/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.net.wifi.WifiNetworkConnectionStatistics;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiConnectionStatistics
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiConnnectionStatistics";
    public HashMap<String, WifiNetworkConnectionStatistics> untrustedNetworkHistory;
    public int num5GhzConnected;
    public int num24GhzConnected;
    public int numAutoJoinAttempt;
    public int numAutoRoamAttempt;
    public int numWifiManagerJoinAttempt;
    public static Parcelable.Creator<WifiConnectionStatistics> CREATOR;

    private void $$robo$$android_net_wifi_WifiConnectionStatistics$__constructor__() {
        this.untrustedNetworkHistory = new HashMap();
    }

    private final void $$robo$$android_net_wifi_WifiConnectionStatistics$incrementOrAddUntrusted(String SSID, int connection, int usage) {
        WifiNetworkConnectionStatistics stats;
        if (TextUtils.isEmpty(SSID)) {
            return;
        }
        if (this.untrustedNetworkHistory.containsKey(SSID)) {
            stats = this.untrustedNetworkHistory.get(SSID);
            if (stats != null) {
                stats.numConnection = connection + stats.numConnection;
                stats.numUsage = usage + stats.numUsage;
            }
        } else {
            stats = new WifiNetworkConnectionStatistics(connection, usage);
        }
        if (stats != null) {
            this.untrustedNetworkHistory.put(SSID, stats);
        }
    }

    private final String $$robo$$android_net_wifi_WifiConnectionStatistics$toString() {
        StringBuilder sbuf = new StringBuilder();
        sbuf.append("Connected on: 2.4Ghz=").append(this.num24GhzConnected);
        sbuf.append(" 5Ghz=").append(this.num5GhzConnected).append("\n");
        sbuf.append(" join=").append(this.numWifiManagerJoinAttempt);
        sbuf.append("\\").append(this.numAutoJoinAttempt).append("\n");
        sbuf.append(" roam=").append(this.numAutoRoamAttempt).append("\n");
        for (String Key2 : this.untrustedNetworkHistory.keySet()) {
            WifiNetworkConnectionStatistics stats = this.untrustedNetworkHistory.get(Key2);
            if (stats == null) continue;
            sbuf.append(Key2).append(" ").append(stats.toString()).append("\n");
        }
        return sbuf.toString();
    }

    private void $$robo$$android_net_wifi_WifiConnectionStatistics$__constructor__(WifiConnectionStatistics source) {
        this.untrustedNetworkHistory = new HashMap();
        if (source != null) {
            this.untrustedNetworkHistory.putAll(source.untrustedNetworkHistory);
        }
    }

    private final int $$robo$$android_net_wifi_WifiConnectionStatistics$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_WifiConnectionStatistics$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.num24GhzConnected);
        dest.writeInt(this.num5GhzConnected);
        dest.writeInt(this.numAutoJoinAttempt);
        dest.writeInt(this.numAutoRoamAttempt);
        dest.writeInt(this.numWifiManagerJoinAttempt);
        dest.writeInt(this.untrustedNetworkHistory.size());
        for (String Key2 : this.untrustedNetworkHistory.keySet()) {
            WifiNetworkConnectionStatistics num = this.untrustedNetworkHistory.get(Key2);
            dest.writeString(Key2);
            dest.writeInt(num.numConnection);
            dest.writeInt(num.numUsage);
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WifiConnectionStatistics>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_WifiConnectionStatistics_1$__constructor__() {
            }

            private final WifiConnectionStatistics $$robo$$android_net_wifi_WifiConnectionStatistics_1$createFromParcel(Parcel in) {
                WifiConnectionStatistics stats = new WifiConnectionStatistics();
                stats.num24GhzConnected = in.readInt();
                stats.num5GhzConnected = in.readInt();
                stats.numAutoJoinAttempt = in.readInt();
                stats.numAutoRoamAttempt = in.readInt();
                stats.numWifiManagerJoinAttempt = in.readInt();
                int n = in.readInt();
                while (n-- > 0) {
                    String Key2 = in.readString();
                    int numConnection = in.readInt();
                    int numUsage = in.readInt();
                    WifiNetworkConnectionStatistics st = new WifiNetworkConnectionStatistics(numConnection, numUsage);
                    stats.untrustedNetworkHistory.put(Key2, st);
                }
                return stats;
            }

            private final WifiConnectionStatistics[] $$robo$$android_net_wifi_WifiConnectionStatistics_1$newArray(int size) {
                return new WifiConnectionStatistics[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_WifiConnectionStatistics_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConnectionStatistics_1$__constructor__(), this);
            }

            @Override
            public WifiConnectionStatistics createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiConnectionStatistics_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public WifiConnectionStatistics[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiConnectionStatistics_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_WifiConnectionStatistics$__constructor__();
    }

    public WifiConnectionStatistics() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConnectionStatistics$__constructor__(), this);
    }

    public void incrementOrAddUntrusted(String string2, int n, int n2) {
        InvokeDynamicSupport.bootstrap("incrementOrAddUntrusted", $$robo$$android_net_wifi_WifiConnectionStatistics$incrementOrAddUntrusted(java.lang.String int int ), this, string2, n, n2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_WifiConnectionStatistics$toString(), this);
    }

    private void __constructor__(WifiConnectionStatistics wifiConnectionStatistics) {
        this.$$robo$$android_net_wifi_WifiConnectionStatistics$__constructor__(wifiConnectionStatistics);
    }

    public WifiConnectionStatistics(WifiConnectionStatistics wifiConnectionStatistics) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiConnectionStatistics$__constructor__(android.net.wifi.WifiConnectionStatistics ), this, wifiConnectionStatistics);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiConnectionStatistics$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiConnectionStatistics$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(WifiConnectionStatistics.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiConnectionStatistics)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

