/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiSsid
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiSsid";
    public ByteArrayOutputStream octets;
    private static int HEX_RADIX = 16;
    public static String NONE = "<unknown ssid>";
    public static Parcelable.Creator<WifiSsid> CREATOR;

    private void $$robo$$android_net_wifi_WifiSsid$__constructor__() {
        this.octets = new ByteArrayOutputStream(32);
    }

    private static final WifiSsid $$robo$$android_net_wifi_WifiSsid$createFromByteArray(byte[] ssid) {
        WifiSsid wifiSsid = new WifiSsid();
        if (ssid != null) {
            wifiSsid.octets.write(ssid, 0, ssid.length);
        }
        return wifiSsid;
    }

    private static final WifiSsid $$robo$$android_net_wifi_WifiSsid$createFromAsciiEncoded(String asciiEncoded) {
        WifiSsid a = new WifiSsid();
        a.convertToBytes(asciiEncoded);
        return a;
    }

    private static final WifiSsid $$robo$$android_net_wifi_WifiSsid$createFromHex(String hexStr) {
        WifiSsid a = new WifiSsid();
        if (hexStr == null) {
            return a;
        }
        if (hexStr.startsWith("0x") || hexStr.startsWith("0X")) {
            hexStr = hexStr.substring(2);
        }
        for (int i = 0; i < hexStr.length() - 1; i += 2) {
            int val;
            try {
                val = Integer.parseInt(hexStr.substring(i, i + 2), 16);
            }
            catch (NumberFormatException e) {
                val = 0;
            }
            a.octets.write(val);
        }
        return a;
    }

    private final void $$robo$$android_net_wifi_WifiSsid$convertToBytes(String asciiEncoded) {
        int i = 0;
        int val = 0;
        block15: while (i < asciiEncoded.length()) {
            char c = asciiEncoded.charAt(i);
            switch (c) {
                case '\\': {
                    switch (asciiEncoded.charAt(++i)) {
                        case '\\': {
                            this.octets.write(92);
                            ++i;
                            break;
                        }
                        case '\"': {
                            this.octets.write(34);
                            ++i;
                            break;
                        }
                        case 'n': {
                            this.octets.write(10);
                            ++i;
                            break;
                        }
                        case 'r': {
                            this.octets.write(13);
                            ++i;
                            break;
                        }
                        case 't': {
                            this.octets.write(9);
                            ++i;
                            break;
                        }
                        case 'e': {
                            this.octets.write(27);
                            ++i;
                            break;
                        }
                        case 'x': {
                            ++i;
                            try {
                                val = Integer.parseInt(asciiEncoded.substring(i, i + 2), 16);
                            }
                            catch (NumberFormatException e) {
                                val = -1;
                            }
                            if (val < 0) {
                                val = Character.digit(asciiEncoded.charAt(i), 16);
                                if (val < 0) break;
                                this.octets.write(val);
                                ++i;
                                break;
                            }
                            this.octets.write(val);
                            i += 2;
                            break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': {
                            val = asciiEncoded.charAt(i) - 48;
                            if (asciiEncoded.charAt(++i) >= '0' && asciiEncoded.charAt(i) <= '7') {
                                val = val * 8 + asciiEncoded.charAt(i) - 48;
                                ++i;
                            }
                            if (asciiEncoded.charAt(i) >= '0' && asciiEncoded.charAt(i) <= '7') {
                                val = val * 8 + asciiEncoded.charAt(i) - 48;
                                ++i;
                            }
                            this.octets.write(val);
                            break;
                        }
                    }
                    continue block15;
                }
                default: {
                    this.octets.write(c);
                    ++i;
                }
            }
        }
    }

    private final String $$robo$$android_net_wifi_WifiSsid$toString() {
        byte[] ssidBytes = this.octets.toByteArray();
        if (this.octets.size() <= 0 || this.isArrayAllZeroes(ssidBytes)) {
            return "";
        }
        Charset charset = Charset.forName("UTF-8");
        CharsetDecoder decoder = charset.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        CharBuffer out = CharBuffer.allocate(32);
        CoderResult result = decoder.decode(ByteBuffer.wrap(ssidBytes), out, true);
        out.flip();
        if (result.isError()) {
            return "<unknown ssid>";
        }
        return out.toString();
    }

    private final boolean $$robo$$android_net_wifi_WifiSsid$isArrayAllZeroes(byte[] ssidBytes) {
        for (int i = 0; i < ssidBytes.length; ++i) {
            if (ssidBytes[i] == 0) continue;
            return false;
        }
        return true;
    }

    private final boolean $$robo$$android_net_wifi_WifiSsid$isHidden() {
        return this.isArrayAllZeroes(this.octets.toByteArray());
    }

    private final byte[] $$robo$$android_net_wifi_WifiSsid$getOctets() {
        return this.octets.toByteArray();
    }

    private final String $$robo$$android_net_wifi_WifiSsid$getHexString() {
        String out = "0x";
        byte[] ssidbytes = this.getOctets();
        for (int i = 0; i < this.octets.size(); ++i) {
            out = out + String.format(Locale.US, "%02x", ssidbytes[i]);
        }
        return this.octets.size() > 0 ? out : null;
    }

    private final int $$robo$$android_net_wifi_WifiSsid$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_WifiSsid$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.octets.size());
        dest.writeByteArray(this.octets.toByteArray());
    }

    private /* synthetic */ void $$robo$$android_net_wifi_WifiSsid$__constructor__(1 x0) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WifiSsid>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_WifiSsid_1$__constructor__() {
            }

            private final WifiSsid $$robo$$android_net_wifi_WifiSsid_1$createFromParcel(Parcel in) {
                WifiSsid ssid = new WifiSsid(null);
                int length = in.readInt();
                byte[] b = new byte[length];
                in.readByteArray(b);
                ssid.octets.write(b, 0, length);
                return ssid;
            }

            private final WifiSsid[] $$robo$$android_net_wifi_WifiSsid_1$newArray(int size) {
                return new WifiSsid[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_WifiSsid_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiSsid_1$__constructor__(), this);
            }

            @Override
            public WifiSsid createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_WifiSsid_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public WifiSsid[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_WifiSsid_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_WifiSsid$__constructor__();
    }

    public WifiSsid() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiSsid$__constructor__(), this);
    }

    public static WifiSsid createFromByteArray(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromByteArray", $$robo$$android_net_wifi_WifiSsid$createFromByteArray(byte[] ), (byte[])byArray);
    }

    public static WifiSsid createFromAsciiEncoded(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromAsciiEncoded", $$robo$$android_net_wifi_WifiSsid$createFromAsciiEncoded(java.lang.String ), (String)string2);
    }

    public static WifiSsid createFromHex(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromHex", $$robo$$android_net_wifi_WifiSsid$createFromHex(java.lang.String ), (String)string2);
    }

    private void convertToBytes(String string2) {
        InvokeDynamicSupport.bootstrap("convertToBytes", $$robo$$android_net_wifi_WifiSsid$convertToBytes(java.lang.String ), this, string2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_WifiSsid$toString(), this);
    }

    private boolean isArrayAllZeroes(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("isArrayAllZeroes", $$robo$$android_net_wifi_WifiSsid$isArrayAllZeroes(byte[] ), this, byArray);
    }

    public boolean isHidden() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHidden", $$robo$$android_net_wifi_WifiSsid$isHidden(), this);
    }

    public byte[] getOctets() {
        return InvokeDynamicSupport.bootstrap("getOctets", $$robo$$android_net_wifi_WifiSsid$getOctets(), this);
    }

    public String getHexString() {
        return InvokeDynamicSupport.bootstrap("getHexString", $$robo$$android_net_wifi_WifiSsid$getHexString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_WifiSsid$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_WifiSsid$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_net_wifi_WifiSsid$__constructor__(var1_1);
    }

    public /* synthetic */ WifiSsid(1 var1_1) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiSsid$__constructor__(android.net.wifi.WifiSsid$1 ), this, var1_1);
    }

    static {
        RobolectricInternals.classInitializing(WifiSsid.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiSsid)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

