/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.net.NetworkSpecifier;
import android.net.wifi.aware.DiscoverySessionCallback;
import android.net.wifi.aware.PublishConfig;
import android.net.wifi.aware.SubscribeConfig;
import android.net.wifi.aware.WifiAwareManager;
import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiAwareSession
implements AutoCloseable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiAwareSession";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    private WeakReference<WifiAwareManager> mMgr;
    private Binder mBinder;
    private int mClientId;
    private boolean mTerminated;
    private CloseGuard mCloseGuard;

    private void $$robo$$android_net_wifi_aware_WifiAwareSession$__constructor__(WifiAwareManager manager, Binder binder, int clientId) {
        this.mTerminated = true;
        this.mCloseGuard = CloseGuard.get();
        this.mMgr = new WeakReference<WifiAwareManager>(manager);
        this.mBinder = binder;
        this.mClientId = clientId;
        this.mTerminated = false;
        this.mCloseGuard.open("destroy");
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareSession$close() {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.w("WifiAwareSession", "destroy: called post GC on WifiAwareManager");
            return;
        }
        mgr.disconnect(this.mClientId, this.mBinder);
        this.mTerminated = true;
        this.mMgr.clear();
        this.mCloseGuard.close();
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareSession$finalize() throws Throwable {
        try {
            if (!this.mTerminated) {
                this.mCloseGuard.warnIfOpen();
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareSession$publish(PublishConfig publishConfig, DiscoverySessionCallback callback, Handler handler) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e("WifiAwareSession", "publish: called post GC on WifiAwareManager");
            return;
        }
        if (this.mTerminated) {
            Log.e("WifiAwareSession", "publish: called after termination");
            return;
        }
        mgr.publish(this.mClientId, handler == null ? Looper.getMainLooper() : handler.getLooper(), publishConfig, callback);
    }

    private final void $$robo$$android_net_wifi_aware_WifiAwareSession$subscribe(SubscribeConfig subscribeConfig, DiscoverySessionCallback callback, Handler handler) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e("WifiAwareSession", "publish: called post GC on WifiAwareManager");
            return;
        }
        if (this.mTerminated) {
            Log.e("WifiAwareSession", "publish: called after termination");
            return;
        }
        mgr.subscribe(this.mClientId, handler == null ? Looper.getMainLooper() : handler.getLooper(), subscribeConfig, callback);
    }

    private final NetworkSpecifier $$robo$$android_net_wifi_aware_WifiAwareSession$createNetworkSpecifierOpen(int role, byte[] peer) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e("WifiAwareSession", "createNetworkSpecifierOpen: called post GC on WifiAwareManager");
            return null;
        }
        if (this.mTerminated) {
            Log.e("WifiAwareSession", "createNetworkSpecifierOpen: called after termination");
            return null;
        }
        return mgr.createNetworkSpecifier(this.mClientId, role, peer, null, null);
    }

    private final NetworkSpecifier $$robo$$android_net_wifi_aware_WifiAwareSession$createNetworkSpecifierPassphrase(int role, byte[] peer, String passphrase) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e("WifiAwareSession", "createNetworkSpecifierPassphrase: called post GC on WifiAwareManager");
            return null;
        }
        if (this.mTerminated) {
            Log.e("WifiAwareSession", "createNetworkSpecifierPassphrase: called after termination");
            return null;
        }
        if (passphrase == null || passphrase.length() == 0) {
            throw new IllegalArgumentException("Passphrase must not be null or empty");
        }
        return mgr.createNetworkSpecifier(this.mClientId, role, peer, null, passphrase);
    }

    private final NetworkSpecifier $$robo$$android_net_wifi_aware_WifiAwareSession$createNetworkSpecifierPmk(int role, byte[] peer, byte[] pmk) {
        WifiAwareManager mgr = (WifiAwareManager)this.mMgr.get();
        if (mgr == null) {
            Log.e("WifiAwareSession", "createNetworkSpecifierPmk: called post GC on WifiAwareManager");
            return null;
        }
        if (this.mTerminated) {
            Log.e("WifiAwareSession", "createNetworkSpecifierPmk: called after termination");
            return null;
        }
        if (pmk == null || pmk.length == 0) {
            throw new IllegalArgumentException("PMK must not be null or empty");
        }
        return mgr.createNetworkSpecifier(this.mClientId, role, peer, pmk, null);
    }

    private void __constructor__(WifiAwareManager wifiAwareManager, Binder binder, int n) {
        this.$$robo$$android_net_wifi_aware_WifiAwareSession$__constructor__(wifiAwareManager, binder, n);
    }

    public WifiAwareSession(WifiAwareManager wifiAwareManager, Binder binder, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_WifiAwareSession$__constructor__(android.net.wifi.aware.WifiAwareManager android.os.Binder int ), this, wifiAwareManager, binder, n);
    }

    @Override
    public void close() {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_net_wifi_aware_WifiAwareSession$close(), this);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_net_wifi_aware_WifiAwareSession$finalize(), this);
    }

    public void publish(PublishConfig publishConfig, DiscoverySessionCallback discoverySessionCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("publish", $$robo$$android_net_wifi_aware_WifiAwareSession$publish(android.net.wifi.aware.PublishConfig android.net.wifi.aware.DiscoverySessionCallback android.os.Handler ), this, publishConfig, discoverySessionCallback, handler);
    }

    public void subscribe(SubscribeConfig subscribeConfig, DiscoverySessionCallback discoverySessionCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("subscribe", $$robo$$android_net_wifi_aware_WifiAwareSession$subscribe(android.net.wifi.aware.SubscribeConfig android.net.wifi.aware.DiscoverySessionCallback android.os.Handler ), this, subscribeConfig, discoverySessionCallback, handler);
    }

    public NetworkSpecifier createNetworkSpecifierOpen(int n, byte[] byArray) {
        return InvokeDynamicSupport.bootstrap("createNetworkSpecifierOpen", $$robo$$android_net_wifi_aware_WifiAwareSession$createNetworkSpecifierOpen(int byte[] ), this, n, byArray);
    }

    public NetworkSpecifier createNetworkSpecifierPassphrase(int n, byte[] byArray, String string2) {
        return InvokeDynamicSupport.bootstrap("createNetworkSpecifierPassphrase", $$robo$$android_net_wifi_aware_WifiAwareSession$createNetworkSpecifierPassphrase(int byte[] java.lang.String ), this, n, byArray, string2);
    }

    public NetworkSpecifier createNetworkSpecifierPmk(int n, byte[] byArray, byte[] byArray2) {
        return InvokeDynamicSupport.bootstrap("createNetworkSpecifierPmk", $$robo$$android_net_wifi_aware_WifiAwareSession$createNetworkSpecifierPmk(int byte[] byte[] ), this, n, byArray, byArray2);
    }

    public /* synthetic */ WifiAwareSession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiAwareSession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

