/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.p2p.nsd;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiP2pServiceRequest
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int mProtocolType;
    private int mLength;
    private int mTransId;
    private String mQuery;
    public static Parcelable.Creator<WifiP2pServiceRequest> CREATOR;

    private void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$__constructor__(int protocolType, String query) {
        this.validateQuery(query);
        this.mProtocolType = protocolType;
        this.mQuery = query;
        this.mLength = query != null ? query.length() / 2 + 2 : 2;
    }

    private void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$__constructor__(int serviceType, int length, int transId, String query) {
        this.mProtocolType = serviceType;
        this.mLength = length;
        this.mTransId = transId;
        this.mQuery = query;
    }

    private final int $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$getTransactionId() {
        return this.mTransId;
    }

    private final void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$setTransactionId(int id2) {
        this.mTransId = id2;
    }

    private final String $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$getSupplicantQuery() {
        StringBuffer sb = new StringBuffer();
        sb.append(String.format(Locale.US, "%02x", this.mLength & 0xFF));
        sb.append(String.format(Locale.US, "%02x", this.mLength >> 8 & 0xFF));
        sb.append(String.format(Locale.US, "%02x", this.mProtocolType));
        sb.append(String.format(Locale.US, "%02x", this.mTransId));
        if (this.mQuery != null) {
            sb.append(this.mQuery);
        }
        return sb.toString();
    }

    private final void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$validateQuery(String query) {
        char[] chars;
        if (query == null) {
            return;
        }
        int UNSIGNED_SHORT_MAX = 65535;
        if (query.length() % 2 == 1) {
            throw new IllegalArgumentException("query size is invalid. query=" + query);
        }
        if (query.length() / 2 > UNSIGNED_SHORT_MAX) {
            throw new IllegalArgumentException("query size is too large. len=" + query.length());
        }
        query = query.toLowerCase(Locale.ROOT);
        for (char c : chars = query.toCharArray()) {
            if (c >= '0' && c <= '9' || c >= 'a' && c <= 'f') continue;
            throw new IllegalArgumentException("query should be hex string. query=" + query);
        }
    }

    private static final WifiP2pServiceRequest $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$newInstance(int protocolType, String queryData) {
        return new WifiP2pServiceRequest(protocolType, queryData);
    }

    private static final WifiP2pServiceRequest $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$newInstance(int protocolType) {
        return new WifiP2pServiceRequest(protocolType, null);
    }

    private final boolean $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WifiP2pServiceRequest)) {
            return false;
        }
        WifiP2pServiceRequest req = (WifiP2pServiceRequest)o;
        if (req.mProtocolType != this.mProtocolType || req.mLength != this.mLength) {
            return false;
        }
        if (req.mQuery == null && this.mQuery == null) {
            return true;
        }
        if (req.mQuery != null) {
            return req.mQuery.equals(this.mQuery);
        }
        return false;
    }

    private final int $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$hashCode() {
        int result = 17;
        result = 31 * result + this.mProtocolType;
        result = 31 * result + this.mLength;
        result = 31 * result + (this.mQuery == null ? 0 : this.mQuery.hashCode());
        return result;
    }

    private final int $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mProtocolType);
        dest.writeInt(this.mLength);
        dest.writeInt(this.mTransId);
        dest.writeString(this.mQuery);
    }

    private /* synthetic */ void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$__constructor__(int x0, int x1, int x2, String x3, 1 x4) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<WifiP2pServiceRequest>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest_1$__constructor__() {
            }

            private final WifiP2pServiceRequest $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest_1$createFromParcel(Parcel in) {
                int servType = in.readInt();
                int length = in.readInt();
                int transId = in.readInt();
                String query = in.readString();
                return new WifiP2pServiceRequest(servType, length, transId, query, null);
            }

            private final WifiP2pServiceRequest[] $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest_1$newArray(int size) {
                return new WifiP2pServiceRequest[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest_1$__constructor__(), this);
            }

            @Override
            public WifiP2pServiceRequest createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public WifiP2pServiceRequest[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, String string2) {
        this.$$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$__constructor__(n, string2);
    }

    public WifiP2pServiceRequest(int n, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$__constructor__(int java.lang.String ), this, n, string2);
    }

    private void __constructor__(int n, int n2, int n3, String string2) {
        this.$$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$__constructor__(n, n2, n3, string2);
    }

    public WifiP2pServiceRequest(int n, int n2, int n3, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$__constructor__(int int int java.lang.String ), this, n, n2, n3, string2);
    }

    public int getTransactionId() {
        return (int)InvokeDynamicSupport.bootstrap("getTransactionId", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$getTransactionId(), this);
    }

    public void setTransactionId(int n) {
        InvokeDynamicSupport.bootstrap("setTransactionId", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$setTransactionId(int ), this, n);
    }

    public String getSupplicantQuery() {
        return InvokeDynamicSupport.bootstrap("getSupplicantQuery", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$getSupplicantQuery(), this);
    }

    private void validateQuery(String string2) {
        InvokeDynamicSupport.bootstrap("validateQuery", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$validateQuery(java.lang.String ), this, string2);
    }

    public static WifiP2pServiceRequest newInstance(int n, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$newInstance(int java.lang.String ), (int)n, (String)string2);
    }

    public static WifiP2pServiceRequest newInstance(int n) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$newInstance(int ), (int)n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$equals(java.lang.Object ), this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$hashCode(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private /* synthetic */ void __constructor__(int n, int n2, int n3, String string2, 1 var5_5) {
        this.$$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$__constructor__(n, n2, n3, string2, var5_5);
    }

    public /* synthetic */ WifiP2pServiceRequest(int n, int n2, int n3, String string2, 1 var5_5) {
        this(n, n2, n3, string2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_p2p_nsd_WifiP2pServiceRequest$__constructor__(int int int java.lang.String android.net.wifi.p2p.nsd.WifiP2pServiceRequest$1 ), this, n, n2, n3, string2, var5_5);
    }

    static {
        RobolectricInternals.classInitializing(WifiP2pServiceRequest.class);
    }

    public /* synthetic */ WifiP2pServiceRequest() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiP2pServiceRequest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

