/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.app.Activity;
import android.app.Application;
import android.content.ContentProvider;
import android.net.Uri;
import android.nfc.BeamShareData;
import android.nfc.IAppCallback;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import android.nfc.NfcEvent;
import android.nfc.Tag;
import android.os.Binder;
import android.os.Bundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NfcActivityManager
extends IAppCallback.Stub
implements Application.ActivityLifecycleCallbacks,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "NFC";
    static Boolean DBG;
    NfcAdapter mAdapter;
    List<NfcApplicationState> mApps;
    List<NfcActivityState> mActivities;

    private final NfcApplicationState $$robo$$android_nfc_NfcActivityManager$findAppState(Application app) {
        for (NfcApplicationState appState : this.mApps) {
            if (appState.app != app) continue;
            return appState;
        }
        return null;
    }

    private final void $$robo$$android_nfc_NfcActivityManager$registerApplication(Application app) {
        NfcApplicationState appState = this.findAppState(app);
        if (appState == null) {
            appState = new NfcApplicationState(this, app);
            this.mApps.add(appState);
        }
        appState.register();
    }

    private final void $$robo$$android_nfc_NfcActivityManager$unregisterApplication(Application app) {
        NfcApplicationState appState = this.findAppState(app);
        if (appState == null) {
            Log.e("NFC", "app was not registered " + app);
            return;
        }
        appState.unregister();
    }

    private final synchronized NfcActivityState $$robo$$android_nfc_NfcActivityManager$findActivityState(Activity activity) {
        for (NfcActivityState state : this.mActivities) {
            if (state.activity != activity) continue;
            return state;
        }
        return null;
    }

    private final synchronized NfcActivityState $$robo$$android_nfc_NfcActivityManager$getActivityState(Activity activity) {
        NfcActivityState state = this.findActivityState(activity);
        if (state == null) {
            state = new NfcActivityState(this, activity);
            this.mActivities.add(state);
        }
        return state;
    }

    private final synchronized NfcActivityState $$robo$$android_nfc_NfcActivityManager$findResumedActivityState() {
        for (NfcActivityState state : this.mActivities) {
            if (!state.resumed) continue;
            return state;
        }
        return null;
    }

    private final synchronized void $$robo$$android_nfc_NfcActivityManager$destroyActivityState(Activity activity) {
        NfcActivityState activityState = this.findActivityState(activity);
        if (activityState != null) {
            activityState.destroy();
            this.mActivities.remove(activityState);
        }
    }

    private void $$robo$$android_nfc_NfcActivityManager$__constructor__(NfcAdapter adapter) {
        this.mAdapter = adapter;
        this.mActivities = new LinkedList<NfcActivityState>();
        this.mApps = new ArrayList<NfcApplicationState>(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$enableReaderMode(Activity activity, NfcAdapter.ReaderCallback callback, int flags, Bundle extras) {
        boolean isResumed;
        Binder token;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.readerCallback = callback;
            state.readerModeFlags = flags;
            state.readerModeExtras = extras;
            token = state.token;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.setReaderMode(token, flags, extras);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$disableReaderMode(Activity activity) {
        boolean isResumed;
        Binder token;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.readerCallback = null;
            state.readerModeFlags = 0;
            state.readerModeExtras = null;
            token = state.token;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.setReaderMode(token, 0, null);
        }
    }

    private final void $$robo$$android_nfc_NfcActivityManager$setReaderMode(Binder token, int flags, Bundle extras) {
        if (DBG.booleanValue()) {
            Log.d("NFC", "Setting reader mode");
        }
        try {
            NfcAdapter.sService.setReaderMode(token, this, flags, extras);
        }
        catch (RemoteException e) {
            this.mAdapter.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$setNdefPushContentUri(Activity activity, Uri[] uris) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.uris = uris;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback();
        } else {
            this.verifyNfcPermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$setNdefPushContentUriCallback(Activity activity, NfcAdapter.CreateBeamUrisCallback callback) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.uriCallback = callback;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback();
        } else {
            this.verifyNfcPermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$setNdefPushMessage(Activity activity, NdefMessage message, int flags) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.ndefMessage = message;
            state.flags = flags;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback();
        } else {
            this.verifyNfcPermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$setNdefPushMessageCallback(Activity activity, NfcAdapter.CreateNdefMessageCallback callback, int flags) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.ndefMessageCallback = callback;
            state.flags = flags;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback();
        } else {
            this.verifyNfcPermission();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$setOnNdefPushCompleteCallback(Activity activity, NfcAdapter.OnNdefPushCompleteCallback callback) {
        boolean isResumed;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.getActivityState(activity);
            state.onNdefPushCompleteCallback = callback;
            isResumed = state.resumed;
        }
        if (isResumed) {
            this.requestNfcServiceCallback();
        } else {
            this.verifyNfcPermission();
        }
    }

    private final void $$robo$$android_nfc_NfcActivityManager$requestNfcServiceCallback() {
        try {
            NfcAdapter.sService.setAppCallback(this);
        }
        catch (RemoteException e) {
            this.mAdapter.attemptDeadServiceRecovery(e);
        }
    }

    private final void $$robo$$android_nfc_NfcActivityManager$verifyNfcPermission() {
        try {
            NfcAdapter.sService.verifyNfcPermission();
        }
        catch (RemoteException e) {
            this.mAdapter.attemptDeadServiceRecovery(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final BeamShareData $$robo$$android_nfc_NfcActivityManager$createBeamShareData(byte peerLlcpVersion) {
        Activity activity;
        int flags;
        Uri[] uris;
        NdefMessage message;
        NfcAdapter.CreateBeamUrisCallback urisCallback;
        NfcAdapter.CreateNdefMessageCallback ndefCallback;
        NfcEvent event = new NfcEvent(this.mAdapter, peerLlcpVersion);
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findResumedActivityState();
            if (state == null) {
                return null;
            }
            ndefCallback = state.ndefMessageCallback;
            urisCallback = state.uriCallback;
            message = state.ndefMessage;
            uris = state.uris;
            flags = state.flags;
            activity = state.activity;
        }
        long ident = Binder.clearCallingIdentity();
        try {
            if (ndefCallback != null) {
                message = ndefCallback.createNdefMessage(event);
            }
            if (urisCallback != null && (uris = urisCallback.createBeamUris(event)) != null) {
                ArrayList<Uri> validUris = new ArrayList<Uri>();
                Uri[] uriArray = uris;
                int n = uriArray.length;
                for (int i = 0; i < n; ++i) {
                    Uri uri = uriArray[i];
                    if (uri == null) {
                        Log.e("NFC", "Uri not allowed to be null.");
                        continue;
                    }
                    String scheme = uri.getScheme();
                    if (scheme == null || !scheme.equalsIgnoreCase("file") && !scheme.equalsIgnoreCase("content")) {
                        Log.e("NFC", "Uri needs to have either scheme file or scheme content");
                        continue;
                    }
                    uri = ContentProvider.maybeAddUserId(uri, UserHandle.myUserId());
                    validUris.add(uri);
                }
                uris = validUris.toArray(new Uri[validUris.size()]);
            }
            if (uris != null && uris.length > 0) {
                for (Uri uri : uris) {
                    activity.grantUriPermission("com.android.nfc", uri, 1);
                }
            }
        }
        finally {
            Binder.restoreCallingIdentity(ident);
        }
        return new BeamShareData(message, uris, new UserHandle(UserHandle.myUserId()), flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$onNdefPushComplete(byte peerLlcpVersion) {
        NfcAdapter.OnNdefPushCompleteCallback callback;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findResumedActivityState();
            if (state == null) {
                return;
            }
            callback = state.onNdefPushCompleteCallback;
        }
        NfcEvent event = new NfcEvent(this.mAdapter, peerLlcpVersion);
        if (callback != null) {
            callback.onNdefPushComplete(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$onTagDiscovered(Tag tag) throws RemoteException {
        NfcAdapter.ReaderCallback callback;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findResumedActivityState();
            if (state == null) {
                return;
            }
            callback = state.readerCallback;
        }
        if (callback != null) {
            callback.onTagDiscovered(tag);
        }
    }

    private final void $$robo$$android_nfc_NfcActivityManager$onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    private final void $$robo$$android_nfc_NfcActivityManager$onActivityStarted(Activity activity) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$onActivityResumed(Activity activity) {
        Binder token;
        int readerModeFlags = 0;
        Bundle readerModeExtras = null;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d("NFC", "onResume() for " + activity + " " + state);
            }
            if (state == null) {
                return;
            }
            state.resumed = true;
            token = state.token;
            readerModeFlags = state.readerModeFlags;
            readerModeExtras = state.readerModeExtras;
        }
        if (readerModeFlags != 0) {
            this.setReaderMode(token, readerModeFlags, readerModeExtras);
        }
        this.requestNfcServiceCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$onActivityPaused(Activity activity) {
        boolean readerModeFlagsSet;
        Binder token;
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d("NFC", "onPause() for " + activity + " " + state);
            }
            if (state == null) {
                return;
            }
            state.resumed = false;
            token = state.token;
            readerModeFlagsSet = state.readerModeFlags != 0;
        }
        if (readerModeFlagsSet) {
            this.setReaderMode(token, 0, null);
        }
    }

    private final void $$robo$$android_nfc_NfcActivityManager$onActivityStopped(Activity activity) {
    }

    private final void $$robo$$android_nfc_NfcActivityManager$onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_nfc_NfcActivityManager$onActivityDestroyed(Activity activity) {
        NfcActivityManager nfcActivityManager = this;
        synchronized (nfcActivityManager) {
            NfcActivityState state = this.findActivityState(activity);
            if (DBG.booleanValue()) {
                Log.d("NFC", "onDestroy() for " + activity + " " + state);
            }
            if (state != null) {
                this.destroyActivityState(activity);
            }
        }
    }

    static void __staticInitializer__() {
        DBG = false;
    }

    NfcApplicationState findAppState(Application application) {
        return InvokeDynamicSupport.bootstrap("findAppState", $$robo$$android_nfc_NfcActivityManager$findAppState(android.app.Application ), this, application);
    }

    void registerApplication(Application application) {
        InvokeDynamicSupport.bootstrap("registerApplication", $$robo$$android_nfc_NfcActivityManager$registerApplication(android.app.Application ), this, application);
    }

    void unregisterApplication(Application application) {
        InvokeDynamicSupport.bootstrap("unregisterApplication", $$robo$$android_nfc_NfcActivityManager$unregisterApplication(android.app.Application ), this, application);
    }

    synchronized NfcActivityState findActivityState(Activity activity) {
        return InvokeDynamicSupport.bootstrap("findActivityState", $$robo$$android_nfc_NfcActivityManager$findActivityState(android.app.Activity ), this, activity);
    }

    synchronized NfcActivityState getActivityState(Activity activity) {
        return InvokeDynamicSupport.bootstrap("getActivityState", $$robo$$android_nfc_NfcActivityManager$getActivityState(android.app.Activity ), this, activity);
    }

    synchronized NfcActivityState findResumedActivityState() {
        return InvokeDynamicSupport.bootstrap("findResumedActivityState", $$robo$$android_nfc_NfcActivityManager$findResumedActivityState(), this);
    }

    synchronized void destroyActivityState(Activity activity) {
        InvokeDynamicSupport.bootstrap("destroyActivityState", $$robo$$android_nfc_NfcActivityManager$destroyActivityState(android.app.Activity ), this, activity);
    }

    private void __constructor__(NfcAdapter nfcAdapter) {
        this.$$robo$$android_nfc_NfcActivityManager$__constructor__(nfcAdapter);
    }

    public NfcActivityManager(NfcAdapter nfcAdapter) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NfcActivityManager$__constructor__(android.nfc.NfcAdapter ), this, nfcAdapter);
    }

    public void enableReaderMode(Activity activity, NfcAdapter.ReaderCallback readerCallback, int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("enableReaderMode", $$robo$$android_nfc_NfcActivityManager$enableReaderMode(android.app.Activity android.nfc.NfcAdapter$ReaderCallback int android.os.Bundle ), this, activity, readerCallback, n, bundle);
    }

    public void disableReaderMode(Activity activity) {
        InvokeDynamicSupport.bootstrap("disableReaderMode", $$robo$$android_nfc_NfcActivityManager$disableReaderMode(android.app.Activity ), this, activity);
    }

    public void setReaderMode(Binder binder, int n, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("setReaderMode", $$robo$$android_nfc_NfcActivityManager$setReaderMode(android.os.Binder int android.os.Bundle ), this, binder, n, bundle);
    }

    public void setNdefPushContentUri(Activity activity, Uri[] uriArray) {
        InvokeDynamicSupport.bootstrap("setNdefPushContentUri", $$robo$$android_nfc_NfcActivityManager$setNdefPushContentUri(android.app.Activity android.net.Uri[] ), this, activity, uriArray);
    }

    public void setNdefPushContentUriCallback(Activity activity, NfcAdapter.CreateBeamUrisCallback createBeamUrisCallback) {
        InvokeDynamicSupport.bootstrap("setNdefPushContentUriCallback", $$robo$$android_nfc_NfcActivityManager$setNdefPushContentUriCallback(android.app.Activity android.nfc.NfcAdapter$CreateBeamUrisCallback ), this, activity, createBeamUrisCallback);
    }

    public void setNdefPushMessage(Activity activity, NdefMessage ndefMessage, int n) {
        InvokeDynamicSupport.bootstrap("setNdefPushMessage", $$robo$$android_nfc_NfcActivityManager$setNdefPushMessage(android.app.Activity android.nfc.NdefMessage int ), this, activity, ndefMessage, n);
    }

    public void setNdefPushMessageCallback(Activity activity, NfcAdapter.CreateNdefMessageCallback createNdefMessageCallback, int n) {
        InvokeDynamicSupport.bootstrap("setNdefPushMessageCallback", $$robo$$android_nfc_NfcActivityManager$setNdefPushMessageCallback(android.app.Activity android.nfc.NfcAdapter$CreateNdefMessageCallback int ), this, activity, createNdefMessageCallback, n);
    }

    public void setOnNdefPushCompleteCallback(Activity activity, NfcAdapter.OnNdefPushCompleteCallback onNdefPushCompleteCallback) {
        InvokeDynamicSupport.bootstrap("setOnNdefPushCompleteCallback", $$robo$$android_nfc_NfcActivityManager$setOnNdefPushCompleteCallback(android.app.Activity android.nfc.NfcAdapter$OnNdefPushCompleteCallback ), this, activity, onNdefPushCompleteCallback);
    }

    void requestNfcServiceCallback() {
        InvokeDynamicSupport.bootstrap("requestNfcServiceCallback", $$robo$$android_nfc_NfcActivityManager$requestNfcServiceCallback(), this);
    }

    void verifyNfcPermission() {
        InvokeDynamicSupport.bootstrap("verifyNfcPermission", $$robo$$android_nfc_NfcActivityManager$verifyNfcPermission(), this);
    }

    @Override
    public BeamShareData createBeamShareData(byte by) {
        return InvokeDynamicSupport.bootstrap("createBeamShareData", $$robo$$android_nfc_NfcActivityManager$createBeamShareData(byte ), this, by);
    }

    @Override
    public void onNdefPushComplete(byte by) {
        InvokeDynamicSupport.bootstrap("onNdefPushComplete", $$robo$$android_nfc_NfcActivityManager$onNdefPushComplete(byte ), this, by);
    }

    @Override
    public void onTagDiscovered(Tag tag) throws RemoteException {
        InvokeDynamicSupport.bootstrap("onTagDiscovered", $$robo$$android_nfc_NfcActivityManager$onTagDiscovered(android.nfc.Tag ), this, tag);
    }

    @Override
    public void onActivityCreated(Activity activity, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onActivityCreated", $$robo$$android_nfc_NfcActivityManager$onActivityCreated(android.app.Activity android.os.Bundle ), this, activity, bundle);
    }

    @Override
    public void onActivityStarted(Activity activity) {
        InvokeDynamicSupport.bootstrap("onActivityStarted", $$robo$$android_nfc_NfcActivityManager$onActivityStarted(android.app.Activity ), this, activity);
    }

    @Override
    public void onActivityResumed(Activity activity) {
        InvokeDynamicSupport.bootstrap("onActivityResumed", $$robo$$android_nfc_NfcActivityManager$onActivityResumed(android.app.Activity ), this, activity);
    }

    @Override
    public void onActivityPaused(Activity activity) {
        InvokeDynamicSupport.bootstrap("onActivityPaused", $$robo$$android_nfc_NfcActivityManager$onActivityPaused(android.app.Activity ), this, activity);
    }

    @Override
    public void onActivityStopped(Activity activity) {
        InvokeDynamicSupport.bootstrap("onActivityStopped", $$robo$$android_nfc_NfcActivityManager$onActivityStopped(android.app.Activity ), this, activity);
    }

    @Override
    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onActivitySaveInstanceState", $$robo$$android_nfc_NfcActivityManager$onActivitySaveInstanceState(android.app.Activity android.os.Bundle ), this, activity, bundle);
    }

    @Override
    public void onActivityDestroyed(Activity activity) {
        InvokeDynamicSupport.bootstrap("onActivityDestroyed", $$robo$$android_nfc_NfcActivityManager$onActivityDestroyed(android.app.Activity ), this, activity);
    }

    static {
        RobolectricInternals.classInitializing(NfcActivityManager.class);
    }

    public /* synthetic */ NfcActivityManager() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NfcActivityManager)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class NfcActivityState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        boolean resumed;
        Activity activity;
        NdefMessage ndefMessage;
        NfcAdapter.CreateNdefMessageCallback ndefMessageCallback;
        NfcAdapter.OnNdefPushCompleteCallback onNdefPushCompleteCallback;
        NfcAdapter.CreateBeamUrisCallback uriCallback;
        Uri[] uris;
        int flags;
        int readerModeFlags;
        NfcAdapter.ReaderCallback readerCallback;
        Bundle readerModeExtras;
        Binder token;
        /* synthetic */ NfcActivityManager this$0;

        private void $$robo$$android_nfc_NfcActivityManager_NfcActivityState$__constructor__(NfcActivityManager this$0, Activity activity) {
            this.resumed = false;
            this.ndefMessage = null;
            this.ndefMessageCallback = null;
            this.onNdefPushCompleteCallback = null;
            this.uriCallback = null;
            this.uris = null;
            this.flags = 0;
            this.readerModeFlags = 0;
            this.readerCallback = null;
            this.readerModeExtras = null;
            if (activity.getWindow().isDestroyed()) {
                throw new IllegalStateException("activity is already destroyed");
            }
            this.resumed = activity.isResumed();
            this.activity = activity;
            this.token = new Binder();
            this$0.registerApplication(activity.getApplication());
        }

        private final void $$robo$$android_nfc_NfcActivityManager_NfcActivityState$destroy() {
            this.this$0.unregisterApplication(this.activity.getApplication());
            this.resumed = false;
            this.activity = null;
            this.ndefMessage = null;
            this.ndefMessageCallback = null;
            this.onNdefPushCompleteCallback = null;
            this.uriCallback = null;
            this.uris = null;
            this.readerModeFlags = 0;
            this.token = null;
        }

        private final String $$robo$$android_nfc_NfcActivityManager_NfcActivityState$toString() {
            StringBuilder s = new StringBuilder("[").append(" ");
            s.append(this.ndefMessage).append(" ").append(this.ndefMessageCallback).append(" ");
            s.append(this.uriCallback).append(" ");
            if (this.uris != null) {
                for (Uri uri : this.uris) {
                    s.append(this.onNdefPushCompleteCallback).append(" ").append(uri).append("]");
                }
            }
            return s.toString();
        }

        private void __constructor__(NfcActivityManager nfcActivityManager, Activity activity) {
            this.$$robo$$android_nfc_NfcActivityManager_NfcActivityState$__constructor__(nfcActivityManager, activity);
        }

        public NfcActivityState(NfcActivityManager nfcActivityManager, Activity activity) {
            this.this$0 = nfcActivityManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NfcActivityManager_NfcActivityState$__constructor__(android.nfc.NfcActivityManager android.app.Activity ), this, nfcActivityManager, activity);
        }

        public void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_nfc_NfcActivityManager_NfcActivityState$destroy(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_nfc_NfcActivityManager_NfcActivityState$toString(), this);
        }

        public /* synthetic */ NfcActivityState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NfcActivityState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class NfcApplicationState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int refCount;
        Application app;
        /* synthetic */ NfcActivityManager this$0;

        private void $$robo$$android_nfc_NfcActivityManager_NfcApplicationState$__constructor__(NfcActivityManager this$0, Application app) {
            this.refCount = 0;
            this.app = app;
        }

        private final void $$robo$$android_nfc_NfcActivityManager_NfcApplicationState$register() {
            ++this.refCount;
            if (this.refCount == 1) {
                this.app.registerActivityLifecycleCallbacks(this.this$0);
            }
        }

        private final void $$robo$$android_nfc_NfcActivityManager_NfcApplicationState$unregister() {
            --this.refCount;
            if (this.refCount == 0) {
                this.app.unregisterActivityLifecycleCallbacks(this.this$0);
            } else if (this.refCount < 0) {
                Log.e("NFC", "-ve refcount for " + this.app);
            }
        }

        private void __constructor__(NfcActivityManager nfcActivityManager, Application application) {
            this.$$robo$$android_nfc_NfcActivityManager_NfcApplicationState$__constructor__(nfcActivityManager, application);
        }

        public NfcApplicationState(NfcActivityManager nfcActivityManager, Application application) {
            this.this$0 = nfcActivityManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NfcActivityManager_NfcApplicationState$__constructor__(android.nfc.NfcActivityManager android.app.Application ), this, nfcActivityManager, application);
        }

        public void register() {
            InvokeDynamicSupport.bootstrap("register", $$robo$$android_nfc_NfcActivityManager_NfcApplicationState$register(), this);
        }

        public void unregister() {
            InvokeDynamicSupport.bootstrap("unregister", $$robo$$android_nfc_NfcActivityManager_NfcApplicationState$unregister(), this);
        }

        public /* synthetic */ NfcApplicationState() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NfcApplicationState)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

