/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.nfc.INfcTag;
import android.nfc.tech.IsoDep;
import android.nfc.tech.MifareClassic;
import android.nfc.tech.MifareUltralight;
import android.nfc.tech.Ndef;
import android.nfc.tech.NdefFormatable;
import android.nfc.tech.NfcA;
import android.nfc.tech.NfcB;
import android.nfc.tech.NfcBarcode;
import android.nfc.tech.NfcF;
import android.nfc.tech.NfcV;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Tag
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    byte[] mId;
    int[] mTechList;
    String[] mTechStringList;
    Bundle[] mTechExtras;
    int mServiceHandle;
    INfcTag mTagService;
    int mConnectedTechnology;
    public static Parcelable.Creator<Tag> CREATOR;

    private void $$robo$$android_nfc_Tag$__constructor__(byte[] id2, int[] techList, Bundle[] techListExtras, int serviceHandle, INfcTag tagService) {
        if (techList == null) {
            throw new IllegalArgumentException("rawTargets cannot be null");
        }
        this.mId = id2;
        this.mTechList = Arrays.copyOf(techList, techList.length);
        this.mTechStringList = this.generateTechStringList(techList);
        this.mTechExtras = Arrays.copyOf(techListExtras, techList.length);
        this.mServiceHandle = serviceHandle;
        this.mTagService = tagService;
        this.mConnectedTechnology = -1;
    }

    private static final Tag $$robo$$android_nfc_Tag$createMockTag(byte[] id2, int[] techList, Bundle[] techListExtras) {
        return new Tag(id2, techList, techListExtras, 0, null);
    }

    private final String[] $$robo$$android_nfc_Tag$generateTechStringList(int[] techList) {
        int size = techList.length;
        String[] strings = new String[size];
        block12: for (int i = 0; i < size; ++i) {
            switch (techList[i]) {
                case 3: {
                    strings[i] = IsoDep.class.getName();
                    continue block12;
                }
                case 8: {
                    strings[i] = MifareClassic.class.getName();
                    continue block12;
                }
                case 9: {
                    strings[i] = MifareUltralight.class.getName();
                    continue block12;
                }
                case 6: {
                    strings[i] = Ndef.class.getName();
                    continue block12;
                }
                case 7: {
                    strings[i] = NdefFormatable.class.getName();
                    continue block12;
                }
                case 1: {
                    strings[i] = NfcA.class.getName();
                    continue block12;
                }
                case 2: {
                    strings[i] = NfcB.class.getName();
                    continue block12;
                }
                case 4: {
                    strings[i] = NfcF.class.getName();
                    continue block12;
                }
                case 5: {
                    strings[i] = NfcV.class.getName();
                    continue block12;
                }
                case 10: {
                    strings[i] = NfcBarcode.class.getName();
                    continue block12;
                }
                default: {
                    throw new IllegalArgumentException("Unknown tech type " + techList[i]);
                }
            }
        }
        return strings;
    }

    private static final int[] $$robo$$android_nfc_Tag$getTechCodesFromStrings(String[] techStringList) throws IllegalArgumentException {
        if (techStringList == null) {
            throw new IllegalArgumentException("List cannot be null");
        }
        int[] techIntList = new int[techStringList.length];
        HashMap<String, Integer> stringToCodeMap = Tag.getTechStringToCodeMap();
        for (int i = 0; i < techStringList.length; ++i) {
            Integer code = stringToCodeMap.get(techStringList[i]);
            if (code == null) {
                throw new IllegalArgumentException("Unknown tech type " + techStringList[i]);
            }
            techIntList[i] = code;
        }
        return techIntList;
    }

    private static final HashMap<String, Integer> $$robo$$android_nfc_Tag$getTechStringToCodeMap() {
        HashMap<String, Integer> techStringToCodeMap = new HashMap<String, Integer>();
        techStringToCodeMap.put(IsoDep.class.getName(), 3);
        techStringToCodeMap.put(MifareClassic.class.getName(), 8);
        techStringToCodeMap.put(MifareUltralight.class.getName(), 9);
        techStringToCodeMap.put(Ndef.class.getName(), 6);
        techStringToCodeMap.put(NdefFormatable.class.getName(), 7);
        techStringToCodeMap.put(NfcA.class.getName(), 1);
        techStringToCodeMap.put(NfcB.class.getName(), 2);
        techStringToCodeMap.put(NfcF.class.getName(), 4);
        techStringToCodeMap.put(NfcV.class.getName(), 5);
        techStringToCodeMap.put(NfcBarcode.class.getName(), 10);
        return techStringToCodeMap;
    }

    private final int $$robo$$android_nfc_Tag$getServiceHandle() {
        return this.mServiceHandle;
    }

    private final int[] $$robo$$android_nfc_Tag$getTechCodeList() {
        return this.mTechList;
    }

    private final byte[] $$robo$$android_nfc_Tag$getId() {
        return this.mId;
    }

    private final String[] $$robo$$android_nfc_Tag$getTechList() {
        return this.mTechStringList;
    }

    private final Tag $$robo$$android_nfc_Tag$rediscover() throws IOException {
        if (this.getConnectedTechnology() != -1) {
            throw new IllegalStateException("Close connection to the technology first!");
        }
        if (this.mTagService == null) {
            throw new IOException("Mock tags don't support this operation.");
        }
        try {
            Tag newTag = this.mTagService.rediscover(this.getServiceHandle());
            if (newTag != null) {
                return newTag;
            }
            throw new IOException("Failed to rediscover tag");
        }
        catch (RemoteException e) {
            throw new IOException("NFC service dead");
        }
    }

    private final boolean $$robo$$android_nfc_Tag$hasTech(int techType) {
        for (int tech : this.mTechList) {
            if (tech != techType) continue;
            return true;
        }
        return false;
    }

    private final Bundle $$robo$$android_nfc_Tag$getTechExtras(int tech) {
        int pos = -1;
        for (int idx = 0; idx < this.mTechList.length; ++idx) {
            if (this.mTechList[idx] != tech) continue;
            pos = idx;
            break;
        }
        if (pos < 0) {
            return null;
        }
        return this.mTechExtras[pos];
    }

    private final INfcTag $$robo$$android_nfc_Tag$getTagService() {
        return this.mTagService;
    }

    private final String $$robo$$android_nfc_Tag$toString() {
        StringBuilder sb = new StringBuilder("TAG: Tech [");
        String[] techList = this.getTechList();
        int length = techList.length;
        for (int i = 0; i < length; ++i) {
            sb.append(techList[i]);
            if (i >= length - 1) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private static final byte[] $$robo$$android_nfc_Tag$readBytesWithNull(Parcel in) {
        int len = in.readInt();
        byte[] result = null;
        if (len >= 0) {
            result = new byte[len];
            in.readByteArray(result);
        }
        return result;
    }

    private static final void $$robo$$android_nfc_Tag$writeBytesWithNull(Parcel out, byte[] b) {
        if (b == null) {
            out.writeInt(-1);
            return;
        }
        out.writeInt(b.length);
        out.writeByteArray(b);
    }

    private final int $$robo$$android_nfc_Tag$describeContents() {
        return 0;
    }

    private final void $$robo$$android_nfc_Tag$writeToParcel(Parcel dest, int flags) {
        int isMock = this.mTagService == null ? 1 : 0;
        Tag.writeBytesWithNull(dest, this.mId);
        dest.writeInt(this.mTechList.length);
        dest.writeIntArray(this.mTechList);
        dest.writeTypedArray(this.mTechExtras, 0);
        dest.writeInt(this.mServiceHandle);
        dest.writeInt(isMock);
        if (isMock == 0) {
            dest.writeStrongBinder(this.mTagService.asBinder());
        }
    }

    private final synchronized void $$robo$$android_nfc_Tag$setConnectedTechnology(int technology) {
        if (this.mConnectedTechnology != -1) {
            throw new IllegalStateException("Close other technology first!");
        }
        this.mConnectedTechnology = technology;
    }

    private final int $$robo$$android_nfc_Tag$getConnectedTechnology() {
        return this.mConnectedTechnology;
    }

    private final void $$robo$$android_nfc_Tag$setTechnologyDisconnected() {
        this.mConnectedTechnology = -1;
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<Tag>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_nfc_Tag_1$__constructor__() {
            }

            private final Tag $$robo$$android_nfc_Tag_1$createFromParcel(Parcel in) {
                byte[] id2 = Tag.readBytesWithNull(in);
                int[] techList = new int[in.readInt()];
                in.readIntArray(techList);
                Bundle[] techExtras = in.createTypedArray(Bundle.CREATOR);
                int serviceHandle = in.readInt();
                int isMock = in.readInt();
                INfcTag tagService = isMock == 0 ? INfcTag.Stub.asInterface(in.readStrongBinder()) : null;
                return new Tag(id2, techList, techExtras, serviceHandle, tagService);
            }

            private final Tag[] $$robo$$android_nfc_Tag_1$newArray(int size) {
                return new Tag[size];
            }

            private void __constructor__() {
                this.$$robo$$android_nfc_Tag_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_Tag_1$__constructor__(), this);
            }

            @Override
            public Tag createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_nfc_Tag_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public Tag[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_nfc_Tag_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(byte[] byArray, int[] nArray, Bundle[] bundleArray, int n, INfcTag iNfcTag) {
        this.$$robo$$android_nfc_Tag$__constructor__(byArray, nArray, bundleArray, n, iNfcTag);
    }

    public Tag(byte[] byArray, int[] nArray, Bundle[] bundleArray, int n, INfcTag iNfcTag) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_Tag$__constructor__(byte[] int[] android.os.Bundle[] int android.nfc.INfcTag ), this, byArray, nArray, bundleArray, n, iNfcTag);
    }

    public static Tag createMockTag(byte[] byArray, int[] nArray, Bundle[] bundleArray) {
        return InvokeDynamicSupport.bootstrapStatic("createMockTag", $$robo$$android_nfc_Tag$createMockTag(byte[] int[] android.os.Bundle[] ), (byte[])byArray, (int[])nArray, (Bundle[])bundleArray);
    }

    private String[] generateTechStringList(int[] nArray) {
        return InvokeDynamicSupport.bootstrap("generateTechStringList", $$robo$$android_nfc_Tag$generateTechStringList(int[] ), this, nArray);
    }

    static int[] getTechCodesFromStrings(String[] stringArray) throws IllegalArgumentException {
        return InvokeDynamicSupport.bootstrapStatic("getTechCodesFromStrings", $$robo$$android_nfc_Tag$getTechCodesFromStrings(java.lang.String[] ), (String[])stringArray);
    }

    private static HashMap<String, Integer> getTechStringToCodeMap() {
        return InvokeDynamicSupport.bootstrapStatic("getTechStringToCodeMap", $$robo$$android_nfc_Tag$getTechStringToCodeMap());
    }

    public int getServiceHandle() {
        return (int)InvokeDynamicSupport.bootstrap("getServiceHandle", $$robo$$android_nfc_Tag$getServiceHandle(), this);
    }

    public int[] getTechCodeList() {
        return InvokeDynamicSupport.bootstrap("getTechCodeList", $$robo$$android_nfc_Tag$getTechCodeList(), this);
    }

    public byte[] getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_nfc_Tag$getId(), this);
    }

    public String[] getTechList() {
        return InvokeDynamicSupport.bootstrap("getTechList", $$robo$$android_nfc_Tag$getTechList(), this);
    }

    public Tag rediscover() throws IOException {
        return InvokeDynamicSupport.bootstrap("rediscover", $$robo$$android_nfc_Tag$rediscover(), this);
    }

    public boolean hasTech(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasTech", $$robo$$android_nfc_Tag$hasTech(int ), this, n);
    }

    public Bundle getTechExtras(int n) {
        return InvokeDynamicSupport.bootstrap("getTechExtras", $$robo$$android_nfc_Tag$getTechExtras(int ), this, n);
    }

    public INfcTag getTagService() {
        return InvokeDynamicSupport.bootstrap("getTagService", $$robo$$android_nfc_Tag$getTagService(), this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_nfc_Tag$toString(), this);
    }

    static byte[] readBytesWithNull(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("readBytesWithNull", $$robo$$android_nfc_Tag$readBytesWithNull(android.os.Parcel ), (Parcel)parcel);
    }

    static void writeBytesWithNull(Parcel parcel, byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("writeBytesWithNull", $$robo$$android_nfc_Tag$writeBytesWithNull(android.os.Parcel byte[] ), (Parcel)parcel, (byte[])byArray);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_nfc_Tag$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_nfc_Tag$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public synchronized void setConnectedTechnology(int n) {
        InvokeDynamicSupport.bootstrap("setConnectedTechnology", $$robo$$android_nfc_Tag$setConnectedTechnology(int ), this, n);
    }

    public int getConnectedTechnology() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectedTechnology", $$robo$$android_nfc_Tag$getConnectedTechnology(), this);
    }

    public void setTechnologyDisconnected() {
        InvokeDynamicSupport.bootstrap("setTechnologyDisconnected", $$robo$$android_nfc_Tag$setTechnologyDisconnected(), this);
    }

    static {
        RobolectricInternals.classInitializing(Tag.class);
    }

    public /* synthetic */ Tag() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Tag)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

