/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Bundle;
import android.os.Debug;
import android.os.Process;
import android.os.SystemClock;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PerformanceCollector
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String METRIC_KEY_ITERATIONS = "iterations";
    public static String METRIC_KEY_LABEL = "label";
    public static String METRIC_KEY_CPU_TIME = "cpu_time";
    public static String METRIC_KEY_EXECUTION_TIME = "execution_time";
    public static String METRIC_KEY_PRE_RECEIVED_TRANSACTIONS = "pre_received_transactions";
    public static String METRIC_KEY_PRE_SENT_TRANSACTIONS = "pre_sent_transactions";
    public static String METRIC_KEY_RECEIVED_TRANSACTIONS = "received_transactions";
    public static String METRIC_KEY_SENT_TRANSACTIONS = "sent_transactions";
    public static String METRIC_KEY_GC_INVOCATION_COUNT = "gc_invocation_count";
    public static String METRIC_KEY_JAVA_ALLOCATED = "java_allocated";
    public static String METRIC_KEY_JAVA_FREE = "java_free";
    public static String METRIC_KEY_JAVA_PRIVATE_DIRTY = "java_private_dirty";
    public static String METRIC_KEY_JAVA_PSS = "java_pss";
    public static String METRIC_KEY_JAVA_SHARED_DIRTY = "java_shared_dirty";
    public static String METRIC_KEY_JAVA_SIZE = "java_size";
    public static String METRIC_KEY_NATIVE_ALLOCATED = "native_allocated";
    public static String METRIC_KEY_NATIVE_FREE = "native_free";
    public static String METRIC_KEY_NATIVE_PRIVATE_DIRTY = "native_private_dirty";
    public static String METRIC_KEY_NATIVE_PSS = "native_pss";
    public static String METRIC_KEY_NATIVE_SHARED_DIRTY = "native_shared_dirty";
    public static String METRIC_KEY_NATIVE_SIZE = "native_size";
    public static String METRIC_KEY_GLOBAL_ALLOC_COUNT = "global_alloc_count";
    public static String METRIC_KEY_GLOBAL_ALLOC_SIZE = "global_alloc_size";
    public static String METRIC_KEY_GLOBAL_FREED_COUNT = "global_freed_count";
    public static String METRIC_KEY_GLOBAL_FREED_SIZE = "global_freed_size";
    public static String METRIC_KEY_OTHER_PRIVATE_DIRTY = "other_private_dirty";
    public static String METRIC_KEY_OTHER_PSS = "other_pss";
    public static String METRIC_KEY_OTHER_SHARED_DIRTY = "other_shared_dirty";
    private PerformanceResultsWriter mPerfWriter;
    private Bundle mPerfSnapshot;
    private Bundle mPerfMeasurement;
    private long mSnapshotCpuTime;
    private long mSnapshotExecTime;
    private long mCpuTime;
    private long mExecTime;

    private void $$robo$$android_os_PerformanceCollector$__constructor__() {
    }

    private void $$robo$$android_os_PerformanceCollector$__constructor__(PerformanceResultsWriter writer) {
        this.setPerformanceResultsWriter(writer);
    }

    private final void $$robo$$android_os_PerformanceCollector$setPerformanceResultsWriter(PerformanceResultsWriter writer) {
        this.mPerfWriter = writer;
    }

    private final void $$robo$$android_os_PerformanceCollector$beginSnapshot(String label) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeBeginSnapshot(label);
        }
        this.startPerformanceSnapshot();
    }

    private final Bundle $$robo$$android_os_PerformanceCollector$endSnapshot() {
        this.endPerformanceSnapshot();
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeEndSnapshot(this.mPerfSnapshot);
        }
        return this.mPerfSnapshot;
    }

    private final void $$robo$$android_os_PerformanceCollector$startTiming(String label) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeStartTiming(label);
        }
        this.mPerfMeasurement = new Bundle();
        this.mPerfMeasurement.putParcelableArrayList("iterations", new ArrayList());
        this.mExecTime = SystemClock.uptimeMillis();
        this.mCpuTime = Process.getElapsedCpuTime();
    }

    private final Bundle $$robo$$android_os_PerformanceCollector$addIteration(String label) {
        this.mCpuTime = Process.getElapsedCpuTime() - this.mCpuTime;
        this.mExecTime = SystemClock.uptimeMillis() - this.mExecTime;
        Bundle iteration = new Bundle();
        iteration.putString("label", label);
        iteration.putLong("execution_time", this.mExecTime);
        iteration.putLong("cpu_time", this.mCpuTime);
        this.mPerfMeasurement.getParcelableArrayList("iterations").add(iteration);
        this.mExecTime = SystemClock.uptimeMillis();
        this.mCpuTime = Process.getElapsedCpuTime();
        return iteration;
    }

    private final Bundle $$robo$$android_os_PerformanceCollector$stopTiming(String label) {
        this.addIteration(label);
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeStopTiming(this.mPerfMeasurement);
        }
        return this.mPerfMeasurement;
    }

    private final void $$robo$$android_os_PerformanceCollector$addMeasurement(String label, long value) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeMeasurement(label, value);
        }
    }

    private final void $$robo$$android_os_PerformanceCollector$addMeasurement(String label, float value) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeMeasurement(label, value);
        }
    }

    private final void $$robo$$android_os_PerformanceCollector$addMeasurement(String label, String value) {
        if (this.mPerfWriter != null) {
            this.mPerfWriter.writeMeasurement(label, value);
        }
    }

    private final void $$robo$$android_os_PerformanceCollector$startPerformanceSnapshot() {
        this.mPerfSnapshot = new Bundle();
        Bundle binderCounts = PerformanceCollector.getBinderCounts();
        for (String key : binderCounts.keySet()) {
            this.mPerfSnapshot.putLong("pre_" + key, binderCounts.getLong(key));
        }
        PerformanceCollector.startAllocCounting();
        this.mSnapshotExecTime = SystemClock.uptimeMillis();
        this.mSnapshotCpuTime = Process.getElapsedCpuTime();
    }

    private final void $$robo$$android_os_PerformanceCollector$endPerformanceSnapshot() {
        this.mSnapshotCpuTime = Process.getElapsedCpuTime() - this.mSnapshotCpuTime;
        this.mSnapshotExecTime = SystemClock.uptimeMillis() - this.mSnapshotExecTime;
        PerformanceCollector.stopAllocCounting();
        long nativeMax = Debug.getNativeHeapSize() / 1024L;
        long nativeAllocated = Debug.getNativeHeapAllocatedSize() / 1024L;
        long nativeFree = Debug.getNativeHeapFreeSize() / 1024L;
        Debug.MemoryInfo memInfo = new Debug.MemoryInfo();
        Debug.getMemoryInfo(memInfo);
        Runtime runtime = Runtime.getRuntime();
        long dalvikMax = runtime.totalMemory() / 1024L;
        long dalvikFree = runtime.freeMemory() / 1024L;
        long dalvikAllocated = dalvikMax - dalvikFree;
        Bundle binderCounts = PerformanceCollector.getBinderCounts();
        for (String key : binderCounts.keySet()) {
            this.mPerfSnapshot.putLong(key, binderCounts.getLong(key));
        }
        Bundle allocCounts = PerformanceCollector.getAllocCounts();
        for (String key : allocCounts.keySet()) {
            this.mPerfSnapshot.putLong(key, allocCounts.getLong(key));
        }
        this.mPerfSnapshot.putLong("execution_time", this.mSnapshotExecTime);
        this.mPerfSnapshot.putLong("cpu_time", this.mSnapshotCpuTime);
        this.mPerfSnapshot.putLong("native_size", nativeMax);
        this.mPerfSnapshot.putLong("native_allocated", nativeAllocated);
        this.mPerfSnapshot.putLong("native_free", nativeFree);
        this.mPerfSnapshot.putLong("native_pss", memInfo.nativePss);
        this.mPerfSnapshot.putLong("native_private_dirty", memInfo.nativePrivateDirty);
        this.mPerfSnapshot.putLong("native_shared_dirty", memInfo.nativeSharedDirty);
        this.mPerfSnapshot.putLong("java_size", dalvikMax);
        this.mPerfSnapshot.putLong("java_allocated", dalvikAllocated);
        this.mPerfSnapshot.putLong("java_free", dalvikFree);
        this.mPerfSnapshot.putLong("java_pss", memInfo.dalvikPss);
        this.mPerfSnapshot.putLong("java_private_dirty", memInfo.dalvikPrivateDirty);
        this.mPerfSnapshot.putLong("java_shared_dirty", memInfo.dalvikSharedDirty);
        this.mPerfSnapshot.putLong("other_pss", memInfo.otherPss);
        this.mPerfSnapshot.putLong("other_private_dirty", memInfo.otherPrivateDirty);
        this.mPerfSnapshot.putLong("other_shared_dirty", memInfo.otherSharedDirty);
    }

    private static final void $$robo$$android_os_PerformanceCollector$startAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.resetAllCounts();
        Debug.startAllocCounting();
    }

    private static final void $$robo$$android_os_PerformanceCollector$stopAllocCounting() {
        Runtime.getRuntime().gc();
        Runtime.getRuntime().runFinalization();
        Runtime.getRuntime().gc();
        Debug.stopAllocCounting();
    }

    private static final Bundle $$robo$$android_os_PerformanceCollector$getAllocCounts() {
        Bundle results = new Bundle();
        results.putLong("global_alloc_count", Debug.getGlobalAllocCount());
        results.putLong("global_alloc_size", Debug.getGlobalAllocSize());
        results.putLong("global_freed_count", Debug.getGlobalFreedCount());
        results.putLong("global_freed_size", Debug.getGlobalFreedSize());
        results.putLong("gc_invocation_count", Debug.getGlobalGcInvocationCount());
        return results;
    }

    private static final Bundle $$robo$$android_os_PerformanceCollector$getBinderCounts() {
        Bundle results = new Bundle();
        results.putLong("sent_transactions", Debug.getBinderSentTransactions());
        results.putLong("received_transactions", Debug.getBinderReceivedTransactions());
        return results;
    }

    private void __constructor__() {
        this.$$robo$$android_os_PerformanceCollector$__constructor__();
    }

    public PerformanceCollector() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_PerformanceCollector$__constructor__(), this);
    }

    private void __constructor__(PerformanceResultsWriter performanceResultsWriter) {
        this.$$robo$$android_os_PerformanceCollector$__constructor__(performanceResultsWriter);
    }

    public PerformanceCollector(PerformanceResultsWriter performanceResultsWriter) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_PerformanceCollector$__constructor__(android.os.PerformanceCollector$PerformanceResultsWriter ), this, performanceResultsWriter);
    }

    public void setPerformanceResultsWriter(PerformanceResultsWriter performanceResultsWriter) {
        InvokeDynamicSupport.bootstrap("setPerformanceResultsWriter", $$robo$$android_os_PerformanceCollector$setPerformanceResultsWriter(android.os.PerformanceCollector$PerformanceResultsWriter ), this, performanceResultsWriter);
    }

    public void beginSnapshot(String string2) {
        InvokeDynamicSupport.bootstrap("beginSnapshot", $$robo$$android_os_PerformanceCollector$beginSnapshot(java.lang.String ), this, string2);
    }

    public Bundle endSnapshot() {
        return InvokeDynamicSupport.bootstrap("endSnapshot", $$robo$$android_os_PerformanceCollector$endSnapshot(), this);
    }

    public void startTiming(String string2) {
        InvokeDynamicSupport.bootstrap("startTiming", $$robo$$android_os_PerformanceCollector$startTiming(java.lang.String ), this, string2);
    }

    public Bundle addIteration(String string2) {
        return InvokeDynamicSupport.bootstrap("addIteration", $$robo$$android_os_PerformanceCollector$addIteration(java.lang.String ), this, string2);
    }

    public Bundle stopTiming(String string2) {
        return InvokeDynamicSupport.bootstrap("stopTiming", $$robo$$android_os_PerformanceCollector$stopTiming(java.lang.String ), this, string2);
    }

    public void addMeasurement(String string2, long l) {
        InvokeDynamicSupport.bootstrap("addMeasurement", $$robo$$android_os_PerformanceCollector$addMeasurement(java.lang.String long ), this, string2, l);
    }

    public void addMeasurement(String string2, float f) {
        InvokeDynamicSupport.bootstrap("addMeasurement", $$robo$$android_os_PerformanceCollector$addMeasurement(java.lang.String float ), this, string2, f);
    }

    public void addMeasurement(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("addMeasurement", $$robo$$android_os_PerformanceCollector$addMeasurement(java.lang.String java.lang.String ), this, string2, string3);
    }

    private void startPerformanceSnapshot() {
        InvokeDynamicSupport.bootstrap("startPerformanceSnapshot", $$robo$$android_os_PerformanceCollector$startPerformanceSnapshot(), this);
    }

    private void endPerformanceSnapshot() {
        InvokeDynamicSupport.bootstrap("endPerformanceSnapshot", $$robo$$android_os_PerformanceCollector$endPerformanceSnapshot(), this);
    }

    private static void startAllocCounting() {
        InvokeDynamicSupport.bootstrapStatic("startAllocCounting", $$robo$$android_os_PerformanceCollector$startAllocCounting());
    }

    private static void stopAllocCounting() {
        InvokeDynamicSupport.bootstrapStatic("stopAllocCounting", $$robo$$android_os_PerformanceCollector$stopAllocCounting());
    }

    private static Bundle getAllocCounts() {
        return InvokeDynamicSupport.bootstrapStatic("getAllocCounts", $$robo$$android_os_PerformanceCollector$getAllocCounts());
    }

    private static Bundle getBinderCounts() {
        return InvokeDynamicSupport.bootstrapStatic("getBinderCounts", $$robo$$android_os_PerformanceCollector$getBinderCounts());
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PerformanceCollector)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface PerformanceResultsWriter
    extends InstrumentedInterface {
        public void writeBeginSnapshot(String var1);

        public void writeEndSnapshot(Bundle var1);

        public void writeStartTiming(String var1);

        public void writeStopTiming(Bundle var1);

        public void writeMeasurement(String var1, long var2);

        public void writeMeasurement(String var1, float var2);

        public void writeMeasurement(String var1, String var2);
    }
}

