/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class VibrationEffect
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int PARCEL_TOKEN_ONE_SHOT = 1;
    private static int PARCEL_TOKEN_WAVEFORM = 2;
    private static int PARCEL_TOKEN_EFFECT = 3;
    public static int DEFAULT_AMPLITUDE = -1;
    public static int EFFECT_CLICK = 0;
    public static int EFFECT_DOUBLE_CLICK = 1;
    public static Parcelable.Creator<VibrationEffect> CREATOR;

    private void $$robo$$android_os_VibrationEffect$__constructor__() {
    }

    private static final VibrationEffect $$robo$$android_os_VibrationEffect$createOneShot(long milliseconds, int amplitude) {
        OneShot effect = new OneShot(milliseconds, amplitude);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    private static final VibrationEffect $$robo$$android_os_VibrationEffect$createWaveform(long[] timings, int repeat) {
        int[] amplitudes = new int[timings.length];
        for (int i = 0; i < timings.length / 2; ++i) {
            amplitudes[i * 2 + 1] = -1;
        }
        return VibrationEffect.createWaveform(timings, amplitudes, repeat);
    }

    private static final VibrationEffect $$robo$$android_os_VibrationEffect$createWaveform(long[] timings, int[] amplitudes, int repeat) {
        Waveform effect = new Waveform(timings, amplitudes, repeat);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    private static final VibrationEffect $$robo$$android_os_VibrationEffect$get(int effectId) {
        Prebaked effect = new Prebaked(effectId);
        ((VibrationEffect)effect).validate();
        return effect;
    }

    private final int $$robo$$android_os_VibrationEffect$describeContents() {
        return 0;
    }

    public abstract void validate();

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<VibrationEffect>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_os_VibrationEffect_1$__constructor__() {
            }

            private final VibrationEffect $$robo$$android_os_VibrationEffect_1$createFromParcel(Parcel in) {
                int token = in.readInt();
                if (token == 1) {
                    return new OneShot(in);
                }
                if (token == 2) {
                    return new Waveform(in);
                }
                if (token == 3) {
                    return new Prebaked(in);
                }
                throw new IllegalStateException("Unexpected vibration event type token in parcel.");
            }

            private final VibrationEffect[] $$robo$$android_os_VibrationEffect_1$newArray(int size) {
                return new VibrationEffect[size];
            }

            private void __constructor__() {
                this.$$robo$$android_os_VibrationEffect_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect_1$__constructor__(), this);
            }

            @Override
            public VibrationEffect createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_VibrationEffect_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public VibrationEffect[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_VibrationEffect_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_os_VibrationEffect$__constructor__();
    }

    public VibrationEffect() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect$__constructor__(), this);
    }

    public static VibrationEffect createOneShot(long l, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createOneShot", $$robo$$android_os_VibrationEffect$createOneShot(long int ), (long)l, (int)n);
    }

    public static VibrationEffect createWaveform(long[] lArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createWaveform", $$robo$$android_os_VibrationEffect$createWaveform(long[] int ), (long[])lArray, (int)n);
    }

    public static VibrationEffect createWaveform(long[] lArray, int[] nArray, int n) {
        return InvokeDynamicSupport.bootstrapStatic("createWaveform", $$robo$$android_os_VibrationEffect$createWaveform(long[] int[] int ), (long[])lArray, (int[])nArray, (int)n);
    }

    public static VibrationEffect get(int n) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_os_VibrationEffect$get(int ), (int)n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_os_VibrationEffect$describeContents(), this);
    }

    static {
        RobolectricInternals.classInitializing(VibrationEffect.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VibrationEffect)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Prebaked
    extends VibrationEffect
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mEffectId;
        public static Parcelable.Creator<Prebaked> CREATOR;

        private void $$robo$$android_os_VibrationEffect_Prebaked$__constructor__(Parcel in) {
        }

        private void $$robo$$android_os_VibrationEffect_Prebaked$__constructor__(int effectId) {
            this.mEffectId = effectId;
        }

        private final int $$robo$$android_os_VibrationEffect_Prebaked$getId() {
            return this.mEffectId;
        }

        private final void $$robo$$android_os_VibrationEffect_Prebaked$validate() {
            if (this.mEffectId != 0) {
                throw new IllegalArgumentException("Unknown prebaked effect type (value=" + this.mEffectId + ")");
            }
        }

        private final boolean $$robo$$android_os_VibrationEffect_Prebaked$equals(Object o) {
            if (!(o instanceof Prebaked)) {
                return false;
            }
            Prebaked other = (Prebaked)o;
            return this.mEffectId == other.mEffectId;
        }

        private final int $$robo$$android_os_VibrationEffect_Prebaked$hashCode() {
            return this.mEffectId;
        }

        private final String $$robo$$android_os_VibrationEffect_Prebaked$toString() {
            return "Prebaked{mEffectId=" + this.mEffectId + "}";
        }

        private final void $$robo$$android_os_VibrationEffect_Prebaked$writeToParcel(Parcel out, int flags) {
            out.writeInt(3);
            out.writeInt(this.mEffectId);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Prebaked>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_os_VibrationEffect_Prebaked_1$__constructor__() {
                }

                private final Prebaked $$robo$$android_os_VibrationEffect_Prebaked_1$createFromParcel(Parcel in) {
                    in.readInt();
                    return new Prebaked(in);
                }

                private final Prebaked[] $$robo$$android_os_VibrationEffect_Prebaked_1$newArray(int size) {
                    return new Prebaked[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_os_VibrationEffect_Prebaked_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect_Prebaked_1$__constructor__(), this);
                }

                @Override
                public Prebaked createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_VibrationEffect_Prebaked_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public Prebaked[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_VibrationEffect_Prebaked_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_os_VibrationEffect_Prebaked$__constructor__(parcel);
        }

        public Prebaked(Parcel parcel) {
            this(parcel.readInt());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect_Prebaked$__constructor__(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_os_VibrationEffect_Prebaked$__constructor__(n);
        }

        public Prebaked(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect_Prebaked$__constructor__(int ), this, n);
        }

        public int getId() {
            return (int)InvokeDynamicSupport.bootstrap("getId", $$robo$$android_os_VibrationEffect_Prebaked$getId(), this);
        }

        @Override
        public void validate() {
            InvokeDynamicSupport.bootstrap("validate", $$robo$$android_os_VibrationEffect_Prebaked$validate(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_VibrationEffect_Prebaked$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_VibrationEffect_Prebaked$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_VibrationEffect_Prebaked$toString(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_VibrationEffect_Prebaked$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(Prebaked.class);
        }

        public /* synthetic */ Prebaked() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Prebaked)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Waveform
    extends VibrationEffect
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long[] mTimings;
        private int[] mAmplitudes;
        private int mRepeat;
        public static Parcelable.Creator<Waveform> CREATOR;

        private void $$robo$$android_os_VibrationEffect_Waveform$__constructor__(Parcel in) {
        }

        private void $$robo$$android_os_VibrationEffect_Waveform$__constructor__(long[] timings, int[] amplitudes, int repeat) {
            this.mTimings = new long[timings.length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])timings, (int)0, (long[])this.mTimings, (int)0, (int)timings.length);
            this.mAmplitudes = new int[amplitudes.length];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])amplitudes, (int)0, (int[])this.mAmplitudes, (int)0, (int)amplitudes.length);
            this.mRepeat = repeat;
        }

        private final long[] $$robo$$android_os_VibrationEffect_Waveform$getTimings() {
            return this.mTimings;
        }

        private final int[] $$robo$$android_os_VibrationEffect_Waveform$getAmplitudes() {
            return this.mAmplitudes;
        }

        private final int $$robo$$android_os_VibrationEffect_Waveform$getRepeatIndex() {
            return this.mRepeat;
        }

        private final void $$robo$$android_os_VibrationEffect_Waveform$validate() {
            if (this.mTimings.length != this.mAmplitudes.length) {
                throw new IllegalArgumentException("timing and amplitude arrays must be of equal length (timings.length=" + this.mTimings.length + ", amplitudes.length=" + this.mAmplitudes.length + ")");
            }
            if (!Waveform.hasNonZeroEntry(this.mTimings)) {
                throw new IllegalArgumentException("at least one timing must be non-zero (timings=" + Arrays.toString(this.mTimings) + ")");
            }
            for (long timing : this.mTimings) {
                if (timing >= 0L) continue;
                throw new IllegalArgumentException("timings must all be >= 0 (timings=" + Arrays.toString(this.mTimings) + ")");
            }
            for (int amplitude : this.mAmplitudes) {
                if (amplitude >= -1 && amplitude <= 255) continue;
                throw new IllegalArgumentException("amplitudes must all be DEFAULT_AMPLITUDE or between 0 and 255 (amplitudes=" + Arrays.toString(this.mAmplitudes) + ")");
            }
            if (this.mRepeat < -1 || this.mRepeat >= this.mTimings.length) {
                throw new IllegalArgumentException("repeat index must be within the bounds of the timings array (timings.length=" + this.mTimings.length + ", index=" + this.mRepeat + ")");
            }
        }

        private final boolean $$robo$$android_os_VibrationEffect_Waveform$equals(Object o) {
            if (!(o instanceof Waveform)) {
                return false;
            }
            Waveform other = (Waveform)o;
            return Arrays.equals(this.mTimings, other.mTimings) && Arrays.equals(this.mAmplitudes, other.mAmplitudes) && this.mRepeat == other.mRepeat;
        }

        private final int $$robo$$android_os_VibrationEffect_Waveform$hashCode() {
            int result = 17;
            result = 37 * Arrays.hashCode(this.mTimings);
            result = 37 * Arrays.hashCode(this.mAmplitudes);
            result = 37 * this.mRepeat;
            return result;
        }

        private final String $$robo$$android_os_VibrationEffect_Waveform$toString() {
            return "Waveform{mTimings=" + Arrays.toString(this.mTimings) + ", mAmplitudes=" + Arrays.toString(this.mAmplitudes) + ", mRepeat=" + this.mRepeat + "}";
        }

        private final void $$robo$$android_os_VibrationEffect_Waveform$writeToParcel(Parcel out, int flags) {
            out.writeInt(2);
            out.writeLongArray(this.mTimings);
            out.writeIntArray(this.mAmplitudes);
            out.writeInt(this.mRepeat);
        }

        private static final boolean $$robo$$android_os_VibrationEffect_Waveform$hasNonZeroEntry(long[] vals) {
            for (long val : vals) {
                if (val == 0L) continue;
                return true;
            }
            return false;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Waveform>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_os_VibrationEffect_Waveform_1$__constructor__() {
                }

                private final Waveform $$robo$$android_os_VibrationEffect_Waveform_1$createFromParcel(Parcel in) {
                    in.readInt();
                    return new Waveform(in);
                }

                private final Waveform[] $$robo$$android_os_VibrationEffect_Waveform_1$newArray(int size) {
                    return new Waveform[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_os_VibrationEffect_Waveform_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect_Waveform_1$__constructor__(), this);
                }

                @Override
                public Waveform createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_VibrationEffect_Waveform_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public Waveform[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_VibrationEffect_Waveform_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_os_VibrationEffect_Waveform$__constructor__(parcel);
        }

        public Waveform(Parcel parcel) {
            this(parcel.createLongArray(), parcel.createIntArray(), parcel.readInt());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect_Waveform$__constructor__(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(long[] lArray, int[] nArray, int n) {
            this.$$robo$$android_os_VibrationEffect_Waveform$__constructor__(lArray, nArray, n);
        }

        public Waveform(long[] lArray, int[] nArray, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect_Waveform$__constructor__(long[] int[] int ), this, lArray, nArray, n);
        }

        public long[] getTimings() {
            return InvokeDynamicSupport.bootstrap("getTimings", $$robo$$android_os_VibrationEffect_Waveform$getTimings(), this);
        }

        public int[] getAmplitudes() {
            return InvokeDynamicSupport.bootstrap("getAmplitudes", $$robo$$android_os_VibrationEffect_Waveform$getAmplitudes(), this);
        }

        public int getRepeatIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getRepeatIndex", $$robo$$android_os_VibrationEffect_Waveform$getRepeatIndex(), this);
        }

        @Override
        public void validate() {
            InvokeDynamicSupport.bootstrap("validate", $$robo$$android_os_VibrationEffect_Waveform$validate(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_VibrationEffect_Waveform$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_VibrationEffect_Waveform$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_VibrationEffect_Waveform$toString(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_VibrationEffect_Waveform$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        private static boolean hasNonZeroEntry(long[] lArray) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("hasNonZeroEntry", $$robo$$android_os_VibrationEffect_Waveform$hasNonZeroEntry(long[] ), (long[])lArray);
        }

        static {
            RobolectricInternals.classInitializing(Waveform.class);
        }

        public /* synthetic */ Waveform() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Waveform)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class OneShot
    extends VibrationEffect
    implements Parcelable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private long mTiming;
        private int mAmplitude;
        public static Parcelable.Creator<OneShot> CREATOR;

        private void $$robo$$android_os_VibrationEffect_OneShot$__constructor__(Parcel in) {
        }

        private void $$robo$$android_os_VibrationEffect_OneShot$__constructor__(long milliseconds, int amplitude) {
            this.mTiming = milliseconds;
            this.mAmplitude = amplitude;
        }

        private final long $$robo$$android_os_VibrationEffect_OneShot$getTiming() {
            return this.mTiming;
        }

        private final int $$robo$$android_os_VibrationEffect_OneShot$getAmplitude() {
            return this.mAmplitude;
        }

        private final void $$robo$$android_os_VibrationEffect_OneShot$validate() {
            if (this.mAmplitude < -1 || this.mAmplitude == 0 || this.mAmplitude > 255) {
                throw new IllegalArgumentException("amplitude must either be DEFAULT_AMPLITUDE, or between 1 and 255 inclusive (amplitude=" + this.mAmplitude + ")");
            }
            if (this.mTiming <= 0L) {
                throw new IllegalArgumentException("timing must be positive (timing=" + this.mTiming + ")");
            }
        }

        private final boolean $$robo$$android_os_VibrationEffect_OneShot$equals(Object o) {
            if (!(o instanceof OneShot)) {
                return false;
            }
            OneShot other = (OneShot)o;
            return other.mTiming == this.mTiming && other.mAmplitude == this.mAmplitude;
        }

        private final int $$robo$$android_os_VibrationEffect_OneShot$hashCode() {
            int result = 17;
            result = 37 * (int)this.mTiming;
            result = 37 * this.mAmplitude;
            return result;
        }

        private final String $$robo$$android_os_VibrationEffect_OneShot$toString() {
            return "OneShot{mTiming=" + this.mTiming + ", mAmplitude=" + this.mAmplitude + "}";
        }

        private final void $$robo$$android_os_VibrationEffect_OneShot$writeToParcel(Parcel out, int flags) {
            out.writeInt(1);
            out.writeLong(this.mTiming);
            out.writeInt(this.mAmplitude);
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<OneShot>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_os_VibrationEffect_OneShot_1$__constructor__() {
                }

                private final OneShot $$robo$$android_os_VibrationEffect_OneShot_1$createFromParcel(Parcel in) {
                    in.readInt();
                    return new OneShot(in);
                }

                private final OneShot[] $$robo$$android_os_VibrationEffect_OneShot_1$newArray(int size) {
                    return new OneShot[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_os_VibrationEffect_OneShot_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect_OneShot_1$__constructor__(), this);
                }

                @Override
                public OneShot createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_os_VibrationEffect_OneShot_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public OneShot[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_os_VibrationEffect_OneShot_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_os_VibrationEffect_OneShot$__constructor__(parcel);
        }

        public OneShot(Parcel parcel) {
            this(parcel.readLong(), parcel.readInt());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect_OneShot$__constructor__(android.os.Parcel ), this, parcel);
        }

        private void __constructor__(long l, int n) {
            this.$$robo$$android_os_VibrationEffect_OneShot$__constructor__(l, n);
        }

        public OneShot(long l, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_VibrationEffect_OneShot$__constructor__(long int ), this, l, n);
        }

        public long getTiming() {
            return (long)InvokeDynamicSupport.bootstrap("getTiming", $$robo$$android_os_VibrationEffect_OneShot$getTiming(), this);
        }

        public int getAmplitude() {
            return (int)InvokeDynamicSupport.bootstrap("getAmplitude", $$robo$$android_os_VibrationEffect_OneShot$getAmplitude(), this);
        }

        @Override
        public void validate() {
            InvokeDynamicSupport.bootstrap("validate", $$robo$$android_os_VibrationEffect_OneShot$validate(), this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_os_VibrationEffect_OneShot$equals(java.lang.Object ), this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_os_VibrationEffect_OneShot$hashCode(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_os_VibrationEffect_OneShot$toString(), this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_os_VibrationEffect_OneShot$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        static {
            RobolectricInternals.classInitializing(OneShot.class);
        }

        public /* synthetic */ OneShot() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OneShot)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

