/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Bundle;
import android.preference.GenericInflater;
import android.preference.Preference;
import android.text.TextUtils;
import android.util.AttributeSet;
import com.android.internal.R;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public abstract class PreferenceGroup
extends Preference
implements GenericInflater.Parent<Preference> {
    public /* synthetic */ Object __robo_data__;
    private List<Preference> mPreferenceList;
    private boolean mOrderingAsAdded;
    private int mCurrentPreferenceOrder;
    private boolean mAttachedToActivity;

    private void $$robo$$android_preference_PreferenceGroup$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mOrderingAsAdded = true;
        this.mCurrentPreferenceOrder = 0;
        this.mAttachedToActivity = false;
        this.mPreferenceList = new ArrayList<Preference>();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.PreferenceGroup, defStyleAttr, defStyleRes);
        this.mOrderingAsAdded = a.getBoolean(0, this.mOrderingAsAdded);
        a.recycle();
    }

    private void $$robo$$android_preference_PreferenceGroup$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_preference_PreferenceGroup$__constructor__(Context context, AttributeSet attrs) {
    }

    private final void $$robo$$android_preference_PreferenceGroup$setOrderingAsAdded(boolean orderingAsAdded) {
        this.mOrderingAsAdded = orderingAsAdded;
    }

    private final boolean $$robo$$android_preference_PreferenceGroup$isOrderingAsAdded() {
        return this.mOrderingAsAdded;
    }

    private final void $$robo$$android_preference_PreferenceGroup$addItemFromInflater(Preference preference) {
        this.addPreference(preference);
    }

    private final int $$robo$$android_preference_PreferenceGroup$getPreferenceCount() {
        return this.mPreferenceList.size();
    }

    private final Preference $$robo$$android_preference_PreferenceGroup$getPreference(int index) {
        return this.mPreferenceList.get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_preference_PreferenceGroup$addPreference(Preference preference) {
        if (this.mPreferenceList.contains(preference)) {
            return true;
        }
        if (preference.getOrder() == Integer.MAX_VALUE) {
            if (this.mOrderingAsAdded) {
                preference.setOrder(this.mCurrentPreferenceOrder++);
            }
            if (preference instanceof PreferenceGroup) {
                ((PreferenceGroup)preference).setOrderingAsAdded(this.mOrderingAsAdded);
            }
        }
        if (!this.onPrepareAddPreference(preference)) {
            return false;
        }
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            int insertionIndex = Collections.binarySearch(this.mPreferenceList, preference);
            if (insertionIndex < 0) {
                insertionIndex = insertionIndex * -1 - 1;
            }
            this.mPreferenceList.add(insertionIndex, preference);
        }
        preference.onAttachedToHierarchy(this.getPreferenceManager());
        preference.assignParent(this);
        if (this.mAttachedToActivity) {
            preference.onAttachedToActivity();
        }
        this.notifyHierarchyChanged();
        return true;
    }

    private final boolean $$robo$$android_preference_PreferenceGroup$removePreference(Preference preference) {
        boolean returnValue = this.removePreferenceInt(preference);
        this.notifyHierarchyChanged();
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_preference_PreferenceGroup$removePreferenceInt(Preference preference) {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            preference.onPrepareForRemoval();
            if (preference.getParent() == this) {
                preference.assignParent(null);
            }
            return this.mPreferenceList.remove(preference);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceGroup$removeAll() {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            List<Preference> preferenceList = this.mPreferenceList;
            for (int i = preferenceList.size() - 1; i >= 0; --i) {
                this.removePreferenceInt(preferenceList.get(0));
            }
        }
        this.notifyHierarchyChanged();
    }

    private final boolean $$robo$$android_preference_PreferenceGroup$onPrepareAddPreference(Preference preference) {
        preference.onParentChanged(this, this.shouldDisableDependents());
        return true;
    }

    private final Preference $$robo$$android_preference_PreferenceGroup$findPreference(CharSequence key) {
        if (TextUtils.equals(this.getKey(), key)) {
            return this;
        }
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            Preference returnedPreference;
            Preference preference = this.getPreference(i);
            String curKey = preference.getKey();
            if (curKey != null && curKey.equals(key)) {
                return preference;
            }
            if (!(preference instanceof PreferenceGroup) || (returnedPreference = ((PreferenceGroup)preference).findPreference(key)) == null) continue;
            return returnedPreference;
        }
        return null;
    }

    private final boolean $$robo$$android_preference_PreferenceGroup$isOnSameScreenAsChildren() {
        return true;
    }

    private final void $$robo$$android_preference_PreferenceGroup$onAttachedToActivity() {
        super.onAttachedToActivity();
        this.mAttachedToActivity = true;
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).onAttachedToActivity();
        }
    }

    private final void $$robo$$android_preference_PreferenceGroup$onPrepareForRemoval() {
        super.onPrepareForRemoval();
        this.mAttachedToActivity = false;
    }

    private final void $$robo$$android_preference_PreferenceGroup$notifyDependencyChange(boolean disableDependents) {
        super.notifyDependencyChange(disableDependents);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).onParentChanged(this, disableDependents);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_PreferenceGroup$sortPreferences() {
        PreferenceGroup preferenceGroup = this;
        synchronized (preferenceGroup) {
            Collections.sort(this.mPreferenceList);
        }
    }

    private final void $$robo$$android_preference_PreferenceGroup$dispatchSaveInstanceState(Bundle container) {
        super.dispatchSaveInstanceState(container);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).dispatchSaveInstanceState(container);
        }
    }

    private final void $$robo$$android_preference_PreferenceGroup$dispatchRestoreInstanceState(Bundle container) {
        super.dispatchRestoreInstanceState(container);
        int preferenceCount = this.getPreferenceCount();
        for (int i = 0; i < preferenceCount; ++i) {
            this.getPreference(i).dispatchRestoreInstanceState(container);
        }
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_preference_PreferenceGroup$__constructor__(context, attributeSet, n, n2);
    }

    public PreferenceGroup(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_PreferenceGroup$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_preference_PreferenceGroup$__constructor__(context, attributeSet, n);
    }

    public PreferenceGroup(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_PreferenceGroup$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_preference_PreferenceGroup$__constructor__(context, attributeSet);
    }

    public PreferenceGroup(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_PreferenceGroup$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    public void setOrderingAsAdded(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOrderingAsAdded", $$robo$$android_preference_PreferenceGroup$setOrderingAsAdded(boolean ), this, bl);
    }

    public boolean isOrderingAsAdded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOrderingAsAdded", $$robo$$android_preference_PreferenceGroup$isOrderingAsAdded(), this);
    }

    @Override
    public void addItemFromInflater(Preference preference) {
        InvokeDynamicSupport.bootstrap("addItemFromInflater", $$robo$$android_preference_PreferenceGroup$addItemFromInflater(android.preference.Preference ), this, preference);
    }

    public int getPreferenceCount() {
        return (int)InvokeDynamicSupport.bootstrap("getPreferenceCount", $$robo$$android_preference_PreferenceGroup$getPreferenceCount(), this);
    }

    public Preference getPreference(int n) {
        return InvokeDynamicSupport.bootstrap("getPreference", $$robo$$android_preference_PreferenceGroup$getPreference(int ), this, n);
    }

    public boolean addPreference(Preference preference) {
        return (boolean)InvokeDynamicSupport.bootstrap("addPreference", $$robo$$android_preference_PreferenceGroup$addPreference(android.preference.Preference ), this, preference);
    }

    public boolean removePreference(Preference preference) {
        return (boolean)InvokeDynamicSupport.bootstrap("removePreference", $$robo$$android_preference_PreferenceGroup$removePreference(android.preference.Preference ), this, preference);
    }

    private boolean removePreferenceInt(Preference preference) {
        return (boolean)InvokeDynamicSupport.bootstrap("removePreferenceInt", $$robo$$android_preference_PreferenceGroup$removePreferenceInt(android.preference.Preference ), this, preference);
    }

    public void removeAll() {
        InvokeDynamicSupport.bootstrap("removeAll", $$robo$$android_preference_PreferenceGroup$removeAll(), this);
    }

    protected boolean onPrepareAddPreference(Preference preference) {
        return (boolean)InvokeDynamicSupport.bootstrap("onPrepareAddPreference", $$robo$$android_preference_PreferenceGroup$onPrepareAddPreference(android.preference.Preference ), this, preference);
    }

    public Preference findPreference(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("findPreference", $$robo$$android_preference_PreferenceGroup$findPreference(java.lang.CharSequence ), this, charSequence);
    }

    protected boolean isOnSameScreenAsChildren() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOnSameScreenAsChildren", $$robo$$android_preference_PreferenceGroup$isOnSameScreenAsChildren(), this);
    }

    @Override
    protected void onAttachedToActivity() {
        InvokeDynamicSupport.bootstrap("onAttachedToActivity", $$robo$$android_preference_PreferenceGroup$onAttachedToActivity(), this);
    }

    @Override
    protected void onPrepareForRemoval() {
        InvokeDynamicSupport.bootstrap("onPrepareForRemoval", $$robo$$android_preference_PreferenceGroup$onPrepareForRemoval(), this);
    }

    @Override
    public void notifyDependencyChange(boolean bl) {
        InvokeDynamicSupport.bootstrap("notifyDependencyChange", $$robo$$android_preference_PreferenceGroup$notifyDependencyChange(boolean ), this, bl);
    }

    void sortPreferences() {
        InvokeDynamicSupport.bootstrap("sortPreferences", $$robo$$android_preference_PreferenceGroup$sortPreferences(), this);
    }

    @Override
    protected void dispatchSaveInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchSaveInstanceState", $$robo$$android_preference_PreferenceGroup$dispatchSaveInstanceState(android.os.Bundle ), this, bundle);
    }

    @Override
    protected void dispatchRestoreInstanceState(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("dispatchRestoreInstanceState", $$robo$$android_preference_PreferenceGroup$dispatchRestoreInstanceState(android.os.Bundle ), this, bundle);
    }

    public /* synthetic */ PreferenceGroup() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PreferenceGroup)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

