/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.content.Context;
import android.content.pm.ParceledListSlice;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.print.IPrintManager;
import android.print.IPrinterDiscoveryObserver;
import android.print.PrinterId;
import android.print.PrinterInfo;
import android.util.ArrayMap;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PrinterDiscoverySession
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "PrinterDiscoverySession";
    private static int MSG_PRINTERS_ADDED = 1;
    private static int MSG_PRINTERS_REMOVED = 2;
    private LinkedHashMap<PrinterId, PrinterInfo> mPrinters;
    private IPrintManager mPrintManager;
    private int mUserId;
    private Handler mHandler;
    private IPrinterDiscoveryObserver mObserver;
    private OnPrintersChangeListener mListener;
    private boolean mIsPrinterDiscoveryStarted;

    private void $$robo$$android_print_PrinterDiscoverySession$__constructor__(IPrintManager printManager, Context context, int userId) {
        this.mPrinters = new LinkedHashMap();
        this.mPrintManager = printManager;
        this.mUserId = userId;
        this.mHandler = new SessionHandler(this, context.getMainLooper());
        this.mObserver = new PrinterDiscoveryObserver(this);
        try {
            this.mPrintManager.createPrinterDiscoverySession(this.mObserver, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e("PrinterDiscoverySession", "Error creating printer discovery session", re);
        }
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$startPrinterDiscovery(List<PrinterId> priorityList) {
        if (this.isDestroyed()) {
            Log.w("PrinterDiscoverySession", "Ignoring start printers discovery - session destroyed");
            return;
        }
        if (!this.mIsPrinterDiscoveryStarted) {
            this.mIsPrinterDiscoveryStarted = true;
            try {
                this.mPrintManager.startPrinterDiscovery(this.mObserver, priorityList, this.mUserId);
            }
            catch (RemoteException re) {
                Log.e("PrinterDiscoverySession", "Error starting printer discovery", re);
            }
        }
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$stopPrinterDiscovery() {
        if (this.isDestroyed()) {
            Log.w("PrinterDiscoverySession", "Ignoring stop printers discovery - session destroyed");
            return;
        }
        if (this.mIsPrinterDiscoveryStarted) {
            this.mIsPrinterDiscoveryStarted = false;
            try {
                this.mPrintManager.stopPrinterDiscovery(this.mObserver, this.mUserId);
            }
            catch (RemoteException re) {
                Log.e("PrinterDiscoverySession", "Error stopping printer discovery", re);
            }
        }
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$startPrinterStateTracking(PrinterId printerId) {
        if (this.isDestroyed()) {
            Log.w("PrinterDiscoverySession", "Ignoring start printer state tracking - session destroyed");
            return;
        }
        try {
            this.mPrintManager.startPrinterStateTracking(printerId, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e("PrinterDiscoverySession", "Error starting printer state tracking", re);
        }
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$stopPrinterStateTracking(PrinterId printerId) {
        if (this.isDestroyed()) {
            Log.w("PrinterDiscoverySession", "Ignoring stop printer state tracking - session destroyed");
            return;
        }
        try {
            this.mPrintManager.stopPrinterStateTracking(printerId, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e("PrinterDiscoverySession", "Error stopping printer state tracking", re);
        }
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$validatePrinters(List<PrinterId> printerIds) {
        if (this.isDestroyed()) {
            Log.w("PrinterDiscoverySession", "Ignoring validate printers - session destroyed");
            return;
        }
        try {
            this.mPrintManager.validatePrinters(printerIds, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e("PrinterDiscoverySession", "Error validating printers", re);
        }
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$destroy() {
        if (this.isDestroyed()) {
            Log.w("PrinterDiscoverySession", "Ignoring destroy - session destroyed");
        }
        this.destroyNoCheck();
    }

    private final List<PrinterInfo> $$robo$$android_print_PrinterDiscoverySession$getPrinters() {
        if (this.isDestroyed()) {
            Log.w("PrinterDiscoverySession", "Ignoring get printers - session destroyed");
            return Collections.emptyList();
        }
        return new ArrayList<PrinterInfo>(this.mPrinters.values());
    }

    private final boolean $$robo$$android_print_PrinterDiscoverySession$isDestroyed() {
        PrinterDiscoverySession.throwIfNotCalledOnMainThread();
        return this.isDestroyedNoCheck();
    }

    private final boolean $$robo$$android_print_PrinterDiscoverySession$isPrinterDiscoveryStarted() {
        PrinterDiscoverySession.throwIfNotCalledOnMainThread();
        return this.mIsPrinterDiscoveryStarted;
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$setOnPrintersChangeListener(OnPrintersChangeListener listener) {
        PrinterDiscoverySession.throwIfNotCalledOnMainThread();
        this.mListener = listener;
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$finalize() throws Throwable {
        if (!this.isDestroyedNoCheck()) {
            Log.e("PrinterDiscoverySession", "Destroying leaked printer discovery session");
            this.destroyNoCheck();
        }
        super.finalize();
    }

    private final boolean $$robo$$android_print_PrinterDiscoverySession$isDestroyedNoCheck() {
        return this.mObserver == null;
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$destroyNoCheck() {
        this.stopPrinterDiscovery();
        try {
            this.mPrintManager.destroyPrinterDiscoverySession(this.mObserver, this.mUserId);
        }
        catch (RemoteException re) {
            Log.e("PrinterDiscoverySession", "Error destroying printer discovery session", re);
        }
        finally {
            this.mObserver = null;
            this.mPrinters.clear();
        }
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$handlePrintersAdded(List<PrinterInfo> addedPrinters) {
        if (this.isDestroyed()) {
            return;
        }
        if (this.mPrinters.isEmpty()) {
            int printerCount = addedPrinters.size();
            for (int i = 0; i < printerCount; ++i) {
                PrinterInfo printer = addedPrinters.get(i);
                this.mPrinters.put(printer.getId(), printer);
            }
            this.notifyOnPrintersChanged();
            return;
        }
        ArrayMap<PrinterId, PrinterInfo> addedPrintersMap = new ArrayMap<PrinterId, PrinterInfo>();
        int printerCount = addedPrinters.size();
        for (int i = 0; i < printerCount; ++i) {
            PrinterInfo printer = addedPrinters.get(i);
            addedPrintersMap.put(printer.getId(), printer);
        }
        for (PrinterId oldPrinterId : this.mPrinters.keySet()) {
            PrinterInfo updatedPrinter = (PrinterInfo)addedPrintersMap.remove(oldPrinterId);
            if (updatedPrinter == null) continue;
            this.mPrinters.put(oldPrinterId, updatedPrinter);
        }
        this.mPrinters.putAll(addedPrintersMap);
        this.notifyOnPrintersChanged();
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$handlePrintersRemoved(List<PrinterId> printerIds) {
        if (this.isDestroyed()) {
            return;
        }
        boolean printersChanged = false;
        int removedPrinterIdCount = printerIds.size();
        for (int i = 0; i < removedPrinterIdCount; ++i) {
            PrinterId removedPrinterId = printerIds.get(i);
            if (this.mPrinters.remove(removedPrinterId) == null) continue;
            printersChanged = true;
        }
        if (printersChanged) {
            this.notifyOnPrintersChanged();
        }
    }

    private final void $$robo$$android_print_PrinterDiscoverySession$notifyOnPrintersChanged() {
        if (this.mListener != null) {
            this.mListener.onPrintersChanged();
        }
    }

    private static final void $$robo$$android_print_PrinterDiscoverySession$throwIfNotCalledOnMainThread() {
        if (!Looper.getMainLooper().isCurrentThread()) {
            throw new IllegalAccessError("must be called from the main thread");
        }
    }

    private void __constructor__(IPrintManager iPrintManager, Context context, int n) {
        this.$$robo$$android_print_PrinterDiscoverySession$__constructor__(iPrintManager, context, n);
    }

    public PrinterDiscoverySession(IPrintManager iPrintManager, Context context, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterDiscoverySession$__constructor__(android.print.IPrintManager android.content.Context int ), this, iPrintManager, context, n);
    }

    public void startPrinterDiscovery(List<PrinterId> list) {
        InvokeDynamicSupport.bootstrap("startPrinterDiscovery", $$robo$$android_print_PrinterDiscoverySession$startPrinterDiscovery(java.util.List<android.print.PrinterId> ), this, list);
    }

    public void stopPrinterDiscovery() {
        InvokeDynamicSupport.bootstrap("stopPrinterDiscovery", $$robo$$android_print_PrinterDiscoverySession$stopPrinterDiscovery(), this);
    }

    public void startPrinterStateTracking(PrinterId printerId) {
        InvokeDynamicSupport.bootstrap("startPrinterStateTracking", $$robo$$android_print_PrinterDiscoverySession$startPrinterStateTracking(android.print.PrinterId ), this, printerId);
    }

    public void stopPrinterStateTracking(PrinterId printerId) {
        InvokeDynamicSupport.bootstrap("stopPrinterStateTracking", $$robo$$android_print_PrinterDiscoverySession$stopPrinterStateTracking(android.print.PrinterId ), this, printerId);
    }

    public void validatePrinters(List<PrinterId> list) {
        InvokeDynamicSupport.bootstrap("validatePrinters", $$robo$$android_print_PrinterDiscoverySession$validatePrinters(java.util.List<android.print.PrinterId> ), this, list);
    }

    public void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_print_PrinterDiscoverySession$destroy(), this);
    }

    public List<PrinterInfo> getPrinters() {
        return InvokeDynamicSupport.bootstrap("getPrinters", $$robo$$android_print_PrinterDiscoverySession$getPrinters(), this);
    }

    public boolean isDestroyed() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDestroyed", $$robo$$android_print_PrinterDiscoverySession$isDestroyed(), this);
    }

    public boolean isPrinterDiscoveryStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrinterDiscoveryStarted", $$robo$$android_print_PrinterDiscoverySession$isPrinterDiscoveryStarted(), this);
    }

    public void setOnPrintersChangeListener(OnPrintersChangeListener onPrintersChangeListener) {
        InvokeDynamicSupport.bootstrap("setOnPrintersChangeListener", $$robo$$android_print_PrinterDiscoverySession$setOnPrintersChangeListener(android.print.PrinterDiscoverySession$OnPrintersChangeListener ), this, onPrintersChangeListener);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_print_PrinterDiscoverySession$finalize(), this);
    }

    private boolean isDestroyedNoCheck() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDestroyedNoCheck", $$robo$$android_print_PrinterDiscoverySession$isDestroyedNoCheck(), this);
    }

    private void destroyNoCheck() {
        InvokeDynamicSupport.bootstrap("destroyNoCheck", $$robo$$android_print_PrinterDiscoverySession$destroyNoCheck(), this);
    }

    private void handlePrintersAdded(List<PrinterInfo> list) {
        InvokeDynamicSupport.bootstrap("handlePrintersAdded", $$robo$$android_print_PrinterDiscoverySession$handlePrintersAdded(java.util.List<android.print.PrinterInfo> ), this, list);
    }

    private void handlePrintersRemoved(List<PrinterId> list) {
        InvokeDynamicSupport.bootstrap("handlePrintersRemoved", $$robo$$android_print_PrinterDiscoverySession$handlePrintersRemoved(java.util.List<android.print.PrinterId> ), this, list);
    }

    private void notifyOnPrintersChanged() {
        InvokeDynamicSupport.bootstrap("notifyOnPrintersChanged", $$robo$$android_print_PrinterDiscoverySession$notifyOnPrintersChanged(), this);
    }

    private static void throwIfNotCalledOnMainThread() {
        InvokeDynamicSupport.bootstrapStatic("throwIfNotCalledOnMainThread", $$robo$$android_print_PrinterDiscoverySession$throwIfNotCalledOnMainThread());
    }

    public /* synthetic */ PrinterDiscoverySession() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrinterDiscoverySession)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class PrinterDiscoveryObserver
    extends IPrinterDiscoveryObserver.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private WeakReference<PrinterDiscoverySession> mWeakSession;

        private void $$robo$$android_print_PrinterDiscoverySession_PrinterDiscoveryObserver$__constructor__(PrinterDiscoverySession session) {
            this.mWeakSession = new WeakReference<PrinterDiscoverySession>(session);
        }

        private final void $$robo$$android_print_PrinterDiscoverySession_PrinterDiscoveryObserver$onPrintersAdded(ParceledListSlice printers) {
            PrinterDiscoverySession session = (PrinterDiscoverySession)this.mWeakSession.get();
            if (session != null) {
                session.mHandler.obtainMessage(1, printers.getList()).sendToTarget();
            }
        }

        private final void $$robo$$android_print_PrinterDiscoverySession_PrinterDiscoveryObserver$onPrintersRemoved(ParceledListSlice printerIds) {
            PrinterDiscoverySession session = (PrinterDiscoverySession)this.mWeakSession.get();
            if (session != null) {
                session.mHandler.obtainMessage(2, printerIds.getList()).sendToTarget();
            }
        }

        private void __constructor__(PrinterDiscoverySession printerDiscoverySession) {
            this.$$robo$$android_print_PrinterDiscoverySession_PrinterDiscoveryObserver$__constructor__(printerDiscoverySession);
        }

        public PrinterDiscoveryObserver(PrinterDiscoverySession printerDiscoverySession) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterDiscoverySession_PrinterDiscoveryObserver$__constructor__(android.print.PrinterDiscoverySession ), this, printerDiscoverySession);
        }

        @Override
        public void onPrintersAdded(ParceledListSlice parceledListSlice) {
            InvokeDynamicSupport.bootstrap("onPrintersAdded", $$robo$$android_print_PrinterDiscoverySession_PrinterDiscoveryObserver$onPrintersAdded(android.content.pm.ParceledListSlice ), this, parceledListSlice);
        }

        @Override
        public void onPrintersRemoved(ParceledListSlice parceledListSlice) {
            InvokeDynamicSupport.bootstrap("onPrintersRemoved", $$robo$$android_print_PrinterDiscoverySession_PrinterDiscoveryObserver$onPrintersRemoved(android.content.pm.ParceledListSlice ), this, parceledListSlice);
        }

        public /* synthetic */ PrinterDiscoveryObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrinterDiscoveryObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class SessionHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ PrinterDiscoverySession this$0;

        private void $$robo$$android_print_PrinterDiscoverySession_SessionHandler$__constructor__(PrinterDiscoverySession printerDiscoverySession, Looper looper) {
        }

        private final void $$robo$$android_print_PrinterDiscoverySession_SessionHandler$handleMessage(Message message) {
            switch (message.what) {
                case 1: {
                    List printers = (List)message.obj;
                    this.this$0.handlePrintersAdded(printers);
                    break;
                }
                case 2: {
                    List printerIds = (List)message.obj;
                    this.this$0.handlePrintersRemoved(printerIds);
                }
            }
        }

        private void __constructor__(PrinterDiscoverySession printerDiscoverySession, Looper looper) {
            this.$$robo$$android_print_PrinterDiscoverySession_SessionHandler$__constructor__(printerDiscoverySession, looper);
        }

        public SessionHandler(PrinterDiscoverySession printerDiscoverySession, Looper looper) {
            this.this$0 = printerDiscoverySession;
            super(looper, null, false);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterDiscoverySession_SessionHandler$__constructor__(android.print.PrinterDiscoverySession android.os.Looper ), this, printerDiscoverySession, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_print_PrinterDiscoverySession_SessionHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ SessionHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SessionHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnPrintersChangeListener
    extends InstrumentedInterface {
        public void onPrintersChanged();
    }
}

