/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.annotation.IntDef;
import android.app.PendingIntent;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import android.print.PrintManager;
import android.print.PrinterCapabilitiesInfo;
import android.print.PrinterId;
import android.text.TextUtils;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PrinterInfo
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static int STATUS_IDLE = 1;
    public static int STATUS_BUSY = 2;
    public static int STATUS_UNAVAILABLE = 3;
    private PrinterId mId;
    private int mIconResourceId;
    private boolean mHasCustomPrinterIcon;
    private int mCustomPrinterIconGen;
    private PendingIntent mInfoIntent;
    private String mName;
    private int mStatus;
    private String mDescription;
    private PrinterCapabilitiesInfo mCapabilities;
    public static Parcelable.Creator<PrinterInfo> CREATOR;

    private void $$robo$$android_print_PrinterInfo$__constructor__(PrinterId printerId, String name, int status, int iconResourceId, boolean hasCustomPrinterIcon, String description, PendingIntent infoIntent, PrinterCapabilitiesInfo capabilities, int customPrinterIconGen) {
        this.mId = printerId;
        this.mName = name;
        this.mStatus = status;
        this.mIconResourceId = iconResourceId;
        this.mHasCustomPrinterIcon = hasCustomPrinterIcon;
        this.mDescription = description;
        this.mInfoIntent = infoIntent;
        this.mCapabilities = capabilities;
        this.mCustomPrinterIconGen = customPrinterIconGen;
    }

    private final PrinterId $$robo$$android_print_PrinterInfo$getId() {
        return this.mId;
    }

    private final Drawable $$robo$$android_print_PrinterInfo$loadIcon(Context context) {
        PrintManager printManager;
        Icon icon;
        Drawable drawable2 = null;
        PackageManager packageManager = context.getPackageManager();
        if (this.mHasCustomPrinterIcon && (icon = (printManager = (PrintManager)context.getSystemService("print")).getCustomPrinterIcon(this.mId)) != null) {
            drawable2 = icon.loadDrawable(context);
        }
        if (drawable2 == null) {
            try {
                String packageName = this.mId.getServiceName().getPackageName();
                PackageInfo packageInfo = packageManager.getPackageInfo(packageName, 0);
                ApplicationInfo appInfo = packageInfo.applicationInfo;
                if (this.mIconResourceId != 0) {
                    drawable2 = packageManager.getDrawable(packageName, this.mIconResourceId, appInfo);
                }
                if (drawable2 == null) {
                    drawable2 = appInfo.loadIcon(packageManager);
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        return drawable2;
    }

    private final boolean $$robo$$android_print_PrinterInfo$getHasCustomPrinterIcon() {
        return this.mHasCustomPrinterIcon;
    }

    private final String $$robo$$android_print_PrinterInfo$getName() {
        return this.mName;
    }

    private final int $$robo$$android_print_PrinterInfo$getStatus() {
        return this.mStatus;
    }

    private final String $$robo$$android_print_PrinterInfo$getDescription() {
        return this.mDescription;
    }

    private final PendingIntent $$robo$$android_print_PrinterInfo$getInfoIntent() {
        return this.mInfoIntent;
    }

    private final PrinterCapabilitiesInfo $$robo$$android_print_PrinterInfo$getCapabilities() {
        return this.mCapabilities;
    }

    private static final PrinterId $$robo$$android_print_PrinterInfo$checkPrinterId(PrinterId printerId) {
        return Preconditions.checkNotNull(printerId, "printerId cannot be null.");
    }

    private static final int $$robo$$android_print_PrinterInfo$checkStatus(int status) {
        if (status != 1 && status != 2 && status != 3) {
            throw new IllegalArgumentException("status is invalid.");
        }
        return status;
    }

    private static final String $$robo$$android_print_PrinterInfo$checkName(String name) {
        return Preconditions.checkStringNotEmpty(name, "name cannot be empty.");
    }

    private void $$robo$$android_print_PrinterInfo$__constructor__(Parcel parcel) {
        this.mId = PrinterInfo.checkPrinterId((PrinterId)parcel.readParcelable(null));
        this.mName = PrinterInfo.checkName(parcel.readString());
        this.mStatus = PrinterInfo.checkStatus(parcel.readInt());
        this.mDescription = parcel.readString();
        this.mCapabilities = (PrinterCapabilitiesInfo)parcel.readParcelable(null);
        this.mIconResourceId = parcel.readInt();
        this.mHasCustomPrinterIcon = parcel.readByte() != 0;
        this.mCustomPrinterIconGen = parcel.readInt();
        this.mInfoIntent = (PendingIntent)parcel.readParcelable(null);
    }

    private final int $$robo$$android_print_PrinterInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_print_PrinterInfo$writeToParcel(Parcel parcel, int flags) {
        parcel.writeParcelable(this.mId, flags);
        parcel.writeString(this.mName);
        parcel.writeInt(this.mStatus);
        parcel.writeString(this.mDescription);
        parcel.writeParcelable(this.mCapabilities, flags);
        parcel.writeInt(this.mIconResourceId);
        parcel.writeByte((byte)(this.mHasCustomPrinterIcon ? 1 : 0));
        parcel.writeInt(this.mCustomPrinterIconGen);
        parcel.writeParcelable(this.mInfoIntent, flags);
    }

    private final int $$robo$$android_print_PrinterInfo$hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.mId.hashCode();
        result = 31 * result + this.mName.hashCode();
        result = 31 * result + this.mStatus;
        result = 31 * result + (this.mDescription != null ? this.mDescription.hashCode() : 0);
        result = 31 * result + (this.mCapabilities != null ? this.mCapabilities.hashCode() : 0);
        result = 31 * result + this.mIconResourceId;
        result = 31 * result + (this.mHasCustomPrinterIcon ? 1 : 0);
        result = 31 * result + this.mCustomPrinterIconGen;
        result = 31 * result + (this.mInfoIntent != null ? this.mInfoIntent.hashCode() : 0);
        return result;
    }

    private final boolean $$robo$$android_print_PrinterInfo$equalsIgnoringStatus(PrinterInfo other) {
        if (!this.mId.equals(other.mId)) {
            return false;
        }
        if (!this.mName.equals(other.mName)) {
            return false;
        }
        if (!TextUtils.equals(this.mDescription, other.mDescription)) {
            return false;
        }
        if (this.mCapabilities == null ? other.mCapabilities != null : !this.mCapabilities.equals(other.mCapabilities)) {
            return false;
        }
        if (this.mIconResourceId != other.mIconResourceId) {
            return false;
        }
        if (this.mHasCustomPrinterIcon != other.mHasCustomPrinterIcon) {
            return false;
        }
        if (this.mCustomPrinterIconGen != other.mCustomPrinterIconGen) {
            return false;
        }
        return !(this.mInfoIntent == null ? other.mInfoIntent != null : !this.mInfoIntent.equals(other.mInfoIntent));
    }

    private final boolean $$robo$$android_print_PrinterInfo$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrinterInfo other = (PrinterInfo)obj;
        if (!this.equalsIgnoringStatus(other)) {
            return false;
        }
        return this.mStatus == other.mStatus;
    }

    private final String $$robo$$android_print_PrinterInfo$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrinterInfo{");
        builder.append("id=").append(this.mId);
        builder.append(", name=").append(this.mName);
        builder.append(", status=").append(this.mStatus);
        builder.append(", description=").append(this.mDescription);
        builder.append(", capabilities=").append(this.mCapabilities);
        builder.append(", iconResId=").append(this.mIconResourceId);
        builder.append(", hasCustomPrinterIcon=").append(this.mHasCustomPrinterIcon);
        builder.append(", customPrinterIconGen=").append(this.mCustomPrinterIconGen);
        builder.append(", infoIntent=").append(this.mInfoIntent);
        builder.append("\"}");
        return builder.toString();
    }

    private /* synthetic */ void $$robo$$android_print_PrinterInfo$__constructor__(PrinterId x0, String x1, int x2, int x3, boolean x4, String x5, PendingIntent x6, PrinterCapabilitiesInfo x7, int x8, 1 x9) {
    }

    private /* synthetic */ void $$robo$$android_print_PrinterInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<PrinterInfo>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_print_PrinterInfo_1$__constructor__() {
            }

            private final PrinterInfo $$robo$$android_print_PrinterInfo_1$createFromParcel(Parcel parcel) {
                return new PrinterInfo(parcel, null);
            }

            private final PrinterInfo[] $$robo$$android_print_PrinterInfo_1$newArray(int size) {
                return new PrinterInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_print_PrinterInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterInfo_1$__constructor__(), this);
            }

            @Override
            public PrinterInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_print_PrinterInfo_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public PrinterInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_print_PrinterInfo_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(PrinterId printerId, String string2, int n, int n2, boolean bl, String string3, PendingIntent pendingIntent, PrinterCapabilitiesInfo printerCapabilitiesInfo, int n3) {
        this.$$robo$$android_print_PrinterInfo$__constructor__(printerId, string2, n, n2, bl, string3, pendingIntent, printerCapabilitiesInfo, n3);
    }

    public PrinterInfo(PrinterId printerId, String string2, int n, int n2, boolean bl, String string3, PendingIntent pendingIntent, PrinterCapabilitiesInfo printerCapabilitiesInfo, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterInfo$__constructor__(android.print.PrinterId java.lang.String int int boolean java.lang.String android.app.PendingIntent android.print.PrinterCapabilitiesInfo int ), this, printerId, string2, n, n2, bl, string3, pendingIntent, printerCapabilitiesInfo, n3);
    }

    public PrinterId getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_print_PrinterInfo$getId(), this);
    }

    public Drawable loadIcon(Context context) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_print_PrinterInfo$loadIcon(android.content.Context ), this, context);
    }

    public boolean getHasCustomPrinterIcon() {
        return (boolean)InvokeDynamicSupport.bootstrap("getHasCustomPrinterIcon", $$robo$$android_print_PrinterInfo$getHasCustomPrinterIcon(), this);
    }

    public String getName() {
        return InvokeDynamicSupport.bootstrap("getName", $$robo$$android_print_PrinterInfo$getName(), this);
    }

    public int getStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStatus", $$robo$$android_print_PrinterInfo$getStatus(), this);
    }

    public String getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_print_PrinterInfo$getDescription(), this);
    }

    public PendingIntent getInfoIntent() {
        return InvokeDynamicSupport.bootstrap("getInfoIntent", $$robo$$android_print_PrinterInfo$getInfoIntent(), this);
    }

    public PrinterCapabilitiesInfo getCapabilities() {
        return InvokeDynamicSupport.bootstrap("getCapabilities", $$robo$$android_print_PrinterInfo$getCapabilities(), this);
    }

    private static PrinterId checkPrinterId(PrinterId printerId) {
        return InvokeDynamicSupport.bootstrapStatic("checkPrinterId", $$robo$$android_print_PrinterInfo$checkPrinterId(android.print.PrinterId ), (PrinterId)printerId);
    }

    private static int checkStatus(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("checkStatus", $$robo$$android_print_PrinterInfo$checkStatus(int ), (int)n);
    }

    private static String checkName(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("checkName", $$robo$$android_print_PrinterInfo$checkName(java.lang.String ), (String)string2);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_print_PrinterInfo$__constructor__(parcel);
    }

    public PrinterInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterInfo$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_print_PrinterInfo$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_print_PrinterInfo$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_print_PrinterInfo$hashCode(), this);
    }

    public boolean equalsIgnoringStatus(PrinterInfo printerInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("equalsIgnoringStatus", $$robo$$android_print_PrinterInfo$equalsIgnoringStatus(android.print.PrinterInfo ), this, printerInfo);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_print_PrinterInfo$equals(java.lang.Object ), this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_print_PrinterInfo$toString(), this);
    }

    private /* synthetic */ void __constructor__(PrinterId printerId, String string2, int n, int n2, boolean bl, String string3, PendingIntent pendingIntent, PrinterCapabilitiesInfo printerCapabilitiesInfo, int n3, 1 var10_10) {
        this.$$robo$$android_print_PrinterInfo$__constructor__(printerId, string2, n, n2, bl, string3, pendingIntent, printerCapabilitiesInfo, n3, var10_10);
    }

    public /* synthetic */ PrinterInfo(PrinterId printerId, String string2, int n, int n2, boolean bl, String string3, PendingIntent pendingIntent, PrinterCapabilitiesInfo printerCapabilitiesInfo, int n3, 1 var10_10) {
        this(printerId, string2, n, n2, bl, string3, pendingIntent, printerCapabilitiesInfo, n3);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterInfo$__constructor__(android.print.PrinterId java.lang.String int int boolean java.lang.String android.app.PendingIntent android.print.PrinterCapabilitiesInfo int android.print.PrinterInfo$1 ), this, printerId, string2, n, n2, bl, string3, pendingIntent, printerCapabilitiesInfo, n3, var10_10);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_print_PrinterInfo$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ PrinterInfo(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterInfo$__constructor__(android.os.Parcel android.print.PrinterInfo$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(PrinterInfo.class);
    }

    public /* synthetic */ PrinterInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrinterInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private PrinterId mPrinterId;
        private String mName;
        private int mStatus;
        private int mIconResourceId;
        private boolean mHasCustomPrinterIcon;
        private String mDescription;
        private PendingIntent mInfoIntent;
        private PrinterCapabilitiesInfo mCapabilities;
        private int mCustomPrinterIconGen;

        private void $$robo$$android_print_PrinterInfo_Builder$__constructor__(PrinterId printerId, String name, int status) {
            this.mPrinterId = PrinterInfo.checkPrinterId(printerId);
            this.mName = PrinterInfo.checkName(name);
            this.mStatus = PrinterInfo.checkStatus(status);
        }

        private void $$robo$$android_print_PrinterInfo_Builder$__constructor__(PrinterInfo other) {
            this.mPrinterId = other.mId;
            this.mName = other.mName;
            this.mStatus = other.mStatus;
            this.mIconResourceId = other.mIconResourceId;
            this.mHasCustomPrinterIcon = other.mHasCustomPrinterIcon;
            this.mDescription = other.mDescription;
            this.mInfoIntent = other.mInfoIntent;
            this.mCapabilities = other.mCapabilities;
            this.mCustomPrinterIconGen = other.mCustomPrinterIconGen;
        }

        private final Builder $$robo$$android_print_PrinterInfo_Builder$setStatus(int status) {
            this.mStatus = PrinterInfo.checkStatus(status);
            return this;
        }

        private final Builder $$robo$$android_print_PrinterInfo_Builder$setIconResourceId(int iconResourceId) {
            this.mIconResourceId = Preconditions.checkArgumentNonnegative(iconResourceId, "iconResourceId can't be negative");
            return this;
        }

        private final Builder $$robo$$android_print_PrinterInfo_Builder$setHasCustomPrinterIcon(boolean hasCustomPrinterIcon) {
            this.mHasCustomPrinterIcon = hasCustomPrinterIcon;
            return this;
        }

        private final Builder $$robo$$android_print_PrinterInfo_Builder$setName(String name) {
            this.mName = PrinterInfo.checkName(name);
            return this;
        }

        private final Builder $$robo$$android_print_PrinterInfo_Builder$setDescription(String description) {
            this.mDescription = description;
            return this;
        }

        private final Builder $$robo$$android_print_PrinterInfo_Builder$setInfoIntent(PendingIntent infoIntent) {
            this.mInfoIntent = infoIntent;
            return this;
        }

        private final Builder $$robo$$android_print_PrinterInfo_Builder$setCapabilities(PrinterCapabilitiesInfo capabilities) {
            this.mCapabilities = capabilities;
            return this;
        }

        private final PrinterInfo $$robo$$android_print_PrinterInfo_Builder$build() {
            return new PrinterInfo(this.mPrinterId, this.mName, this.mStatus, this.mIconResourceId, this.mHasCustomPrinterIcon, this.mDescription, this.mInfoIntent, this.mCapabilities, this.mCustomPrinterIconGen, null);
        }

        private final Builder $$robo$$android_print_PrinterInfo_Builder$incCustomPrinterIconGen() {
            ++this.mCustomPrinterIconGen;
            return this;
        }

        private void __constructor__(PrinterId printerId, String string2, int n) {
            this.$$robo$$android_print_PrinterInfo_Builder$__constructor__(printerId, string2, n);
        }

        public Builder(PrinterId printerId, String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterInfo_Builder$__constructor__(android.print.PrinterId java.lang.String int ), this, printerId, string2, n);
        }

        private void __constructor__(PrinterInfo printerInfo) {
            this.$$robo$$android_print_PrinterInfo_Builder$__constructor__(printerInfo);
        }

        public Builder(PrinterInfo printerInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterInfo_Builder$__constructor__(android.print.PrinterInfo ), this, printerInfo);
        }

        public Builder setStatus(int n) {
            return InvokeDynamicSupport.bootstrap("setStatus", $$robo$$android_print_PrinterInfo_Builder$setStatus(int ), this, n);
        }

        public Builder setIconResourceId(int n) {
            return InvokeDynamicSupport.bootstrap("setIconResourceId", $$robo$$android_print_PrinterInfo_Builder$setIconResourceId(int ), this, n);
        }

        public Builder setHasCustomPrinterIcon(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setHasCustomPrinterIcon", $$robo$$android_print_PrinterInfo_Builder$setHasCustomPrinterIcon(boolean ), this, bl);
        }

        public Builder setName(String string2) {
            return InvokeDynamicSupport.bootstrap("setName", $$robo$$android_print_PrinterInfo_Builder$setName(java.lang.String ), this, string2);
        }

        public Builder setDescription(String string2) {
            return InvokeDynamicSupport.bootstrap("setDescription", $$robo$$android_print_PrinterInfo_Builder$setDescription(java.lang.String ), this, string2);
        }

        public Builder setInfoIntent(PendingIntent pendingIntent) {
            return InvokeDynamicSupport.bootstrap("setInfoIntent", $$robo$$android_print_PrinterInfo_Builder$setInfoIntent(android.app.PendingIntent ), this, pendingIntent);
        }

        public Builder setCapabilities(PrinterCapabilitiesInfo printerCapabilitiesInfo) {
            return InvokeDynamicSupport.bootstrap("setCapabilities", $$robo$$android_print_PrinterInfo_Builder$setCapabilities(android.print.PrinterCapabilitiesInfo ), this, printerCapabilitiesInfo);
        }

        public PrinterInfo build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_print_PrinterInfo_Builder$build(), this);
        }

        public Builder incCustomPrinterIconGen() {
            return InvokeDynamicSupport.bootstrap("incCustomPrinterIconGen", $$robo$$android_print_PrinterInfo_Builder$incCustomPrinterIconGen(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L, 3L})
    public static @interface Status {
    }
}

