/*
 * Decompiled with CFR 0.152.
 */
package android.printservice;

import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.print.PrintJobInfo;
import android.print.PrinterId;
import android.printservice.IPrintServiceClient;
import android.printservice.PrintJob;
import android.printservice.PrinterDiscoverySession;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class PrintService
extends Service
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "PrintService";
    private static boolean DEBUG = false;
    public static String SERVICE_INTERFACE = "android.printservice.PrintService";
    public static String SERVICE_META_DATA = "android.printservice";
    public static String EXTRA_PRINT_JOB_INFO = "android.intent.extra.print.PRINT_JOB_INFO";
    public static String EXTRA_PRINTER_INFO = "android.intent.extra.print.EXTRA_PRINTER_INFO";
    public static String EXTRA_PRINT_DOCUMENT_INFO = "android.printservice.extra.PRINT_DOCUMENT_INFO";
    public static String EXTRA_CAN_SELECT_PRINTER = "android.printservice.extra.CAN_SELECT_PRINTER";
    public static String EXTRA_SELECT_PRINTER = "android.printservice.extra.SELECT_PRINTER";
    private Handler mHandler;
    private IPrintServiceClient mClient;
    private int mLastSessionId;
    private PrinterDiscoverySession mDiscoverySession;

    private void $$robo$$android_printservice_PrintService$__constructor__() {
        this.mLastSessionId = -1;
    }

    private final void $$robo$$android_printservice_PrintService$attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.mHandler = new ServiceHandler(this, base.getMainLooper());
    }

    private final void $$robo$$android_printservice_PrintService$onConnected() {
    }

    private final void $$robo$$android_printservice_PrintService$onDisconnected() {
    }

    protected abstract PrinterDiscoverySession onCreatePrinterDiscoverySession();

    protected abstract void onRequestCancelPrintJob(PrintJob var1);

    protected abstract void onPrintJobQueued(PrintJob var1);

    private final List<PrintJob> $$robo$$android_printservice_PrintService$getActivePrintJobs() {
        PrintService.throwIfNotCalledOnMainThread();
        if (this.mClient == null) {
            return Collections.emptyList();
        }
        try {
            ArrayList<PrintJob> printJobs = null;
            List<PrintJobInfo> printJobInfos = this.mClient.getPrintJobInfos();
            if (printJobInfos != null) {
                int printJobInfoCount = printJobInfos.size();
                printJobs = new ArrayList<PrintJob>(printJobInfoCount);
                for (int i = 0; i < printJobInfoCount; ++i) {
                    printJobs.add(new PrintJob(this, printJobInfos.get(i), this.mClient));
                }
            }
            if (printJobs != null) {
                return printJobs;
            }
        }
        catch (RemoteException re) {
            Log.e("PrintService", "Error calling getPrintJobs()", re);
        }
        return Collections.emptyList();
    }

    private final PrinterId $$robo$$android_printservice_PrintService$generatePrinterId(String localId) {
        PrintService.throwIfNotCalledOnMainThread();
        localId = Preconditions.checkNotNull(localId, "localId cannot be null");
        return new PrinterId(new ComponentName(this.getPackageName(), this.getClass().getName()), localId);
    }

    private static final void $$robo$$android_printservice_PrintService$throwIfNotCalledOnMainThread() {
        if (!Looper.getMainLooper().isCurrentThread()) {
            throw new IllegalAccessError("must be called from the main thread");
        }
    }

    private final IBinder $$robo$$android_printservice_PrintService$onBind(Intent intent) {
        return new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ PrintService this$0;

            private void $$robo$$android_printservice_PrintService_1$__constructor__(PrintService this$0) {
            }

            private final void $$robo$$android_printservice_PrintService_1$createPrinterDiscoverySession() {
                this.this$0.mHandler.sendEmptyMessage(1);
            }

            private final void $$robo$$android_printservice_PrintService_1$destroyPrinterDiscoverySession() {
                this.this$0.mHandler.sendEmptyMessage(2);
            }

            private final void $$robo$$android_printservice_PrintService_1$startPrinterDiscovery(List<PrinterId> priorityList) {
                this.this$0.mHandler.obtainMessage(3, priorityList).sendToTarget();
            }

            private final void $$robo$$android_printservice_PrintService_1$stopPrinterDiscovery() {
                this.this$0.mHandler.sendEmptyMessage(4);
            }

            private final void $$robo$$android_printservice_PrintService_1$validatePrinters(List<PrinterId> printerIds) {
                this.this$0.mHandler.obtainMessage(5, printerIds).sendToTarget();
            }

            private final void $$robo$$android_printservice_PrintService_1$startPrinterStateTracking(PrinterId printerId) {
                this.this$0.mHandler.obtainMessage(6, printerId).sendToTarget();
            }

            private final void $$robo$$android_printservice_PrintService_1$requestCustomPrinterIcon(PrinterId printerId) {
                this.this$0.mHandler.obtainMessage(7, printerId).sendToTarget();
            }

            private final void $$robo$$android_printservice_PrintService_1$stopPrinterStateTracking(PrinterId printerId) {
                this.this$0.mHandler.obtainMessage(8, printerId).sendToTarget();
            }

            private final void $$robo$$android_printservice_PrintService_1$setClient(IPrintServiceClient client) {
                this.this$0.mHandler.obtainMessage(11, client).sendToTarget();
            }

            private final void $$robo$$android_printservice_PrintService_1$requestCancelPrintJob(PrintJobInfo printJobInfo) {
                this.this$0.mHandler.obtainMessage(10, printJobInfo).sendToTarget();
            }

            private final void $$robo$$android_printservice_PrintService_1$onPrintJobQueued(PrintJobInfo printJobInfo) {
                this.this$0.mHandler.obtainMessage(9, printJobInfo).sendToTarget();
            }

            private void __constructor__(PrintService printService) {
                this.$$robo$$android_printservice_PrintService_1$__constructor__(printService);
            }
            {
                this.this$0 = printService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_printservice_PrintService_1$__constructor__(android.printservice.PrintService ), this, printService);
            }

            @Override
            public void createPrinterDiscoverySession() {
                InvokeDynamicSupport.bootstrap("createPrinterDiscoverySession", $$robo$$android_printservice_PrintService_1$createPrinterDiscoverySession(), this);
            }

            @Override
            public void destroyPrinterDiscoverySession() {
                InvokeDynamicSupport.bootstrap("destroyPrinterDiscoverySession", $$robo$$android_printservice_PrintService_1$destroyPrinterDiscoverySession(), this);
            }

            @Override
            public void startPrinterDiscovery(List<PrinterId> list) {
                InvokeDynamicSupport.bootstrap("startPrinterDiscovery", $$robo$$android_printservice_PrintService_1$startPrinterDiscovery(java.util.List<android.print.PrinterId> ), this, list);
            }

            @Override
            public void stopPrinterDiscovery() {
                InvokeDynamicSupport.bootstrap("stopPrinterDiscovery", $$robo$$android_printservice_PrintService_1$stopPrinterDiscovery(), this);
            }

            @Override
            public void validatePrinters(List<PrinterId> list) {
                InvokeDynamicSupport.bootstrap("validatePrinters", $$robo$$android_printservice_PrintService_1$validatePrinters(java.util.List<android.print.PrinterId> ), this, list);
            }

            @Override
            public void startPrinterStateTracking(PrinterId printerId) {
                InvokeDynamicSupport.bootstrap("startPrinterStateTracking", $$robo$$android_printservice_PrintService_1$startPrinterStateTracking(android.print.PrinterId ), this, printerId);
            }

            @Override
            public void requestCustomPrinterIcon(PrinterId printerId) {
                InvokeDynamicSupport.bootstrap("requestCustomPrinterIcon", $$robo$$android_printservice_PrintService_1$requestCustomPrinterIcon(android.print.PrinterId ), this, printerId);
            }

            @Override
            public void stopPrinterStateTracking(PrinterId printerId) {
                InvokeDynamicSupport.bootstrap("stopPrinterStateTracking", $$robo$$android_printservice_PrintService_1$stopPrinterStateTracking(android.print.PrinterId ), this, printerId);
            }

            @Override
            public void setClient(IPrintServiceClient iPrintServiceClient) {
                InvokeDynamicSupport.bootstrap("setClient", $$robo$$android_printservice_PrintService_1$setClient(android.printservice.IPrintServiceClient ), this, iPrintServiceClient);
            }

            @Override
            public void requestCancelPrintJob(PrintJobInfo printJobInfo) {
                InvokeDynamicSupport.bootstrap("requestCancelPrintJob", $$robo$$android_printservice_PrintService_1$requestCancelPrintJob(android.print.PrintJobInfo ), this, printJobInfo);
            }

            @Override
            public void onPrintJobQueued(PrintJobInfo printJobInfo) {
                InvokeDynamicSupport.bootstrap("onPrintJobQueued", $$robo$$android_printservice_PrintService_1$onPrintJobQueued(android.print.PrintJobInfo ), this, printJobInfo);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_printservice_PrintService$__constructor__();
    }

    public PrintService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_printservice_PrintService$__constructor__(), this);
    }

    @Override
    protected void attachBaseContext(Context context) {
        InvokeDynamicSupport.bootstrap("attachBaseContext", $$robo$$android_printservice_PrintService$attachBaseContext(android.content.Context ), this, context);
    }

    protected void onConnected() {
        InvokeDynamicSupport.bootstrap("onConnected", $$robo$$android_printservice_PrintService$onConnected(), this);
    }

    protected void onDisconnected() {
        InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_printservice_PrintService$onDisconnected(), this);
    }

    public List<PrintJob> getActivePrintJobs() {
        return InvokeDynamicSupport.bootstrap("getActivePrintJobs", $$robo$$android_printservice_PrintService$getActivePrintJobs(), this);
    }

    public PrinterId generatePrinterId(String string2) {
        return InvokeDynamicSupport.bootstrap("generatePrinterId", $$robo$$android_printservice_PrintService$generatePrinterId(java.lang.String ), this, string2);
    }

    static void throwIfNotCalledOnMainThread() {
        InvokeDynamicSupport.bootstrapStatic("throwIfNotCalledOnMainThread", $$robo$$android_printservice_PrintService$throwIfNotCalledOnMainThread());
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_printservice_PrintService$onBind(android.content.Intent ), this, intent);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrintService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class ServiceHandler
    extends Handler
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int MSG_CREATE_PRINTER_DISCOVERY_SESSION = 1;
        public static int MSG_DESTROY_PRINTER_DISCOVERY_SESSION = 2;
        public static int MSG_START_PRINTER_DISCOVERY = 3;
        public static int MSG_STOP_PRINTER_DISCOVERY = 4;
        public static int MSG_VALIDATE_PRINTERS = 5;
        public static int MSG_START_PRINTER_STATE_TRACKING = 6;
        public static int MSG_REQUEST_CUSTOM_PRINTER_ICON = 7;
        public static int MSG_STOP_PRINTER_STATE_TRACKING = 8;
        public static int MSG_ON_PRINTJOB_QUEUED = 9;
        public static int MSG_ON_REQUEST_CANCEL_PRINTJOB = 10;
        public static int MSG_SET_CLIENT = 11;
        /* synthetic */ PrintService this$0;

        private void $$robo$$android_printservice_PrintService_ServiceHandler$__constructor__(PrintService printService, Looper looper) {
        }

        private final void $$robo$$android_printservice_PrintService_ServiceHandler$handleMessage(Message message) {
            int action = message.what;
            switch (action) {
                case 1: {
                    PrinterDiscoverySession session = this.this$0.onCreatePrinterDiscoverySession();
                    if (session == null) {
                        throw new NullPointerException("session cannot be null");
                    }
                    if (session.getId() == this.this$0.mLastSessionId) {
                        throw new IllegalStateException("cannot reuse session instances");
                    }
                    this.this$0.mDiscoverySession = session;
                    this.this$0.mLastSessionId = session.getId();
                    session.setObserver(this.this$0.mClient);
                    break;
                }
                case 2: {
                    if (this.this$0.mDiscoverySession == null) break;
                    this.this$0.mDiscoverySession.destroy();
                    this.this$0.mDiscoverySession = null;
                    break;
                }
                case 3: {
                    if (this.this$0.mDiscoverySession == null) break;
                    ArrayList priorityList = (ArrayList)message.obj;
                    this.this$0.mDiscoverySession.startPrinterDiscovery(priorityList);
                    break;
                }
                case 4: {
                    if (this.this$0.mDiscoverySession == null) break;
                    this.this$0.mDiscoverySession.stopPrinterDiscovery();
                    break;
                }
                case 5: {
                    if (this.this$0.mDiscoverySession == null) break;
                    List printerIds = (List)message.obj;
                    this.this$0.mDiscoverySession.validatePrinters(printerIds);
                    break;
                }
                case 6: {
                    if (this.this$0.mDiscoverySession == null) break;
                    PrinterId printerId = (PrinterId)message.obj;
                    this.this$0.mDiscoverySession.startPrinterStateTracking(printerId);
                    break;
                }
                case 7: {
                    if (this.this$0.mDiscoverySession == null) break;
                    PrinterId printerId = (PrinterId)message.obj;
                    this.this$0.mDiscoverySession.requestCustomPrinterIcon(printerId);
                    break;
                }
                case 8: {
                    if (this.this$0.mDiscoverySession == null) break;
                    PrinterId printerId = (PrinterId)message.obj;
                    this.this$0.mDiscoverySession.stopPrinterStateTracking(printerId);
                    break;
                }
                case 10: {
                    PrintJobInfo printJobInfo = (PrintJobInfo)message.obj;
                    this.this$0.onRequestCancelPrintJob(new PrintJob(this.this$0, printJobInfo, this.this$0.mClient));
                    break;
                }
                case 9: {
                    PrintJobInfo printJobInfo = (PrintJobInfo)message.obj;
                    this.this$0.onPrintJobQueued(new PrintJob(this.this$0, printJobInfo, this.this$0.mClient));
                    break;
                }
                case 11: {
                    this.this$0.mClient = (IPrintServiceClient)message.obj;
                    if (this.this$0.mClient != null) {
                        this.this$0.onConnected();
                        break;
                    }
                    this.this$0.onDisconnected();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown message: " + action);
                }
            }
        }

        private void __constructor__(PrintService printService, Looper looper) {
            this.$$robo$$android_printservice_PrintService_ServiceHandler$__constructor__(printService, looper);
        }

        public ServiceHandler(PrintService printService, Looper looper) {
            this.this$0 = printService;
            super(looper, null, true);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_printservice_PrintService_ServiceHandler$__constructor__(android.printservice.PrintService android.os.Looper ), this, printService, looper);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_printservice_PrintService_ServiceHandler$handleMessage(android.os.Message ), this, message);
        }

        public /* synthetic */ ServiceHandler() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceHandler)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

