/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ClipDescription;
import android.content.ContentProvider;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.IntentSender;
import android.content.UriMatcher;
import android.content.pm.ProviderInfo;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.graphics.Point;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.ParcelableException;
import android.provider.DocumentsContract;
import android.util.Log;
import java.io.FileNotFoundException;
import java.util.LinkedList;
import java.util.Objects;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class DocumentsProvider
extends ContentProvider
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "DocumentsProvider";
    private static int MATCH_ROOTS = 1;
    private static int MATCH_ROOT = 2;
    private static int MATCH_RECENT = 3;
    private static int MATCH_SEARCH = 4;
    private static int MATCH_DOCUMENT = 5;
    private static int MATCH_CHILDREN = 6;
    private static int MATCH_DOCUMENT_TREE = 7;
    private static int MATCH_CHILDREN_TREE = 8;
    private String mAuthority;
    private UriMatcher mMatcher;

    private void $$robo$$android_provider_DocumentsProvider$__constructor__() {
    }

    private final void $$robo$$android_provider_DocumentsProvider$attachInfo(Context context, ProviderInfo info) {
        this.registerAuthority(info.authority);
        if (!info.exported) {
            throw new SecurityException("Provider must be exported");
        }
        if (!info.grantUriPermissions) {
            throw new SecurityException("Provider must grantUriPermissions");
        }
        if (!"android.permission.MANAGE_DOCUMENTS".equals(info.readPermission) || !"android.permission.MANAGE_DOCUMENTS".equals(info.writePermission)) {
            throw new SecurityException("Provider must be protected by MANAGE_DOCUMENTS");
        }
        super.attachInfo(context, info);
    }

    private final void $$robo$$android_provider_DocumentsProvider$attachInfoForTesting(Context context, ProviderInfo info) {
        this.registerAuthority(info.authority);
        super.attachInfoForTesting(context, info);
    }

    private final void $$robo$$android_provider_DocumentsProvider$registerAuthority(String authority) {
        this.mAuthority = authority;
        this.mMatcher = new UriMatcher(-1);
        this.mMatcher.addURI(this.mAuthority, "root", 1);
        this.mMatcher.addURI(this.mAuthority, "root/*", 2);
        this.mMatcher.addURI(this.mAuthority, "root/*/recent", 3);
        this.mMatcher.addURI(this.mAuthority, "root/*/search", 4);
        this.mMatcher.addURI(this.mAuthority, "document/*", 5);
        this.mMatcher.addURI(this.mAuthority, "document/*/children", 6);
        this.mMatcher.addURI(this.mAuthority, "tree/*/document/*", 7);
        this.mMatcher.addURI(this.mAuthority, "tree/*/document/*/children", 8);
    }

    private final boolean $$robo$$android_provider_DocumentsProvider$isChildDocument(String parentDocumentId, String documentId) {
        return false;
    }

    private final void $$robo$$android_provider_DocumentsProvider$enforceTree(Uri documentUri) {
        if (DocumentsContract.isTreeUri(documentUri)) {
            String child;
            String parent = DocumentsContract.getTreeDocumentId(documentUri);
            if (Objects.equals(parent, child = DocumentsContract.getDocumentId(documentUri))) {
                return;
            }
            if (!this.isChildDocument(parent, child)) {
                throw new SecurityException("Document " + child + " is not a descendant of " + parent);
            }
        }
    }

    private final String $$robo$$android_provider_DocumentsProvider$createDocument(String parentDocumentId, String mimeType, String displayName) throws FileNotFoundException {
        throw new UnsupportedOperationException("Create not supported");
    }

    private final String $$robo$$android_provider_DocumentsProvider$renameDocument(String documentId, String displayName) throws FileNotFoundException {
        throw new UnsupportedOperationException("Rename not supported");
    }

    private final void $$robo$$android_provider_DocumentsProvider$deleteDocument(String documentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Delete not supported");
    }

    private final String $$robo$$android_provider_DocumentsProvider$copyDocument(String sourceDocumentId, String targetParentDocumentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Copy not supported");
    }

    private final String $$robo$$android_provider_DocumentsProvider$moveDocument(String sourceDocumentId, String sourceParentDocumentId, String targetParentDocumentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Move not supported");
    }

    private final void $$robo$$android_provider_DocumentsProvider$removeDocument(String documentId, String parentDocumentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("Remove not supported");
    }

    private final DocumentsContract.Path $$robo$$android_provider_DocumentsProvider$findDocumentPath(String parentDocumentId, String childDocumentId) throws FileNotFoundException {
        throw new UnsupportedOperationException("findDocumentPath not supported.");
    }

    private final IntentSender $$robo$$android_provider_DocumentsProvider$createWebLinkIntent(String documentId, Bundle options) throws FileNotFoundException {
        throw new UnsupportedOperationException("createWebLink is not supported.");
    }

    public abstract Cursor queryRoots(String[] var1) throws FileNotFoundException;

    private final Cursor $$robo$$android_provider_DocumentsProvider$queryRecentDocuments(String rootId, String[] projection) throws FileNotFoundException {
        throw new UnsupportedOperationException("Recent not supported");
    }

    public abstract Cursor queryDocument(String var1, String[] var2) throws FileNotFoundException;

    public abstract Cursor queryChildDocuments(String var1, String[] var2, String var3) throws FileNotFoundException;

    private final Cursor $$robo$$android_provider_DocumentsProvider$queryChildDocuments(String parentDocumentId, String[] projection, Bundle queryArgs) throws FileNotFoundException {
        return this.queryChildDocuments(parentDocumentId, projection, DocumentsProvider.getSortClause(queryArgs));
    }

    private final Cursor $$robo$$android_provider_DocumentsProvider$queryChildDocumentsForManage(String parentDocumentId, String[] projection, String sortOrder) throws FileNotFoundException {
        throw new UnsupportedOperationException("Manage not supported");
    }

    private final Cursor $$robo$$android_provider_DocumentsProvider$querySearchDocuments(String rootId, String query, String[] projection) throws FileNotFoundException {
        throw new UnsupportedOperationException("Search not supported");
    }

    private final void $$robo$$android_provider_DocumentsProvider$ejectRoot(String rootId) {
        throw new UnsupportedOperationException("Eject not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String $$robo$$android_provider_DocumentsProvider$getDocumentType(String documentId) throws FileNotFoundException {
        Cursor cursor = this.queryDocument(documentId, null);
        try {
            if (cursor.moveToFirst()) {
                String string2 = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                return string2;
            }
            String string3 = null;
            return string3;
        }
        finally {
            IoUtils.closeQuietly(cursor);
        }
    }

    public abstract ParcelFileDescriptor openDocument(String var1, String var2, CancellationSignal var3) throws FileNotFoundException;

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openDocumentThumbnail(String documentId, Point sizeHint, CancellationSignal signal) throws FileNotFoundException {
        throw new UnsupportedOperationException("Thumbnails not supported");
    }

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openTypedDocument(String documentId, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        throw new FileNotFoundException("The requested MIME type is not supported.");
    }

    private final Cursor $$robo$$android_provider_DocumentsProvider$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        throw new UnsupportedOperationException("Pre-Android-O query format not supported.");
    }

    private final Cursor $$robo$$android_provider_DocumentsProvider$query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder, CancellationSignal cancellationSignal) {
        throw new UnsupportedOperationException("Pre-Android-O query format not supported.");
    }

    private final Cursor $$robo$$android_provider_DocumentsProvider$query(Uri uri, String[] projection, Bundle queryArgs, CancellationSignal cancellationSignal) {
        try {
            switch (this.mMatcher.match(uri)) {
                case 1: {
                    return this.queryRoots(projection);
                }
                case 3: {
                    return this.queryRecentDocuments(DocumentsContract.getRootId(uri), projection);
                }
                case 4: {
                    return this.querySearchDocuments(DocumentsContract.getRootId(uri), DocumentsContract.getSearchDocumentsQuery(uri), projection);
                }
                case 5: 
                case 7: {
                    this.enforceTree(uri);
                    return this.queryDocument(DocumentsContract.getDocumentId(uri), projection);
                }
                case 6: 
                case 8: {
                    this.enforceTree(uri);
                    if (DocumentsContract.isManageMode(uri)) {
                        return this.queryChildDocumentsForManage(DocumentsContract.getDocumentId(uri), projection, DocumentsProvider.getSortClause(queryArgs));
                    }
                    return this.queryChildDocuments(DocumentsContract.getDocumentId(uri), projection, queryArgs);
                }
            }
            throw new UnsupportedOperationException("Unsupported Uri " + uri);
        }
        catch (FileNotFoundException e) {
            Log.w("DocumentsProvider", "Failed during query", e);
            return null;
        }
    }

    private static final String $$robo$$android_provider_DocumentsProvider$getSortClause(Bundle queryArgs) {
        String sortClause = (queryArgs = queryArgs != null ? queryArgs : Bundle.EMPTY).getString("android:query-arg-sql-sort-order");
        if (sortClause == null && queryArgs.containsKey("android:query-arg-sort-columns")) {
            sortClause = ContentResolver.createSqlSortClause(queryArgs);
        }
        return sortClause;
    }

    private final String $$robo$$android_provider_DocumentsProvider$getType(Uri uri) {
        try {
            switch (this.mMatcher.match(uri)) {
                case 2: {
                    return "vnd.android.document/root";
                }
                case 5: 
                case 7: {
                    this.enforceTree(uri);
                    return this.getDocumentType(DocumentsContract.getDocumentId(uri));
                }
            }
            return null;
        }
        catch (FileNotFoundException e) {
            Log.w("DocumentsProvider", "Failed during getType", e);
            return null;
        }
    }

    private final Uri $$robo$$android_provider_DocumentsProvider$canonicalize(Uri uri) {
        Context context = this.getContext();
        switch (this.mMatcher.match(uri)) {
            case 7: {
                this.enforceTree(uri);
                Uri narrowUri = DocumentsContract.buildDocumentUri(uri.getAuthority(), DocumentsContract.getDocumentId(uri));
                int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, uri);
                context.grantUriPermission(this.getCallingPackage(), narrowUri, modeFlags);
                return narrowUri;
            }
        }
        return null;
    }

    private static final int $$robo$$android_provider_DocumentsProvider$getCallingOrSelfUriPermissionModeFlags(Context context, Uri uri) {
        int modeFlags = 0;
        if (context.checkCallingOrSelfUriPermission(uri, 1) == 0) {
            modeFlags |= 1;
        }
        if (context.checkCallingOrSelfUriPermission(uri, 2) == 0) {
            modeFlags |= 2;
        }
        if (context.checkCallingOrSelfUriPermission(uri, 65) == 0) {
            modeFlags |= 0x40;
        }
        return modeFlags;
    }

    private final Uri $$robo$$android_provider_DocumentsProvider$insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException("Insert not supported");
    }

    private final int $$robo$$android_provider_DocumentsProvider$delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Delete not supported");
    }

    private final int $$robo$$android_provider_DocumentsProvider$update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException("Update not supported");
    }

    private final Bundle $$robo$$android_provider_DocumentsProvider$call(String method, String arg, Bundle extras) {
        if (!method.startsWith("android:")) {
            return super.call(method, arg, extras);
        }
        try {
            return this.callUnchecked(method, arg, extras);
        }
        catch (FileNotFoundException e) {
            throw new ParcelableException(e);
        }
    }

    private final Bundle $$robo$$android_provider_DocumentsProvider$callUnchecked(String method, String arg, Bundle extras) throws FileNotFoundException {
        Context context = this.getContext();
        Bundle out = new Bundle();
        if ("android:ejectRoot".equals(method)) {
            Uri rootUri = (Uri)extras.getParcelable("uri");
            this.enforceWritePermissionInner(rootUri, this.getCallingPackage(), null);
            String rootId = DocumentsContract.getRootId(rootUri);
            this.ejectRoot(rootId);
            return out;
        }
        Uri documentUri = (Uri)extras.getParcelable("uri");
        String authority = documentUri.getAuthority();
        String documentId = DocumentsContract.getDocumentId(documentUri);
        if (!this.mAuthority.equals(authority)) {
            throw new SecurityException("Requested authority " + authority + " doesn't match provider " + this.mAuthority);
        }
        this.enforceTree(documentUri);
        if ("android:isChildDocument".equals(method)) {
            this.enforceReadPermissionInner(documentUri, this.getCallingPackage(), null);
            Uri childUri = (Uri)extras.getParcelable("android.content.extra.TARGET_URI");
            String childAuthority = childUri.getAuthority();
            String childId = DocumentsContract.getDocumentId(childUri);
            out.putBoolean("result", this.mAuthority.equals(childAuthority) && this.isChildDocument(documentId, childId));
        } else if ("android:createDocument".equals(method)) {
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            String mimeType = extras.getString("mime_type");
            String displayName = extras.getString("_display_name");
            String newDocumentId = this.createDocument(documentId, mimeType, displayName);
            Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
            out.putParcelable("uri", newDocumentUri);
        } else if ("android:createWebLinkIntent".equals(method)) {
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            Bundle options = extras.getBundle("options");
            IntentSender intentSender = this.createWebLinkIntent(documentId, options);
            out.putParcelable("result", intentSender);
        } else if ("android:renameDocument".equals(method)) {
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            String displayName = extras.getString("_display_name");
            String newDocumentId = this.renameDocument(documentId, displayName);
            if (newDocumentId != null) {
                Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
                if (!DocumentsContract.isTreeUri(newDocumentUri)) {
                    int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, documentUri);
                    context.grantUriPermission(this.getCallingPackage(), newDocumentUri, modeFlags);
                }
                out.putParcelable("uri", newDocumentUri);
                this.revokeDocumentPermission(documentId);
            }
        } else if ("android:deleteDocument".equals(method)) {
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            this.deleteDocument(documentId);
            this.revokeDocumentPermission(documentId);
        } else if ("android:copyDocument".equals(method)) {
            Uri targetUri = (Uri)extras.getParcelable("android.content.extra.TARGET_URI");
            String targetId = DocumentsContract.getDocumentId(targetUri);
            this.enforceReadPermissionInner(documentUri, this.getCallingPackage(), null);
            this.enforceWritePermissionInner(targetUri, this.getCallingPackage(), null);
            String newDocumentId = this.copyDocument(documentId, targetId);
            if (newDocumentId != null) {
                Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
                if (!DocumentsContract.isTreeUri(newDocumentUri)) {
                    int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, documentUri);
                    context.grantUriPermission(this.getCallingPackage(), newDocumentUri, modeFlags);
                }
                out.putParcelable("uri", newDocumentUri);
            }
        } else if ("android:moveDocument".equals(method)) {
            Uri parentSourceUri = (Uri)extras.getParcelable("parentUri");
            String parentSourceId = DocumentsContract.getDocumentId(parentSourceUri);
            Uri targetUri = (Uri)extras.getParcelable("android.content.extra.TARGET_URI");
            String targetId = DocumentsContract.getDocumentId(targetUri);
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            this.enforceReadPermissionInner(parentSourceUri, this.getCallingPackage(), null);
            this.enforceWritePermissionInner(targetUri, this.getCallingPackage(), null);
            String newDocumentId = this.moveDocument(documentId, parentSourceId, targetId);
            if (newDocumentId != null) {
                Uri newDocumentUri = DocumentsContract.buildDocumentUriMaybeUsingTree(documentUri, newDocumentId);
                if (!DocumentsContract.isTreeUri(newDocumentUri)) {
                    int modeFlags = DocumentsProvider.getCallingOrSelfUriPermissionModeFlags(context, documentUri);
                    context.grantUriPermission(this.getCallingPackage(), newDocumentUri, modeFlags);
                }
                out.putParcelable("uri", newDocumentUri);
            }
        } else if ("android:removeDocument".equals(method)) {
            Uri parentSourceUri = (Uri)extras.getParcelable("parentUri");
            String parentSourceId = DocumentsContract.getDocumentId(parentSourceUri);
            this.enforceReadPermissionInner(parentSourceUri, this.getCallingPackage(), null);
            this.enforceWritePermissionInner(documentUri, this.getCallingPackage(), null);
            this.removeDocument(documentId, parentSourceId);
        } else if ("android:findDocumentPath".equals(method)) {
            boolean isTreeUri = DocumentsContract.isTreeUri(documentUri);
            if (isTreeUri) {
                this.enforceReadPermissionInner(documentUri, this.getCallingPackage(), null);
            } else {
                this.getContext().enforceCallingPermission("android.permission.MANAGE_DOCUMENTS", null);
            }
            String parentDocumentId = isTreeUri ? DocumentsContract.getTreeDocumentId(documentUri) : null;
            DocumentsContract.Path path = this.findDocumentPath(parentDocumentId, documentId);
            if (isTreeUri) {
                if (!Objects.equals(path.getPath().get(0), parentDocumentId)) {
                    Log.wtf("DocumentsProvider", "Provider doesn't return path from the tree root. Expected: " + parentDocumentId + " found: " + path.getPath().get(0));
                    LinkedList<String> docs = new LinkedList<String>(path.getPath());
                    while (docs.size() > 1 && !Objects.equals(docs.getFirst(), parentDocumentId)) {
                        docs.removeFirst();
                    }
                    path = new DocumentsContract.Path(null, docs);
                }
                if (path.getRootId() != null) {
                    Log.wtf("DocumentsProvider", "Provider returns root id :" + path.getRootId() + " unexpectedly. Erase root id.");
                    path = new DocumentsContract.Path(null, path.getPath());
                }
            }
            out.putParcelable("result", path);
        } else {
            throw new UnsupportedOperationException("Method not supported " + method);
        }
        return out;
    }

    private final void $$robo$$android_provider_DocumentsProvider$revokeDocumentPermission(String documentId) {
        Context context = this.getContext();
        context.revokeUriPermission(DocumentsContract.buildDocumentUri(this.mAuthority, documentId), -1);
        context.revokeUriPermission(DocumentsContract.buildTreeDocumentUri(this.mAuthority, documentId), -1);
    }

    private final ParcelFileDescriptor $$robo$$android_provider_DocumentsProvider$openFile(Uri uri, String mode) throws FileNotFoundException {
        this.enforceTree(uri);
        return this.openDocument(DocumentsContract.getDocumentId(uri), mode, null);
    }

    private final ParcelFileDescriptor $$robo$$android_provider_DocumentsProvider$openFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        return this.openDocument(DocumentsContract.getDocumentId(uri), mode, signal);
    }

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        this.enforceTree(uri);
        ParcelFileDescriptor fd = this.openDocument(DocumentsContract.getDocumentId(uri), mode, null);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openAssetFile(Uri uri, String mode, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        ParcelFileDescriptor fd = this.openDocument(DocumentsContract.getDocumentId(uri), mode, signal);
        return fd != null ? new AssetFileDescriptor(fd, 0L, -1L) : null;
    }

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts) throws FileNotFoundException {
        return this.openTypedAssetFileImpl(uri, mimeTypeFilter, opts, null);
    }

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openTypedAssetFile(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        return this.openTypedAssetFileImpl(uri, mimeTypeFilter, opts, signal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String[] $$robo$$android_provider_DocumentsProvider$getDocumentStreamTypes(String documentId, String mimeTypeFilter) {
        Cursor cursor;
        block4: {
            String[] stringArray;
            cursor = null;
            try {
                cursor = this.queryDocument(documentId, null);
                if (!cursor.moveToFirst()) break block4;
                String mimeType = cursor.getString(cursor.getColumnIndexOrThrow("mime_type"));
                long flags = cursor.getLong(cursor.getColumnIndexOrThrow("flags"));
                if ((flags & 0x200L) != 0L || mimeType == null || !DocumentsProvider.mimeTypeMatches(mimeTypeFilter, mimeType)) break block4;
                stringArray = new String[]{mimeType};
            }
            catch (FileNotFoundException e) {
                String[] stringArray2;
                try {
                    stringArray2 = null;
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(cursor);
                    throw throwable;
                }
                IoUtils.closeQuietly(cursor);
                return stringArray2;
            }
            IoUtils.closeQuietly(cursor);
            return stringArray;
        }
        IoUtils.closeQuietly(cursor);
        return null;
    }

    private final String[] $$robo$$android_provider_DocumentsProvider$getStreamTypes(Uri uri, String mimeTypeFilter) {
        this.enforceTree(uri);
        return this.getDocumentStreamTypes(DocumentsContract.getDocumentId(uri), mimeTypeFilter);
    }

    private final AssetFileDescriptor $$robo$$android_provider_DocumentsProvider$openTypedAssetFileImpl(Uri uri, String mimeTypeFilter, Bundle opts, CancellationSignal signal) throws FileNotFoundException {
        this.enforceTree(uri);
        String documentId = DocumentsContract.getDocumentId(uri);
        if (opts != null && opts.containsKey("android.content.extra.SIZE")) {
            Point sizeHint = (Point)opts.getParcelable("android.content.extra.SIZE");
            return this.openDocumentThumbnail(documentId, sizeHint, signal);
        }
        if ("*/*".equals(mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        String baseType = this.getType(uri);
        if (baseType != null && ClipDescription.compareMimeTypes(baseType, mimeTypeFilter)) {
            return this.openAssetFile(uri, "r");
        }
        return this.openTypedDocument(documentId, mimeTypeFilter, opts, signal);
    }

    private static final boolean $$robo$$android_provider_DocumentsProvider$mimeTypeMatches(String filter, String test) {
        if (test == null) {
            return false;
        }
        if (filter == null || "*/*".equals(filter)) {
            return true;
        }
        if (filter.equals(test)) {
            return true;
        }
        if (filter.endsWith("/*")) {
            return filter.regionMatches(0, test, 0, filter.indexOf(47));
        }
        return false;
    }

    private void __constructor__() {
        this.$$robo$$android_provider_DocumentsProvider$__constructor__();
    }

    public DocumentsProvider() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_DocumentsProvider$__constructor__(), this);
    }

    @Override
    public void attachInfo(Context context, ProviderInfo providerInfo) {
        InvokeDynamicSupport.bootstrap("attachInfo", $$robo$$android_provider_DocumentsProvider$attachInfo(android.content.Context android.content.pm.ProviderInfo ), this, context, providerInfo);
    }

    @Override
    public void attachInfoForTesting(Context context, ProviderInfo providerInfo) {
        InvokeDynamicSupport.bootstrap("attachInfoForTesting", $$robo$$android_provider_DocumentsProvider$attachInfoForTesting(android.content.Context android.content.pm.ProviderInfo ), this, context, providerInfo);
    }

    private void registerAuthority(String string2) {
        InvokeDynamicSupport.bootstrap("registerAuthority", $$robo$$android_provider_DocumentsProvider$registerAuthority(java.lang.String ), this, string2);
    }

    public boolean isChildDocument(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isChildDocument", $$robo$$android_provider_DocumentsProvider$isChildDocument(java.lang.String java.lang.String ), this, string2, string3);
    }

    private void enforceTree(Uri uri) {
        InvokeDynamicSupport.bootstrap("enforceTree", $$robo$$android_provider_DocumentsProvider$enforceTree(android.net.Uri ), this, uri);
    }

    public String createDocument(String string2, String string3, String string4) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("createDocument", $$robo$$android_provider_DocumentsProvider$createDocument(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    public String renameDocument(String string2, String string3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("renameDocument", $$robo$$android_provider_DocumentsProvider$renameDocument(java.lang.String java.lang.String ), this, string2, string3);
    }

    public void deleteDocument(String string2) throws FileNotFoundException {
        InvokeDynamicSupport.bootstrap("deleteDocument", $$robo$$android_provider_DocumentsProvider$deleteDocument(java.lang.String ), this, string2);
    }

    public String copyDocument(String string2, String string3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("copyDocument", $$robo$$android_provider_DocumentsProvider$copyDocument(java.lang.String java.lang.String ), this, string2, string3);
    }

    public String moveDocument(String string2, String string3, String string4) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("moveDocument", $$robo$$android_provider_DocumentsProvider$moveDocument(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    public void removeDocument(String string2, String string3) throws FileNotFoundException {
        InvokeDynamicSupport.bootstrap("removeDocument", $$robo$$android_provider_DocumentsProvider$removeDocument(java.lang.String java.lang.String ), this, string2, string3);
    }

    public DocumentsContract.Path findDocumentPath(String string2, String string3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("findDocumentPath", $$robo$$android_provider_DocumentsProvider$findDocumentPath(java.lang.String java.lang.String ), this, string2, string3);
    }

    public IntentSender createWebLinkIntent(String string2, Bundle bundle) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("createWebLinkIntent", $$robo$$android_provider_DocumentsProvider$createWebLinkIntent(java.lang.String android.os.Bundle ), this, string2, bundle);
    }

    public Cursor queryRecentDocuments(String string2, String[] stringArray) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("queryRecentDocuments", $$robo$$android_provider_DocumentsProvider$queryRecentDocuments(java.lang.String java.lang.String[] ), this, string2, stringArray);
    }

    public Cursor queryChildDocuments(String string2, String[] stringArray, Bundle bundle) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("queryChildDocuments", $$robo$$android_provider_DocumentsProvider$queryChildDocuments(java.lang.String java.lang.String[] android.os.Bundle ), this, string2, stringArray, bundle);
    }

    public Cursor queryChildDocumentsForManage(String string2, String[] stringArray, String string3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("queryChildDocumentsForManage", $$robo$$android_provider_DocumentsProvider$queryChildDocumentsForManage(java.lang.String java.lang.String[] java.lang.String ), this, string2, stringArray, string3);
    }

    public Cursor querySearchDocuments(String string2, String string3, String[] stringArray) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("querySearchDocuments", $$robo$$android_provider_DocumentsProvider$querySearchDocuments(java.lang.String java.lang.String java.lang.String[] ), this, string2, string3, stringArray);
    }

    public void ejectRoot(String string2) {
        InvokeDynamicSupport.bootstrap("ejectRoot", $$robo$$android_provider_DocumentsProvider$ejectRoot(java.lang.String ), this, string2);
    }

    public String getDocumentType(String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("getDocumentType", $$robo$$android_provider_DocumentsProvider$getDocumentType(java.lang.String ), this, string2);
    }

    public AssetFileDescriptor openDocumentThumbnail(String string2, Point point, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openDocumentThumbnail", $$robo$$android_provider_DocumentsProvider$openDocumentThumbnail(java.lang.String android.graphics.Point android.os.CancellationSignal ), this, string2, point, cancellationSignal);
    }

    public AssetFileDescriptor openTypedDocument(String string2, String string3, Bundle bundle, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedDocument", $$robo$$android_provider_DocumentsProvider$openTypedDocument(java.lang.String java.lang.String android.os.Bundle android.os.CancellationSignal ), this, string2, string3, bundle, cancellationSignal);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_provider_DocumentsProvider$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String ), this, uri, stringArray, string2, stringArray2, string3);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_provider_DocumentsProvider$query(android.net.Uri java.lang.String[] java.lang.String java.lang.String[] java.lang.String android.os.CancellationSignal ), this, uri, stringArray, string2, stringArray2, string3, cancellationSignal);
    }

    @Override
    public Cursor query(Uri uri, String[] stringArray, Bundle bundle, CancellationSignal cancellationSignal) {
        return InvokeDynamicSupport.bootstrap("query", $$robo$$android_provider_DocumentsProvider$query(android.net.Uri java.lang.String[] android.os.Bundle android.os.CancellationSignal ), this, uri, stringArray, bundle, cancellationSignal);
    }

    private static String getSortClause(Bundle bundle) {
        return InvokeDynamicSupport.bootstrapStatic("getSortClause", $$robo$$android_provider_DocumentsProvider$getSortClause(android.os.Bundle ), (Bundle)bundle);
    }

    @Override
    public String getType(Uri uri) {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_provider_DocumentsProvider$getType(android.net.Uri ), this, uri);
    }

    @Override
    public Uri canonicalize(Uri uri) {
        return InvokeDynamicSupport.bootstrap("canonicalize", $$robo$$android_provider_DocumentsProvider$canonicalize(android.net.Uri ), this, uri);
    }

    private static int getCallingOrSelfUriPermissionModeFlags(Context context, Uri uri) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getCallingOrSelfUriPermissionModeFlags", $$robo$$android_provider_DocumentsProvider$getCallingOrSelfUriPermissionModeFlags(android.content.Context android.net.Uri ), (Context)context, (Uri)uri);
    }

    @Override
    public Uri insert(Uri uri, ContentValues contentValues) {
        return InvokeDynamicSupport.bootstrap("insert", $$robo$$android_provider_DocumentsProvider$insert(android.net.Uri android.content.ContentValues ), this, uri, contentValues);
    }

    @Override
    public int delete(Uri uri, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("delete", $$robo$$android_provider_DocumentsProvider$delete(android.net.Uri java.lang.String java.lang.String[] ), this, uri, string2, stringArray);
    }

    @Override
    public int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrap("update", $$robo$$android_provider_DocumentsProvider$update(android.net.Uri android.content.ContentValues java.lang.String java.lang.String[] ), this, uri, contentValues, string2, stringArray);
    }

    @Override
    public Bundle call(String string2, String string3, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("call", $$robo$$android_provider_DocumentsProvider$call(java.lang.String java.lang.String android.os.Bundle ), this, string2, string3, bundle);
    }

    private Bundle callUnchecked(String string2, String string3, Bundle bundle) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("callUnchecked", $$robo$$android_provider_DocumentsProvider$callUnchecked(java.lang.String java.lang.String android.os.Bundle ), this, string2, string3, bundle);
    }

    public void revokeDocumentPermission(String string2) {
        InvokeDynamicSupport.bootstrap("revokeDocumentPermission", $$robo$$android_provider_DocumentsProvider$revokeDocumentPermission(java.lang.String ), this, string2);
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFile", $$robo$$android_provider_DocumentsProvider$openFile(android.net.Uri java.lang.String ), this, uri, string2);
    }

    @Override
    public ParcelFileDescriptor openFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openFile", $$robo$$android_provider_DocumentsProvider$openFile(android.net.Uri java.lang.String android.os.CancellationSignal ), this, uri, string2, cancellationSignal);
    }

    @Override
    public AssetFileDescriptor openAssetFile(Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openAssetFile", $$robo$$android_provider_DocumentsProvider$openAssetFile(android.net.Uri java.lang.String ), this, uri, string2);
    }

    @Override
    public AssetFileDescriptor openAssetFile(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openAssetFile", $$robo$$android_provider_DocumentsProvider$openAssetFile(android.net.Uri java.lang.String android.os.CancellationSignal ), this, uri, string2, cancellationSignal);
    }

    @Override
    public AssetFileDescriptor openTypedAssetFile(Uri uri, String string2, Bundle bundle) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFile", $$robo$$android_provider_DocumentsProvider$openTypedAssetFile(android.net.Uri java.lang.String android.os.Bundle ), this, uri, string2, bundle);
    }

    @Override
    public AssetFileDescriptor openTypedAssetFile(Uri uri, String string2, Bundle bundle, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFile", $$robo$$android_provider_DocumentsProvider$openTypedAssetFile(android.net.Uri java.lang.String android.os.Bundle android.os.CancellationSignal ), this, uri, string2, bundle, cancellationSignal);
    }

    public String[] getDocumentStreamTypes(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("getDocumentStreamTypes", $$robo$$android_provider_DocumentsProvider$getDocumentStreamTypes(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public String[] getStreamTypes(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrap("getStreamTypes", $$robo$$android_provider_DocumentsProvider$getStreamTypes(android.net.Uri java.lang.String ), this, uri, string2);
    }

    private AssetFileDescriptor openTypedAssetFileImpl(Uri uri, String string2, Bundle bundle, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("openTypedAssetFileImpl", $$robo$$android_provider_DocumentsProvider$openTypedAssetFileImpl(android.net.Uri java.lang.String android.os.Bundle android.os.CancellationSignal ), this, uri, string2, bundle, cancellationSignal);
    }

    public static boolean mimeTypeMatches(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("mimeTypeMatches", $$robo$$android_provider_DocumentsProvider$mimeTypeMatches(java.lang.String java.lang.String ), (String)string2, (String)string3);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DocumentsProvider)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

