/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.renderscript.ProgramFragment;
import android.renderscript.ProgramRaster;
import android.renderscript.ProgramStore;
import android.renderscript.ProgramVertex;
import android.renderscript.RSDriverException;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Script;
import android.view.Surface;
import android.view.SurfaceHolder;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RenderScriptGL
extends RenderScript
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    int mWidth;
    int mHeight;
    SurfaceConfig mSurfaceConfig;

    private void $$robo$$android_renderscript_RenderScriptGL$__constructor__(Context ctx, SurfaceConfig sc) {
        this.mSurfaceConfig = new SurfaceConfig(sc);
        int sdkVersion = ctx.getApplicationInfo().targetSdkVersion;
        this.mWidth = 0;
        this.mHeight = 0;
        long device = this.nDeviceCreate();
        int dpi = ctx.getResources().getDisplayMetrics().densityDpi;
        this.mContext = this.nContextCreateGL(device, 0, sdkVersion, this.mSurfaceConfig.mColorMin, this.mSurfaceConfig.mColorPref, this.mSurfaceConfig.mAlphaMin, this.mSurfaceConfig.mAlphaPref, this.mSurfaceConfig.mDepthMin, this.mSurfaceConfig.mDepthPref, this.mSurfaceConfig.mStencilMin, this.mSurfaceConfig.mStencilPref, this.mSurfaceConfig.mSamplesMin, this.mSurfaceConfig.mSamplesPref, this.mSurfaceConfig.mSamplesQ, dpi);
        if (this.mContext == 0L) {
            throw new RSDriverException("Failed to create RS context.");
        }
        this.mMessageThread = new RenderScript.MessageThread(this);
        this.mMessageThread.start();
    }

    private final void $$robo$$android_renderscript_RenderScriptGL$setSurface(SurfaceHolder sur, int w, int h) {
        this.validate();
        Surface s = null;
        if (sur != null) {
            s = sur.getSurface();
        }
        this.mWidth = w;
        this.mHeight = h;
        this.nContextSetSurface(w, h, s);
    }

    private final void $$robo$$android_renderscript_RenderScriptGL$setSurfaceTexture(SurfaceTexture sur, int w, int h) {
        this.validate();
        Surface s = null;
        if (sur != null) {
            s = new Surface(sur);
        }
        this.mWidth = w;
        this.mHeight = h;
        this.nContextSetSurface(w, h, s);
    }

    private final int $$robo$$android_renderscript_RenderScriptGL$getHeight() {
        return this.mHeight;
    }

    private final int $$robo$$android_renderscript_RenderScriptGL$getWidth() {
        return this.mWidth;
    }

    private final void $$robo$$android_renderscript_RenderScriptGL$pause() {
        this.validate();
        this.nContextPause();
    }

    private final void $$robo$$android_renderscript_RenderScriptGL$resume() {
        this.validate();
        this.nContextResume();
    }

    private final void $$robo$$android_renderscript_RenderScriptGL$bindRootScript(Script s) {
        this.validate();
        this.nContextBindRootScript((int)this.safeID(s));
    }

    private final void $$robo$$android_renderscript_RenderScriptGL$bindProgramStore(ProgramStore p) {
        this.validate();
        this.nContextBindProgramStore((int)this.safeID(p));
    }

    private final void $$robo$$android_renderscript_RenderScriptGL$bindProgramFragment(ProgramFragment p) {
        this.validate();
        this.nContextBindProgramFragment((int)this.safeID(p));
    }

    private final void $$robo$$android_renderscript_RenderScriptGL$bindProgramRaster(ProgramRaster p) {
        this.validate();
        this.nContextBindProgramRaster((int)this.safeID(p));
    }

    private final void $$robo$$android_renderscript_RenderScriptGL$bindProgramVertex(ProgramVertex p) {
        this.validate();
        this.nContextBindProgramVertex((int)this.safeID(p));
    }

    private void __constructor__(Context context, SurfaceConfig surfaceConfig) {
        this.$$robo$$android_renderscript_RenderScriptGL$__constructor__(context, surfaceConfig);
    }

    public RenderScriptGL(Context context, SurfaceConfig surfaceConfig) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_RenderScriptGL$__constructor__(android.content.Context android.renderscript.RenderScriptGL$SurfaceConfig ), this, context, surfaceConfig);
    }

    public void setSurface(SurfaceHolder surfaceHolder, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSurface", $$robo$$android_renderscript_RenderScriptGL$setSurface(android.view.SurfaceHolder int int ), this, surfaceHolder, n, n2);
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setSurfaceTexture", $$robo$$android_renderscript_RenderScriptGL$setSurfaceTexture(android.graphics.SurfaceTexture int int ), this, surfaceTexture, n, n2);
    }

    public int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_renderscript_RenderScriptGL$getHeight(), this);
    }

    public int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_renderscript_RenderScriptGL$getWidth(), this);
    }

    public void pause() {
        InvokeDynamicSupport.bootstrap("pause", $$robo$$android_renderscript_RenderScriptGL$pause(), this);
    }

    public void resume() {
        InvokeDynamicSupport.bootstrap("resume", $$robo$$android_renderscript_RenderScriptGL$resume(), this);
    }

    public void bindRootScript(Script script) {
        InvokeDynamicSupport.bootstrap("bindRootScript", $$robo$$android_renderscript_RenderScriptGL$bindRootScript(android.renderscript.Script ), this, script);
    }

    public void bindProgramStore(ProgramStore programStore) {
        InvokeDynamicSupport.bootstrap("bindProgramStore", $$robo$$android_renderscript_RenderScriptGL$bindProgramStore(android.renderscript.ProgramStore ), this, programStore);
    }

    public void bindProgramFragment(ProgramFragment programFragment) {
        InvokeDynamicSupport.bootstrap("bindProgramFragment", $$robo$$android_renderscript_RenderScriptGL$bindProgramFragment(android.renderscript.ProgramFragment ), this, programFragment);
    }

    public void bindProgramRaster(ProgramRaster programRaster) {
        InvokeDynamicSupport.bootstrap("bindProgramRaster", $$robo$$android_renderscript_RenderScriptGL$bindProgramRaster(android.renderscript.ProgramRaster ), this, programRaster);
    }

    public void bindProgramVertex(ProgramVertex programVertex) {
        InvokeDynamicSupport.bootstrap("bindProgramVertex", $$robo$$android_renderscript_RenderScriptGL$bindProgramVertex(android.renderscript.ProgramVertex ), this, programVertex);
    }

    public /* synthetic */ RenderScriptGL() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RenderScriptGL)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SurfaceConfig
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        int mDepthMin;
        int mDepthPref;
        int mStencilMin;
        int mStencilPref;
        int mColorMin;
        int mColorPref;
        int mAlphaMin;
        int mAlphaPref;
        int mSamplesMin;
        int mSamplesPref;
        float mSamplesQ;

        private void $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$__constructor__() {
            this.mDepthMin = 0;
            this.mDepthPref = 0;
            this.mStencilMin = 0;
            this.mStencilPref = 0;
            this.mColorMin = 8;
            this.mColorPref = 8;
            this.mAlphaMin = 0;
            this.mAlphaPref = 0;
            this.mSamplesMin = 1;
            this.mSamplesPref = 1;
            this.mSamplesQ = 1.0f;
        }

        private void $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$__constructor__(SurfaceConfig sc) {
            this.mDepthMin = 0;
            this.mDepthPref = 0;
            this.mStencilMin = 0;
            this.mStencilPref = 0;
            this.mColorMin = 8;
            this.mColorPref = 8;
            this.mAlphaMin = 0;
            this.mAlphaPref = 0;
            this.mSamplesMin = 1;
            this.mSamplesPref = 1;
            this.mSamplesQ = 1.0f;
            this.mDepthMin = sc.mDepthMin;
            this.mDepthPref = sc.mDepthPref;
            this.mStencilMin = sc.mStencilMin;
            this.mStencilPref = sc.mStencilPref;
            this.mColorMin = sc.mColorMin;
            this.mColorPref = sc.mColorPref;
            this.mAlphaMin = sc.mAlphaMin;
            this.mAlphaPref = sc.mAlphaPref;
            this.mSamplesMin = sc.mSamplesMin;
            this.mSamplesPref = sc.mSamplesPref;
            this.mSamplesQ = sc.mSamplesQ;
        }

        private final void $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$validateRange(int umin, int upref, int rmin, int rmax) {
            if (umin < rmin || umin > rmax) {
                throw new RSIllegalArgumentException("Minimum value provided out of range.");
            }
            if (upref < umin) {
                throw new RSIllegalArgumentException("preferred must be >= Minimum.");
            }
        }

        private final void $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$setColor(int minimum, int preferred) {
            this.validateRange(minimum, preferred, 5, 8);
            this.mColorMin = minimum;
            this.mColorPref = preferred;
        }

        private final void $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$setAlpha(int minimum, int preferred) {
            this.validateRange(minimum, preferred, 0, 8);
            this.mAlphaMin = minimum;
            this.mAlphaPref = preferred;
        }

        private final void $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$setDepth(int minimum, int preferred) {
            this.validateRange(minimum, preferred, 0, 24);
            this.mDepthMin = minimum;
            this.mDepthPref = preferred;
        }

        private final void $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$setSamples(int minimum, int preferred, float Q) {
            this.validateRange(minimum, preferred, 1, 32);
            if (Q < 0.0f || Q > 1.0f) {
                throw new RSIllegalArgumentException("Quality out of 0-1 range.");
            }
            this.mSamplesMin = minimum;
            this.mSamplesPref = preferred;
            this.mSamplesQ = Q;
        }

        private void __constructor__() {
            this.$$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$__constructor__();
        }

        public SurfaceConfig() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$__constructor__(), this);
        }

        private void __constructor__(SurfaceConfig surfaceConfig) {
            this.$$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$__constructor__(surfaceConfig);
        }

        public SurfaceConfig(SurfaceConfig surfaceConfig) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$__constructor__(android.renderscript.RenderScriptGL$SurfaceConfig ), this, surfaceConfig);
        }

        private void validateRange(int n, int n2, int n3, int n4) {
            InvokeDynamicSupport.bootstrap("validateRange", $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$validateRange(int int int int ), this, n, n2, n3, n4);
        }

        public void setColor(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setColor", $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$setColor(int int ), this, n, n2);
        }

        public void setAlpha(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$setAlpha(int int ), this, n, n2);
        }

        public void setDepth(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setDepth", $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$setDepth(int int ), this, n, n2);
        }

        public void setSamples(int n, int n2, float f) {
            InvokeDynamicSupport.bootstrap("setSamples", $$robo$$android_renderscript_RenderScriptGL_SurfaceConfig$setSamples(int int float ), this, n, n2, f);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceConfig)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

