/*
 * Decompiled with CFR 0.152.
 */
package android.security;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.security.KeyChain;
import android.security.KeyStore;
import android.util.Log;
import com.android.org.bouncycastle.util.io.pem.PemObject;
import com.android.org.bouncycastle.util.io.pem.PemObjectGenerator;
import com.android.org.bouncycastle.util.io.pem.PemReader;
import com.android.org.bouncycastle.util.io.pem.PemWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Credentials
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOGTAG = "Credentials";
    public static String INSTALL_ACTION = "android.credentials.INSTALL";
    public static String INSTALL_AS_USER_ACTION = "android.credentials.INSTALL_AS_USER";
    public static String UNLOCK_ACTION = "com.android.credentials.UNLOCK";
    public static String CA_CERTIFICATE = "CACERT_";
    public static String USER_CERTIFICATE = "USRCERT_";
    public static String USER_PRIVATE_KEY = "USRPKEY_";
    public static String USER_SECRET_KEY = "USRSKEY_";
    public static String VPN = "VPN_";
    public static String WIFI = "WIFI_";
    public static String LOCKDOWN_VPN = "LOCKDOWN_VPN";
    public static String EXTRA_PUBLIC_KEY = "KEY";
    public static String EXTRA_PRIVATE_KEY = "PKEY";
    public static String EXTENSION_CRT = ".crt";
    public static String EXTENSION_P12 = ".p12";
    public static String EXTENSION_CER = ".cer";
    public static String EXTENSION_PFX = ".pfx";
    public static String EXTRA_INSTALL_AS_UID = "install_as_uid";
    public static String EXTRA_USER_PRIVATE_KEY_NAME = "user_private_key_name";
    public static String EXTRA_USER_PRIVATE_KEY_DATA = "user_private_key_data";
    public static String EXTRA_USER_CERTIFICATE_NAME = "user_certificate_name";
    public static String EXTRA_USER_CERTIFICATE_DATA = "user_certificate_data";
    public static String EXTRA_CA_CERTIFICATES_NAME = "ca_certificates_name";
    public static String EXTRA_CA_CERTIFICATES_DATA = "ca_certificates_data";
    private static Credentials singleton;

    private void $$robo$$android_security_Credentials$__constructor__() {
    }

    private static final byte[] $$robo$$android_security_Credentials$convertToPem(Certificate ... objects) throws IOException, CertificateEncodingException {
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bao, StandardCharsets.US_ASCII);
        PemWriter pw = new PemWriter((Writer)writer);
        for (Certificate o : objects) {
            pw.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", o.getEncoded()));
        }
        pw.close();
        return bao.toByteArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<X509Certificate> $$robo$$android_security_Credentials$convertFromPem(byte[] bytes) throws IOException, CertificateException {
        ByteArrayInputStream bai = new ByteArrayInputStream(bytes);
        InputStreamReader reader = new InputStreamReader((InputStream)bai, StandardCharsets.US_ASCII);
        try (PemReader pr = new PemReader((Reader)reader);){
            PemObject o;
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            ArrayList<X509Certificate> result = new ArrayList<X509Certificate>();
            while ((o = pr.readPemObject()) != null) {
                if (o.getType().equals("CERTIFICATE")) {
                    Certificate c = cf.generateCertificate(new ByteArrayInputStream(o.getContent()));
                    result.add((X509Certificate)c);
                    continue;
                }
                throw new IllegalArgumentException("Unknown type " + o.getType());
            }
            ArrayList<X509Certificate> arrayList = result;
            return arrayList;
        }
    }

    private static final Credentials $$robo$$android_security_Credentials$getInstance() {
        if (singleton == null) {
            singleton = new Credentials();
        }
        return singleton;
    }

    private final void $$robo$$android_security_Credentials$unlock(Context context) {
        try {
            Intent intent = new Intent("com.android.credentials.UNLOCK");
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.w("Credentials", e.toString());
        }
    }

    private final void $$robo$$android_security_Credentials$install(Context context) {
        try {
            Intent intent = KeyChain.createInstallIntent();
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.w("Credentials", e.toString());
        }
    }

    private final void $$robo$$android_security_Credentials$install(Context context, KeyPair pair) {
        try {
            Intent intent = KeyChain.createInstallIntent();
            intent.putExtra("PKEY", pair.getPrivate().getEncoded());
            intent.putExtra("KEY", pair.getPublic().getEncoded());
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.w("Credentials", e.toString());
        }
    }

    private final void $$robo$$android_security_Credentials$install(Context context, String type, byte[] value) {
        try {
            Intent intent = KeyChain.createInstallIntent();
            intent.putExtra(type, value);
            context.startActivity(intent);
        }
        catch (ActivityNotFoundException e) {
            Log.w("Credentials", e.toString());
        }
    }

    private static final boolean $$robo$$android_security_Credentials$deleteAllTypesForAlias(KeyStore keystore, String alias) {
        return Credentials.deleteAllTypesForAlias(keystore, alias, -1);
    }

    private static final boolean $$robo$$android_security_Credentials$deleteAllTypesForAlias(KeyStore keystore, String alias, int uid) {
        return Credentials.deletePrivateKeyTypeForAlias(keystore, alias, uid) & Credentials.deleteSecretKeyTypeForAlias(keystore, alias, uid) & Credentials.deleteCertificateTypesForAlias(keystore, alias, uid);
    }

    private static final boolean $$robo$$android_security_Credentials$deleteCertificateTypesForAlias(KeyStore keystore, String alias) {
        return Credentials.deleteCertificateTypesForAlias(keystore, alias, -1);
    }

    private static final boolean $$robo$$android_security_Credentials$deleteCertificateTypesForAlias(KeyStore keystore, String alias, int uid) {
        return keystore.delete("USRCERT_" + alias, uid) & keystore.delete("CACERT_" + alias, uid);
    }

    private static final boolean $$robo$$android_security_Credentials$deletePrivateKeyTypeForAlias(KeyStore keystore, String alias) {
        return Credentials.deletePrivateKeyTypeForAlias(keystore, alias, -1);
    }

    private static final boolean $$robo$$android_security_Credentials$deletePrivateKeyTypeForAlias(KeyStore keystore, String alias, int uid) {
        return keystore.delete("USRPKEY_" + alias, uid);
    }

    private static final boolean $$robo$$android_security_Credentials$deleteSecretKeyTypeForAlias(KeyStore keystore, String alias) {
        return Credentials.deleteSecretKeyTypeForAlias(keystore, alias, -1);
    }

    private static final boolean $$robo$$android_security_Credentials$deleteSecretKeyTypeForAlias(KeyStore keystore, String alias, int uid) {
        return keystore.delete("USRSKEY_" + alias, uid);
    }

    private void __constructor__() {
        this.$$robo$$android_security_Credentials$__constructor__();
    }

    public Credentials() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_Credentials$__constructor__(), this);
    }

    public static byte[] convertToPem(Certificate ... certificateArray) throws IOException, CertificateEncodingException {
        return InvokeDynamicSupport.bootstrapStatic("convertToPem", $$robo$$android_security_Credentials$convertToPem(java.security.cert.Certificate[] ), (Certificate[])certificateArray);
    }

    public static List<X509Certificate> convertFromPem(byte[] byArray) throws IOException, CertificateException {
        return InvokeDynamicSupport.bootstrapStatic("convertFromPem", $$robo$$android_security_Credentials$convertFromPem(byte[] ), (byte[])byArray);
    }

    public static Credentials getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_security_Credentials$getInstance());
    }

    public void unlock(Context context) {
        InvokeDynamicSupport.bootstrap("unlock", $$robo$$android_security_Credentials$unlock(android.content.Context ), this, context);
    }

    public void install(Context context) {
        InvokeDynamicSupport.bootstrap("install", $$robo$$android_security_Credentials$install(android.content.Context ), this, context);
    }

    public void install(Context context, KeyPair keyPair) {
        InvokeDynamicSupport.bootstrap("install", $$robo$$android_security_Credentials$install(android.content.Context java.security.KeyPair ), this, context, keyPair);
    }

    public void install(Context context, String string2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("install", $$robo$$android_security_Credentials$install(android.content.Context java.lang.String byte[] ), this, context, string2, byArray);
    }

    public static boolean deleteAllTypesForAlias(KeyStore keyStore, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteAllTypesForAlias", $$robo$$android_security_Credentials$deleteAllTypesForAlias(android.security.KeyStore java.lang.String ), (KeyStore)keyStore, (String)string2);
    }

    public static boolean deleteAllTypesForAlias(KeyStore keyStore, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteAllTypesForAlias", $$robo$$android_security_Credentials$deleteAllTypesForAlias(android.security.KeyStore java.lang.String int ), (KeyStore)keyStore, (String)string2, (int)n);
    }

    public static boolean deleteCertificateTypesForAlias(KeyStore keyStore, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteCertificateTypesForAlias", $$robo$$android_security_Credentials$deleteCertificateTypesForAlias(android.security.KeyStore java.lang.String ), (KeyStore)keyStore, (String)string2);
    }

    public static boolean deleteCertificateTypesForAlias(KeyStore keyStore, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteCertificateTypesForAlias", $$robo$$android_security_Credentials$deleteCertificateTypesForAlias(android.security.KeyStore java.lang.String int ), (KeyStore)keyStore, (String)string2, (int)n);
    }

    static boolean deletePrivateKeyTypeForAlias(KeyStore keyStore, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deletePrivateKeyTypeForAlias", $$robo$$android_security_Credentials$deletePrivateKeyTypeForAlias(android.security.KeyStore java.lang.String ), (KeyStore)keyStore, (String)string2);
    }

    static boolean deletePrivateKeyTypeForAlias(KeyStore keyStore, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deletePrivateKeyTypeForAlias", $$robo$$android_security_Credentials$deletePrivateKeyTypeForAlias(android.security.KeyStore java.lang.String int ), (KeyStore)keyStore, (String)string2, (int)n);
    }

    public static boolean deleteSecretKeyTypeForAlias(KeyStore keyStore, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteSecretKeyTypeForAlias", $$robo$$android_security_Credentials$deleteSecretKeyTypeForAlias(android.security.KeyStore java.lang.String ), (KeyStore)keyStore, (String)string2);
    }

    public static boolean deleteSecretKeyTypeForAlias(KeyStore keyStore, String string2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteSecretKeyTypeForAlias", $$robo$$android_security_Credentials$deleteSecretKeyTypeForAlias(android.security.KeyStore java.lang.String int ), (KeyStore)keyStore, (String)string2, (int)n);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Credentials)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

