/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.os.IBinder;
import android.security.KeyStore;
import android.security.KeyStoreException;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.OperationResult;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.AndroidKeyStorePrivateKey;
import android.security.keystore.AndroidKeyStorePublicKey;
import android.security.keystore.ArrayUtils;
import android.security.keystore.KeyStoreConnectException;
import android.security.keystore.KeyStoreCryptoOperation;
import android.security.keystore.KeyStoreCryptoOperationChunkedStreamer;
import android.security.keystore.KeyStoreCryptoOperationStreamer;
import android.security.keystore.KeyStoreCryptoOperationUtils;
import java.nio.ByteBuffer;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.security.SignatureSpi;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AndroidKeyStoreSignatureSpiBase
extends SignatureSpi
implements KeyStoreCryptoOperation,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private KeyStore mKeyStore;
    private boolean mSigning;
    private AndroidKeyStoreKey mKey;
    private IBinder mOperationToken;
    private long mOperationHandle;
    private KeyStoreCryptoOperationStreamer mMessageStreamer;
    private Exception mCachedException;

    private void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$__constructor__() {
        this.mKeyStore = KeyStore.getInstance();
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineInitSign(PrivateKey key) throws InvalidKeyException {
        this.engineInitSign(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineInitSign(PrivateKey privateKey, SecureRandom random) throws InvalidKeyException {
        this.resetAll();
        boolean success = false;
        try {
            if (privateKey == null) {
                throw new InvalidKeyException("Unsupported key: null");
            }
            if (!(privateKey instanceof AndroidKeyStorePrivateKey)) {
                throw new InvalidKeyException("Unsupported private key type: " + privateKey);
            }
            AndroidKeyStoreKey keystoreKey = (AndroidKeyStoreKey)((Object)privateKey);
            this.mSigning = true;
            this.initKey(keystoreKey);
            this.appRandom = random;
            this.ensureKeystoreOperationInitialized();
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        this.resetAll();
        boolean success = false;
        try {
            if (publicKey == null) {
                throw new InvalidKeyException("Unsupported key: null");
            }
            if (!(publicKey instanceof AndroidKeyStorePublicKey)) {
                throw new InvalidKeyException("Unsupported public key type: " + publicKey);
            }
            AndroidKeyStorePublicKey keystoreKey = (AndroidKeyStorePublicKey)publicKey;
            this.mSigning = false;
            this.initKey(keystoreKey);
            this.appRandom = null;
            this.ensureKeystoreOperationInitialized();
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$initKey(AndroidKeyStoreKey key) throws InvalidKeyException {
        this.mKey = key;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$resetAll() {
        IBinder operationToken = this.mOperationToken;
        if (operationToken != null) {
            this.mOperationToken = null;
            this.mKeyStore.abort(operationToken);
        }
        this.mSigning = false;
        this.mKey = null;
        this.appRandom = null;
        this.mOperationToken = null;
        this.mOperationHandle = 0L;
        this.mMessageStreamer = null;
        this.mCachedException = null;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$resetWhilePreservingInitState() {
        IBinder operationToken = this.mOperationToken;
        if (operationToken != null) {
            this.mOperationToken = null;
            this.mKeyStore.abort(operationToken);
        }
        this.mOperationHandle = 0L;
        this.mMessageStreamer = null;
        this.mCachedException = null;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$ensureKeystoreOperationInitialized() throws InvalidKeyException {
        if (this.mMessageStreamer != null) {
            return;
        }
        if (this.mCachedException != null) {
            return;
        }
        if (this.mKey == null) {
            throw new IllegalStateException("Not initialized");
        }
        KeymasterArguments keymasterInputArgs = new KeymasterArguments();
        this.addAlgorithmSpecificParametersToBegin(keymasterInputArgs);
        OperationResult opResult = this.mKeyStore.begin(this.mKey.getAlias(), this.mSigning ? 2 : 3, true, keymasterInputArgs, null, this.mKey.getUid());
        if (opResult == null) {
            throw new KeyStoreConnectException();
        }
        this.mOperationToken = opResult.token;
        this.mOperationHandle = opResult.operationHandle;
        InvalidKeyException e = KeyStoreCryptoOperationUtils.getInvalidKeyExceptionForInit(this.mKeyStore, this.mKey, opResult.resultCode);
        if (e != null) {
            throw e;
        }
        if (this.mOperationToken == null) {
            throw new ProviderException("Keystore returned null operation token");
        }
        if (this.mOperationHandle == 0L) {
            throw new ProviderException("Keystore returned invalid operation handle");
        }
        this.mMessageStreamer = this.createMainDataStreamer(this.mKeyStore, opResult.token);
    }

    private final KeyStoreCryptoOperationStreamer $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$createMainDataStreamer(KeyStore keyStore, IBinder operationToken) {
        return new KeyStoreCryptoOperationChunkedStreamer(new KeyStoreCryptoOperationChunkedStreamer.MainDataStream(keyStore, operationToken));
    }

    private final long $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$getOperationHandle() {
        return this.mOperationHandle;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineUpdate(byte[] b, int off, int len) throws SignatureException {
        byte[] output;
        if (this.mCachedException != null) {
            throw new SignatureException(this.mCachedException);
        }
        try {
            this.ensureKeystoreOperationInitialized();
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(e);
        }
        if (len == 0) {
            return;
        }
        try {
            output = this.mMessageStreamer.update(b, off, len);
        }
        catch (KeyStoreException e) {
            throw new SignatureException(e);
        }
        if (output.length != 0) {
            throw new ProviderException("Update operation unexpectedly produced output: " + output.length + " bytes");
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineUpdate(byte b) throws SignatureException {
        this.engineUpdate(new byte[]{b}, 0, 1);
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineUpdate(ByteBuffer input) {
        int off;
        byte[] b;
        int len = input.remaining();
        if (input.hasArray()) {
            b = input.array();
            off = input.arrayOffset() + input.position();
            input.position(input.limit());
        } else {
            b = new byte[len];
            off = 0;
            input.get(b);
        }
        try {
            this.engineUpdate(b, off, len);
        }
        catch (SignatureException e) {
            this.mCachedException = e;
        }
    }

    private final int $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineSign(byte[] out, int outOffset, int outLen) throws SignatureException {
        return super.engineSign(out, outOffset, outLen);
    }

    private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineSign() throws SignatureException {
        byte[] signature;
        if (this.mCachedException != null) {
            throw new SignatureException(this.mCachedException);
        }
        try {
            this.ensureKeystoreOperationInitialized();
            byte[] additionalEntropy = KeyStoreCryptoOperationUtils.getRandomBytesToMixIntoKeystoreRng(this.appRandom, this.getAdditionalEntropyAmountForSign());
            signature = this.mMessageStreamer.doFinal(EmptyArray.BYTE, 0, 0, null, additionalEntropy);
        }
        catch (KeyStoreException | InvalidKeyException e) {
            throw new SignatureException(e);
        }
        this.resetWhilePreservingInitState();
        return signature;
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineVerify(byte[] signature) throws SignatureException {
        boolean verified;
        if (this.mCachedException != null) {
            throw new SignatureException(this.mCachedException);
        }
        try {
            this.ensureKeystoreOperationInitialized();
        }
        catch (InvalidKeyException e) {
            throw new SignatureException(e);
        }
        try {
            byte[] output = this.mMessageStreamer.doFinal(EmptyArray.BYTE, 0, 0, signature, null);
            if (output.length != 0) {
                throw new ProviderException("Signature verification unexpected produced output: " + output.length + " bytes");
            }
            verified = true;
        }
        catch (KeyStoreException e) {
            switch (e.getErrorCode()) {
                case -30: {
                    verified = false;
                    break;
                }
                default: {
                    throw new SignatureException(e);
                }
            }
        }
        this.resetWhilePreservingInitState();
        return verified;
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineVerify(byte[] sigBytes, int offset, int len) throws SignatureException {
        return this.engineVerify(ArrayUtils.subarray(sigBytes, offset, len));
    }

    @Deprecated
    private final Object $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineGetParameter(String param) throws InvalidParameterException {
        throw new InvalidParameterException();
    }

    @Deprecated
    private final void $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineSetParameter(String param, Object value) throws InvalidParameterException {
        throw new InvalidParameterException();
    }

    private final KeyStore $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$getKeyStore() {
        return this.mKeyStore;
    }

    private final boolean $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$isSigning() {
        return this.mSigning;
    }

    protected abstract int getAdditionalEntropyAmountForSign();

    protected abstract void addAlgorithmSpecificParametersToBegin(KeymasterArguments var1);

    private void __constructor__() {
        this.$$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$__constructor__();
    }

    public AndroidKeyStoreSignatureSpiBase() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$__constructor__(), this);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("engineInitSign", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineInitSign(java.security.PrivateKey ), this, privateKey);
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey, SecureRandom secureRandom) throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("engineInitSign", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineInitSign(java.security.PrivateKey java.security.SecureRandom ), this, privateKey, secureRandom);
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("engineInitVerify", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineInitVerify(java.security.PublicKey ), this, publicKey);
    }

    protected void initKey(AndroidKeyStoreKey androidKeyStoreKey) throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("initKey", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$initKey(android.security.keystore.AndroidKeyStoreKey ), this, androidKeyStoreKey);
    }

    protected void resetAll() {
        InvokeDynamicSupport.bootstrap("resetAll", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$resetAll(), this);
    }

    protected void resetWhilePreservingInitState() {
        InvokeDynamicSupport.bootstrap("resetWhilePreservingInitState", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$resetWhilePreservingInitState(), this);
    }

    private void ensureKeystoreOperationInitialized() throws InvalidKeyException {
        InvokeDynamicSupport.bootstrap("ensureKeystoreOperationInitialized", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$ensureKeystoreOperationInitialized(), this);
    }

    protected KeyStoreCryptoOperationStreamer createMainDataStreamer(KeyStore keyStore, IBinder iBinder) {
        return InvokeDynamicSupport.bootstrap("createMainDataStreamer", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$createMainDataStreamer(android.security.KeyStore android.os.IBinder ), this, keyStore, iBinder);
    }

    @Override
    public long getOperationHandle() {
        return (long)InvokeDynamicSupport.bootstrap("getOperationHandle", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$getOperationHandle(), this);
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        InvokeDynamicSupport.bootstrap("engineUpdate", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineUpdate(byte[] int int ), this, byArray, n, n2);
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        InvokeDynamicSupport.bootstrap("engineUpdate", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineUpdate(byte ), this, by);
    }

    @Override
    protected void engineUpdate(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrap("engineUpdate", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineUpdate(java.nio.ByteBuffer ), this, byteBuffer);
    }

    @Override
    protected int engineSign(byte[] byArray, int n, int n2) throws SignatureException {
        return (int)InvokeDynamicSupport.bootstrap("engineSign", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineSign(byte[] int int ), this, byArray, n, n2);
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        return InvokeDynamicSupport.bootstrap("engineSign", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineSign(), this);
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        return (boolean)InvokeDynamicSupport.bootstrap("engineVerify", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineVerify(byte[] ), this, byArray);
    }

    @Override
    protected boolean engineVerify(byte[] byArray, int n, int n2) throws SignatureException {
        return (boolean)InvokeDynamicSupport.bootstrap("engineVerify", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineVerify(byte[] int int ), this, byArray, n, n2);
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String string2) throws InvalidParameterException {
        return InvokeDynamicSupport.bootstrap("engineGetParameter", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineGetParameter(java.lang.String ), this, string2);
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String string2, Object object) throws InvalidParameterException {
        InvokeDynamicSupport.bootstrap("engineSetParameter", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$engineSetParameter(java.lang.String java.lang.Object ), this, string2, object);
    }

    protected KeyStore getKeyStore() {
        return InvokeDynamicSupport.bootstrap("getKeyStore", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$getKeyStore(), this);
    }

    protected boolean isSigning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSigning", $$robo$$android_security_keystore_AndroidKeyStoreSignatureSpiBase$isSigning(), this);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStoreSignatureSpiBase)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

