/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keystore.ArrayUtils;
import android.security.keystore.Utils;
import com.google.errorprone.annotations.DoNotMock;
import java.security.KeyStore;
import java.util.Date;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class KeyProtection
implements KeyStore.ProtectionParameter,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Date mKeyValidityStart;
    private Date mKeyValidityForOriginationEnd;
    private Date mKeyValidityForConsumptionEnd;
    private int mPurposes;
    private String[] mEncryptionPaddings;
    private String[] mSignaturePaddings;
    private String[] mDigests;
    private String[] mBlockModes;
    private boolean mRandomizedEncryptionRequired;
    private boolean mUserAuthenticationRequired;
    private int mUserAuthenticationValidityDurationSeconds;
    private boolean mUserAuthenticationValidWhileOnBody;
    private boolean mInvalidatedByBiometricEnrollment;
    private long mBoundToSecureUserId;
    private boolean mCriticalToDeviceEncryption;

    private void $$robo$$android_security_keystore_KeyProtection$__constructor__(Date keyValidityStart, Date keyValidityForOriginationEnd, Date keyValidityForConsumptionEnd, int purposes, String[] encryptionPaddings, String[] signaturePaddings, String[] digests, String[] blockModes, boolean randomizedEncryptionRequired, boolean userAuthenticationRequired, int userAuthenticationValidityDurationSeconds, boolean userAuthenticationValidWhileOnBody, boolean invalidatedByBiometricEnrollment, long boundToSecureUserId, boolean criticalToDeviceEncryption) {
        this.mKeyValidityStart = Utils.cloneIfNotNull(keyValidityStart);
        this.mKeyValidityForOriginationEnd = Utils.cloneIfNotNull(keyValidityForOriginationEnd);
        this.mKeyValidityForConsumptionEnd = Utils.cloneIfNotNull(keyValidityForConsumptionEnd);
        this.mPurposes = purposes;
        this.mEncryptionPaddings = ArrayUtils.cloneIfNotEmpty(ArrayUtils.nullToEmpty(encryptionPaddings));
        this.mSignaturePaddings = ArrayUtils.cloneIfNotEmpty(ArrayUtils.nullToEmpty(signaturePaddings));
        this.mDigests = ArrayUtils.cloneIfNotEmpty(digests);
        this.mBlockModes = ArrayUtils.cloneIfNotEmpty(ArrayUtils.nullToEmpty(blockModes));
        this.mRandomizedEncryptionRequired = randomizedEncryptionRequired;
        this.mUserAuthenticationRequired = userAuthenticationRequired;
        this.mUserAuthenticationValidityDurationSeconds = userAuthenticationValidityDurationSeconds;
        this.mUserAuthenticationValidWhileOnBody = userAuthenticationValidWhileOnBody;
        this.mInvalidatedByBiometricEnrollment = invalidatedByBiometricEnrollment;
        this.mBoundToSecureUserId = boundToSecureUserId;
        this.mCriticalToDeviceEncryption = criticalToDeviceEncryption;
    }

    private final Date $$robo$$android_security_keystore_KeyProtection$getKeyValidityStart() {
        return Utils.cloneIfNotNull(this.mKeyValidityStart);
    }

    private final Date $$robo$$android_security_keystore_KeyProtection$getKeyValidityForConsumptionEnd() {
        return Utils.cloneIfNotNull(this.mKeyValidityForConsumptionEnd);
    }

    private final Date $$robo$$android_security_keystore_KeyProtection$getKeyValidityForOriginationEnd() {
        return Utils.cloneIfNotNull(this.mKeyValidityForOriginationEnd);
    }

    private final int $$robo$$android_security_keystore_KeyProtection$getPurposes() {
        return this.mPurposes;
    }

    private final String[] $$robo$$android_security_keystore_KeyProtection$getEncryptionPaddings() {
        return ArrayUtils.cloneIfNotEmpty(this.mEncryptionPaddings);
    }

    private final String[] $$robo$$android_security_keystore_KeyProtection$getSignaturePaddings() {
        return ArrayUtils.cloneIfNotEmpty(this.mSignaturePaddings);
    }

    private final String[] $$robo$$android_security_keystore_KeyProtection$getDigests() {
        if (this.mDigests == null) {
            throw new IllegalStateException("Digests not specified");
        }
        return ArrayUtils.cloneIfNotEmpty(this.mDigests);
    }

    private final boolean $$robo$$android_security_keystore_KeyProtection$isDigestsSpecified() {
        return this.mDigests != null;
    }

    private final String[] $$robo$$android_security_keystore_KeyProtection$getBlockModes() {
        return ArrayUtils.cloneIfNotEmpty(this.mBlockModes);
    }

    private final boolean $$robo$$android_security_keystore_KeyProtection$isRandomizedEncryptionRequired() {
        return this.mRandomizedEncryptionRequired;
    }

    private final boolean $$robo$$android_security_keystore_KeyProtection$isUserAuthenticationRequired() {
        return this.mUserAuthenticationRequired;
    }

    private final int $$robo$$android_security_keystore_KeyProtection$getUserAuthenticationValidityDurationSeconds() {
        return this.mUserAuthenticationValidityDurationSeconds;
    }

    private final boolean $$robo$$android_security_keystore_KeyProtection$isUserAuthenticationValidWhileOnBody() {
        return this.mUserAuthenticationValidWhileOnBody;
    }

    private final boolean $$robo$$android_security_keystore_KeyProtection$isInvalidatedByBiometricEnrollment() {
        return this.mInvalidatedByBiometricEnrollment;
    }

    private final long $$robo$$android_security_keystore_KeyProtection$getBoundToSpecificSecureUserId() {
        return this.mBoundToSecureUserId;
    }

    private final boolean $$robo$$android_security_keystore_KeyProtection$isCriticalToDeviceEncryption() {
        return this.mCriticalToDeviceEncryption;
    }

    private /* synthetic */ void $$robo$$android_security_keystore_KeyProtection$__constructor__(Date x0, Date x1, Date x2, int x3, String[] x4, String[] x5, String[] x6, String[] x7, boolean x8, boolean x9, int x10, boolean x11, boolean x12, long x13, boolean x14, 1 x15) {
    }

    private void __constructor__(Date date, Date date2, Date date3, int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, long l, boolean bl5) {
        this.$$robo$$android_security_keystore_KeyProtection$__constructor__(date, date2, date3, n, stringArray, stringArray2, stringArray3, stringArray4, bl, bl2, n2, bl3, bl4, l, bl5);
    }

    public KeyProtection(Date date, Date date2, Date date3, int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, long l, boolean bl5) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProtection$__constructor__(java.util.Date java.util.Date java.util.Date int java.lang.String[] java.lang.String[] java.lang.String[] java.lang.String[] boolean boolean int boolean boolean long boolean ), this, date, date2, date3, n, stringArray, stringArray2, stringArray3, stringArray4, bl, bl2, n2, bl3, bl4, l, bl5);
    }

    public Date getKeyValidityStart() {
        return InvokeDynamicSupport.bootstrap("getKeyValidityStart", $$robo$$android_security_keystore_KeyProtection$getKeyValidityStart(), this);
    }

    public Date getKeyValidityForConsumptionEnd() {
        return InvokeDynamicSupport.bootstrap("getKeyValidityForConsumptionEnd", $$robo$$android_security_keystore_KeyProtection$getKeyValidityForConsumptionEnd(), this);
    }

    public Date getKeyValidityForOriginationEnd() {
        return InvokeDynamicSupport.bootstrap("getKeyValidityForOriginationEnd", $$robo$$android_security_keystore_KeyProtection$getKeyValidityForOriginationEnd(), this);
    }

    public int getPurposes() {
        return (int)InvokeDynamicSupport.bootstrap("getPurposes", $$robo$$android_security_keystore_KeyProtection$getPurposes(), this);
    }

    public String[] getEncryptionPaddings() {
        return InvokeDynamicSupport.bootstrap("getEncryptionPaddings", $$robo$$android_security_keystore_KeyProtection$getEncryptionPaddings(), this);
    }

    public String[] getSignaturePaddings() {
        return InvokeDynamicSupport.bootstrap("getSignaturePaddings", $$robo$$android_security_keystore_KeyProtection$getSignaturePaddings(), this);
    }

    public String[] getDigests() {
        return InvokeDynamicSupport.bootstrap("getDigests", $$robo$$android_security_keystore_KeyProtection$getDigests(), this);
    }

    public boolean isDigestsSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDigestsSpecified", $$robo$$android_security_keystore_KeyProtection$isDigestsSpecified(), this);
    }

    public String[] getBlockModes() {
        return InvokeDynamicSupport.bootstrap("getBlockModes", $$robo$$android_security_keystore_KeyProtection$getBlockModes(), this);
    }

    public boolean isRandomizedEncryptionRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRandomizedEncryptionRequired", $$robo$$android_security_keystore_KeyProtection$isRandomizedEncryptionRequired(), this);
    }

    public boolean isUserAuthenticationRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserAuthenticationRequired", $$robo$$android_security_keystore_KeyProtection$isUserAuthenticationRequired(), this);
    }

    public int getUserAuthenticationValidityDurationSeconds() {
        return (int)InvokeDynamicSupport.bootstrap("getUserAuthenticationValidityDurationSeconds", $$robo$$android_security_keystore_KeyProtection$getUserAuthenticationValidityDurationSeconds(), this);
    }

    public boolean isUserAuthenticationValidWhileOnBody() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserAuthenticationValidWhileOnBody", $$robo$$android_security_keystore_KeyProtection$isUserAuthenticationValidWhileOnBody(), this);
    }

    public boolean isInvalidatedByBiometricEnrollment() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInvalidatedByBiometricEnrollment", $$robo$$android_security_keystore_KeyProtection$isInvalidatedByBiometricEnrollment(), this);
    }

    public long getBoundToSpecificSecureUserId() {
        return (long)InvokeDynamicSupport.bootstrap("getBoundToSpecificSecureUserId", $$robo$$android_security_keystore_KeyProtection$getBoundToSpecificSecureUserId(), this);
    }

    public boolean isCriticalToDeviceEncryption() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCriticalToDeviceEncryption", $$robo$$android_security_keystore_KeyProtection$isCriticalToDeviceEncryption(), this);
    }

    private /* synthetic */ void __constructor__(Date date, Date date2, Date date3, int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, long l, boolean bl5, 1 var17_16) {
        this.$$robo$$android_security_keystore_KeyProtection$__constructor__(date, date2, date3, n, stringArray, stringArray2, stringArray3, stringArray4, bl, bl2, n2, bl3, bl4, l, bl5, var17_16);
    }

    public /* synthetic */ KeyProtection(Date date, Date date2, Date date3, int n, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, int n2, boolean bl3, boolean bl4, long l, boolean bl5, 1 var17_16) {
        this(date, date2, date3, n, stringArray, stringArray2, stringArray3, stringArray4, bl, bl2, n2, bl3, bl4, l, bl5);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProtection$__constructor__(java.util.Date java.util.Date java.util.Date int java.lang.String[] java.lang.String[] java.lang.String[] java.lang.String[] boolean boolean int boolean boolean long boolean android.security.keystore.KeyProtection$1 ), this, date, date2, date3, n, stringArray, stringArray2, stringArray3, stringArray4, bl, bl2, n2, bl3, bl4, l, bl5, var17_16);
    }

    public /* synthetic */ KeyProtection() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyProtection)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mPurposes;
        private Date mKeyValidityStart;
        private Date mKeyValidityForOriginationEnd;
        private Date mKeyValidityForConsumptionEnd;
        private String[] mEncryptionPaddings;
        private String[] mSignaturePaddings;
        private String[] mDigests;
        private String[] mBlockModes;
        private boolean mRandomizedEncryptionRequired;
        private boolean mUserAuthenticationRequired;
        private int mUserAuthenticationValidityDurationSeconds;
        private boolean mUserAuthenticationValidWhileOnBody;
        private boolean mInvalidatedByBiometricEnrollment;
        private long mBoundToSecureUserId;
        private boolean mCriticalToDeviceEncryption;

        private void $$robo$$android_security_keystore_KeyProtection_Builder$__constructor__(int purposes) {
            this.mRandomizedEncryptionRequired = true;
            this.mUserAuthenticationValidityDurationSeconds = -1;
            this.mInvalidatedByBiometricEnrollment = true;
            this.mBoundToSecureUserId = 0L;
            this.mCriticalToDeviceEncryption = false;
            this.mPurposes = purposes;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setKeyValidityStart(Date startDate) {
            this.mKeyValidityStart = Utils.cloneIfNotNull(startDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setKeyValidityEnd(Date endDate) {
            this.setKeyValidityForOriginationEnd(endDate);
            this.setKeyValidityForConsumptionEnd(endDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setKeyValidityForOriginationEnd(Date endDate) {
            this.mKeyValidityForOriginationEnd = Utils.cloneIfNotNull(endDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setKeyValidityForConsumptionEnd(Date endDate) {
            this.mKeyValidityForConsumptionEnd = Utils.cloneIfNotNull(endDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setEncryptionPaddings(String ... paddings) {
            this.mEncryptionPaddings = ArrayUtils.cloneIfNotEmpty(paddings);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setSignaturePaddings(String ... paddings) {
            this.mSignaturePaddings = ArrayUtils.cloneIfNotEmpty(paddings);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setDigests(String ... digests) {
            this.mDigests = ArrayUtils.cloneIfNotEmpty(digests);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setBlockModes(String ... blockModes) {
            this.mBlockModes = ArrayUtils.cloneIfNotEmpty(blockModes);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setRandomizedEncryptionRequired(boolean required) {
            this.mRandomizedEncryptionRequired = required;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setUserAuthenticationRequired(boolean required) {
            this.mUserAuthenticationRequired = required;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setUserAuthenticationValidityDurationSeconds(int seconds) {
            if (seconds < -1) {
                throw new IllegalArgumentException("seconds must be -1 or larger");
            }
            this.mUserAuthenticationValidityDurationSeconds = seconds;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setUserAuthenticationValidWhileOnBody(boolean remainsValid) {
            this.mUserAuthenticationValidWhileOnBody = remainsValid;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setInvalidatedByBiometricEnrollment(boolean invalidateKey) {
            this.mInvalidatedByBiometricEnrollment = invalidateKey;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setBoundToSpecificSecureUserId(long secureUserId) {
            this.mBoundToSecureUserId = secureUserId;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyProtection_Builder$setCriticalToDeviceEncryption(boolean critical) {
            this.mCriticalToDeviceEncryption = critical;
            return this;
        }

        private final KeyProtection $$robo$$android_security_keystore_KeyProtection_Builder$build() {
            return new KeyProtection(this.mKeyValidityStart, this.mKeyValidityForOriginationEnd, this.mKeyValidityForConsumptionEnd, this.mPurposes, this.mEncryptionPaddings, this.mSignaturePaddings, this.mDigests, this.mBlockModes, this.mRandomizedEncryptionRequired, this.mUserAuthenticationRequired, this.mUserAuthenticationValidityDurationSeconds, this.mUserAuthenticationValidWhileOnBody, this.mInvalidatedByBiometricEnrollment, this.mBoundToSecureUserId, this.mCriticalToDeviceEncryption, null);
        }

        private void __constructor__(int n) {
            this.$$robo$$android_security_keystore_KeyProtection_Builder$__constructor__(n);
        }

        public Builder(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyProtection_Builder$__constructor__(int ), this, n);
        }

        public Builder setKeyValidityStart(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityStart", $$robo$$android_security_keystore_KeyProtection_Builder$setKeyValidityStart(java.util.Date ), this, date);
        }

        public Builder setKeyValidityEnd(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityEnd", $$robo$$android_security_keystore_KeyProtection_Builder$setKeyValidityEnd(java.util.Date ), this, date);
        }

        public Builder setKeyValidityForOriginationEnd(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityForOriginationEnd", $$robo$$android_security_keystore_KeyProtection_Builder$setKeyValidityForOriginationEnd(java.util.Date ), this, date);
        }

        public Builder setKeyValidityForConsumptionEnd(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityForConsumptionEnd", $$robo$$android_security_keystore_KeyProtection_Builder$setKeyValidityForConsumptionEnd(java.util.Date ), this, date);
        }

        public Builder setEncryptionPaddings(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setEncryptionPaddings", $$robo$$android_security_keystore_KeyProtection_Builder$setEncryptionPaddings(java.lang.String[] ), this, stringArray);
        }

        public Builder setSignaturePaddings(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setSignaturePaddings", $$robo$$android_security_keystore_KeyProtection_Builder$setSignaturePaddings(java.lang.String[] ), this, stringArray);
        }

        public Builder setDigests(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setDigests", $$robo$$android_security_keystore_KeyProtection_Builder$setDigests(java.lang.String[] ), this, stringArray);
        }

        public Builder setBlockModes(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setBlockModes", $$robo$$android_security_keystore_KeyProtection_Builder$setBlockModes(java.lang.String[] ), this, stringArray);
        }

        public Builder setRandomizedEncryptionRequired(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setRandomizedEncryptionRequired", $$robo$$android_security_keystore_KeyProtection_Builder$setRandomizedEncryptionRequired(boolean ), this, bl);
        }

        public Builder setUserAuthenticationRequired(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUserAuthenticationRequired", $$robo$$android_security_keystore_KeyProtection_Builder$setUserAuthenticationRequired(boolean ), this, bl);
        }

        public Builder setUserAuthenticationValidityDurationSeconds(int n) {
            return InvokeDynamicSupport.bootstrap("setUserAuthenticationValidityDurationSeconds", $$robo$$android_security_keystore_KeyProtection_Builder$setUserAuthenticationValidityDurationSeconds(int ), this, n);
        }

        public Builder setUserAuthenticationValidWhileOnBody(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUserAuthenticationValidWhileOnBody", $$robo$$android_security_keystore_KeyProtection_Builder$setUserAuthenticationValidWhileOnBody(boolean ), this, bl);
        }

        public Builder setInvalidatedByBiometricEnrollment(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setInvalidatedByBiometricEnrollment", $$robo$$android_security_keystore_KeyProtection_Builder$setInvalidatedByBiometricEnrollment(boolean ), this, bl);
        }

        public Builder setBoundToSpecificSecureUserId(long l) {
            return InvokeDynamicSupport.bootstrap("setBoundToSpecificSecureUserId", $$robo$$android_security_keystore_KeyProtection_Builder$setBoundToSpecificSecureUserId(long ), this, l);
        }

        public Builder setCriticalToDeviceEncryption(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setCriticalToDeviceEncryption", $$robo$$android_security_keystore_KeyProtection_Builder$setCriticalToDeviceEncryption(boolean ), this, bl);
        }

        public KeyProtection build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_security_keystore_KeyProtection_Builder$build(), this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

