/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.KeyStore;
import android.security.keystore.AndroidKeyStoreKey;
import android.security.keystore.UserNotAuthenticatedException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.SecureRandom;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class KeyStoreCryptoOperationUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static volatile SecureRandom sRng;

    private void $$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$__constructor__() {
    }

    private static final InvalidKeyException $$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$getInvalidKeyExceptionForInit(KeyStore keyStore, AndroidKeyStoreKey key, int beginOpResultCode) {
        if (beginOpResultCode == 1) {
            return null;
        }
        InvalidKeyException e = keyStore.getInvalidKeyException(key.getAlias(), key.getUid(), beginOpResultCode);
        switch (beginOpResultCode) {
            case 15: {
                if (!(e instanceof UserNotAuthenticatedException)) break;
                return null;
            }
        }
        return e;
    }

    private static final GeneralSecurityException $$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$getExceptionForCipherInit(KeyStore keyStore, AndroidKeyStoreKey key, int beginOpResultCode) {
        if (beginOpResultCode == 1) {
            return null;
        }
        switch (beginOpResultCode) {
            case -52: {
                return new InvalidAlgorithmParameterException("Invalid IV");
            }
            case -55: {
                return new InvalidAlgorithmParameterException("Caller-provided IV not permitted");
            }
        }
        return KeyStoreCryptoOperationUtils.getInvalidKeyExceptionForInit(keyStore, key, beginOpResultCode);
    }

    private static final byte[] $$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$getRandomBytesToMixIntoKeystoreRng(SecureRandom rng, int sizeBytes) {
        if (sizeBytes <= 0) {
            return EmptyArray.BYTE;
        }
        if (rng == null) {
            rng = KeyStoreCryptoOperationUtils.getRng();
        }
        byte[] result = new byte[sizeBytes];
        rng.nextBytes(result);
        return result;
    }

    private static final SecureRandom $$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$getRng() {
        if (sRng == null) {
            sRng = new SecureRandom();
        }
        return sRng;
    }

    private void __constructor__() {
        this.$$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$__constructor__();
    }

    public KeyStoreCryptoOperationUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$__constructor__(), this);
    }

    static InvalidKeyException getInvalidKeyExceptionForInit(KeyStore keyStore, AndroidKeyStoreKey androidKeyStoreKey, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getInvalidKeyExceptionForInit", $$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$getInvalidKeyExceptionForInit(android.security.KeyStore android.security.keystore.AndroidKeyStoreKey int ), (KeyStore)keyStore, (AndroidKeyStoreKey)androidKeyStoreKey, (int)n);
    }

    public static GeneralSecurityException getExceptionForCipherInit(KeyStore keyStore, AndroidKeyStoreKey androidKeyStoreKey, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getExceptionForCipherInit", $$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$getExceptionForCipherInit(android.security.KeyStore android.security.keystore.AndroidKeyStoreKey int ), (KeyStore)keyStore, (AndroidKeyStoreKey)androidKeyStoreKey, (int)n);
    }

    static byte[] getRandomBytesToMixIntoKeystoreRng(SecureRandom secureRandom, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getRandomBytesToMixIntoKeystoreRng", $$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$getRandomBytesToMixIntoKeystoreRng(java.security.SecureRandom int ), (SecureRandom)secureRandom, (int)n);
    }

    private static SecureRandom getRng() {
        return InvokeDynamicSupport.bootstrapStatic("getRng", $$robo$$android_security_keystore_KeyStoreCryptoOperationUtils$getRng());
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyStoreCryptoOperationUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

