/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.CertificatesEntryRef;
import android.security.net.config.NetworkSecurityTrustManager;
import android.security.net.config.PinSet;
import android.security.net.config.SystemCertificateSource;
import android.security.net.config.TrustAnchor;
import android.security.net.config.UserCertificateSource;
import android.util.ArrayMap;
import android.util.ArraySet;
import com.google.errorprone.annotations.DoNotMock;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NetworkSecurityConfig
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static boolean DEFAULT_CLEARTEXT_TRAFFIC_PERMITTED = true;
    public static boolean DEFAULT_HSTS_ENFORCED = false;
    private boolean mCleartextTrafficPermitted;
    private boolean mHstsEnforced;
    private PinSet mPins;
    private List<CertificatesEntryRef> mCertificatesEntryRefs;
    private Set<TrustAnchor> mAnchors;
    private Object mAnchorsLock;
    private NetworkSecurityTrustManager mTrustManager;
    private Object mTrustManagerLock;

    private void $$robo$$android_security_net_config_NetworkSecurityConfig$__constructor__(boolean cleartextTrafficPermitted, boolean hstsEnforced, PinSet pins, List<CertificatesEntryRef> certificatesEntryRefs) {
        this.mAnchorsLock = new Object();
        this.mTrustManagerLock = new Object();
        this.mCleartextTrafficPermitted = cleartextTrafficPermitted;
        this.mHstsEnforced = hstsEnforced;
        this.mPins = pins;
        this.mCertificatesEntryRefs = certificatesEntryRefs;
        Collections.sort(this.mCertificatesEntryRefs, new Comparator<CertificatesEntryRef>(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ NetworkSecurityConfig this$0;

            private void $$robo$$android_security_net_config_NetworkSecurityConfig_1$__constructor__(NetworkSecurityConfig this$0) {
            }

            private final int $$robo$$android_security_net_config_NetworkSecurityConfig_1$compare(CertificatesEntryRef lhs, CertificatesEntryRef rhs) {
                if (lhs.overridesPins()) {
                    return rhs.overridesPins() ? 0 : -1;
                }
                return rhs.overridesPins() ? 1 : 0;
            }

            private void __constructor__(NetworkSecurityConfig networkSecurityConfig) {
                this.$$robo$$android_security_net_config_NetworkSecurityConfig_1$__constructor__(networkSecurityConfig);
            }
            {
                this.this$0 = networkSecurityConfig;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_NetworkSecurityConfig_1$__constructor__(android.security.net.config.NetworkSecurityConfig ), this, networkSecurityConfig);
            }

            @Override
            public int compare(CertificatesEntryRef certificatesEntryRef, CertificatesEntryRef certificatesEntryRef2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_security_net_config_NetworkSecurityConfig_1$compare(android.security.net.config.CertificatesEntryRef android.security.net.config.CertificatesEntryRef ), this, certificatesEntryRef, certificatesEntryRef2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Set<TrustAnchor> $$robo$$android_security_net_config_NetworkSecurityConfig$getTrustAnchors() {
        Object object = this.mAnchorsLock;
        synchronized (object) {
            if (this.mAnchors != null) {
                return this.mAnchors;
            }
            ArrayMap<X509Certificate, TrustAnchor> anchorMap = new ArrayMap<X509Certificate, TrustAnchor>();
            for (CertificatesEntryRef ref : this.mCertificatesEntryRefs) {
                Set<TrustAnchor> anchors = ref.getTrustAnchors();
                for (TrustAnchor anchor : anchors) {
                    X509Certificate cert = anchor.certificate;
                    if (anchorMap.containsKey(cert)) continue;
                    anchorMap.put(cert, anchor);
                }
            }
            ArraySet<TrustAnchor> anchors = new ArraySet<TrustAnchor>(anchorMap.size());
            anchors.addAll(anchorMap.values());
            this.mAnchors = anchors;
            return this.mAnchors;
        }
    }

    private final boolean $$robo$$android_security_net_config_NetworkSecurityConfig$isCleartextTrafficPermitted() {
        return this.mCleartextTrafficPermitted;
    }

    private final boolean $$robo$$android_security_net_config_NetworkSecurityConfig$isHstsEnforced() {
        return this.mHstsEnforced;
    }

    private final PinSet $$robo$$android_security_net_config_NetworkSecurityConfig$getPins() {
        return this.mPins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final NetworkSecurityTrustManager $$robo$$android_security_net_config_NetworkSecurityConfig$getTrustManager() {
        Object object = this.mTrustManagerLock;
        synchronized (object) {
            if (this.mTrustManager == null) {
                this.mTrustManager = new NetworkSecurityTrustManager(this);
            }
            return this.mTrustManager;
        }
    }

    private final TrustAnchor $$robo$$android_security_net_config_NetworkSecurityConfig$findTrustAnchorBySubjectAndPublicKey(X509Certificate cert) {
        for (CertificatesEntryRef ref : this.mCertificatesEntryRefs) {
            TrustAnchor anchor = ref.findBySubjectAndPublicKey(cert);
            if (anchor == null) continue;
            return anchor;
        }
        return null;
    }

    private final TrustAnchor $$robo$$android_security_net_config_NetworkSecurityConfig$findTrustAnchorByIssuerAndSignature(X509Certificate cert) {
        for (CertificatesEntryRef ref : this.mCertificatesEntryRefs) {
            TrustAnchor anchor = ref.findByIssuerAndSignature(cert);
            if (anchor == null) continue;
            return anchor;
        }
        return null;
    }

    private final Set<X509Certificate> $$robo$$android_security_net_config_NetworkSecurityConfig$findAllCertificatesByIssuerAndSignature(X509Certificate cert) {
        ArraySet<X509Certificate> certs = new ArraySet<X509Certificate>();
        for (CertificatesEntryRef ref : this.mCertificatesEntryRefs) {
            certs.addAll(ref.findAllCertificatesByIssuerAndSignature(cert));
        }
        return certs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_net_config_NetworkSecurityConfig$handleTrustStorageUpdate() {
        Object object = this.mAnchorsLock;
        synchronized (object) {
            this.mAnchors = null;
            for (CertificatesEntryRef ref : this.mCertificatesEntryRefs) {
                ref.handleTrustStorageUpdate();
            }
        }
        this.getTrustManager().handleTrustStorageUpdate();
    }

    private static final Builder $$robo$$android_security_net_config_NetworkSecurityConfig$getDefaultBuilder(int targetSdkVersion, int targetSandboxVesrsion) {
        Builder builder = new Builder().setHstsEnforced(false).addCertificatesEntryRef(new CertificatesEntryRef(SystemCertificateSource.getInstance(), false));
        boolean cleartextTrafficPermitted = targetSandboxVesrsion < 2;
        builder.setCleartextTrafficPermitted(cleartextTrafficPermitted);
        if (targetSdkVersion <= 23) {
            builder.addCertificatesEntryRef(new CertificatesEntryRef(UserCertificateSource.getInstance(), false));
        }
        return builder;
    }

    private /* synthetic */ void $$robo$$android_security_net_config_NetworkSecurityConfig$__constructor__(boolean x0, boolean x1, PinSet x2, List x3, 1 x4) {
    }

    private void __constructor__(boolean bl, boolean bl2, PinSet pinSet, List<CertificatesEntryRef> list) {
        this.$$robo$$android_security_net_config_NetworkSecurityConfig$__constructor__(bl, bl2, pinSet, list);
    }

    public NetworkSecurityConfig(boolean bl, boolean bl2, PinSet pinSet, List<CertificatesEntryRef> list) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_NetworkSecurityConfig$__constructor__(boolean boolean android.security.net.config.PinSet java.util.List<android.security.net.config.CertificatesEntryRef> ), this, bl, bl2, pinSet, list);
    }

    public Set<TrustAnchor> getTrustAnchors() {
        return InvokeDynamicSupport.bootstrap("getTrustAnchors", $$robo$$android_security_net_config_NetworkSecurityConfig$getTrustAnchors(), this);
    }

    public boolean isCleartextTrafficPermitted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCleartextTrafficPermitted", $$robo$$android_security_net_config_NetworkSecurityConfig$isCleartextTrafficPermitted(), this);
    }

    public boolean isHstsEnforced() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHstsEnforced", $$robo$$android_security_net_config_NetworkSecurityConfig$isHstsEnforced(), this);
    }

    public PinSet getPins() {
        return InvokeDynamicSupport.bootstrap("getPins", $$robo$$android_security_net_config_NetworkSecurityConfig$getPins(), this);
    }

    public NetworkSecurityTrustManager getTrustManager() {
        return InvokeDynamicSupport.bootstrap("getTrustManager", $$robo$$android_security_net_config_NetworkSecurityConfig$getTrustManager(), this);
    }

    public TrustAnchor findTrustAnchorBySubjectAndPublicKey(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findTrustAnchorBySubjectAndPublicKey", $$robo$$android_security_net_config_NetworkSecurityConfig$findTrustAnchorBySubjectAndPublicKey(java.security.cert.X509Certificate ), this, x509Certificate);
    }

    public TrustAnchor findTrustAnchorByIssuerAndSignature(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findTrustAnchorByIssuerAndSignature", $$robo$$android_security_net_config_NetworkSecurityConfig$findTrustAnchorByIssuerAndSignature(java.security.cert.X509Certificate ), this, x509Certificate);
    }

    public Set<X509Certificate> findAllCertificatesByIssuerAndSignature(X509Certificate x509Certificate) {
        return InvokeDynamicSupport.bootstrap("findAllCertificatesByIssuerAndSignature", $$robo$$android_security_net_config_NetworkSecurityConfig$findAllCertificatesByIssuerAndSignature(java.security.cert.X509Certificate ), this, x509Certificate);
    }

    public void handleTrustStorageUpdate() {
        InvokeDynamicSupport.bootstrap("handleTrustStorageUpdate", $$robo$$android_security_net_config_NetworkSecurityConfig$handleTrustStorageUpdate(), this);
    }

    public static Builder getDefaultBuilder(int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("getDefaultBuilder", $$robo$$android_security_net_config_NetworkSecurityConfig$getDefaultBuilder(int int ), (int)n, (int)n2);
    }

    private /* synthetic */ void __constructor__(boolean bl, boolean bl2, PinSet pinSet, List list, 1 var5_5) {
        this.$$robo$$android_security_net_config_NetworkSecurityConfig$__constructor__(bl, bl2, pinSet, list, var5_5);
    }

    public /* synthetic */ NetworkSecurityConfig(boolean bl, boolean bl2, PinSet pinSet, List list, 1 var5_5) {
        this(bl, bl2, pinSet, list);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_NetworkSecurityConfig$__constructor__(boolean boolean android.security.net.config.PinSet java.util.List android.security.net.config.NetworkSecurityConfig$1 ), this, bl, bl2, pinSet, list, var5_5);
    }

    public /* synthetic */ NetworkSecurityConfig() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkSecurityConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private List<CertificatesEntryRef> mCertificatesEntryRefs;
        private PinSet mPinSet;
        private boolean mCleartextTrafficPermitted;
        private boolean mHstsEnforced;
        private boolean mCleartextTrafficPermittedSet;
        private boolean mHstsEnforcedSet;
        private Builder mParentBuilder;

        private void $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$__constructor__() {
            this.mCleartextTrafficPermitted = true;
            this.mHstsEnforced = false;
            this.mCleartextTrafficPermittedSet = false;
            this.mHstsEnforcedSet = false;
        }

        private final Builder $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$setParent(Builder parent) {
            for (Builder current = parent; current != null; current = current.getParent()) {
                if (current != this) continue;
                throw new IllegalArgumentException("Loops are not allowed in Builder parents");
            }
            this.mParentBuilder = parent;
            return this;
        }

        private final Builder $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getParent() {
            return this.mParentBuilder;
        }

        private final Builder $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$setPinSet(PinSet pinSet) {
            this.mPinSet = pinSet;
            return this;
        }

        private final PinSet $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getEffectivePinSet() {
            if (this.mPinSet != null) {
                return this.mPinSet;
            }
            if (this.mParentBuilder != null) {
                return this.mParentBuilder.getEffectivePinSet();
            }
            return PinSet.EMPTY_PINSET;
        }

        private final Builder $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$setCleartextTrafficPermitted(boolean cleartextTrafficPermitted) {
            this.mCleartextTrafficPermitted = cleartextTrafficPermitted;
            this.mCleartextTrafficPermittedSet = true;
            return this;
        }

        private final boolean $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getEffectiveCleartextTrafficPermitted() {
            if (this.mCleartextTrafficPermittedSet) {
                return this.mCleartextTrafficPermitted;
            }
            if (this.mParentBuilder != null) {
                return this.mParentBuilder.getEffectiveCleartextTrafficPermitted();
            }
            return true;
        }

        private final Builder $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$setHstsEnforced(boolean hstsEnforced) {
            this.mHstsEnforced = hstsEnforced;
            this.mHstsEnforcedSet = true;
            return this;
        }

        private final boolean $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getEffectiveHstsEnforced() {
            if (this.mHstsEnforcedSet) {
                return this.mHstsEnforced;
            }
            if (this.mParentBuilder != null) {
                return this.mParentBuilder.getEffectiveHstsEnforced();
            }
            return false;
        }

        private final Builder $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$addCertificatesEntryRef(CertificatesEntryRef ref) {
            if (this.mCertificatesEntryRefs == null) {
                this.mCertificatesEntryRefs = new ArrayList<CertificatesEntryRef>();
            }
            this.mCertificatesEntryRefs.add(ref);
            return this;
        }

        private final Builder $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$addCertificatesEntryRefs(Collection<? extends CertificatesEntryRef> refs) {
            if (this.mCertificatesEntryRefs == null) {
                this.mCertificatesEntryRefs = new ArrayList<CertificatesEntryRef>();
            }
            this.mCertificatesEntryRefs.addAll(refs);
            return this;
        }

        private final List<CertificatesEntryRef> $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getEffectiveCertificatesEntryRefs() {
            if (this.mCertificatesEntryRefs != null) {
                return this.mCertificatesEntryRefs;
            }
            if (this.mParentBuilder != null) {
                return this.mParentBuilder.getEffectiveCertificatesEntryRefs();
            }
            return Collections.emptyList();
        }

        private final boolean $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$hasCertificatesEntryRefs() {
            return this.mCertificatesEntryRefs != null;
        }

        private final List<CertificatesEntryRef> $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getCertificatesEntryRefs() {
            return this.mCertificatesEntryRefs;
        }

        private final NetworkSecurityConfig $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$build() {
            boolean cleartextPermitted = this.getEffectiveCleartextTrafficPermitted();
            boolean hstsEnforced = this.getEffectiveHstsEnforced();
            PinSet pinSet = this.getEffectivePinSet();
            List<CertificatesEntryRef> entryRefs = this.getEffectiveCertificatesEntryRefs();
            return new NetworkSecurityConfig(cleartextPermitted, hstsEnforced, pinSet, entryRefs, null);
        }

        private void __constructor__() {
            this.$$robo$$android_security_net_config_NetworkSecurityConfig_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$__constructor__(), this);
        }

        public Builder setParent(Builder builder) {
            return InvokeDynamicSupport.bootstrap("setParent", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$setParent(android.security.net.config.NetworkSecurityConfig$Builder ), this, builder);
        }

        public Builder getParent() {
            return InvokeDynamicSupport.bootstrap("getParent", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getParent(), this);
        }

        public Builder setPinSet(PinSet pinSet) {
            return InvokeDynamicSupport.bootstrap("setPinSet", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$setPinSet(android.security.net.config.PinSet ), this, pinSet);
        }

        private PinSet getEffectivePinSet() {
            return InvokeDynamicSupport.bootstrap("getEffectivePinSet", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getEffectivePinSet(), this);
        }

        public Builder setCleartextTrafficPermitted(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setCleartextTrafficPermitted", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$setCleartextTrafficPermitted(boolean ), this, bl);
        }

        private boolean getEffectiveCleartextTrafficPermitted() {
            return (boolean)InvokeDynamicSupport.bootstrap("getEffectiveCleartextTrafficPermitted", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getEffectiveCleartextTrafficPermitted(), this);
        }

        public Builder setHstsEnforced(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setHstsEnforced", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$setHstsEnforced(boolean ), this, bl);
        }

        private boolean getEffectiveHstsEnforced() {
            return (boolean)InvokeDynamicSupport.bootstrap("getEffectiveHstsEnforced", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getEffectiveHstsEnforced(), this);
        }

        public Builder addCertificatesEntryRef(CertificatesEntryRef certificatesEntryRef) {
            return InvokeDynamicSupport.bootstrap("addCertificatesEntryRef", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$addCertificatesEntryRef(android.security.net.config.CertificatesEntryRef ), this, certificatesEntryRef);
        }

        public Builder addCertificatesEntryRefs(Collection<? extends CertificatesEntryRef> collection) {
            return InvokeDynamicSupport.bootstrap("addCertificatesEntryRefs", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$addCertificatesEntryRefs(java.util.Collection<? extends android.security.net.config.CertificatesEntryRef> ), this, collection);
        }

        private List<CertificatesEntryRef> getEffectiveCertificatesEntryRefs() {
            return InvokeDynamicSupport.bootstrap("getEffectiveCertificatesEntryRefs", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getEffectiveCertificatesEntryRefs(), this);
        }

        public boolean hasCertificatesEntryRefs() {
            return (boolean)InvokeDynamicSupport.bootstrap("hasCertificatesEntryRefs", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$hasCertificatesEntryRefs(), this);
        }

        List<CertificatesEntryRef> getCertificatesEntryRefs() {
            return InvokeDynamicSupport.bootstrap("getCertificatesEntryRefs", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$getCertificatesEntryRefs(), this);
        }

        public NetworkSecurityConfig build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_security_net_config_NetworkSecurityConfig_Builder$build(), this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

