/*
 * Decompiled with CFR 0.152.
 */
package android.security.net.config;

import android.security.net.config.NetworkSecurityConfig;
import android.security.net.config.Pin;
import android.security.net.config.PinSet;
import android.security.net.config.TrustAnchor;
import android.security.net.config.TrustedCertificateStoreAdapter;
import android.util.ArrayMap;
import com.android.org.conscrypt.TrustManagerImpl;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.MessageDigest;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.X509ExtendedTrustManager;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkSecurityTrustManager
extends X509ExtendedTrustManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private TrustManagerImpl mDelegate;
    private NetworkSecurityConfig mNetworkSecurityConfig;
    private Object mIssuersLock;
    private X509Certificate[] mIssuers;

    private void $$robo$$android_security_net_config_NetworkSecurityTrustManager$__constructor__(NetworkSecurityConfig config) {
        this.mIssuersLock = new Object();
        if (config == null) {
            throw new NullPointerException("config must not be null");
        }
        this.mNetworkSecurityConfig = config;
        try {
            TrustedCertificateStoreAdapter certStore = new TrustedCertificateStoreAdapter(config);
            KeyStore store = KeyStore.getInstance(KeyStore.getDefaultType());
            store.load(null);
            this.mDelegate = new TrustManagerImpl(store, null, certStore);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private final void $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.mDelegate.checkClientTrusted(chain, authType);
    }

    private final void $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkClientTrusted(X509Certificate[] certs, String authType, Socket socket) throws CertificateException {
        this.mDelegate.checkClientTrusted(certs, authType, socket);
    }

    private final void $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkClientTrusted(X509Certificate[] certs, String authType, SSLEngine engine) throws CertificateException {
        this.mDelegate.checkClientTrusted(certs, authType, engine);
    }

    private final void $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkServerTrusted(X509Certificate[] certs, String authType) throws CertificateException {
        this.checkServerTrusted(certs, authType, (String)null);
    }

    private final void $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkServerTrusted(X509Certificate[] certs, String authType, Socket socket) throws CertificateException {
        List<X509Certificate> trustedChain = this.mDelegate.getTrustedChainForServer(certs, authType, socket);
        this.checkPins(trustedChain);
    }

    private final void $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkServerTrusted(X509Certificate[] certs, String authType, SSLEngine engine) throws CertificateException {
        List<X509Certificate> trustedChain = this.mDelegate.getTrustedChainForServer(certs, authType, engine);
        this.checkPins(trustedChain);
    }

    private final List<X509Certificate> $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkServerTrusted(X509Certificate[] certs, String authType, String host) throws CertificateException {
        List<X509Certificate> trustedChain = this.mDelegate.checkServerTrusted(certs, authType, host);
        this.checkPins(trustedChain);
        return trustedChain;
    }

    private final void $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkPins(List<X509Certificate> chain) throws CertificateException {
        PinSet pinSet = this.mNetworkSecurityConfig.getPins();
        if (pinSet.pins.isEmpty() || InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") > pinSet.expirationTime || !this.isPinningEnforced(chain)) {
            return;
        }
        Set<String> pinAlgorithms = pinSet.getPinAlgorithms();
        ArrayMap<String, MessageDigest> digestMap = new ArrayMap<String, MessageDigest>(pinAlgorithms.size());
        for (int i = chain.size() - 1; i >= 0; --i) {
            X509Certificate cert = chain.get(i);
            byte[] encodedSPKI = cert.getPublicKey().getEncoded();
            for (String algorithm : pinAlgorithms) {
                MessageDigest md = (MessageDigest)digestMap.get(algorithm);
                if (md == null) {
                    try {
                        md = MessageDigest.getInstance(algorithm);
                    }
                    catch (GeneralSecurityException e) {
                        throw new RuntimeException(e);
                    }
                    digestMap.put(algorithm, md);
                }
                if (!pinSet.pins.contains(new Pin(algorithm, md.digest(encodedSPKI)))) continue;
                return;
            }
        }
        throw new CertificateException("Pin verification failed");
    }

    private final boolean $$robo$$android_security_net_config_NetworkSecurityTrustManager$isPinningEnforced(List<X509Certificate> chain) throws CertificateException {
        if (chain.isEmpty()) {
            return false;
        }
        X509Certificate anchorCert = chain.get(chain.size() - 1);
        TrustAnchor chainAnchor = this.mNetworkSecurityConfig.findTrustAnchorBySubjectAndPublicKey(anchorCert);
        if (chainAnchor == null) {
            throw new CertificateException("Trusted chain does not end in a TrustAnchor");
        }
        return !chainAnchor.overridesPins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final X509Certificate[] $$robo$$android_security_net_config_NetworkSecurityTrustManager$getAcceptedIssuers() {
        Object object = this.mIssuersLock;
        synchronized (object) {
            if (this.mIssuers == null) {
                Set<TrustAnchor> anchors = this.mNetworkSecurityConfig.getTrustAnchors();
                X509Certificate[] issuers = new X509Certificate[anchors.size()];
                int i = 0;
                for (TrustAnchor anchor : anchors) {
                    issuers[i++] = anchor.certificate;
                }
                this.mIssuers = issuers;
            }
            return (X509Certificate[])this.mIssuers.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_net_config_NetworkSecurityTrustManager$handleTrustStorageUpdate() {
        Object object = this.mIssuersLock;
        synchronized (object) {
            this.mIssuers = null;
            this.mDelegate.handleTrustStorageUpdate();
        }
    }

    private void __constructor__(NetworkSecurityConfig networkSecurityConfig) {
        this.$$robo$$android_security_net_config_NetworkSecurityTrustManager$__constructor__(networkSecurityConfig);
    }

    public NetworkSecurityTrustManager(NetworkSecurityConfig networkSecurityConfig) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_net_config_NetworkSecurityTrustManager$__constructor__(android.security.net.config.NetworkSecurityConfig ), this, networkSecurityConfig);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkClientTrusted", $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkClientTrusted(java.security.cert.X509Certificate[] java.lang.String ), this, x509CertificateArray, string2);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2, Socket socket) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkClientTrusted", $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkClientTrusted(java.security.cert.X509Certificate[] java.lang.String java.net.Socket ), this, x509CertificateArray, string2, socket);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string2, SSLEngine sSLEngine) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkClientTrusted", $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkClientTrusted(java.security.cert.X509Certificate[] java.lang.String javax.net.ssl.SSLEngine ), this, x509CertificateArray, string2, sSLEngine);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String ), this, x509CertificateArray, string2);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2, Socket socket) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String java.net.Socket ), this, x509CertificateArray, string2, socket);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string2, SSLEngine sSLEngine) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String javax.net.ssl.SSLEngine ), this, x509CertificateArray, string2, sSLEngine);
    }

    public List<X509Certificate> checkServerTrusted(X509Certificate[] x509CertificateArray, String string2, String string3) throws CertificateException {
        return InvokeDynamicSupport.bootstrap("checkServerTrusted", $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkServerTrusted(java.security.cert.X509Certificate[] java.lang.String java.lang.String ), this, x509CertificateArray, string2, string3);
    }

    private void checkPins(List<X509Certificate> list) throws CertificateException {
        InvokeDynamicSupport.bootstrap("checkPins", $$robo$$android_security_net_config_NetworkSecurityTrustManager$checkPins(java.util.List<java.security.cert.X509Certificate> ), this, list);
    }

    private boolean isPinningEnforced(List<X509Certificate> list) throws CertificateException {
        return (boolean)InvokeDynamicSupport.bootstrap("isPinningEnforced", $$robo$$android_security_net_config_NetworkSecurityTrustManager$isPinningEnforced(java.util.List<java.security.cert.X509Certificate> ), this, list);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return InvokeDynamicSupport.bootstrap("getAcceptedIssuers", $$robo$$android_security_net_config_NetworkSecurityTrustManager$getAcceptedIssuers(), this);
    }

    public void handleTrustStorageUpdate() {
        InvokeDynamicSupport.bootstrap("handleTrustStorageUpdate", $$robo$$android_security_net_config_NetworkSecurityTrustManager$handleTrustStorageUpdate(), this);
    }

    public /* synthetic */ NetworkSecurityTrustManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkSecurityTrustManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

