/*
 * Decompiled with CFR 0.152.
 */
package android.speech;

import android.app.Service;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.RemoteException;
import android.speech.IRecognitionListener;
import android.speech.IRecognitionService;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.ref.WeakReference;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class RecognitionService
extends Service
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static String SERVICE_INTERFACE = "android.speech.RecognitionService";
    public static String SERVICE_META_DATA = "android.speech";
    private static String TAG = "RecognitionService";
    private static boolean DBG = false;
    private RecognitionServiceBinder mBinder;
    private Callback mCurrentCallback;
    private static int MSG_START_LISTENING = 1;
    private static int MSG_STOP_LISTENING = 2;
    private static int MSG_CANCEL = 3;
    private static int MSG_RESET = 4;
    private Handler mHandler;

    private void $$robo$$android_speech_RecognitionService$__constructor__() {
        this.mBinder = new RecognitionServiceBinder(this);
        this.mCurrentCallback = null;
        this.mHandler = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RecognitionService this$0;

            private void $$robo$$android_speech_RecognitionService_1$__constructor__(RecognitionService this$0) {
            }

            private final void $$robo$$android_speech_RecognitionService_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        StartListeningArgs args = (StartListeningArgs)msg.obj;
                        this.this$0.dispatchStartListening(args.mIntent, args.mListener, args.mCallingUid);
                        break;
                    }
                    case 2: {
                        this.this$0.dispatchStopListening((IRecognitionListener)msg.obj);
                        break;
                    }
                    case 3: {
                        this.this$0.dispatchCancel((IRecognitionListener)msg.obj);
                        break;
                    }
                    case 4: {
                        this.this$0.dispatchClearCallback();
                    }
                }
            }

            private void __constructor__(RecognitionService recognitionService) {
                this.$$robo$$android_speech_RecognitionService_1$__constructor__(recognitionService);
            }
            {
                this.this$0 = recognitionService;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_RecognitionService_1$__constructor__(android.speech.RecognitionService ), this, recognitionService);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_speech_RecognitionService_1$handleMessage(android.os.Message ), this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$android_speech_RecognitionService$dispatchStartListening(Intent intent, IRecognitionListener listener, int callingUid) {
        if (this.mCurrentCallback == null) {
            try {
                listener.asBinder().linkToDeath(new IBinder.DeathRecipient(this, listener){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ IRecognitionListener val$listener;
                    /* synthetic */ RecognitionService this$0;

                    private void $$robo$$android_speech_RecognitionService_2$__constructor__(RecognitionService this$0, IRecognitionListener iRecognitionListener) {
                        this.val$listener = iRecognitionListener;
                    }

                    private final void $$robo$$android_speech_RecognitionService_2$binderDied() {
                        this.this$0.mHandler.sendMessage(this.this$0.mHandler.obtainMessage(3, this.val$listener));
                    }

                    private void __constructor__(RecognitionService recognitionService, IRecognitionListener iRecognitionListener) {
                        this.$$robo$$android_speech_RecognitionService_2$__constructor__(recognitionService, iRecognitionListener);
                    }
                    {
                        this.this$0 = recognitionService;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_RecognitionService_2$__constructor__(android.speech.RecognitionService android.speech.IRecognitionListener ), this, recognitionService, iRecognitionListener);
                    }

                    @Override
                    public void binderDied() {
                        InvokeDynamicSupport.bootstrap("binderDied", $$robo$$android_speech_RecognitionService_2$binderDied(), this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                }, 0);
            }
            catch (RemoteException re) {
                Log.e("RecognitionService", "dead listener on startListening");
                return;
            }
            this.mCurrentCallback = new Callback(this, listener, callingUid, null);
            this.onStartListening(intent, this.mCurrentCallback);
        } else {
            try {
                listener.onError(8);
            }
            catch (RemoteException e) {
                Log.d("RecognitionService", "onError call from startListening failed");
            }
            Log.i("RecognitionService", "concurrent startListening received - ignoring this call");
        }
    }

    private final void $$robo$$android_speech_RecognitionService$dispatchStopListening(IRecognitionListener listener) {
        try {
            if (this.mCurrentCallback == null) {
                listener.onError(5);
                Log.w("RecognitionService", "stopListening called with no preceding startListening - ignoring");
            } else if (this.mCurrentCallback.mListener.asBinder() != listener.asBinder()) {
                listener.onError(8);
                Log.w("RecognitionService", "stopListening called by other caller than startListening - ignoring");
            } else {
                this.onStopListening(this.mCurrentCallback);
            }
        }
        catch (RemoteException e) {
            Log.d("RecognitionService", "onError call from stopListening failed");
        }
    }

    private final void $$robo$$android_speech_RecognitionService$dispatchCancel(IRecognitionListener listener) {
        if (this.mCurrentCallback != null) {
            if (this.mCurrentCallback.mListener.asBinder() != listener.asBinder()) {
                Log.w("RecognitionService", "cancel called by client who did not call startListening - ignoring");
            } else {
                this.onCancel(this.mCurrentCallback);
                this.mCurrentCallback = null;
            }
        }
    }

    private final void $$robo$$android_speech_RecognitionService$dispatchClearCallback() {
        this.mCurrentCallback = null;
    }

    private final boolean $$robo$$android_speech_RecognitionService$checkPermissions(IRecognitionListener listener) {
        if (this.checkCallingOrSelfPermission("android.permission.RECORD_AUDIO") == 0) {
            return true;
        }
        try {
            Log.e("RecognitionService", "call for recognition service without RECORD_AUDIO permissions");
            listener.onError(9);
        }
        catch (RemoteException re) {
            Log.e("RecognitionService", "sending ERROR_INSUFFICIENT_PERMISSIONS message failed", re);
        }
        return false;
    }

    protected abstract void onStartListening(Intent var1, Callback var2);

    protected abstract void onCancel(Callback var1);

    protected abstract void onStopListening(Callback var1);

    private final IBinder $$robo$$android_speech_RecognitionService$onBind(Intent intent) {
        return this.mBinder;
    }

    private final void $$robo$$android_speech_RecognitionService$onDestroy() {
        this.mCurrentCallback = null;
        this.mBinder.clearReference();
        super.onDestroy();
    }

    private void __constructor__() {
        this.$$robo$$android_speech_RecognitionService$__constructor__();
    }

    public RecognitionService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_RecognitionService$__constructor__(), this);
    }

    private void dispatchStartListening(Intent intent, IRecognitionListener iRecognitionListener, int n) {
        InvokeDynamicSupport.bootstrap("dispatchStartListening", $$robo$$android_speech_RecognitionService$dispatchStartListening(android.content.Intent android.speech.IRecognitionListener int ), this, intent, iRecognitionListener, n);
    }

    private void dispatchStopListening(IRecognitionListener iRecognitionListener) {
        InvokeDynamicSupport.bootstrap("dispatchStopListening", $$robo$$android_speech_RecognitionService$dispatchStopListening(android.speech.IRecognitionListener ), this, iRecognitionListener);
    }

    private void dispatchCancel(IRecognitionListener iRecognitionListener) {
        InvokeDynamicSupport.bootstrap("dispatchCancel", $$robo$$android_speech_RecognitionService$dispatchCancel(android.speech.IRecognitionListener ), this, iRecognitionListener);
    }

    private void dispatchClearCallback() {
        InvokeDynamicSupport.bootstrap("dispatchClearCallback", $$robo$$android_speech_RecognitionService$dispatchClearCallback(), this);
    }

    private boolean checkPermissions(IRecognitionListener iRecognitionListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkPermissions", $$robo$$android_speech_RecognitionService$checkPermissions(android.speech.IRecognitionListener ), this, iRecognitionListener);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_speech_RecognitionService$onBind(android.content.Intent ), this, intent);
    }

    @Override
    public void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$android_speech_RecognitionService$onDestroy(), this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecognitionService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class RecognitionServiceBinder
    extends IRecognitionService.Stub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private WeakReference<RecognitionService> mServiceRef;

        private void $$robo$$android_speech_RecognitionService_RecognitionServiceBinder$__constructor__(RecognitionService service) {
            this.mServiceRef = new WeakReference<RecognitionService>(service);
        }

        private final void $$robo$$android_speech_RecognitionService_RecognitionServiceBinder$startListening(Intent recognizerIntent, IRecognitionListener listener) {
            RecognitionService service = (RecognitionService)this.mServiceRef.get();
            if (service != null && service.checkPermissions(listener)) {
                Handler handler = service.mHandler;
                Handler handler2 = service.mHandler;
                RecognitionService recognitionService = service;
                recognitionService.getClass();
                handler.sendMessage(Message.obtain(handler2, 1, new StartListeningArgs(recognitionService, recognizerIntent, listener, Binder.getCallingUid())));
            }
        }

        private final void $$robo$$android_speech_RecognitionService_RecognitionServiceBinder$stopListening(IRecognitionListener listener) {
            RecognitionService service = (RecognitionService)this.mServiceRef.get();
            if (service != null && service.checkPermissions(listener)) {
                service.mHandler.sendMessage(Message.obtain(service.mHandler, 2, listener));
            }
        }

        private final void $$robo$$android_speech_RecognitionService_RecognitionServiceBinder$cancel(IRecognitionListener listener) {
            RecognitionService service = (RecognitionService)this.mServiceRef.get();
            if (service != null && service.checkPermissions(listener)) {
                service.mHandler.sendMessage(Message.obtain(service.mHandler, 3, listener));
            }
        }

        private final void $$robo$$android_speech_RecognitionService_RecognitionServiceBinder$clearReference() {
            this.mServiceRef.clear();
        }

        private void __constructor__(RecognitionService recognitionService) {
            this.$$robo$$android_speech_RecognitionService_RecognitionServiceBinder$__constructor__(recognitionService);
        }

        public RecognitionServiceBinder(RecognitionService recognitionService) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_RecognitionService_RecognitionServiceBinder$__constructor__(android.speech.RecognitionService ), this, recognitionService);
        }

        @Override
        public void startListening(Intent intent, IRecognitionListener iRecognitionListener) {
            InvokeDynamicSupport.bootstrap("startListening", $$robo$$android_speech_RecognitionService_RecognitionServiceBinder$startListening(android.content.Intent android.speech.IRecognitionListener ), this, intent, iRecognitionListener);
        }

        @Override
        public void stopListening(IRecognitionListener iRecognitionListener) {
            InvokeDynamicSupport.bootstrap("stopListening", $$robo$$android_speech_RecognitionService_RecognitionServiceBinder$stopListening(android.speech.IRecognitionListener ), this, iRecognitionListener);
        }

        @Override
        public void cancel(IRecognitionListener iRecognitionListener) {
            InvokeDynamicSupport.bootstrap("cancel", $$robo$$android_speech_RecognitionService_RecognitionServiceBinder$cancel(android.speech.IRecognitionListener ), this, iRecognitionListener);
        }

        public void clearReference() {
            InvokeDynamicSupport.bootstrap("clearReference", $$robo$$android_speech_RecognitionService_RecognitionServiceBinder$clearReference(), this);
        }

        public /* synthetic */ RecognitionServiceBinder() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecognitionServiceBinder)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class Callback
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private IRecognitionListener mListener;
        private int mCallingUid;
        /* synthetic */ RecognitionService this$0;

        private void $$robo$$android_speech_RecognitionService_Callback$__constructor__(RecognitionService this$0, IRecognitionListener listener, int callingUid) {
            this.mListener = listener;
            this.mCallingUid = callingUid;
        }

        private final void $$robo$$android_speech_RecognitionService_Callback$beginningOfSpeech() throws RemoteException {
            this.mListener.onBeginningOfSpeech();
        }

        private final void $$robo$$android_speech_RecognitionService_Callback$bufferReceived(byte[] buffer) throws RemoteException {
            this.mListener.onBufferReceived(buffer);
        }

        private final void $$robo$$android_speech_RecognitionService_Callback$endOfSpeech() throws RemoteException {
            this.mListener.onEndOfSpeech();
        }

        private final void $$robo$$android_speech_RecognitionService_Callback$error(int error) throws RemoteException {
            Message.obtain(this.this$0.mHandler, 4).sendToTarget();
            this.mListener.onError(error);
        }

        private final void $$robo$$android_speech_RecognitionService_Callback$partialResults(Bundle partialResults) throws RemoteException {
            this.mListener.onPartialResults(partialResults);
        }

        private final void $$robo$$android_speech_RecognitionService_Callback$readyForSpeech(Bundle params) throws RemoteException {
            this.mListener.onReadyForSpeech(params);
        }

        private final void $$robo$$android_speech_RecognitionService_Callback$results(Bundle results) throws RemoteException {
            Message.obtain(this.this$0.mHandler, 4).sendToTarget();
            this.mListener.onResults(results);
        }

        private final void $$robo$$android_speech_RecognitionService_Callback$rmsChanged(float rmsdB) throws RemoteException {
            this.mListener.onRmsChanged(rmsdB);
        }

        private final int $$robo$$android_speech_RecognitionService_Callback$getCallingUid() {
            return this.mCallingUid;
        }

        private /* synthetic */ void $$robo$$android_speech_RecognitionService_Callback$__constructor__(RecognitionService x0, IRecognitionListener x1, int x2, 1 x3) {
        }

        private void __constructor__(RecognitionService recognitionService, IRecognitionListener iRecognitionListener, int n) {
            this.$$robo$$android_speech_RecognitionService_Callback$__constructor__(recognitionService, iRecognitionListener, n);
        }

        public Callback(RecognitionService recognitionService, IRecognitionListener iRecognitionListener, int n) {
            this.this$0 = recognitionService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_RecognitionService_Callback$__constructor__(android.speech.RecognitionService android.speech.IRecognitionListener int ), this, recognitionService, iRecognitionListener, n);
        }

        public void beginningOfSpeech() throws RemoteException {
            InvokeDynamicSupport.bootstrap("beginningOfSpeech", $$robo$$android_speech_RecognitionService_Callback$beginningOfSpeech(), this);
        }

        public void bufferReceived(byte[] byArray) throws RemoteException {
            InvokeDynamicSupport.bootstrap("bufferReceived", $$robo$$android_speech_RecognitionService_Callback$bufferReceived(byte[] ), this, byArray);
        }

        public void endOfSpeech() throws RemoteException {
            InvokeDynamicSupport.bootstrap("endOfSpeech", $$robo$$android_speech_RecognitionService_Callback$endOfSpeech(), this);
        }

        public void error(int n) throws RemoteException {
            InvokeDynamicSupport.bootstrap("error", $$robo$$android_speech_RecognitionService_Callback$error(int ), this, n);
        }

        public void partialResults(Bundle bundle) throws RemoteException {
            InvokeDynamicSupport.bootstrap("partialResults", $$robo$$android_speech_RecognitionService_Callback$partialResults(android.os.Bundle ), this, bundle);
        }

        public void readyForSpeech(Bundle bundle) throws RemoteException {
            InvokeDynamicSupport.bootstrap("readyForSpeech", $$robo$$android_speech_RecognitionService_Callback$readyForSpeech(android.os.Bundle ), this, bundle);
        }

        public void results(Bundle bundle) throws RemoteException {
            InvokeDynamicSupport.bootstrap("results", $$robo$$android_speech_RecognitionService_Callback$results(android.os.Bundle ), this, bundle);
        }

        public void rmsChanged(float f) throws RemoteException {
            InvokeDynamicSupport.bootstrap("rmsChanged", $$robo$$android_speech_RecognitionService_Callback$rmsChanged(float ), this, f);
        }

        public int getCallingUid() {
            return (int)InvokeDynamicSupport.bootstrap("getCallingUid", $$robo$$android_speech_RecognitionService_Callback$getCallingUid(), this);
        }

        private /* synthetic */ void __constructor__(RecognitionService recognitionService, IRecognitionListener iRecognitionListener, int n, 1 var4_4) {
            this.$$robo$$android_speech_RecognitionService_Callback$__constructor__(recognitionService, iRecognitionListener, n, var4_4);
        }

        public /* synthetic */ Callback(RecognitionService recognitionService, IRecognitionListener iRecognitionListener, int n, 1 var4_4) {
            this(recognitionService, iRecognitionListener, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_RecognitionService_Callback$__constructor__(android.speech.RecognitionService android.speech.IRecognitionListener int android.speech.RecognitionService$1 ), this, recognitionService, iRecognitionListener, n, var4_4);
        }

        public /* synthetic */ Callback() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class StartListeningArgs
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public Intent mIntent;
        public IRecognitionListener mListener;
        public int mCallingUid;
        /* synthetic */ RecognitionService this$0;

        private void $$robo$$android_speech_RecognitionService_StartListeningArgs$__constructor__(RecognitionService recognitionService, Intent intent, IRecognitionListener listener, int callingUid) {
            this.mIntent = intent;
            this.mListener = listener;
            this.mCallingUid = callingUid;
        }

        private void __constructor__(RecognitionService recognitionService, Intent intent, IRecognitionListener iRecognitionListener, int n) {
            this.$$robo$$android_speech_RecognitionService_StartListeningArgs$__constructor__(recognitionService, intent, iRecognitionListener, n);
        }

        public StartListeningArgs(RecognitionService recognitionService, Intent intent, IRecognitionListener iRecognitionListener, int n) {
            this.this$0 = recognitionService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_RecognitionService_StartListeningArgs$__constructor__(android.speech.RecognitionService android.content.Intent android.speech.IRecognitionListener int ), this, recognitionService, intent, iRecognitionListener, n);
        }

        public /* synthetic */ StartListeningArgs() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StartListeningArgs)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

