/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyHistogram;
import android.util.SparseArray;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ClientRequestStats
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public static Parcelable.Creator<ClientRequestStats> CREATOR;
    private static int REQUEST_HISTOGRAM_BUCKET_COUNT = 5;
    private String mCallingPackage;
    private long mCompletedRequestsWakelockTime;
    private long mCompletedRequestsCount;
    private long mPendingRequestsWakelockTime;
    private long mPendingRequestsCount;
    private SparseArray<TelephonyHistogram> mRequestHistograms;

    private void $$robo$$android_telephony_ClientRequestStats$__constructor__(Parcel in) {
        this.mCompletedRequestsWakelockTime = 0L;
        this.mCompletedRequestsCount = 0L;
        this.mPendingRequestsWakelockTime = 0L;
        this.mPendingRequestsCount = 0L;
        this.mRequestHistograms = new SparseArray();
        this.readFromParcel(in);
    }

    private void $$robo$$android_telephony_ClientRequestStats$__constructor__() {
        this.mCompletedRequestsWakelockTime = 0L;
        this.mCompletedRequestsCount = 0L;
        this.mPendingRequestsWakelockTime = 0L;
        this.mPendingRequestsCount = 0L;
        this.mRequestHistograms = new SparseArray();
    }

    private void $$robo$$android_telephony_ClientRequestStats$__constructor__(ClientRequestStats clientRequestStats) {
        this.mCompletedRequestsWakelockTime = 0L;
        this.mCompletedRequestsCount = 0L;
        this.mPendingRequestsWakelockTime = 0L;
        this.mPendingRequestsCount = 0L;
        this.mRequestHistograms = new SparseArray();
        this.mCallingPackage = clientRequestStats.getCallingPackage();
        this.mCompletedRequestsCount = clientRequestStats.getCompletedRequestsCount();
        this.mCompletedRequestsWakelockTime = clientRequestStats.getCompletedRequestsWakelockTime();
        this.mPendingRequestsCount = clientRequestStats.getPendingRequestsCount();
        this.mPendingRequestsWakelockTime = clientRequestStats.getPendingRequestsWakelockTime();
        List<TelephonyHistogram> list = clientRequestStats.getRequestHistograms();
        for (TelephonyHistogram entry : list) {
            this.mRequestHistograms.put(entry.getId(), entry);
        }
    }

    private final String $$robo$$android_telephony_ClientRequestStats$getCallingPackage() {
        return this.mCallingPackage;
    }

    private final void $$robo$$android_telephony_ClientRequestStats$setCallingPackage(String mCallingPackage) {
        this.mCallingPackage = mCallingPackage;
    }

    private final long $$robo$$android_telephony_ClientRequestStats$getCompletedRequestsWakelockTime() {
        return this.mCompletedRequestsWakelockTime;
    }

    private final void $$robo$$android_telephony_ClientRequestStats$addCompletedWakelockTime(long completedRequestsWakelockTime) {
        this.mCompletedRequestsWakelockTime += completedRequestsWakelockTime;
    }

    private final long $$robo$$android_telephony_ClientRequestStats$getPendingRequestsWakelockTime() {
        return this.mPendingRequestsWakelockTime;
    }

    private final void $$robo$$android_telephony_ClientRequestStats$setPendingRequestsWakelockTime(long pendingRequestsWakelockTime) {
        this.mPendingRequestsWakelockTime = pendingRequestsWakelockTime;
    }

    private final long $$robo$$android_telephony_ClientRequestStats$getCompletedRequestsCount() {
        return this.mCompletedRequestsCount;
    }

    private final void $$robo$$android_telephony_ClientRequestStats$incrementCompletedRequestsCount() {
        ++this.mCompletedRequestsCount;
    }

    private final long $$robo$$android_telephony_ClientRequestStats$getPendingRequestsCount() {
        return this.mPendingRequestsCount;
    }

    private final void $$robo$$android_telephony_ClientRequestStats$setPendingRequestsCount(long pendingRequestsCount) {
        this.mPendingRequestsCount = pendingRequestsCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<TelephonyHistogram> $$robo$$android_telephony_ClientRequestStats$getRequestHistograms() {
        ArrayList<TelephonyHistogram> list;
        SparseArray<TelephonyHistogram> sparseArray = this.mRequestHistograms;
        synchronized (sparseArray) {
            list = new ArrayList<TelephonyHistogram>(this.mRequestHistograms.size());
            for (int i = 0; i < this.mRequestHistograms.size(); ++i) {
                TelephonyHistogram entry = new TelephonyHistogram(this.mRequestHistograms.valueAt(i));
                list.add(entry);
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telephony_ClientRequestStats$updateRequestHistograms(int requestId, int time) {
        SparseArray<TelephonyHistogram> sparseArray = this.mRequestHistograms;
        synchronized (sparseArray) {
            TelephonyHistogram entry = this.mRequestHistograms.get(requestId);
            if (entry == null) {
                entry = new TelephonyHistogram(1, requestId, 5);
                this.mRequestHistograms.put(requestId, entry);
            }
            entry.addTimeTaken(time);
        }
    }

    private final String $$robo$$android_telephony_ClientRequestStats$toString() {
        return "ClientRequestStats{mCallingPackage='" + this.mCallingPackage + '\'' + ", mCompletedRequestsWakelockTime=" + this.mCompletedRequestsWakelockTime + ", mCompletedRequestsCount=" + this.mCompletedRequestsCount + ", mPendingRequestsWakelockTime=" + this.mPendingRequestsWakelockTime + ", mPendingRequestsCount=" + this.mPendingRequestsCount + '}';
    }

    private final int $$robo$$android_telephony_ClientRequestStats$describeContents() {
        return 0;
    }

    private final void $$robo$$android_telephony_ClientRequestStats$readFromParcel(Parcel in) {
        this.mCallingPackage = in.readString();
        this.mCompletedRequestsWakelockTime = in.readLong();
        this.mCompletedRequestsCount = in.readLong();
        this.mPendingRequestsWakelockTime = in.readLong();
        this.mPendingRequestsCount = in.readLong();
        ArrayList requestHistograms = new ArrayList();
        in.readTypedList(requestHistograms, TelephonyHistogram.CREATOR);
        for (TelephonyHistogram h : requestHistograms) {
            this.mRequestHistograms.put(h.getId(), h);
        }
    }

    private final void $$robo$$android_telephony_ClientRequestStats$writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mCallingPackage);
        dest.writeLong(this.mCompletedRequestsWakelockTime);
        dest.writeLong(this.mCompletedRequestsCount);
        dest.writeLong(this.mPendingRequestsWakelockTime);
        dest.writeLong(this.mPendingRequestsCount);
        dest.writeTypedList(this.getRequestHistograms());
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ClientRequestStats>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_ClientRequestStats_1$__constructor__() {
            }

            private final ClientRequestStats $$robo$$android_telephony_ClientRequestStats_1$createFromParcel(Parcel in) {
                return new ClientRequestStats(in);
            }

            private final ClientRequestStats[] $$robo$$android_telephony_ClientRequestStats_1$newArray(int size) {
                return new ClientRequestStats[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_ClientRequestStats_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ClientRequestStats_1$__constructor__(), this);
            }

            @Override
            public ClientRequestStats createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_ClientRequestStats_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public ClientRequestStats[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_ClientRequestStats_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_ClientRequestStats$__constructor__(parcel);
    }

    public ClientRequestStats(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ClientRequestStats$__constructor__(android.os.Parcel ), this, parcel);
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_ClientRequestStats$__constructor__();
    }

    public ClientRequestStats() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ClientRequestStats$__constructor__(), this);
    }

    private void __constructor__(ClientRequestStats clientRequestStats) {
        this.$$robo$$android_telephony_ClientRequestStats$__constructor__(clientRequestStats);
    }

    public ClientRequestStats(ClientRequestStats clientRequestStats) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_ClientRequestStats$__constructor__(android.telephony.ClientRequestStats ), this, clientRequestStats);
    }

    public String getCallingPackage() {
        return InvokeDynamicSupport.bootstrap("getCallingPackage", $$robo$$android_telephony_ClientRequestStats$getCallingPackage(), this);
    }

    public void setCallingPackage(String string2) {
        InvokeDynamicSupport.bootstrap("setCallingPackage", $$robo$$android_telephony_ClientRequestStats$setCallingPackage(java.lang.String ), this, string2);
    }

    public long getCompletedRequestsWakelockTime() {
        return (long)InvokeDynamicSupport.bootstrap("getCompletedRequestsWakelockTime", $$robo$$android_telephony_ClientRequestStats$getCompletedRequestsWakelockTime(), this);
    }

    public void addCompletedWakelockTime(long l) {
        InvokeDynamicSupport.bootstrap("addCompletedWakelockTime", $$robo$$android_telephony_ClientRequestStats$addCompletedWakelockTime(long ), this, l);
    }

    public long getPendingRequestsWakelockTime() {
        return (long)InvokeDynamicSupport.bootstrap("getPendingRequestsWakelockTime", $$robo$$android_telephony_ClientRequestStats$getPendingRequestsWakelockTime(), this);
    }

    public void setPendingRequestsWakelockTime(long l) {
        InvokeDynamicSupport.bootstrap("setPendingRequestsWakelockTime", $$robo$$android_telephony_ClientRequestStats$setPendingRequestsWakelockTime(long ), this, l);
    }

    public long getCompletedRequestsCount() {
        return (long)InvokeDynamicSupport.bootstrap("getCompletedRequestsCount", $$robo$$android_telephony_ClientRequestStats$getCompletedRequestsCount(), this);
    }

    public void incrementCompletedRequestsCount() {
        InvokeDynamicSupport.bootstrap("incrementCompletedRequestsCount", $$robo$$android_telephony_ClientRequestStats$incrementCompletedRequestsCount(), this);
    }

    public long getPendingRequestsCount() {
        return (long)InvokeDynamicSupport.bootstrap("getPendingRequestsCount", $$robo$$android_telephony_ClientRequestStats$getPendingRequestsCount(), this);
    }

    public void setPendingRequestsCount(long l) {
        InvokeDynamicSupport.bootstrap("setPendingRequestsCount", $$robo$$android_telephony_ClientRequestStats$setPendingRequestsCount(long ), this, l);
    }

    public List<TelephonyHistogram> getRequestHistograms() {
        return InvokeDynamicSupport.bootstrap("getRequestHistograms", $$robo$$android_telephony_ClientRequestStats$getRequestHistograms(), this);
    }

    public void updateRequestHistograms(int n, int n2) {
        InvokeDynamicSupport.bootstrap("updateRequestHistograms", $$robo$$android_telephony_ClientRequestStats$updateRequestHistograms(int int ), this, n, n2);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_ClientRequestStats$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_ClientRequestStats$describeContents(), this);
    }

    public void readFromParcel(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readFromParcel", $$robo$$android_telephony_ClientRequestStats$readFromParcel(android.os.Parcel ), this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_ClientRequestStats$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    static {
        RobolectricInternals.classInitializing(ClientRequestStats.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ClientRequestStats)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

