/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.res.Resources;
import android.os.Binder;
import android.telephony.Rlog;
import android.telephony.SmsManager;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import com.android.internal.telephony.GsmAlphabet;
import com.android.internal.telephony.Sms7BitEncodingTranslator;
import com.android.internal.telephony.SmsMessageBase;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SmsMessage
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SmsMessage";
    public static int ENCODING_UNKNOWN = 0;
    public static int ENCODING_7BIT = 1;
    public static int ENCODING_8BIT = 2;
    public static int ENCODING_16BIT = 3;
    public static int ENCODING_KSC5601 = 4;
    public static int MAX_USER_DATA_BYTES = 140;
    public static int MAX_USER_DATA_BYTES_WITH_HEADER = 134;
    public static int MAX_USER_DATA_SEPTETS = 160;
    public static int MAX_USER_DATA_SEPTETS_WITH_HEADER = 153;
    public static String FORMAT_3GPP = "3gpp";
    public static String FORMAT_3GPP2 = "3gpp2";
    public SmsMessageBase mWrappedSmsMessage;
    private int mSubId;
    private static NoEmsSupportConfig[] mNoEmsSupportConfigList;
    private static boolean mIsNoEmsSupportConfigListLoaded;

    private final void $$robo$$android_telephony_SmsMessage$setSubId(int subId) {
        this.mSubId = subId;
    }

    private final int $$robo$$android_telephony_SmsMessage$getSubId() {
        return this.mSubId;
    }

    private void $$robo$$android_telephony_SmsMessage$__constructor__(SmsMessageBase smb) {
        this.mSubId = 0;
        this.mWrappedSmsMessage = smb;
    }

    @Deprecated
    private static final SmsMessage $$robo$$android_telephony_SmsMessage$createFromPdu(byte[] pdu) {
        SmsMessage message = null;
        int activePhone = TelephonyManager.getDefault().getCurrentPhoneType();
        String format = 2 == activePhone ? "3gpp2" : "3gpp";
        message = SmsMessage.createFromPdu(pdu, format);
        if (null == message || null == message.mWrappedSmsMessage) {
            format = 2 == activePhone ? "3gpp" : "3gpp2";
            message = SmsMessage.createFromPdu(pdu, format);
        }
        return message;
    }

    private static final SmsMessage $$robo$$android_telephony_SmsMessage$createFromPdu(byte[] pdu, String format) {
        SmsMessageBase wrappedMessage;
        if ("3gpp2".equals(format)) {
            wrappedMessage = com.android.internal.telephony.cdma.SmsMessage.createFromPdu(pdu);
        } else if ("3gpp".equals(format)) {
            wrappedMessage = com.android.internal.telephony.gsm.SmsMessage.createFromPdu(pdu);
        } else {
            Rlog.e("SmsMessage", "createFromPdu(): unsupported message format " + format);
            return null;
        }
        if (wrappedMessage != null) {
            return new SmsMessage(wrappedMessage);
        }
        Rlog.e("SmsMessage", "createFromPdu(): wrappedMessage is null");
        return null;
    }

    private static final SmsMessage $$robo$$android_telephony_SmsMessage$newFromCMT(byte[] pdu) {
        com.android.internal.telephony.gsm.SmsMessage wrappedMessage = com.android.internal.telephony.gsm.SmsMessage.newFromCMT(pdu);
        if (wrappedMessage != null) {
            return new SmsMessage(wrappedMessage);
        }
        Rlog.e("SmsMessage", "newFromCMT(): wrappedMessage is null");
        return null;
    }

    private static final SmsMessage $$robo$$android_telephony_SmsMessage$createFromEfRecord(int index, byte[] data) {
        SmsMessageBase wrappedMessage = SmsMessage.isCdmaVoice() ? com.android.internal.telephony.cdma.SmsMessage.createFromEfRecord(index, data) : com.android.internal.telephony.gsm.SmsMessage.createFromEfRecord(index, data);
        if (wrappedMessage != null) {
            return new SmsMessage(wrappedMessage);
        }
        Rlog.e("SmsMessage", "createFromEfRecord(): wrappedMessage is null");
        return null;
    }

    private static final int $$robo$$android_telephony_SmsMessage$getTPLayerLengthForPDU(String pdu) {
        if (SmsMessage.isCdmaVoice()) {
            return com.android.internal.telephony.cdma.SmsMessage.getTPLayerLengthForPDU(pdu);
        }
        return com.android.internal.telephony.gsm.SmsMessage.getTPLayerLengthForPDU(pdu);
    }

    private static final int[] $$robo$$android_telephony_SmsMessage$calculateLength(CharSequence msgBody, boolean use7bitOnly) {
        GsmAlphabet.TextEncodingDetails ted = SmsMessage.useCdmaFormatForMoSms() ? com.android.internal.telephony.cdma.SmsMessage.calculateLength(msgBody, use7bitOnly, true) : com.android.internal.telephony.gsm.SmsMessage.calculateLength(msgBody, use7bitOnly);
        int[] ret = new int[]{ted.msgCount, ted.codeUnitCount, ted.codeUnitsRemaining, ted.codeUnitSize};
        return ret;
    }

    private static final ArrayList<String> $$robo$$android_telephony_SmsMessage$fragmentText(String text) {
        int limit;
        GsmAlphabet.TextEncodingDetails ted;
        GsmAlphabet.TextEncodingDetails textEncodingDetails = ted = SmsMessage.useCdmaFormatForMoSms() ? com.android.internal.telephony.cdma.SmsMessage.calculateLength(text, false, true) : com.android.internal.telephony.gsm.SmsMessage.calculateLength(text, false);
        if (ted.codeUnitSize == 1) {
            int udhLength = ted.languageTable != 0 && ted.languageShiftTable != 0 ? 7 : (ted.languageTable != 0 || ted.languageShiftTable != 0 ? 4 : 0);
            if (ted.msgCount > 1) {
                udhLength += 6;
            }
            if (udhLength != 0) {
                ++udhLength;
            }
            limit = 160 - udhLength;
        } else if (ted.msgCount > 1) {
            limit = 134;
            if (!SmsMessage.hasEmsSupport() && ted.msgCount < 10) {
                limit -= 2;
            }
        } else {
            limit = 140;
        }
        String newMsgBody = null;
        Resources r = Resources.getSystem();
        if (r.getBoolean(17957004)) {
            newMsgBody = Sms7BitEncodingTranslator.translate(text);
        }
        if (TextUtils.isEmpty(newMsgBody)) {
            newMsgBody = text;
        }
        int pos = 0;
        int textLen = newMsgBody.length();
        ArrayList<String> result = new ArrayList<String>(ted.msgCount);
        while (pos < textLen) {
            int nextPos = 0;
            nextPos = ted.codeUnitSize == 1 ? (SmsMessage.useCdmaFormatForMoSms() && ted.msgCount == 1 ? pos + Math.min(limit, textLen - pos) : GsmAlphabet.findGsmSeptetLimitIndex(newMsgBody, pos, limit, ted.languageTable, ted.languageShiftTable)) : SmsMessageBase.findNextUnicodePosition(pos, limit, newMsgBody);
            if (nextPos <= pos || nextPos > textLen) {
                Rlog.e("SmsMessage", "fragmentText failed (" + pos + " >= " + nextPos + " or " + nextPos + " >= " + textLen + ")");
                break;
            }
            result.add(newMsgBody.substring(pos, nextPos));
            pos = nextPos;
        }
        return result;
    }

    private static final int[] $$robo$$android_telephony_SmsMessage$calculateLength(String messageBody, boolean use7bitOnly) {
        return SmsMessage.calculateLength((CharSequence)messageBody, use7bitOnly);
    }

    private static final SubmitPdu $$robo$$android_telephony_SmsMessage$getSubmitPdu(String scAddress, String destinationAddress, String message, boolean statusReportRequested) {
        SmsMessageBase.SubmitPduBase spb = SmsMessage.useCdmaFormatForMoSms() ? com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested, null) : com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddress, destinationAddress, message, statusReportRequested);
        return new SubmitPdu(spb);
    }

    private static final SubmitPdu $$robo$$android_telephony_SmsMessage$getSubmitPdu(String scAddress, String destinationAddress, short destinationPort, byte[] data, boolean statusReportRequested) {
        SmsMessageBase.SubmitPduBase spb = SmsMessage.useCdmaFormatForMoSms() ? com.android.internal.telephony.cdma.SmsMessage.getSubmitPdu(scAddress, destinationAddress, destinationPort, data, statusReportRequested) : com.android.internal.telephony.gsm.SmsMessage.getSubmitPdu(scAddress, destinationAddress, destinationPort, data, statusReportRequested);
        return new SubmitPdu(spb);
    }

    private final String $$robo$$android_telephony_SmsMessage$getServiceCenterAddress() {
        return this.mWrappedSmsMessage.getServiceCenterAddress();
    }

    private final String $$robo$$android_telephony_SmsMessage$getOriginatingAddress() {
        return this.mWrappedSmsMessage.getOriginatingAddress();
    }

    private final String $$robo$$android_telephony_SmsMessage$getDisplayOriginatingAddress() {
        return this.mWrappedSmsMessage.getDisplayOriginatingAddress();
    }

    private final String $$robo$$android_telephony_SmsMessage$getMessageBody() {
        return this.mWrappedSmsMessage.getMessageBody();
    }

    private final MessageClass $$robo$$android_telephony_SmsMessage$getMessageClass() {
        switch (1.$SwitchMap$com$android$internal$telephony$SmsConstants$MessageClass[this.mWrappedSmsMessage.getMessageClass().ordinal()]) {
            case 1: {
                return MessageClass.CLASS_0;
            }
            case 2: {
                return MessageClass.CLASS_1;
            }
            case 3: {
                return MessageClass.CLASS_2;
            }
            case 4: {
                return MessageClass.CLASS_3;
            }
        }
        return MessageClass.UNKNOWN;
    }

    private final String $$robo$$android_telephony_SmsMessage$getDisplayMessageBody() {
        return this.mWrappedSmsMessage.getDisplayMessageBody();
    }

    private final String $$robo$$android_telephony_SmsMessage$getPseudoSubject() {
        return this.mWrappedSmsMessage.getPseudoSubject();
    }

    private final long $$robo$$android_telephony_SmsMessage$getTimestampMillis() {
        return this.mWrappedSmsMessage.getTimestampMillis();
    }

    private final boolean $$robo$$android_telephony_SmsMessage$isEmail() {
        return this.mWrappedSmsMessage.isEmail();
    }

    private final String $$robo$$android_telephony_SmsMessage$getEmailBody() {
        return this.mWrappedSmsMessage.getEmailBody();
    }

    private final String $$robo$$android_telephony_SmsMessage$getEmailFrom() {
        return this.mWrappedSmsMessage.getEmailFrom();
    }

    private final int $$robo$$android_telephony_SmsMessage$getProtocolIdentifier() {
        return this.mWrappedSmsMessage.getProtocolIdentifier();
    }

    private final boolean $$robo$$android_telephony_SmsMessage$isReplace() {
        return this.mWrappedSmsMessage.isReplace();
    }

    private final boolean $$robo$$android_telephony_SmsMessage$isCphsMwiMessage() {
        return this.mWrappedSmsMessage.isCphsMwiMessage();
    }

    private final boolean $$robo$$android_telephony_SmsMessage$isMWIClearMessage() {
        return this.mWrappedSmsMessage.isMWIClearMessage();
    }

    private final boolean $$robo$$android_telephony_SmsMessage$isMWISetMessage() {
        return this.mWrappedSmsMessage.isMWISetMessage();
    }

    private final boolean $$robo$$android_telephony_SmsMessage$isMwiDontStore() {
        return this.mWrappedSmsMessage.isMwiDontStore();
    }

    private final byte[] $$robo$$android_telephony_SmsMessage$getUserData() {
        return this.mWrappedSmsMessage.getUserData();
    }

    private final byte[] $$robo$$android_telephony_SmsMessage$getPdu() {
        return this.mWrappedSmsMessage.getPdu();
    }

    @Deprecated
    private final int $$robo$$android_telephony_SmsMessage$getStatusOnSim() {
        return this.mWrappedSmsMessage.getStatusOnIcc();
    }

    private final int $$robo$$android_telephony_SmsMessage$getStatusOnIcc() {
        return this.mWrappedSmsMessage.getStatusOnIcc();
    }

    @Deprecated
    private final int $$robo$$android_telephony_SmsMessage$getIndexOnSim() {
        return this.mWrappedSmsMessage.getIndexOnIcc();
    }

    private final int $$robo$$android_telephony_SmsMessage$getIndexOnIcc() {
        return this.mWrappedSmsMessage.getIndexOnIcc();
    }

    private final int $$robo$$android_telephony_SmsMessage$getStatus() {
        return this.mWrappedSmsMessage.getStatus();
    }

    private final boolean $$robo$$android_telephony_SmsMessage$isStatusReportMessage() {
        return this.mWrappedSmsMessage.isStatusReportMessage();
    }

    private final boolean $$robo$$android_telephony_SmsMessage$isReplyPathPresent() {
        return this.mWrappedSmsMessage.isReplyPathPresent();
    }

    private static final boolean $$robo$$android_telephony_SmsMessage$useCdmaFormatForMoSms() {
        if (!SmsManager.getDefault().isImsSmsSupported()) {
            return SmsMessage.isCdmaVoice();
        }
        return "3gpp2".equals(SmsManager.getDefault().getImsSmsFormat());
    }

    private static final boolean $$robo$$android_telephony_SmsMessage$isCdmaVoice() {
        int activePhone = TelephonyManager.getDefault().getCurrentPhoneType();
        return 2 == activePhone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_telephony_SmsMessage$hasEmsSupport() {
        String gid;
        String simOperator;
        if (!SmsMessage.isNoEmsSupportConfigListExisted()) {
            return true;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            simOperator = TelephonyManager.getDefault().getSimOperatorNumeric();
            gid = TelephonyManager.getDefault().getGroupIdLevel1();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        if (!TextUtils.isEmpty(simOperator)) {
            for (NoEmsSupportConfig currentConfig : mNoEmsSupportConfigList) {
                if (!simOperator.startsWith(currentConfig.mOperatorNumber) || !TextUtils.isEmpty(currentConfig.mGid1) && (TextUtils.isEmpty(currentConfig.mGid1) || !currentConfig.mGid1.equalsIgnoreCase(gid))) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_telephony_SmsMessage$shouldAppendPageNumberAsPrefix() {
        String gid;
        String simOperator;
        if (!SmsMessage.isNoEmsSupportConfigListExisted()) {
            return false;
        }
        long identity = Binder.clearCallingIdentity();
        try {
            simOperator = TelephonyManager.getDefault().getSimOperatorNumeric();
            gid = TelephonyManager.getDefault().getGroupIdLevel1();
        }
        finally {
            Binder.restoreCallingIdentity(identity);
        }
        for (NoEmsSupportConfig currentConfig : mNoEmsSupportConfigList) {
            if (!simOperator.startsWith(currentConfig.mOperatorNumber) || !TextUtils.isEmpty(currentConfig.mGid1) && (TextUtils.isEmpty(currentConfig.mGid1) || !currentConfig.mGid1.equalsIgnoreCase(gid))) continue;
            return currentConfig.mIsPrefix;
        }
        return false;
    }

    private static final boolean $$robo$$android_telephony_SmsMessage$isNoEmsSupportConfigListExisted() {
        Resources r;
        if (!mIsNoEmsSupportConfigListLoaded && (r = Resources.getSystem()) != null) {
            String[] listArray = r.getStringArray(17236053);
            if (listArray != null && listArray.length > 0) {
                mNoEmsSupportConfigList = new NoEmsSupportConfig[listArray.length];
                for (int i = 0; i < listArray.length; ++i) {
                    SmsMessage.mNoEmsSupportConfigList[i] = new NoEmsSupportConfig(listArray[i].split(";"));
                }
            }
            mIsNoEmsSupportConfigListLoaded = true;
        }
        return mNoEmsSupportConfigList != null && mNoEmsSupportConfigList.length != 0;
    }

    static void __staticInitializer__() {
        mNoEmsSupportConfigList = null;
        mIsNoEmsSupportConfigListLoaded = false;
    }

    public void setSubId(int n) {
        InvokeDynamicSupport.bootstrap("setSubId", $$robo$$android_telephony_SmsMessage$setSubId(int ), this, n);
    }

    public int getSubId() {
        return (int)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$android_telephony_SmsMessage$getSubId(), this);
    }

    private void __constructor__(SmsMessageBase smsMessageBase) {
        this.$$robo$$android_telephony_SmsMessage$__constructor__(smsMessageBase);
    }

    public SmsMessage(SmsMessageBase smsMessageBase) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SmsMessage$__constructor__(com.android.internal.telephony.SmsMessageBase ), this, smsMessageBase);
    }

    @Deprecated
    public static SmsMessage createFromPdu(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromPdu", $$robo$$android_telephony_SmsMessage$createFromPdu(byte[] ), (byte[])byArray);
    }

    public static SmsMessage createFromPdu(byte[] byArray, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createFromPdu", $$robo$$android_telephony_SmsMessage$createFromPdu(byte[] java.lang.String ), (byte[])byArray, (String)string2);
    }

    public static SmsMessage newFromCMT(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("newFromCMT", $$robo$$android_telephony_SmsMessage$newFromCMT(byte[] ), (byte[])byArray);
    }

    public static SmsMessage createFromEfRecord(int n, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createFromEfRecord", $$robo$$android_telephony_SmsMessage$createFromEfRecord(int byte[] ), (int)n, (byte[])byArray);
    }

    public static int getTPLayerLengthForPDU(String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getTPLayerLengthForPDU", $$robo$$android_telephony_SmsMessage$getTPLayerLengthForPDU(java.lang.String ), (String)string2);
    }

    public static int[] calculateLength(CharSequence charSequence, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("calculateLength", $$robo$$android_telephony_SmsMessage$calculateLength(java.lang.CharSequence boolean ), (CharSequence)charSequence, (boolean)bl);
    }

    public static ArrayList<String> fragmentText(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("fragmentText", $$robo$$android_telephony_SmsMessage$fragmentText(java.lang.String ), (String)string2);
    }

    public static int[] calculateLength(String string2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("calculateLength", $$robo$$android_telephony_SmsMessage$calculateLength(java.lang.String boolean ), (String)string2, (boolean)bl);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, String string4, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getSubmitPdu", $$robo$$android_telephony_SmsMessage$getSubmitPdu(java.lang.String java.lang.String java.lang.String boolean ), (String)string2, (String)string3, (String)string4, (boolean)bl);
    }

    public static SubmitPdu getSubmitPdu(String string2, String string3, short s, byte[] byArray, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getSubmitPdu", $$robo$$android_telephony_SmsMessage$getSubmitPdu(java.lang.String java.lang.String short byte[] boolean ), (String)string2, (String)string3, (short)s, (byte[])byArray, (boolean)bl);
    }

    public String getServiceCenterAddress() {
        return InvokeDynamicSupport.bootstrap("getServiceCenterAddress", $$robo$$android_telephony_SmsMessage$getServiceCenterAddress(), this);
    }

    public String getOriginatingAddress() {
        return InvokeDynamicSupport.bootstrap("getOriginatingAddress", $$robo$$android_telephony_SmsMessage$getOriginatingAddress(), this);
    }

    public String getDisplayOriginatingAddress() {
        return InvokeDynamicSupport.bootstrap("getDisplayOriginatingAddress", $$robo$$android_telephony_SmsMessage$getDisplayOriginatingAddress(), this);
    }

    public String getMessageBody() {
        return InvokeDynamicSupport.bootstrap("getMessageBody", $$robo$$android_telephony_SmsMessage$getMessageBody(), this);
    }

    public MessageClass getMessageClass() {
        return InvokeDynamicSupport.bootstrap("getMessageClass", $$robo$$android_telephony_SmsMessage$getMessageClass(), this);
    }

    public String getDisplayMessageBody() {
        return InvokeDynamicSupport.bootstrap("getDisplayMessageBody", $$robo$$android_telephony_SmsMessage$getDisplayMessageBody(), this);
    }

    public String getPseudoSubject() {
        return InvokeDynamicSupport.bootstrap("getPseudoSubject", $$robo$$android_telephony_SmsMessage$getPseudoSubject(), this);
    }

    public long getTimestampMillis() {
        return (long)InvokeDynamicSupport.bootstrap("getTimestampMillis", $$robo$$android_telephony_SmsMessage$getTimestampMillis(), this);
    }

    public boolean isEmail() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmail", $$robo$$android_telephony_SmsMessage$isEmail(), this);
    }

    public String getEmailBody() {
        return InvokeDynamicSupport.bootstrap("getEmailBody", $$robo$$android_telephony_SmsMessage$getEmailBody(), this);
    }

    public String getEmailFrom() {
        return InvokeDynamicSupport.bootstrap("getEmailFrom", $$robo$$android_telephony_SmsMessage$getEmailFrom(), this);
    }

    public int getProtocolIdentifier() {
        return (int)InvokeDynamicSupport.bootstrap("getProtocolIdentifier", $$robo$$android_telephony_SmsMessage$getProtocolIdentifier(), this);
    }

    public boolean isReplace() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReplace", $$robo$$android_telephony_SmsMessage$isReplace(), this);
    }

    public boolean isCphsMwiMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCphsMwiMessage", $$robo$$android_telephony_SmsMessage$isCphsMwiMessage(), this);
    }

    public boolean isMWIClearMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMWIClearMessage", $$robo$$android_telephony_SmsMessage$isMWIClearMessage(), this);
    }

    public boolean isMWISetMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMWISetMessage", $$robo$$android_telephony_SmsMessage$isMWISetMessage(), this);
    }

    public boolean isMwiDontStore() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMwiDontStore", $$robo$$android_telephony_SmsMessage$isMwiDontStore(), this);
    }

    public byte[] getUserData() {
        return InvokeDynamicSupport.bootstrap("getUserData", $$robo$$android_telephony_SmsMessage$getUserData(), this);
    }

    public byte[] getPdu() {
        return InvokeDynamicSupport.bootstrap("getPdu", $$robo$$android_telephony_SmsMessage$getPdu(), this);
    }

    @Deprecated
    public int getStatusOnSim() {
        return (int)InvokeDynamicSupport.bootstrap("getStatusOnSim", $$robo$$android_telephony_SmsMessage$getStatusOnSim(), this);
    }

    public int getStatusOnIcc() {
        return (int)InvokeDynamicSupport.bootstrap("getStatusOnIcc", $$robo$$android_telephony_SmsMessage$getStatusOnIcc(), this);
    }

    @Deprecated
    public int getIndexOnSim() {
        return (int)InvokeDynamicSupport.bootstrap("getIndexOnSim", $$robo$$android_telephony_SmsMessage$getIndexOnSim(), this);
    }

    public int getIndexOnIcc() {
        return (int)InvokeDynamicSupport.bootstrap("getIndexOnIcc", $$robo$$android_telephony_SmsMessage$getIndexOnIcc(), this);
    }

    public int getStatus() {
        return (int)InvokeDynamicSupport.bootstrap("getStatus", $$robo$$android_telephony_SmsMessage$getStatus(), this);
    }

    public boolean isStatusReportMessage() {
        return (boolean)InvokeDynamicSupport.bootstrap("isStatusReportMessage", $$robo$$android_telephony_SmsMessage$isStatusReportMessage(), this);
    }

    public boolean isReplyPathPresent() {
        return (boolean)InvokeDynamicSupport.bootstrap("isReplyPathPresent", $$robo$$android_telephony_SmsMessage$isReplyPathPresent(), this);
    }

    private static boolean useCdmaFormatForMoSms() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("useCdmaFormatForMoSms", $$robo$$android_telephony_SmsMessage$useCdmaFormatForMoSms());
    }

    private static boolean isCdmaVoice() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isCdmaVoice", $$robo$$android_telephony_SmsMessage$isCdmaVoice());
    }

    public static boolean hasEmsSupport() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasEmsSupport", $$robo$$android_telephony_SmsMessage$hasEmsSupport());
    }

    public static boolean shouldAppendPageNumberAsPrefix() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldAppendPageNumberAsPrefix", $$robo$$android_telephony_SmsMessage$shouldAppendPageNumberAsPrefix());
    }

    private static boolean isNoEmsSupportConfigListExisted() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNoEmsSupportConfigListExisted", $$robo$$android_telephony_SmsMessage$isNoEmsSupportConfigListExisted());
    }

    static {
        RobolectricInternals.classInitializing(SmsMessage.class);
    }

    public /* synthetic */ SmsMessage() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SmsMessage)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class NoEmsSupportConfig
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        String mOperatorNumber;
        String mGid1;
        boolean mIsPrefix;

        private void $$robo$$android_telephony_SmsMessage_NoEmsSupportConfig$__constructor__(String[] config) {
            this.mOperatorNumber = config[0];
            this.mIsPrefix = "prefix".equals(config[1]);
            this.mGid1 = config.length > 2 ? config[2] : null;
        }

        private final String $$robo$$android_telephony_SmsMessage_NoEmsSupportConfig$toString() {
            return "NoEmsSupportConfig { mOperatorNumber = " + this.mOperatorNumber + ", mIsPrefix = " + this.mIsPrefix + ", mGid1 = " + this.mGid1 + " }";
        }

        private void __constructor__(String[] stringArray) {
            this.$$robo$$android_telephony_SmsMessage_NoEmsSupportConfig$__constructor__(stringArray);
        }

        public NoEmsSupportConfig(String[] stringArray) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SmsMessage_NoEmsSupportConfig$__constructor__(java.lang.String[] ), this, stringArray);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_SmsMessage_NoEmsSupportConfig$toString(), this);
        }

        public /* synthetic */ NoEmsSupportConfig() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NoEmsSupportConfig)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SubmitPdu
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public byte[] encodedScAddress;
        public byte[] encodedMessage;

        private final String $$robo$$android_telephony_SmsMessage_SubmitPdu$toString() {
            return "SubmitPdu: encodedScAddress = " + Arrays.toString(this.encodedScAddress) + ", encodedMessage = " + Arrays.toString(this.encodedMessage);
        }

        private void $$robo$$android_telephony_SmsMessage_SubmitPdu$__constructor__(SmsMessageBase.SubmitPduBase spb) {
            this.encodedMessage = spb.encodedMessage;
            this.encodedScAddress = spb.encodedScAddress;
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_SmsMessage_SubmitPdu$toString(), this);
        }

        private void __constructor__(SmsMessageBase.SubmitPduBase submitPduBase) {
            this.$$robo$$android_telephony_SmsMessage_SubmitPdu$__constructor__(submitPduBase);
        }

        public SubmitPdu(SmsMessageBase.SubmitPduBase submitPduBase) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SmsMessage_SubmitPdu$__constructor__(com.android.internal.telephony.SmsMessageBase$SubmitPduBase ), this, submitPduBase);
        }

        public /* synthetic */ SubmitPdu() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubmitPdu)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MessageClass
    extends Enum<MessageClass> {
        public /* synthetic */ Object __robo_data__;
        public static /* enum */ MessageClass UNKNOWN;
        public static /* enum */ MessageClass CLASS_0;
        public static /* enum */ MessageClass CLASS_1;
        public static /* enum */ MessageClass CLASS_2;
        public static /* enum */ MessageClass CLASS_3;
        private static /* synthetic */ MessageClass[] $VALUES;

        private static final MessageClass[] $$robo$$android_telephony_SmsMessage_MessageClass$values() {
            return (MessageClass[])$VALUES.clone();
        }

        private static final MessageClass $$robo$$android_telephony_SmsMessage_MessageClass$valueOf(String name) {
            return Enum.valueOf(MessageClass.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_telephony_SmsMessage_MessageClass$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            UNKNOWN = new MessageClass();
            CLASS_0 = new MessageClass();
            CLASS_1 = new MessageClass();
            CLASS_2 = new MessageClass();
            CLASS_3 = new MessageClass();
            $VALUES = new MessageClass[]{UNKNOWN, CLASS_0, CLASS_1, CLASS_2, CLASS_3};
        }

        public static MessageClass[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_telephony_SmsMessage_MessageClass$values());
        }

        public static MessageClass valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_telephony_SmsMessage_MessageClass$valueOf(java.lang.String ), (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_telephony_SmsMessage_MessageClass$__constructor__(string2, n);
        }

        public MessageClass() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SmsMessage_MessageClass$__constructor__(java.lang.String int ), this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(MessageClass.class);
        }

        public /* synthetic */ MessageClass() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageClass)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

