/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.telephony.Rlog;
import android.telephony.SubscriptionInfo;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import com.android.internal.telephony.IOnSubscriptionsChangedListener;
import com.android.internal.telephony.ISub;
import com.android.internal.telephony.ITelephonyRegistry;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SubscriptionManager
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "SubscriptionManager";
    private static boolean DBG = false;
    private static boolean VDBG = false;
    public static int INVALID_SUBSCRIPTION_ID = -1;
    public static int DUMMY_SUBSCRIPTION_ID_BASE = -2;
    public static int INVALID_PHONE_INDEX = -1;
    public static int INVALID_SIM_SLOT_INDEX = -1;
    public static int DEFAULT_SUBSCRIPTION_ID = Integer.MAX_VALUE;
    public static int DEFAULT_PHONE_INDEX = Integer.MAX_VALUE;
    public static int DEFAULT_SIM_SLOT_INDEX = Integer.MAX_VALUE;
    public static int MIN_SUBSCRIPTION_ID_VALUE = 0;
    public static int MAX_SUBSCRIPTION_ID_VALUE = 0x7FFFFFFE;
    public static Uri CONTENT_URI;
    public static String UNIQUE_KEY_SUBSCRIPTION_ID = "_id";
    public static String ICC_ID = "icc_id";
    public static String SIM_SLOT_INDEX = "sim_id";
    public static int SIM_NOT_INSERTED = -1;
    public static String DISPLAY_NAME = "display_name";
    public static String CARRIER_NAME = "carrier_name";
    public static int DEFAULT_NAME_RES = 17039374;
    public static String NAME_SOURCE = "name_source";
    public static int NAME_SOURCE_UNDEFINDED = -1;
    public static int NAME_SOURCE_DEFAULT_SOURCE = 0;
    public static int NAME_SOURCE_SIM_SOURCE = 1;
    public static int NAME_SOURCE_USER_INPUT = 2;
    public static String COLOR = "color";
    public static int COLOR_1 = 0;
    public static int COLOR_2 = 1;
    public static int COLOR_3 = 2;
    public static int COLOR_4 = 3;
    public static int COLOR_DEFAULT = 0;
    public static String NUMBER = "number";
    public static String DISPLAY_NUMBER_FORMAT = "display_number_format";
    public static int DISPLAY_NUMBER_NONE = 0;
    public static int DISPLAY_NUMBER_FIRST = 1;
    public static int DISPLAY_NUMBER_LAST = 2;
    public static int DISPLAY_NUMBER_DEFAULT = 1;
    public static String DATA_ROAMING = "data_roaming";
    public static int DATA_ROAMING_ENABLE = 1;
    public static int DATA_ROAMING_DISABLE = 0;
    public static int DATA_ROAMING_DEFAULT = 0;
    public static int SIM_PROVISIONED = 0;
    public static String MCC = "mcc";
    public static String MNC = "mnc";
    public static String SIM_PROVISIONING_STATUS = "sim_provisioning_status";
    public static String CB_EXTREME_THREAT_ALERT = "enable_cmas_extreme_threat_alerts";
    public static String CB_SEVERE_THREAT_ALERT = "enable_cmas_severe_threat_alerts";
    public static String CB_AMBER_ALERT = "enable_cmas_amber_alerts";
    public static String CB_EMERGENCY_ALERT = "enable_emergency_alerts";
    public static String CB_ALERT_SOUND_DURATION = "alert_sound_duration";
    public static String CB_ALERT_REMINDER_INTERVAL = "alert_reminder_interval";
    public static String CB_ALERT_VIBRATE = "enable_alert_vibrate";
    public static String CB_ALERT_SPEECH = "enable_alert_speech";
    public static String CB_ETWS_TEST_ALERT = "enable_etws_test_alerts";
    public static String CB_CHANNEL_50_ALERT = "enable_channel_50_alerts";
    public static String CB_CMAS_TEST_ALERT = "enable_cmas_test_alerts";
    public static String CB_OPT_OUT_DIALOG = "show_cmas_opt_out_dialog";
    public static String SUB_DEFAULT_CHANGED_ACTION = "android.intent.action.SUB_DEFAULT_CHANGED";
    public static String ACTION_DEFAULT_SUBSCRIPTION_CHANGED = "android.telephony.action.DEFAULT_SUBSCRIPTION_CHANGED";
    public static String ACTION_DEFAULT_SMS_SUBSCRIPTION_CHANGED = "android.telephony.action.DEFAULT_SMS_SUBSCRIPTION_CHANGED";
    public static String EXTRA_SUBSCRIPTION_INDEX = "android.telephony.extra.SUBSCRIPTION_INDEX";
    private Context mContext;

    private void $$robo$$android_telephony_SubscriptionManager$__constructor__(Context context) {
        this.mContext = context;
    }

    private static final SubscriptionManager $$robo$$android_telephony_SubscriptionManager$from(Context context) {
        return (SubscriptionManager)context.getSystemService("telephony_subscription_service");
    }

    private final void $$robo$$android_telephony_SubscriptionManager$addOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener) {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.addOnSubscriptionsChangedListener(pkgForDebug, listener.callback);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_SubscriptionManager$removeOnSubscriptionsChangedListener(OnSubscriptionsChangedListener listener) {
        String pkgForDebug = this.mContext != null ? this.mContext.getOpPackageName() : "<unknown>";
        try {
            ITelephonyRegistry tr = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
            if (tr != null) {
                tr.removeOnSubscriptionsChangedListener(pkgForDebug, listener.callback);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfo(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return null;
        }
        SubscriptionInfo subInfo = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subInfo = iSub.getActiveSubscriptionInfo(subId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subInfo;
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoForIccIndex(String iccId) {
        if (iccId == null) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForIccIndex]- null iccid");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForIccId(iccId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoForSimSlotIndex(int slotIndex) {
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[getActiveSubscriptionInfoForSimSlotIndex]- invalid slotIndex");
            return null;
        }
        SubscriptionInfo result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoForSimSlotIndex(slotIndex, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final List<SubscriptionInfo> $$robo$$android_telephony_SubscriptionManager$getAllSubscriptionInfoList() {
        List<Object> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (result == null) {
            result = new ArrayList();
        }
        return result;
    }

    private final List<SubscriptionInfo> $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoList() {
        List<SubscriptionInfo> result = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubscriptionInfoList(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$getAllSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getAllSubInfoCount(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoCount() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCount(this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoCountMax() {
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getActiveSubInfoCountMax();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final Uri $$robo$$android_telephony_SubscriptionManager$addSubscriptionInfoRecord(String iccId, int slotIndex) {
        if (iccId == null) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- null iccId");
        }
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[addSubscriptionInfoRecord]- invalid slotIndex");
        }
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.addSubInfoRecord(iccId, slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$setIconTint(int tint, int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setIconTint]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setIconTint(tint, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$setDisplayName(String displayName, int subId) {
        return this.setDisplayName(displayName, subId, -1L);
    }

    private final int $$robo$$android_telephony_SubscriptionManager$setDisplayName(String displayName, int subId, long nameSource) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDisplayName]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNameUsingSrc(displayName, subId, nameSource);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$setDisplayNumber(String number, int subId) {
        if (number == null || !SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDisplayNumber]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDisplayNumber(number, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private final int $$robo$$android_telephony_SubscriptionManager$setDataRoaming(int roaming, int subId) {
        if (roaming < 0 || !SubscriptionManager.isValidSubscriptionId(subId)) {
            SubscriptionManager.logd("[setDataRoaming]- fail");
            return -1;
        }
        int result = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.setDataRoaming(roaming, subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getSlotIndex(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            // empty if block
        }
        int result = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getSlotIndex(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final int[] $$robo$$android_telephony_SubscriptionManager$getSubId(int slotIndex) {
        if (!SubscriptionManager.isValidSlotIndex(slotIndex)) {
            SubscriptionManager.logd("[getSubId]- fail");
            return null;
        }
        int[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getSubId(slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getPhoneId(int subId) {
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return -1;
        }
        int result = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                result = iSub.getPhoneId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return result;
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$logd(String msg) {
        Rlog.d("SubscriptionManager", msg);
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultVoiceSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private final void $$robo$$android_telephony_SubscriptionManager$setDefaultVoiceSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultVoiceSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultVoicePhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultSmsSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private final void $$robo$$android_telephony_SubscriptionManager$setDefaultSmsSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultSmsSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultSmsSubscriptionId());
    }

    private final int $$robo$$android_telephony_SubscriptionManager$getDefaultSmsPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultSmsSubscriptionId());
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubscriptionId() {
        int subId = -1;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getDefaultDataSubId();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return subId;
    }

    private final void $$robo$$android_telephony_SubscriptionManager$setDefaultDataSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setDefaultDataSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final SubscriptionInfo $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubscriptionInfo() {
        return this.getActiveSubscriptionInfo(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    private final int $$robo$$android_telephony_SubscriptionManager$getDefaultDataPhoneId() {
        return SubscriptionManager.getPhoneId(SubscriptionManager.getDefaultDataSubscriptionId());
    }

    private final void $$robo$$android_telephony_SubscriptionManager$clearSubscriptionInfo() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearSubInfo();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_telephony_SubscriptionManager$allDefaultsSelected() {
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultDataSubscriptionId())) {
            return false;
        }
        if (!SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultSmsSubscriptionId())) {
            return false;
        }
        return SubscriptionManager.isValidSubscriptionId(SubscriptionManager.getDefaultVoiceSubscriptionId());
    }

    private final void $$robo$$android_telephony_SubscriptionManager$clearDefaultsForInactiveSubIds() {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.clearDefaultsForInactiveSubIds();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isValidSubscriptionId(int subId) {
        return subId > -1;
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isUsableSubIdValue(int subId) {
        return subId >= 0 && subId <= 0x7FFFFFFE;
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isValidSlotIndex(int slotIndex) {
        return slotIndex >= 0 && slotIndex < TelephonyManager.getDefault().getSimCount();
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$isValidPhoneId(int phoneId) {
        return phoneId >= 0 && phoneId < TelephonyManager.getDefault().getPhoneCount();
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(Intent intent, int phoneId) {
        int[] subIds = SubscriptionManager.getSubId(phoneId);
        if (subIds != null && subIds.length > 0) {
            SubscriptionManager.putPhoneIdAndSubIdExtra(intent, phoneId, subIds[0]);
        } else {
            SubscriptionManager.logd("putPhoneIdAndSubIdExtra: no valid subs");
        }
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(Intent intent, int phoneId, int subId) {
        intent.putExtra("subscription", subId);
        intent.putExtra("android.telephony.extra.SUBSCRIPTION_INDEX", subId);
        intent.putExtra("phone", phoneId);
        intent.putExtra("slot", phoneId);
    }

    private final int[] $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionIdList() {
        int[] subId = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                subId = iSub.getActiveSubIdList();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (subId == null) {
            subId = new int[]{};
        }
        return subId;
    }

    private final boolean $$robo$$android_telephony_SubscriptionManager$isNetworkRoaming(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        if (phoneId < 0) {
            return false;
        }
        return TelephonyManager.getDefault().isNetworkRoaming(subId);
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getSimStateForSlotIndex(int slotIndex) {
        int simState = 0;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                simState = iSub.getSimStateForSlotIndex(slotIndex);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return simState;
    }

    private static final void $$robo$$android_telephony_SubscriptionManager$setSubscriptionProperty(int subId, String propKey, String propValue) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                iSub.setSubscriptionProperty(subId, propKey, propValue);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final String $$robo$$android_telephony_SubscriptionManager$getSubscriptionProperty(int subId, String propKey, Context context) {
        String resultValue = null;
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                resultValue = iSub.getSubscriptionProperty(subId, propKey, context.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return resultValue;
    }

    private static final boolean $$robo$$android_telephony_SubscriptionManager$getBooleanSubscriptionProperty(int subId, String propKey, boolean defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Integer.parseInt(result) == 1;
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getBooleanSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    private static final int $$robo$$android_telephony_SubscriptionManager$getIntegerSubscriptionProperty(int subId, String propKey, int defValue, Context context) {
        String result = SubscriptionManager.getSubscriptionProperty(subId, propKey, context);
        if (result != null) {
            try {
                return Integer.parseInt(result);
            }
            catch (NumberFormatException err) {
                SubscriptionManager.logd("getBooleanSubscriptionProperty NumberFormat exception");
            }
        }
        return defValue;
    }

    private static final Resources $$robo$$android_telephony_SubscriptionManager$getResourcesForSubId(Context context, int subId) {
        SubscriptionInfo subInfo = SubscriptionManager.from(context).getActiveSubscriptionInfo(subId);
        Configuration config = context.getResources().getConfiguration();
        Configuration newConfig = new Configuration();
        newConfig.setTo(config);
        if (subInfo != null) {
            newConfig.mcc = subInfo.getMcc();
            newConfig.mnc = subInfo.getMnc();
            if (newConfig.mnc == 0) {
                newConfig.mnc = 65535;
            }
        }
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        DisplayMetrics newMetrics = new DisplayMetrics();
        newMetrics.setTo(metrics);
        return new Resources(context.getResources().getAssets(), newMetrics, newConfig);
    }

    private final boolean $$robo$$android_telephony_SubscriptionManager$isActiveSubId(int subId) {
        try {
            ISub iSub = ISub.Stub.asInterface(ServiceManager.getService("isub"));
            if (iSub != null) {
                return iSub.isActiveSubId(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return false;
    }

    static void __staticInitializer__() {
        CONTENT_URI = Uri.parse("content://telephony/siminfo");
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_telephony_SubscriptionManager$__constructor__(context);
    }

    public SubscriptionManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager$__constructor__(android.content.Context ), this, context);
    }

    public static SubscriptionManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_telephony_SubscriptionManager$from(android.content.Context ), (Context)context);
    }

    public void addOnSubscriptionsChangedListener(OnSubscriptionsChangedListener onSubscriptionsChangedListener) {
        InvokeDynamicSupport.bootstrap("addOnSubscriptionsChangedListener", $$robo$$android_telephony_SubscriptionManager$addOnSubscriptionsChangedListener(android.telephony.SubscriptionManager$OnSubscriptionsChangedListener ), this, onSubscriptionsChangedListener);
    }

    public void removeOnSubscriptionsChangedListener(OnSubscriptionsChangedListener onSubscriptionsChangedListener) {
        InvokeDynamicSupport.bootstrap("removeOnSubscriptionsChangedListener", $$robo$$android_telephony_SubscriptionManager$removeOnSubscriptionsChangedListener(android.telephony.SubscriptionManager$OnSubscriptionsChangedListener ), this, onSubscriptionsChangedListener);
    }

    public SubscriptionInfo getActiveSubscriptionInfo(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfo", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfo(int ), this, n);
    }

    public SubscriptionInfo getActiveSubscriptionInfoForIccIndex(String string2) {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoForIccIndex", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoForIccIndex(java.lang.String ), this, string2);
    }

    public SubscriptionInfo getActiveSubscriptionInfoForSimSlotIndex(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoForSimSlotIndex", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoForSimSlotIndex(int ), this, n);
    }

    public List<SubscriptionInfo> getAllSubscriptionInfoList() {
        return InvokeDynamicSupport.bootstrap("getAllSubscriptionInfoList", $$robo$$android_telephony_SubscriptionManager$getAllSubscriptionInfoList(), this);
    }

    public List<SubscriptionInfo> getActiveSubscriptionInfoList() {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoList", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoList(), this);
    }

    public int getAllSubscriptionInfoCount() {
        return (int)InvokeDynamicSupport.bootstrap("getAllSubscriptionInfoCount", $$robo$$android_telephony_SubscriptionManager$getAllSubscriptionInfoCount(), this);
    }

    public int getActiveSubscriptionInfoCount() {
        return (int)InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoCount", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoCount(), this);
    }

    public int getActiveSubscriptionInfoCountMax() {
        return (int)InvokeDynamicSupport.bootstrap("getActiveSubscriptionInfoCountMax", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionInfoCountMax(), this);
    }

    public Uri addSubscriptionInfoRecord(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("addSubscriptionInfoRecord", $$robo$$android_telephony_SubscriptionManager$addSubscriptionInfoRecord(java.lang.String int ), this, string2, n);
    }

    public int setIconTint(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("setIconTint", $$robo$$android_telephony_SubscriptionManager$setIconTint(int int ), this, n, n2);
    }

    public int setDisplayName(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayName", $$robo$$android_telephony_SubscriptionManager$setDisplayName(java.lang.String int ), this, string2, n);
    }

    public int setDisplayName(String string2, int n, long l) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayName", $$robo$$android_telephony_SubscriptionManager$setDisplayName(java.lang.String int long ), this, string2, n, l);
    }

    public int setDisplayNumber(String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("setDisplayNumber", $$robo$$android_telephony_SubscriptionManager$setDisplayNumber(java.lang.String int ), this, string2, n);
    }

    public int setDataRoaming(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("setDataRoaming", $$robo$$android_telephony_SubscriptionManager$setDataRoaming(int int ), this, n, n2);
    }

    public static int getSlotIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSlotIndex", $$robo$$android_telephony_SubscriptionManager$getSlotIndex(int ), (int)n);
    }

    public static int[] getSubId(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getSubId", $$robo$$android_telephony_SubscriptionManager$getSubId(int ), (int)n);
    }

    public static int getPhoneId(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPhoneId", $$robo$$android_telephony_SubscriptionManager$getPhoneId(int ), (int)n);
    }

    private static void logd(String string2) {
        InvokeDynamicSupport.bootstrapStatic("logd", $$robo$$android_telephony_SubscriptionManager$logd(java.lang.String ), (String)string2);
    }

    public static int getDefaultSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultSubscriptionId", $$robo$$android_telephony_SubscriptionManager$getDefaultSubscriptionId());
    }

    public static int getDefaultVoiceSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultVoiceSubscriptionId", $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubscriptionId());
    }

    public void setDefaultVoiceSubId(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultVoiceSubId", $$robo$$android_telephony_SubscriptionManager$setDefaultVoiceSubId(int ), this, n);
    }

    public SubscriptionInfo getDefaultVoiceSubscriptionInfo() {
        return InvokeDynamicSupport.bootstrap("getDefaultVoiceSubscriptionInfo", $$robo$$android_telephony_SubscriptionManager$getDefaultVoiceSubscriptionInfo(), this);
    }

    public static int getDefaultVoicePhoneId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultVoicePhoneId", $$robo$$android_telephony_SubscriptionManager$getDefaultVoicePhoneId());
    }

    public static int getDefaultSmsSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultSmsSubscriptionId", $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubscriptionId());
    }

    public void setDefaultSmsSubId(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultSmsSubId", $$robo$$android_telephony_SubscriptionManager$setDefaultSmsSubId(int ), this, n);
    }

    public SubscriptionInfo getDefaultSmsSubscriptionInfo() {
        return InvokeDynamicSupport.bootstrap("getDefaultSmsSubscriptionInfo", $$robo$$android_telephony_SubscriptionManager$getDefaultSmsSubscriptionInfo(), this);
    }

    public int getDefaultSmsPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultSmsPhoneId", $$robo$$android_telephony_SubscriptionManager$getDefaultSmsPhoneId(), this);
    }

    public static int getDefaultDataSubscriptionId() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultDataSubscriptionId", $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubscriptionId());
    }

    public void setDefaultDataSubId(int n) {
        InvokeDynamicSupport.bootstrap("setDefaultDataSubId", $$robo$$android_telephony_SubscriptionManager$setDefaultDataSubId(int ), this, n);
    }

    public SubscriptionInfo getDefaultDataSubscriptionInfo() {
        return InvokeDynamicSupport.bootstrap("getDefaultDataSubscriptionInfo", $$robo$$android_telephony_SubscriptionManager$getDefaultDataSubscriptionInfo(), this);
    }

    public int getDefaultDataPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultDataPhoneId", $$robo$$android_telephony_SubscriptionManager$getDefaultDataPhoneId(), this);
    }

    public void clearSubscriptionInfo() {
        InvokeDynamicSupport.bootstrap("clearSubscriptionInfo", $$robo$$android_telephony_SubscriptionManager$clearSubscriptionInfo(), this);
    }

    public boolean allDefaultsSelected() {
        return (boolean)InvokeDynamicSupport.bootstrap("allDefaultsSelected", $$robo$$android_telephony_SubscriptionManager$allDefaultsSelected(), this);
    }

    public void clearDefaultsForInactiveSubIds() {
        InvokeDynamicSupport.bootstrap("clearDefaultsForInactiveSubIds", $$robo$$android_telephony_SubscriptionManager$clearDefaultsForInactiveSubIds(), this);
    }

    public static boolean isValidSubscriptionId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSubscriptionId", $$robo$$android_telephony_SubscriptionManager$isValidSubscriptionId(int ), (int)n);
    }

    public static boolean isUsableSubIdValue(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isUsableSubIdValue", $$robo$$android_telephony_SubscriptionManager$isUsableSubIdValue(int ), (int)n);
    }

    public static boolean isValidSlotIndex(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidSlotIndex", $$robo$$android_telephony_SubscriptionManager$isValidSlotIndex(int ), (int)n);
    }

    public static boolean isValidPhoneId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidPhoneId", $$robo$$android_telephony_SubscriptionManager$isValidPhoneId(int ), (int)n);
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int n) {
        InvokeDynamicSupport.bootstrapStatic("putPhoneIdAndSubIdExtra", $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(android.content.Intent int ), (Intent)intent, (int)n);
    }

    public static void putPhoneIdAndSubIdExtra(Intent intent, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("putPhoneIdAndSubIdExtra", $$robo$$android_telephony_SubscriptionManager$putPhoneIdAndSubIdExtra(android.content.Intent int int ), (Intent)intent, (int)n, (int)n2);
    }

    public int[] getActiveSubscriptionIdList() {
        return InvokeDynamicSupport.bootstrap("getActiveSubscriptionIdList", $$robo$$android_telephony_SubscriptionManager$getActiveSubscriptionIdList(), this);
    }

    public boolean isNetworkRoaming(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNetworkRoaming", $$robo$$android_telephony_SubscriptionManager$isNetworkRoaming(int ), this, n);
    }

    public static int getSimStateForSlotIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getSimStateForSlotIndex", $$robo$$android_telephony_SubscriptionManager$getSimStateForSlotIndex(int ), (int)n);
    }

    public static void setSubscriptionProperty(int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("setSubscriptionProperty", $$robo$$android_telephony_SubscriptionManager$setSubscriptionProperty(int java.lang.String java.lang.String ), (int)n, (String)string2, (String)string3);
    }

    private static String getSubscriptionProperty(int n, String string2, Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getSubscriptionProperty", $$robo$$android_telephony_SubscriptionManager$getSubscriptionProperty(int java.lang.String android.content.Context ), (int)n, (String)string2, (Context)context);
    }

    public static boolean getBooleanSubscriptionProperty(int n, String string2, boolean bl, Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("getBooleanSubscriptionProperty", $$robo$$android_telephony_SubscriptionManager$getBooleanSubscriptionProperty(int java.lang.String boolean android.content.Context ), (int)n, (String)string2, (boolean)bl, (Context)context);
    }

    public static int getIntegerSubscriptionProperty(int n, String string2, int n2, Context context) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIntegerSubscriptionProperty", $$robo$$android_telephony_SubscriptionManager$getIntegerSubscriptionProperty(int java.lang.String int android.content.Context ), (int)n, (String)string2, (int)n2, (Context)context);
    }

    public static Resources getResourcesForSubId(Context context, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getResourcesForSubId", $$robo$$android_telephony_SubscriptionManager$getResourcesForSubId(android.content.Context int ), (Context)context, (int)n);
    }

    public boolean isActiveSubId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isActiveSubId", $$robo$$android_telephony_SubscriptionManager$isActiveSubId(int ), this, n);
    }

    static {
        RobolectricInternals.classInitializing(SubscriptionManager.class);
    }

    public /* synthetic */ SubscriptionManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SubscriptionManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class OnSubscriptionsChangedListener
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Handler mHandler;
        IOnSubscriptionsChangedListener callback;

        private void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$__constructor__() {
            this.mHandler = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ OnSubscriptionsChangedListener this$0;

                private void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_1$__constructor__(OnSubscriptionsChangedListener this$0) {
                }

                private final void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_1$handleMessage(Message msg) {
                    this.this$0.onSubscriptionsChanged();
                }

                private void __constructor__(OnSubscriptionsChangedListener onSubscriptionsChangedListener) {
                    this.$$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_1$__constructor__(onSubscriptionsChangedListener);
                }
                {
                    this.this$0 = onSubscriptionsChangedListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_1$__constructor__(android.telephony.SubscriptionManager$OnSubscriptionsChangedListener ), this, onSubscriptionsChangedListener);
                }

                @Override
                public void handleMessage(Message message) {
                    InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_1$handleMessage(android.os.Message ), this, message);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.callback = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ OnSubscriptionsChangedListener this$0;

                private void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_2$__constructor__(OnSubscriptionsChangedListener this$0) {
                }

                private final void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_2$onSubscriptionsChanged() {
                    this.this$0.mHandler.sendEmptyMessage(0);
                }

                private void __constructor__(OnSubscriptionsChangedListener onSubscriptionsChangedListener) {
                    this.$$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_2$__constructor__(onSubscriptionsChangedListener);
                }
                {
                    this.this$0 = onSubscriptionsChangedListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_2$__constructor__(android.telephony.SubscriptionManager$OnSubscriptionsChangedListener ), this, onSubscriptionsChangedListener);
                }

                @Override
                public void onSubscriptionsChanged() {
                    InvokeDynamicSupport.bootstrap("onSubscriptionsChanged", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener_2$onSubscriptionsChanged(), this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$onSubscriptionsChanged() {
        }

        private final void $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$log(String s) {
            Rlog.d("SubscriptionManager", s);
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$__constructor__();
        }

        public OnSubscriptionsChangedListener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$__constructor__(), this);
        }

        public void onSubscriptionsChanged() {
            InvokeDynamicSupport.bootstrap("onSubscriptionsChanged", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$onSubscriptionsChanged(), this);
        }

        private void log(String string2) {
            InvokeDynamicSupport.bootstrap("log", $$robo$$android_telephony_SubscriptionManager_OnSubscriptionsChangedListener$log(java.lang.String ), this, string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OnSubscriptionsChangedListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

