/*
 * Decompiled with CFR 0.152.
 */
package android.text;

import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.drawable.Drawable;
import android.text.Editable;
import android.text.Html;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.AlignmentSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.BulletSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.ParagraphStyle;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.URLSpan;
import android.text.style.UnderlineSpan;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.ccil.cowan.tagsoup.Parser;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class HtmlToSpannedConverter
implements ContentHandler,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static float[] HEADING_SIZES;
    private String mSource;
    private XMLReader mReader;
    private SpannableStringBuilder mSpannableStringBuilder;
    private Html.ImageGetter mImageGetter;
    private Html.TagHandler mTagHandler;
    private int mFlags;
    private static Pattern sTextAlignPattern;
    private static Pattern sForegroundColorPattern;
    private static Pattern sBackgroundColorPattern;
    private static Pattern sTextDecorationPattern;
    private static Map<String, Integer> sColorMap;

    private static final Pattern $$robo$$android_text_HtmlToSpannedConverter$getTextAlignPattern() {
        if (sTextAlignPattern == null) {
            sTextAlignPattern = Pattern.compile("(?:\\s+|\\A)text-align\\s*:\\s*(\\S*)\\b");
        }
        return sTextAlignPattern;
    }

    private static final Pattern $$robo$$android_text_HtmlToSpannedConverter$getForegroundColorPattern() {
        if (sForegroundColorPattern == null) {
            sForegroundColorPattern = Pattern.compile("(?:\\s+|\\A)color\\s*:\\s*(\\S*)\\b");
        }
        return sForegroundColorPattern;
    }

    private static final Pattern $$robo$$android_text_HtmlToSpannedConverter$getBackgroundColorPattern() {
        if (sBackgroundColorPattern == null) {
            sBackgroundColorPattern = Pattern.compile("(?:\\s+|\\A)background(?:-color)?\\s*:\\s*(\\S*)\\b");
        }
        return sBackgroundColorPattern;
    }

    private static final Pattern $$robo$$android_text_HtmlToSpannedConverter$getTextDecorationPattern() {
        if (sTextDecorationPattern == null) {
            sTextDecorationPattern = Pattern.compile("(?:\\s+|\\A)text-decoration\\s*:\\s*(\\S*)\\b");
        }
        return sTextDecorationPattern;
    }

    private void $$robo$$android_text_HtmlToSpannedConverter$__constructor__(String source, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser, int flags) {
        this.mSource = source;
        this.mSpannableStringBuilder = new SpannableStringBuilder();
        this.mImageGetter = imageGetter;
        this.mTagHandler = tagHandler;
        this.mReader = parser;
        this.mFlags = flags;
    }

    private final Spanned $$robo$$android_text_HtmlToSpannedConverter$convert() {
        this.mReader.setContentHandler(this);
        try {
            this.mReader.parse(new InputSource(new StringReader(this.mSource)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        ParagraphStyle[] obj = this.mSpannableStringBuilder.getSpans(0, this.mSpannableStringBuilder.length(), ParagraphStyle.class);
        for (int i = 0; i < obj.length; ++i) {
            int start = this.mSpannableStringBuilder.getSpanStart(obj[i]);
            int end = this.mSpannableStringBuilder.getSpanEnd(obj[i]);
            if (end - 2 >= 0 && this.mSpannableStringBuilder.charAt(end - 1) == '\n' && this.mSpannableStringBuilder.charAt(end - 2) == '\n') {
                --end;
            }
            if (end == start) {
                this.mSpannableStringBuilder.removeSpan(obj[i]);
                continue;
            }
            this.mSpannableStringBuilder.setSpan(obj[i], start, end, 51);
        }
        return this.mSpannableStringBuilder;
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$handleStartTag(String tag, Attributes attributes) {
        if (!tag.equalsIgnoreCase("br")) {
            if (tag.equalsIgnoreCase("p")) {
                HtmlToSpannedConverter.startBlockElement(this.mSpannableStringBuilder, attributes, this.getMarginParagraph());
                this.startCssStyle(this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("ul")) {
                HtmlToSpannedConverter.startBlockElement(this.mSpannableStringBuilder, attributes, this.getMarginList());
            } else if (tag.equalsIgnoreCase("li")) {
                this.startLi(this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("div")) {
                HtmlToSpannedConverter.startBlockElement(this.mSpannableStringBuilder, attributes, this.getMarginDiv());
            } else if (tag.equalsIgnoreCase("span")) {
                this.startCssStyle(this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("strong")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Bold(null));
            } else if (tag.equalsIgnoreCase("b")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Bold(null));
            } else if (tag.equalsIgnoreCase("em")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic(null));
            } else if (tag.equalsIgnoreCase("cite")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic(null));
            } else if (tag.equalsIgnoreCase("dfn")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic(null));
            } else if (tag.equalsIgnoreCase("i")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Italic(null));
            } else if (tag.equalsIgnoreCase("big")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Big(null));
            } else if (tag.equalsIgnoreCase("small")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Small(null));
            } else if (tag.equalsIgnoreCase("font")) {
                this.startFont(this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("blockquote")) {
                this.startBlockquote(this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("tt")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Monospace(null));
            } else if (tag.equalsIgnoreCase("a")) {
                HtmlToSpannedConverter.startA(this.mSpannableStringBuilder, attributes);
            } else if (tag.equalsIgnoreCase("u")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Underline(null));
            } else if (tag.equalsIgnoreCase("del")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Strikethrough(null));
            } else if (tag.equalsIgnoreCase("s")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Strikethrough(null));
            } else if (tag.equalsIgnoreCase("strike")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Strikethrough(null));
            } else if (tag.equalsIgnoreCase("sup")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Super(null));
            } else if (tag.equalsIgnoreCase("sub")) {
                HtmlToSpannedConverter.start(this.mSpannableStringBuilder, new Sub(null));
            } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
                this.startHeading(this.mSpannableStringBuilder, attributes, tag.charAt(1) - 49);
            } else if (tag.equalsIgnoreCase("img")) {
                HtmlToSpannedConverter.startImg(this.mSpannableStringBuilder, attributes, this.mImageGetter);
            } else if (this.mTagHandler != null) {
                this.mTagHandler.handleTag(true, tag, this.mSpannableStringBuilder, this.mReader);
            }
        }
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$handleEndTag(String tag) {
        if (tag.equalsIgnoreCase("br")) {
            HtmlToSpannedConverter.handleBr(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("p")) {
            HtmlToSpannedConverter.endCssStyle(this.mSpannableStringBuilder);
            HtmlToSpannedConverter.endBlockElement(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("ul")) {
            HtmlToSpannedConverter.endBlockElement(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("li")) {
            HtmlToSpannedConverter.endLi(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("div")) {
            HtmlToSpannedConverter.endBlockElement(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("span")) {
            HtmlToSpannedConverter.endCssStyle(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("strong")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
        } else if (tag.equalsIgnoreCase("b")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Bold.class, new StyleSpan(1));
        } else if (tag.equalsIgnoreCase("em")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("cite")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("dfn")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("i")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Italic.class, new StyleSpan(2));
        } else if (tag.equalsIgnoreCase("big")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Big.class, new RelativeSizeSpan(1.25f));
        } else if (tag.equalsIgnoreCase("small")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Small.class, new RelativeSizeSpan(0.8f));
        } else if (tag.equalsIgnoreCase("font")) {
            HtmlToSpannedConverter.endFont(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("blockquote")) {
            HtmlToSpannedConverter.endBlockquote(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("tt")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Monospace.class, new TypefaceSpan("monospace"));
        } else if (tag.equalsIgnoreCase("a")) {
            HtmlToSpannedConverter.endA(this.mSpannableStringBuilder);
        } else if (tag.equalsIgnoreCase("u")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Underline.class, new UnderlineSpan());
        } else if (tag.equalsIgnoreCase("del")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("s")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("strike")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("sup")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Super.class, new SuperscriptSpan());
        } else if (tag.equalsIgnoreCase("sub")) {
            HtmlToSpannedConverter.end(this.mSpannableStringBuilder, Sub.class, new SubscriptSpan());
        } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
            HtmlToSpannedConverter.endHeading(this.mSpannableStringBuilder);
        } else if (this.mTagHandler != null) {
            this.mTagHandler.handleTag(false, tag, this.mSpannableStringBuilder, this.mReader);
        }
    }

    private final int $$robo$$android_text_HtmlToSpannedConverter$getMarginParagraph() {
        return this.getMargin(1);
    }

    private final int $$robo$$android_text_HtmlToSpannedConverter$getMarginHeading() {
        return this.getMargin(2);
    }

    private final int $$robo$$android_text_HtmlToSpannedConverter$getMarginListItem() {
        return this.getMargin(4);
    }

    private final int $$robo$$android_text_HtmlToSpannedConverter$getMarginList() {
        return this.getMargin(8);
    }

    private final int $$robo$$android_text_HtmlToSpannedConverter$getMarginDiv() {
        return this.getMargin(16);
    }

    private final int $$robo$$android_text_HtmlToSpannedConverter$getMarginBlockquote() {
        return this.getMargin(32);
    }

    private final int $$robo$$android_text_HtmlToSpannedConverter$getMargin(int flag) {
        if ((flag & this.mFlags) != 0) {
            return 1;
        }
        return 2;
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$appendNewlines(Editable text, int minNewline) {
        int len = text.length();
        if (len == 0) {
            return;
        }
        int existingNewlines = 0;
        for (int i = len - 1; i >= 0 && text.charAt(i) == '\n'; --i) {
            ++existingNewlines;
        }
        for (int j = existingNewlines; j < minNewline; ++j) {
            text.append("\n");
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$startBlockElement(Editable text, Attributes attributes, int margin) {
        Matcher m;
        String style2;
        int len = text.length();
        if (margin > 0) {
            HtmlToSpannedConverter.appendNewlines(text, margin);
            HtmlToSpannedConverter.start(text, new Newline(margin));
        }
        if ((style2 = attributes.getValue("", "style")) != null && (m = HtmlToSpannedConverter.getTextAlignPattern().matcher(style2)).find()) {
            String alignment = m.group(1);
            if (alignment.equalsIgnoreCase("start")) {
                HtmlToSpannedConverter.start(text, new Alignment(Layout.Alignment.ALIGN_NORMAL));
            } else if (alignment.equalsIgnoreCase("center")) {
                HtmlToSpannedConverter.start(text, new Alignment(Layout.Alignment.ALIGN_CENTER));
            } else if (alignment.equalsIgnoreCase("end")) {
                HtmlToSpannedConverter.start(text, new Alignment(Layout.Alignment.ALIGN_OPPOSITE));
            }
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$endBlockElement(Editable text) {
        Alignment a;
        Newline n = HtmlToSpannedConverter.getLast(text, Newline.class);
        if (n != null) {
            HtmlToSpannedConverter.appendNewlines(text, n.mNumNewlines);
            text.removeSpan(n);
        }
        if ((a = HtmlToSpannedConverter.getLast(text, Alignment.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, a, new AlignmentSpan.Standard(a.mAlignment));
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$handleBr(Editable text) {
        text.append('\n');
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startLi(Editable text, Attributes attributes) {
        HtmlToSpannedConverter.startBlockElement(text, attributes, this.getMarginListItem());
        HtmlToSpannedConverter.start(text, new Bullet(null));
        this.startCssStyle(text, attributes);
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$endLi(Editable text) {
        HtmlToSpannedConverter.endCssStyle(text);
        HtmlToSpannedConverter.endBlockElement(text);
        HtmlToSpannedConverter.end(text, Bullet.class, new BulletSpan());
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startBlockquote(Editable text, Attributes attributes) {
        HtmlToSpannedConverter.startBlockElement(text, attributes, this.getMarginBlockquote());
        HtmlToSpannedConverter.start(text, new Blockquote(null));
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$endBlockquote(Editable text) {
        HtmlToSpannedConverter.endBlockElement(text);
        HtmlToSpannedConverter.end(text, Blockquote.class, new QuoteSpan());
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startHeading(Editable text, Attributes attributes, int level) {
        HtmlToSpannedConverter.startBlockElement(text, attributes, this.getMarginHeading());
        HtmlToSpannedConverter.start(text, new Heading(level));
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$endHeading(Editable text) {
        Heading h = HtmlToSpannedConverter.getLast(text, Heading.class);
        if (h != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, h, new RelativeSizeSpan(HEADING_SIZES[h.mLevel]), new StyleSpan(1));
        }
        HtmlToSpannedConverter.endBlockElement(text);
    }

    private static final <T> T $$robo$$android_text_HtmlToSpannedConverter$getLast(Spanned text, Class<T> kind) {
        T[] objs = text.getSpans(0, text.length(), kind);
        if (objs.length == 0) {
            return null;
        }
        return objs[objs.length - 1];
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$setSpanFromMark(Spannable text, Object mark, Object ... spans) {
        int where = text.getSpanStart(mark);
        text.removeSpan(mark);
        int len = text.length();
        if (where != len) {
            for (Object span : spans) {
                text.setSpan(span, where, len, 33);
            }
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$start(Editable text, Object mark) {
        int len = text.length();
        text.setSpan(mark, len, len, 17);
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$end(Editable text, Class kind, Object repl) {
        int len = text.length();
        Object obj = HtmlToSpannedConverter.getLast(text, kind);
        if (obj != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, obj, repl);
        }
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startCssStyle(Editable text, Attributes attributes) {
        String style2 = attributes.getValue("", "style");
        if (style2 != null) {
            String textDecoration;
            int c;
            Matcher m = HtmlToSpannedConverter.getForegroundColorPattern().matcher(style2);
            if (m.find() && (c = this.getHtmlColor(m.group(1))) != -1) {
                HtmlToSpannedConverter.start(text, new Foreground(c | 0xFF000000));
            }
            if ((m = HtmlToSpannedConverter.getBackgroundColorPattern().matcher(style2)).find() && (c = this.getHtmlColor(m.group(1))) != -1) {
                HtmlToSpannedConverter.start(text, new Background(c | 0xFF000000));
            }
            if ((m = HtmlToSpannedConverter.getTextDecorationPattern().matcher(style2)).find() && (textDecoration = m.group(1)).equalsIgnoreCase("line-through")) {
                HtmlToSpannedConverter.start(text, new Strikethrough(null));
            }
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$endCssStyle(Editable text) {
        Foreground f;
        Background b;
        Strikethrough s = HtmlToSpannedConverter.getLast(text, Strikethrough.class);
        if (s != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, s, new StrikethroughSpan());
        }
        if ((b = HtmlToSpannedConverter.getLast(text, Background.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, b, new BackgroundColorSpan(b.mBackgroundColor));
        }
        if ((f = HtmlToSpannedConverter.getLast(text, Foreground.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, f, new ForegroundColorSpan(f.mForegroundColor));
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$startImg(Editable text, Attributes attributes, Html.ImageGetter img) {
        String src = attributes.getValue("", "src");
        Drawable d = null;
        if (img != null) {
            d = img.getDrawable(src);
        }
        if (d == null) {
            d = Resources.getSystem().getDrawable(17303542);
            d.setBounds(0, 0, d.getIntrinsicWidth(), d.getIntrinsicHeight());
        }
        int len = text.length();
        text.append("\ufffc");
        text.setSpan(new ImageSpan(d, src), len, text.length(), 33);
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startFont(Editable text, Attributes attributes) {
        int c;
        String color2 = attributes.getValue("", "color");
        String face = attributes.getValue("", "face");
        if (!TextUtils.isEmpty(color2) && (c = this.getHtmlColor(color2)) != -1) {
            HtmlToSpannedConverter.start(text, new Foreground(c | 0xFF000000));
        }
        if (!TextUtils.isEmpty(face)) {
            HtmlToSpannedConverter.start(text, new Font(face));
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$endFont(Editable text) {
        Foreground foreground;
        Font font = HtmlToSpannedConverter.getLast(text, Font.class);
        if (font != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, font, new TypefaceSpan(font.mFace));
        }
        if ((foreground = HtmlToSpannedConverter.getLast(text, Foreground.class)) != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, foreground, new ForegroundColorSpan(foreground.mForegroundColor));
        }
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$startA(Editable text, Attributes attributes) {
        String href = attributes.getValue("", "href");
        HtmlToSpannedConverter.start(text, new Href(href));
    }

    private static final void $$robo$$android_text_HtmlToSpannedConverter$endA(Editable text) {
        Href h = HtmlToSpannedConverter.getLast(text, Href.class);
        if (h != null && h.mHref != null) {
            HtmlToSpannedConverter.setSpanFromMark(text, h, new URLSpan(h.mHref));
        }
    }

    private final int $$robo$$android_text_HtmlToSpannedConverter$getHtmlColor(String color2) {
        Integer i;
        if ((this.mFlags & 0x100) == 256 && (i = sColorMap.get(color2.toLowerCase(Locale.US))) != null) {
            return i;
        }
        return Color.getHtmlColor(color2);
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$setDocumentLocator(Locator locator) {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startDocument() throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$endDocument() throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$endPrefixMapping(String prefix) throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.handleStartTag(localName, attributes);
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$endElement(String uri, String localName, String qName) throws SAXException {
        this.handleEndTag(localName);
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$characters(char[] ch, int start, int length) throws SAXException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = ch[i + start];
            if (c == ' ' || c == '\n') {
                int len = sb.length();
                int pred = len == 0 ? ((len = this.mSpannableStringBuilder.length()) == 0 ? 10 : (int)this.mSpannableStringBuilder.charAt(len - 1)) : sb.charAt(len - 1);
                if (pred == 32 || pred == 10) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        this.mSpannableStringBuilder.append(sb);
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$processingInstruction(String target, String data) throws SAXException {
    }

    private final void $$robo$$android_text_HtmlToSpannedConverter$skippedEntity(String name) throws SAXException {
    }

    static void __staticInitializer__() {
        HEADING_SIZES = new float[]{1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
        sColorMap = new HashMap<String, Integer>();
        sColorMap.put("darkgray", -5658199);
        sColorMap.put("gray", -8355712);
        sColorMap.put("lightgray", -2894893);
        sColorMap.put("darkgrey", -5658199);
        sColorMap.put("grey", -8355712);
        sColorMap.put("lightgrey", -2894893);
        sColorMap.put("green", -16744448);
    }

    private static Pattern getTextAlignPattern() {
        return InvokeDynamicSupport.bootstrapStatic("getTextAlignPattern", $$robo$$android_text_HtmlToSpannedConverter$getTextAlignPattern());
    }

    private static Pattern getForegroundColorPattern() {
        return InvokeDynamicSupport.bootstrapStatic("getForegroundColorPattern", $$robo$$android_text_HtmlToSpannedConverter$getForegroundColorPattern());
    }

    private static Pattern getBackgroundColorPattern() {
        return InvokeDynamicSupport.bootstrapStatic("getBackgroundColorPattern", $$robo$$android_text_HtmlToSpannedConverter$getBackgroundColorPattern());
    }

    private static Pattern getTextDecorationPattern() {
        return InvokeDynamicSupport.bootstrapStatic("getTextDecorationPattern", $$robo$$android_text_HtmlToSpannedConverter$getTextDecorationPattern());
    }

    private void __constructor__(String string2, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser, int n) {
        this.$$robo$$android_text_HtmlToSpannedConverter$__constructor__(string2, imageGetter, tagHandler, parser, n);
    }

    public HtmlToSpannedConverter(String string2, Html.ImageGetter imageGetter, Html.TagHandler tagHandler, Parser parser, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter$__constructor__(java.lang.String android.text.Html$ImageGetter android.text.Html$TagHandler org.ccil.cowan.tagsoup.Parser int ), this, string2, imageGetter, tagHandler, parser, n);
    }

    public Spanned convert() {
        return InvokeDynamicSupport.bootstrap("convert", $$robo$$android_text_HtmlToSpannedConverter$convert(), this);
    }

    private void handleStartTag(String string2, Attributes attributes) {
        InvokeDynamicSupport.bootstrap("handleStartTag", $$robo$$android_text_HtmlToSpannedConverter$handleStartTag(java.lang.String org.xml.sax.Attributes ), this, string2, attributes);
    }

    private void handleEndTag(String string2) {
        InvokeDynamicSupport.bootstrap("handleEndTag", $$robo$$android_text_HtmlToSpannedConverter$handleEndTag(java.lang.String ), this, string2);
    }

    private int getMarginParagraph() {
        return (int)InvokeDynamicSupport.bootstrap("getMarginParagraph", $$robo$$android_text_HtmlToSpannedConverter$getMarginParagraph(), this);
    }

    private int getMarginHeading() {
        return (int)InvokeDynamicSupport.bootstrap("getMarginHeading", $$robo$$android_text_HtmlToSpannedConverter$getMarginHeading(), this);
    }

    private int getMarginListItem() {
        return (int)InvokeDynamicSupport.bootstrap("getMarginListItem", $$robo$$android_text_HtmlToSpannedConverter$getMarginListItem(), this);
    }

    private int getMarginList() {
        return (int)InvokeDynamicSupport.bootstrap("getMarginList", $$robo$$android_text_HtmlToSpannedConverter$getMarginList(), this);
    }

    private int getMarginDiv() {
        return (int)InvokeDynamicSupport.bootstrap("getMarginDiv", $$robo$$android_text_HtmlToSpannedConverter$getMarginDiv(), this);
    }

    private int getMarginBlockquote() {
        return (int)InvokeDynamicSupport.bootstrap("getMarginBlockquote", $$robo$$android_text_HtmlToSpannedConverter$getMarginBlockquote(), this);
    }

    private int getMargin(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMargin", $$robo$$android_text_HtmlToSpannedConverter$getMargin(int ), this, n);
    }

    private static void appendNewlines(Editable editable, int n) {
        InvokeDynamicSupport.bootstrapStatic("appendNewlines", $$robo$$android_text_HtmlToSpannedConverter$appendNewlines(android.text.Editable int ), (Editable)editable, (int)n);
    }

    private static void startBlockElement(Editable editable, Attributes attributes, int n) {
        InvokeDynamicSupport.bootstrapStatic("startBlockElement", $$robo$$android_text_HtmlToSpannedConverter$startBlockElement(android.text.Editable org.xml.sax.Attributes int ), (Editable)editable, (Attributes)attributes, (int)n);
    }

    private static void endBlockElement(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("endBlockElement", $$robo$$android_text_HtmlToSpannedConverter$endBlockElement(android.text.Editable ), (Editable)editable);
    }

    private static void handleBr(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("handleBr", $$robo$$android_text_HtmlToSpannedConverter$handleBr(android.text.Editable ), (Editable)editable);
    }

    private void startLi(Editable editable, Attributes attributes) {
        InvokeDynamicSupport.bootstrap("startLi", $$robo$$android_text_HtmlToSpannedConverter$startLi(android.text.Editable org.xml.sax.Attributes ), this, editable, attributes);
    }

    private static void endLi(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("endLi", $$robo$$android_text_HtmlToSpannedConverter$endLi(android.text.Editable ), (Editable)editable);
    }

    private void startBlockquote(Editable editable, Attributes attributes) {
        InvokeDynamicSupport.bootstrap("startBlockquote", $$robo$$android_text_HtmlToSpannedConverter$startBlockquote(android.text.Editable org.xml.sax.Attributes ), this, editable, attributes);
    }

    private static void endBlockquote(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("endBlockquote", $$robo$$android_text_HtmlToSpannedConverter$endBlockquote(android.text.Editable ), (Editable)editable);
    }

    private void startHeading(Editable editable, Attributes attributes, int n) {
        InvokeDynamicSupport.bootstrap("startHeading", $$robo$$android_text_HtmlToSpannedConverter$startHeading(android.text.Editable org.xml.sax.Attributes int ), this, editable, attributes, n);
    }

    private static void endHeading(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("endHeading", $$robo$$android_text_HtmlToSpannedConverter$endHeading(android.text.Editable ), (Editable)editable);
    }

    private static <T> T getLast(Spanned spanned, Class<T> clazz) {
        return (T)InvokeDynamicSupport.bootstrapStatic("getLast", $$robo$$android_text_HtmlToSpannedConverter$getLast(android.text.Spanned java.lang.Class<T> ), (Spanned)spanned, clazz);
    }

    private static void setSpanFromMark(Spannable spannable, Object object, Object ... objectArray) {
        InvokeDynamicSupport.bootstrapStatic("setSpanFromMark", $$robo$$android_text_HtmlToSpannedConverter$setSpanFromMark(android.text.Spannable java.lang.Object java.lang.Object[] ), (Spannable)spannable, (Object)object, (Object[])objectArray);
    }

    private static void start(Editable editable, Object object) {
        InvokeDynamicSupport.bootstrapStatic("start", $$robo$$android_text_HtmlToSpannedConverter$start(android.text.Editable java.lang.Object ), (Editable)editable, (Object)object);
    }

    private static void end(Editable editable, Class clazz, Object object) {
        InvokeDynamicSupport.bootstrapStatic("end", $$robo$$android_text_HtmlToSpannedConverter$end(android.text.Editable java.lang.Class java.lang.Object ), (Editable)editable, (Class)clazz, (Object)object);
    }

    private void startCssStyle(Editable editable, Attributes attributes) {
        InvokeDynamicSupport.bootstrap("startCssStyle", $$robo$$android_text_HtmlToSpannedConverter$startCssStyle(android.text.Editable org.xml.sax.Attributes ), this, editable, attributes);
    }

    private static void endCssStyle(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("endCssStyle", $$robo$$android_text_HtmlToSpannedConverter$endCssStyle(android.text.Editable ), (Editable)editable);
    }

    private static void startImg(Editable editable, Attributes attributes, Html.ImageGetter imageGetter) {
        InvokeDynamicSupport.bootstrapStatic("startImg", $$robo$$android_text_HtmlToSpannedConverter$startImg(android.text.Editable org.xml.sax.Attributes android.text.Html$ImageGetter ), (Editable)editable, (Attributes)attributes, (Html.ImageGetter)imageGetter);
    }

    private void startFont(Editable editable, Attributes attributes) {
        InvokeDynamicSupport.bootstrap("startFont", $$robo$$android_text_HtmlToSpannedConverter$startFont(android.text.Editable org.xml.sax.Attributes ), this, editable, attributes);
    }

    private static void endFont(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("endFont", $$robo$$android_text_HtmlToSpannedConverter$endFont(android.text.Editable ), (Editable)editable);
    }

    private static void startA(Editable editable, Attributes attributes) {
        InvokeDynamicSupport.bootstrapStatic("startA", $$robo$$android_text_HtmlToSpannedConverter$startA(android.text.Editable org.xml.sax.Attributes ), (Editable)editable, (Attributes)attributes);
    }

    private static void endA(Editable editable) {
        InvokeDynamicSupport.bootstrapStatic("endA", $$robo$$android_text_HtmlToSpannedConverter$endA(android.text.Editable ), (Editable)editable);
    }

    private int getHtmlColor(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("getHtmlColor", $$robo$$android_text_HtmlToSpannedConverter$getHtmlColor(java.lang.String ), this, string2);
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        InvokeDynamicSupport.bootstrap("setDocumentLocator", $$robo$$android_text_HtmlToSpannedConverter$setDocumentLocator(org.xml.sax.Locator ), this, locator);
    }

    @Override
    public void startDocument() throws SAXException {
        InvokeDynamicSupport.bootstrap("startDocument", $$robo$$android_text_HtmlToSpannedConverter$startDocument(), this);
    }

    @Override
    public void endDocument() throws SAXException {
        InvokeDynamicSupport.bootstrap("endDocument", $$robo$$android_text_HtmlToSpannedConverter$endDocument(), this);
    }

    @Override
    public void startPrefixMapping(String string2, String string3) throws SAXException {
        InvokeDynamicSupport.bootstrap("startPrefixMapping", $$robo$$android_text_HtmlToSpannedConverter$startPrefixMapping(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void endPrefixMapping(String string2) throws SAXException {
        InvokeDynamicSupport.bootstrap("endPrefixMapping", $$robo$$android_text_HtmlToSpannedConverter$endPrefixMapping(java.lang.String ), this, string2);
    }

    @Override
    public void startElement(String string2, String string3, String string4, Attributes attributes) throws SAXException {
        InvokeDynamicSupport.bootstrap("startElement", $$robo$$android_text_HtmlToSpannedConverter$startElement(java.lang.String java.lang.String java.lang.String org.xml.sax.Attributes ), this, string2, string3, string4, attributes);
    }

    @Override
    public void endElement(String string2, String string3, String string4) throws SAXException {
        InvokeDynamicSupport.bootstrap("endElement", $$robo$$android_text_HtmlToSpannedConverter$endElement(java.lang.String java.lang.String java.lang.String ), this, string2, string3, string4);
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        InvokeDynamicSupport.bootstrap("characters", $$robo$$android_text_HtmlToSpannedConverter$characters(char[] int int ), this, cArray, n, n2);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        InvokeDynamicSupport.bootstrap("ignorableWhitespace", $$robo$$android_text_HtmlToSpannedConverter$ignorableWhitespace(char[] int int ), this, cArray, n, n2);
    }

    @Override
    public void processingInstruction(String string2, String string3) throws SAXException {
        InvokeDynamicSupport.bootstrap("processingInstruction", $$robo$$android_text_HtmlToSpannedConverter$processingInstruction(java.lang.String java.lang.String ), this, string2, string3);
    }

    @Override
    public void skippedEntity(String string2) throws SAXException {
        InvokeDynamicSupport.bootstrap("skippedEntity", $$robo$$android_text_HtmlToSpannedConverter$skippedEntity(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(HtmlToSpannedConverter.class);
    }

    public /* synthetic */ HtmlToSpannedConverter() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HtmlToSpannedConverter)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class Alignment
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Layout.Alignment mAlignment;

        private void $$robo$$android_text_HtmlToSpannedConverter_Alignment$__constructor__(Layout.Alignment alignment) {
            this.mAlignment = alignment;
        }

        private void __constructor__(Layout.Alignment alignment) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Alignment$__constructor__(alignment);
        }

        public Alignment(Layout.Alignment alignment) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Alignment$__constructor__(android.text.Layout$Alignment ), this, alignment);
        }

        public /* synthetic */ Alignment() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Alignment)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Newline
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mNumNewlines;

        private void $$robo$$android_text_HtmlToSpannedConverter_Newline$__constructor__(int numNewlines) {
            this.mNumNewlines = numNewlines;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Newline$__constructor__(n);
        }

        public Newline(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Newline$__constructor__(int ), this, n);
        }

        public /* synthetic */ Newline() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Newline)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Heading
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mLevel;

        private void $$robo$$android_text_HtmlToSpannedConverter_Heading$__constructor__(int level) {
            this.mLevel = level;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Heading$__constructor__(n);
        }

        public Heading(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Heading$__constructor__(int ), this, n);
        }

        public /* synthetic */ Heading() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Heading)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Background
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mBackgroundColor;

        private void $$robo$$android_text_HtmlToSpannedConverter_Background$__constructor__(int backgroundColor) {
            this.mBackgroundColor = backgroundColor;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Background$__constructor__(n);
        }

        public Background(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Background$__constructor__(int ), this, n);
        }

        public /* synthetic */ Background() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Background)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Foreground
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mForegroundColor;

        private void $$robo$$android_text_HtmlToSpannedConverter_Foreground$__constructor__(int foregroundColor) {
            this.mForegroundColor = foregroundColor;
        }

        private void __constructor__(int n) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Foreground$__constructor__(n);
        }

        public Foreground(int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Foreground$__constructor__(int ), this, n);
        }

        public /* synthetic */ Foreground() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Foreground)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Href
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String mHref;

        private void $$robo$$android_text_HtmlToSpannedConverter_Href$__constructor__(String href) {
            this.mHref = href;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Href$__constructor__(string2);
        }

        public Href(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Href$__constructor__(java.lang.String ), this, string2);
        }

        public /* synthetic */ Href() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Href)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Font
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public String mFace;

        private void $$robo$$android_text_HtmlToSpannedConverter_Font$__constructor__(String face) {
            this.mFace = face;
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Font$__constructor__(string2);
        }

        public Font(String string2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Font$__constructor__(java.lang.String ), this, string2);
        }

        public /* synthetic */ Font() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Font)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Bullet
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Bullet$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Bullet$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Bullet$__constructor__();
        }

        public Bullet() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Bullet$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Bullet$__constructor__(var1_1);
        }

        public /* synthetic */ Bullet(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Bullet$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Bullet)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Sub
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__();
        }

        public Sub() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__(var1_1);
        }

        public /* synthetic */ Sub(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Sub$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Sub)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Super
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__();
        }

        public Super() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__(var1_1);
        }

        public /* synthetic */ Super(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Super$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Super)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Blockquote
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__();
        }

        public Blockquote() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__(var1_1);
        }

        public /* synthetic */ Blockquote(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Blockquote$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Blockquote)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Monospace
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__();
        }

        public Monospace() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__(var1_1);
        }

        public /* synthetic */ Monospace(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Monospace$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Monospace)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Small
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__();
        }

        public Small() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__(var1_1);
        }

        public /* synthetic */ Small(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Small$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Small)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Big
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__();
        }

        public Big() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__(var1_1);
        }

        public /* synthetic */ Big(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Big$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Big)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Strikethrough
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Strikethrough$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Strikethrough$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Strikethrough$__constructor__();
        }

        public Strikethrough() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Strikethrough$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Strikethrough$__constructor__(var1_1);
        }

        public /* synthetic */ Strikethrough(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Strikethrough$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Strikethrough)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Underline
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__();
        }

        public Underline() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__(var1_1);
        }

        public /* synthetic */ Underline(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Underline$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Underline)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Italic
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__();
        }

        public Italic() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__(var1_1);
        }

        public /* synthetic */ Italic(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Italic$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Italic)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class Bold
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__();
        }

        public Bold() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__(var1_1);
        }

        public /* synthetic */ Bold(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_HtmlToSpannedConverter_Bold$__constructor__(android.text.HtmlToSpannedConverter$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Bold)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

