/*
 * Decompiled with CFR 0.152.
 */
package android.text.method;

import android.graphics.Paint;
import android.icu.lang.UCharacter;
import android.text.Editable;
import android.text.Emoji;
import android.text.Layout;
import android.text.NoCopySpan;
import android.text.Selection;
import android.text.Spanned;
import android.text.method.KeyListener;
import android.text.method.MetaKeyKeyListener;
import android.text.method.TextKeyListener;
import android.text.method.WordIterator;
import android.text.style.ReplacementSpan;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.android.internal.annotations.GuardedBy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class BaseKeyListener
extends MetaKeyKeyListener
implements KeyListener,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static Object OLD_SEL_START;
    private static int LINE_FEED = 10;
    private static int CARRIAGE_RETURN = 13;
    private Object mLock;
    @GuardedBy(value="mLock")
    static Paint sCachedPaint;

    private void $$robo$$android_text_method_BaseKeyListener$__constructor__() {
        this.mLock = new Object();
    }

    private final boolean $$robo$$android_text_method_BaseKeyListener$backspace(View view, Editable content, int keyCode, KeyEvent event) {
        return this.backspaceOrForwardDelete(view, content, keyCode, event, false);
    }

    private final boolean $$robo$$android_text_method_BaseKeyListener$forwardDelete(View view, Editable content, int keyCode, KeyEvent event) {
        return this.backspaceOrForwardDelete(view, content, keyCode, event, true);
    }

    private static final boolean $$robo$$android_text_method_BaseKeyListener$isVariationSelector(int codepoint) {
        return UCharacter.hasBinaryProperty(codepoint, 36);
    }

    private static final int $$robo$$android_text_method_BaseKeyListener$adjustReplacementSpan(CharSequence text, int offset, boolean moveToStart) {
        if (!(text instanceof Spanned)) {
            return offset;
        }
        ReplacementSpan[] spans = ((Spanned)text).getSpans(offset, offset, ReplacementSpan.class);
        for (int i = 0; i < spans.length; ++i) {
            int start = ((Spanned)text).getSpanStart(spans[i]);
            int end = ((Spanned)text).getSpanEnd(spans[i]);
            if (start >= offset || end <= offset) continue;
            offset = moveToStart ? start : end;
        }
        return offset;
    }

    private static final int $$robo$$android_text_method_BaseKeyListener$getOffsetForBackspaceKey(CharSequence text, int offset) {
        if (offset <= 1) {
            return 0;
        }
        boolean STATE_START = false;
        boolean STATE_LF = true;
        int STATE_BEFORE_KEYCAP = 2;
        int STATE_BEFORE_VS_AND_KEYCAP = 3;
        int STATE_BEFORE_EMOJI_MODIFIER = 4;
        int STATE_BEFORE_VS_AND_EMOJI_MODIFIER = 5;
        int STATE_BEFORE_VS = 6;
        int STATE_BEFORE_EMOJI = 7;
        int STATE_BEFORE_ZWJ = 8;
        int STATE_BEFORE_VS_AND_ZWJ = 9;
        int STATE_ODD_NUMBERED_RIS = 10;
        int STATE_EVEN_NUMBERED_RIS = 11;
        int STATE_IN_TAG_SEQUENCE = 12;
        int STATE_FINISHED = 13;
        int deleteCharCount = 0;
        int lastSeenVSCharCount = 0;
        int state = 0;
        int tmpOffset = offset;
        do {
            int codePoint = Character.codePointBefore(text, tmpOffset);
            tmpOffset -= Character.charCount(codePoint);
            switch (state) {
                case 0: {
                    deleteCharCount = Character.charCount(codePoint);
                    if (codePoint == 10) {
                        state = 1;
                        break;
                    }
                    if (BaseKeyListener.isVariationSelector(codePoint)) {
                        state = 6;
                        break;
                    }
                    if (Emoji.isRegionalIndicatorSymbol(codePoint)) {
                        state = 10;
                        break;
                    }
                    if (Emoji.isEmojiModifier(codePoint)) {
                        state = 4;
                        break;
                    }
                    if (codePoint == Emoji.COMBINING_ENCLOSING_KEYCAP) {
                        state = 2;
                        break;
                    }
                    if (Emoji.isEmoji(codePoint)) {
                        state = 7;
                        break;
                    }
                    if (codePoint == Emoji.CANCEL_TAG) {
                        state = 12;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 1: {
                    if (codePoint == 13) {
                        ++deleteCharCount;
                    }
                    state = 13;
                    break;
                }
                case 10: {
                    if (Emoji.isRegionalIndicatorSymbol(codePoint)) {
                        deleteCharCount += 2;
                        state = 11;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 11: {
                    if (Emoji.isRegionalIndicatorSymbol(codePoint)) {
                        deleteCharCount -= 2;
                        state = 10;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 2: {
                    if (BaseKeyListener.isVariationSelector(codePoint)) {
                        lastSeenVSCharCount = Character.charCount(codePoint);
                        state = 3;
                        break;
                    }
                    if (Emoji.isKeycapBase(codePoint)) {
                        deleteCharCount += Character.charCount(codePoint);
                    }
                    state = 13;
                    break;
                }
                case 3: {
                    if (Emoji.isKeycapBase(codePoint)) {
                        deleteCharCount += lastSeenVSCharCount + Character.charCount(codePoint);
                    }
                    state = 13;
                    break;
                }
                case 4: {
                    if (BaseKeyListener.isVariationSelector(codePoint)) {
                        lastSeenVSCharCount = Character.charCount(codePoint);
                        state = 5;
                        break;
                    }
                    if (Emoji.isEmojiModifierBase(codePoint)) {
                        deleteCharCount += Character.charCount(codePoint);
                    }
                    state = 13;
                    break;
                }
                case 5: {
                    if (Emoji.isEmojiModifierBase(codePoint)) {
                        deleteCharCount += lastSeenVSCharCount + Character.charCount(codePoint);
                    }
                    state = 13;
                    break;
                }
                case 6: {
                    if (Emoji.isEmoji(codePoint)) {
                        deleteCharCount += Character.charCount(codePoint);
                        state = 7;
                        break;
                    }
                    if (!BaseKeyListener.isVariationSelector(codePoint) && UCharacter.getCombiningClass(codePoint) == 0) {
                        deleteCharCount += Character.charCount(codePoint);
                    }
                    state = 13;
                    break;
                }
                case 7: {
                    if (codePoint == Emoji.ZERO_WIDTH_JOINER) {
                        state = 8;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 8: {
                    if (Emoji.isEmoji(codePoint)) {
                        deleteCharCount += Character.charCount(codePoint) + 1;
                        state = Emoji.isEmojiModifier(codePoint) ? 4 : 7;
                        break;
                    }
                    if (BaseKeyListener.isVariationSelector(codePoint)) {
                        lastSeenVSCharCount = Character.charCount(codePoint);
                        state = 9;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 9: {
                    if (Emoji.isEmoji(codePoint)) {
                        deleteCharCount += lastSeenVSCharCount + 1 + Character.charCount(codePoint);
                        lastSeenVSCharCount = 0;
                        state = 7;
                        break;
                    }
                    state = 13;
                    break;
                }
                case 12: {
                    if (Emoji.isTagSpecChar(codePoint)) {
                        deleteCharCount += 2;
                        break;
                    }
                    if (Emoji.isEmoji(codePoint)) {
                        deleteCharCount += Character.charCount(codePoint);
                        state = 13;
                        break;
                    }
                    deleteCharCount = 2;
                    state = 13;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("state " + state + " is unknown");
                }
            }
        } while (tmpOffset > 0 && state != 13);
        return BaseKeyListener.adjustReplacementSpan(text, offset - deleteCharCount, true);
    }

    private static final int $$robo$$android_text_method_BaseKeyListener$getOffsetForForwardDeleteKey(CharSequence text, int offset, Paint paint) {
        int len = text.length();
        if (offset >= len - 1) {
            return len;
        }
        offset = paint.getTextRunCursor(text, offset, len, 0, offset, 0);
        return BaseKeyListener.adjustReplacementSpan(text, offset, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_text_method_BaseKeyListener$backspaceOrForwardDelete(View view, Editable content, int keyCode, KeyEvent event, boolean isForwardDelete) {
        int end;
        boolean isAltActive;
        if (!KeyEvent.metaStateHasNoModifiers(event.getMetaState() & 0xFFFF8F0C)) {
            return false;
        }
        if (this.deleteSelection(view, content)) {
            return true;
        }
        boolean isCtrlActive = (event.getMetaState() & 0x1000) != 0;
        boolean isShiftActive = BaseKeyListener.getMetaState(content, 1, event) == 1;
        boolean bl = isAltActive = BaseKeyListener.getMetaState(content, 2, event) == 1;
        if (isCtrlActive) {
            if (isAltActive || isShiftActive) {
                return false;
            }
            return this.deleteUntilWordBoundary(view, content, isForwardDelete);
        }
        if (isAltActive && this.deleteLine(view, content)) {
            return true;
        }
        int start = Selection.getSelectionEnd(content);
        if (isForwardDelete) {
            Paint paint;
            if (view instanceof TextView) {
                paint = ((TextView)view).getPaint();
            } else {
                Object object = this.mLock;
                synchronized (object) {
                    if (sCachedPaint == null) {
                        sCachedPaint = new Paint();
                    }
                    paint = sCachedPaint;
                }
            }
            end = BaseKeyListener.getOffsetForForwardDeleteKey(content, start, paint);
        } else {
            end = BaseKeyListener.getOffsetForBackspaceKey(content, start);
        }
        if (start != end) {
            content.delete(Math.min(start, end), Math.max(start, end));
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_text_method_BaseKeyListener$deleteUntilWordBoundary(View view, Editable content, boolean isForwardDelete) {
        int deleteTo;
        int deleteFrom;
        int currentCursorOffset = Selection.getSelectionStart(content);
        if (currentCursorOffset != Selection.getSelectionEnd(content)) {
            return false;
        }
        if (!isForwardDelete && currentCursorOffset == 0 || isForwardDelete && currentCursorOffset == content.length()) {
            return false;
        }
        WordIterator wordIterator = null;
        if (view instanceof TextView) {
            wordIterator = ((TextView)view).getWordIterator();
        }
        if (wordIterator == null) {
            wordIterator = new WordIterator();
        }
        if (isForwardDelete) {
            deleteFrom = currentCursorOffset;
            wordIterator.setCharSequence(content, deleteFrom, content.length());
            deleteTo = wordIterator.following(currentCursorOffset);
            if (deleteTo == -1) {
                deleteTo = content.length();
            }
        } else {
            deleteTo = currentCursorOffset;
            wordIterator.setCharSequence(content, 0, deleteTo);
            deleteFrom = wordIterator.preceding(currentCursorOffset);
            if (deleteFrom == -1) {
                deleteFrom = 0;
            }
        }
        content.delete(deleteFrom, deleteTo);
        return true;
    }

    private final boolean $$robo$$android_text_method_BaseKeyListener$deleteSelection(View view, Editable content) {
        int selectionStart = Selection.getSelectionStart(content);
        int selectionEnd = Selection.getSelectionEnd(content);
        if (selectionEnd < selectionStart) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
        }
        if (selectionStart != selectionEnd) {
            content.delete(selectionStart, selectionEnd);
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_text_method_BaseKeyListener$deleteLine(View view, Editable content) {
        Layout layout2;
        if (view instanceof TextView && (layout2 = ((TextView)view).getLayout()) != null) {
            int line = layout2.getLineForOffset(Selection.getSelectionStart(content));
            int start = layout2.getLineStart(line);
            int end = layout2.getLineEnd(line);
            if (end != start) {
                content.delete(start, end);
                return true;
            }
        }
        return false;
    }

    private static final int $$robo$$android_text_method_BaseKeyListener$makeTextContentType(TextKeyListener.Capitalize caps, boolean autoText) {
        int contentType = 1;
        switch (1.$SwitchMap$android$text$method$TextKeyListener$Capitalize[caps.ordinal()]) {
            case 1: {
                contentType |= 0x1000;
                break;
            }
            case 2: {
                contentType |= 0x2000;
                break;
            }
            case 3: {
                contentType |= 0x4000;
            }
        }
        if (autoText) {
            contentType |= 0x8000;
        }
        return contentType;
    }

    private final boolean $$robo$$android_text_method_BaseKeyListener$onKeyDown(View view, Editable content, int keyCode, KeyEvent event) {
        boolean handled;
        switch (keyCode) {
            case 67: {
                handled = this.backspace(view, content, keyCode, event);
                break;
            }
            case 112: {
                handled = this.forwardDelete(view, content, keyCode, event);
                break;
            }
            default: {
                handled = false;
            }
        }
        if (handled) {
            BaseKeyListener.adjustMetaAfterKeypress(content);
            return true;
        }
        return super.onKeyDown(view, content, keyCode, event);
    }

    private final boolean $$robo$$android_text_method_BaseKeyListener$onKeyOther(View view, Editable content, KeyEvent event) {
        String text;
        if (event.getAction() != 2 || event.getKeyCode() != 0) {
            return false;
        }
        int selectionStart = Selection.getSelectionStart(content);
        int selectionEnd = Selection.getSelectionEnd(content);
        if (selectionEnd < selectionStart) {
            int temp = selectionEnd;
            selectionEnd = selectionStart;
            selectionStart = temp;
        }
        if ((text = event.getCharacters()) == null) {
            return false;
        }
        content.replace(selectionStart, selectionEnd, text);
        return true;
    }

    static void __staticInitializer__() {
        OLD_SEL_START = new NoCopySpan.Concrete();
        sCachedPaint = null;
    }

    private void __constructor__() {
        this.$$robo$$android_text_method_BaseKeyListener$__constructor__();
    }

    public BaseKeyListener() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_text_method_BaseKeyListener$__constructor__(), this);
    }

    public boolean backspace(View view, Editable editable, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("backspace", $$robo$$android_text_method_BaseKeyListener$backspace(android.view.View android.text.Editable int android.view.KeyEvent ), this, view, editable, n, keyEvent);
    }

    public boolean forwardDelete(View view, Editable editable, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("forwardDelete", $$robo$$android_text_method_BaseKeyListener$forwardDelete(android.view.View android.text.Editable int android.view.KeyEvent ), this, view, editable, n, keyEvent);
    }

    private static boolean isVariationSelector(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isVariationSelector", $$robo$$android_text_method_BaseKeyListener$isVariationSelector(int ), (int)n);
    }

    private static int adjustReplacementSpan(CharSequence charSequence, int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("adjustReplacementSpan", $$robo$$android_text_method_BaseKeyListener$adjustReplacementSpan(java.lang.CharSequence int boolean ), (CharSequence)charSequence, (int)n, (boolean)bl);
    }

    private static int getOffsetForBackspaceKey(CharSequence charSequence, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getOffsetForBackspaceKey", $$robo$$android_text_method_BaseKeyListener$getOffsetForBackspaceKey(java.lang.CharSequence int ), (CharSequence)charSequence, (int)n);
    }

    private static int getOffsetForForwardDeleteKey(CharSequence charSequence, int n, Paint paint) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getOffsetForForwardDeleteKey", $$robo$$android_text_method_BaseKeyListener$getOffsetForForwardDeleteKey(java.lang.CharSequence int android.graphics.Paint ), (CharSequence)charSequence, (int)n, (Paint)paint);
    }

    private boolean backspaceOrForwardDelete(View view, Editable editable, int n, KeyEvent keyEvent, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("backspaceOrForwardDelete", $$robo$$android_text_method_BaseKeyListener$backspaceOrForwardDelete(android.view.View android.text.Editable int android.view.KeyEvent boolean ), this, view, editable, n, keyEvent, bl);
    }

    private boolean deleteUntilWordBoundary(View view, Editable editable, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteUntilWordBoundary", $$robo$$android_text_method_BaseKeyListener$deleteUntilWordBoundary(android.view.View android.text.Editable boolean ), this, view, editable, bl);
    }

    private boolean deleteSelection(View view, Editable editable) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteSelection", $$robo$$android_text_method_BaseKeyListener$deleteSelection(android.view.View android.text.Editable ), this, view, editable);
    }

    private boolean deleteLine(View view, Editable editable) {
        return (boolean)InvokeDynamicSupport.bootstrap("deleteLine", $$robo$$android_text_method_BaseKeyListener$deleteLine(android.view.View android.text.Editable ), this, view, editable);
    }

    static int makeTextContentType(TextKeyListener.Capitalize capitalize, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("makeTextContentType", $$robo$$android_text_method_BaseKeyListener$makeTextContentType(android.text.method.TextKeyListener$Capitalize boolean ), (TextKeyListener.Capitalize)capitalize, (boolean)bl);
    }

    @Override
    public boolean onKeyDown(View view, Editable editable, int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_text_method_BaseKeyListener$onKeyDown(android.view.View android.text.Editable int android.view.KeyEvent ), this, view, editable, n, keyEvent);
    }

    @Override
    public boolean onKeyOther(View view, Editable editable, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyOther", $$robo$$android_text_method_BaseKeyListener$onKeyOther(android.view.View android.text.Editable android.view.KeyEvent ), this, view, editable, keyEvent);
    }

    static {
        RobolectricInternals.classInitializing(BaseKeyListener.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseKeyListener)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

