/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.Build;
import android.os.SystemClock;
import android.os.Trace;
import android.util.Pair;
import android.util.Slog;
import java.util.ArrayDeque;
import java.util.Deque;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BootTimingsTraceLog
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static boolean DEBUG_BOOT_TIME;
    private Deque<Pair<String, Long>> mStartTimes;
    private String mTag;
    private long mTraceTag;

    private void $$robo$$android_util_BootTimingsTraceLog$__constructor__(String tag, long traceTag) {
        this.mStartTimes = DEBUG_BOOT_TIME ? new ArrayDeque() : null;
        this.mTag = tag;
        this.mTraceTag = traceTag;
    }

    private final void $$robo$$android_util_BootTimingsTraceLog$traceBegin(String name) {
        Trace.traceBegin(this.mTraceTag, name);
        if (DEBUG_BOOT_TIME) {
            this.mStartTimes.push(Pair.create(name, SystemClock.elapsedRealtime()));
        }
    }

    private final void $$robo$$android_util_BootTimingsTraceLog$traceEnd() {
        Trace.traceEnd(this.mTraceTag);
        if (!DEBUG_BOOT_TIME) {
            return;
        }
        if (this.mStartTimes.peek() == null) {
            Slog.w(this.mTag, "traceEnd called more times than traceBegin");
            return;
        }
        Pair<String, Long> event = this.mStartTimes.pop();
        Slog.d(this.mTag, (String)event.first + " took to complete: " + (SystemClock.elapsedRealtime() - (Long)event.second) + "ms");
    }

    static void __staticInitializer__() {
        DEBUG_BOOT_TIME = !"user".equals(Build.TYPE);
    }

    private void __constructor__(String string2, long l) {
        this.$$robo$$android_util_BootTimingsTraceLog$__constructor__(string2, l);
    }

    public BootTimingsTraceLog(String string2, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_BootTimingsTraceLog$__constructor__(java.lang.String long ), this, string2, l);
    }

    public void traceBegin(String string2) {
        InvokeDynamicSupport.bootstrap("traceBegin", $$robo$$android_util_BootTimingsTraceLog$traceBegin(java.lang.String ), this, string2);
    }

    public void traceEnd() {
        InvokeDynamicSupport.bootstrap("traceEnd", $$robo$$android_util_BootTimingsTraceLog$traceEnd(), this);
    }

    static {
        RobolectricInternals.classInitializing(BootTimingsTraceLog.class);
    }

    public /* synthetic */ BootTimingsTraceLog() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BootTimingsTraceLog)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

