/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Rational
extends Number
implements Comparable<Rational> {
    public /* synthetic */ Object __robo_data__;
    public static Rational NaN;
    public static Rational POSITIVE_INFINITY;
    public static Rational NEGATIVE_INFINITY;
    public static Rational ZERO;
    private static long serialVersionUID = 1L;
    private int mNumerator;
    private int mDenominator;

    private void $$robo$$android_util_Rational$__constructor__(int numerator, int denominator) {
        if (denominator < 0) {
            numerator = -numerator;
            denominator = -denominator;
        }
        if (denominator == 0 && numerator > 0) {
            this.mNumerator = 1;
            this.mDenominator = 0;
        } else if (denominator == 0 && numerator < 0) {
            this.mNumerator = -1;
            this.mDenominator = 0;
        } else if (denominator == 0 && numerator == 0) {
            this.mNumerator = 0;
            this.mDenominator = 0;
        } else if (numerator == 0) {
            this.mNumerator = 0;
            this.mDenominator = 1;
        } else {
            int gcd = Rational.gcd(numerator, denominator);
            this.mNumerator = numerator / gcd;
            this.mDenominator = denominator / gcd;
        }
    }

    private final int $$robo$$android_util_Rational$getNumerator() {
        return this.mNumerator;
    }

    private final int $$robo$$android_util_Rational$getDenominator() {
        return this.mDenominator;
    }

    private final boolean $$robo$$android_util_Rational$isNaN() {
        return this.mDenominator == 0 && this.mNumerator == 0;
    }

    private final boolean $$robo$$android_util_Rational$isInfinite() {
        return this.mNumerator != 0 && this.mDenominator == 0;
    }

    private final boolean $$robo$$android_util_Rational$isFinite() {
        return this.mDenominator != 0;
    }

    private final boolean $$robo$$android_util_Rational$isZero() {
        return this.isFinite() && this.mNumerator == 0;
    }

    private final boolean $$robo$$android_util_Rational$isPosInf() {
        return this.mDenominator == 0 && this.mNumerator > 0;
    }

    private final boolean $$robo$$android_util_Rational$isNegInf() {
        return this.mDenominator == 0 && this.mNumerator < 0;
    }

    private final boolean $$robo$$android_util_Rational$equals(Object obj) {
        return obj instanceof Rational && this.equals((Rational)obj);
    }

    private final boolean $$robo$$android_util_Rational$equals(Rational other) {
        return this.mNumerator == other.mNumerator && this.mDenominator == other.mDenominator;
    }

    private final String $$robo$$android_util_Rational$toString() {
        if (this.isNaN()) {
            return "NaN";
        }
        if (this.isPosInf()) {
            return "Infinity";
        }
        if (this.isNegInf()) {
            return "-Infinity";
        }
        return this.mNumerator + "/" + this.mDenominator;
    }

    private final float $$robo$$android_util_Rational$toFloat() {
        return this.floatValue();
    }

    private final int $$robo$$android_util_Rational$hashCode() {
        int numeratorFlipped = this.mNumerator << 16 | this.mNumerator >>> 16;
        return this.mDenominator ^ numeratorFlipped;
    }

    private static final int $$robo$$android_util_Rational$gcd(int numerator, int denominator) {
        int a = numerator;
        int b = denominator;
        while (b != 0) {
            int oldB = b;
            b = a % b;
            a = oldB;
        }
        return Math.abs(a);
    }

    private final double $$robo$$android_util_Rational$doubleValue() {
        double num = this.mNumerator;
        double den = this.mDenominator;
        return num / den;
    }

    private final float $$robo$$android_util_Rational$floatValue() {
        float num = this.mNumerator;
        float den = this.mDenominator;
        return num / den;
    }

    private final int $$robo$$android_util_Rational$intValue() {
        if (this.isPosInf()) {
            return Integer.MAX_VALUE;
        }
        if (this.isNegInf()) {
            return Integer.MIN_VALUE;
        }
        if (this.isNaN()) {
            return 0;
        }
        return this.mNumerator / this.mDenominator;
    }

    private final long $$robo$$android_util_Rational$longValue() {
        if (this.isPosInf()) {
            return Long.MAX_VALUE;
        }
        if (this.isNegInf()) {
            return Long.MIN_VALUE;
        }
        if (this.isNaN()) {
            return 0L;
        }
        return this.mNumerator / this.mDenominator;
    }

    private final short $$robo$$android_util_Rational$shortValue() {
        return (short)this.intValue();
    }

    private final int $$robo$$android_util_Rational$compareTo(Rational another) {
        Preconditions.checkNotNull(another, "another must not be null");
        if (this.equals(another)) {
            return 0;
        }
        if (this.isNaN()) {
            return 1;
        }
        if (another.isNaN()) {
            return -1;
        }
        if (this.isPosInf() || another.isNegInf()) {
            return 1;
        }
        if (this.isNegInf() || another.isPosInf()) {
            return -1;
        }
        long thisNumerator = (long)this.mNumerator * (long)another.mDenominator;
        long otherNumerator = (long)another.mNumerator * (long)this.mDenominator;
        if (thisNumerator < otherNumerator) {
            return -1;
        }
        if (thisNumerator > otherNumerator) {
            return 1;
        }
        return 0;
    }

    private final void $$robo$$android_util_Rational$readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.mNumerator == 0) {
            if (this.mDenominator == 1 || this.mDenominator == 0) {
                return;
            }
            throw new InvalidObjectException("Rational must be deserialized from a reduced form for zero values");
        }
        if (this.mDenominator == 0) {
            if (this.mNumerator == 1 || this.mNumerator == -1) {
                return;
            }
            throw new InvalidObjectException("Rational must be deserialized from a reduced form for infinity values");
        }
        if (Rational.gcd(this.mNumerator, this.mDenominator) > 1) {
            throw new InvalidObjectException("Rational must be deserialized from a reduced form for finite values");
        }
    }

    private static final NumberFormatException $$robo$$android_util_Rational$invalidRational(String s) {
        throw new NumberFormatException("Invalid Rational: \"" + s + "\"");
    }

    private static final Rational $$robo$$android_util_Rational$parseRational(String string2) throws NumberFormatException {
        Preconditions.checkNotNull(string2, "string must not be null");
        if (string2.equals("NaN")) {
            return NaN;
        }
        if (string2.equals("Infinity")) {
            return POSITIVE_INFINITY;
        }
        if (string2.equals("-Infinity")) {
            return NEGATIVE_INFINITY;
        }
        int sep_ix = string2.indexOf(58);
        if (sep_ix < 0) {
            sep_ix = string2.indexOf(47);
        }
        if (sep_ix < 0) {
            throw Rational.invalidRational(string2);
        }
        try {
            return new Rational(Integer.parseInt(string2.substring(0, sep_ix)), Integer.parseInt(string2.substring(sep_ix + 1)));
        }
        catch (NumberFormatException e) {
            throw Rational.invalidRational(string2);
        }
    }

    static void __staticInitializer__() {
        NaN = new Rational(0, 0);
        POSITIVE_INFINITY = new Rational(1, 0);
        NEGATIVE_INFINITY = new Rational(-1, 0);
        ZERO = new Rational(0, 1);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_util_Rational$__constructor__(n, n2);
    }

    public Rational(int n, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_Rational$__constructor__(int int ), this, n, n2);
    }

    public int getNumerator() {
        return (int)InvokeDynamicSupport.bootstrap("getNumerator", $$robo$$android_util_Rational$getNumerator(), this);
    }

    public int getDenominator() {
        return (int)InvokeDynamicSupport.bootstrap("getDenominator", $$robo$$android_util_Rational$getDenominator(), this);
    }

    public boolean isNaN() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNaN", $$robo$$android_util_Rational$isNaN(), this);
    }

    public boolean isInfinite() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInfinite", $$robo$$android_util_Rational$isInfinite(), this);
    }

    public boolean isFinite() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFinite", $$robo$$android_util_Rational$isFinite(), this);
    }

    public boolean isZero() {
        return (boolean)InvokeDynamicSupport.bootstrap("isZero", $$robo$$android_util_Rational$isZero(), this);
    }

    private boolean isPosInf() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPosInf", $$robo$$android_util_Rational$isPosInf(), this);
    }

    private boolean isNegInf() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNegInf", $$robo$$android_util_Rational$isNegInf(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_util_Rational$equals(java.lang.Object ), this, object);
    }

    private boolean equals(Rational rational) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_util_Rational$equals(android.util.Rational ), this, rational);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_Rational$toString(), this);
    }

    public float toFloat() {
        return (float)InvokeDynamicSupport.bootstrap("toFloat", $$robo$$android_util_Rational$toFloat(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_util_Rational$hashCode(), this);
    }

    public static int gcd(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("gcd", $$robo$$android_util_Rational$gcd(int int ), (int)n, (int)n2);
    }

    @Override
    public double doubleValue() {
        return (double)InvokeDynamicSupport.bootstrap("doubleValue", $$robo$$android_util_Rational$doubleValue(), this);
    }

    @Override
    public float floatValue() {
        return (float)InvokeDynamicSupport.bootstrap("floatValue", $$robo$$android_util_Rational$floatValue(), this);
    }

    @Override
    public int intValue() {
        return (int)InvokeDynamicSupport.bootstrap("intValue", $$robo$$android_util_Rational$intValue(), this);
    }

    @Override
    public long longValue() {
        return (long)InvokeDynamicSupport.bootstrap("longValue", $$robo$$android_util_Rational$longValue(), this);
    }

    @Override
    public short shortValue() {
        return (short)InvokeDynamicSupport.bootstrap("shortValue", $$robo$$android_util_Rational$shortValue(), this);
    }

    @Override
    public int compareTo(Rational rational) {
        return (int)InvokeDynamicSupport.bootstrap("compareTo", $$robo$$android_util_Rational$compareTo(android.util.Rational ), this, rational);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        InvokeDynamicSupport.bootstrap("readObject", $$robo$$android_util_Rational$readObject(java.io.ObjectInputStream ), this, objectInputStream);
    }

    private static NumberFormatException invalidRational(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("invalidRational", $$robo$$android_util_Rational$invalidRational(java.lang.String ), (String)string2);
    }

    public static Rational parseRational(String string2) throws NumberFormatException {
        return InvokeDynamicSupport.bootstrapStatic("parseRational", $$robo$$android_util_Rational$parseRational(java.lang.String ), (String)string2);
    }

    static {
        RobolectricInternals.classInitializing(Rational.class);
    }

    public /* synthetic */ Rational() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Rational)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

