/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.SystemClock;
import android.util.Log;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TimingLogger
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private String mTag;
    private String mLabel;
    private boolean mDisabled;
    ArrayList<Long> mSplits;
    ArrayList<String> mSplitLabels;

    private void $$robo$$android_util_TimingLogger$__constructor__(String tag, String label) {
        this.reset(tag, label);
    }

    private final void $$robo$$android_util_TimingLogger$reset(String tag, String label) {
        this.mTag = tag;
        this.mLabel = label;
        this.reset();
    }

    private final void $$robo$$android_util_TimingLogger$reset() {
        boolean bl = this.mDisabled = !Log.isLoggable(this.mTag, 2);
        if (this.mDisabled) {
            return;
        }
        if (this.mSplits == null) {
            this.mSplits = new ArrayList();
            this.mSplitLabels = new ArrayList();
        } else {
            this.mSplits.clear();
            this.mSplitLabels.clear();
        }
        this.addSplit(null);
    }

    private final void $$robo$$android_util_TimingLogger$addSplit(String splitLabel) {
        if (this.mDisabled) {
            return;
        }
        long now = SystemClock.elapsedRealtime();
        this.mSplits.add(now);
        this.mSplitLabels.add(splitLabel);
    }

    private final void $$robo$$android_util_TimingLogger$dumpToLog() {
        long first;
        if (this.mDisabled) {
            return;
        }
        Log.d(this.mTag, this.mLabel + ": begin");
        long now = first = this.mSplits.get(0).longValue();
        for (int i = 1; i < this.mSplits.size(); ++i) {
            now = this.mSplits.get(i);
            String splitLabel = this.mSplitLabels.get(i);
            long prev = this.mSplits.get(i - 1);
            Log.d(this.mTag, this.mLabel + ":      " + (now - prev) + " ms, " + splitLabel);
        }
        Log.d(this.mTag, this.mLabel + ": end, " + (now - first) + " ms");
    }

    private void __constructor__(String string2, String string3) {
        this.$$robo$$android_util_TimingLogger$__constructor__(string2, string3);
    }

    public TimingLogger(String string2, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_TimingLogger$__constructor__(java.lang.String java.lang.String ), this, string2, string3);
    }

    public void reset(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_util_TimingLogger$reset(java.lang.String java.lang.String ), this, string2, string3);
    }

    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$android_util_TimingLogger$reset(), this);
    }

    public void addSplit(String string2) {
        InvokeDynamicSupport.bootstrap("addSplit", $$robo$$android_util_TimingLogger$addSplit(java.lang.String ), this, string2);
    }

    public void dumpToLog() {
        InvokeDynamicSupport.bootstrap("dumpToLog", $$robo$$android_util_TimingLogger$dumpToLog(), this);
    }

    public /* synthetic */ TimingLogger() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimingLogger)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

