/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Rect;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class FocusFinder
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static ThreadLocal<FocusFinder> tlFocusFinder;
    Rect mFocusedRect;
    Rect mOtherRect;
    Rect mBestCandidateRect;
    private UserSpecifiedFocusComparator mUserSpecifiedFocusComparator;
    private UserSpecifiedFocusComparator mUserSpecifiedClusterComparator;
    private FocusSorter mFocusSorter;
    private ArrayList<View> mTempList;

    private static final FocusFinder $$robo$$android_view_FocusFinder$getInstance() {
        return tlFocusFinder.get();
    }

    private void $$robo$$android_view_FocusFinder$__constructor__() {
        this.mFocusedRect = new Rect();
        this.mOtherRect = new Rect();
        this.mBestCandidateRect = new Rect();
        this.mUserSpecifiedFocusComparator = new UserSpecifiedFocusComparator((r, v) -> FocusFinder.isValidId(v.getNextFocusForwardId()) ? v.findUserSetNextFocus(r, 2) : null);
        this.mUserSpecifiedClusterComparator = new UserSpecifiedFocusComparator((r, v) -> FocusFinder.isValidId(v.getNextClusterForwardId()) ? v.findUserSetNextKeyboardNavigationCluster(r, 2) : null);
        this.mFocusSorter = new FocusSorter();
        this.mTempList = new ArrayList();
    }

    private final View $$robo$$android_view_FocusFinder$findNextFocus(ViewGroup root, View focused, int direction) {
        return this.findNextFocus(root, focused, null, direction);
    }

    private final View $$robo$$android_view_FocusFinder$findNextFocusFromRect(ViewGroup root, Rect focusedRect, int direction) {
        this.mFocusedRect.set(focusedRect);
        return this.findNextFocus(root, null, this.mFocusedRect, direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final View $$robo$$android_view_FocusFinder$findNextFocus(ViewGroup root, View focused, Rect focusedRect, int direction) {
        View next = null;
        ViewGroup effectiveRoot = this.getEffectiveRoot(root, focused);
        if (focused != null) {
            next = this.findNextUserSpecifiedFocus(effectiveRoot, focused, direction);
        }
        if (next != null) {
            return next;
        }
        ArrayList<View> focusables = this.mTempList;
        try {
            focusables.clear();
            effectiveRoot.addFocusables(focusables, direction);
            if (!focusables.isEmpty()) {
                next = this.findNextFocus(effectiveRoot, focused, focusedRect, direction, focusables);
            }
        }
        finally {
            focusables.clear();
        }
        return next;
    }

    private final ViewGroup $$robo$$android_view_FocusFinder$getEffectiveRoot(ViewGroup root, View focused) {
        if (focused == null || focused == root) {
            return root;
        }
        ViewGroup effective = null;
        ViewParent nextParent = focused.getParent();
        do {
            if (nextParent == root) {
                return effective != null ? effective : root;
            }
            ViewGroup vg = (ViewGroup)nextParent;
            if (!vg.getTouchscreenBlocksFocus() || !focused.getContext().getPackageManager().hasSystemFeature("android.hardware.touchscreen") || !vg.isKeyboardNavigationCluster()) continue;
            effective = vg;
        } while ((nextParent = nextParent.getParent()) instanceof ViewGroup);
        return root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final View $$robo$$android_view_FocusFinder$findNextKeyboardNavigationCluster(View root, View currentCluster, int direction) {
        View next = null;
        if (currentCluster != null && (next = this.findNextUserSpecifiedKeyboardNavigationCluster(root, currentCluster, direction)) != null) {
            return next;
        }
        ArrayList<View> clusters = this.mTempList;
        try {
            clusters.clear();
            root.addKeyboardNavigationClusters(clusters, direction);
            if (!clusters.isEmpty()) {
                next = this.findNextKeyboardNavigationCluster(root, currentCluster, clusters, direction);
            }
        }
        finally {
            clusters.clear();
        }
        return next;
    }

    private final View $$robo$$android_view_FocusFinder$findNextUserSpecifiedKeyboardNavigationCluster(View root, View currentCluster, int direction) {
        View userSetNextCluster = currentCluster.findUserSetNextKeyboardNavigationCluster(root, direction);
        if (userSetNextCluster != null && userSetNextCluster.hasFocusable()) {
            return userSetNextCluster;
        }
        return null;
    }

    private final View $$robo$$android_view_FocusFinder$findNextUserSpecifiedFocus(ViewGroup root, View focused, int direction) {
        for (View userSetNextFocus = focused.findUserSetNextFocus(root, direction); userSetNextFocus != null; userSetNextFocus = userSetNextFocus.findUserSetNextFocus(root, direction)) {
            if (!userSetNextFocus.isFocusable() || userSetNextFocus.getVisibility() != 0 || userSetNextFocus.isInTouchMode() && !userSetNextFocus.isFocusableInTouchMode()) continue;
            return userSetNextFocus;
        }
        return null;
    }

    private final View $$robo$$android_view_FocusFinder$findNextFocus(ViewGroup root, View focused, Rect focusedRect, int direction, ArrayList<View> focusables) {
        if (focused != null) {
            if (focusedRect == null) {
                focusedRect = this.mFocusedRect;
            }
            focused.getFocusedRect(focusedRect);
            root.offsetDescendantRectToMyCoords(focused, focusedRect);
        } else if (focusedRect == null) {
            focusedRect = this.mFocusedRect;
            switch (direction) {
                case 66: 
                case 130: {
                    this.setFocusTopLeft(root, focusedRect);
                    break;
                }
                case 2: {
                    if (root.isLayoutRtl()) {
                        this.setFocusBottomRight(root, focusedRect);
                        break;
                    }
                    this.setFocusTopLeft(root, focusedRect);
                    break;
                }
                case 17: 
                case 33: {
                    this.setFocusBottomRight(root, focusedRect);
                    break;
                }
                case 1: {
                    if (root.isLayoutRtl()) {
                        this.setFocusTopLeft(root, focusedRect);
                        break;
                    }
                    this.setFocusBottomRight(root, focusedRect);
                }
            }
        }
        switch (direction) {
            case 1: 
            case 2: {
                return this.findNextFocusInRelativeDirection(focusables, root, focused, focusedRect, direction);
            }
            case 17: 
            case 33: 
            case 66: 
            case 130: {
                return this.findNextFocusInAbsoluteDirection(focusables, root, focused, focusedRect, direction);
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final View $$robo$$android_view_FocusFinder$findNextKeyboardNavigationCluster(View root, View currentCluster, List<View> clusters, int direction) {
        try {
            this.mUserSpecifiedClusterComparator.setFocusables(clusters, root);
            Collections.sort(clusters, this.mUserSpecifiedClusterComparator);
        }
        finally {
            this.mUserSpecifiedClusterComparator.recycle();
        }
        int count = clusters.size();
        switch (direction) {
            case 2: 
            case 66: 
            case 130: {
                return FocusFinder.getNextKeyboardNavigationCluster(root, currentCluster, clusters, count);
            }
            case 1: 
            case 17: 
            case 33: {
                return FocusFinder.getPreviousKeyboardNavigationCluster(root, currentCluster, clusters, count);
            }
        }
        throw new IllegalArgumentException("Unknown direction: " + direction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final View $$robo$$android_view_FocusFinder$findNextFocusInRelativeDirection(ArrayList<View> focusables, ViewGroup root, View focused, Rect focusedRect, int direction) {
        try {
            this.mUserSpecifiedFocusComparator.setFocusables(focusables, root);
            Collections.sort(focusables, this.mUserSpecifiedFocusComparator);
        }
        finally {
            this.mUserSpecifiedFocusComparator.recycle();
        }
        int count = focusables.size();
        switch (direction) {
            case 2: {
                return FocusFinder.getNextFocusable(focused, focusables, count);
            }
            case 1: {
                return FocusFinder.getPreviousFocusable(focused, focusables, count);
            }
        }
        return focusables.get(count - 1);
    }

    private final void $$robo$$android_view_FocusFinder$setFocusBottomRight(ViewGroup root, Rect focusedRect) {
        int rootBottom = root.getScrollY() + root.getHeight();
        int rootRight = root.getScrollX() + root.getWidth();
        focusedRect.set(rootRight, rootBottom, rootRight, rootBottom);
    }

    private final void $$robo$$android_view_FocusFinder$setFocusTopLeft(ViewGroup root, Rect focusedRect) {
        int rootTop = root.getScrollY();
        int rootLeft = root.getScrollX();
        focusedRect.set(rootLeft, rootTop, rootLeft, rootTop);
    }

    private final View $$robo$$android_view_FocusFinder$findNextFocusInAbsoluteDirection(ArrayList<View> focusables, ViewGroup root, View focused, Rect focusedRect, int direction) {
        this.mBestCandidateRect.set(focusedRect);
        switch (direction) {
            case 17: {
                this.mBestCandidateRect.offset(focusedRect.width() + 1, 0);
                break;
            }
            case 66: {
                this.mBestCandidateRect.offset(-(focusedRect.width() + 1), 0);
                break;
            }
            case 33: {
                this.mBestCandidateRect.offset(0, focusedRect.height() + 1);
                break;
            }
            case 130: {
                this.mBestCandidateRect.offset(0, -(focusedRect.height() + 1));
            }
        }
        View closest = null;
        int numFocusables = focusables.size();
        for (int i = 0; i < numFocusables; ++i) {
            View focusable = focusables.get(i);
            if (focusable == focused || focusable == root) continue;
            focusable.getFocusedRect(this.mOtherRect);
            root.offsetDescendantRectToMyCoords(focusable, this.mOtherRect);
            if (!this.isBetterCandidate(direction, focusedRect, this.mOtherRect, this.mBestCandidateRect)) continue;
            this.mBestCandidateRect.set(this.mOtherRect);
            closest = focusable;
        }
        return closest;
    }

    private static final View $$robo$$android_view_FocusFinder$getNextFocusable(View focused, ArrayList<View> focusables, int count) {
        int position;
        if (focused != null && (position = focusables.lastIndexOf(focused)) >= 0 && position + 1 < count) {
            return focusables.get(position + 1);
        }
        if (!focusables.isEmpty()) {
            return focusables.get(0);
        }
        return null;
    }

    private static final View $$robo$$android_view_FocusFinder$getPreviousFocusable(View focused, ArrayList<View> focusables, int count) {
        int position;
        if (focused != null && (position = focusables.indexOf(focused)) > 0) {
            return focusables.get(position - 1);
        }
        if (!focusables.isEmpty()) {
            return focusables.get(count - 1);
        }
        return null;
    }

    private static final View $$robo$$android_view_FocusFinder$getNextKeyboardNavigationCluster(View root, View currentCluster, List<View> clusters, int count) {
        if (currentCluster == null) {
            return clusters.get(0);
        }
        int position = clusters.lastIndexOf(currentCluster);
        if (position >= 0 && position + 1 < count) {
            return clusters.get(position + 1);
        }
        return root;
    }

    private static final View $$robo$$android_view_FocusFinder$getPreviousKeyboardNavigationCluster(View root, View currentCluster, List<View> clusters, int count) {
        if (currentCluster == null) {
            return clusters.get(count - 1);
        }
        int position = clusters.indexOf(currentCluster);
        if (position > 0) {
            return clusters.get(position - 1);
        }
        return root;
    }

    private final boolean $$robo$$android_view_FocusFinder$isBetterCandidate(int direction, Rect source, Rect rect1, Rect rect2) {
        if (!this.isCandidate(source, rect1, direction)) {
            return false;
        }
        if (!this.isCandidate(source, rect2, direction)) {
            return true;
        }
        if (this.beamBeats(direction, source, rect1, rect2)) {
            return true;
        }
        if (this.beamBeats(direction, source, rect2, rect1)) {
            return false;
        }
        return this.getWeightedDistanceFor(FocusFinder.majorAxisDistance(direction, source, rect1), FocusFinder.minorAxisDistance(direction, source, rect1)) < this.getWeightedDistanceFor(FocusFinder.majorAxisDistance(direction, source, rect2), FocusFinder.minorAxisDistance(direction, source, rect2));
    }

    private final boolean $$robo$$android_view_FocusFinder$beamBeats(int direction, Rect source, Rect rect1, Rect rect2) {
        boolean rect1InSrcBeam = this.beamsOverlap(direction, source, rect1);
        boolean rect2InSrcBeam = this.beamsOverlap(direction, source, rect2);
        if (rect2InSrcBeam || !rect1InSrcBeam) {
            return false;
        }
        if (!this.isToDirectionOf(direction, source, rect2)) {
            return true;
        }
        if (direction == 17 || direction == 66) {
            return true;
        }
        return FocusFinder.majorAxisDistance(direction, source, rect1) < FocusFinder.majorAxisDistanceToFarEdge(direction, source, rect2);
    }

    private final int $$robo$$android_view_FocusFinder$getWeightedDistanceFor(int majorAxisDistance, int minorAxisDistance) {
        return 13 * majorAxisDistance * majorAxisDistance + minorAxisDistance * minorAxisDistance;
    }

    private final boolean $$robo$$android_view_FocusFinder$isCandidate(Rect srcRect, Rect destRect, int direction) {
        switch (direction) {
            case 17: {
                return (srcRect.right > destRect.right || srcRect.left >= destRect.right) && srcRect.left > destRect.left;
            }
            case 66: {
                return (srcRect.left < destRect.left || srcRect.right <= destRect.left) && srcRect.right < destRect.right;
            }
            case 33: {
                return (srcRect.bottom > destRect.bottom || srcRect.top >= destRect.bottom) && srcRect.top > destRect.top;
            }
            case 130: {
                return (srcRect.top < destRect.top || srcRect.bottom <= destRect.top) && srcRect.bottom < destRect.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private final boolean $$robo$$android_view_FocusFinder$beamsOverlap(int direction, Rect rect1, Rect rect2) {
        switch (direction) {
            case 17: 
            case 66: {
                return rect2.bottom >= rect1.top && rect2.top <= rect1.bottom;
            }
            case 33: 
            case 130: {
                return rect2.right >= rect1.left && rect2.left <= rect1.right;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private final boolean $$robo$$android_view_FocusFinder$isToDirectionOf(int direction, Rect src, Rect dest) {
        switch (direction) {
            case 17: {
                return src.left >= dest.right;
            }
            case 66: {
                return src.right <= dest.left;
            }
            case 33: {
                return src.top >= dest.bottom;
            }
            case 130: {
                return src.bottom <= dest.top;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static final int $$robo$$android_view_FocusFinder$majorAxisDistance(int direction, Rect source, Rect dest) {
        return Math.max(0, FocusFinder.majorAxisDistanceRaw(direction, source, dest));
    }

    private static final int $$robo$$android_view_FocusFinder$majorAxisDistanceRaw(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: {
                return source.left - dest.right;
            }
            case 66: {
                return dest.left - source.right;
            }
            case 33: {
                return source.top - dest.bottom;
            }
            case 130: {
                return dest.top - source.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static final int $$robo$$android_view_FocusFinder$majorAxisDistanceToFarEdge(int direction, Rect source, Rect dest) {
        return Math.max(1, FocusFinder.majorAxisDistanceToFarEdgeRaw(direction, source, dest));
    }

    private static final int $$robo$$android_view_FocusFinder$majorAxisDistanceToFarEdgeRaw(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: {
                return source.left - dest.left;
            }
            case 66: {
                return dest.right - source.right;
            }
            case 33: {
                return source.top - dest.top;
            }
            case 130: {
                return dest.bottom - source.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static final int $$robo$$android_view_FocusFinder$minorAxisDistance(int direction, Rect source, Rect dest) {
        switch (direction) {
            case 17: 
            case 66: {
                return Math.abs(source.top + source.height() / 2 - (dest.top + dest.height() / 2));
            }
            case 33: 
            case 130: {
                return Math.abs(source.left + source.width() / 2 - (dest.left + dest.width() / 2));
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private final View $$robo$$android_view_FocusFinder$findNearestTouchable(ViewGroup root, int x, int y, int direction, int[] deltas) {
        ArrayList<View> touchables = root.getTouchables();
        int minDistance = Integer.MAX_VALUE;
        View closest = null;
        int numTouchables = touchables.size();
        int edgeSlop = ViewConfiguration.get(root.mContext).getScaledEdgeSlop();
        Rect closestBounds = new Rect();
        Rect touchableBounds = this.mOtherRect;
        block12: for (int i = 0; i < numTouchables; ++i) {
            View touchable = touchables.get(i);
            touchable.getDrawingRect(touchableBounds);
            root.offsetRectBetweenParentAndChild(touchable, touchableBounds, true, true);
            if (!this.isTouchCandidate(x, y, touchableBounds, direction)) continue;
            int distance = Integer.MAX_VALUE;
            switch (direction) {
                case 17: {
                    distance = x - touchableBounds.right + 1;
                    break;
                }
                case 66: {
                    distance = touchableBounds.left;
                    break;
                }
                case 33: {
                    distance = y - touchableBounds.bottom + 1;
                    break;
                }
                case 130: {
                    distance = touchableBounds.top;
                }
            }
            if (distance >= edgeSlop || closest != null && !closestBounds.contains(touchableBounds) && (touchableBounds.contains(closestBounds) || distance >= minDistance)) continue;
            minDistance = distance;
            closest = touchable;
            closestBounds.set(touchableBounds);
            switch (direction) {
                case 17: {
                    deltas[0] = -distance;
                    continue block12;
                }
                case 66: {
                    deltas[0] = distance;
                    continue block12;
                }
                case 33: {
                    deltas[1] = -distance;
                    continue block12;
                }
                case 130: {
                    deltas[1] = distance;
                }
            }
        }
        return closest;
    }

    private final boolean $$robo$$android_view_FocusFinder$isTouchCandidate(int x, int y, Rect destRect, int direction) {
        switch (direction) {
            case 17: {
                return destRect.left <= x && destRect.top <= y && y <= destRect.bottom;
            }
            case 66: {
                return destRect.left >= x && destRect.top <= y && y <= destRect.bottom;
            }
            case 33: {
                return destRect.top <= y && destRect.left <= x && x <= destRect.right;
            }
            case 130: {
                return destRect.top >= y && destRect.left <= x && x <= destRect.right;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static final boolean $$robo$$android_view_FocusFinder$isValidId(int id2) {
        return id2 != 0 && id2 != -1;
    }

    private static final void $$robo$$android_view_FocusFinder$sort(View[] views, int start, int end, ViewGroup root, boolean isRtl) {
        FocusFinder.getInstance().mFocusSorter.sort(views, start, end, root, isRtl);
    }

    private /* synthetic */ void $$robo$$android_view_FocusFinder$__constructor__(1 x0) {
    }

    static void __staticInitializer__() {
        tlFocusFinder = new ThreadLocal<FocusFinder>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_FocusFinder_1$__constructor__() {
            }

            private final FocusFinder $$robo$$android_view_FocusFinder_1$initialValue() {
                return new FocusFinder(null);
            }

            private void __constructor__() {
                this.$$robo$$android_view_FocusFinder_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_FocusFinder_1$__constructor__(), this);
            }

            @Override
            protected FocusFinder initialValue() {
                return InvokeDynamicSupport.bootstrap("initialValue", $$robo$$android_view_FocusFinder_1$initialValue(), this);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static FocusFinder getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_FocusFinder$getInstance());
    }

    private void __constructor__() {
        this.$$robo$$android_view_FocusFinder$__constructor__();
    }

    public FocusFinder() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_FocusFinder$__constructor__(), this);
    }

    public View findNextFocus(ViewGroup viewGroup, View view, int n) {
        return InvokeDynamicSupport.bootstrap("findNextFocus", $$robo$$android_view_FocusFinder$findNextFocus(android.view.ViewGroup android.view.View int ), this, viewGroup, view, n);
    }

    public View findNextFocusFromRect(ViewGroup viewGroup, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("findNextFocusFromRect", $$robo$$android_view_FocusFinder$findNextFocusFromRect(android.view.ViewGroup android.graphics.Rect int ), this, viewGroup, rect, n);
    }

    private View findNextFocus(ViewGroup viewGroup, View view, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("findNextFocus", $$robo$$android_view_FocusFinder$findNextFocus(android.view.ViewGroup android.view.View android.graphics.Rect int ), this, viewGroup, view, rect, n);
    }

    private ViewGroup getEffectiveRoot(ViewGroup viewGroup, View view) {
        return InvokeDynamicSupport.bootstrap("getEffectiveRoot", $$robo$$android_view_FocusFinder$getEffectiveRoot(android.view.ViewGroup android.view.View ), this, viewGroup, view);
    }

    public View findNextKeyboardNavigationCluster(View view, View view2, int n) {
        return InvokeDynamicSupport.bootstrap("findNextKeyboardNavigationCluster", $$robo$$android_view_FocusFinder$findNextKeyboardNavigationCluster(android.view.View android.view.View int ), this, view, view2, n);
    }

    private View findNextUserSpecifiedKeyboardNavigationCluster(View view, View view2, int n) {
        return InvokeDynamicSupport.bootstrap("findNextUserSpecifiedKeyboardNavigationCluster", $$robo$$android_view_FocusFinder$findNextUserSpecifiedKeyboardNavigationCluster(android.view.View android.view.View int ), this, view, view2, n);
    }

    private View findNextUserSpecifiedFocus(ViewGroup viewGroup, View view, int n) {
        return InvokeDynamicSupport.bootstrap("findNextUserSpecifiedFocus", $$robo$$android_view_FocusFinder$findNextUserSpecifiedFocus(android.view.ViewGroup android.view.View int ), this, viewGroup, view, n);
    }

    private View findNextFocus(ViewGroup viewGroup, View view, Rect rect, int n, ArrayList<View> arrayList) {
        return InvokeDynamicSupport.bootstrap("findNextFocus", $$robo$$android_view_FocusFinder$findNextFocus(android.view.ViewGroup android.view.View android.graphics.Rect int java.util.ArrayList<android.view.View> ), this, viewGroup, view, rect, n, arrayList);
    }

    private View findNextKeyboardNavigationCluster(View view, View view2, List<View> list, int n) {
        return InvokeDynamicSupport.bootstrap("findNextKeyboardNavigationCluster", $$robo$$android_view_FocusFinder$findNextKeyboardNavigationCluster(android.view.View android.view.View java.util.List<android.view.View> int ), this, view, view2, list, n);
    }

    private View findNextFocusInRelativeDirection(ArrayList<View> arrayList, ViewGroup viewGroup, View view, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("findNextFocusInRelativeDirection", $$robo$$android_view_FocusFinder$findNextFocusInRelativeDirection(java.util.ArrayList<android.view.View> android.view.ViewGroup android.view.View android.graphics.Rect int ), this, arrayList, viewGroup, view, rect, n);
    }

    private void setFocusBottomRight(ViewGroup viewGroup, Rect rect) {
        InvokeDynamicSupport.bootstrap("setFocusBottomRight", $$robo$$android_view_FocusFinder$setFocusBottomRight(android.view.ViewGroup android.graphics.Rect ), this, viewGroup, rect);
    }

    private void setFocusTopLeft(ViewGroup viewGroup, Rect rect) {
        InvokeDynamicSupport.bootstrap("setFocusTopLeft", $$robo$$android_view_FocusFinder$setFocusTopLeft(android.view.ViewGroup android.graphics.Rect ), this, viewGroup, rect);
    }

    View findNextFocusInAbsoluteDirection(ArrayList<View> arrayList, ViewGroup viewGroup, View view, Rect rect, int n) {
        return InvokeDynamicSupport.bootstrap("findNextFocusInAbsoluteDirection", $$robo$$android_view_FocusFinder$findNextFocusInAbsoluteDirection(java.util.ArrayList<android.view.View> android.view.ViewGroup android.view.View android.graphics.Rect int ), this, arrayList, viewGroup, view, rect, n);
    }

    private static View getNextFocusable(View view, ArrayList<View> arrayList, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNextFocusable", $$robo$$android_view_FocusFinder$getNextFocusable(android.view.View java.util.ArrayList<android.view.View> int ), (View)view, arrayList, (int)n);
    }

    private static View getPreviousFocusable(View view, ArrayList<View> arrayList, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getPreviousFocusable", $$robo$$android_view_FocusFinder$getPreviousFocusable(android.view.View java.util.ArrayList<android.view.View> int ), (View)view, arrayList, (int)n);
    }

    private static View getNextKeyboardNavigationCluster(View view, View view2, List<View> list, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNextKeyboardNavigationCluster", $$robo$$android_view_FocusFinder$getNextKeyboardNavigationCluster(android.view.View android.view.View java.util.List<android.view.View> int ), (View)view, (View)view2, list, (int)n);
    }

    private static View getPreviousKeyboardNavigationCluster(View view, View view2, List<View> list, int n) {
        return InvokeDynamicSupport.bootstrapStatic("getPreviousKeyboardNavigationCluster", $$robo$$android_view_FocusFinder$getPreviousKeyboardNavigationCluster(android.view.View android.view.View java.util.List<android.view.View> int ), (View)view, (View)view2, list, (int)n);
    }

    boolean isBetterCandidate(int n, Rect rect, Rect rect2, Rect rect3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isBetterCandidate", $$robo$$android_view_FocusFinder$isBetterCandidate(int android.graphics.Rect android.graphics.Rect android.graphics.Rect ), this, n, rect, rect2, rect3);
    }

    boolean beamBeats(int n, Rect rect, Rect rect2, Rect rect3) {
        return (boolean)InvokeDynamicSupport.bootstrap("beamBeats", $$robo$$android_view_FocusFinder$beamBeats(int android.graphics.Rect android.graphics.Rect android.graphics.Rect ), this, n, rect, rect2, rect3);
    }

    int getWeightedDistanceFor(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getWeightedDistanceFor", $$robo$$android_view_FocusFinder$getWeightedDistanceFor(int int ), this, n, n2);
    }

    boolean isCandidate(Rect rect, Rect rect2, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isCandidate", $$robo$$android_view_FocusFinder$isCandidate(android.graphics.Rect android.graphics.Rect int ), this, rect, rect2, n);
    }

    boolean beamsOverlap(int n, Rect rect, Rect rect2) {
        return (boolean)InvokeDynamicSupport.bootstrap("beamsOverlap", $$robo$$android_view_FocusFinder$beamsOverlap(int android.graphics.Rect android.graphics.Rect ), this, n, rect, rect2);
    }

    boolean isToDirectionOf(int n, Rect rect, Rect rect2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isToDirectionOf", $$robo$$android_view_FocusFinder$isToDirectionOf(int android.graphics.Rect android.graphics.Rect ), this, n, rect, rect2);
    }

    static int majorAxisDistance(int n, Rect rect, Rect rect2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("majorAxisDistance", $$robo$$android_view_FocusFinder$majorAxisDistance(int android.graphics.Rect android.graphics.Rect ), (int)n, (Rect)rect, (Rect)rect2);
    }

    static int majorAxisDistanceRaw(int n, Rect rect, Rect rect2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("majorAxisDistanceRaw", $$robo$$android_view_FocusFinder$majorAxisDistanceRaw(int android.graphics.Rect android.graphics.Rect ), (int)n, (Rect)rect, (Rect)rect2);
    }

    static int majorAxisDistanceToFarEdge(int n, Rect rect, Rect rect2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("majorAxisDistanceToFarEdge", $$robo$$android_view_FocusFinder$majorAxisDistanceToFarEdge(int android.graphics.Rect android.graphics.Rect ), (int)n, (Rect)rect, (Rect)rect2);
    }

    static int majorAxisDistanceToFarEdgeRaw(int n, Rect rect, Rect rect2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("majorAxisDistanceToFarEdgeRaw", $$robo$$android_view_FocusFinder$majorAxisDistanceToFarEdgeRaw(int android.graphics.Rect android.graphics.Rect ), (int)n, (Rect)rect, (Rect)rect2);
    }

    static int minorAxisDistance(int n, Rect rect, Rect rect2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("minorAxisDistance", $$robo$$android_view_FocusFinder$minorAxisDistance(int android.graphics.Rect android.graphics.Rect ), (int)n, (Rect)rect, (Rect)rect2);
    }

    public View findNearestTouchable(ViewGroup viewGroup, int n, int n2, int n3, int[] nArray) {
        return InvokeDynamicSupport.bootstrap("findNearestTouchable", $$robo$$android_view_FocusFinder$findNearestTouchable(android.view.ViewGroup int int int int[] ), this, viewGroup, n, n2, n3, nArray);
    }

    private boolean isTouchCandidate(int n, int n2, Rect rect, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTouchCandidate", $$robo$$android_view_FocusFinder$isTouchCandidate(int int android.graphics.Rect int ), this, n, n2, rect, n3);
    }

    private static boolean isValidId(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isValidId", $$robo$$android_view_FocusFinder$isValidId(int ), (int)n);
    }

    public static void sort(View[] viewArray, int n, int n2, ViewGroup viewGroup, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("sort", $$robo$$android_view_FocusFinder$sort(android.view.View[] int int android.view.ViewGroup boolean ), (View[])viewArray, (int)n, (int)n2, (ViewGroup)viewGroup, (boolean)bl);
    }

    private /* synthetic */ void __constructor__(1 var1_1) {
        this.$$robo$$android_view_FocusFinder$__constructor__(var1_1);
    }

    public /* synthetic */ FocusFinder(1 var1_1) {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_FocusFinder$__constructor__(android.view.FocusFinder$1 ), this, var1_1);
    }

    static {
        RobolectricInternals.classInitializing(FocusFinder.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FocusFinder)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class UserSpecifiedFocusComparator
    implements Comparator<View> {
        public /* synthetic */ Object __robo_data__;
        private ArrayMap<View, View> mNextFoci;
        private ArraySet<View> mIsConnectedTo;
        private ArrayMap<View, View> mHeadsOfChains;
        private ArrayMap<View, Integer> mOriginalOrdinal;
        private NextFocusGetter mNextFocusGetter;
        private View mRoot;

        private void $$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$__constructor__(NextFocusGetter nextFocusGetter) {
            this.mNextFoci = new ArrayMap();
            this.mIsConnectedTo = new ArraySet();
            this.mHeadsOfChains = new ArrayMap();
            this.mOriginalOrdinal = new ArrayMap();
            this.mNextFocusGetter = nextFocusGetter;
        }

        private final void $$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$recycle() {
            this.mRoot = null;
            this.mHeadsOfChains.clear();
            this.mIsConnectedTo.clear();
            this.mOriginalOrdinal.clear();
            this.mNextFoci.clear();
        }

        private final void $$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$setFocusables(List<View> focusables, View root) {
            View next;
            View view;
            int i;
            this.mRoot = root;
            for (i = 0; i < focusables.size(); ++i) {
                this.mOriginalOrdinal.put(focusables.get(i), i);
            }
            for (i = focusables.size() - 1; i >= 0; --i) {
                view = focusables.get(i);
                next = this.mNextFocusGetter.get(this.mRoot, view);
                if (next == null || !this.mOriginalOrdinal.containsKey(next)) continue;
                this.mNextFoci.put(view, next);
                this.mIsConnectedTo.add(next);
            }
            for (i = focusables.size() - 1; i >= 0; --i) {
                view = focusables.get(i);
                next = this.mNextFoci.get(view);
                if (next == null || this.mIsConnectedTo.contains(view)) continue;
                this.setHeadOfChain(view);
            }
        }

        private final void $$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$setHeadOfChain(View head) {
            View view = head;
            while (view != null) {
                View otherHead = this.mHeadsOfChains.get(view);
                if (otherHead != null) {
                    if (otherHead == head) {
                        return;
                    }
                    view = head;
                    head = otherHead;
                }
                this.mHeadsOfChains.put(view, head);
                view = this.mNextFoci.get(view);
            }
        }

        private final int $$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$compare(View first, View second) {
            View secondHead;
            if (first == second) {
                return 0;
            }
            View firstHead = this.mHeadsOfChains.get(first);
            if (firstHead == (secondHead = this.mHeadsOfChains.get(second)) && firstHead != null) {
                if (first == firstHead) {
                    return -1;
                }
                if (second == firstHead) {
                    return 1;
                }
                if (this.mNextFoci.get(first) != null) {
                    return -1;
                }
                return 1;
            }
            boolean involvesChain = false;
            if (firstHead != null) {
                first = firstHead;
                involvesChain = true;
            }
            if (secondHead != null) {
                second = secondHead;
                involvesChain = true;
            }
            if (involvesChain) {
                return this.mOriginalOrdinal.get(first) < this.mOriginalOrdinal.get(second) ? -1 : 1;
            }
            return 0;
        }

        private void __constructor__(NextFocusGetter nextFocusGetter) {
            this.$$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$__constructor__(nextFocusGetter);
        }

        public UserSpecifiedFocusComparator(NextFocusGetter nextFocusGetter) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$__constructor__(android.view.FocusFinder$UserSpecifiedFocusComparator$NextFocusGetter ), this, nextFocusGetter);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$recycle(), this);
        }

        public void setFocusables(List<View> list, View view) {
            InvokeDynamicSupport.bootstrap("setFocusables", $$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$setFocusables(java.util.List<android.view.View> android.view.View ), this, list, view);
        }

        private void setHeadOfChain(View view) {
            InvokeDynamicSupport.bootstrap("setHeadOfChain", $$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$setHeadOfChain(android.view.View ), this, view);
        }

        @Override
        public int compare(View view, View view2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_view_FocusFinder_UserSpecifiedFocusComparator$compare(android.view.View android.view.View ), this, view, view2);
        }

        public /* synthetic */ UserSpecifiedFocusComparator() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UserSpecifiedFocusComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static interface NextFocusGetter
        extends InstrumentedInterface {
            public View get(View var1, View var2);
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class FocusSorter
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ArrayList<Rect> mRectPool;
        private int mLastPoolRect;
        private int mRtlMult;
        private HashMap<View, Rect> mRectByView;
        private Comparator<View> mTopsComparator;
        private Comparator<View> mSidesComparator;

        private void $$robo$$android_view_FocusFinder_FocusSorter$__constructor__() {
            this.mRectPool = new ArrayList();
            this.mRectByView = null;
            this.mTopsComparator = (first, second) -> {
                if (first == second) {
                    return 0;
                }
                Rect firstRect = this.mRectByView.get(first);
                Rect secondRect = this.mRectByView.get(second);
                int result = firstRect.top - secondRect.top;
                if (result == 0) {
                    return firstRect.bottom - secondRect.bottom;
                }
                return result;
            };
            this.mSidesComparator = (first, second) -> {
                if (first == second) {
                    return 0;
                }
                Rect firstRect = this.mRectByView.get(first);
                Rect secondRect = this.mRectByView.get(second);
                int result = firstRect.left - secondRect.left;
                if (result == 0) {
                    return firstRect.right - secondRect.right;
                }
                return this.mRtlMult * result;
            };
        }

        private final void $$robo$$android_view_FocusFinder_FocusSorter$sort(View[] views, int start, int end, ViewGroup root, boolean isRtl) {
            int sweepIdx;
            int i;
            int count = end - start;
            if (count < 2) {
                return;
            }
            if (this.mRectByView == null) {
                this.mRectByView = new HashMap();
            }
            this.mRtlMult = isRtl ? -1 : 1;
            for (i = this.mRectPool.size(); i < count; ++i) {
                this.mRectPool.add(new Rect());
            }
            for (i = start; i < end; ++i) {
                Rect next = this.mRectPool.get(this.mLastPoolRect++);
                views[i].getDrawingRect(next);
                root.offsetDescendantRectToMyCoords(views[i], next);
                this.mRectByView.put(views[i], next);
            }
            Arrays.sort(views, start, count, this.mTopsComparator);
            int sweepBottom = this.mRectByView.get((Object)views[start]).bottom;
            int rowStart = start;
            for (sweepIdx = start + 1; sweepIdx < end; ++sweepIdx) {
                Rect currRect = this.mRectByView.get(views[sweepIdx]);
                if (currRect.top >= sweepBottom) {
                    if (sweepIdx - rowStart > 1) {
                        Arrays.sort(views, rowStart, sweepIdx, this.mSidesComparator);
                    }
                    sweepBottom = currRect.bottom;
                    rowStart = sweepIdx;
                    continue;
                }
                sweepBottom = Math.max(sweepBottom, currRect.bottom);
            }
            if (sweepIdx - rowStart > 1) {
                Arrays.sort(views, rowStart, sweepIdx, this.mSidesComparator);
            }
            this.mLastPoolRect = 0;
            this.mRectByView.clear();
        }

        private void __constructor__() {
            this.$$robo$$android_view_FocusFinder_FocusSorter$__constructor__();
        }

        public FocusSorter() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_FocusFinder_FocusSorter$__constructor__(), this);
        }

        public void sort(View[] viewArray, int n, int n2, ViewGroup viewGroup, boolean bl) {
            InvokeDynamicSupport.bootstrap("sort", $$robo$$android_view_FocusFinder_FocusSorter$sort(android.view.View[] int int android.view.ViewGroup boolean ), this, viewArray, n, n2, viewGroup, bl);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FocusSorter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

