/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.view.View;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RoundScrollbarRenderer
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int SCROLLBAR_ANGLE_RANGE = 90;
    private static int MAX_SCROLLBAR_ANGLE_SWIPE = 16;
    private static int MIN_SCROLLBAR_ANGLE_SWIPE = 6;
    private static float WIDTH_PERCENTAGE = 0.02f;
    private static int DEFAULT_THUMB_COLOR = 0x4CFFFFFF;
    private static int DEFAULT_TRACK_COLOR = 0x26FFFFFF;
    private Paint mThumbPaint;
    private Paint mTrackPaint;
    private RectF mRect;
    private View mParent;

    private void $$robo$$android_view_RoundScrollbarRenderer$__constructor__(View parent) {
        this.mThumbPaint = new Paint();
        this.mTrackPaint = new Paint();
        this.mRect = new RectF();
        this.mThumbPaint.setAntiAlias(true);
        this.mThumbPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mThumbPaint.setStyle(Paint.Style.STROKE);
        this.mTrackPaint.setAntiAlias(true);
        this.mTrackPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mTrackPaint.setStyle(Paint.Style.STROKE);
        this.mParent = parent;
    }

    private final void $$robo$$android_view_RoundScrollbarRenderer$drawRoundScrollbars(Canvas canvas, float alpha, Rect bounds) {
        if (alpha == 0.0f) {
            return;
        }
        float maxScroll = this.mParent.computeVerticalScrollRange();
        float scrollExtent = this.mParent.computeVerticalScrollExtent();
        if (scrollExtent <= 0.0f || maxScroll <= scrollExtent) {
            return;
        }
        float currentScroll = Math.max(0, this.mParent.computeVerticalScrollOffset());
        float linearThumbLength = this.mParent.computeVerticalScrollExtent();
        float thumbWidth = (float)this.mParent.getWidth() * 0.02f;
        this.mThumbPaint.setStrokeWidth(thumbWidth);
        this.mTrackPaint.setStrokeWidth(thumbWidth);
        this.setThumbColor(RoundScrollbarRenderer.applyAlpha(0x4CFFFFFF, alpha));
        this.setTrackColor(RoundScrollbarRenderer.applyAlpha(0x26FFFFFF, alpha));
        float sweepAngle = linearThumbLength / maxScroll * 90.0f;
        sweepAngle = RoundScrollbarRenderer.clamp(sweepAngle, 6.0f, 16.0f);
        float startAngle = currentScroll * (90.0f - sweepAngle) / (maxScroll - linearThumbLength) - 45.0f;
        startAngle = RoundScrollbarRenderer.clamp(startAngle, -45.0f, 45.0f - sweepAngle);
        this.mRect.set((float)bounds.left - thumbWidth / 2.0f, bounds.top, (float)bounds.right - thumbWidth / 2.0f, bounds.bottom);
        canvas.drawArc(this.mRect, -45.0f, 90.0f, false, this.mTrackPaint);
        canvas.drawArc(this.mRect, startAngle, sweepAngle, false, this.mThumbPaint);
    }

    private static final float $$robo$$android_view_RoundScrollbarRenderer$clamp(float val, float min, float max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    private static final int $$robo$$android_view_RoundScrollbarRenderer$applyAlpha(int color2, float alpha) {
        int alphaByte = (int)((float)Color.alpha(color2) * alpha);
        return Color.argb(alphaByte, Color.red(color2), Color.green(color2), Color.blue(color2));
    }

    private final void $$robo$$android_view_RoundScrollbarRenderer$setThumbColor(int thumbColor) {
        if (this.mThumbPaint.getColor() != thumbColor) {
            this.mThumbPaint.setColor(thumbColor);
        }
    }

    private final void $$robo$$android_view_RoundScrollbarRenderer$setTrackColor(int trackColor) {
        if (this.mTrackPaint.getColor() != trackColor) {
            this.mTrackPaint.setColor(trackColor);
        }
    }

    private void __constructor__(View view) {
        this.$$robo$$android_view_RoundScrollbarRenderer$__constructor__(view);
    }

    public RoundScrollbarRenderer(View view) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_RoundScrollbarRenderer$__constructor__(android.view.View ), this, view);
    }

    public void drawRoundScrollbars(Canvas canvas, float f, Rect rect) {
        InvokeDynamicSupport.bootstrap("drawRoundScrollbars", $$robo$$android_view_RoundScrollbarRenderer$drawRoundScrollbars(android.graphics.Canvas float android.graphics.Rect ), this, canvas, f, rect);
    }

    private static float clamp(float f, float f2, float f3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("clamp", $$robo$$android_view_RoundScrollbarRenderer$clamp(float float float ), (float)f, (float)f2, (float)f3);
    }

    private static int applyAlpha(int n, float f) {
        return (int)InvokeDynamicSupport.bootstrapStatic("applyAlpha", $$robo$$android_view_RoundScrollbarRenderer$applyAlpha(int float ), (int)n, (float)f);
    }

    private void setThumbColor(int n) {
        InvokeDynamicSupport.bootstrap("setThumbColor", $$robo$$android_view_RoundScrollbarRenderer$setThumbColor(int ), this, n);
    }

    private void setTrackColor(int n) {
        InvokeDynamicSupport.bootstrap("setTrackColor", $$robo$$android_view_RoundScrollbarRenderer$setTrackColor(int ), this, n);
    }

    public /* synthetic */ RoundScrollbarRenderer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RoundScrollbarRenderer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

