/*
 * Decompiled with CFR 0.152.
 */
package android.view.autofill;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AutofillValue
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int mType;
    private Object mValue;
    public static Parcelable.Creator<AutofillValue> CREATOR;

    private void $$robo$$android_view_autofill_AutofillValue$__constructor__(int type, Object value) {
        this.mType = type;
        this.mValue = value;
    }

    private final CharSequence $$robo$$android_view_autofill_AutofillValue$getTextValue() {
        Preconditions.checkState(this.isText(), "value must be a text value, not type=" + this.mType);
        return (CharSequence)this.mValue;
    }

    private final boolean $$robo$$android_view_autofill_AutofillValue$isText() {
        return this.mType == 1;
    }

    private final boolean $$robo$$android_view_autofill_AutofillValue$getToggleValue() {
        Preconditions.checkState(this.isToggle(), "value must be a toggle value, not type=" + this.mType);
        return (Boolean)this.mValue;
    }

    private final boolean $$robo$$android_view_autofill_AutofillValue$isToggle() {
        return this.mType == 2;
    }

    private final int $$robo$$android_view_autofill_AutofillValue$getListValue() {
        Preconditions.checkState(this.isList(), "value must be a list value, not type=" + this.mType);
        return (Integer)this.mValue;
    }

    private final boolean $$robo$$android_view_autofill_AutofillValue$isList() {
        return this.mType == 3;
    }

    private final long $$robo$$android_view_autofill_AutofillValue$getDateValue() {
        Preconditions.checkState(this.isDate(), "value must be a date value, not type=" + this.mType);
        return (Long)this.mValue;
    }

    private final boolean $$robo$$android_view_autofill_AutofillValue$isDate() {
        return this.mType == 4;
    }

    private final boolean $$robo$$android_view_autofill_AutofillValue$isEmpty() {
        return this.isText() && ((CharSequence)this.mValue).length() == 0;
    }

    private final int $$robo$$android_view_autofill_AutofillValue$hashCode() {
        return this.mType + this.mValue.hashCode();
    }

    private final boolean $$robo$$android_view_autofill_AutofillValue$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AutofillValue other = (AutofillValue)obj;
        if (this.mType != other.mType) {
            return false;
        }
        if (this.isText()) {
            return this.mValue.toString().equals(other.mValue.toString());
        }
        return Objects.equals(this.mValue, other.mValue);
    }

    private final String $$robo$$android_view_autofill_AutofillValue$toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        StringBuilder string2 = new StringBuilder().append("[type=").append(this.mType).append(", value=");
        if (this.isText()) {
            string2.append(((CharSequence)this.mValue).length()).append("_chars");
        } else {
            string2.append(this.mValue);
        }
        return string2.append(']').toString();
    }

    private final int $$robo$$android_view_autofill_AutofillValue$describeContents() {
        return 0;
    }

    private final void $$robo$$android_view_autofill_AutofillValue$writeToParcel(Parcel parcel, int flags) {
        parcel.writeInt(this.mType);
        switch (this.mType) {
            case 1: {
                parcel.writeCharSequence((CharSequence)this.mValue);
                break;
            }
            case 2: {
                parcel.writeInt((Boolean)this.mValue != false ? 1 : 0);
                break;
            }
            case 3: {
                parcel.writeInt((Integer)this.mValue);
                break;
            }
            case 4: {
                parcel.writeLong((Long)this.mValue);
            }
        }
    }

    private void $$robo$$android_view_autofill_AutofillValue$__constructor__(Parcel parcel) {
        this.mType = parcel.readInt();
        switch (this.mType) {
            case 1: {
                this.mValue = parcel.readCharSequence();
                break;
            }
            case 2: {
                int rawValue = parcel.readInt();
                this.mValue = rawValue != 0;
                break;
            }
            case 3: {
                this.mValue = parcel.readInt();
                break;
            }
            case 4: {
                this.mValue = parcel.readLong();
                break;
            }
            default: {
                throw new IllegalArgumentException("type=" + this.mType + " not valid");
            }
        }
    }

    private static final AutofillValue $$robo$$android_view_autofill_AutofillValue$forText(CharSequence value) {
        return value == null ? null : new AutofillValue(1, TextUtils.trimNoCopySpans(value));
    }

    private static final AutofillValue $$robo$$android_view_autofill_AutofillValue$forToggle(boolean value) {
        return new AutofillValue(2, value);
    }

    private static final AutofillValue $$robo$$android_view_autofill_AutofillValue$forList(int value) {
        return new AutofillValue(3, value);
    }

    private static final AutofillValue $$robo$$android_view_autofill_AutofillValue$forDate(long value) {
        return new AutofillValue(4, value);
    }

    private /* synthetic */ void $$robo$$android_view_autofill_AutofillValue$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<AutofillValue>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_autofill_AutofillValue_1$__constructor__() {
            }

            private final AutofillValue $$robo$$android_view_autofill_AutofillValue_1$createFromParcel(Parcel source) {
                return new AutofillValue(source, null);
            }

            private final AutofillValue[] $$robo$$android_view_autofill_AutofillValue_1$newArray(int size) {
                return new AutofillValue[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_autofill_AutofillValue_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillValue_1$__constructor__(), this);
            }

            @Override
            public AutofillValue createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_autofill_AutofillValue_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public AutofillValue[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_autofill_AutofillValue_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(int n, Object object) {
        this.$$robo$$android_view_autofill_AutofillValue$__constructor__(n, object);
    }

    public AutofillValue(int n, Object object) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillValue$__constructor__(int java.lang.Object ), this, n, object);
    }

    public CharSequence getTextValue() {
        return InvokeDynamicSupport.bootstrap("getTextValue", $$robo$$android_view_autofill_AutofillValue$getTextValue(), this);
    }

    public boolean isText() {
        return (boolean)InvokeDynamicSupport.bootstrap("isText", $$robo$$android_view_autofill_AutofillValue$isText(), this);
    }

    public boolean getToggleValue() {
        return (boolean)InvokeDynamicSupport.bootstrap("getToggleValue", $$robo$$android_view_autofill_AutofillValue$getToggleValue(), this);
    }

    public boolean isToggle() {
        return (boolean)InvokeDynamicSupport.bootstrap("isToggle", $$robo$$android_view_autofill_AutofillValue$isToggle(), this);
    }

    public int getListValue() {
        return (int)InvokeDynamicSupport.bootstrap("getListValue", $$robo$$android_view_autofill_AutofillValue$getListValue(), this);
    }

    public boolean isList() {
        return (boolean)InvokeDynamicSupport.bootstrap("isList", $$robo$$android_view_autofill_AutofillValue$isList(), this);
    }

    public long getDateValue() {
        return (long)InvokeDynamicSupport.bootstrap("getDateValue", $$robo$$android_view_autofill_AutofillValue$getDateValue(), this);
    }

    public boolean isDate() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDate", $$robo$$android_view_autofill_AutofillValue$isDate(), this);
    }

    public boolean isEmpty() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_view_autofill_AutofillValue$isEmpty(), this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_autofill_AutofillValue$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_autofill_AutofillValue$equals(java.lang.Object ), this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_autofill_AutofillValue$toString(), this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_autofill_AutofillValue$describeContents(), this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_autofill_AutofillValue$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_autofill_AutofillValue$__constructor__(parcel);
    }

    public AutofillValue(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillValue$__constructor__(android.os.Parcel ), this, parcel);
    }

    public static AutofillValue forText(CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrapStatic("forText", $$robo$$android_view_autofill_AutofillValue$forText(java.lang.CharSequence ), (CharSequence)charSequence);
    }

    public static AutofillValue forToggle(boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("forToggle", $$robo$$android_view_autofill_AutofillValue$forToggle(boolean ), (boolean)bl);
    }

    public static AutofillValue forList(int n) {
        return InvokeDynamicSupport.bootstrapStatic("forList", $$robo$$android_view_autofill_AutofillValue$forList(int ), (int)n);
    }

    public static AutofillValue forDate(long l) {
        return InvokeDynamicSupport.bootstrapStatic("forDate", $$robo$$android_view_autofill_AutofillValue$forDate(long ), (long)l);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_view_autofill_AutofillValue$__constructor__(parcel, var2_2);
    }

    public /* synthetic */ AutofillValue(Parcel parcel, 1 var2_2) {
        this(parcel);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_autofill_AutofillValue$__constructor__(android.os.Parcel android.view.autofill.AutofillValue$1 ), this, parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(AutofillValue.class);
    }

    public /* synthetic */ AutofillValue() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AutofillValue)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

