/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class SparseRectFArray
implements Parcelable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private int[] mKeys;
    private float[] mCoordinates;
    private int[] mFlagsArray;
    public static Parcelable.Creator<SparseRectFArray> CREATOR;

    private void $$robo$$android_view_inputmethod_SparseRectFArray$__constructor__(Parcel source) {
        this.mKeys = source.createIntArray();
        this.mCoordinates = source.createFloatArray();
        this.mFlagsArray = source.createIntArray();
    }

    private final void $$robo$$android_view_inputmethod_SparseRectFArray$writeToParcel(Parcel dest, int flags) {
        dest.writeIntArray(this.mKeys);
        dest.writeFloatArray(this.mCoordinates);
        dest.writeIntArray(this.mFlagsArray);
    }

    private final int $$robo$$android_view_inputmethod_SparseRectFArray$hashCode() {
        if (this.mKeys == null || this.mKeys.length == 0) {
            return 0;
        }
        int hash = this.mKeys.length;
        for (int i = 0; i < 4; ++i) {
            hash *= 31;
            hash = (int)((float)hash + this.mCoordinates[i]);
        }
        hash *= 31;
        return hash += this.mFlagsArray[0];
    }

    private final boolean $$robo$$android_view_inputmethod_SparseRectFArray$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SparseRectFArray)) {
            return false;
        }
        SparseRectFArray that = (SparseRectFArray)obj;
        return Arrays.equals(this.mKeys, that.mKeys) && Arrays.equals(this.mCoordinates, that.mCoordinates) && Arrays.equals(this.mFlagsArray, that.mFlagsArray);
    }

    private final String $$robo$$android_view_inputmethod_SparseRectFArray$toString() {
        if (this.mKeys == null || this.mCoordinates == null || this.mFlagsArray == null) {
            return "SparseRectFArray{}";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("SparseRectFArray{");
        for (int i = 0; i < this.mKeys.length; ++i) {
            if (i != 0) {
                sb.append(", ");
            }
            int baseIndex = i * 4;
            sb.append(this.mKeys[i]);
            sb.append(":[");
            sb.append(this.mCoordinates[baseIndex + 0]);
            sb.append(",");
            sb.append(this.mCoordinates[baseIndex + 1]);
            sb.append("],[");
            sb.append(this.mCoordinates[baseIndex + 2]);
            sb.append(",");
            sb.append(this.mCoordinates[baseIndex + 3]);
            sb.append("]:flagsArray=");
            sb.append(this.mFlagsArray[i]);
        }
        sb.append("}");
        return sb.toString();
    }

    private void $$robo$$android_view_inputmethod_SparseRectFArray$__constructor__(SparseRectFArrayBuilder builder) {
        if (builder.mCount == 0) {
            this.mKeys = null;
            this.mCoordinates = null;
            this.mFlagsArray = null;
        } else {
            this.mKeys = new int[builder.mCount];
            this.mCoordinates = new float[builder.mCount * 4];
            this.mFlagsArray = new int[builder.mCount];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])builder.mKeys, (int)0, (int[])this.mKeys, (int)0, (int)builder.mCount);
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])builder.mCoordinates, (int)0, (float[])this.mCoordinates, (int)0, (int)(builder.mCount * 4));
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])builder.mFlagsArray, (int)0, (int[])this.mFlagsArray, (int)0, (int)builder.mCount);
        }
    }

    private final RectF $$robo$$android_view_inputmethod_SparseRectFArray$get(int index) {
        if (this.mKeys == null) {
            return null;
        }
        if (index < 0) {
            return null;
        }
        int arrayIndex = Arrays.binarySearch(this.mKeys, index);
        if (arrayIndex < 0) {
            return null;
        }
        int baseCoordIndex = arrayIndex * 4;
        return new RectF(this.mCoordinates[baseCoordIndex], this.mCoordinates[baseCoordIndex + 1], this.mCoordinates[baseCoordIndex + 2], this.mCoordinates[baseCoordIndex + 3]);
    }

    private final int $$robo$$android_view_inputmethod_SparseRectFArray$getFlags(int index, int valueIfKeyNotFound) {
        if (this.mKeys == null) {
            return valueIfKeyNotFound;
        }
        if (index < 0) {
            return valueIfKeyNotFound;
        }
        int arrayIndex = Arrays.binarySearch(this.mKeys, index);
        if (arrayIndex < 0) {
            return valueIfKeyNotFound;
        }
        return this.mFlagsArray[arrayIndex];
    }

    private final int $$robo$$android_view_inputmethod_SparseRectFArray$describeContents() {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_view_inputmethod_SparseRectFArray$__constructor__(SparseRectFArrayBuilder x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<SparseRectFArray>(){
            public /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_inputmethod_SparseRectFArray_1$__constructor__() {
            }

            private final SparseRectFArray $$robo$$android_view_inputmethod_SparseRectFArray_1$createFromParcel(Parcel source) {
                return new SparseRectFArray(source);
            }

            private final SparseRectFArray[] $$robo$$android_view_inputmethod_SparseRectFArray_1$newArray(int size) {
                return new SparseRectFArray[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_inputmethod_SparseRectFArray_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_SparseRectFArray_1$__constructor__(), this);
            }

            @Override
            public SparseRectFArray createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_inputmethod_SparseRectFArray_1$createFromParcel(android.os.Parcel ), this, parcel);
            }

            public SparseRectFArray[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_inputmethod_SparseRectFArray_1$newArray(int ), this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_inputmethod_SparseRectFArray$__constructor__(parcel);
    }

    public SparseRectFArray(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_SparseRectFArray$__constructor__(android.os.Parcel ), this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_inputmethod_SparseRectFArray$writeToParcel(android.os.Parcel int ), this, parcel, n);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_inputmethod_SparseRectFArray$hashCode(), this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_inputmethod_SparseRectFArray$equals(java.lang.Object ), this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_inputmethod_SparseRectFArray$toString(), this);
    }

    private void __constructor__(SparseRectFArrayBuilder sparseRectFArrayBuilder) {
        this.$$robo$$android_view_inputmethod_SparseRectFArray$__constructor__(sparseRectFArrayBuilder);
    }

    public SparseRectFArray(SparseRectFArrayBuilder sparseRectFArrayBuilder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_SparseRectFArray$__constructor__(android.view.inputmethod.SparseRectFArray$SparseRectFArrayBuilder ), this, sparseRectFArrayBuilder);
    }

    public RectF get(int n) {
        return InvokeDynamicSupport.bootstrap("get", $$robo$$android_view_inputmethod_SparseRectFArray$get(int ), this, n);
    }

    public int getFlags(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getFlags", $$robo$$android_view_inputmethod_SparseRectFArray$getFlags(int int ), this, n, n2);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_inputmethod_SparseRectFArray$describeContents(), this);
    }

    private /* synthetic */ void __constructor__(SparseRectFArrayBuilder sparseRectFArrayBuilder, 1 var2_2) {
        this.$$robo$$android_view_inputmethod_SparseRectFArray$__constructor__(sparseRectFArrayBuilder, var2_2);
    }

    public /* synthetic */ SparseRectFArray(SparseRectFArrayBuilder sparseRectFArrayBuilder, 1 var2_2) {
        this(sparseRectFArrayBuilder);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_SparseRectFArray$__constructor__(android.view.inputmethod.SparseRectFArray$SparseRectFArrayBuilder android.view.inputmethod.SparseRectFArray$1 ), this, sparseRectFArrayBuilder, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(SparseRectFArray.class);
    }

    public /* synthetic */ SparseRectFArray() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SparseRectFArray)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class SparseRectFArrayBuilder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mCount;
        private int[] mKeys;
        private float[] mCoordinates;
        private int[] mFlagsArray;
        private static int INITIAL_SIZE;

        private void $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$__constructor__() {
            this.mCount = 0;
            this.mKeys = null;
            this.mCoordinates = null;
            this.mFlagsArray = null;
        }

        private final void $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$checkIndex(int key) {
            if (this.mCount == 0) {
                return;
            }
            if (this.mKeys[this.mCount - 1] >= key) {
                throw new IllegalArgumentException("key must be greater than all existing keys.");
            }
        }

        private final void $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$ensureBufferSize() {
            int requiredFlagsArraySize;
            int requiredCoordinatesArraySize;
            int requiredIndexArraySize;
            if (this.mKeys == null) {
                this.mKeys = new int[INITIAL_SIZE];
            }
            if (this.mCoordinates == null) {
                this.mCoordinates = new float[INITIAL_SIZE * 4];
            }
            if (this.mFlagsArray == null) {
                this.mFlagsArray = new int[INITIAL_SIZE];
            }
            if (this.mKeys.length <= (requiredIndexArraySize = this.mCount + 1)) {
                int[] newArray = new int[requiredIndexArraySize * 2];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mKeys, (int)0, (int[])newArray, (int)0, (int)this.mCount);
                this.mKeys = newArray;
            }
            if (this.mCoordinates.length <= (requiredCoordinatesArraySize = (this.mCount + 1) * 4)) {
                float[] newArray = new float[requiredCoordinatesArraySize * 2];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])this.mCoordinates, (int)0, (float[])newArray, (int)0, (int)(this.mCount * 4));
                this.mCoordinates = newArray;
            }
            if (this.mFlagsArray.length <= (requiredFlagsArraySize = requiredIndexArraySize)) {
                int[] newArray = new int[requiredFlagsArraySize * 2];
                InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (int[])this.mFlagsArray, (int)0, (int[])newArray, (int)0, (int)this.mCount);
                this.mFlagsArray = newArray;
            }
        }

        private final SparseRectFArrayBuilder $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$append(int key, float left, float top, float right, float bottom, int flags) {
            this.checkIndex(key);
            this.ensureBufferSize();
            int baseCoordinatesIndex = this.mCount * 4;
            this.mCoordinates[baseCoordinatesIndex + 0] = left;
            this.mCoordinates[baseCoordinatesIndex + 1] = top;
            this.mCoordinates[baseCoordinatesIndex + 2] = right;
            this.mCoordinates[baseCoordinatesIndex + 3] = bottom;
            int flagsIndex = this.mCount;
            this.mFlagsArray[flagsIndex] = flags;
            this.mKeys[this.mCount] = key;
            ++this.mCount;
            return this;
        }

        private final boolean $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$isEmpty() {
            return this.mCount <= 0;
        }

        private final SparseRectFArray $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$build() {
            return new SparseRectFArray(this, null);
        }

        private final void $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$reset() {
            if (this.mCount == 0) {
                this.mKeys = null;
                this.mCoordinates = null;
                this.mFlagsArray = null;
            }
            this.mCount = 0;
        }

        static void __staticInitializer__() {
            INITIAL_SIZE = 16;
        }

        private void __constructor__() {
            this.$$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$__constructor__();
        }

        public SparseRectFArrayBuilder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$__constructor__(), this);
        }

        private void checkIndex(int n) {
            InvokeDynamicSupport.bootstrap("checkIndex", $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$checkIndex(int ), this, n);
        }

        private void ensureBufferSize() {
            InvokeDynamicSupport.bootstrap("ensureBufferSize", $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$ensureBufferSize(), this);
        }

        public SparseRectFArrayBuilder append(int n, float f, float f2, float f3, float f4, int n2) {
            return InvokeDynamicSupport.bootstrap("append", $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$append(int float float float float int ), this, n, f, f2, f3, f4, n2);
        }

        public boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$isEmpty(), this);
        }

        public SparseRectFArray build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$build(), this);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_view_inputmethod_SparseRectFArray_SparseRectFArrayBuilder$reset(), this);
        }

        static {
            RobolectricInternals.classInitializing(SparseRectFArrayBuilder.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SparseRectFArrayBuilder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

