/*
 * Decompiled with CFR 0.152.
 */
package android.view.textclassifier;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.LocaleList;
import android.os.ParcelFileDescriptor;
import android.text.Spannable;
import android.text.TextUtils;
import android.text.method.WordIterator;
import android.text.style.ClickableSpan;
import android.text.util.Linkify;
import android.util.Log;
import android.util.Patterns;
import android.view.View;
import android.view.textclassifier.LinksInfo;
import android.view.textclassifier.SmartSelection;
import android.view.textclassifier.TextClassification;
import android.view.textclassifier.TextClassifier;
import android.view.textclassifier.TextSelection;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.logging.MetricsLogger;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class TextClassifierImpl
implements TextClassifier,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "TextClassifierImpl";
    private static String MODEL_DIR = "/etc/textclassifier/";
    private static String MODEL_FILE_REGEX = "textclassifier\\.smartselection\\.(.*)\\.model";
    private static String UPDATED_MODEL_FILE_PATH = "/data/misc/textclassifier/textclassifier.smartselection.model";
    private Context mContext;
    private MetricsLogger mMetricsLogger;
    private Object mSmartSelectionLock;
    @GuardedBy(value="mSmartSelectionLock")
    private Map<Locale, String> mModelFilePaths;
    @GuardedBy(value="mSmartSelectionLock")
    private Locale mLocale;
    @GuardedBy(value="mSmartSelectionLock")
    private SmartSelection mSmartSelection;

    private void $$robo$$android_view_textclassifier_TextClassifierImpl$__constructor__(Context context) {
        this.mMetricsLogger = new MetricsLogger();
        this.mSmartSelectionLock = new Object();
        this.mContext = Preconditions.checkNotNull(context);
    }

    private final TextSelection $$robo$$android_view_textclassifier_TextClassifierImpl$suggestSelection(CharSequence text, int selectionStartIndex, int selectionEndIndex, LocaleList defaultLocales) {
        TextClassifierImpl.validateInput(text, selectionStartIndex, selectionEndIndex);
        try {
            if (text.length() > 0) {
                int end;
                String string2;
                SmartSelection smartSelection = this.getSmartSelection(defaultLocales);
                int[] startEnd = smartSelection.suggest(string2 = text.toString(), selectionStartIndex, selectionEndIndex);
                int start = startEnd[0];
                if (start <= (end = startEnd[1]) && start >= 0 && end <= string2.length() && start <= selectionStartIndex && end >= selectionEndIndex) {
                    TextSelection.Builder tsBuilder = new TextSelection.Builder(start, end).setLogSource("TextClassifierImpl");
                    SmartSelection.ClassificationResult[] results = smartSelection.classifyText(string2, start, end, TextClassifierImpl.getHintFlags(string2, start, end));
                    int size = results.length;
                    for (int i = 0; i < size; ++i) {
                        tsBuilder.setEntityType(results[i].mCollection, results[i].mScore);
                    }
                    return tsBuilder.build();
                }
                Log.d("TextClassifierImpl", "Got bad indices for input text. Ignoring result.");
            }
        }
        catch (Throwable t) {
            Log.e("TextClassifierImpl", "Error suggesting selection for text. No changes to selection suggested.", t);
        }
        return TextClassifier.NO_OP.suggestSelection(text, selectionStartIndex, selectionEndIndex, defaultLocales);
    }

    private final TextClassification $$robo$$android_view_textclassifier_TextClassifierImpl$classifyText(CharSequence text, int startIndex, int endIndex, LocaleList defaultLocales) {
        TextClassifierImpl.validateInput(text, startIndex, endIndex);
        try {
            if (text.length() > 0) {
                String string2 = text.toString();
                SmartSelection.ClassificationResult[] results = this.getSmartSelection(defaultLocales).classifyText(string2, startIndex, endIndex, TextClassifierImpl.getHintFlags(string2, startIndex, endIndex));
                if (results.length > 0) {
                    TextClassification classificationResult = this.createClassificationResult(results, string2.subSequence(startIndex, endIndex));
                    return classificationResult;
                }
            }
        }
        catch (Throwable t) {
            Log.e("TextClassifierImpl", "Error getting assist info.", t);
        }
        return TextClassifier.NO_OP.classifyText(text, startIndex, endIndex, defaultLocales);
    }

    private final LinksInfo $$robo$$android_view_textclassifier_TextClassifierImpl$getLinks(CharSequence text, int linkMask, LocaleList defaultLocales) {
        Preconditions.checkArgument(text != null);
        try {
            return LinksInfoFactory.create(this.mContext, this.getSmartSelection(defaultLocales), text.toString(), linkMask);
        }
        catch (Throwable t) {
            Log.e("TextClassifierImpl", "Error getting links info.", t);
            return TextClassifier.NO_OP.getLinks(text, linkMask, defaultLocales);
        }
    }

    private final void $$robo$$android_view_textclassifier_TextClassifierImpl$logEvent(String source, String event) {
        if ("TextClassifierImpl".equals(source)) {
            this.mMetricsLogger.count(event, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SmartSelection $$robo$$android_view_textclassifier_TextClassifierImpl$getSmartSelection(LocaleList localeList) throws FileNotFoundException {
        Object object = this.mSmartSelectionLock;
        synchronized (object) {
            localeList = localeList == null ? LocaleList.getEmptyLocaleList() : localeList;
            Locale locale = this.findBestSupportedLocaleLocked(localeList);
            if (locale == null) {
                throw new FileNotFoundException("No file for null locale");
            }
            if (this.mSmartSelection == null || !Objects.equals(this.mLocale, locale)) {
                this.destroySmartSelectionIfExistsLocked();
                ParcelFileDescriptor fd = this.getFdLocked(locale);
                this.mSmartSelection = new SmartSelection(fd.getFd());
                TextClassifierImpl.closeAndLogError(fd);
                this.mLocale = locale;
            }
            return this.mSmartSelection;
        }
    }

    @GuardedBy(value="mSmartSelectionLock")
    private final ParcelFileDescriptor $$robo$$android_view_textclassifier_TextClassifierImpl$getFdLocked(Locale locale) throws FileNotFoundException {
        int factoryVersion;
        ParcelFileDescriptor factoryFd;
        ParcelFileDescriptor updateFd;
        try {
            updateFd = ParcelFileDescriptor.open(new File("/data/misc/textclassifier/textclassifier.smartselection.model"), 0x10000000);
        }
        catch (FileNotFoundException e) {
            updateFd = null;
        }
        try {
            String factoryModelFilePath = this.getFactoryModelFilePathsLocked().get(locale);
            factoryFd = factoryModelFilePath != null ? ParcelFileDescriptor.open(new File(factoryModelFilePath), 0x10000000) : null;
        }
        catch (FileNotFoundException e) {
            factoryFd = null;
        }
        if (updateFd == null) {
            if (factoryFd != null) {
                return factoryFd;
            }
            throw new FileNotFoundException(String.format("No model file found for %s", locale));
        }
        int updateFdInt = updateFd.getFd();
        boolean localeMatches = Objects.equals(locale.getLanguage().trim().toLowerCase(), SmartSelection.getLanguage(updateFdInt).trim().toLowerCase());
        if (factoryFd == null) {
            if (localeMatches) {
                return updateFd;
            }
            TextClassifierImpl.closeAndLogError(updateFd);
            throw new FileNotFoundException(String.format("No model file found for %s", locale));
        }
        if (!localeMatches) {
            TextClassifierImpl.closeAndLogError(updateFd);
            return factoryFd;
        }
        int updateVersion = SmartSelection.getVersion(updateFdInt);
        if (updateVersion > (factoryVersion = SmartSelection.getVersion(factoryFd.getFd()))) {
            TextClassifierImpl.closeAndLogError(factoryFd);
            return updateFd;
        }
        TextClassifierImpl.closeAndLogError(updateFd);
        return factoryFd;
    }

    @GuardedBy(value="mSmartSelectionLock")
    private final void $$robo$$android_view_textclassifier_TextClassifierImpl$destroySmartSelectionIfExistsLocked() {
        if (this.mSmartSelection != null) {
            this.mSmartSelection.close();
            this.mSmartSelection = null;
        }
    }

    @GuardedBy(value="mSmartSelectionLock")
    private final Locale $$robo$$android_view_textclassifier_TextClassifierImpl$findBestSupportedLocaleLocked(LocaleList localeList) {
        String languages = localeList.isEmpty() ? LocaleList.getDefault().toLanguageTags() : localeList.toLanguageTags() + "," + LocaleList.getDefault().toLanguageTags();
        List<Locale.LanguageRange> languageRangeList = Locale.LanguageRange.parse(languages);
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>(this.getFactoryModelFilePathsLocked().keySet());
        Locale updatedModelLocale = this.getUpdatedModelLocale();
        if (updatedModelLocale != null) {
            supportedLocales.add(updatedModelLocale);
        }
        return Locale.lookup(languageRangeList, supportedLocales);
    }

    @GuardedBy(value="mSmartSelectionLock")
    private final Map<Locale, String> $$robo$$android_view_textclassifier_TextClassifierImpl$getFactoryModelFilePathsLocked() {
        if (this.mModelFilePaths == null) {
            HashMap<Locale, String> modelFilePaths = new HashMap<Locale, String>();
            File modelsDir = new File("/etc/textclassifier/");
            if (modelsDir.exists() && modelsDir.isDirectory()) {
                File[] models = modelsDir.listFiles();
                Pattern modelFilenamePattern = Pattern.compile("textclassifier\\.smartselection\\.(.*)\\.model");
                for (File modelFile : models) {
                    Matcher matcher = modelFilenamePattern.matcher(modelFile.getName());
                    if (!matcher.matches() || !modelFile.isFile()) continue;
                    String language = matcher.group(1);
                    Locale locale = Locale.forLanguageTag(language);
                    modelFilePaths.put(locale, modelFile.getAbsolutePath());
                }
            }
            this.mModelFilePaths = modelFilePaths;
        }
        return this.mModelFilePaths;
    }

    private final Locale $$robo$$android_view_textclassifier_TextClassifierImpl$getUpdatedModelLocale() {
        try {
            ParcelFileDescriptor updateFd = ParcelFileDescriptor.open(new File("/data/misc/textclassifier/textclassifier.smartselection.model"), 0x10000000);
            Locale locale = Locale.forLanguageTag(SmartSelection.getLanguage(updateFd.getFd()));
            TextClassifierImpl.closeAndLogError(updateFd);
            return locale;
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    private final TextClassification $$robo$$android_view_textclassifier_TextClassifierImpl$createClassificationResult(SmartSelection.ClassificationResult[] classifications, CharSequence text) {
        ResolveInfo resolveInfo;
        PackageManager pm;
        TextClassification.Builder builder = new TextClassification.Builder().setText(text.toString());
        int size = classifications.length;
        for (int i = 0; i < size; ++i) {
            builder.setEntityType(classifications[i].mCollection, classifications[i].mScore);
        }
        String type = TextClassifierImpl.getHighestScoringType(classifications);
        builder.setLogType(IntentFactory.getLogType(type));
        Intent intent = IntentFactory.create(this.mContext, type, text.toString());
        if (intent != null) {
            pm = this.mContext.getPackageManager();
            resolveInfo = pm.resolveActivity(intent, 0);
        } else {
            pm = null;
            resolveInfo = null;
        }
        if (resolveInfo != null && resolveInfo.activityInfo != null) {
            builder.setIntent(intent).setOnClickListener(TextClassification.createStartActivityOnClickListener(this.mContext, intent));
            String packageName = resolveInfo.activityInfo.packageName;
            if ("android".equals(packageName)) {
                builder.setLabel(IntentFactory.getLabel(this.mContext, type));
            } else {
                intent.setComponent(new ComponentName(packageName, resolveInfo.activityInfo.name));
                Drawable icon = resolveInfo.activityInfo.loadIcon(pm);
                if (icon == null) {
                    icon = resolveInfo.loadIcon(pm);
                }
                builder.setIcon(icon);
                CharSequence label = resolveInfo.activityInfo.loadLabel(pm);
                if (label == null) {
                    label = resolveInfo.loadLabel(pm);
                }
                builder.setLabel(label != null ? label.toString() : null);
            }
        }
        return builder.build();
    }

    private static final int $$robo$$android_view_textclassifier_TextClassifierImpl$getHintFlags(CharSequence text, int start, int end) {
        int flag = 0;
        CharSequence subText = text.subSequence(start, end);
        if (Patterns.AUTOLINK_EMAIL_ADDRESS.matcher(subText).matches()) {
            flag |= 2;
        }
        if (Patterns.AUTOLINK_WEB_URL.matcher(subText).matches() && Linkify.sUrlMatchFilter.acceptMatch(text, start, end)) {
            flag |= 1;
        }
        return flag;
    }

    private static final String $$robo$$android_view_textclassifier_TextClassifierImpl$getHighestScoringType(SmartSelection.ClassificationResult[] types) {
        if (types.length < 1) {
            return "";
        }
        String type = types[0].mCollection;
        float highestScore = types[0].mScore;
        int size = types.length;
        for (int i = 1; i < size; ++i) {
            if (!(types[i].mScore > highestScore)) continue;
            type = types[i].mCollection;
            highestScore = types[i].mScore;
        }
        return type;
    }

    private static final void $$robo$$android_view_textclassifier_TextClassifierImpl$closeAndLogError(ParcelFileDescriptor fd) {
        try {
            fd.close();
        }
        catch (IOException e) {
            Log.e("TextClassifierImpl", "Error closing file.", e);
        }
    }

    private static final void $$robo$$android_view_textclassifier_TextClassifierImpl$validateInput(CharSequence text, int startIndex, int endIndex) {
        Preconditions.checkArgument(text != null);
        Preconditions.checkArgument(startIndex >= 0);
        Preconditions.checkArgument(endIndex <= text.length());
        Preconditions.checkArgument(endIndex > startIndex);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_textclassifier_TextClassifierImpl$__constructor__(context);
    }

    public TextClassifierImpl(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl$__constructor__(android.content.Context ), this, context);
    }

    @Override
    public TextSelection suggestSelection(CharSequence charSequence, int n, int n2, LocaleList localeList) {
        return InvokeDynamicSupport.bootstrap("suggestSelection", $$robo$$android_view_textclassifier_TextClassifierImpl$suggestSelection(java.lang.CharSequence int int android.os.LocaleList ), this, charSequence, n, n2, localeList);
    }

    @Override
    public TextClassification classifyText(CharSequence charSequence, int n, int n2, LocaleList localeList) {
        return InvokeDynamicSupport.bootstrap("classifyText", $$robo$$android_view_textclassifier_TextClassifierImpl$classifyText(java.lang.CharSequence int int android.os.LocaleList ), this, charSequence, n, n2, localeList);
    }

    @Override
    public LinksInfo getLinks(CharSequence charSequence, int n, LocaleList localeList) {
        return InvokeDynamicSupport.bootstrap("getLinks", $$robo$$android_view_textclassifier_TextClassifierImpl$getLinks(java.lang.CharSequence int android.os.LocaleList ), this, charSequence, n, localeList);
    }

    @Override
    public void logEvent(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("logEvent", $$robo$$android_view_textclassifier_TextClassifierImpl$logEvent(java.lang.String java.lang.String ), this, string2, string3);
    }

    private SmartSelection getSmartSelection(LocaleList localeList) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("getSmartSelection", $$robo$$android_view_textclassifier_TextClassifierImpl$getSmartSelection(android.os.LocaleList ), this, localeList);
    }

    private ParcelFileDescriptor getFdLocked(Locale locale) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrap("getFdLocked", $$robo$$android_view_textclassifier_TextClassifierImpl$getFdLocked(java.util.Locale ), this, locale);
    }

    private void destroySmartSelectionIfExistsLocked() {
        InvokeDynamicSupport.bootstrap("destroySmartSelectionIfExistsLocked", $$robo$$android_view_textclassifier_TextClassifierImpl$destroySmartSelectionIfExistsLocked(), this);
    }

    private Locale findBestSupportedLocaleLocked(LocaleList localeList) {
        return InvokeDynamicSupport.bootstrap("findBestSupportedLocaleLocked", $$robo$$android_view_textclassifier_TextClassifierImpl$findBestSupportedLocaleLocked(android.os.LocaleList ), this, localeList);
    }

    private Map<Locale, String> getFactoryModelFilePathsLocked() {
        return InvokeDynamicSupport.bootstrap("getFactoryModelFilePathsLocked", $$robo$$android_view_textclassifier_TextClassifierImpl$getFactoryModelFilePathsLocked(), this);
    }

    private Locale getUpdatedModelLocale() {
        return InvokeDynamicSupport.bootstrap("getUpdatedModelLocale", $$robo$$android_view_textclassifier_TextClassifierImpl$getUpdatedModelLocale(), this);
    }

    private TextClassification createClassificationResult(SmartSelection.ClassificationResult[] classificationResultArray, CharSequence charSequence) {
        return InvokeDynamicSupport.bootstrap("createClassificationResult", $$robo$$android_view_textclassifier_TextClassifierImpl$createClassificationResult(android.view.textclassifier.SmartSelection$ClassificationResult[] java.lang.CharSequence ), this, classificationResultArray, charSequence);
    }

    private static int getHintFlags(CharSequence charSequence, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getHintFlags", $$robo$$android_view_textclassifier_TextClassifierImpl$getHintFlags(java.lang.CharSequence int int ), (CharSequence)charSequence, (int)n, (int)n2);
    }

    private static String getHighestScoringType(SmartSelection.ClassificationResult[] classificationResultArray) {
        return InvokeDynamicSupport.bootstrapStatic("getHighestScoringType", $$robo$$android_view_textclassifier_TextClassifierImpl$getHighestScoringType(android.view.textclassifier.SmartSelection$ClassificationResult[] ), (SmartSelection.ClassificationResult[])classificationResultArray);
    }

    private static void closeAndLogError(ParcelFileDescriptor parcelFileDescriptor) {
        InvokeDynamicSupport.bootstrapStatic("closeAndLogError", $$robo$$android_view_textclassifier_TextClassifierImpl$closeAndLogError(android.os.ParcelFileDescriptor ), (ParcelFileDescriptor)parcelFileDescriptor);
    }

    private static void validateInput(CharSequence charSequence, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("validateInput", $$robo$$android_view_textclassifier_TextClassifierImpl$validateInput(java.lang.CharSequence int int ), (CharSequence)charSequence, (int)n, (int)n2);
    }

    public /* synthetic */ TextClassifierImpl() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextClassifierImpl)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class IntentFactory
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$__constructor__() {
        }

        private static final Intent $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$create(Context context, String type, String text) {
            type = type.trim().toLowerCase(Locale.ENGLISH);
            text = text.trim();
            switch (type) {
                case "email": {
                    return new Intent("android.intent.action.SENDTO").setData(Uri.parse(String.format("mailto:%s", text)));
                }
                case "phone": {
                    return new Intent("android.intent.action.DIAL").setData(Uri.parse(String.format("tel:%s", text)));
                }
                case "address": {
                    return new Intent("android.intent.action.VIEW").setData(Uri.parse(String.format("geo:0,0?q=%s", text)));
                }
                case "url": {
                    String httpPrefix = "http://";
                    String httpsPrefix = "https://";
                    text = text.toLowerCase().startsWith("http://") ? "http://" + text.substring("http://".length()) : (text.toLowerCase().startsWith("https://") ? "https://" + text.substring("https://".length()) : "http://" + text);
                    return new Intent("android.intent.action.VIEW", Uri.parse(text)).putExtra("com.android.browser.application_id", context.getPackageName());
                }
            }
            return null;
        }

        private static final String $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$getLabel(Context context, String type) {
            switch (type = type.trim().toLowerCase(Locale.ENGLISH)) {
                case "email": {
                    return context.getString(17039792);
                }
                case "phone": {
                    return context.getString(17039762);
                }
                case "address": {
                    return context.getString(17040156);
                }
                case "url": {
                    return context.getString(17039571);
                }
            }
            return null;
        }

        private static final int $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$getLogType(String type) {
            switch (type = type.trim().toLowerCase(Locale.ENGLISH)) {
                case "email": {
                    return 1;
                }
                case "phone": {
                    return 2;
                }
                case "address": {
                    return 3;
                }
                case "url": {
                    return 4;
                }
            }
            return 0;
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$__constructor__();
        }

        public IntentFactory() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$__constructor__(), this);
        }

        public static Intent create(Context context, String string2, String string3) {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$create(android.content.Context java.lang.String java.lang.String ), (Context)context, (String)string2, (String)string3);
        }

        public static String getLabel(Context context, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("getLabel", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$getLabel(android.content.Context java.lang.String ), (Context)context, (String)string2);
        }

        public static int getLogType(String string2) {
            return (int)InvokeDynamicSupport.bootstrapStatic("getLogType", $$robo$$android_view_textclassifier_TextClassifierImpl_IntentFactory$getLogType(java.lang.String ), (String)string2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IntentFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class LinksInfoFactory
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$__constructor__() {
        }

        private static final LinksInfo $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$create(Context context, SmartSelection smartSelection, String text, int linkMask) {
            int end;
            WordIterator wordIterator = new WordIterator();
            wordIterator.setCharSequence(text, 0, text.length());
            ArrayList<SpanSpec> spans = new ArrayList<SpanSpec>();
            int start = 0;
            while ((end = wordIterator.nextBoundary(start)) != -1) {
                Intent intent;
                String type;
                SmartSelection.ClassificationResult[] results;
                String token = text.substring(start, end);
                if (TextUtils.isEmpty(token)) continue;
                int[] selection = smartSelection.suggest(text, start, end);
                int selectionStart = selection[0];
                int selectionEnd = selection[1];
                if (selectionStart >= 0 && selectionEnd <= text.length() && selectionStart <= selectionEnd && (results = smartSelection.classifyText(text, selectionStart, selectionEnd, TextClassifierImpl.getHintFlags(text, selectionStart, selectionEnd))).length > 0 && LinksInfoFactory.matches(type = TextClassifierImpl.getHighestScoringType(results), linkMask) && LinksInfoFactory.hasActivityHandler(context, intent = IntentFactory.create(context, type, text.substring(selectionStart, selectionEnd)))) {
                    ClickableSpan span = LinksInfoFactory.createSpan(context, intent);
                    spans.add(new SpanSpec(selectionStart, selectionEnd, span));
                }
                start = end;
            }
            return new LinksInfoImpl(text, LinksInfoFactory.avoidOverlaps(spans, text));
        }

        private static final boolean $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$matches(String type, int linkMask) {
            type = type.trim().toLowerCase(Locale.ENGLISH);
            if ((linkMask & 4) != 0 && "phone".equals(type)) {
                return true;
            }
            if ((linkMask & 2) != 0 && "email".equals(type)) {
                return true;
            }
            if ((linkMask & 8) != 0 && "address".equals(type)) {
                return true;
            }
            return (linkMask & 1) != 0 && "url".equals(type);
        }

        private static final List<SpanSpec> $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$avoidOverlaps(List<SpanSpec> spans, String text) {
            Collections.sort(spans, Comparator.comparingInt(span -> ((SpanSpec)span).mStart));
            LinkedHashMap<Integer, SpanSpec> reps = new LinkedHashMap<Integer, SpanSpec>();
            int size = spans.size();
            for (int i = 0; i < size; ++i) {
                SpanSpec span2 = spans.get(i);
                SpanSpec rep = (SpanSpec)reps.get(span2.mStart);
                if (rep != null && rep.mEnd >= span2.mEnd) continue;
                reps.put(span2.mStart, span2);
            }
            LinkedList<SpanSpec> result = new LinkedList<SpanSpec>();
            for (SpanSpec rep : reps.values()) {
                if (result.isEmpty()) {
                    result.add(rep);
                    continue;
                }
                SpanSpec last = result.getLast();
                if (rep.mStart < last.mEnd) {
                    if (rep.mEnd - rep.mStart <= last.mEnd - last.mStart) continue;
                    result.set(result.size() - 1, rep);
                    continue;
                }
                result.add(rep);
            }
            return result;
        }

        private static final ClickableSpan $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$createSpan(Context context, Intent intent) {
            return new ShadowedObject(context, intent){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ Context val$context;
                /* synthetic */ Intent val$intent;

                private void $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_1$__constructor__(Context context, Intent intent) {
                    this.val$context = context;
                    this.val$intent = intent;
                }

                private final void $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_1$onClick(View widget) {
                    this.val$context.startActivity(this.val$intent);
                }

                private void __constructor__(Context context, Intent intent) {
                    this.$$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_1$__constructor__(context, intent);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_1$__constructor__(android.content.Context android.content.Intent ), this, context, intent);
                }

                @Override
                public void onClick(View view) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_1$onClick(android.view.View ), this, view);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private static final boolean $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$hasActivityHandler(Context context, Intent intent) {
            if (intent == null) {
                return false;
            }
            ResolveInfo resolveInfo = context.getPackageManager().resolveActivity(intent, 0);
            return resolveInfo != null && resolveInfo.activityInfo != null;
        }

        private void __constructor__() {
            this.$$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$__constructor__();
        }

        public LinksInfoFactory() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$__constructor__(), this);
        }

        public static LinksInfo create(Context context, SmartSelection smartSelection, String string2, int n) {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$create(android.content.Context android.view.textclassifier.SmartSelection java.lang.String int ), (Context)context, (SmartSelection)smartSelection, (String)string2, (int)n);
        }

        private static boolean matches(String string2, int n) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("matches", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$matches(java.lang.String int ), (String)string2, (int)n);
        }

        private static List<SpanSpec> avoidOverlaps(List<SpanSpec> list, String string2) {
            return InvokeDynamicSupport.bootstrapStatic("avoidOverlaps", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$avoidOverlaps(java.util.List<android.view.textclassifier.TextClassifierImpl$LinksInfoFactory$SpanSpec> java.lang.String ), list, (String)string2);
        }

        private static ClickableSpan createSpan(Context context, Intent intent) {
            return InvokeDynamicSupport.bootstrapStatic("createSpan", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$createSpan(android.content.Context android.content.Intent ), (Context)context, (Intent)intent);
        }

        private static boolean hasActivityHandler(Context context, Intent intent) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("hasActivityHandler", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory$hasActivityHandler(android.content.Context android.content.Intent ), (Context)context, (Intent)intent);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LinksInfoFactory)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private static final class SpanSpec
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private int mStart;
            private int mEnd;
            private ClickableSpan mSpan;

            private void $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_SpanSpec$__constructor__(int start, int end, ClickableSpan span) {
                this.mStart = start;
                this.mEnd = end;
                this.mSpan = span;
            }

            private void __constructor__(int n, int n2, ClickableSpan clickableSpan) {
                this.$$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_SpanSpec$__constructor__(n, n2, clickableSpan);
            }

            public SpanSpec(int n, int n2, ClickableSpan clickableSpan) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_SpanSpec$__constructor__(int int android.text.style.ClickableSpan ), this, n, n2, clickableSpan);
            }

            public /* synthetic */ SpanSpec() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SpanSpec)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
        private static final class LinksInfoImpl
        implements LinksInfo,
        ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private CharSequence mOriginalText;
            private List<SpanSpec> mSpans;

            private void $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_LinksInfoImpl$__constructor__(CharSequence originalText, List<SpanSpec> spans) {
                this.mOriginalText = originalText;
                this.mSpans = spans;
            }

            private final boolean $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_LinksInfoImpl$apply(CharSequence text) {
                Preconditions.checkArgument(text != null);
                if (text instanceof Spannable && this.mOriginalText.toString().equals(text.toString())) {
                    Spannable spannable = (Spannable)text;
                    int size = this.mSpans.size();
                    for (int i = 0; i < size; ++i) {
                        SpanSpec span = this.mSpans.get(i);
                        spannable.setSpan(span.mSpan, span.mStart, span.mEnd, 0);
                    }
                    return true;
                }
                return false;
            }

            private void __constructor__(CharSequence charSequence, List<SpanSpec> list) {
                this.$$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_LinksInfoImpl$__constructor__(charSequence, list);
            }

            public LinksInfoImpl(CharSequence charSequence, List<SpanSpec> list) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_LinksInfoImpl$__constructor__(java.lang.CharSequence java.util.List<android.view.textclassifier.TextClassifierImpl$LinksInfoFactory$SpanSpec> ), this, charSequence, list);
            }

            @Override
            public boolean apply(CharSequence charSequence) {
                return (boolean)InvokeDynamicSupport.bootstrap("apply", $$robo$$android_view_textclassifier_TextClassifierImpl_LinksInfoFactory_LinksInfoImpl$apply(java.lang.CharSequence ), this, charSequence);
            }

            public /* synthetic */ LinksInfoImpl() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LinksInfoImpl)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

