/*
 * Decompiled with CFR 0.152.
 */
package android.webkit;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.webkit.JsPromptResult;
import android.webkit.URLUtil;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.widget.EditText;
import android.widget.TextView;
import java.net.MalformedURLException;
import java.net.URL;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class JsDialogHelper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "JsDialogHelper";
    public static int ALERT = 1;
    public static int CONFIRM = 2;
    public static int PROMPT = 3;
    public static int UNLOAD = 4;
    private String mDefaultValue;
    private JsPromptResult mResult;
    private String mMessage;
    private int mType;
    private String mUrl;

    private void $$robo$$android_webkit_JsDialogHelper$__constructor__(JsPromptResult result, int type, String defaultValue, String message, String url) {
        this.mResult = result;
        this.mDefaultValue = defaultValue;
        this.mMessage = message;
        this.mType = type;
        this.mUrl = url;
    }

    private void $$robo$$android_webkit_JsDialogHelper$__constructor__(JsPromptResult result, Message msg) {
        this.mResult = result;
        this.mDefaultValue = msg.getData().getString("default");
        this.mMessage = msg.getData().getString("message");
        this.mType = msg.getData().getInt("type");
        this.mUrl = msg.getData().getString("url");
    }

    private final boolean $$robo$$android_webkit_JsDialogHelper$invokeCallback(WebChromeClient client, WebView webView) {
        switch (this.mType) {
            case 1: {
                return client.onJsAlert(webView, this.mUrl, this.mMessage, this.mResult);
            }
            case 2: {
                return client.onJsConfirm(webView, this.mUrl, this.mMessage, this.mResult);
            }
            case 4: {
                return client.onJsBeforeUnload(webView, this.mUrl, this.mMessage, this.mResult);
            }
            case 3: {
                return client.onJsPrompt(webView, this.mUrl, this.mMessage, this.mDefaultValue, this.mResult);
            }
        }
        throw new IllegalArgumentException("Unexpected type: " + this.mType);
    }

    private final void $$robo$$android_webkit_JsDialogHelper$showDialog(Context context) {
        int negativeTextId;
        int positiveTextId;
        String displayMessage;
        String title;
        if (!JsDialogHelper.canShowAlertDialog(context)) {
            Log.w("JsDialogHelper", "Cannot create a dialog, the WebView context is not an Activity");
            this.mResult.cancel();
            return;
        }
        if (this.mType == 4) {
            title = context.getString(17039998);
            displayMessage = context.getString(17039995, this.mMessage);
            positiveTextId = 17039997;
            negativeTextId = 17039996;
        } else {
            title = this.getJsDialogTitle(context);
            displayMessage = this.mMessage;
            positiveTextId = 17039370;
            negativeTextId = 0x1040000;
        }
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle(title);
        builder.setOnCancelListener(new CancelListener(this, null));
        if (this.mType != 3) {
            builder.setMessage(displayMessage);
            builder.setPositiveButton(positiveTextId, (DialogInterface.OnClickListener)new PositiveListener(this, null));
        } else {
            View view = LayoutInflater.from(context).inflate(17367153, null);
            EditText edit = (EditText)view.findViewById(16909438);
            edit.setText(this.mDefaultValue);
            builder.setPositiveButton(positiveTextId, (DialogInterface.OnClickListener)new PositiveListener(this, edit));
            ((TextView)view.findViewById(16908299)).setText(this.mMessage);
            builder.setView(view);
        }
        if (this.mType != 1) {
            builder.setNegativeButton(negativeTextId, (DialogInterface.OnClickListener)new CancelListener(this, null));
        }
        builder.show();
    }

    private final String $$robo$$android_webkit_JsDialogHelper$getJsDialogTitle(Context context) {
        String title = this.mUrl;
        if (URLUtil.isDataUrl(this.mUrl)) {
            title = context.getString(17040000);
        } else {
            try {
                URL alertUrl = new URL(this.mUrl);
                title = context.getString(17039999, alertUrl.getProtocol() + "://" + alertUrl.getHost());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return title;
    }

    private static final boolean $$robo$$android_webkit_JsDialogHelper$canShowAlertDialog(Context context) {
        return context instanceof Activity;
    }

    private void __constructor__(JsPromptResult jsPromptResult, int n, String string2, String string3, String string4) {
        this.$$robo$$android_webkit_JsDialogHelper$__constructor__(jsPromptResult, n, string2, string3, string4);
    }

    public JsDialogHelper(JsPromptResult jsPromptResult, int n, String string2, String string3, String string4) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_JsDialogHelper$__constructor__(android.webkit.JsPromptResult int java.lang.String java.lang.String java.lang.String ), this, jsPromptResult, n, string2, string3, string4);
    }

    private void __constructor__(JsPromptResult jsPromptResult, Message message) {
        this.$$robo$$android_webkit_JsDialogHelper$__constructor__(jsPromptResult, message);
    }

    public JsDialogHelper(JsPromptResult jsPromptResult, Message message) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_JsDialogHelper$__constructor__(android.webkit.JsPromptResult android.os.Message ), this, jsPromptResult, message);
    }

    public boolean invokeCallback(WebChromeClient webChromeClient, WebView webView) {
        return (boolean)InvokeDynamicSupport.bootstrap("invokeCallback", $$robo$$android_webkit_JsDialogHelper$invokeCallback(android.webkit.WebChromeClient android.webkit.WebView ), this, webChromeClient, webView);
    }

    public void showDialog(Context context) {
        InvokeDynamicSupport.bootstrap("showDialog", $$robo$$android_webkit_JsDialogHelper$showDialog(android.content.Context ), this, context);
    }

    private String getJsDialogTitle(Context context) {
        return InvokeDynamicSupport.bootstrap("getJsDialogTitle", $$robo$$android_webkit_JsDialogHelper$getJsDialogTitle(android.content.Context ), this, context);
    }

    private static boolean canShowAlertDialog(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("canShowAlertDialog", $$robo$$android_webkit_JsDialogHelper$canShowAlertDialog(android.content.Context ), (Context)context);
    }

    public /* synthetic */ JsDialogHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (JsDialogHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class PositiveListener
    implements DialogInterface.OnClickListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private EditText mEdit;
        /* synthetic */ JsDialogHelper this$0;

        private void $$robo$$android_webkit_JsDialogHelper_PositiveListener$__constructor__(JsDialogHelper jsDialogHelper, EditText edit) {
            this.mEdit = edit;
        }

        private final void $$robo$$android_webkit_JsDialogHelper_PositiveListener$onClick(DialogInterface dialog, int which) {
            if (this.mEdit == null) {
                this.this$0.mResult.confirm();
            } else {
                this.this$0.mResult.confirm(((Object)this.mEdit.getText()).toString());
            }
        }

        private void __constructor__(JsDialogHelper jsDialogHelper, EditText editText) {
            this.$$robo$$android_webkit_JsDialogHelper_PositiveListener$__constructor__(jsDialogHelper, editText);
        }

        public PositiveListener(JsDialogHelper jsDialogHelper, EditText editText) {
            this.this$0 = jsDialogHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_JsDialogHelper_PositiveListener$__constructor__(android.webkit.JsDialogHelper android.widget.EditText ), this, jsDialogHelper, editText);
        }

        @Override
        public void onClick(DialogInterface dialogInterface, int n) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_webkit_JsDialogHelper_PositiveListener$onClick(android.content.DialogInterface int ), this, dialogInterface, n);
        }

        public /* synthetic */ PositiveListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PositiveListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class CancelListener
    implements DialogInterface.OnCancelListener,
    DialogInterface.OnClickListener,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ JsDialogHelper this$0;

        private void $$robo$$android_webkit_JsDialogHelper_CancelListener$__constructor__(JsDialogHelper jsDialogHelper) {
        }

        private final void $$robo$$android_webkit_JsDialogHelper_CancelListener$onCancel(DialogInterface dialog) {
            this.this$0.mResult.cancel();
        }

        private final void $$robo$$android_webkit_JsDialogHelper_CancelListener$onClick(DialogInterface dialog, int which) {
            this.this$0.mResult.cancel();
        }

        private /* synthetic */ void $$robo$$android_webkit_JsDialogHelper_CancelListener$__constructor__(JsDialogHelper x0, 1 x1) {
        }

        private void __constructor__(JsDialogHelper jsDialogHelper) {
            this.$$robo$$android_webkit_JsDialogHelper_CancelListener$__constructor__(jsDialogHelper);
        }

        public CancelListener(JsDialogHelper jsDialogHelper) {
            this.this$0 = jsDialogHelper;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_JsDialogHelper_CancelListener$__constructor__(android.webkit.JsDialogHelper ), this, jsDialogHelper);
        }

        @Override
        public void onCancel(DialogInterface dialogInterface) {
            InvokeDynamicSupport.bootstrap("onCancel", $$robo$$android_webkit_JsDialogHelper_CancelListener$onCancel(android.content.DialogInterface ), this, dialogInterface);
        }

        @Override
        public void onClick(DialogInterface dialogInterface, int n) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_webkit_JsDialogHelper_CancelListener$onClick(android.content.DialogInterface int ), this, dialogInterface, n);
        }

        private /* synthetic */ void __constructor__(JsDialogHelper jsDialogHelper, 1 var2_2) {
            this.$$robo$$android_webkit_JsDialogHelper_CancelListener$__constructor__(jsDialogHelper, var2_2);
        }

        public /* synthetic */ CancelListener(JsDialogHelper jsDialogHelper, 1 var2_2) {
            this(jsDialogHelper);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_webkit_JsDialogHelper_CancelListener$__constructor__(android.webkit.JsDialogHelper android.webkit.JsDialogHelper$1 ), this, jsDialogHelper, var2_2);
        }

        public /* synthetic */ CancelListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CancelListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

