/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.os.Process;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RemoteViews;
import com.android.internal.R;
import java.util.TimeZone;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
@Deprecated
public class AnalogClock
extends View
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private Time mCalendar;
    private Drawable mHourHand;
    private Drawable mMinuteHand;
    private Drawable mDial;
    private int mDialWidth;
    private int mDialHeight;
    private boolean mAttached;
    private float mMinutes;
    private float mHour;
    private boolean mChanged;
    private BroadcastReceiver mIntentReceiver;

    private void $$robo$$android_widget_AnalogClock$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_AnalogClock$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_AnalogClock$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_AnalogClock$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mIntentReceiver = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ AnalogClock this$0;

            private void $$robo$$android_widget_AnalogClock_1$__constructor__(AnalogClock this$0) {
            }

            private final void $$robo$$android_widget_AnalogClock_1$onReceive(Context context, Intent intent) {
                if (intent.getAction().equals("android.intent.action.TIMEZONE_CHANGED")) {
                    String tz = intent.getStringExtra("time-zone");
                    this.this$0.mCalendar = new Time(TimeZone.getTimeZone(tz).getID());
                }
                this.this$0.onTimeChanged();
                this.this$0.invalidate();
            }

            private void __constructor__(AnalogClock analogClock) {
                this.$$robo$$android_widget_AnalogClock_1$__constructor__(analogClock);
            }
            {
                this.this$0 = analogClock;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AnalogClock_1$__constructor__(android.widget.AnalogClock ), this, analogClock);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_widget_AnalogClock_1$onReceive(android.content.Context android.content.Intent ), this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        Resources r = context.getResources();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AnalogClock, defStyleAttr, defStyleRes);
        this.mDial = a.getDrawable(0);
        if (this.mDial == null) {
            this.mDial = context.getDrawable(17302089);
        }
        this.mHourHand = a.getDrawable(1);
        if (this.mHourHand == null) {
            this.mHourHand = context.getDrawable(17302090);
        }
        this.mMinuteHand = a.getDrawable(2);
        if (this.mMinuteHand == null) {
            this.mMinuteHand = context.getDrawable(17302091);
        }
        this.mCalendar = new Time();
        this.mDialWidth = this.mDial.getIntrinsicWidth();
        this.mDialHeight = this.mDial.getIntrinsicHeight();
    }

    private final void $$robo$$android_widget_AnalogClock$onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.mAttached) {
            this.mAttached = true;
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.TIME_TICK");
            filter.addAction("android.intent.action.TIME_SET");
            filter.addAction("android.intent.action.TIMEZONE_CHANGED");
            this.getContext().registerReceiverAsUser(this.mIntentReceiver, Process.myUserHandle(), filter, null, this.getHandler());
        }
        this.mCalendar = new Time();
        this.onTimeChanged();
    }

    private final void $$robo$$android_widget_AnalogClock$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mAttached) {
            this.getContext().unregisterReceiver(this.mIntentReceiver);
            this.mAttached = false;
        }
    }

    private final void $$robo$$android_widget_AnalogClock$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        float hScale = 1.0f;
        float vScale = 1.0f;
        if (widthMode != 0 && widthSize < this.mDialWidth) {
            hScale = (float)widthSize / (float)this.mDialWidth;
        }
        if (heightMode != 0 && heightSize < this.mDialHeight) {
            vScale = (float)heightSize / (float)this.mDialHeight;
        }
        float scale = Math.min(hScale, vScale);
        this.setMeasuredDimension(AnalogClock.resolveSizeAndState((int)((float)this.mDialWidth * scale), widthMeasureSpec, 0), AnalogClock.resolveSizeAndState((int)((float)this.mDialHeight * scale), heightMeasureSpec, 0));
    }

    private final void $$robo$$android_widget_AnalogClock$onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.mChanged = true;
    }

    private final void $$robo$$android_widget_AnalogClock$onDraw(Canvas canvas) {
        super.onDraw(canvas);
        boolean changed = this.mChanged;
        if (changed) {
            this.mChanged = false;
        }
        int availableWidth = this.mRight - this.mLeft;
        int availableHeight = this.mBottom - this.mTop;
        int x = availableWidth / 2;
        int y = availableHeight / 2;
        Drawable dial = this.mDial;
        int w = dial.getIntrinsicWidth();
        int h = dial.getIntrinsicHeight();
        boolean scaled = false;
        if (availableWidth < w || availableHeight < h) {
            scaled = true;
            float scale = Math.min((float)availableWidth / (float)w, (float)availableHeight / (float)h);
            canvas.save();
            canvas.scale(scale, scale, x, y);
        }
        if (changed) {
            dial.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        }
        dial.draw(canvas);
        canvas.save();
        canvas.rotate(this.mHour / 12.0f * 360.0f, x, y);
        Drawable hourHand = this.mHourHand;
        if (changed) {
            w = hourHand.getIntrinsicWidth();
            h = hourHand.getIntrinsicHeight();
            hourHand.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        }
        hourHand.draw(canvas);
        canvas.restore();
        canvas.save();
        canvas.rotate(this.mMinutes / 60.0f * 360.0f, x, y);
        Drawable minuteHand = this.mMinuteHand;
        if (changed) {
            w = minuteHand.getIntrinsicWidth();
            h = minuteHand.getIntrinsicHeight();
            minuteHand.setBounds(x - w / 2, y - h / 2, x + w / 2, y + h / 2);
        }
        minuteHand.draw(canvas);
        canvas.restore();
        if (scaled) {
            canvas.restore();
        }
    }

    private final void $$robo$$android_widget_AnalogClock$onTimeChanged() {
        this.mCalendar.setToNow();
        int hour = this.mCalendar.hour;
        int minute = this.mCalendar.minute;
        int second = this.mCalendar.second;
        this.mMinutes = (float)minute + (float)second / 60.0f;
        this.mHour = (float)hour + this.mMinutes / 60.0f;
        this.mChanged = true;
        this.updateContentDescription(this.mCalendar);
    }

    private final void $$robo$$android_widget_AnalogClock$updateContentDescription(Time time) {
        int flags = 129;
        String contentDescription = DateUtils.formatDateTime(this.mContext, time.toMillis(false), 129);
        this.setContentDescription(contentDescription);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_AnalogClock$__constructor__(context);
    }

    public AnalogClock(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AnalogClock$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_AnalogClock$__constructor__(context, attributeSet);
    }

    public AnalogClock(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AnalogClock$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_AnalogClock$__constructor__(context, attributeSet, n);
    }

    public AnalogClock(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AnalogClock$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_AnalogClock$__constructor__(context, attributeSet, n, n2);
    }

    public AnalogClock(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AnalogClock$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_widget_AnalogClock$onAttachedToWindow(), this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_AnalogClock$onDetachedFromWindow(), this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_AnalogClock$onMeasure(int int ), this, n, n2);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_AnalogClock$onSizeChanged(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_AnalogClock$onDraw(android.graphics.Canvas ), this, canvas);
    }

    private void onTimeChanged() {
        InvokeDynamicSupport.bootstrap("onTimeChanged", $$robo$$android_widget_AnalogClock$onTimeChanged(), this);
    }

    private void updateContentDescription(Time time) {
        InvokeDynamicSupport.bootstrap("updateContentDescription", $$robo$$android_widget_AnalogClock$updateContentDescription(android.text.format.Time ), this, time);
    }

    public /* synthetic */ AnalogClock() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AnalogClock)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

