/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewHierarchyEncoder;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.Checkable;
import android.widget.TextView;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class CheckedTextView
extends TextView
implements Checkable,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private boolean mChecked;
    private int mCheckMarkResource;
    private Drawable mCheckMarkDrawable;
    private ColorStateList mCheckMarkTintList;
    private PorterDuff.Mode mCheckMarkTintMode;
    private boolean mHasCheckMarkTint;
    private boolean mHasCheckMarkTintMode;
    private int mBasePadding;
    private int mCheckMarkWidth;
    private int mCheckMarkGravity;
    private boolean mNeedRequestlayout;
    private static int[] CHECKED_STATE_SET;

    private void $$robo$$android_widget_CheckedTextView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_CheckedTextView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_CheckedTextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_CheckedTextView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mCheckMarkTintList = null;
        this.mCheckMarkTintMode = null;
        this.mHasCheckMarkTint = false;
        this.mHasCheckMarkTintMode = false;
        this.mCheckMarkGravity = 0x800005;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.CheckedTextView, defStyleAttr, defStyleRes);
        Drawable d = a.getDrawable(1);
        if (d != null) {
            this.setCheckMarkDrawable(d);
        }
        if (a.hasValue(3)) {
            this.mCheckMarkTintMode = Drawable.parseTintMode(a.getInt(3, -1), this.mCheckMarkTintMode);
            this.mHasCheckMarkTintMode = true;
        }
        if (a.hasValue(2)) {
            this.mCheckMarkTintList = a.getColorStateList(2);
            this.mHasCheckMarkTint = true;
        }
        this.mCheckMarkGravity = a.getInt(4, 0x800005);
        boolean checked = a.getBoolean(0, false);
        this.setChecked(checked);
        a.recycle();
        this.applyCheckMarkTint();
    }

    private final void $$robo$$android_widget_CheckedTextView$toggle() {
        this.setChecked(!this.mChecked);
    }

    @ViewDebug.ExportedProperty
    private final boolean $$robo$$android_widget_CheckedTextView$isChecked() {
        return this.mChecked;
    }

    private final void $$robo$$android_widget_CheckedTextView$setChecked(boolean checked) {
        if (this.mChecked != checked) {
            this.mChecked = checked;
            this.refreshDrawableState();
            this.notifyViewAccessibilityStateChangedIfNeeded(0);
        }
    }

    private final void $$robo$$android_widget_CheckedTextView$setCheckMarkDrawable(int resId) {
        if (resId != 0 && resId == this.mCheckMarkResource) {
            return;
        }
        Drawable d = resId != 0 ? this.getContext().getDrawable(resId) : null;
        this.setCheckMarkDrawableInternal(d, resId);
    }

    private final void $$robo$$android_widget_CheckedTextView$setCheckMarkDrawable(Drawable d) {
        this.setCheckMarkDrawableInternal(d, 0);
    }

    private final void $$robo$$android_widget_CheckedTextView$setCheckMarkDrawableInternal(Drawable d, int resId) {
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.setCallback(null);
            this.unscheduleDrawable(this.mCheckMarkDrawable);
        }
        boolean bl = this.mNeedRequestlayout = d != this.mCheckMarkDrawable;
        if (d != null) {
            d.setCallback(this);
            d.setVisible(this.getVisibility() == 0, false);
            d.setState(CHECKED_STATE_SET);
            this.setMinHeight(d.getIntrinsicHeight());
            this.mCheckMarkWidth = d.getIntrinsicWidth();
            d.setState(this.getDrawableState());
        } else {
            this.mCheckMarkWidth = 0;
        }
        this.mCheckMarkDrawable = d;
        this.mCheckMarkResource = resId;
        this.applyCheckMarkTint();
        this.resolvePadding();
    }

    private final void $$robo$$android_widget_CheckedTextView$setCheckMarkTintList(ColorStateList tint) {
        this.mCheckMarkTintList = tint;
        this.mHasCheckMarkTint = true;
        this.applyCheckMarkTint();
    }

    private final ColorStateList $$robo$$android_widget_CheckedTextView$getCheckMarkTintList() {
        return this.mCheckMarkTintList;
    }

    private final void $$robo$$android_widget_CheckedTextView$setCheckMarkTintMode(PorterDuff.Mode tintMode) {
        this.mCheckMarkTintMode = tintMode;
        this.mHasCheckMarkTintMode = true;
        this.applyCheckMarkTint();
    }

    private final PorterDuff.Mode $$robo$$android_widget_CheckedTextView$getCheckMarkTintMode() {
        return this.mCheckMarkTintMode;
    }

    private final void $$robo$$android_widget_CheckedTextView$applyCheckMarkTint() {
        if (this.mCheckMarkDrawable != null && (this.mHasCheckMarkTint || this.mHasCheckMarkTintMode)) {
            this.mCheckMarkDrawable = this.mCheckMarkDrawable.mutate();
            if (this.mHasCheckMarkTint) {
                this.mCheckMarkDrawable.setTintList(this.mCheckMarkTintList);
            }
            if (this.mHasCheckMarkTintMode) {
                this.mCheckMarkDrawable.setTintMode(this.mCheckMarkTintMode);
            }
            if (this.mCheckMarkDrawable.isStateful()) {
                this.mCheckMarkDrawable.setState(this.getDrawableState());
            }
        }
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_CheckedTextView$setVisibility(int visibility) {
        super.setVisibility(visibility);
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.setVisible(visibility == 0, false);
        }
    }

    private final void $$robo$$android_widget_CheckedTextView$jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.jumpToCurrentState();
        }
    }

    private final boolean $$robo$$android_widget_CheckedTextView$verifyDrawable(Drawable who) {
        return who == this.mCheckMarkDrawable || super.verifyDrawable(who);
    }

    private final Drawable $$robo$$android_widget_CheckedTextView$getCheckMarkDrawable() {
        return this.mCheckMarkDrawable;
    }

    private final void $$robo$$android_widget_CheckedTextView$internalSetPadding(int left, int top, int right, int bottom) {
        super.internalSetPadding(left, top, right, bottom);
        this.setBasePadding(this.isCheckMarkAtStart());
    }

    private final void $$robo$$android_widget_CheckedTextView$onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.updatePadding();
    }

    private final void $$robo$$android_widget_CheckedTextView$updatePadding() {
        int newPadding;
        this.resetPaddingToInitialValues();
        int n = newPadding = this.mCheckMarkDrawable != null ? this.mCheckMarkWidth + this.mBasePadding : this.mBasePadding;
        if (this.isCheckMarkAtStart()) {
            this.mNeedRequestlayout |= this.mPaddingLeft != newPadding;
            this.mPaddingLeft = newPadding;
        } else {
            this.mNeedRequestlayout |= this.mPaddingRight != newPadding;
            this.mPaddingRight = newPadding;
        }
        if (this.mNeedRequestlayout) {
            this.requestLayout();
            this.mNeedRequestlayout = false;
        }
    }

    private final void $$robo$$android_widget_CheckedTextView$setBasePadding(boolean checkmarkAtStart) {
        this.mBasePadding = checkmarkAtStart ? this.mPaddingLeft : this.mPaddingRight;
    }

    private final boolean $$robo$$android_widget_CheckedTextView$isCheckMarkAtStart() {
        int gravity = Gravity.getAbsoluteGravity(this.mCheckMarkGravity, this.getLayoutDirection());
        int hgrav = gravity & 7;
        return hgrav == 3;
    }

    private final void $$robo$$android_widget_CheckedTextView$onDraw(Canvas canvas) {
        super.onDraw(canvas);
        Drawable checkMarkDrawable = this.mCheckMarkDrawable;
        if (checkMarkDrawable != null) {
            int right;
            int left;
            int verticalGravity = this.getGravity() & 0x70;
            int height = checkMarkDrawable.getIntrinsicHeight();
            int y = 0;
            switch (verticalGravity) {
                case 80: {
                    y = this.getHeight() - height;
                    break;
                }
                case 16: {
                    y = (this.getHeight() - height) / 2;
                }
            }
            boolean checkMarkAtStart = this.isCheckMarkAtStart();
            int width = this.getWidth();
            int top = y;
            int bottom = top + height;
            if (checkMarkAtStart) {
                left = this.mBasePadding;
                right = left + this.mCheckMarkWidth;
            } else {
                right = width - this.mBasePadding;
                left = right - this.mCheckMarkWidth;
            }
            checkMarkDrawable.setBounds(this.mScrollX + left, top, this.mScrollX + right, bottom);
            checkMarkDrawable.draw(canvas);
            Drawable background = this.getBackground();
            if (background != null) {
                background.setHotspotBounds(this.mScrollX + left, top, this.mScrollX + right, bottom);
            }
        }
    }

    private final int[] $$robo$$android_widget_CheckedTextView$onCreateDrawableState(int extraSpace) {
        int[] drawableState = super.onCreateDrawableState(extraSpace + 1);
        if (this.isChecked()) {
            CheckedTextView.mergeDrawableStates(drawableState, CHECKED_STATE_SET);
        }
        return drawableState;
    }

    private final void $$robo$$android_widget_CheckedTextView$drawableStateChanged() {
        super.drawableStateChanged();
        Drawable checkMarkDrawable = this.mCheckMarkDrawable;
        if (checkMarkDrawable != null && checkMarkDrawable.isStateful() && checkMarkDrawable.setState(this.getDrawableState())) {
            this.invalidateDrawable(checkMarkDrawable);
        }
    }

    private final void $$robo$$android_widget_CheckedTextView$drawableHotspotChanged(float x, float y) {
        super.drawableHotspotChanged(x, y);
        if (this.mCheckMarkDrawable != null) {
            this.mCheckMarkDrawable.setHotspot(x, y);
        }
    }

    private final CharSequence $$robo$$android_widget_CheckedTextView$getAccessibilityClassName() {
        return CheckedTextView.class.getName();
    }

    private final Parcelable $$robo$$android_widget_CheckedTextView$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.checked = this.isChecked();
        return ss;
    }

    private final void $$robo$$android_widget_CheckedTextView$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setChecked(ss.checked);
        this.requestLayout();
    }

    private final void $$robo$$android_widget_CheckedTextView$onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        event.setChecked(this.mChecked);
    }

    private final void $$robo$$android_widget_CheckedTextView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        info.setCheckable(true);
        info.setChecked(this.mChecked);
    }

    private final void $$robo$$android_widget_CheckedTextView$encodeProperties(ViewHierarchyEncoder stream) {
        super.encodeProperties(stream);
        stream.addProperty("text:checked", this.isChecked());
    }

    static void __staticInitializer__() {
        CHECKED_STATE_SET = new int[]{0x10100A0};
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_CheckedTextView$__constructor__(context);
    }

    public CheckedTextView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_CheckedTextView$__constructor__(context, attributeSet);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843720);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_CheckedTextView$__constructor__(context, attributeSet, n);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_CheckedTextView$__constructor__(context, attributeSet, n, n2);
    }

    public CheckedTextView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    public void toggle() {
        InvokeDynamicSupport.bootstrap("toggle", $$robo$$android_widget_CheckedTextView$toggle(), this);
    }

    @Override
    @ViewDebug.ExportedProperty
    public boolean isChecked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isChecked", $$robo$$android_widget_CheckedTextView$isChecked(), this);
    }

    @Override
    public void setChecked(boolean bl) {
        InvokeDynamicSupport.bootstrap("setChecked", $$robo$$android_widget_CheckedTextView$setChecked(boolean ), this, bl);
    }

    public void setCheckMarkDrawable(int n) {
        InvokeDynamicSupport.bootstrap("setCheckMarkDrawable", $$robo$$android_widget_CheckedTextView$setCheckMarkDrawable(int ), this, n);
    }

    public void setCheckMarkDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setCheckMarkDrawable", $$robo$$android_widget_CheckedTextView$setCheckMarkDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    private void setCheckMarkDrawableInternal(Drawable drawable2, int n) {
        InvokeDynamicSupport.bootstrap("setCheckMarkDrawableInternal", $$robo$$android_widget_CheckedTextView$setCheckMarkDrawableInternal(android.graphics.drawable.Drawable int ), this, drawable2, n);
    }

    public void setCheckMarkTintList(ColorStateList colorStateList) {
        InvokeDynamicSupport.bootstrap("setCheckMarkTintList", $$robo$$android_widget_CheckedTextView$setCheckMarkTintList(android.content.res.ColorStateList ), this, colorStateList);
    }

    public ColorStateList getCheckMarkTintList() {
        return InvokeDynamicSupport.bootstrap("getCheckMarkTintList", $$robo$$android_widget_CheckedTextView$getCheckMarkTintList(), this);
    }

    public void setCheckMarkTintMode(PorterDuff.Mode mode) {
        InvokeDynamicSupport.bootstrap("setCheckMarkTintMode", $$robo$$android_widget_CheckedTextView$setCheckMarkTintMode(android.graphics.PorterDuff$Mode ), this, mode);
    }

    public PorterDuff.Mode getCheckMarkTintMode() {
        return InvokeDynamicSupport.bootstrap("getCheckMarkTintMode", $$robo$$android_widget_CheckedTextView$getCheckMarkTintMode(), this);
    }

    private void applyCheckMarkTint() {
        InvokeDynamicSupport.bootstrap("applyCheckMarkTint", $$robo$$android_widget_CheckedTextView$applyCheckMarkTint(), this);
    }

    @Override
    @RemotableViewMethod
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_widget_CheckedTextView$setVisibility(int ), this, n);
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        InvokeDynamicSupport.bootstrap("jumpDrawablesToCurrentState", $$robo$$android_widget_CheckedTextView$jumpDrawablesToCurrentState(), this);
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return (boolean)InvokeDynamicSupport.bootstrap("verifyDrawable", $$robo$$android_widget_CheckedTextView$verifyDrawable(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public Drawable getCheckMarkDrawable() {
        return InvokeDynamicSupport.bootstrap("getCheckMarkDrawable", $$robo$$android_widget_CheckedTextView$getCheckMarkDrawable(), this);
    }

    @Override
    protected void internalSetPadding(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("internalSetPadding", $$robo$$android_widget_CheckedTextView$internalSetPadding(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    public void onRtlPropertiesChanged(int n) {
        InvokeDynamicSupport.bootstrap("onRtlPropertiesChanged", $$robo$$android_widget_CheckedTextView$onRtlPropertiesChanged(int ), this, n);
    }

    private void updatePadding() {
        InvokeDynamicSupport.bootstrap("updatePadding", $$robo$$android_widget_CheckedTextView$updatePadding(), this);
    }

    private void setBasePadding(boolean bl) {
        InvokeDynamicSupport.bootstrap("setBasePadding", $$robo$$android_widget_CheckedTextView$setBasePadding(boolean ), this, bl);
    }

    private boolean isCheckMarkAtStart() {
        return (boolean)InvokeDynamicSupport.bootstrap("isCheckMarkAtStart", $$robo$$android_widget_CheckedTextView$isCheckMarkAtStart(), this);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_CheckedTextView$onDraw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    protected int[] onCreateDrawableState(int n) {
        return InvokeDynamicSupport.bootstrap("onCreateDrawableState", $$robo$$android_widget_CheckedTextView$onCreateDrawableState(int ), this, n);
    }

    @Override
    protected void drawableStateChanged() {
        InvokeDynamicSupport.bootstrap("drawableStateChanged", $$robo$$android_widget_CheckedTextView$drawableStateChanged(), this);
    }

    @Override
    public void drawableHotspotChanged(float f, float f2) {
        InvokeDynamicSupport.bootstrap("drawableHotspotChanged", $$robo$$android_widget_CheckedTextView$drawableHotspotChanged(float float ), this, f, f2);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_CheckedTextView$getAccessibilityClassName(), this);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_CheckedTextView$onSaveInstanceState(), this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_CheckedTextView$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEventInternal", $$robo$$android_widget_CheckedTextView$onInitializeAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_CheckedTextView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), this, accessibilityNodeInfo);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_CheckedTextView$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
    }

    static {
        RobolectricInternals.classInitializing(CheckedTextView.class);
    }

    public /* synthetic */ CheckedTextView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CheckedTextView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        boolean checked;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_CheckedTextView_SavedState$__constructor__(Parcelable superState) {
        }

        private void $$robo$$android_widget_CheckedTextView_SavedState$__constructor__(Parcel in) {
            this.checked = (Boolean)in.readValue(null);
        }

        private final void $$robo$$android_widget_CheckedTextView_SavedState$writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeValue(this.checked);
        }

        private final String $$robo$$android_widget_CheckedTextView_SavedState$toString() {
            return "CheckedTextView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " checked=" + this.checked + "}";
        }

        private /* synthetic */ void $$robo$$android_widget_CheckedTextView_SavedState$__constructor__(Parcel x0, 1 x1) {
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_CheckedTextView_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_CheckedTextView_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in, null);
                }

                private final SavedState[] $$robo$$android_widget_CheckedTextView_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_CheckedTextView_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView_SavedState_1$__constructor__(), this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_CheckedTextView_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_CheckedTextView_SavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_widget_CheckedTextView_SavedState$__constructor__(parcelable);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView_SavedState$__constructor__(android.os.Parcelable ), this, parcelable);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_CheckedTextView_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView_SavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_CheckedTextView_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_CheckedTextView_SavedState$toString(), this);
        }

        private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
            this.$$robo$$android_widget_CheckedTextView_SavedState$__constructor__(parcel, var2_2);
        }

        public /* synthetic */ SavedState(Parcel parcel, 1 var2_2) {
            this(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_CheckedTextView_SavedState$__constructor__(android.os.Parcel android.widget.CheckedTextView$1 ), this, parcel, var2_2);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

