/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.annotation.IntDef;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.icu.util.Calendar;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.format.DateUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.view.autofill.AutofillManager;
import android.view.autofill.AutofillValue;
import android.widget.CalendarView;
import android.widget.DatePickerCalendarDelegate;
import android.widget.DatePickerSpinnerDelegate;
import android.widget.FrameLayout;
import com.android.internal.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DatePicker
extends FrameLayout
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String LOG_TAG;
    public static int MODE_SPINNER = 1;
    public static int MODE_CALENDAR = 2;
    private DatePickerDelegate mDelegate;
    private int mMode;

    private void $$robo$$android_widget_DatePicker$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_DatePicker$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_DatePicker$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_DatePicker$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        if (this.getImportantForAutofill() == 0) {
            this.setImportantForAutofill(1);
        }
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyleAttr, defStyleRes);
        boolean isDialogMode = a.getBoolean(17, false);
        int requestedMode = a.getInt(16, 1);
        int firstDayOfWeek = a.getInt(3, 0);
        a.recycle();
        this.mMode = requestedMode == 2 && isDialogMode ? context.getResources().getInteger(17694908) : requestedMode;
        switch (this.mMode) {
            case 2: {
                this.mDelegate = this.createCalendarUIDelegate(context, attrs, defStyleAttr, defStyleRes);
                break;
            }
            default: {
                this.mDelegate = this.createSpinnerUIDelegate(context, attrs, defStyleAttr, defStyleRes);
            }
        }
        if (firstDayOfWeek != 0) {
            this.setFirstDayOfWeek(firstDayOfWeek);
        }
        this.mDelegate.setAutoFillChangeListener((v, y, m, d) -> {
            AutofillManager afm = context.getSystemService(AutofillManager.class);
            if (afm != null) {
                afm.notifyValueChanged(this);
            }
        });
    }

    private final DatePickerDelegate $$robo$$android_widget_DatePicker$createSpinnerUIDelegate(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        return new DatePickerSpinnerDelegate(this, context, attrs, defStyleAttr, defStyleRes);
    }

    private final DatePickerDelegate $$robo$$android_widget_DatePicker$createCalendarUIDelegate(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        return new DatePickerCalendarDelegate(this, context, attrs, defStyleAttr, defStyleRes);
    }

    private final int $$robo$$android_widget_DatePicker$getMode() {
        return this.mMode;
    }

    private final void $$robo$$android_widget_DatePicker$init(int year, int monthOfYear, int dayOfMonth, OnDateChangedListener onDateChangedListener) {
        this.mDelegate.init(year, monthOfYear, dayOfMonth, onDateChangedListener);
    }

    private final void $$robo$$android_widget_DatePicker$setOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        this.mDelegate.setOnDateChangedListener(onDateChangedListener);
    }

    private final void $$robo$$android_widget_DatePicker$updateDate(int year, int month, int dayOfMonth) {
        this.mDelegate.updateDate(year, month, dayOfMonth);
    }

    private final int $$robo$$android_widget_DatePicker$getYear() {
        return this.mDelegate.getYear();
    }

    private final int $$robo$$android_widget_DatePicker$getMonth() {
        return this.mDelegate.getMonth();
    }

    private final int $$robo$$android_widget_DatePicker$getDayOfMonth() {
        return this.mDelegate.getDayOfMonth();
    }

    private final long $$robo$$android_widget_DatePicker$getMinDate() {
        return this.mDelegate.getMinDate().getTimeInMillis();
    }

    private final void $$robo$$android_widget_DatePicker$setMinDate(long minDate) {
        this.mDelegate.setMinDate(minDate);
    }

    private final long $$robo$$android_widget_DatePicker$getMaxDate() {
        return this.mDelegate.getMaxDate().getTimeInMillis();
    }

    private final void $$robo$$android_widget_DatePicker$setMaxDate(long maxDate) {
        this.mDelegate.setMaxDate(maxDate);
    }

    private final void $$robo$$android_widget_DatePicker$setValidationCallback(ValidationCallback callback) {
        this.mDelegate.setValidationCallback(callback);
    }

    private final void $$robo$$android_widget_DatePicker$setEnabled(boolean enabled) {
        if (this.mDelegate.isEnabled() == enabled) {
            return;
        }
        super.setEnabled(enabled);
        this.mDelegate.setEnabled(enabled);
    }

    private final boolean $$robo$$android_widget_DatePicker$isEnabled() {
        return this.mDelegate.isEnabled();
    }

    private final boolean $$robo$$android_widget_DatePicker$dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        return this.mDelegate.dispatchPopulateAccessibilityEvent(event);
    }

    private final void $$robo$$android_widget_DatePicker$onPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        super.onPopulateAccessibilityEventInternal(event);
        this.mDelegate.onPopulateAccessibilityEvent(event);
    }

    private final CharSequence $$robo$$android_widget_DatePicker$getAccessibilityClassName() {
        return DatePicker.class.getName();
    }

    private final void $$robo$$android_widget_DatePicker$onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.mDelegate.onConfigurationChanged(newConfig);
    }

    private final void $$robo$$android_widget_DatePicker$setFirstDayOfWeek(int firstDayOfWeek) {
        if (firstDayOfWeek < 1 || firstDayOfWeek > 7) {
            throw new IllegalArgumentException("firstDayOfWeek must be between 1 and 7");
        }
        this.mDelegate.setFirstDayOfWeek(firstDayOfWeek);
    }

    private final int $$robo$$android_widget_DatePicker$getFirstDayOfWeek() {
        return this.mDelegate.getFirstDayOfWeek();
    }

    @Deprecated
    private final boolean $$robo$$android_widget_DatePicker$getCalendarViewShown() {
        return this.mDelegate.getCalendarViewShown();
    }

    @Deprecated
    private final CalendarView $$robo$$android_widget_DatePicker$getCalendarView() {
        return this.mDelegate.getCalendarView();
    }

    @Deprecated
    private final void $$robo$$android_widget_DatePicker$setCalendarViewShown(boolean shown) {
        this.mDelegate.setCalendarViewShown(shown);
    }

    @Deprecated
    private final boolean $$robo$$android_widget_DatePicker$getSpinnersShown() {
        return this.mDelegate.getSpinnersShown();
    }

    @Deprecated
    private final void $$robo$$android_widget_DatePicker$setSpinnersShown(boolean shown) {
        this.mDelegate.setSpinnersShown(shown);
    }

    private final void $$robo$$android_widget_DatePicker$dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    private final Parcelable $$robo$$android_widget_DatePicker$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return this.mDelegate.onSaveInstanceState(superState);
    }

    private final void $$robo$$android_widget_DatePicker$onRestoreInstanceState(Parcelable state) {
        View.BaseSavedState ss = (View.BaseSavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mDelegate.onRestoreInstanceState(ss);
    }

    private final void $$robo$$android_widget_DatePicker$dispatchProvideAutofillStructure(ViewStructure structure, int flags) {
        structure.setAutofillId(this.getAutofillId());
        this.onProvideAutofillStructure(structure, flags);
    }

    private final void $$robo$$android_widget_DatePicker$autofill(AutofillValue value) {
        if (!this.isEnabled()) {
            return;
        }
        if (!value.isDate()) {
            Log.w(LOG_TAG, value + " could not be autofilled into " + this);
            return;
        }
        this.mDelegate.updateDate(value.getDateValue());
    }

    private final int $$robo$$android_widget_DatePicker$getAutofillType() {
        return this.isEnabled() ? 4 : 0;
    }

    private final AutofillValue $$robo$$android_widget_DatePicker$getAutofillValue() {
        return this.isEnabled() ? AutofillValue.forDate(this.mDelegate.getDate()) : null;
    }

    static void __staticInitializer__() {
        LOG_TAG = DatePicker.class.getSimpleName();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_DatePicker$__constructor__(context);
    }

    public DatePicker(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_DatePicker$__constructor__(context, attributeSet);
    }

    public DatePicker(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843612);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_DatePicker$__constructor__(context, attributeSet, n);
    }

    public DatePicker(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_DatePicker$__constructor__(context, attributeSet, n, n2);
    }

    public DatePicker(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private DatePickerDelegate createSpinnerUIDelegate(Context context, AttributeSet attributeSet, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createSpinnerUIDelegate", $$robo$$android_widget_DatePicker$createSpinnerUIDelegate(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    private DatePickerDelegate createCalendarUIDelegate(Context context, AttributeSet attributeSet, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("createCalendarUIDelegate", $$robo$$android_widget_DatePicker$createCalendarUIDelegate(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    public int getMode() {
        return (int)InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_widget_DatePicker$getMode(), this);
    }

    public void init(int n, int n2, int n3, OnDateChangedListener onDateChangedListener) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_DatePicker$init(int int int android.widget.DatePicker$OnDateChangedListener ), this, n, n2, n3, onDateChangedListener);
    }

    public void setOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
        InvokeDynamicSupport.bootstrap("setOnDateChangedListener", $$robo$$android_widget_DatePicker$setOnDateChangedListener(android.widget.DatePicker$OnDateChangedListener ), this, onDateChangedListener);
    }

    public void updateDate(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("updateDate", $$robo$$android_widget_DatePicker$updateDate(int int int ), this, n, n2, n3);
    }

    public int getYear() {
        return (int)InvokeDynamicSupport.bootstrap("getYear", $$robo$$android_widget_DatePicker$getYear(), this);
    }

    public int getMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getMonth", $$robo$$android_widget_DatePicker$getMonth(), this);
    }

    public int getDayOfMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getDayOfMonth", $$robo$$android_widget_DatePicker$getDayOfMonth(), this);
    }

    public long getMinDate() {
        return (long)InvokeDynamicSupport.bootstrap("getMinDate", $$robo$$android_widget_DatePicker$getMinDate(), this);
    }

    public void setMinDate(long l) {
        InvokeDynamicSupport.bootstrap("setMinDate", $$robo$$android_widget_DatePicker$setMinDate(long ), this, l);
    }

    public long getMaxDate() {
        return (long)InvokeDynamicSupport.bootstrap("getMaxDate", $$robo$$android_widget_DatePicker$getMaxDate(), this);
    }

    public void setMaxDate(long l) {
        InvokeDynamicSupport.bootstrap("setMaxDate", $$robo$$android_widget_DatePicker$setMaxDate(long ), this, l);
    }

    public void setValidationCallback(ValidationCallback validationCallback) {
        InvokeDynamicSupport.bootstrap("setValidationCallback", $$robo$$android_widget_DatePicker$setValidationCallback(android.widget.DatePicker$ValidationCallback ), this, validationCallback);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_DatePicker$setEnabled(boolean ), this, bl);
    }

    @Override
    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_DatePicker$isEnabled(), this);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEventInternal", $$robo$$android_widget_DatePicker$dispatchPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public void onPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEventInternal", $$robo$$android_widget_DatePicker$onPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_DatePicker$getAccessibilityClassName(), this);
    }

    @Override
    protected void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_DatePicker$onConfigurationChanged(android.content.res.Configuration ), this, configuration);
    }

    public void setFirstDayOfWeek(int n) {
        InvokeDynamicSupport.bootstrap("setFirstDayOfWeek", $$robo$$android_widget_DatePicker$setFirstDayOfWeek(int ), this, n);
    }

    public int getFirstDayOfWeek() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstDayOfWeek", $$robo$$android_widget_DatePicker$getFirstDayOfWeek(), this);
    }

    @Deprecated
    public boolean getCalendarViewShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCalendarViewShown", $$robo$$android_widget_DatePicker$getCalendarViewShown(), this);
    }

    @Deprecated
    public CalendarView getCalendarView() {
        return InvokeDynamicSupport.bootstrap("getCalendarView", $$robo$$android_widget_DatePicker$getCalendarView(), this);
    }

    @Deprecated
    public void setCalendarViewShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCalendarViewShown", $$robo$$android_widget_DatePicker$setCalendarViewShown(boolean ), this, bl);
    }

    @Deprecated
    public boolean getSpinnersShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSpinnersShown", $$robo$$android_widget_DatePicker$getSpinnersShown(), this);
    }

    @Deprecated
    public void setSpinnersShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSpinnersShown", $$robo$$android_widget_DatePicker$setSpinnersShown(boolean ), this, bl);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchRestoreInstanceState", $$robo$$android_widget_DatePicker$dispatchRestoreInstanceState(android.util.SparseArray<android.os.Parcelable> ), this, sparseArray);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_DatePicker$onSaveInstanceState(), this);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_DatePicker$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    public void dispatchProvideAutofillStructure(ViewStructure viewStructure, int n) {
        InvokeDynamicSupport.bootstrap("dispatchProvideAutofillStructure", $$robo$$android_widget_DatePicker$dispatchProvideAutofillStructure(android.view.ViewStructure int ), this, viewStructure, n);
    }

    @Override
    public void autofill(AutofillValue autofillValue) {
        InvokeDynamicSupport.bootstrap("autofill", $$robo$$android_widget_DatePicker$autofill(android.view.autofill.AutofillValue ), this, autofillValue);
    }

    @Override
    public int getAutofillType() {
        return (int)InvokeDynamicSupport.bootstrap("getAutofillType", $$robo$$android_widget_DatePicker$getAutofillType(), this);
    }

    @Override
    public AutofillValue getAutofillValue() {
        return InvokeDynamicSupport.bootstrap("getAutofillValue", $$robo$$android_widget_DatePicker$getAutofillValue(), this);
    }

    static {
        RobolectricInternals.classInitializing(DatePicker.class);
    }

    public /* synthetic */ DatePicker() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DatePicker)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ValidationCallback
    extends InstrumentedInterface {
        public void onValidationChanged(boolean var1);
    }

    public static abstract class AbstractDatePickerDelegate
    implements DatePickerDelegate,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        protected DatePicker mDelegator;
        protected Context mContext;
        protected Calendar mCurrentDate;
        protected Locale mCurrentLocale;
        protected OnDateChangedListener mOnDateChangedListener;
        protected OnDateChangedListener mAutoFillChangeListener;
        protected ValidationCallback mValidationCallback;

        private void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$__constructor__(DatePicker delegator, Context context) {
            this.mDelegator = delegator;
            this.mContext = context;
            this.setCurrentLocale(Locale.getDefault());
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setCurrentLocale(Locale locale) {
            if (!locale.equals(this.mCurrentLocale)) {
                this.mCurrentLocale = locale;
                this.onLocaleChanged(locale);
            }
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setOnDateChangedListener(OnDateChangedListener callback) {
            this.mOnDateChangedListener = callback;
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setAutoFillChangeListener(OnDateChangedListener callback) {
            this.mAutoFillChangeListener = callback;
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setValidationCallback(ValidationCallback callback) {
            this.mValidationCallback = callback;
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$updateDate(long date) {
            Calendar cal = Calendar.getInstance(this.mCurrentLocale);
            cal.setTimeInMillis(date);
            this.updateDate(cal.get(1), cal.get(2), cal.get(5));
        }

        private final long $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$getDate() {
            return this.mCurrentDate.getTimeInMillis();
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$onValidationChanged(boolean valid) {
            if (this.mValidationCallback != null) {
                this.mValidationCallback.onValidationChanged(valid);
            }
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$onLocaleChanged(Locale locale) {
        }

        private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$onPopulateAccessibilityEvent(AccessibilityEvent event) {
            event.getText().add(this.getFormattedCurrentDate());
        }

        private final String $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$getFormattedCurrentDate() {
            return DateUtils.formatDateTime(this.mContext, this.mCurrentDate.getTimeInMillis(), 22);
        }

        private void __constructor__(DatePicker datePicker, Context context) {
            this.$$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$__constructor__(datePicker, context);
        }

        public AbstractDatePickerDelegate(DatePicker datePicker, Context context) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$__constructor__(android.widget.DatePicker android.content.Context ), this, datePicker, context);
        }

        protected void setCurrentLocale(Locale locale) {
            InvokeDynamicSupport.bootstrap("setCurrentLocale", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setCurrentLocale(java.util.Locale ), this, locale);
        }

        @Override
        public void setOnDateChangedListener(OnDateChangedListener onDateChangedListener) {
            InvokeDynamicSupport.bootstrap("setOnDateChangedListener", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setOnDateChangedListener(android.widget.DatePicker$OnDateChangedListener ), this, onDateChangedListener);
        }

        @Override
        public void setAutoFillChangeListener(OnDateChangedListener onDateChangedListener) {
            InvokeDynamicSupport.bootstrap("setAutoFillChangeListener", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setAutoFillChangeListener(android.widget.DatePicker$OnDateChangedListener ), this, onDateChangedListener);
        }

        @Override
        public void setValidationCallback(ValidationCallback validationCallback) {
            InvokeDynamicSupport.bootstrap("setValidationCallback", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$setValidationCallback(android.widget.DatePicker$ValidationCallback ), this, validationCallback);
        }

        @Override
        public void updateDate(long l) {
            InvokeDynamicSupport.bootstrap("updateDate", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$updateDate(long ), this, l);
        }

        @Override
        public long getDate() {
            return (long)InvokeDynamicSupport.bootstrap("getDate", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$getDate(), this);
        }

        protected void onValidationChanged(boolean bl) {
            InvokeDynamicSupport.bootstrap("onValidationChanged", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$onValidationChanged(boolean ), this, bl);
        }

        protected void onLocaleChanged(Locale locale) {
            InvokeDynamicSupport.bootstrap("onLocaleChanged", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$onLocaleChanged(java.util.Locale ), this, locale);
        }

        @Override
        public void onPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onPopulateAccessibilityEvent", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$onPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
        }

        protected String getFormattedCurrentDate() {
            return InvokeDynamicSupport.bootstrap("getFormattedCurrentDate", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate$getFormattedCurrentDate(), this);
        }

        public /* synthetic */ AbstractDatePickerDelegate() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbstractDatePickerDelegate)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        public static class SavedState
        extends View.BaseSavedState
        implements ShadowedObject {
            public /* synthetic */ Object __robo_data__;
            private int mSelectedYear;
            private int mSelectedMonth;
            private int mSelectedDay;
            private long mMinDate;
            private long mMaxDate;
            private int mCurrentView;
            private int mListPosition;
            private int mListPositionOffset;
            public static Parcelable.Creator<SavedState> CREATOR;

            private void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(Parcelable superState, int year, int month, int day, long minDate, long maxDate) {
            }

            private void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(Parcelable superState, int year, int month, int day, long minDate, long maxDate, int currentView, int listPosition, int listPositionOffset) {
                this.mSelectedYear = year;
                this.mSelectedMonth = month;
                this.mSelectedDay = day;
                this.mMinDate = minDate;
                this.mMaxDate = maxDate;
                this.mCurrentView = currentView;
                this.mListPosition = listPosition;
                this.mListPositionOffset = listPositionOffset;
            }

            private void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(Parcel in) {
                this.mSelectedYear = in.readInt();
                this.mSelectedMonth = in.readInt();
                this.mSelectedDay = in.readInt();
                this.mMinDate = in.readLong();
                this.mMaxDate = in.readLong();
                this.mCurrentView = in.readInt();
                this.mListPosition = in.readInt();
                this.mListPositionOffset = in.readInt();
            }

            private final void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$writeToParcel(Parcel dest, int flags) {
                super.writeToParcel(dest, flags);
                dest.writeInt(this.mSelectedYear);
                dest.writeInt(this.mSelectedMonth);
                dest.writeInt(this.mSelectedDay);
                dest.writeLong(this.mMinDate);
                dest.writeLong(this.mMaxDate);
                dest.writeInt(this.mCurrentView);
                dest.writeInt(this.mListPosition);
                dest.writeInt(this.mListPositionOffset);
            }

            private final int $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getSelectedDay() {
                return this.mSelectedDay;
            }

            private final int $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getSelectedMonth() {
                return this.mSelectedMonth;
            }

            private final int $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getSelectedYear() {
                return this.mSelectedYear;
            }

            private final long $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getMinDate() {
                return this.mMinDate;
            }

            private final long $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getMaxDate() {
                return this.mMaxDate;
            }

            private final int $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getCurrentView() {
                return this.mCurrentView;
            }

            private final int $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getListPosition() {
                return this.mListPosition;
            }

            private final int $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getListPositionOffset() {
                return this.mListPositionOffset;
            }

            private /* synthetic */ void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(Parcel x0, 1 x1) {
            }

            static void __staticInitializer__() {
                CREATOR = new Parcelable.Creator<SavedState>(){
                    public /* synthetic */ Object __robo_data__;

                    private void $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState_1$__constructor__() {
                    }

                    private final SavedState $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState_1$createFromParcel(Parcel in) {
                        return new SavedState(in, null);
                    }

                    private final SavedState[] $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState_1$newArray(int size) {
                        return new SavedState[size];
                    }

                    private void __constructor__() {
                        this.$$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState_1$__constructor__();
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState_1$__constructor__(), this);
                    }

                    @Override
                    public SavedState createFromParcel(Parcel parcel) {
                        return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                    }

                    public SavedState[] newArray(int n) {
                        return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState_1$newArray(int ), this, n);
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                };
            }

            private void __constructor__(Parcelable parcelable, int n, int n2, int n3, long l, long l2) {
                this.$$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(parcelable, n, n2, n3, l, l2);
            }

            public SavedState(Parcelable parcelable, int n, int n2, int n3, long l, long l2) {
                this(parcelable, n, n2, n3, l, l2, 0, 0, 0);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(android.os.Parcelable int int int long long ), this, parcelable, n, n2, n3, l, l2);
            }

            private void __constructor__(Parcelable parcelable, int n, int n2, int n3, long l, long l2, int n4, int n5, int n6) {
                this.$$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(parcelable, n, n2, n3, l, l2, n4, n5, n6);
            }

            public SavedState(Parcelable parcelable, int n, int n2, int n3, long l, long l2, int n4, int n5, int n6) {
                super(parcelable);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(android.os.Parcelable int int int long long int int int ), this, parcelable, n, n2, n3, l, l2, n4, n5, n6);
            }

            private void __constructor__(Parcel parcel) {
                this.$$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(parcel);
            }

            public SavedState(Parcel parcel) {
                super(parcel);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(android.os.Parcel ), this, parcel);
            }

            @Override
            public void writeToParcel(Parcel parcel, int n) {
                InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
            }

            public int getSelectedDay() {
                return (int)InvokeDynamicSupport.bootstrap("getSelectedDay", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getSelectedDay(), this);
            }

            public int getSelectedMonth() {
                return (int)InvokeDynamicSupport.bootstrap("getSelectedMonth", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getSelectedMonth(), this);
            }

            public int getSelectedYear() {
                return (int)InvokeDynamicSupport.bootstrap("getSelectedYear", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getSelectedYear(), this);
            }

            public long getMinDate() {
                return (long)InvokeDynamicSupport.bootstrap("getMinDate", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getMinDate(), this);
            }

            public long getMaxDate() {
                return (long)InvokeDynamicSupport.bootstrap("getMaxDate", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getMaxDate(), this);
            }

            public int getCurrentView() {
                return (int)InvokeDynamicSupport.bootstrap("getCurrentView", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getCurrentView(), this);
            }

            public int getListPosition() {
                return (int)InvokeDynamicSupport.bootstrap("getListPosition", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getListPosition(), this);
            }

            public int getListPositionOffset() {
                return (int)InvokeDynamicSupport.bootstrap("getListPositionOffset", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$getListPositionOffset(), this);
            }

            private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
                this.$$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(parcel, var2_2);
            }

            public /* synthetic */ SavedState(Parcel parcel, 1 var2_2) {
                this(parcel);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePicker_AbstractDatePickerDelegate_SavedState$__constructor__(android.os.Parcel android.widget.DatePicker$1 ), this, parcel, var2_2);
            }

            static {
                RobolectricInternals.classInitializing(SavedState.class);
            }

            public /* synthetic */ SavedState() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    static interface DatePickerDelegate
    extends InstrumentedInterface {
        public void init(int var1, int var2, int var3, OnDateChangedListener var4);

        public void setOnDateChangedListener(OnDateChangedListener var1);

        public void setAutoFillChangeListener(OnDateChangedListener var1);

        public void updateDate(int var1, int var2, int var3);

        public void updateDate(long var1);

        public int getYear();

        public int getMonth();

        public int getDayOfMonth();

        public long getDate();

        public void setFirstDayOfWeek(int var1);

        public int getFirstDayOfWeek();

        public void setMinDate(long var1);

        public Calendar getMinDate();

        public void setMaxDate(long var1);

        public Calendar getMaxDate();

        public void setEnabled(boolean var1);

        public boolean isEnabled();

        public CalendarView getCalendarView();

        public void setCalendarViewShown(boolean var1);

        public boolean getCalendarViewShown();

        public void setSpinnersShown(boolean var1);

        public boolean getSpinnersShown();

        public void setValidationCallback(ValidationCallback var1);

        public void onConfigurationChanged(Configuration var1);

        public Parcelable onSaveInstanceState(Parcelable var1);

        public void onRestoreInstanceState(Parcelable var1);

        public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent var1);

        public void onPopulateAccessibilityEvent(AccessibilityEvent var1);
    }

    public static interface OnDateChangedListener
    extends InstrumentedInterface {
        public void onDateChanged(DatePicker var1, int var2, int var3, int var4);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={1L, 2L})
    public static @interface DatePickerMode {
    }
}

