/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.icu.util.Calendar;
import android.os.Parcelable;
import android.text.TextUtils;
import android.text.format.DateFormat;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import android.view.inputmethod.InputMethodManager;
import android.widget.CalendarView;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.NumberPicker;
import android.widget.TextView;
import com.android.internal.R;
import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import libcore.icu.ICU;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class DatePickerSpinnerDelegate
extends DatePicker.AbstractDatePickerDelegate
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String DATE_FORMAT = "MM/dd/yyyy";
    private static int DEFAULT_START_YEAR = 1900;
    private static int DEFAULT_END_YEAR = 2100;
    private static boolean DEFAULT_CALENDAR_VIEW_SHOWN = true;
    private static boolean DEFAULT_SPINNERS_SHOWN = true;
    private static boolean DEFAULT_ENABLED_STATE = true;
    private LinearLayout mSpinners;
    private NumberPicker mDaySpinner;
    private NumberPicker mMonthSpinner;
    private NumberPicker mYearSpinner;
    private EditText mDaySpinnerInput;
    private EditText mMonthSpinnerInput;
    private EditText mYearSpinnerInput;
    private CalendarView mCalendarView;
    private String[] mShortMonths;
    private java.text.DateFormat mDateFormat;
    private int mNumberOfMonths;
    private Calendar mTempDate;
    private Calendar mMinDate;
    private Calendar mMaxDate;
    private boolean mIsEnabled;

    private void $$robo$$android_widget_DatePickerSpinnerDelegate$__constructor__(DatePicker delegator, Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mDateFormat = new SimpleDateFormat("MM/dd/yyyy");
        this.mIsEnabled = true;
        this.mDelegator = delegator;
        this.mContext = context;
        this.setCurrentLocale(Locale.getDefault());
        TypedArray attributesArray = context.obtainStyledAttributes(attrs, R.styleable.DatePicker, defStyleAttr, defStyleRes);
        boolean spinnersShown = attributesArray.getBoolean(6, true);
        boolean calendarViewShown = attributesArray.getBoolean(7, true);
        int startYear = attributesArray.getInt(1, 1900);
        int endYear = attributesArray.getInt(2, 2100);
        String minDate = attributesArray.getString(4);
        String maxDate = attributesArray.getString(5);
        int layoutResourceId = attributesArray.getResourceId(20, 17367116);
        attributesArray.recycle();
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(layoutResourceId, (ViewGroup)this.mDelegator, true);
        view.setSaveFromParentEnabled(false);
        NumberPicker.OnValueChangeListener onChangeListener = new NumberPicker.OnValueChangeListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ DatePickerSpinnerDelegate this$0;

            private void $$robo$$android_widget_DatePickerSpinnerDelegate_1$__constructor__(DatePickerSpinnerDelegate this$0) {
            }

            private final void $$robo$$android_widget_DatePickerSpinnerDelegate_1$onValueChange(NumberPicker picker, int oldVal, int newVal) {
                this.this$0.updateInputState();
                this.this$0.mTempDate.setTimeInMillis(this.this$0.mCurrentDate.getTimeInMillis());
                if (picker == this.this$0.mDaySpinner) {
                    int maxDayOfMonth = this.this$0.mTempDate.getActualMaximum(5);
                    if (oldVal == maxDayOfMonth && newVal == 1) {
                        this.this$0.mTempDate.add(5, 1);
                    } else if (oldVal == 1 && newVal == maxDayOfMonth) {
                        this.this$0.mTempDate.add(5, -1);
                    } else {
                        this.this$0.mTempDate.add(5, newVal - oldVal);
                    }
                } else if (picker == this.this$0.mMonthSpinner) {
                    if (oldVal == 11 && newVal == 0) {
                        this.this$0.mTempDate.add(2, 1);
                    } else if (oldVal == 0 && newVal == 11) {
                        this.this$0.mTempDate.add(2, -1);
                    } else {
                        this.this$0.mTempDate.add(2, newVal - oldVal);
                    }
                } else if (picker == this.this$0.mYearSpinner) {
                    this.this$0.mTempDate.set(1, newVal);
                } else {
                    throw new IllegalArgumentException();
                }
                this.this$0.setDate(this.this$0.mTempDate.get(1), this.this$0.mTempDate.get(2), this.this$0.mTempDate.get(5));
                this.this$0.updateSpinners();
                this.this$0.updateCalendarView();
                this.this$0.notifyDateChanged();
            }

            private void __constructor__(DatePickerSpinnerDelegate datePickerSpinnerDelegate) {
                this.$$robo$$android_widget_DatePickerSpinnerDelegate_1$__constructor__(datePickerSpinnerDelegate);
            }
            {
                this.this$0 = datePickerSpinnerDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePickerSpinnerDelegate_1$__constructor__(android.widget.DatePickerSpinnerDelegate ), this, datePickerSpinnerDelegate);
            }

            @Override
            public void onValueChange(NumberPicker numberPicker, int n, int n2) {
                InvokeDynamicSupport.bootstrap("onValueChange", $$robo$$android_widget_DatePickerSpinnerDelegate_1$onValueChange(android.widget.NumberPicker int int ), this, numberPicker, n, n2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mSpinners = (LinearLayout)this.mDelegator.findViewById(16909150);
        this.mCalendarView = (CalendarView)this.mDelegator.findViewById(16908769);
        this.mCalendarView.setOnDateChangeListener(new CalendarView.OnDateChangeListener(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ DatePickerSpinnerDelegate this$0;

            private void $$robo$$android_widget_DatePickerSpinnerDelegate_2$__constructor__(DatePickerSpinnerDelegate this$0) {
            }

            private final void $$robo$$android_widget_DatePickerSpinnerDelegate_2$onSelectedDayChange(CalendarView view, int year, int month, int monthDay) {
                this.this$0.setDate(year, month, monthDay);
                this.this$0.updateSpinners();
                this.this$0.notifyDateChanged();
            }

            private void __constructor__(DatePickerSpinnerDelegate datePickerSpinnerDelegate) {
                this.$$robo$$android_widget_DatePickerSpinnerDelegate_2$__constructor__(datePickerSpinnerDelegate);
            }
            {
                this.this$0 = datePickerSpinnerDelegate;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePickerSpinnerDelegate_2$__constructor__(android.widget.DatePickerSpinnerDelegate ), this, datePickerSpinnerDelegate);
            }

            @Override
            public void onSelectedDayChange(CalendarView calendarView, int n, int n2, int n3) {
                InvokeDynamicSupport.bootstrap("onSelectedDayChange", $$robo$$android_widget_DatePickerSpinnerDelegate_2$onSelectedDayChange(android.widget.CalendarView int int int ), this, calendarView, n, n2, n3);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.mDaySpinner = (NumberPicker)this.mDelegator.findViewById(0x1020212);
        this.mDaySpinner.setFormatter(NumberPicker.getTwoDigitFormatter());
        this.mDaySpinner.setOnLongPressUpdateInterval(100L);
        this.mDaySpinner.setOnValueChangedListener(onChangeListener);
        this.mDaySpinnerInput = (EditText)this.mDaySpinner.findViewById(16909104);
        this.mMonthSpinner = (NumberPicker)this.mDelegator.findViewById(16909057);
        this.mMonthSpinner.setMinValue(0);
        this.mMonthSpinner.setMaxValue(this.mNumberOfMonths - 1);
        this.mMonthSpinner.setDisplayedValues(this.mShortMonths);
        this.mMonthSpinner.setOnLongPressUpdateInterval(200L);
        this.mMonthSpinner.setOnValueChangedListener(onChangeListener);
        this.mMonthSpinnerInput = (EditText)this.mMonthSpinner.findViewById(16909104);
        this.mYearSpinner = (NumberPicker)this.mDelegator.findViewById(16909468);
        this.mYearSpinner.setOnLongPressUpdateInterval(100L);
        this.mYearSpinner.setOnValueChangedListener(onChangeListener);
        this.mYearSpinnerInput = (EditText)this.mYearSpinner.findViewById(16909104);
        if (!spinnersShown && !calendarViewShown) {
            this.setSpinnersShown(true);
        } else {
            this.setSpinnersShown(spinnersShown);
            this.setCalendarViewShown(calendarViewShown);
        }
        this.mTempDate.clear();
        if (!TextUtils.isEmpty(minDate)) {
            if (!this.parseDate(minDate, this.mTempDate)) {
                this.mTempDate.set(startYear, 0, 1);
            }
        } else {
            this.mTempDate.set(startYear, 0, 1);
        }
        this.setMinDate(this.mTempDate.getTimeInMillis());
        this.mTempDate.clear();
        if (!TextUtils.isEmpty(maxDate)) {
            if (!this.parseDate(maxDate, this.mTempDate)) {
                this.mTempDate.set(endYear, 11, 31);
            }
        } else {
            this.mTempDate.set(endYear, 11, 31);
        }
        this.setMaxDate(this.mTempDate.getTimeInMillis());
        this.mCurrentDate.setTimeInMillis((long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"));
        this.init(this.mCurrentDate.get(1), this.mCurrentDate.get(2), this.mCurrentDate.get(5), null);
        this.reorderSpinners();
        this.setContentDescriptions();
        if (this.mDelegator.getImportantForAccessibility() == 0) {
            this.mDelegator.setImportantForAccessibility(1);
        }
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$init(int year, int monthOfYear, int dayOfMonth, DatePicker.OnDateChangedListener onDateChangedListener) {
        this.setDate(year, monthOfYear, dayOfMonth);
        this.updateSpinners();
        this.updateCalendarView();
        this.mOnDateChangedListener = onDateChangedListener;
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$updateDate(int year, int month, int dayOfMonth) {
        if (!this.isNewDate(year, month, dayOfMonth)) {
            return;
        }
        this.setDate(year, month, dayOfMonth);
        this.updateSpinners();
        this.updateCalendarView();
        this.notifyDateChanged();
    }

    private final int $$robo$$android_widget_DatePickerSpinnerDelegate$getYear() {
        return this.mCurrentDate.get(1);
    }

    private final int $$robo$$android_widget_DatePickerSpinnerDelegate$getMonth() {
        return this.mCurrentDate.get(2);
    }

    private final int $$robo$$android_widget_DatePickerSpinnerDelegate$getDayOfMonth() {
        return this.mCurrentDate.get(5);
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$setFirstDayOfWeek(int firstDayOfWeek) {
        this.mCalendarView.setFirstDayOfWeek(firstDayOfWeek);
    }

    private final int $$robo$$android_widget_DatePickerSpinnerDelegate$getFirstDayOfWeek() {
        return this.mCalendarView.getFirstDayOfWeek();
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$setMinDate(long minDate) {
        this.mTempDate.setTimeInMillis(minDate);
        if (this.mTempDate.get(1) == this.mMinDate.get(1) && this.mTempDate.get(6) == this.mMinDate.get(6)) {
            return;
        }
        this.mMinDate.setTimeInMillis(minDate);
        this.mCalendarView.setMinDate(minDate);
        if (this.mCurrentDate.before(this.mMinDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
            this.updateCalendarView();
        }
        this.updateSpinners();
    }

    private final Calendar $$robo$$android_widget_DatePickerSpinnerDelegate$getMinDate() {
        Calendar minDate = Calendar.getInstance();
        minDate.setTimeInMillis(this.mCalendarView.getMinDate());
        return minDate;
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$setMaxDate(long maxDate) {
        this.mTempDate.setTimeInMillis(maxDate);
        if (this.mTempDate.get(1) == this.mMaxDate.get(1) && this.mTempDate.get(6) == this.mMaxDate.get(6)) {
            return;
        }
        this.mMaxDate.setTimeInMillis(maxDate);
        this.mCalendarView.setMaxDate(maxDate);
        if (this.mCurrentDate.after(this.mMaxDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
            this.updateCalendarView();
        }
        this.updateSpinners();
    }

    private final Calendar $$robo$$android_widget_DatePickerSpinnerDelegate$getMaxDate() {
        Calendar maxDate = Calendar.getInstance();
        maxDate.setTimeInMillis(this.mCalendarView.getMaxDate());
        return maxDate;
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$setEnabled(boolean enabled) {
        this.mDaySpinner.setEnabled(enabled);
        this.mMonthSpinner.setEnabled(enabled);
        this.mYearSpinner.setEnabled(enabled);
        this.mCalendarView.setEnabled(enabled);
        this.mIsEnabled = enabled;
    }

    private final boolean $$robo$$android_widget_DatePickerSpinnerDelegate$isEnabled() {
        return this.mIsEnabled;
    }

    private final CalendarView $$robo$$android_widget_DatePickerSpinnerDelegate$getCalendarView() {
        return this.mCalendarView;
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$setCalendarViewShown(boolean shown) {
        this.mCalendarView.setVisibility(shown ? 0 : 8);
    }

    private final boolean $$robo$$android_widget_DatePickerSpinnerDelegate$getCalendarViewShown() {
        return this.mCalendarView.getVisibility() == 0;
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$setSpinnersShown(boolean shown) {
        this.mSpinners.setVisibility(shown ? 0 : 8);
    }

    private final boolean $$robo$$android_widget_DatePickerSpinnerDelegate$getSpinnersShown() {
        return this.mSpinners.isShown();
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$onConfigurationChanged(Configuration newConfig) {
        this.setCurrentLocale(newConfig.locale);
    }

    private final Parcelable $$robo$$android_widget_DatePickerSpinnerDelegate$onSaveInstanceState(Parcelable superState) {
        return new DatePicker.AbstractDatePickerDelegate.SavedState(superState, this.getYear(), this.getMonth(), this.getDayOfMonth(), this.getMinDate().getTimeInMillis(), this.getMaxDate().getTimeInMillis());
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$onRestoreInstanceState(Parcelable state) {
        if (state instanceof DatePicker.AbstractDatePickerDelegate.SavedState) {
            DatePicker.AbstractDatePickerDelegate.SavedState ss = (DatePicker.AbstractDatePickerDelegate.SavedState)state;
            this.setDate(ss.getSelectedYear(), ss.getSelectedMonth(), ss.getSelectedDay());
            this.updateSpinners();
            this.updateCalendarView();
        }
    }

    private final boolean $$robo$$android_widget_DatePickerSpinnerDelegate$dispatchPopulateAccessibilityEvent(AccessibilityEvent event) {
        this.onPopulateAccessibilityEvent(event);
        return true;
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$setCurrentLocale(Locale locale) {
        super.setCurrentLocale(locale);
        this.mTempDate = this.getCalendarForLocale(this.mTempDate, locale);
        this.mMinDate = this.getCalendarForLocale(this.mMinDate, locale);
        this.mMaxDate = this.getCalendarForLocale(this.mMaxDate, locale);
        this.mCurrentDate = this.getCalendarForLocale(this.mCurrentDate, locale);
        this.mNumberOfMonths = this.mTempDate.getActualMaximum(2) + 1;
        this.mShortMonths = new DateFormatSymbols().getShortMonths();
        if (this.usingNumericMonths()) {
            this.mShortMonths = new String[this.mNumberOfMonths];
            for (int i = 0; i < this.mNumberOfMonths; ++i) {
                this.mShortMonths[i] = String.format("%d", i + 1);
            }
        }
    }

    private final boolean $$robo$$android_widget_DatePickerSpinnerDelegate$usingNumericMonths() {
        return Character.isDigit(this.mShortMonths[0].charAt(0));
    }

    private final Calendar $$robo$$android_widget_DatePickerSpinnerDelegate$getCalendarForLocale(Calendar oldCalendar, Locale locale) {
        if (oldCalendar == null) {
            return Calendar.getInstance(locale);
        }
        long currentTimeMillis = oldCalendar.getTimeInMillis();
        Calendar newCalendar = Calendar.getInstance(locale);
        newCalendar.setTimeInMillis(currentTimeMillis);
        return newCalendar;
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$reorderSpinners() {
        this.mSpinners.removeAllViews();
        String pattern = DateFormat.getBestDateTimePattern(Locale.getDefault(), "yyyyMMMdd");
        char[] order = ICU.getDateFormatOrder(pattern);
        int spinnerCount = order.length;
        block5: for (int i = 0; i < spinnerCount; ++i) {
            switch (order[i]) {
                case 'd': {
                    this.mSpinners.addView(this.mDaySpinner);
                    this.setImeOptions(this.mDaySpinner, spinnerCount, i);
                    continue block5;
                }
                case 'M': {
                    this.mSpinners.addView(this.mMonthSpinner);
                    this.setImeOptions(this.mMonthSpinner, spinnerCount, i);
                    continue block5;
                }
                case 'y': {
                    this.mSpinners.addView(this.mYearSpinner);
                    this.setImeOptions(this.mYearSpinner, spinnerCount, i);
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException(Arrays.toString(order));
                }
            }
        }
    }

    private final boolean $$robo$$android_widget_DatePickerSpinnerDelegate$parseDate(String date, Calendar outDate) {
        try {
            outDate.setTime(this.mDateFormat.parse(date));
            return true;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
    }

    private final boolean $$robo$$android_widget_DatePickerSpinnerDelegate$isNewDate(int year, int month, int dayOfMonth) {
        return this.mCurrentDate.get(1) != year || this.mCurrentDate.get(2) != month || this.mCurrentDate.get(5) != dayOfMonth;
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$setDate(int year, int month, int dayOfMonth) {
        this.mCurrentDate.set(year, month, dayOfMonth);
        if (this.mCurrentDate.before(this.mMinDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMinDate.getTimeInMillis());
        } else if (this.mCurrentDate.after(this.mMaxDate)) {
            this.mCurrentDate.setTimeInMillis(this.mMaxDate.getTimeInMillis());
        }
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$updateSpinners() {
        if (this.mCurrentDate.equals(this.mMinDate)) {
            this.mDaySpinner.setMinValue(this.mCurrentDate.get(5));
            this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
            this.mDaySpinner.setWrapSelectorWheel(false);
            this.mMonthSpinner.setDisplayedValues(null);
            this.mMonthSpinner.setMinValue(this.mCurrentDate.get(2));
            this.mMonthSpinner.setMaxValue(this.mCurrentDate.getActualMaximum(2));
            this.mMonthSpinner.setWrapSelectorWheel(false);
        } else if (this.mCurrentDate.equals(this.mMaxDate)) {
            this.mDaySpinner.setMinValue(this.mCurrentDate.getActualMinimum(5));
            this.mDaySpinner.setMaxValue(this.mCurrentDate.get(5));
            this.mDaySpinner.setWrapSelectorWheel(false);
            this.mMonthSpinner.setDisplayedValues(null);
            this.mMonthSpinner.setMinValue(this.mCurrentDate.getActualMinimum(2));
            this.mMonthSpinner.setMaxValue(this.mCurrentDate.get(2));
            this.mMonthSpinner.setWrapSelectorWheel(false);
        } else {
            this.mDaySpinner.setMinValue(1);
            this.mDaySpinner.setMaxValue(this.mCurrentDate.getActualMaximum(5));
            this.mDaySpinner.setWrapSelectorWheel(true);
            this.mMonthSpinner.setDisplayedValues(null);
            this.mMonthSpinner.setMinValue(0);
            this.mMonthSpinner.setMaxValue(11);
            this.mMonthSpinner.setWrapSelectorWheel(true);
        }
        String[] displayedValues = Arrays.copyOfRange(this.mShortMonths, this.mMonthSpinner.getMinValue(), this.mMonthSpinner.getMaxValue() + 1);
        this.mMonthSpinner.setDisplayedValues(displayedValues);
        this.mYearSpinner.setMinValue(this.mMinDate.get(1));
        this.mYearSpinner.setMaxValue(this.mMaxDate.get(1));
        this.mYearSpinner.setWrapSelectorWheel(false);
        this.mYearSpinner.setValue(this.mCurrentDate.get(1));
        this.mMonthSpinner.setValue(this.mCurrentDate.get(2));
        this.mDaySpinner.setValue(this.mCurrentDate.get(5));
        if (this.usingNumericMonths()) {
            this.mMonthSpinnerInput.setRawInputType(2);
        }
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$updateCalendarView() {
        this.mCalendarView.setDate(this.mCurrentDate.getTimeInMillis(), false, false);
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$notifyDateChanged() {
        this.mDelegator.sendAccessibilityEvent(4);
        if (this.mOnDateChangedListener != null) {
            this.mOnDateChangedListener.onDateChanged(this.mDelegator, this.getYear(), this.getMonth(), this.getDayOfMonth());
        }
        if (this.mAutoFillChangeListener != null) {
            this.mAutoFillChangeListener.onDateChanged(this.mDelegator, this.getYear(), this.getMonth(), this.getDayOfMonth());
        }
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$setImeOptions(NumberPicker spinner, int spinnerCount, int spinnerIndex) {
        int imeOptions = spinnerIndex < spinnerCount - 1 ? 5 : 6;
        TextView input = (TextView)spinner.findViewById(16909104);
        input.setImeOptions(imeOptions);
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$setContentDescriptions() {
        this.trySetContentDescription(this.mDaySpinner, 16908957, 17039724);
        this.trySetContentDescription(this.mDaySpinner, 16908823, 17039720);
        this.trySetContentDescription(this.mMonthSpinner, 16908957, 17039725);
        this.trySetContentDescription(this.mMonthSpinner, 16908823, 17039721);
        this.trySetContentDescription(this.mYearSpinner, 16908957, 17039726);
        this.trySetContentDescription(this.mYearSpinner, 16908823, 17039722);
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$trySetContentDescription(View root, int viewId, int contDescResId) {
        Object target = root.findViewById(viewId);
        if (target != null) {
            ((View)target).setContentDescription(this.mContext.getString(contDescResId));
        }
    }

    private final void $$robo$$android_widget_DatePickerSpinnerDelegate$updateInputState() {
        InputMethodManager inputMethodManager = InputMethodManager.peekInstance();
        if (inputMethodManager != null) {
            if (inputMethodManager.isActive(this.mYearSpinnerInput)) {
                this.mYearSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mMonthSpinnerInput)) {
                this.mMonthSpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            } else if (inputMethodManager.isActive(this.mDaySpinnerInput)) {
                this.mDaySpinnerInput.clearFocus();
                inputMethodManager.hideSoftInputFromWindow(this.mDelegator.getWindowToken(), 0);
            }
        }
    }

    private void __constructor__(DatePicker datePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_DatePickerSpinnerDelegate$__constructor__(datePicker, context, attributeSet, n, n2);
    }

    public DatePickerSpinnerDelegate(DatePicker datePicker, Context context, AttributeSet attributeSet, int n, int n2) {
        super(datePicker, context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_DatePickerSpinnerDelegate$__constructor__(android.widget.DatePicker android.content.Context android.util.AttributeSet int int ), this, datePicker, context, attributeSet, n, n2);
    }

    @Override
    public void init(int n, int n2, int n3, DatePicker.OnDateChangedListener onDateChangedListener) {
        InvokeDynamicSupport.bootstrap("init", $$robo$$android_widget_DatePickerSpinnerDelegate$init(int int int android.widget.DatePicker$OnDateChangedListener ), this, n, n2, n3, onDateChangedListener);
    }

    @Override
    public void updateDate(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("updateDate", $$robo$$android_widget_DatePickerSpinnerDelegate$updateDate(int int int ), this, n, n2, n3);
    }

    @Override
    public int getYear() {
        return (int)InvokeDynamicSupport.bootstrap("getYear", $$robo$$android_widget_DatePickerSpinnerDelegate$getYear(), this);
    }

    @Override
    public int getMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getMonth", $$robo$$android_widget_DatePickerSpinnerDelegate$getMonth(), this);
    }

    @Override
    public int getDayOfMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getDayOfMonth", $$robo$$android_widget_DatePickerSpinnerDelegate$getDayOfMonth(), this);
    }

    @Override
    public void setFirstDayOfWeek(int n) {
        InvokeDynamicSupport.bootstrap("setFirstDayOfWeek", $$robo$$android_widget_DatePickerSpinnerDelegate$setFirstDayOfWeek(int ), this, n);
    }

    @Override
    public int getFirstDayOfWeek() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstDayOfWeek", $$robo$$android_widget_DatePickerSpinnerDelegate$getFirstDayOfWeek(), this);
    }

    @Override
    public void setMinDate(long l) {
        InvokeDynamicSupport.bootstrap("setMinDate", $$robo$$android_widget_DatePickerSpinnerDelegate$setMinDate(long ), this, l);
    }

    @Override
    public Calendar getMinDate() {
        return InvokeDynamicSupport.bootstrap("getMinDate", $$robo$$android_widget_DatePickerSpinnerDelegate$getMinDate(), this);
    }

    @Override
    public void setMaxDate(long l) {
        InvokeDynamicSupport.bootstrap("setMaxDate", $$robo$$android_widget_DatePickerSpinnerDelegate$setMaxDate(long ), this, l);
    }

    @Override
    public Calendar getMaxDate() {
        return InvokeDynamicSupport.bootstrap("getMaxDate", $$robo$$android_widget_DatePickerSpinnerDelegate$getMaxDate(), this);
    }

    @Override
    public void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_widget_DatePickerSpinnerDelegate$setEnabled(boolean ), this, bl);
    }

    @Override
    public boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_widget_DatePickerSpinnerDelegate$isEnabled(), this);
    }

    @Override
    public CalendarView getCalendarView() {
        return InvokeDynamicSupport.bootstrap("getCalendarView", $$robo$$android_widget_DatePickerSpinnerDelegate$getCalendarView(), this);
    }

    @Override
    public void setCalendarViewShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setCalendarViewShown", $$robo$$android_widget_DatePickerSpinnerDelegate$setCalendarViewShown(boolean ), this, bl);
    }

    @Override
    public boolean getCalendarViewShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("getCalendarViewShown", $$robo$$android_widget_DatePickerSpinnerDelegate$getCalendarViewShown(), this);
    }

    @Override
    public void setSpinnersShown(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSpinnersShown", $$robo$$android_widget_DatePickerSpinnerDelegate$setSpinnersShown(boolean ), this, bl);
    }

    @Override
    public boolean getSpinnersShown() {
        return (boolean)InvokeDynamicSupport.bootstrap("getSpinnersShown", $$robo$$android_widget_DatePickerSpinnerDelegate$getSpinnersShown(), this);
    }

    @Override
    public void onConfigurationChanged(Configuration configuration) {
        InvokeDynamicSupport.bootstrap("onConfigurationChanged", $$robo$$android_widget_DatePickerSpinnerDelegate$onConfigurationChanged(android.content.res.Configuration ), this, configuration);
    }

    @Override
    public Parcelable onSaveInstanceState(Parcelable parcelable) {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_DatePickerSpinnerDelegate$onSaveInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_DatePickerSpinnerDelegate$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEvent", $$robo$$android_widget_DatePickerSpinnerDelegate$dispatchPopulateAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    @Override
    protected void setCurrentLocale(Locale locale) {
        InvokeDynamicSupport.bootstrap("setCurrentLocale", $$robo$$android_widget_DatePickerSpinnerDelegate$setCurrentLocale(java.util.Locale ), this, locale);
    }

    private boolean usingNumericMonths() {
        return (boolean)InvokeDynamicSupport.bootstrap("usingNumericMonths", $$robo$$android_widget_DatePickerSpinnerDelegate$usingNumericMonths(), this);
    }

    private Calendar getCalendarForLocale(Calendar calendar, Locale locale) {
        return InvokeDynamicSupport.bootstrap("getCalendarForLocale", $$robo$$android_widget_DatePickerSpinnerDelegate$getCalendarForLocale(android.icu.util.Calendar java.util.Locale ), this, calendar, locale);
    }

    private void reorderSpinners() {
        InvokeDynamicSupport.bootstrap("reorderSpinners", $$robo$$android_widget_DatePickerSpinnerDelegate$reorderSpinners(), this);
    }

    private boolean parseDate(String string2, Calendar calendar) {
        return (boolean)InvokeDynamicSupport.bootstrap("parseDate", $$robo$$android_widget_DatePickerSpinnerDelegate$parseDate(java.lang.String android.icu.util.Calendar ), this, string2, calendar);
    }

    private boolean isNewDate(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNewDate", $$robo$$android_widget_DatePickerSpinnerDelegate$isNewDate(int int int ), this, n, n2, n3);
    }

    private void setDate(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("setDate", $$robo$$android_widget_DatePickerSpinnerDelegate$setDate(int int int ), this, n, n2, n3);
    }

    private void updateSpinners() {
        InvokeDynamicSupport.bootstrap("updateSpinners", $$robo$$android_widget_DatePickerSpinnerDelegate$updateSpinners(), this);
    }

    private void updateCalendarView() {
        InvokeDynamicSupport.bootstrap("updateCalendarView", $$robo$$android_widget_DatePickerSpinnerDelegate$updateCalendarView(), this);
    }

    private void notifyDateChanged() {
        InvokeDynamicSupport.bootstrap("notifyDateChanged", $$robo$$android_widget_DatePickerSpinnerDelegate$notifyDateChanged(), this);
    }

    private void setImeOptions(NumberPicker numberPicker, int n, int n2) {
        InvokeDynamicSupport.bootstrap("setImeOptions", $$robo$$android_widget_DatePickerSpinnerDelegate$setImeOptions(android.widget.NumberPicker int int ), this, numberPicker, n, n2);
    }

    private void setContentDescriptions() {
        InvokeDynamicSupport.bootstrap("setContentDescriptions", $$robo$$android_widget_DatePickerSpinnerDelegate$setContentDescriptions(), this);
    }

    private void trySetContentDescription(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("trySetContentDescription", $$robo$$android_widget_DatePickerSpinnerDelegate$trySetContentDescription(android.view.View int int ), this, view, n, n2);
    }

    private void updateInputState() {
        InvokeDynamicSupport.bootstrap("updateInputState", $$robo$$android_widget_DatePickerSpinnerDelegate$updateInputState(), this);
    }

    public /* synthetic */ DatePickerSpinnerDelegate() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DatePickerSpinnerDelegate)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

