/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.R;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.AnimationUtils;
import android.widget.EdgeEffect;
import android.widget.FrameLayout;
import android.widget.OverScroller;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class HorizontalScrollView
extends FrameLayout
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static int ANIMATED_SCROLL_GAP = 250;
    private static float MAX_SCROLL_FACTOR = 0.5f;
    private static String TAG = "HorizontalScrollView";
    private long mLastScroll;
    private Rect mTempRect;
    private OverScroller mScroller;
    private EdgeEffect mEdgeGlowLeft;
    private EdgeEffect mEdgeGlowRight;
    private int mLastMotionX;
    private boolean mIsLayoutDirty;
    private View mChildToScrollTo;
    private boolean mIsBeingDragged;
    private VelocityTracker mVelocityTracker;
    @ViewDebug.ExportedProperty(category="layout")
    private boolean mFillViewport;
    private boolean mSmoothScrollingEnabled;
    private int mTouchSlop;
    private int mMinimumVelocity;
    private int mMaximumVelocity;
    private int mOverscrollDistance;
    private int mOverflingDistance;
    private float mHorizontalScrollFactor;
    private int mActivePointerId;
    private static int INVALID_POINTER = -1;
    private SavedState mSavedState;

    private void $$robo$$android_widget_HorizontalScrollView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_HorizontalScrollView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_HorizontalScrollView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_HorizontalScrollView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mTempRect = new Rect();
        this.mIsLayoutDirty = true;
        this.mChildToScrollTo = null;
        this.mIsBeingDragged = false;
        this.mSmoothScrollingEnabled = true;
        this.mActivePointerId = -1;
        this.initScrollView();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.HorizontalScrollView, defStyleAttr, defStyleRes);
        this.setFillViewport(a.getBoolean(0, false));
        a.recycle();
        if (context.getResources().getConfiguration().uiMode == 6) {
            this.setRevealOnFocusHint(false);
        }
    }

    private final float $$robo$$android_widget_HorizontalScrollView$getLeftFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getHorizontalFadingEdgeLength();
        if (this.mScrollX < length) {
            return (float)this.mScrollX / (float)length;
        }
        return 1.0f;
    }

    private final float $$robo$$android_widget_HorizontalScrollView$getRightFadingEdgeStrength() {
        if (this.getChildCount() == 0) {
            return 0.0f;
        }
        int length = this.getHorizontalFadingEdgeLength();
        int rightEdge = this.getWidth() - this.mPaddingRight;
        int span = this.getChildAt(0).getRight() - this.mScrollX - rightEdge;
        if (span < length) {
            return (float)span / (float)length;
        }
        return 1.0f;
    }

    private final int $$robo$$android_widget_HorizontalScrollView$getMaxScrollAmount() {
        return (int)(0.5f * (float)(this.mRight - this.mLeft));
    }

    private final void $$robo$$android_widget_HorizontalScrollView$initScrollView() {
        this.mScroller = new OverScroller(this.getContext());
        this.setFocusable(true);
        this.setDescendantFocusability(262144);
        this.setWillNotDraw(false);
        ViewConfiguration configuration = ViewConfiguration.get(this.mContext);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mOverscrollDistance = configuration.getScaledOverscrollDistance();
        this.mOverflingDistance = configuration.getScaledOverflingDistance();
        this.mHorizontalScrollFactor = configuration.getScaledHorizontalScrollFactor();
    }

    private final void $$robo$$android_widget_HorizontalScrollView$addView(View child) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(child);
    }

    private final void $$robo$$android_widget_HorizontalScrollView$addView(View child, int index) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(child, index);
    }

    private final void $$robo$$android_widget_HorizontalScrollView$addView(View child, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(child, params);
    }

    private final void $$robo$$android_widget_HorizontalScrollView$addView(View child, int index, ViewGroup.LayoutParams params) {
        if (this.getChildCount() > 0) {
            throw new IllegalStateException("HorizontalScrollView can host only one direct child");
        }
        super.addView(child, index, params);
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$canScroll() {
        View child = this.getChildAt(0);
        if (child != null) {
            int childWidth = child.getWidth();
            return this.getWidth() < childWidth + this.mPaddingLeft + this.mPaddingRight;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$isFillViewport() {
        return this.mFillViewport;
    }

    private final void $$robo$$android_widget_HorizontalScrollView$setFillViewport(boolean fillViewport) {
        if (fillViewport != this.mFillViewport) {
            this.mFillViewport = fillViewport;
            this.requestLayout();
        }
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$isSmoothScrollingEnabled() {
        return this.mSmoothScrollingEnabled;
    }

    private final void $$robo$$android_widget_HorizontalScrollView$setSmoothScrollingEnabled(boolean smoothScrollingEnabled) {
        this.mSmoothScrollingEnabled = smoothScrollingEnabled;
    }

    private final void $$robo$$android_widget_HorizontalScrollView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (!this.mFillViewport) {
            return;
        }
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        if (widthMode == 0) {
            return;
        }
        if (this.getChildCount() > 0) {
            int heightPadding;
            int widthPadding;
            View child = this.getChildAt(0);
            FrameLayout.LayoutParams lp = (FrameLayout.LayoutParams)child.getLayoutParams();
            int targetSdkVersion = this.getContext().getApplicationInfo().targetSdkVersion;
            if (targetSdkVersion >= 23) {
                widthPadding = this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin;
                heightPadding = this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin;
            } else {
                widthPadding = this.mPaddingLeft + this.mPaddingRight;
                heightPadding = this.mPaddingTop + this.mPaddingBottom;
            }
            int desiredWidth = this.getMeasuredWidth() - widthPadding;
            if (child.getMeasuredWidth() < desiredWidth) {
                int childWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(desiredWidth, 0x40000000);
                int childHeightMeasureSpec = HorizontalScrollView.getChildMeasureSpec(heightMeasureSpec, heightPadding, lp.height);
                child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
            }
        }
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$executeKeyEvent(KeyEvent event) {
        this.mTempRect.setEmpty();
        if (!this.canScroll()) {
            if (this.isFocused()) {
                View nextFocused;
                View currentFocused = this.findFocus();
                if (currentFocused == this) {
                    currentFocused = null;
                }
                return (nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, 66)) != null && nextFocused != this && nextFocused.requestFocus(66);
            }
            return false;
        }
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 21: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(17);
                        break;
                    }
                    handled = this.fullScroll(17);
                    break;
                }
                case 22: {
                    if (!event.isAltPressed()) {
                        handled = this.arrowScroll(66);
                        break;
                    }
                    handled = this.fullScroll(66);
                    break;
                }
                case 62: {
                    this.pageScroll(event.isShiftPressed() ? 17 : 66);
                }
            }
        }
        return handled;
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$inChild(int x, int y) {
        if (this.getChildCount() > 0) {
            int scrollX = this.mScrollX;
            View child = this.getChildAt(0);
            return y >= child.getTop() && y < child.getBottom() && x >= child.getLeft() - scrollX && x < child.getRight() - scrollX;
        }
        return false;
    }

    private final void $$robo$$android_widget_HorizontalScrollView$initOrResetVelocityTracker() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        } else {
            this.mVelocityTracker.clear();
        }
    }

    private final void $$robo$$android_widget_HorizontalScrollView$initVelocityTrackerIfNotExists() {
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
    }

    private final void $$robo$$android_widget_HorizontalScrollView$recycleVelocityTracker() {
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private final void $$robo$$android_widget_HorizontalScrollView$requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        if (disallowIntercept) {
            this.recycleVelocityTracker();
        }
        super.requestDisallowInterceptTouchEvent(disallowIntercept);
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        if (action == 2 && this.mIsBeingDragged) {
            return true;
        }
        if (super.onInterceptTouchEvent(ev)) {
            return true;
        }
        switch (action & 0xFF) {
            case 2: {
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = ev.findPointerIndex(activePointerId);
                if (pointerIndex == -1) {
                    Log.e("HorizontalScrollView", "Invalid pointerId=" + activePointerId + " in onInterceptTouchEvent");
                    break;
                }
                int x = (int)ev.getX(pointerIndex);
                int xDiff = Math.abs(x - this.mLastMotionX);
                if (xDiff <= this.mTouchSlop) break;
                this.mIsBeingDragged = true;
                this.mLastMotionX = x;
                this.initVelocityTrackerIfNotExists();
                this.mVelocityTracker.addMovement(ev);
                if (this.mParent == null) break;
                this.mParent.requestDisallowInterceptTouchEvent(true);
                break;
            }
            case 0: {
                int x = (int)ev.getX();
                if (!this.inChild(x, (int)ev.getY())) {
                    this.mIsBeingDragged = false;
                    this.recycleVelocityTracker();
                    break;
                }
                this.mLastMotionX = x;
                this.mActivePointerId = ev.getPointerId(0);
                this.initOrResetVelocityTracker();
                this.mVelocityTracker.addMovement(ev);
                this.mIsBeingDragged = !this.mScroller.isFinished();
                break;
            }
            case 1: 
            case 3: {
                this.mIsBeingDragged = false;
                this.mActivePointerId = -1;
                if (!this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0)) break;
                this.postInvalidateOnAnimation();
                break;
            }
            case 5: {
                int index = ev.getActionIndex();
                this.mLastMotionX = (int)ev.getX(index);
                this.mActivePointerId = ev.getPointerId(index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastMotionX = (int)ev.getX(ev.findPointerIndex(this.mActivePointerId));
            }
        }
        return this.mIsBeingDragged;
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$onTouchEvent(MotionEvent ev) {
        this.initVelocityTrackerIfNotExists();
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        switch (action & 0xFF) {
            case 0: {
                ViewParent parent;
                if (this.getChildCount() == 0) {
                    return false;
                }
                this.mIsBeingDragged = !this.mScroller.isFinished();
                if (this.mIsBeingDragged && (parent = this.getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
                if (!this.mScroller.isFinished()) {
                    this.mScroller.abortAnimation();
                }
                this.mLastMotionX = (int)ev.getX();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                boolean canOverscroll;
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                if (activePointerIndex == -1) {
                    Log.e("HorizontalScrollView", "Invalid pointerId=" + this.mActivePointerId + " in onTouchEvent");
                    break;
                }
                int x = (int)ev.getX(activePointerIndex);
                int deltaX = this.mLastMotionX - x;
                if (!this.mIsBeingDragged && Math.abs(deltaX) > this.mTouchSlop) {
                    ViewParent parent = this.getParent();
                    if (parent != null) {
                        parent.requestDisallowInterceptTouchEvent(true);
                    }
                    this.mIsBeingDragged = true;
                    deltaX = deltaX > 0 ? (deltaX -= this.mTouchSlop) : (deltaX += this.mTouchSlop);
                }
                if (!this.mIsBeingDragged) break;
                this.mLastMotionX = x;
                int oldX = this.mScrollX;
                int oldY = this.mScrollY;
                int range = this.getScrollRange();
                int overscrollMode = this.getOverScrollMode();
                boolean bl = canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
                if (this.overScrollBy(deltaX, 0, this.mScrollX, 0, range, 0, this.mOverscrollDistance, 0, true)) {
                    this.mVelocityTracker.clear();
                }
                if (!canOverscroll) break;
                int pulledToX = oldX + deltaX;
                if (pulledToX < 0) {
                    this.mEdgeGlowLeft.onPull((float)deltaX / (float)this.getWidth(), 1.0f - ev.getY(activePointerIndex) / (float)this.getHeight());
                    if (!this.mEdgeGlowRight.isFinished()) {
                        this.mEdgeGlowRight.onRelease();
                    }
                } else if (pulledToX > range) {
                    this.mEdgeGlowRight.onPull((float)deltaX / (float)this.getWidth(), ev.getY(activePointerIndex) / (float)this.getHeight());
                    if (!this.mEdgeGlowLeft.isFinished()) {
                        this.mEdgeGlowLeft.onRelease();
                    }
                }
                if (this.mEdgeGlowLeft == null || this.mEdgeGlowLeft.isFinished() && this.mEdgeGlowRight.isFinished()) break;
                this.postInvalidateOnAnimation();
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getXVelocity(this.mActivePointerId);
                if (this.getChildCount() > 0) {
                    if (Math.abs(initialVelocity) > this.mMinimumVelocity) {
                        this.fling(-initialVelocity);
                    } else if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0)) {
                        this.postInvalidateOnAnimation();
                    }
                }
                this.mActivePointerId = -1;
                this.mIsBeingDragged = false;
                this.recycleVelocityTracker();
                if (this.mEdgeGlowLeft == null) break;
                this.mEdgeGlowLeft.onRelease();
                this.mEdgeGlowRight.onRelease();
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged || this.getChildCount() <= 0) break;
                if (this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0)) {
                    this.postInvalidateOnAnimation();
                }
                this.mActivePointerId = -1;
                this.mIsBeingDragged = false;
                this.recycleVelocityTracker();
                if (this.mEdgeGlowLeft == null) break;
                this.mEdgeGlowLeft.onRelease();
                this.mEdgeGlowRight.onRelease();
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        return true;
    }

    private final void $$robo$$android_widget_HorizontalScrollView$onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = (ev.getAction() & 0xFF00) >> 8;
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionX = (int)ev.getX(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$onGenericMotionEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 8: {
                if (this.mIsBeingDragged) break;
                float axisValue = event.isFromSource(2) ? ((event.getMetaState() & 1) != 0 ? -event.getAxisValue(9) : event.getAxisValue(10)) : (event.isFromSource(0x400000) ? event.getAxisValue(26) : 0.0f);
                int delta = Math.round(axisValue * this.mHorizontalScrollFactor);
                if (delta == 0) break;
                int range = this.getScrollRange();
                int oldScrollX = this.mScrollX;
                int newScrollX = oldScrollX + delta;
                if (newScrollX < 0) {
                    newScrollX = 0;
                } else if (newScrollX > range) {
                    newScrollX = range;
                }
                if (newScrollX == oldScrollX) break;
                super.scrollTo(newScrollX, this.mScrollY);
                return true;
            }
        }
        return super.onGenericMotionEvent(event);
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$shouldDelayChildPressedState() {
        return true;
    }

    private final void $$robo$$android_widget_HorizontalScrollView$onOverScrolled(int scrollX, int scrollY, boolean clampedX, boolean clampedY) {
        if (!this.mScroller.isFinished()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            this.mScrollX = scrollX;
            this.mScrollY = scrollY;
            this.invalidateParentIfNeeded();
            this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
            if (clampedX) {
                this.mScroller.springBack(this.mScrollX, this.mScrollY, 0, this.getScrollRange(), 0, 0);
            }
        } else {
            super.scrollTo(scrollX, scrollY);
        }
        this.awakenScrollBars();
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$performAccessibilityActionInternal(int action, Bundle arguments) {
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        switch (action) {
            case 4096: 
            case 16908347: {
                if (!this.isEnabled()) {
                    return false;
                }
                int viewportWidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                int targetScrollX = Math.min(this.mScrollX + viewportWidth, this.getScrollRange());
                if (targetScrollX != this.mScrollX) {
                    this.smoothScrollTo(targetScrollX, 0);
                    return true;
                }
                return false;
            }
            case 8192: 
            case 16908345: {
                if (!this.isEnabled()) {
                    return false;
                }
                int viewportWidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
                int targetScrollX = Math.max(0, this.mScrollX - viewportWidth);
                if (targetScrollX != this.mScrollX) {
                    this.smoothScrollTo(targetScrollX, 0);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private final CharSequence $$robo$$android_widget_HorizontalScrollView$getAccessibilityClassName() {
        return HorizontalScrollView.class.getName();
    }

    private final void $$robo$$android_widget_HorizontalScrollView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        int scrollRange = this.getScrollRange();
        if (scrollRange > 0) {
            info.setScrollable(true);
            if (this.isEnabled() && this.mScrollX > 0) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_LEFT);
            }
            if (this.isEnabled() && this.mScrollX < scrollRange) {
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
                info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_RIGHT);
            }
        }
    }

    private final void $$robo$$android_widget_HorizontalScrollView$onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        event.setScrollable(this.getScrollRange() > 0);
        event.setScrollX(this.mScrollX);
        event.setScrollY(this.mScrollY);
        event.setMaxScrollX(this.getScrollRange());
        event.setMaxScrollY(this.mScrollY);
    }

    private final int $$robo$$android_widget_HorizontalScrollView$getScrollRange() {
        int scrollRange = 0;
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            scrollRange = Math.max(0, child.getWidth() - (this.getWidth() - this.mPaddingLeft - this.mPaddingRight));
        }
        return scrollRange;
    }

    private final View $$robo$$android_widget_HorizontalScrollView$findFocusableViewInMyBounds(boolean leftFocus, int left, View preferredFocusable) {
        int fadingEdgeLength = this.getHorizontalFadingEdgeLength() / 2;
        int leftWithoutFadingEdge = left + fadingEdgeLength;
        int rightWithoutFadingEdge = left + this.getWidth() - fadingEdgeLength;
        if (preferredFocusable != null && preferredFocusable.getLeft() < rightWithoutFadingEdge && preferredFocusable.getRight() > leftWithoutFadingEdge) {
            return preferredFocusable;
        }
        return this.findFocusableViewInBounds(leftFocus, leftWithoutFadingEdge, rightWithoutFadingEdge);
    }

    private final View $$robo$$android_widget_HorizontalScrollView$findFocusableViewInBounds(boolean leftFocus, int left, int right) {
        ArrayList<View> focusables = this.getFocusables(2);
        View focusCandidate = null;
        boolean foundFullyContainedFocusable = false;
        int count = focusables.size();
        for (int i = 0; i < count; ++i) {
            boolean viewIsCloserToBoundary;
            boolean viewIsFullyContained;
            View view = (View)focusables.get(i);
            int viewLeft = view.getLeft();
            int viewRight = view.getRight();
            if (left >= viewRight || viewLeft >= right) continue;
            boolean bl = viewIsFullyContained = left < viewLeft && viewRight < right;
            if (focusCandidate == null) {
                focusCandidate = view;
                foundFullyContainedFocusable = viewIsFullyContained;
                continue;
            }
            boolean bl2 = viewIsCloserToBoundary = leftFocus && viewLeft < focusCandidate.getLeft() || !leftFocus && viewRight > focusCandidate.getRight();
            if (foundFullyContainedFocusable) {
                if (!viewIsFullyContained || !viewIsCloserToBoundary) continue;
                focusCandidate = view;
                continue;
            }
            if (viewIsFullyContained) {
                focusCandidate = view;
                foundFullyContainedFocusable = true;
                continue;
            }
            if (!viewIsCloserToBoundary) continue;
            focusCandidate = view;
        }
        return focusCandidate;
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$pageScroll(int direction) {
        boolean right = direction == 66;
        int width = this.getWidth();
        if (right) {
            View view;
            this.mTempRect.left = this.getScrollX() + width;
            int count = this.getChildCount();
            if (count > 0 && this.mTempRect.left + width > (view = this.getChildAt(0)).getRight()) {
                this.mTempRect.left = view.getRight() - width;
            }
        } else {
            this.mTempRect.left = this.getScrollX() - width;
            if (this.mTempRect.left < 0) {
                this.mTempRect.left = 0;
            }
        }
        this.mTempRect.right = this.mTempRect.left + width;
        return this.scrollAndFocus(direction, this.mTempRect.left, this.mTempRect.right);
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$fullScroll(int direction) {
        int count;
        boolean right = direction == 66;
        int width = this.getWidth();
        this.mTempRect.left = 0;
        this.mTempRect.right = width;
        if (right && (count = this.getChildCount()) > 0) {
            View view = this.getChildAt(0);
            this.mTempRect.right = view.getRight();
            this.mTempRect.left = this.mTempRect.right - width;
        }
        return this.scrollAndFocus(direction, this.mTempRect.left, this.mTempRect.right);
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$scrollAndFocus(int direction, int left, int right) {
        boolean handled = true;
        int width = this.getWidth();
        int containerLeft = this.getScrollX();
        int containerRight = containerLeft + width;
        boolean goLeft = direction == 17;
        View newFocused = this.findFocusableViewInBounds(goLeft, left, right);
        if (newFocused == null) {
            newFocused = this;
        }
        if (left >= containerLeft && right <= containerRight) {
            handled = false;
        } else {
            int delta = goLeft ? left - containerLeft : right - containerRight;
            this.doScrollX(delta);
        }
        if (newFocused != this.findFocus()) {
            newFocused.requestFocus(direction);
        }
        return handled;
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$arrowScroll(int direction) {
        int scrollDelta;
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        }
        View nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, direction);
        int maxJump = this.getMaxScrollAmount();
        if (nextFocused != null && this.isWithinDeltaOfScreen(nextFocused, maxJump)) {
            nextFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(nextFocused, this.mTempRect);
            scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollX(scrollDelta);
            nextFocused.requestFocus(direction);
        } else {
            int screenRight;
            int daRight;
            scrollDelta = maxJump;
            if (direction == 17 && this.getScrollX() < scrollDelta) {
                scrollDelta = this.getScrollX();
            } else if (direction == 66 && this.getChildCount() > 0 && (daRight = this.getChildAt(0).getRight()) - (screenRight = this.getScrollX() + this.getWidth()) < maxJump) {
                scrollDelta = daRight - screenRight;
            }
            if (scrollDelta == 0) {
                return false;
            }
            this.doScrollX(direction == 66 ? scrollDelta : -scrollDelta);
        }
        if (currentFocused != null && currentFocused.isFocused() && this.isOffScreen(currentFocused)) {
            int descendantFocusability = this.getDescendantFocusability();
            this.setDescendantFocusability(131072);
            this.requestFocus();
            this.setDescendantFocusability(descendantFocusability);
        }
        return true;
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$isOffScreen(View descendant) {
        return !this.isWithinDeltaOfScreen(descendant, 0);
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$isWithinDeltaOfScreen(View descendant, int delta) {
        descendant.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendant, this.mTempRect);
        return this.mTempRect.right + delta >= this.getScrollX() && this.mTempRect.left - delta <= this.getScrollX() + this.getWidth();
    }

    private final void $$robo$$android_widget_HorizontalScrollView$doScrollX(int delta) {
        if (delta != 0) {
            if (this.mSmoothScrollingEnabled) {
                this.smoothScrollBy(delta, 0);
            } else {
                this.scrollBy(delta, 0);
            }
        }
    }

    private final void $$robo$$android_widget_HorizontalScrollView$smoothScrollBy(int dx, int dy) {
        if (this.getChildCount() == 0) {
            return;
        }
        long duration = AnimationUtils.currentAnimationTimeMillis() - this.mLastScroll;
        if (duration > 250L) {
            int width = this.getWidth() - this.mPaddingRight - this.mPaddingLeft;
            int right = this.getChildAt(0).getWidth();
            int maxX = Math.max(0, right - width);
            int scrollX = this.mScrollX;
            dx = Math.max(0, Math.min(scrollX + dx, maxX)) - scrollX;
            this.mScroller.startScroll(scrollX, this.mScrollY, dx, 0);
            this.postInvalidateOnAnimation();
        } else {
            if (!this.mScroller.isFinished()) {
                this.mScroller.abortAnimation();
            }
            this.scrollBy(dx, dy);
        }
        this.mLastScroll = AnimationUtils.currentAnimationTimeMillis();
    }

    private final void $$robo$$android_widget_HorizontalScrollView$smoothScrollTo(int x, int y) {
        this.smoothScrollBy(x - this.mScrollX, y - this.mScrollY);
    }

    private final int $$robo$$android_widget_HorizontalScrollView$computeHorizontalScrollRange() {
        int count = this.getChildCount();
        int contentWidth = this.getWidth() - this.mPaddingLeft - this.mPaddingRight;
        if (count == 0) {
            return contentWidth;
        }
        int scrollRange = this.getChildAt(0).getRight();
        int scrollX = this.mScrollX;
        int overscrollRight = Math.max(0, scrollRange - contentWidth);
        if (scrollX < 0) {
            scrollRange -= scrollX;
        } else if (scrollX > overscrollRight) {
            scrollRange += scrollX - overscrollRight;
        }
        return scrollRange;
    }

    private final int $$robo$$android_widget_HorizontalScrollView$computeHorizontalScrollOffset() {
        return Math.max(0, super.computeHorizontalScrollOffset());
    }

    private final void $$robo$$android_widget_HorizontalScrollView$measureChild(View child, int parentWidthMeasureSpec, int parentHeightMeasureSpec) {
        ViewGroup.LayoutParams lp = child.getLayoutParams();
        int horizontalPadding = this.mPaddingLeft + this.mPaddingRight;
        int childWidthMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(Math.max(0, View.MeasureSpec.getSize(parentWidthMeasureSpec) - horizontalPadding), 0);
        int childHeightMeasureSpec = HorizontalScrollView.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom, lp.height);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private final void $$robo$$android_widget_HorizontalScrollView$measureChildWithMargins(View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        int childHeightMeasureSpec = HorizontalScrollView.getChildMeasureSpec(parentHeightMeasureSpec, this.mPaddingTop + this.mPaddingBottom + lp.topMargin + lp.bottomMargin + heightUsed, lp.height);
        int usedTotal = this.mPaddingLeft + this.mPaddingRight + lp.leftMargin + lp.rightMargin + widthUsed;
        int childWidthMeasureSpec = View.MeasureSpec.makeSafeMeasureSpec(Math.max(0, View.MeasureSpec.getSize(parentWidthMeasureSpec) - usedTotal), 0);
        child.measure(childWidthMeasureSpec, childHeightMeasureSpec);
    }

    private final void $$robo$$android_widget_HorizontalScrollView$computeScroll() {
        if (this.mScroller.computeScrollOffset()) {
            int oldX = this.mScrollX;
            int oldY = this.mScrollY;
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                int range = this.getScrollRange();
                int overscrollMode = this.getOverScrollMode();
                boolean canOverscroll = overscrollMode == 0 || overscrollMode == 1 && range > 0;
                this.overScrollBy(x - oldX, y - oldY, oldX, oldY, range, 0, this.mOverflingDistance, 0, false);
                this.onScrollChanged(this.mScrollX, this.mScrollY, oldX, oldY);
                if (canOverscroll) {
                    if (x < 0 && oldX >= 0) {
                        this.mEdgeGlowLeft.onAbsorb((int)this.mScroller.getCurrVelocity());
                    } else if (x > range && oldX <= range) {
                        this.mEdgeGlowRight.onAbsorb((int)this.mScroller.getCurrVelocity());
                    }
                }
            }
            if (!this.awakenScrollBars()) {
                this.postInvalidateOnAnimation();
            }
        }
    }

    private final void $$robo$$android_widget_HorizontalScrollView$scrollToChild(View child) {
        child.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(child, this.mTempRect);
        int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
        if (scrollDelta != 0) {
            this.scrollBy(scrollDelta, 0);
        }
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$scrollToChildRect(Rect rect, boolean immediate) {
        boolean scroll;
        int delta = this.computeScrollDeltaToGetChildRectOnScreen(rect);
        boolean bl = scroll = delta != 0;
        if (scroll) {
            if (immediate) {
                this.scrollBy(delta, 0);
            } else {
                this.smoothScrollBy(delta, 0);
            }
        }
        return scroll;
    }

    private final int $$robo$$android_widget_HorizontalScrollView$computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        if (this.getChildCount() == 0) {
            return 0;
        }
        int width = this.getWidth();
        int screenLeft = this.getScrollX();
        int screenRight = screenLeft + width;
        int fadingEdge = this.getHorizontalFadingEdgeLength();
        if (rect.left > 0) {
            screenLeft += fadingEdge;
        }
        if (rect.right < this.getChildAt(0).getWidth()) {
            screenRight -= fadingEdge;
        }
        int scrollXDelta = 0;
        if (rect.right > screenRight && rect.left > screenLeft) {
            scrollXDelta = rect.width() > width ? (scrollXDelta += rect.left - screenLeft) : (scrollXDelta += rect.right - screenRight);
            int right = this.getChildAt(0).getRight();
            int distanceToRight = right - screenRight;
            scrollXDelta = Math.min(scrollXDelta, distanceToRight);
        } else if (rect.left < screenLeft && rect.right < screenRight) {
            scrollXDelta = rect.width() > width ? (scrollXDelta -= screenRight - rect.right) : (scrollXDelta -= screenLeft - rect.left);
            scrollXDelta = Math.max(scrollXDelta, -this.getScrollX());
        }
        return scrollXDelta;
    }

    private final void $$robo$$android_widget_HorizontalScrollView$requestChildFocus(View child, View focused) {
        if (focused != null && focused.getRevealOnFocusHint()) {
            if (!this.mIsLayoutDirty) {
                this.scrollToChild(focused);
            } else {
                this.mChildToScrollTo = focused;
            }
        }
        super.requestChildFocus(child, focused);
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        View nextFocus;
        if (direction == 2) {
            direction = 66;
        } else if (direction == 1) {
            direction = 17;
        }
        View view = nextFocus = previouslyFocusedRect == null ? FocusFinder.getInstance().findNextFocus(this, null, direction) : FocusFinder.getInstance().findNextFocusFromRect(this, previouslyFocusedRect, direction);
        if (nextFocus == null) {
            return false;
        }
        if (this.isOffScreen(nextFocus)) {
            return false;
        }
        return nextFocus.requestFocus(direction, previouslyFocusedRect);
    }

    private final boolean $$robo$$android_widget_HorizontalScrollView$requestChildRectangleOnScreen(View child, Rect rectangle, boolean immediate) {
        rectangle.offset(child.getLeft() - child.getScrollX(), child.getTop() - child.getScrollY());
        return this.scrollToChildRect(rectangle, immediate);
    }

    private final void $$robo$$android_widget_HorizontalScrollView$requestLayout() {
        this.mIsLayoutDirty = true;
        super.requestLayout();
    }

    private final void $$robo$$android_widget_HorizontalScrollView$onLayout(boolean changed, int l, int t, int r, int b) {
        int available;
        int childWidth = 0;
        int childMargins = 0;
        if (this.getChildCount() > 0) {
            childWidth = this.getChildAt(0).getMeasuredWidth();
            FrameLayout.LayoutParams childParams = (FrameLayout.LayoutParams)this.getChildAt(0).getLayoutParams();
            childMargins = childParams.leftMargin + childParams.rightMargin;
        }
        boolean forceLeftGravity = childWidth > (available = r - l - this.getPaddingLeftWithForeground() - this.getPaddingRightWithForeground() - childMargins);
        this.layoutChildren(l, t, r, b, forceLeftGravity);
        this.mIsLayoutDirty = false;
        if (this.mChildToScrollTo != null && HorizontalScrollView.isViewDescendantOf(this.mChildToScrollTo, this)) {
            this.scrollToChild(this.mChildToScrollTo);
        }
        this.mChildToScrollTo = null;
        if (!this.isLaidOut()) {
            int scrollRange = Math.max(0, childWidth - (r - l - this.mPaddingLeft - this.mPaddingRight));
            if (this.mSavedState != null) {
                this.mScrollX = this.isLayoutRtl() ? scrollRange - this.mSavedState.scrollOffsetFromStart : this.mSavedState.scrollOffsetFromStart;
                this.mSavedState = null;
            } else if (this.isLayoutRtl()) {
                this.mScrollX = scrollRange - this.mScrollX;
            }
            if (this.mScrollX > scrollRange) {
                this.mScrollX = scrollRange;
            } else if (this.mScrollX < 0) {
                this.mScrollX = 0;
            }
        }
        this.scrollTo(this.mScrollX, this.mScrollY);
    }

    private final void $$robo$$android_widget_HorizontalScrollView$onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        View currentFocused = this.findFocus();
        if (null == currentFocused || this == currentFocused) {
            return;
        }
        int maxJump = this.mRight - this.mLeft;
        if (this.isWithinDeltaOfScreen(currentFocused, maxJump)) {
            currentFocused.getDrawingRect(this.mTempRect);
            this.offsetDescendantRectToMyCoords(currentFocused, this.mTempRect);
            int scrollDelta = this.computeScrollDeltaToGetChildRectOnScreen(this.mTempRect);
            this.doScrollX(scrollDelta);
        }
    }

    private static final boolean $$robo$$android_widget_HorizontalScrollView$isViewDescendantOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && HorizontalScrollView.isViewDescendantOf((View)((Object)theParent), parent);
    }

    private final void $$robo$$android_widget_HorizontalScrollView$fling(int velocityX) {
        if (this.getChildCount() > 0) {
            int width = this.getWidth() - this.mPaddingRight - this.mPaddingLeft;
            int right = this.getChildAt(0).getWidth();
            this.mScroller.fling(this.mScrollX, this.mScrollY, velocityX, 0, 0, Math.max(0, right - width), 0, 0, width / 2, 0);
            boolean movingRight = velocityX > 0;
            View currentFocused = this.findFocus();
            View newFocused = this.findFocusableViewInMyBounds(movingRight, this.mScroller.getFinalX(), currentFocused);
            if (newFocused == null) {
                newFocused = this;
            }
            if (newFocused != currentFocused) {
                newFocused.requestFocus(movingRight ? 66 : 17);
            }
            this.postInvalidateOnAnimation();
        }
    }

    private final void $$robo$$android_widget_HorizontalScrollView$scrollTo(int x, int y) {
        if (this.getChildCount() > 0) {
            View child = this.getChildAt(0);
            x = HorizontalScrollView.clamp(x, this.getWidth() - this.mPaddingRight - this.mPaddingLeft, child.getWidth());
            y = HorizontalScrollView.clamp(y, this.getHeight() - this.mPaddingBottom - this.mPaddingTop, child.getHeight());
            if (x != this.mScrollX || y != this.mScrollY) {
                super.scrollTo(x, y);
            }
        }
    }

    private final void $$robo$$android_widget_HorizontalScrollView$setOverScrollMode(int mode) {
        if (mode != 2) {
            if (this.mEdgeGlowLeft == null) {
                Context context = this.getContext();
                this.mEdgeGlowLeft = new EdgeEffect(context);
                this.mEdgeGlowRight = new EdgeEffect(context);
            }
        } else {
            this.mEdgeGlowLeft = null;
            this.mEdgeGlowRight = null;
        }
        super.setOverScrollMode(mode);
    }

    private final void $$robo$$android_widget_HorizontalScrollView$draw(Canvas canvas) {
        super.draw(canvas);
        if (this.mEdgeGlowLeft != null) {
            int restoreCount;
            int scrollX = this.mScrollX;
            if (!this.mEdgeGlowLeft.isFinished()) {
                restoreCount = canvas.save();
                int height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                canvas.rotate(270.0f);
                canvas.translate(-height + this.mPaddingTop, Math.min(0, scrollX));
                this.mEdgeGlowLeft.setSize(height, this.getWidth());
                if (this.mEdgeGlowLeft.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mEdgeGlowRight.isFinished()) {
                restoreCount = canvas.save();
                int width = this.getWidth();
                int height = this.getHeight() - this.mPaddingTop - this.mPaddingBottom;
                canvas.rotate(90.0f);
                canvas.translate(-this.mPaddingTop, -(Math.max(this.getScrollRange(), scrollX) + width));
                this.mEdgeGlowRight.setSize(height, width);
                if (this.mEdgeGlowRight.draw(canvas)) {
                    this.postInvalidateOnAnimation();
                }
                canvas.restoreToCount(restoreCount);
            }
        }
    }

    private static final int $$robo$$android_widget_HorizontalScrollView$clamp(int n, int my, int child) {
        if (my >= child || n < 0) {
            return 0;
        }
        if (my + n > child) {
            return child - my;
        }
        return n;
    }

    private final void $$robo$$android_widget_HorizontalScrollView$onRestoreInstanceState(Parcelable state) {
        if (this.mContext.getApplicationInfo().targetSdkVersion <= 18) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.mSavedState = ss;
        this.requestLayout();
    }

    private final Parcelable $$robo$$android_widget_HorizontalScrollView$onSaveInstanceState() {
        if (this.mContext.getApplicationInfo().targetSdkVersion <= 18) {
            return super.onSaveInstanceState();
        }
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.scrollOffsetFromStart = this.isLayoutRtl() ? -this.mScrollX : this.mScrollX;
        return ss;
    }

    private final void $$robo$$android_widget_HorizontalScrollView$encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("layout:fillViewPort", this.mFillViewport);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_HorizontalScrollView$__constructor__(context);
    }

    public HorizontalScrollView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_HorizontalScrollView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_HorizontalScrollView$__constructor__(context, attributeSet);
    }

    public HorizontalScrollView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843603);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_HorizontalScrollView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_HorizontalScrollView$__constructor__(context, attributeSet, n);
    }

    public HorizontalScrollView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_HorizontalScrollView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_HorizontalScrollView$__constructor__(context, attributeSet, n, n2);
    }

    public HorizontalScrollView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_HorizontalScrollView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    @Override
    protected float getLeftFadingEdgeStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getLeftFadingEdgeStrength", $$robo$$android_widget_HorizontalScrollView$getLeftFadingEdgeStrength(), this);
    }

    @Override
    protected float getRightFadingEdgeStrength() {
        return (float)InvokeDynamicSupport.bootstrap("getRightFadingEdgeStrength", $$robo$$android_widget_HorizontalScrollView$getRightFadingEdgeStrength(), this);
    }

    public int getMaxScrollAmount() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxScrollAmount", $$robo$$android_widget_HorizontalScrollView$getMaxScrollAmount(), this);
    }

    private void initScrollView() {
        InvokeDynamicSupport.bootstrap("initScrollView", $$robo$$android_widget_HorizontalScrollView$initScrollView(), this);
    }

    @Override
    public void addView(View view) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_HorizontalScrollView$addView(android.view.View ), this, view);
    }

    @Override
    public void addView(View view, int n) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_HorizontalScrollView$addView(android.view.View int ), this, view, n);
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_HorizontalScrollView$addView(android.view.View android.view.ViewGroup$LayoutParams ), this, view, layoutParams);
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_HorizontalScrollView$addView(android.view.View int android.view.ViewGroup$LayoutParams ), this, view, n, layoutParams);
    }

    private boolean canScroll() {
        return (boolean)InvokeDynamicSupport.bootstrap("canScroll", $$robo$$android_widget_HorizontalScrollView$canScroll(), this);
    }

    public boolean isFillViewport() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFillViewport", $$robo$$android_widget_HorizontalScrollView$isFillViewport(), this);
    }

    public void setFillViewport(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFillViewport", $$robo$$android_widget_HorizontalScrollView$setFillViewport(boolean ), this, bl);
    }

    public boolean isSmoothScrollingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmoothScrollingEnabled", $$robo$$android_widget_HorizontalScrollView$isSmoothScrollingEnabled(), this);
    }

    public void setSmoothScrollingEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSmoothScrollingEnabled", $$robo$$android_widget_HorizontalScrollView$setSmoothScrollingEnabled(boolean ), this, bl);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_HorizontalScrollView$onMeasure(int int ), this, n, n2);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_widget_HorizontalScrollView$dispatchKeyEvent(android.view.KeyEvent ), this, keyEvent);
    }

    public boolean executeKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("executeKeyEvent", $$robo$$android_widget_HorizontalScrollView$executeKeyEvent(android.view.KeyEvent ), this, keyEvent);
    }

    private boolean inChild(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("inChild", $$robo$$android_widget_HorizontalScrollView$inChild(int int ), this, n, n2);
    }

    private void initOrResetVelocityTracker() {
        InvokeDynamicSupport.bootstrap("initOrResetVelocityTracker", $$robo$$android_widget_HorizontalScrollView$initOrResetVelocityTracker(), this);
    }

    private void initVelocityTrackerIfNotExists() {
        InvokeDynamicSupport.bootstrap("initVelocityTrackerIfNotExists", $$robo$$android_widget_HorizontalScrollView$initVelocityTrackerIfNotExists(), this);
    }

    private void recycleVelocityTracker() {
        InvokeDynamicSupport.bootstrap("recycleVelocityTracker", $$robo$$android_widget_HorizontalScrollView$recycleVelocityTracker(), this);
    }

    @Override
    public void requestDisallowInterceptTouchEvent(boolean bl) {
        InvokeDynamicSupport.bootstrap("requestDisallowInterceptTouchEvent", $$robo$$android_widget_HorizontalScrollView$requestDisallowInterceptTouchEvent(boolean ), this, bl);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onInterceptTouchEvent", $$robo$$android_widget_HorizontalScrollView$onInterceptTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_HorizontalScrollView$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    private void onSecondaryPointerUp(MotionEvent motionEvent) {
        InvokeDynamicSupport.bootstrap("onSecondaryPointerUp", $$robo$$android_widget_HorizontalScrollView$onSecondaryPointerUp(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onGenericMotionEvent", $$robo$$android_widget_HorizontalScrollView$onGenericMotionEvent(android.view.MotionEvent ), this, motionEvent);
    }

    @Override
    public boolean shouldDelayChildPressedState() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldDelayChildPressedState", $$robo$$android_widget_HorizontalScrollView$shouldDelayChildPressedState(), this);
    }

    @Override
    protected void onOverScrolled(int n, int n2, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("onOverScrolled", $$robo$$android_widget_HorizontalScrollView$onOverScrolled(int int boolean boolean ), this, n, n2, bl, bl2);
    }

    @Override
    public boolean performAccessibilityActionInternal(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionInternal", $$robo$$android_widget_HorizontalScrollView$performAccessibilityActionInternal(int android.os.Bundle ), this, n, bundle);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_HorizontalScrollView$getAccessibilityClassName(), this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_HorizontalScrollView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), this, accessibilityNodeInfo);
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEventInternal", $$robo$$android_widget_HorizontalScrollView$onInitializeAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), this, accessibilityEvent);
    }

    private int getScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("getScrollRange", $$robo$$android_widget_HorizontalScrollView$getScrollRange(), this);
    }

    private View findFocusableViewInMyBounds(boolean bl, int n, View view) {
        return InvokeDynamicSupport.bootstrap("findFocusableViewInMyBounds", $$robo$$android_widget_HorizontalScrollView$findFocusableViewInMyBounds(boolean int android.view.View ), this, bl, n, view);
    }

    private View findFocusableViewInBounds(boolean bl, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("findFocusableViewInBounds", $$robo$$android_widget_HorizontalScrollView$findFocusableViewInBounds(boolean int int ), this, bl, n, n2);
    }

    public boolean pageScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("pageScroll", $$robo$$android_widget_HorizontalScrollView$pageScroll(int ), this, n);
    }

    public boolean fullScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("fullScroll", $$robo$$android_widget_HorizontalScrollView$fullScroll(int ), this, n);
    }

    private boolean scrollAndFocus(int n, int n2, int n3) {
        return (boolean)InvokeDynamicSupport.bootstrap("scrollAndFocus", $$robo$$android_widget_HorizontalScrollView$scrollAndFocus(int int int ), this, n, n2, n3);
    }

    public boolean arrowScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("arrowScroll", $$robo$$android_widget_HorizontalScrollView$arrowScroll(int ), this, n);
    }

    private boolean isOffScreen(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffScreen", $$robo$$android_widget_HorizontalScrollView$isOffScreen(android.view.View ), this, view);
    }

    private boolean isWithinDeltaOfScreen(View view, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWithinDeltaOfScreen", $$robo$$android_widget_HorizontalScrollView$isWithinDeltaOfScreen(android.view.View int ), this, view, n);
    }

    private void doScrollX(int n) {
        InvokeDynamicSupport.bootstrap("doScrollX", $$robo$$android_widget_HorizontalScrollView$doScrollX(int ), this, n);
    }

    public void smoothScrollBy(int n, int n2) {
        InvokeDynamicSupport.bootstrap("smoothScrollBy", $$robo$$android_widget_HorizontalScrollView$smoothScrollBy(int int ), this, n, n2);
    }

    public void smoothScrollTo(int n, int n2) {
        InvokeDynamicSupport.bootstrap("smoothScrollTo", $$robo$$android_widget_HorizontalScrollView$smoothScrollTo(int int ), this, n, n2);
    }

    @Override
    protected int computeHorizontalScrollRange() {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollRange", $$robo$$android_widget_HorizontalScrollView$computeHorizontalScrollRange(), this);
    }

    @Override
    protected int computeHorizontalScrollOffset() {
        return (int)InvokeDynamicSupport.bootstrap("computeHorizontalScrollOffset", $$robo$$android_widget_HorizontalScrollView$computeHorizontalScrollOffset(), this);
    }

    @Override
    protected void measureChild(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureChild", $$robo$$android_widget_HorizontalScrollView$measureChild(android.view.View int int ), this, view, n, n2);
    }

    @Override
    protected void measureChildWithMargins(View view, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("measureChildWithMargins", $$robo$$android_widget_HorizontalScrollView$measureChildWithMargins(android.view.View int int int int ), this, view, n, n2, n3, n4);
    }

    @Override
    public void computeScroll() {
        InvokeDynamicSupport.bootstrap("computeScroll", $$robo$$android_widget_HorizontalScrollView$computeScroll(), this);
    }

    private void scrollToChild(View view) {
        InvokeDynamicSupport.bootstrap("scrollToChild", $$robo$$android_widget_HorizontalScrollView$scrollToChild(android.view.View ), this, view);
    }

    private boolean scrollToChildRect(Rect rect, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("scrollToChildRect", $$robo$$android_widget_HorizontalScrollView$scrollToChildRect(android.graphics.Rect boolean ), this, rect, bl);
    }

    protected int computeScrollDeltaToGetChildRectOnScreen(Rect rect) {
        return (int)InvokeDynamicSupport.bootstrap("computeScrollDeltaToGetChildRectOnScreen", $$robo$$android_widget_HorizontalScrollView$computeScrollDeltaToGetChildRectOnScreen(android.graphics.Rect ), this, rect);
    }

    @Override
    public void requestChildFocus(View view, View view2) {
        InvokeDynamicSupport.bootstrap("requestChildFocus", $$robo$$android_widget_HorizontalScrollView$requestChildFocus(android.view.View android.view.View ), this, view, view2);
    }

    @Override
    protected boolean onRequestFocusInDescendants(int n, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrap("onRequestFocusInDescendants", $$robo$$android_widget_HorizontalScrollView$onRequestFocusInDescendants(int android.graphics.Rect ), this, n, rect);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestChildRectangleOnScreen", $$robo$$android_widget_HorizontalScrollView$requestChildRectangleOnScreen(android.view.View android.graphics.Rect boolean ), this, view, rect, bl);
    }

    @Override
    public void requestLayout() {
        InvokeDynamicSupport.bootstrap("requestLayout", $$robo$$android_widget_HorizontalScrollView$requestLayout(), this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_HorizontalScrollView$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_HorizontalScrollView$onSizeChanged(int int int int ), this, n, n2, n3, n4);
    }

    private static boolean isViewDescendantOf(View view, View view2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isViewDescendantOf", $$robo$$android_widget_HorizontalScrollView$isViewDescendantOf(android.view.View android.view.View ), (View)view, (View)view2);
    }

    public void fling(int n) {
        InvokeDynamicSupport.bootstrap("fling", $$robo$$android_widget_HorizontalScrollView$fling(int ), this, n);
    }

    @Override
    public void scrollTo(int n, int n2) {
        InvokeDynamicSupport.bootstrap("scrollTo", $$robo$$android_widget_HorizontalScrollView$scrollTo(int int ), this, n, n2);
    }

    @Override
    public void setOverScrollMode(int n) {
        InvokeDynamicSupport.bootstrap("setOverScrollMode", $$robo$$android_widget_HorizontalScrollView$setOverScrollMode(int ), this, n);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_widget_HorizontalScrollView$draw(android.graphics.Canvas ), this, canvas);
    }

    private static int clamp(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("clamp", $$robo$$android_widget_HorizontalScrollView$clamp(int int int ), (int)n, (int)n2, (int)n3);
    }

    @Override
    protected void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_HorizontalScrollView$onRestoreInstanceState(android.os.Parcelable ), this, parcelable);
    }

    @Override
    protected Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_HorizontalScrollView$onSaveInstanceState(), this);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_HorizontalScrollView$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
    }

    public /* synthetic */ HorizontalScrollView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (HorizontalScrollView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public int scrollOffsetFromStart;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_HorizontalScrollView_SavedState$__constructor__(Parcelable superState) {
        }

        private void $$robo$$android_widget_HorizontalScrollView_SavedState$__constructor__(Parcel source) {
            this.scrollOffsetFromStart = source.readInt();
        }

        private final void $$robo$$android_widget_HorizontalScrollView_SavedState$writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeInt(this.scrollOffsetFromStart);
        }

        private final String $$robo$$android_widget_HorizontalScrollView_SavedState$toString() {
            return "HorizontalScrollView.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " scrollPosition=" + this.scrollOffsetFromStart + "}";
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_HorizontalScrollView_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_HorizontalScrollView_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_HorizontalScrollView_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_HorizontalScrollView_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_HorizontalScrollView_SavedState_1$__constructor__(), this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_HorizontalScrollView_SavedState_1$createFromParcel(android.os.Parcel ), this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_HorizontalScrollView_SavedState_1$newArray(int ), this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_widget_HorizontalScrollView_SavedState$__constructor__(parcelable);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_HorizontalScrollView_SavedState$__constructor__(android.os.Parcelable ), this, parcelable);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_HorizontalScrollView_SavedState$__constructor__(parcel);
        }

        public SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_HorizontalScrollView_SavedState$__constructor__(android.os.Parcel ), this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_HorizontalScrollView_SavedState$writeToParcel(android.os.Parcel int ), this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_HorizontalScrollView_SavedState$toString(), this);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

