/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.Intent;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Trace;
import android.util.AttributeSet;
import android.util.Log;
import android.util.MathUtils;
import android.util.SparseBooleanArray;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.RemotableViewMethod;
import android.view.SoundEffectConstants;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewParent;
import android.view.ViewRootImpl;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityNodeProvider;
import android.widget.AbsListView;
import android.widget.Adapter;
import android.widget.ArrayAdapter;
import android.widget.Checkable;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.RemoteViews;
import com.android.internal.R;
import com.google.android.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@RemoteViews.RemoteView
public class ListView
extends AbsListView
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static String TAG = "ListView";
    static int NO_POSITION = -1;
    private static float MAX_SCROLL_FACTOR = 0.33f;
    private static int MIN_SCROLL_PREVIEW_PIXELS = 2;
    ArrayList<FixedViewInfo> mHeaderViewInfos;
    ArrayList<FixedViewInfo> mFooterViewInfos;
    Drawable mDivider;
    int mDividerHeight;
    Drawable mOverScrollHeader;
    Drawable mOverScrollFooter;
    private boolean mIsCacheColorOpaque;
    private boolean mDividerIsOpaque;
    private boolean mHeaderDividersEnabled;
    private boolean mFooterDividersEnabled;
    private boolean mAreAllItemsSelectable;
    private boolean mItemsCanFocus;
    private Rect mTempRect;
    private Paint mDividerPaint;
    private ArrowScrollFocusResult mArrowScrollFocusResult;
    private FocusSelector mFocusSelector;

    private void $$robo$$android_widget_ListView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_ListView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_ListView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_ListView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int dividerHeight;
        Drawable osFooter;
        Drawable osHeader;
        Drawable d;
        this.mHeaderViewInfos = Lists.newArrayList();
        this.mFooterViewInfos = Lists.newArrayList();
        this.mAreAllItemsSelectable = true;
        this.mItemsCanFocus = false;
        this.mTempRect = new Rect();
        this.mArrowScrollFocusResult = new ArrowScrollFocusResult(null);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.ListView, defStyleAttr, defStyleRes);
        CharSequence[] entries = a.getTextArray(0);
        if (entries != null) {
            this.setAdapter(new ArrayAdapter<CharSequence>(context, 17367043, entries));
        }
        if ((d = a.getDrawable(1)) != null) {
            this.setDivider(d);
        }
        if ((osHeader = a.getDrawable(5)) != null) {
            this.setOverscrollHeader(osHeader);
        }
        if ((osFooter = a.getDrawable(6)) != null) {
            this.setOverscrollFooter(osFooter);
        }
        if (a.hasValueOrEmpty(2) && (dividerHeight = a.getDimensionPixelSize(2, 0)) != 0) {
            this.setDividerHeight(dividerHeight);
        }
        this.mHeaderDividersEnabled = a.getBoolean(3, true);
        this.mFooterDividersEnabled = a.getBoolean(4, true);
        a.recycle();
    }

    private final int $$robo$$android_widget_ListView$getMaxScrollAmount() {
        return (int)(0.33f * (float)(this.mBottom - this.mTop));
    }

    private final void $$robo$$android_widget_ListView$adjustViewsUpOrDown() {
        int childCount = this.getChildCount();
        if (childCount > 0) {
            int delta;
            if (!this.mStackFromBottom) {
                View child = this.getChildAt(0);
                delta = child.getTop() - this.mListPadding.top;
                if (this.mFirstPosition != 0) {
                    delta -= this.mDividerHeight;
                }
                if (delta < 0) {
                    delta = 0;
                }
            } else {
                View child = this.getChildAt(childCount - 1);
                delta = child.getBottom() - (this.getHeight() - this.mListPadding.bottom);
                if (this.mFirstPosition + childCount < this.mItemCount) {
                    delta += this.mDividerHeight;
                }
                if (delta > 0) {
                    delta = 0;
                }
            }
            if (delta != 0) {
                this.offsetChildrenTopAndBottom(-delta);
            }
        }
    }

    private final void $$robo$$android_widget_ListView$addHeaderView(View v, Object data, boolean isSelectable) {
        if (v.getParent() != null && v.getParent() != this && Log.isLoggable("ListView", 5)) {
            Log.w("ListView", "The specified child already has a parent. You must call removeView() on the child's parent first.");
        }
        FixedViewInfo info = new FixedViewInfo(this);
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mHeaderViewInfos.add(info);
        this.mAreAllItemsSelectable &= isSelectable;
        if (this.mAdapter != null) {
            if (!(this.mAdapter instanceof HeaderViewListAdapter)) {
                this.wrapHeaderListAdapterInternal();
            }
            if (this.mDataSetObserver != null) {
                this.mDataSetObserver.onChanged();
            }
        }
    }

    private final void $$robo$$android_widget_ListView$addHeaderView(View v) {
        this.addHeaderView(v, null, true);
    }

    private final int $$robo$$android_widget_ListView$getHeaderViewsCount() {
        return this.mHeaderViewInfos.size();
    }

    private final boolean $$robo$$android_widget_ListView$removeHeaderView(View v) {
        if (this.mHeaderViewInfos.size() > 0) {
            boolean result = false;
            if (this.mAdapter != null && ((HeaderViewListAdapter)this.mAdapter).removeHeader(v)) {
                if (this.mDataSetObserver != null) {
                    this.mDataSetObserver.onChanged();
                }
                result = true;
            }
            this.removeFixedViewInfo(v, this.mHeaderViewInfos);
            return result;
        }
        return false;
    }

    private final void $$robo$$android_widget_ListView$removeFixedViewInfo(View v, ArrayList<FixedViewInfo> where) {
        int len = where.size();
        for (int i = 0; i < len; ++i) {
            FixedViewInfo info = where.get(i);
            if (info.view != v) continue;
            where.remove(i);
            break;
        }
    }

    private final void $$robo$$android_widget_ListView$addFooterView(View v, Object data, boolean isSelectable) {
        if (v.getParent() != null && v.getParent() != this && Log.isLoggable("ListView", 5)) {
            Log.w("ListView", "The specified child already has a parent. You must call removeView() on the child's parent first.");
        }
        FixedViewInfo info = new FixedViewInfo(this);
        info.view = v;
        info.data = data;
        info.isSelectable = isSelectable;
        this.mFooterViewInfos.add(info);
        this.mAreAllItemsSelectable &= isSelectable;
        if (this.mAdapter != null) {
            if (!(this.mAdapter instanceof HeaderViewListAdapter)) {
                this.wrapHeaderListAdapterInternal();
            }
            if (this.mDataSetObserver != null) {
                this.mDataSetObserver.onChanged();
            }
        }
    }

    private final void $$robo$$android_widget_ListView$addFooterView(View v) {
        this.addFooterView(v, null, true);
    }

    private final int $$robo$$android_widget_ListView$getFooterViewsCount() {
        return this.mFooterViewInfos.size();
    }

    private final boolean $$robo$$android_widget_ListView$removeFooterView(View v) {
        if (this.mFooterViewInfos.size() > 0) {
            boolean result = false;
            if (this.mAdapter != null && ((HeaderViewListAdapter)this.mAdapter).removeFooter(v)) {
                if (this.mDataSetObserver != null) {
                    this.mDataSetObserver.onChanged();
                }
                result = true;
            }
            this.removeFixedViewInfo(v, this.mFooterViewInfos);
            return result;
        }
        return false;
    }

    private final ListAdapter $$robo$$android_widget_ListView$getAdapter() {
        return this.mAdapter;
    }

    @RemotableViewMethod(asyncImpl="setRemoteViewsAdapterAsync")
    private final void $$robo$$android_widget_ListView$setRemoteViewsAdapter(Intent intent) {
        super.setRemoteViewsAdapter(intent);
    }

    private final void $$robo$$android_widget_ListView$setAdapter(ListAdapter adapter) {
        if (this.mAdapter != null && this.mDataSetObserver != null) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        this.resetList();
        this.mRecycler.clear();
        this.mAdapter = this.mHeaderViewInfos.size() > 0 || this.mFooterViewInfos.size() > 0 ? this.wrapHeaderListAdapterInternal(this.mHeaderViewInfos, this.mFooterViewInfos, adapter) : adapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        super.setAdapter(adapter);
        if (this.mAdapter != null) {
            this.mAreAllItemsSelectable = this.mAdapter.areAllItemsEnabled();
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = new AbsListView.AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            this.mRecycler.setViewTypeCount(this.mAdapter.getViewTypeCount());
            int position = this.mStackFromBottom ? this.lookForSelectablePosition(this.mItemCount - 1, false) : this.lookForSelectablePosition(0, true);
            this.setSelectedPositionInt(position);
            this.setNextSelectedPositionInt(position);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.mAreAllItemsSelectable = true;
            this.checkFocus();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    private final void $$robo$$android_widget_ListView$resetList() {
        this.clearRecycledState(this.mHeaderViewInfos);
        this.clearRecycledState(this.mFooterViewInfos);
        super.resetList();
        this.mLayoutMode = 0;
    }

    private final void $$robo$$android_widget_ListView$clearRecycledState(ArrayList<FixedViewInfo> infos) {
        if (infos != null) {
            int count = infos.size();
            for (int i = 0; i < count; ++i) {
                View child = infos.get((int)i).view;
                AbsListView.LayoutParams p = (AbsListView.LayoutParams)child.getLayoutParams();
                if (p == null) continue;
                p.recycledHeaderFooter = false;
            }
        }
    }

    private final boolean $$robo$$android_widget_ListView$showingTopFadingEdge() {
        int listTop = this.mScrollY + this.mListPadding.top;
        return this.mFirstPosition > 0 || this.getChildAt(0).getTop() > listTop;
    }

    private final boolean $$robo$$android_widget_ListView$showingBottomFadingEdge() {
        int childCount = this.getChildCount();
        int bottomOfBottomChild = this.getChildAt(childCount - 1).getBottom();
        int lastVisiblePosition = this.mFirstPosition + childCount - 1;
        int listBottom = this.mScrollY + this.getHeight() - this.mListPadding.bottom;
        return lastVisiblePosition < this.mItemCount - 1 || bottomOfBottomChild < listBottom;
    }

    private final boolean $$robo$$android_widget_ListView$requestChildRectangleOnScreen(View child, Rect rect, boolean immediate) {
        boolean scroll;
        int rectTopWithinChild = rect.top;
        rect.offset(child.getLeft(), child.getTop());
        rect.offset(-child.getScrollX(), -child.getScrollY());
        int height = this.getHeight();
        int listUnfadedTop = this.getScrollY();
        int listUnfadedBottom = listUnfadedTop + height;
        int fadingEdge = this.getVerticalFadingEdgeLength();
        if (this.showingTopFadingEdge() && (this.mSelectedPosition > 0 || rectTopWithinChild > fadingEdge)) {
            listUnfadedTop += fadingEdge;
        }
        int childCount = this.getChildCount();
        int bottomOfBottomChild = this.getChildAt(childCount - 1).getBottom();
        if (this.showingBottomFadingEdge() && (this.mSelectedPosition < this.mItemCount - 1 || rect.bottom < bottomOfBottomChild - fadingEdge)) {
            listUnfadedBottom -= fadingEdge;
        }
        int scrollYDelta = 0;
        if (rect.bottom > listUnfadedBottom && rect.top > listUnfadedTop) {
            scrollYDelta = rect.height() > height ? (scrollYDelta += rect.top - listUnfadedTop) : (scrollYDelta += rect.bottom - listUnfadedBottom);
            int distanceToBottom = bottomOfBottomChild - listUnfadedBottom;
            scrollYDelta = Math.min(scrollYDelta, distanceToBottom);
        } else if (rect.top < listUnfadedTop && rect.bottom < listUnfadedBottom) {
            scrollYDelta = rect.height() > height ? (scrollYDelta -= listUnfadedBottom - rect.bottom) : (scrollYDelta -= listUnfadedTop - rect.top);
            int top = this.getChildAt(0).getTop();
            int deltaToTop = top - listUnfadedTop;
            scrollYDelta = Math.max(scrollYDelta, deltaToTop);
        }
        boolean bl = scroll = scrollYDelta != 0;
        if (scroll) {
            this.scrollListItemsBy(-scrollYDelta);
            this.positionSelector(-1, child);
            this.mSelectedTop = child.getTop();
            this.invalidate();
        }
        return scroll;
    }

    private final void $$robo$$android_widget_ListView$fillGap(boolean down) {
        int count = this.getChildCount();
        if (down) {
            int paddingTop = 0;
            if ((this.mGroupFlags & 0x22) == 34) {
                paddingTop = this.getListPaddingTop();
            }
            int startOffset = count > 0 ? this.getChildAt(count - 1).getBottom() + this.mDividerHeight : paddingTop;
            this.fillDown(this.mFirstPosition + count, startOffset);
            this.correctTooHigh(this.getChildCount());
        } else {
            int paddingBottom = 0;
            if ((this.mGroupFlags & 0x22) == 34) {
                paddingBottom = this.getListPaddingBottom();
            }
            int startOffset = count > 0 ? this.getChildAt(0).getTop() - this.mDividerHeight : this.getHeight() - paddingBottom;
            this.fillUp(this.mFirstPosition - 1, startOffset);
            this.correctTooLow(this.getChildCount());
        }
    }

    private final View $$robo$$android_widget_ListView$fillDown(int pos, int nextTop) {
        View selectedView = null;
        int end = this.mBottom - this.mTop;
        if ((this.mGroupFlags & 0x22) == 34) {
            end -= this.mListPadding.bottom;
        }
        while (nextTop < end && pos < this.mItemCount) {
            boolean selected = pos == this.mSelectedPosition;
            View child = this.makeAndAddView(pos, nextTop, true, this.mListPadding.left, selected);
            nextTop = child.getBottom() + this.mDividerHeight;
            if (selected) {
                selectedView = child;
            }
            ++pos;
        }
        this.setVisibleRangeHint(this.mFirstPosition, this.mFirstPosition + this.getChildCount() - 1);
        return selectedView;
    }

    private final View $$robo$$android_widget_ListView$fillUp(int pos, int nextBottom) {
        View selectedView = null;
        int end = 0;
        if ((this.mGroupFlags & 0x22) == 34) {
            end = this.mListPadding.top;
        }
        while (nextBottom > end && pos >= 0) {
            boolean selected = pos == this.mSelectedPosition;
            View child = this.makeAndAddView(pos, nextBottom, false, this.mListPadding.left, selected);
            nextBottom = child.getTop() - this.mDividerHeight;
            if (selected) {
                selectedView = child;
            }
            --pos;
        }
        this.mFirstPosition = pos + 1;
        this.setVisibleRangeHint(this.mFirstPosition, this.mFirstPosition + this.getChildCount() - 1);
        return selectedView;
    }

    private final View $$robo$$android_widget_ListView$fillFromTop(int nextTop) {
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mSelectedPosition);
        this.mFirstPosition = Math.min(this.mFirstPosition, this.mItemCount - 1);
        if (this.mFirstPosition < 0) {
            this.mFirstPosition = 0;
        }
        return this.fillDown(this.mFirstPosition, nextTop);
    }

    private final View $$robo$$android_widget_ListView$fillFromMiddle(int childrenTop, int childrenBottom) {
        int height = childrenBottom - childrenTop;
        int position = this.reconcileSelectedPosition();
        View sel = this.makeAndAddView(position, childrenTop, true, this.mListPadding.left, true);
        this.mFirstPosition = position;
        int selHeight = sel.getMeasuredHeight();
        if (selHeight <= height) {
            sel.offsetTopAndBottom((height - selHeight) / 2);
        }
        this.fillAboveAndBelow(sel, position);
        if (!this.mStackFromBottom) {
            this.correctTooHigh(this.getChildCount());
        } else {
            this.correctTooLow(this.getChildCount());
        }
        return sel;
    }

    private final void $$robo$$android_widget_ListView$fillAboveAndBelow(View sel, int position) {
        int dividerHeight = this.mDividerHeight;
        if (!this.mStackFromBottom) {
            this.fillUp(position - 1, sel.getTop() - dividerHeight);
            this.adjustViewsUpOrDown();
            this.fillDown(position + 1, sel.getBottom() + dividerHeight);
        } else {
            this.fillDown(position + 1, sel.getBottom() + dividerHeight);
            this.adjustViewsUpOrDown();
            this.fillUp(position - 1, sel.getTop() - dividerHeight);
        }
    }

    private final View $$robo$$android_widget_ListView$fillFromSelection(int selectedTop, int childrenTop, int childrenBottom) {
        int fadingEdgeLength = this.getVerticalFadingEdgeLength();
        int selectedPosition = this.mSelectedPosition;
        int topSelectionPixel = this.getTopSelectionPixel(childrenTop, fadingEdgeLength, selectedPosition);
        int bottomSelectionPixel = this.getBottomSelectionPixel(childrenBottom, fadingEdgeLength, selectedPosition);
        View sel = this.makeAndAddView(selectedPosition, selectedTop, true, this.mListPadding.left, true);
        if (sel.getBottom() > bottomSelectionPixel) {
            int spaceAbove = sel.getTop() - topSelectionPixel;
            int spaceBelow = sel.getBottom() - bottomSelectionPixel;
            int offset = Math.min(spaceAbove, spaceBelow);
            sel.offsetTopAndBottom(-offset);
        } else if (sel.getTop() < topSelectionPixel) {
            int spaceAbove = topSelectionPixel - sel.getTop();
            int spaceBelow = bottomSelectionPixel - sel.getBottom();
            int offset = Math.min(spaceAbove, spaceBelow);
            sel.offsetTopAndBottom(offset);
        }
        this.fillAboveAndBelow(sel, selectedPosition);
        if (!this.mStackFromBottom) {
            this.correctTooHigh(this.getChildCount());
        } else {
            this.correctTooLow(this.getChildCount());
        }
        return sel;
    }

    private final int $$robo$$android_widget_ListView$getBottomSelectionPixel(int childrenBottom, int fadingEdgeLength, int selectedPosition) {
        int bottomSelectionPixel = childrenBottom;
        if (selectedPosition != this.mItemCount - 1) {
            bottomSelectionPixel -= fadingEdgeLength;
        }
        return bottomSelectionPixel;
    }

    private final int $$robo$$android_widget_ListView$getTopSelectionPixel(int childrenTop, int fadingEdgeLength, int selectedPosition) {
        int topSelectionPixel = childrenTop;
        if (selectedPosition > 0) {
            topSelectionPixel += fadingEdgeLength;
        }
        return topSelectionPixel;
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ListView$smoothScrollToPosition(int position) {
        super.smoothScrollToPosition(position);
    }

    @RemotableViewMethod
    private final void $$robo$$android_widget_ListView$smoothScrollByOffset(int offset) {
        super.smoothScrollByOffset(offset);
    }

    private final View $$robo$$android_widget_ListView$moveSelection(View oldSel, View newSel, int delta, int childrenTop, int childrenBottom) {
        View sel;
        int fadingEdgeLength = this.getVerticalFadingEdgeLength();
        int selectedPosition = this.mSelectedPosition;
        int topSelectionPixel = this.getTopSelectionPixel(childrenTop, fadingEdgeLength, selectedPosition);
        int bottomSelectionPixel = this.getBottomSelectionPixel(childrenTop, fadingEdgeLength, selectedPosition);
        if (delta > 0) {
            oldSel = this.makeAndAddView(selectedPosition - 1, oldSel.getTop(), true, this.mListPadding.left, false);
            int dividerHeight = this.mDividerHeight;
            sel = this.makeAndAddView(selectedPosition, oldSel.getBottom() + dividerHeight, true, this.mListPadding.left, true);
            if (sel.getBottom() > bottomSelectionPixel) {
                int spaceAbove = sel.getTop() - topSelectionPixel;
                int spaceBelow = sel.getBottom() - bottomSelectionPixel;
                int halfVerticalSpace = (childrenBottom - childrenTop) / 2;
                int offset = Math.min(spaceAbove, spaceBelow);
                offset = Math.min(offset, halfVerticalSpace);
                oldSel.offsetTopAndBottom(-offset);
                sel.offsetTopAndBottom(-offset);
            }
            if (!this.mStackFromBottom) {
                this.fillUp(this.mSelectedPosition - 2, sel.getTop() - dividerHeight);
                this.adjustViewsUpOrDown();
                this.fillDown(this.mSelectedPosition + 1, sel.getBottom() + dividerHeight);
            } else {
                this.fillDown(this.mSelectedPosition + 1, sel.getBottom() + dividerHeight);
                this.adjustViewsUpOrDown();
                this.fillUp(this.mSelectedPosition - 2, sel.getTop() - dividerHeight);
            }
        } else if (delta < 0) {
            sel = newSel != null ? this.makeAndAddView(selectedPosition, newSel.getTop(), true, this.mListPadding.left, true) : this.makeAndAddView(selectedPosition, oldSel.getTop(), false, this.mListPadding.left, true);
            if (sel.getTop() < topSelectionPixel) {
                int spaceAbove = topSelectionPixel - sel.getTop();
                int spaceBelow = bottomSelectionPixel - sel.getBottom();
                int halfVerticalSpace = (childrenBottom - childrenTop) / 2;
                int offset = Math.min(spaceAbove, spaceBelow);
                offset = Math.min(offset, halfVerticalSpace);
                sel.offsetTopAndBottom(offset);
            }
            this.fillAboveAndBelow(sel, selectedPosition);
        } else {
            int newBottom;
            int oldTop = oldSel.getTop();
            sel = this.makeAndAddView(selectedPosition, oldTop, true, this.mListPadding.left, true);
            if (oldTop < childrenTop && (newBottom = sel.getBottom()) < childrenTop + 20) {
                sel.offsetTopAndBottom(childrenTop - sel.getTop());
            }
            this.fillAboveAndBelow(sel, selectedPosition);
        }
        return sel;
    }

    private final void $$robo$$android_widget_ListView$onDetachedFromWindow() {
        if (this.mFocusSelector != null) {
            this.removeCallbacks(this.mFocusSelector);
            this.mFocusSelector = null;
        }
        super.onDetachedFromWindow();
    }

    private final void $$robo$$android_widget_ListView$onSizeChanged(int w, int h, int oldw, int oldh) {
        View focusedChild;
        if (this.getChildCount() > 0 && (focusedChild = this.getFocusedChild()) != null) {
            int childPosition = this.mFirstPosition + this.indexOfChild(focusedChild);
            int childBottom = focusedChild.getBottom();
            int offset = Math.max(0, childBottom - (h - this.mPaddingTop));
            int top = focusedChild.getTop() - offset;
            if (this.mFocusSelector == null) {
                this.mFocusSelector = new FocusSelector(this, null);
            }
            this.post(this.mFocusSelector.setupForSetSelection(childPosition, top));
        }
        super.onSizeChanged(w, h, oldw, oldh);
    }

    private final void $$robo$$android_widget_ListView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode(heightMeasureSpec);
        int widthSize = View.MeasureSpec.getSize(widthMeasureSpec);
        int heightSize = View.MeasureSpec.getSize(heightMeasureSpec);
        int childWidth = 0;
        int childHeight = 0;
        int childState = 0;
        int n = this.mItemCount = this.mAdapter == null ? 0 : this.mAdapter.getCount();
        if (this.mItemCount > 0 && (widthMode == 0 || heightMode == 0)) {
            View child = this.obtainView(0, this.mIsScrap);
            this.measureScrapChild(child, 0, widthMeasureSpec, heightSize);
            childWidth = child.getMeasuredWidth();
            childHeight = child.getMeasuredHeight();
            childState = ListView.combineMeasuredStates(childState, child.getMeasuredState());
            if (this.recycleOnMeasure() && this.mRecycler.shouldRecycleViewType(((AbsListView.LayoutParams)child.getLayoutParams()).viewType)) {
                this.mRecycler.addScrapView(child, 0);
            }
        }
        widthSize = widthMode == 0 ? this.mListPadding.left + this.mListPadding.right + childWidth + this.getVerticalScrollbarWidth() : (widthSize |= childState & 0xFF000000);
        if (heightMode == 0) {
            heightSize = this.mListPadding.top + this.mListPadding.bottom + childHeight + this.getVerticalFadingEdgeLength() * 2;
        }
        if (heightMode == Integer.MIN_VALUE) {
            heightSize = this.measureHeightOfChildren(widthMeasureSpec, 0, -1, heightSize, -1);
        }
        this.setMeasuredDimension(widthSize, heightSize);
        this.mWidthMeasureSpec = widthMeasureSpec;
    }

    private final void $$robo$$android_widget_ListView$measureScrapChild(View child, int position, int widthMeasureSpec, int heightHint) {
        AbsListView.LayoutParams p = (AbsListView.LayoutParams)child.getLayoutParams();
        if (p == null) {
            p = (AbsListView.LayoutParams)this.generateDefaultLayoutParams();
            child.setLayoutParams(p);
        }
        p.viewType = this.mAdapter.getItemViewType(position);
        p.isEnabled = this.mAdapter.isEnabled(position);
        p.forceAdd = true;
        int childWidthSpec = ViewGroup.getChildMeasureSpec(widthMeasureSpec, this.mListPadding.left + this.mListPadding.right, p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec(lpHeight, 0x40000000) : View.MeasureSpec.makeSafeMeasureSpec(heightHint, 0);
        child.measure(childWidthSpec, childHeightSpec);
        child.forceLayout();
    }

    @ViewDebug.ExportedProperty(category="list")
    private final boolean $$robo$$android_widget_ListView$recycleOnMeasure() {
        return true;
    }

    private final int $$robo$$android_widget_ListView$measureHeightOfChildren(int widthMeasureSpec, int startPosition, int endPosition, int maxHeight, int disallowPartialChildPosition) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null) {
            return this.mListPadding.top + this.mListPadding.bottom;
        }
        int returnedHeight = this.mListPadding.top + this.mListPadding.bottom;
        int dividerHeight = this.mDividerHeight;
        int prevHeightWithoutPartialChild = 0;
        endPosition = endPosition == -1 ? adapter.getCount() - 1 : endPosition;
        AbsListView.RecycleBin recycleBin = this.mRecycler;
        boolean recyle = this.recycleOnMeasure();
        boolean[] isScrap = this.mIsScrap;
        for (int i = startPosition; i <= endPosition; ++i) {
            View child = this.obtainView(i, isScrap);
            this.measureScrapChild(child, i, widthMeasureSpec, maxHeight);
            if (i > 0) {
                returnedHeight += dividerHeight;
            }
            if (recyle && recycleBin.shouldRecycleViewType(((AbsListView.LayoutParams)child.getLayoutParams()).viewType)) {
                recycleBin.addScrapView(child, -1);
            }
            if ((returnedHeight += child.getMeasuredHeight()) >= maxHeight) {
                return disallowPartialChildPosition >= 0 && i > disallowPartialChildPosition && prevHeightWithoutPartialChild > 0 && returnedHeight != maxHeight ? prevHeightWithoutPartialChild : maxHeight;
            }
            if (disallowPartialChildPosition < 0 || i < disallowPartialChildPosition) continue;
            prevHeightWithoutPartialChild = returnedHeight;
        }
        return returnedHeight;
    }

    private final int $$robo$$android_widget_ListView$findMotionRow(int y) {
        block4: {
            int childCount = this.getChildCount();
            if (childCount <= 0) break block4;
            if (!this.mStackFromBottom) {
                for (int i = 0; i < childCount; ++i) {
                    View v = this.getChildAt(i);
                    if (y > v.getBottom()) continue;
                    return this.mFirstPosition + i;
                }
            } else {
                for (int i = childCount - 1; i >= 0; --i) {
                    View v = this.getChildAt(i);
                    if (y < v.getTop()) continue;
                    return this.mFirstPosition + i;
                }
            }
        }
        return -1;
    }

    private final View $$robo$$android_widget_ListView$fillSpecific(int position, int top) {
        View below;
        View above;
        boolean tempIsSelected = position == this.mSelectedPosition;
        View temp = this.makeAndAddView(position, top, true, this.mListPadding.left, tempIsSelected);
        this.mFirstPosition = position;
        int dividerHeight = this.mDividerHeight;
        if (!this.mStackFromBottom) {
            above = this.fillUp(position - 1, temp.getTop() - dividerHeight);
            this.adjustViewsUpOrDown();
            below = this.fillDown(position + 1, temp.getBottom() + dividerHeight);
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooHigh(childCount);
            }
        } else {
            below = this.fillDown(position + 1, temp.getBottom() + dividerHeight);
            this.adjustViewsUpOrDown();
            above = this.fillUp(position - 1, temp.getTop() - dividerHeight);
            int childCount = this.getChildCount();
            if (childCount > 0) {
                this.correctTooLow(childCount);
            }
        }
        if (tempIsSelected) {
            return temp;
        }
        if (above != null) {
            return above;
        }
        return below;
    }

    private final void $$robo$$android_widget_ListView$correctTooHigh(int childCount) {
        int lastPosition = this.mFirstPosition + childCount - 1;
        if (lastPosition == this.mItemCount - 1 && childCount > 0) {
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild.getBottom();
            int end = this.mBottom - this.mTop - this.mListPadding.bottom;
            int bottomOffset = end - lastBottom;
            View firstChild = this.getChildAt(0);
            int firstTop = firstChild.getTop();
            if (bottomOffset > 0 && (this.mFirstPosition > 0 || firstTop < this.mListPadding.top)) {
                if (this.mFirstPosition == 0) {
                    bottomOffset = Math.min(bottomOffset, this.mListPadding.top - firstTop);
                }
                this.offsetChildrenTopAndBottom(bottomOffset);
                if (this.mFirstPosition > 0) {
                    this.fillUp(this.mFirstPosition - 1, firstChild.getTop() - this.mDividerHeight);
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    private final void $$robo$$android_widget_ListView$correctTooLow(int childCount) {
        if (this.mFirstPosition == 0 && childCount > 0) {
            View firstChild = this.getChildAt(0);
            int firstTop = firstChild.getTop();
            int start = this.mListPadding.top;
            int end = this.mBottom - this.mTop - this.mListPadding.bottom;
            int topOffset = firstTop - start;
            View lastChild = this.getChildAt(childCount - 1);
            int lastBottom = lastChild.getBottom();
            int lastPosition = this.mFirstPosition + childCount - 1;
            if (topOffset > 0) {
                if (lastPosition < this.mItemCount - 1 || lastBottom > end) {
                    if (lastPosition == this.mItemCount - 1) {
                        topOffset = Math.min(topOffset, lastBottom - end);
                    }
                    this.offsetChildrenTopAndBottom(-topOffset);
                    if (lastPosition < this.mItemCount - 1) {
                        this.fillDown(lastPosition + 1, lastChild.getBottom() + this.mDividerHeight);
                        this.adjustViewsUpOrDown();
                    }
                } else if (lastPosition == this.mItemCount - 1) {
                    this.adjustViewsUpOrDown();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_widget_ListView$layoutChildren() {
        boolean blockLayoutRequests = this.mBlockLayoutRequests;
        if (blockLayoutRequests) {
            return;
        }
        this.mBlockLayoutRequests = true;
        try {
            View newAccessibilityFocusedView;
            View sel;
            View focusChild;
            View focusHost;
            boolean dataChanged;
            super.layoutChildren();
            this.invalidate();
            if (this.mAdapter == null) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            int childrenTop = this.mListPadding.top;
            int childrenBottom = this.mBottom - this.mTop - this.mListPadding.bottom;
            int childCount = this.getChildCount();
            int index = 0;
            int delta = 0;
            View oldSel = null;
            View oldFirst = null;
            View newSel = null;
            switch (this.mLayoutMode) {
                case 2: {
                    index = this.mNextSelectedPosition - this.mFirstPosition;
                    if (index < 0 || index >= childCount) break;
                    newSel = this.getChildAt(index);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
                default: {
                    index = this.mSelectedPosition - this.mFirstPosition;
                    if (index >= 0 && index < childCount) {
                        oldSel = this.getChildAt(index);
                    }
                    oldFirst = this.getChildAt(0);
                    if (this.mNextSelectedPosition >= 0) {
                        delta = this.mNextSelectedPosition - this.mSelectedPosition;
                    }
                    newSel = this.getChildAt(index + delta);
                }
            }
            if (dataChanged = this.mDataChanged) {
                this.handleDataChanged();
            }
            if (this.mItemCount == 0) {
                this.resetList();
                this.invokeOnItemScrollListener();
                return;
            }
            if (this.mItemCount != this.mAdapter.getCount()) {
                throw new IllegalStateException("The content of the adapter has changed but ListView did not receive a notification. Make sure the content of your adapter is not modified from a background thread, but only from the UI thread. Make sure your adapter calls notifyDataSetChanged() when its content changes. [in ListView(" + this.getId() + ", " + this.getClass() + ") with Adapter(" + this.mAdapter.getClass() + ")]");
            }
            this.setSelectedPositionInt(this.mNextSelectedPosition);
            AccessibilityNodeInfo accessibilityFocusLayoutRestoreNode = null;
            View accessibilityFocusLayoutRestoreView = null;
            int accessibilityFocusPosition = -1;
            ViewRootImpl viewRootImpl = this.getViewRootImpl();
            if (viewRootImpl != null && (focusHost = viewRootImpl.getAccessibilityFocusedHost()) != null && (focusChild = this.getAccessibilityFocusedChild(focusHost)) != null) {
                if (!dataChanged || this.isDirectChildHeaderOrFooter(focusChild) || focusChild.hasTransientState() && this.mAdapterHasStableIds) {
                    accessibilityFocusLayoutRestoreView = focusHost;
                    accessibilityFocusLayoutRestoreNode = viewRootImpl.getAccessibilityFocusedVirtualView();
                }
                accessibilityFocusPosition = this.getPositionForView(focusChild);
            }
            View focusLayoutRestoreDirectChild = null;
            View focusLayoutRestoreView = null;
            View focusedChild = this.getFocusedChild();
            if (focusedChild != null) {
                if (!dataChanged || this.isDirectChildHeaderOrFooter(focusedChild) || focusedChild.hasTransientState() || this.mAdapterHasStableIds) {
                    focusLayoutRestoreDirectChild = focusedChild;
                    focusLayoutRestoreView = this.findFocus();
                    if (focusLayoutRestoreView != null) {
                        focusLayoutRestoreView.dispatchStartTemporaryDetach();
                    }
                }
                this.requestFocus();
            }
            int firstPosition = this.mFirstPosition;
            AbsListView.RecycleBin recycleBin = this.mRecycler;
            if (dataChanged) {
                for (int i = 0; i < childCount; ++i) {
                    recycleBin.addScrapView(this.getChildAt(i), firstPosition + i);
                }
            } else {
                recycleBin.fillActiveViews(childCount, firstPosition);
            }
            this.detachAllViewsFromParent();
            recycleBin.removeSkippedScrap();
            switch (this.mLayoutMode) {
                case 2: {
                    if (newSel != null) {
                        sel = this.fillFromSelection(newSel.getTop(), childrenTop, childrenBottom);
                        break;
                    }
                    sel = this.fillFromMiddle(childrenTop, childrenBottom);
                    break;
                }
                case 5: {
                    sel = this.fillSpecific(this.mSyncPosition, this.mSpecificTop);
                    break;
                }
                case 3: {
                    sel = this.fillUp(this.mItemCount - 1, childrenBottom);
                    this.adjustViewsUpOrDown();
                    break;
                }
                case 1: {
                    this.mFirstPosition = 0;
                    sel = this.fillFromTop(childrenTop);
                    this.adjustViewsUpOrDown();
                    break;
                }
                case 4: {
                    Runnable focusRunnable;
                    int selectedPosition = this.reconcileSelectedPosition();
                    sel = this.fillSpecific(selectedPosition, this.mSpecificTop);
                    if (sel != null || this.mFocusSelector == null || (focusRunnable = this.mFocusSelector.setupFocusIfValid(selectedPosition)) == null) break;
                    this.post(focusRunnable);
                    break;
                }
                case 6: {
                    sel = this.moveSelection(oldSel, newSel, delta, childrenTop, childrenBottom);
                    break;
                }
                default: {
                    if (childCount == 0) {
                        if (!this.mStackFromBottom) {
                            int position = this.lookForSelectablePosition(0, true);
                            this.setSelectedPositionInt(position);
                            sel = this.fillFromTop(childrenTop);
                            break;
                        }
                        int position = this.lookForSelectablePosition(this.mItemCount - 1, false);
                        this.setSelectedPositionInt(position);
                        sel = this.fillUp(this.mItemCount - 1, childrenBottom);
                        break;
                    }
                    sel = this.mSelectedPosition >= 0 && this.mSelectedPosition < this.mItemCount ? this.fillSpecific(this.mSelectedPosition, oldSel == null ? childrenTop : oldSel.getTop()) : (this.mFirstPosition < this.mItemCount ? this.fillSpecific(this.mFirstPosition, oldFirst == null ? childrenTop : oldFirst.getTop()) : this.fillSpecific(0, childrenTop));
                }
            }
            recycleBin.scrapActiveViews();
            this.removeUnusedFixedViews(this.mHeaderViewInfos);
            this.removeUnusedFixedViews(this.mFooterViewInfos);
            if (sel != null) {
                if (this.mItemsCanFocus && this.hasFocus() && !sel.hasFocus()) {
                    boolean focusWasTaken;
                    boolean bl = focusWasTaken = sel == focusLayoutRestoreDirectChild && focusLayoutRestoreView != null && focusLayoutRestoreView.requestFocus() || sel.requestFocus();
                    if (!focusWasTaken) {
                        View focused = this.getFocusedChild();
                        if (focused != null) {
                            focused.clearFocus();
                        }
                        this.positionSelector(-1, sel);
                    } else {
                        sel.setSelected(false);
                        this.mSelectorRect.setEmpty();
                    }
                } else {
                    this.positionSelector(-1, sel);
                }
                this.mSelectedTop = sel.getTop();
            } else {
                View child;
                boolean inTouchMode;
                boolean bl = inTouchMode = this.mTouchMode == 1 || this.mTouchMode == 2;
                if (inTouchMode) {
                    child = this.getChildAt(this.mMotionPosition - this.mFirstPosition);
                    if (child != null) {
                        this.positionSelector(this.mMotionPosition, child);
                    }
                } else if (this.mSelectorPosition != -1) {
                    child = this.getChildAt(this.mSelectorPosition - this.mFirstPosition);
                    if (child != null) {
                        this.positionSelector(this.mSelectorPosition, child);
                    }
                } else {
                    this.mSelectedTop = 0;
                    this.mSelectorRect.setEmpty();
                }
                if (this.hasFocus() && focusLayoutRestoreView != null) {
                    focusLayoutRestoreView.requestFocus();
                }
            }
            if (viewRootImpl != null && (newAccessibilityFocusedView = viewRootImpl.getAccessibilityFocusedHost()) == null) {
                int position;
                View restoreView;
                if (accessibilityFocusLayoutRestoreView != null && accessibilityFocusLayoutRestoreView.isAttachedToWindow()) {
                    AccessibilityNodeProvider provider = accessibilityFocusLayoutRestoreView.getAccessibilityNodeProvider();
                    if (accessibilityFocusLayoutRestoreNode != null && provider != null) {
                        int virtualViewId = AccessibilityNodeInfo.getVirtualDescendantId(accessibilityFocusLayoutRestoreNode.getSourceNodeId());
                        provider.performAction(virtualViewId, 64, null);
                    } else {
                        accessibilityFocusLayoutRestoreView.requestAccessibilityFocus();
                    }
                } else if (accessibilityFocusPosition != -1 && (restoreView = this.getChildAt(position = MathUtils.constrain(accessibilityFocusPosition - this.mFirstPosition, 0, this.getChildCount() - 1))) != null) {
                    restoreView.requestAccessibilityFocus();
                }
            }
            if (focusLayoutRestoreView != null && focusLayoutRestoreView.getWindowToken() != null) {
                focusLayoutRestoreView.dispatchFinishTemporaryDetach();
            }
            this.mLayoutMode = 0;
            this.mDataChanged = false;
            if (this.mPositionScrollAfterLayout != null) {
                this.post(this.mPositionScrollAfterLayout);
                this.mPositionScrollAfterLayout = null;
            }
            this.mNeedSync = false;
            this.setNextSelectedPositionInt(this.mSelectedPosition);
            this.updateScrollIndicators();
            if (this.mItemCount > 0) {
                this.checkSelectionChanged();
            }
            this.invokeOnItemScrollListener();
        }
        finally {
            if (this.mFocusSelector != null) {
                this.mFocusSelector.onLayoutComplete();
            }
            if (!blockLayoutRequests) {
                this.mBlockLayoutRequests = false;
            }
        }
    }

    private final boolean $$robo$$android_widget_ListView$trackMotionScroll(int deltaY, int incrementalDeltaY) {
        boolean result = super.trackMotionScroll(deltaY, incrementalDeltaY);
        this.removeUnusedFixedViews(this.mHeaderViewInfos);
        this.removeUnusedFixedViews(this.mFooterViewInfos);
        return result;
    }

    private final void $$robo$$android_widget_ListView$removeUnusedFixedViews(List<FixedViewInfo> infoList) {
        if (infoList == null) {
            return;
        }
        for (int i = infoList.size() - 1; i >= 0; --i) {
            FixedViewInfo fixedViewInfo = infoList.get(i);
            View view = fixedViewInfo.view;
            AbsListView.LayoutParams lp = (AbsListView.LayoutParams)view.getLayoutParams();
            if (view.getParent() != null || lp == null || !lp.recycledHeaderFooter) continue;
            this.removeDetachedView(view, false);
            lp.recycledHeaderFooter = false;
        }
    }

    private final boolean $$robo$$android_widget_ListView$isDirectChildHeaderOrFooter(View child) {
        ArrayList<FixedViewInfo> headers = this.mHeaderViewInfos;
        int numHeaders = headers.size();
        for (int i = 0; i < numHeaders; ++i) {
            if (child != headers.get((int)i).view) continue;
            return true;
        }
        ArrayList<FixedViewInfo> footers = this.mFooterViewInfos;
        int numFooters = footers.size();
        for (int i = 0; i < numFooters; ++i) {
            if (child != footers.get((int)i).view) continue;
            return true;
        }
        return false;
    }

    private final View $$robo$$android_widget_ListView$makeAndAddView(int position, int y, boolean flow, int childrenLeft, boolean selected) {
        View activeView;
        if (!this.mDataChanged && (activeView = this.mRecycler.getActiveView(position)) != null) {
            this.setupChild(activeView, position, y, flow, childrenLeft, selected, true);
            return activeView;
        }
        View child = this.obtainView(position, this.mIsScrap);
        this.setupChild(child, position, y, flow, childrenLeft, selected, this.mIsScrap[0]);
        return child;
    }

    private final void $$robo$$android_widget_ListView$setupChild(View child, int position, int y, boolean flowDown, int childrenLeft, boolean selected, boolean isAttachedToWindow) {
        int childTop;
        Trace.traceBegin(8L, "setupListItem");
        boolean isSelected = selected && this.shouldShowSelector();
        boolean updateChildSelected = isSelected != child.isSelected();
        int mode = this.mTouchMode;
        boolean isPressed = mode > 0 && mode < 3 && this.mMotionPosition == position;
        boolean updateChildPressed = isPressed != child.isPressed();
        boolean needToMeasure = !isAttachedToWindow || updateChildSelected || child.isLayoutRequested();
        AbsListView.LayoutParams p = (AbsListView.LayoutParams)child.getLayoutParams();
        if (p == null) {
            p = (AbsListView.LayoutParams)this.generateDefaultLayoutParams();
        }
        p.viewType = this.mAdapter.getItemViewType(position);
        p.isEnabled = this.mAdapter.isEnabled(position);
        if (updateChildSelected) {
            child.setSelected(isSelected);
        }
        if (updateChildPressed) {
            child.setPressed(isPressed);
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null) {
            if (child instanceof Checkable) {
                ((Checkable)((Object)child)).setChecked(this.mCheckStates.get(position));
            } else if (this.getContext().getApplicationInfo().targetSdkVersion >= 11) {
                child.setActivated(this.mCheckStates.get(position));
            }
        }
        if (isAttachedToWindow && !p.forceAdd || p.recycledHeaderFooter && p.viewType == -2) {
            this.attachViewToParent(child, flowDown ? -1 : 0, p);
            if (isAttachedToWindow && ((AbsListView.LayoutParams)child.getLayoutParams()).scrappedFromPosition != position) {
                child.jumpDrawablesToCurrentState();
            }
        } else {
            p.forceAdd = false;
            if (p.viewType == -2) {
                p.recycledHeaderFooter = true;
            }
            this.addViewInLayout(child, flowDown ? -1 : 0, p, true);
            child.resolveRtlPropertiesIfNeeded();
        }
        if (needToMeasure) {
            int childWidthSpec = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mListPadding.left + this.mListPadding.right, p.width);
            int lpHeight = p.height;
            int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec(lpHeight, 0x40000000) : View.MeasureSpec.makeSafeMeasureSpec(this.getMeasuredHeight(), 0);
            child.measure(childWidthSpec, childHeightSpec);
        } else {
            this.cleanupLayoutState(child);
        }
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int n = childTop = flowDown ? y : y - h;
        if (needToMeasure) {
            int childRight = childrenLeft + w;
            int childBottom = childTop + h;
            child.layout(childrenLeft, childTop, childRight, childBottom);
        } else {
            child.offsetLeftAndRight(childrenLeft - child.getLeft());
            child.offsetTopAndBottom(childTop - child.getTop());
        }
        if (this.mCachingStarted && !child.isDrawingCacheEnabled()) {
            child.setDrawingCacheEnabled(true);
        }
        Trace.traceEnd(8L);
    }

    private final boolean $$robo$$android_widget_ListView$canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    private final void $$robo$$android_widget_ListView$setSelection(int position) {
        this.setSelectionFromTop(position, 0);
    }

    private final void $$robo$$android_widget_ListView$setSelectionInt(int position) {
        this.setNextSelectedPositionInt(position);
        boolean awakeScrollbars = false;
        int selectedPosition = this.mSelectedPosition;
        if (selectedPosition >= 0) {
            if (position == selectedPosition - 1) {
                awakeScrollbars = true;
            } else if (position == selectedPosition + 1) {
                awakeScrollbars = true;
            }
        }
        if (this.mPositionScroller != null) {
            this.mPositionScroller.stop();
        }
        this.layoutChildren();
        if (awakeScrollbars) {
            this.awakenScrollBars();
        }
    }

    private final int $$robo$$android_widget_ListView$lookForSelectablePosition(int position, boolean lookDown) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null || this.isInTouchMode()) {
            return -1;
        }
        int count = adapter.getCount();
        if (!this.mAreAllItemsSelectable) {
            if (lookDown) {
                for (position = Math.max(0, position); position < count && !adapter.isEnabled(position); ++position) {
                }
            } else {
                for (position = Math.min(position, count - 1); position >= 0 && !adapter.isEnabled(position); --position) {
                }
            }
        }
        if (position < 0 || position >= count) {
            return -1;
        }
        return position;
    }

    private final int $$robo$$android_widget_ListView$lookForSelectablePositionAfter(int current, int position, boolean lookDown) {
        ListAdapter adapter = this.mAdapter;
        if (adapter == null || this.isInTouchMode()) {
            return -1;
        }
        int after = this.lookForSelectablePosition(position, lookDown);
        if (after != -1) {
            return after;
        }
        int count = adapter.getCount();
        current = MathUtils.constrain(current, -1, count - 1);
        if (lookDown) {
            for (position = Math.min(position - 1, count - 1); position > current && !adapter.isEnabled(position); --position) {
            }
            if (position <= current) {
                return -1;
            }
        } else {
            for (position = Math.max(0, position + 1); position < current && !adapter.isEnabled(position); ++position) {
            }
            if (position >= current) {
                return -1;
            }
        }
        return position;
    }

    private final void $$robo$$android_widget_ListView$setSelectionAfterHeaderView() {
        int count = this.getHeaderViewsCount();
        if (count > 0) {
            this.mNextSelectedPosition = 0;
            return;
        }
        if (this.mAdapter != null) {
            this.setSelection(count);
        } else {
            this.mNextSelectedPosition = count;
            this.mLayoutMode = 2;
        }
    }

    private final boolean $$robo$$android_widget_ListView$dispatchKeyEvent(KeyEvent event) {
        View focused;
        boolean handled = super.dispatchKeyEvent(event);
        if (!handled && (focused = this.getFocusedChild()) != null && event.getAction() == 0) {
            handled = this.onKeyDown(event.getKeyCode(), event);
        }
        return handled;
    }

    private final boolean $$robo$$android_widget_ListView$onKeyDown(int keyCode, KeyEvent event) {
        return this.commonKey(keyCode, 1, event);
    }

    private final boolean $$robo$$android_widget_ListView$onKeyMultiple(int keyCode, int repeatCount, KeyEvent event) {
        return this.commonKey(keyCode, repeatCount, event);
    }

    private final boolean $$robo$$android_widget_ListView$onKeyUp(int keyCode, KeyEvent event) {
        return this.commonKey(keyCode, 1, event);
    }

    private final boolean $$robo$$android_widget_ListView$commonKey(int keyCode, int count, KeyEvent event) {
        if (this.mAdapter == null || !this.isAttachedToWindow()) {
            return false;
        }
        if (this.mDataChanged) {
            this.layoutChildren();
        }
        boolean handled = false;
        int action = event.getAction();
        if (KeyEvent.isConfirmKey(keyCode) && event.hasNoModifiers() && action != 1 && !(handled = this.resurrectSelectionIfNeeded()) && event.getRepeatCount() == 0 && this.getChildCount() > 0) {
            this.keyPressed();
            handled = true;
        }
        if (!handled && action != 1) {
            switch (keyCode) {
                case 19: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded();
                        if (handled) break;
                        while (count-- > 0 && this.arrowScroll(33)) {
                            handled = true;
                        }
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 20: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded();
                        if (handled) break;
                        while (count-- > 0 && this.arrowScroll(130)) {
                            handled = true;
                        }
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 21: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.handleHorizontalFocusWithinListItem(17);
                    break;
                }
                case 22: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.handleHorizontalFocusWithinListItem(66);
                    break;
                }
                case 92: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(33);
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 93: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.pageScroll(130);
                        break;
                    }
                    if (!event.hasModifiers(2)) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 122: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(33);
                    break;
                }
                case 123: {
                    if (!event.hasNoModifiers()) break;
                    handled = this.resurrectSelectionIfNeeded() || this.fullScroll(130);
                    break;
                }
                case 61: {
                    if (event.hasNoModifiers()) {
                        handled = this.resurrectSelectionIfNeeded() || this.arrowScroll(130);
                        break;
                    }
                    if (!event.hasModifiers(1)) break;
                    boolean bl = handled = this.resurrectSelectionIfNeeded() || this.arrowScroll(33);
                }
            }
        }
        if (handled) {
            return true;
        }
        if (this.sendToTextFilter(keyCode, count, event)) {
            return true;
        }
        switch (action) {
            case 0: {
                return super.onKeyDown(keyCode, event);
            }
            case 1: {
                return super.onKeyUp(keyCode, event);
            }
            case 2: {
                return super.onKeyMultiple(keyCode, count, event);
            }
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ListView$pageScroll(int direction) {
        int position;
        boolean down;
        int nextPage;
        if (direction == 33) {
            nextPage = Math.max(0, this.mSelectedPosition - this.getChildCount() - 1);
            down = false;
        } else if (direction == 130) {
            nextPage = Math.min(this.mItemCount - 1, this.mSelectedPosition + this.getChildCount() - 1);
            down = true;
        } else {
            return false;
        }
        if (nextPage >= 0 && (position = this.lookForSelectablePositionAfter(this.mSelectedPosition, nextPage, down)) >= 0) {
            this.mLayoutMode = 4;
            this.mSpecificTop = this.mPaddingTop + this.getVerticalFadingEdgeLength();
            if (down && position > this.mItemCount - this.getChildCount()) {
                this.mLayoutMode = 3;
            }
            if (!down && position < this.getChildCount()) {
                this.mLayoutMode = 1;
            }
            this.setSelectionInt(position);
            this.invokeOnItemScrollListener();
            if (!this.awakenScrollBars()) {
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_ListView$fullScroll(int direction) {
        int lastItem;
        boolean moved = false;
        if (direction == 33) {
            if (this.mSelectedPosition != 0) {
                int position = this.lookForSelectablePositionAfter(this.mSelectedPosition, 0, true);
                if (position >= 0) {
                    this.mLayoutMode = 1;
                    this.setSelectionInt(position);
                    this.invokeOnItemScrollListener();
                }
                moved = true;
            }
        } else if (direction == 130 && this.mSelectedPosition < (lastItem = this.mItemCount - 1)) {
            int position = this.lookForSelectablePositionAfter(this.mSelectedPosition, lastItem, false);
            if (position >= 0) {
                this.mLayoutMode = 3;
                this.setSelectionInt(position);
                this.invokeOnItemScrollListener();
            }
            moved = true;
        }
        if (moved && !this.awakenScrollBars()) {
            this.awakenScrollBars();
            this.invalidate();
        }
        return moved;
    }

    private final boolean $$robo$$android_widget_ListView$handleHorizontalFocusWithinListItem(int direction) {
        View selectedView;
        if (direction != 17 && direction != 66) {
            throw new IllegalArgumentException("direction must be one of {View.FOCUS_LEFT, View.FOCUS_RIGHT}");
        }
        int numChildren = this.getChildCount();
        if (this.mItemsCanFocus && numChildren > 0 && this.mSelectedPosition != -1 && (selectedView = this.getSelectedView()) != null && selectedView.hasFocus() && selectedView instanceof ViewGroup) {
            View globalNextFocus;
            View currentFocus = selectedView.findFocus();
            View nextFocus = FocusFinder.getInstance().findNextFocus((ViewGroup)selectedView, currentFocus, direction);
            if (nextFocus != null) {
                Rect focusedRect = this.mTempRect;
                if (currentFocus != null) {
                    currentFocus.getFocusedRect(focusedRect);
                    this.offsetDescendantRectToMyCoords(currentFocus, focusedRect);
                    this.offsetRectIntoDescendantCoords(nextFocus, focusedRect);
                } else {
                    focusedRect = null;
                }
                if (nextFocus.requestFocus(direction, focusedRect)) {
                    return true;
                }
            }
            if ((globalNextFocus = FocusFinder.getInstance().findNextFocus((ViewGroup)this.getRootView(), currentFocus, direction)) != null) {
                return this.isViewAncestorOf(globalNextFocus, this);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_widget_ListView$arrowScroll(int direction) {
        try {
            this.mInLayout = true;
            boolean handled = this.arrowScrollImpl(direction);
            if (handled) {
                this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
            }
            boolean bl = handled;
            return bl;
        }
        finally {
            this.mInLayout = false;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final int $$robo$$android_widget_ListView$nextSelectedPositionForDirection(View selectedView, int selectedPos, int direction) {
        int nextSelected;
        if (direction == 130) {
            int listBottom = this.getHeight() - this.mListPadding.bottom;
            if (selectedView == null || selectedView.getBottom() > listBottom) return -1;
            nextSelected = selectedPos != -1 && selectedPos >= this.mFirstPosition ? selectedPos + 1 : this.mFirstPosition;
        } else {
            int listTop = this.mListPadding.top;
            if (selectedView == null || selectedView.getTop() < listTop) return -1;
            int lastPos = this.mFirstPosition + this.getChildCount() - 1;
            nextSelected = selectedPos != -1 && selectedPos <= lastPos ? selectedPos - 1 : lastPos;
        }
        if (nextSelected >= 0 && nextSelected < this.mAdapter.getCount()) return this.lookForSelectablePosition(nextSelected, direction == 130);
        return -1;
    }

    private final boolean $$robo$$android_widget_ListView$arrowScrollImpl(int direction) {
        View focused;
        boolean needToRedraw;
        ArrowScrollFocusResult focusResult;
        if (this.getChildCount() <= 0) {
            return false;
        }
        View selectedView = this.getSelectedView();
        int selectedPos = this.mSelectedPosition;
        int nextSelectedPosition = this.nextSelectedPositionForDirection(selectedView, selectedPos, direction);
        int amountToScroll = this.amountToScroll(direction, nextSelectedPosition);
        ArrowScrollFocusResult arrowScrollFocusResult = focusResult = this.mItemsCanFocus ? this.arrowScrollFocused(direction) : null;
        if (focusResult != null) {
            nextSelectedPosition = focusResult.getSelectedPosition();
            amountToScroll = focusResult.getAmountToScroll();
        }
        boolean bl = needToRedraw = focusResult != null;
        if (nextSelectedPosition != -1) {
            this.handleNewSelectionChange(selectedView, direction, nextSelectedPosition, focusResult != null);
            this.setSelectedPositionInt(nextSelectedPosition);
            this.setNextSelectedPositionInt(nextSelectedPosition);
            selectedView = this.getSelectedView();
            selectedPos = nextSelectedPosition;
            if (this.mItemsCanFocus && focusResult == null && (focused = this.getFocusedChild()) != null) {
                focused.clearFocus();
            }
            needToRedraw = true;
            this.checkSelectionChanged();
        }
        if (amountToScroll > 0) {
            this.scrollListItemsBy(direction == 33 ? amountToScroll : -amountToScroll);
            needToRedraw = true;
        }
        if (this.mItemsCanFocus && focusResult == null && selectedView != null && selectedView.hasFocus() && (focused = selectedView.findFocus()) != null && (!this.isViewAncestorOf(focused, this) || this.distanceToView(focused) > 0)) {
            focused.clearFocus();
        }
        if (nextSelectedPosition == -1 && selectedView != null && !this.isViewAncestorOf(selectedView, this)) {
            selectedView = null;
            this.hideSelector();
            this.mResurrectToPosition = -1;
        }
        if (needToRedraw) {
            if (selectedView != null) {
                this.positionSelectorLikeFocus(selectedPos, selectedView);
                this.mSelectedTop = selectedView.getTop();
            }
            if (!this.awakenScrollBars()) {
                this.invalidate();
            }
            this.invokeOnItemScrollListener();
            return true;
        }
        return false;
    }

    private final void $$robo$$android_widget_ListView$handleNewSelectionChange(View selectedView, int direction, int newSelectedPosition, boolean newFocusAssigned) {
        View bottomView;
        View topView;
        int bottomViewIndex;
        int topViewIndex;
        if (newSelectedPosition == -1) {
            throw new IllegalArgumentException("newSelectedPosition needs to be valid");
        }
        boolean topSelected = false;
        int selectedIndex = this.mSelectedPosition - this.mFirstPosition;
        int nextSelectedIndex = newSelectedPosition - this.mFirstPosition;
        if (direction == 33) {
            topViewIndex = nextSelectedIndex;
            bottomViewIndex = selectedIndex;
            topView = this.getChildAt(topViewIndex);
            bottomView = selectedView;
            topSelected = true;
        } else {
            topViewIndex = selectedIndex;
            bottomViewIndex = nextSelectedIndex;
            topView = selectedView;
            bottomView = this.getChildAt(bottomViewIndex);
        }
        int numChildren = this.getChildCount();
        if (topView != null) {
            topView.setSelected(!newFocusAssigned && topSelected);
            this.measureAndAdjustDown(topView, topViewIndex, numChildren);
        }
        if (bottomView != null) {
            bottomView.setSelected(!newFocusAssigned && !topSelected);
            this.measureAndAdjustDown(bottomView, bottomViewIndex, numChildren);
        }
    }

    private final void $$robo$$android_widget_ListView$measureAndAdjustDown(View child, int childIndex, int numChildren) {
        int oldHeight = child.getHeight();
        this.measureItem(child);
        if (child.getMeasuredHeight() != oldHeight) {
            this.relayoutMeasuredItem(child);
            int heightDelta = child.getMeasuredHeight() - oldHeight;
            for (int i = childIndex + 1; i < numChildren; ++i) {
                this.getChildAt(i).offsetTopAndBottom(heightDelta);
            }
        }
    }

    private final void $$robo$$android_widget_ListView$measureItem(View child) {
        ViewGroup.LayoutParams p = child.getLayoutParams();
        if (p == null) {
            p = new ViewGroup.LayoutParams(-1, -2);
        }
        int childWidthSpec = ViewGroup.getChildMeasureSpec(this.mWidthMeasureSpec, this.mListPadding.left + this.mListPadding.right, p.width);
        int lpHeight = p.height;
        int childHeightSpec = lpHeight > 0 ? View.MeasureSpec.makeMeasureSpec(lpHeight, 0x40000000) : View.MeasureSpec.makeSafeMeasureSpec(this.getMeasuredHeight(), 0);
        child.measure(childWidthSpec, childHeightSpec);
    }

    private final void $$robo$$android_widget_ListView$relayoutMeasuredItem(View child) {
        int w = child.getMeasuredWidth();
        int h = child.getMeasuredHeight();
        int childLeft = this.mListPadding.left;
        int childRight = childLeft + w;
        int childTop = child.getTop();
        int childBottom = childTop + h;
        child.layout(childLeft, childTop, childRight, childBottom);
    }

    private final int $$robo$$android_widget_ListView$getArrowScrollPreviewLength() {
        return Math.max(2, this.getVerticalFadingEdgeLength());
    }

    private final int $$robo$$android_widget_ListView$amountToScroll(int direction, int nextSelectedPosition) {
        int listBottom = this.getHeight() - this.mListPadding.bottom;
        int listTop = this.mListPadding.top;
        int numChildren = this.getChildCount();
        if (direction == 130) {
            int indexToMakeVisible = numChildren - 1;
            if (nextSelectedPosition != -1) {
                indexToMakeVisible = nextSelectedPosition - this.mFirstPosition;
            }
            while (numChildren <= indexToMakeVisible) {
                this.addViewBelow(this.getChildAt(numChildren - 1), this.mFirstPosition + numChildren - 1);
                ++numChildren;
            }
            int positionToMakeVisible = this.mFirstPosition + indexToMakeVisible;
            View viewToMakeVisible = this.getChildAt(indexToMakeVisible);
            int goalBottom = listBottom;
            if (positionToMakeVisible < this.mItemCount - 1) {
                goalBottom -= this.getArrowScrollPreviewLength();
            }
            if (viewToMakeVisible.getBottom() <= goalBottom) {
                return 0;
            }
            if (nextSelectedPosition != -1 && goalBottom - viewToMakeVisible.getTop() >= this.getMaxScrollAmount()) {
                return 0;
            }
            int amountToScroll = viewToMakeVisible.getBottom() - goalBottom;
            if (this.mFirstPosition + numChildren == this.mItemCount) {
                int max = this.getChildAt(numChildren - 1).getBottom() - listBottom;
                amountToScroll = Math.min(amountToScroll, max);
            }
            return Math.min(amountToScroll, this.getMaxScrollAmount());
        }
        int indexToMakeVisible = 0;
        if (nextSelectedPosition != -1) {
            indexToMakeVisible = nextSelectedPosition - this.mFirstPosition;
        }
        while (indexToMakeVisible < 0) {
            this.addViewAbove(this.getChildAt(0), this.mFirstPosition);
            --this.mFirstPosition;
            indexToMakeVisible = nextSelectedPosition - this.mFirstPosition;
        }
        int positionToMakeVisible = this.mFirstPosition + indexToMakeVisible;
        View viewToMakeVisible = this.getChildAt(indexToMakeVisible);
        int goalTop = listTop;
        if (positionToMakeVisible > 0) {
            goalTop += this.getArrowScrollPreviewLength();
        }
        if (viewToMakeVisible.getTop() >= goalTop) {
            return 0;
        }
        if (nextSelectedPosition != -1 && viewToMakeVisible.getBottom() - goalTop >= this.getMaxScrollAmount()) {
            return 0;
        }
        int amountToScroll = goalTop - viewToMakeVisible.getTop();
        if (this.mFirstPosition == 0) {
            int max = listTop - this.getChildAt(0).getTop();
            amountToScroll = Math.min(amountToScroll, max);
        }
        return Math.min(amountToScroll, this.getMaxScrollAmount());
    }

    private final int $$robo$$android_widget_ListView$lookForSelectablePositionOnScreen(int direction) {
        int firstPosition = this.mFirstPosition;
        if (direction == 130) {
            int startPos;
            int n = startPos = this.mSelectedPosition != -1 ? this.mSelectedPosition + 1 : firstPosition;
            if (startPos >= this.mAdapter.getCount()) {
                return -1;
            }
            if (startPos < firstPosition) {
                startPos = firstPosition;
            }
            int lastVisiblePos = this.getLastVisiblePosition();
            Adapter adapter = this.getAdapter();
            for (int pos = startPos; pos <= lastVisiblePos; ++pos) {
                if (!adapter.isEnabled(pos) || this.getChildAt(pos - firstPosition).getVisibility() != 0) continue;
                return pos;
            }
        } else {
            int startPos;
            int last = firstPosition + this.getChildCount() - 1;
            int n = startPos = this.mSelectedPosition != -1 ? this.mSelectedPosition - 1 : firstPosition + this.getChildCount() - 1;
            if (startPos < 0 || startPos >= this.mAdapter.getCount()) {
                return -1;
            }
            if (startPos > last) {
                startPos = last;
            }
            Adapter adapter = this.getAdapter();
            for (int pos = startPos; pos >= firstPosition; --pos) {
                if (!adapter.isEnabled(pos) || this.getChildAt(pos - firstPosition).getVisibility() != 0) continue;
                return pos;
            }
        }
        return -1;
    }

    private final ArrowScrollFocusResult $$robo$$android_widget_ListView$arrowScrollFocused(int direction) {
        View newFocus;
        View selectedView = this.getSelectedView();
        if (selectedView != null && selectedView.hasFocus()) {
            View oldFocus = selectedView.findFocus();
            newFocus = FocusFinder.getInstance().findNextFocus(this, oldFocus, direction);
        } else {
            int ySearchPoint;
            if (direction == 130) {
                boolean topFadingEdgeShowing = this.mFirstPosition > 0;
                int listTop = this.mListPadding.top + (topFadingEdgeShowing ? this.getArrowScrollPreviewLength() : 0);
                ySearchPoint = selectedView != null && selectedView.getTop() > listTop ? selectedView.getTop() : listTop;
                this.mTempRect.set(0, ySearchPoint, 0, ySearchPoint);
            } else {
                boolean bottomFadingEdgeShowing = this.mFirstPosition + this.getChildCount() - 1 < this.mItemCount;
                int listBottom = this.getHeight() - this.mListPadding.bottom - (bottomFadingEdgeShowing ? this.getArrowScrollPreviewLength() : 0);
                ySearchPoint = selectedView != null && selectedView.getBottom() < listBottom ? selectedView.getBottom() : listBottom;
                this.mTempRect.set(0, ySearchPoint, 0, ySearchPoint);
            }
            newFocus = FocusFinder.getInstance().findNextFocusFromRect(this, this.mTempRect, direction);
        }
        if (newFocus != null) {
            int maxScrollAmount;
            int selectablePosition;
            int positionOfNewFocus = this.positionOfNewFocus(newFocus);
            if (this.mSelectedPosition != -1 && positionOfNewFocus != this.mSelectedPosition && (selectablePosition = this.lookForSelectablePositionOnScreen(direction)) != -1 && (direction == 130 && selectablePosition < positionOfNewFocus || direction == 33 && selectablePosition > positionOfNewFocus)) {
                return null;
            }
            int focusScroll = this.amountToScrollToNewFocus(direction, newFocus, positionOfNewFocus);
            if (focusScroll < (maxScrollAmount = this.getMaxScrollAmount())) {
                newFocus.requestFocus(direction);
                this.mArrowScrollFocusResult.populate(positionOfNewFocus, focusScroll);
                return this.mArrowScrollFocusResult;
            }
            if (this.distanceToView(newFocus) < maxScrollAmount) {
                newFocus.requestFocus(direction);
                this.mArrowScrollFocusResult.populate(positionOfNewFocus, maxScrollAmount);
                return this.mArrowScrollFocusResult;
            }
        }
        return null;
    }

    private final int $$robo$$android_widget_ListView$positionOfNewFocus(View newFocus) {
        int numChildren = this.getChildCount();
        for (int i = 0; i < numChildren; ++i) {
            View child = this.getChildAt(i);
            if (!this.isViewAncestorOf(newFocus, child)) continue;
            return this.mFirstPosition + i;
        }
        throw new IllegalArgumentException("newFocus is not a child of any of the children of the list!");
    }

    private final boolean $$robo$$android_widget_ListView$isViewAncestorOf(View child, View parent) {
        if (child == parent) {
            return true;
        }
        ViewParent theParent = child.getParent();
        return theParent instanceof ViewGroup && this.isViewAncestorOf((View)((Object)theParent), parent);
    }

    private final int $$robo$$android_widget_ListView$amountToScrollToNewFocus(int direction, View newFocus, int positionOfNewFocus) {
        int amountToScroll = 0;
        newFocus.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(newFocus, this.mTempRect);
        if (direction == 33) {
            if (this.mTempRect.top < this.mListPadding.top) {
                amountToScroll = this.mListPadding.top - this.mTempRect.top;
                if (positionOfNewFocus > 0) {
                    amountToScroll += this.getArrowScrollPreviewLength();
                }
            }
        } else {
            int listBottom = this.getHeight() - this.mListPadding.bottom;
            if (this.mTempRect.bottom > listBottom) {
                amountToScroll = this.mTempRect.bottom - listBottom;
                if (positionOfNewFocus < this.mItemCount - 1) {
                    amountToScroll += this.getArrowScrollPreviewLength();
                }
            }
        }
        return amountToScroll;
    }

    private final int $$robo$$android_widget_ListView$distanceToView(View descendant) {
        int distance = 0;
        descendant.getDrawingRect(this.mTempRect);
        this.offsetDescendantRectToMyCoords(descendant, this.mTempRect);
        int listBottom = this.mBottom - this.mTop - this.mListPadding.bottom;
        if (this.mTempRect.bottom < this.mListPadding.top) {
            distance = this.mListPadding.top - this.mTempRect.bottom;
        } else if (this.mTempRect.top > listBottom) {
            distance = this.mTempRect.top - listBottom;
        }
        return distance;
    }

    private final void $$robo$$android_widget_ListView$scrollListItemsBy(int amount) {
        this.offsetChildrenTopAndBottom(amount);
        int listBottom = this.getHeight() - this.mListPadding.bottom;
        int listTop = this.mListPadding.top;
        AbsListView.RecycleBin recycleBin = this.mRecycler;
        if (amount < 0) {
            int lastVisiblePosition;
            int numChildren = this.getChildCount();
            View last = this.getChildAt(numChildren - 1);
            while (last.getBottom() < listBottom && (lastVisiblePosition = this.mFirstPosition + numChildren - 1) < this.mItemCount - 1) {
                last = this.addViewBelow(last, lastVisiblePosition);
                ++numChildren;
            }
            if (last.getBottom() < listBottom) {
                this.offsetChildrenTopAndBottom(listBottom - last.getBottom());
            }
            View first = this.getChildAt(0);
            while (first.getBottom() < listTop) {
                AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)first.getLayoutParams();
                if (recycleBin.shouldRecycleViewType(layoutParams.viewType)) {
                    recycleBin.addScrapView(first, this.mFirstPosition);
                }
                this.detachViewFromParent(first);
                first = this.getChildAt(0);
                ++this.mFirstPosition;
            }
        } else {
            View first = this.getChildAt(0);
            while (first.getTop() > listTop && this.mFirstPosition > 0) {
                first = this.addViewAbove(first, this.mFirstPosition);
                --this.mFirstPosition;
            }
            if (first.getTop() > listTop) {
                this.offsetChildrenTopAndBottom(listTop - first.getTop());
            }
            int lastIndex = this.getChildCount() - 1;
            View last = this.getChildAt(lastIndex);
            while (last.getTop() > listBottom) {
                AbsListView.LayoutParams layoutParams = (AbsListView.LayoutParams)last.getLayoutParams();
                if (recycleBin.shouldRecycleViewType(layoutParams.viewType)) {
                    recycleBin.addScrapView(last, this.mFirstPosition + lastIndex);
                }
                this.detachViewFromParent(last);
                last = this.getChildAt(--lastIndex);
            }
        }
        recycleBin.fullyDetachScrapViews();
        this.removeUnusedFixedViews(this.mHeaderViewInfos);
        this.removeUnusedFixedViews(this.mFooterViewInfos);
    }

    private final View $$robo$$android_widget_ListView$addViewAbove(View theView, int position) {
        int abovePosition = position - 1;
        View view = this.obtainView(abovePosition, this.mIsScrap);
        int edgeOfNewChild = theView.getTop() - this.mDividerHeight;
        this.setupChild(view, abovePosition, edgeOfNewChild, false, this.mListPadding.left, false, this.mIsScrap[0]);
        return view;
    }

    private final View $$robo$$android_widget_ListView$addViewBelow(View theView, int position) {
        int belowPosition = position + 1;
        View view = this.obtainView(belowPosition, this.mIsScrap);
        int edgeOfNewChild = theView.getBottom() + this.mDividerHeight;
        this.setupChild(view, belowPosition, edgeOfNewChild, true, this.mListPadding.left, false, this.mIsScrap[0]);
        return view;
    }

    private final void $$robo$$android_widget_ListView$setItemsCanFocus(boolean itemsCanFocus) {
        this.mItemsCanFocus = itemsCanFocus;
        if (!itemsCanFocus) {
            this.setDescendantFocusability(393216);
        }
    }

    private final boolean $$robo$$android_widget_ListView$getItemsCanFocus() {
        return this.mItemsCanFocus;
    }

    private final boolean $$robo$$android_widget_ListView$isOpaque() {
        boolean retValue;
        boolean bl = retValue = this.mCachingActive && this.mIsCacheColorOpaque && this.mDividerIsOpaque && this.hasOpaqueScrollbars() || super.isOpaque();
        if (retValue) {
            int listTop = this.mListPadding != null ? this.mListPadding.top : this.mPaddingTop;
            View first = this.getChildAt(0);
            if (first == null || first.getTop() > listTop) {
                return false;
            }
            int listBottom = this.getHeight() - (this.mListPadding != null ? this.mListPadding.bottom : this.mPaddingBottom);
            View last = this.getChildAt(this.getChildCount() - 1);
            if (last == null || last.getBottom() < listBottom) {
                return false;
            }
        }
        return retValue;
    }

    private final void $$robo$$android_widget_ListView$setCacheColorHint(int color2) {
        boolean opaque;
        this.mIsCacheColorOpaque = opaque = color2 >>> 24 == 255;
        if (opaque) {
            if (this.mDividerPaint == null) {
                this.mDividerPaint = new Paint();
            }
            this.mDividerPaint.setColor(color2);
        }
        super.setCacheColorHint(color2);
    }

    private final void $$robo$$android_widget_ListView$drawOverscrollHeader(Canvas canvas, Drawable drawable2, Rect bounds) {
        int height = drawable2.getMinimumHeight();
        canvas.save();
        canvas.clipRect(bounds);
        int span = bounds.bottom - bounds.top;
        if (span < height) {
            bounds.top = bounds.bottom - height;
        }
        drawable2.setBounds(bounds);
        drawable2.draw(canvas);
        canvas.restore();
    }

    private final void $$robo$$android_widget_ListView$drawOverscrollFooter(Canvas canvas, Drawable drawable2, Rect bounds) {
        int height = drawable2.getMinimumHeight();
        canvas.save();
        canvas.clipRect(bounds);
        int span = bounds.bottom - bounds.top;
        if (span < height) {
            bounds.bottom = bounds.top + height;
        }
        drawable2.setBounds(bounds);
        drawable2.draw(canvas);
        canvas.restore();
    }

    private final void $$robo$$android_widget_ListView$dispatchDraw(Canvas canvas) {
        boolean drawDividers;
        if (this.mCachingStarted) {
            this.mCachingActive = true;
        }
        int dividerHeight = this.mDividerHeight;
        Drawable overscrollHeader = this.mOverScrollHeader;
        Drawable overscrollFooter = this.mOverScrollFooter;
        boolean drawOverscrollHeader = overscrollHeader != null;
        boolean drawOverscrollFooter = overscrollFooter != null;
        boolean bl = drawDividers = dividerHeight > 0 && this.mDivider != null;
        if (drawDividers || drawOverscrollHeader || drawOverscrollFooter) {
            boolean fillForMissingDividers;
            Rect bounds = this.mTempRect;
            bounds.left = this.mPaddingLeft;
            bounds.right = this.mRight - this.mLeft - this.mPaddingRight;
            int count = this.getChildCount();
            int headerCount = this.getHeaderViewsCount();
            int itemCount = this.mItemCount;
            int footerLimit = itemCount - this.mFooterViewInfos.size();
            boolean headerDividers = this.mHeaderDividersEnabled;
            boolean footerDividers = this.mFooterDividersEnabled;
            int first = this.mFirstPosition;
            boolean areAllItemsSelectable = this.mAreAllItemsSelectable;
            ListAdapter adapter = this.mAdapter;
            boolean bl2 = fillForMissingDividers = this.isOpaque() && !super.isOpaque();
            if (fillForMissingDividers && this.mDividerPaint == null && this.mIsCacheColorOpaque) {
                this.mDividerPaint = new Paint();
                this.mDividerPaint.setColor(this.getCacheColorHint());
            }
            Paint paint = this.mDividerPaint;
            int effectivePaddingTop = 0;
            int effectivePaddingBottom = 0;
            if ((this.mGroupFlags & 0x22) == 34) {
                effectivePaddingTop = this.mListPadding.top;
                effectivePaddingBottom = this.mListPadding.bottom;
            }
            int listBottom = this.mBottom - this.mTop - effectivePaddingBottom + this.mScrollY;
            if (!this.mStackFromBottom) {
                int bottom = 0;
                int scrollY = this.mScrollY;
                if (count > 0 && scrollY < 0) {
                    if (drawOverscrollHeader) {
                        bounds.bottom = 0;
                        bounds.top = scrollY;
                        this.drawOverscrollHeader(canvas, overscrollHeader, bounds);
                    } else if (drawDividers) {
                        bounds.bottom = 0;
                        bounds.top = -dividerHeight;
                        this.drawDivider(canvas, bounds, -1);
                    }
                }
                for (int i = 0; i < count; ++i) {
                    boolean isLastItem;
                    boolean isFooter;
                    int itemIndex = first + i;
                    boolean isHeader = itemIndex < headerCount;
                    boolean bl3 = isFooter = itemIndex >= footerLimit;
                    if (!headerDividers && isHeader || !footerDividers && isFooter) continue;
                    View child = this.getChildAt(i);
                    bottom = child.getBottom();
                    boolean bl4 = isLastItem = i == count - 1;
                    if (!drawDividers || bottom >= listBottom || drawOverscrollFooter && isLastItem) continue;
                    int nextIndex = itemIndex + 1;
                    if (adapter.isEnabled(itemIndex) && (headerDividers || !isHeader && nextIndex >= headerCount) && (isLastItem || adapter.isEnabled(nextIndex) && (footerDividers || !isFooter && nextIndex < footerLimit))) {
                        bounds.top = bottom;
                        bounds.bottom = bottom + dividerHeight;
                        this.drawDivider(canvas, bounds, i);
                        continue;
                    }
                    if (!fillForMissingDividers) continue;
                    bounds.top = bottom;
                    bounds.bottom = bottom + dividerHeight;
                    canvas.drawRect(bounds, paint);
                }
                int overFooterBottom = this.mBottom + this.mScrollY;
                if (drawOverscrollFooter && first + count == itemCount && overFooterBottom > bottom) {
                    bounds.top = bottom;
                    bounds.bottom = overFooterBottom;
                    this.drawOverscrollFooter(canvas, overscrollFooter, bounds);
                }
            } else {
                int start;
                int scrollY = this.mScrollY;
                if (count > 0 && drawOverscrollHeader) {
                    bounds.top = scrollY;
                    bounds.bottom = this.getChildAt(0).getTop();
                    this.drawOverscrollHeader(canvas, overscrollHeader, bounds);
                }
                for (int i = start = drawOverscrollHeader ? 1 : 0; i < count; ++i) {
                    boolean isFooter;
                    int itemIndex = first + i;
                    boolean isHeader = itemIndex < headerCount;
                    boolean bl5 = isFooter = itemIndex >= footerLimit;
                    if (!headerDividers && isHeader || !footerDividers && isFooter) continue;
                    View child = this.getChildAt(i);
                    int top = child.getTop();
                    if (!drawDividers || top <= effectivePaddingTop) continue;
                    boolean isFirstItem = i == start;
                    int previousIndex = itemIndex - 1;
                    if (adapter.isEnabled(itemIndex) && (headerDividers || !isHeader && previousIndex >= headerCount) && (isFirstItem || adapter.isEnabled(previousIndex) && (footerDividers || !isFooter && previousIndex < footerLimit))) {
                        bounds.top = top - dividerHeight;
                        bounds.bottom = top;
                        this.drawDivider(canvas, bounds, i - 1);
                        continue;
                    }
                    if (!fillForMissingDividers) continue;
                    bounds.top = top - dividerHeight;
                    bounds.bottom = top;
                    canvas.drawRect(bounds, paint);
                }
                if (count > 0 && scrollY > 0) {
                    if (drawOverscrollFooter) {
                        int absListBottom;
                        bounds.top = absListBottom = this.mBottom;
                        bounds.bottom = absListBottom + scrollY;
                        this.drawOverscrollFooter(canvas, overscrollFooter, bounds);
                    } else if (drawDividers) {
                        bounds.top = listBottom;
                        bounds.bottom = listBottom + dividerHeight;
                        this.drawDivider(canvas, bounds, -1);
                    }
                }
            }
        }
        super.dispatchDraw(canvas);
    }

    private final boolean $$robo$$android_widget_ListView$drawChild(Canvas canvas, View child, long drawingTime) {
        boolean more = super.drawChild(canvas, child, drawingTime);
        if (this.mCachingActive && child.mCachingFailed) {
            this.mCachingActive = false;
        }
        return more;
    }

    private final void $$robo$$android_widget_ListView$drawDivider(Canvas canvas, Rect bounds, int childIndex) {
        Drawable divider = this.mDivider;
        divider.setBounds(bounds);
        divider.draw(canvas);
    }

    private final Drawable $$robo$$android_widget_ListView$getDivider() {
        return this.mDivider;
    }

    private final void $$robo$$android_widget_ListView$setDivider(Drawable divider) {
        this.mDividerHeight = divider != null ? divider.getIntrinsicHeight() : 0;
        this.mDivider = divider;
        this.mDividerIsOpaque = divider == null || divider.getOpacity() == -1;
        this.requestLayout();
        this.invalidate();
    }

    private final int $$robo$$android_widget_ListView$getDividerHeight() {
        return this.mDividerHeight;
    }

    private final void $$robo$$android_widget_ListView$setDividerHeight(int height) {
        this.mDividerHeight = height;
        this.requestLayout();
        this.invalidate();
    }

    private final void $$robo$$android_widget_ListView$setHeaderDividersEnabled(boolean headerDividersEnabled) {
        this.mHeaderDividersEnabled = headerDividersEnabled;
        this.invalidate();
    }

    private final boolean $$robo$$android_widget_ListView$areHeaderDividersEnabled() {
        return this.mHeaderDividersEnabled;
    }

    private final void $$robo$$android_widget_ListView$setFooterDividersEnabled(boolean footerDividersEnabled) {
        this.mFooterDividersEnabled = footerDividersEnabled;
        this.invalidate();
    }

    private final boolean $$robo$$android_widget_ListView$areFooterDividersEnabled() {
        return this.mFooterDividersEnabled;
    }

    private final void $$robo$$android_widget_ListView$setOverscrollHeader(Drawable header) {
        this.mOverScrollHeader = header;
        if (this.mScrollY < 0) {
            this.invalidate();
        }
    }

    private final Drawable $$robo$$android_widget_ListView$getOverscrollHeader() {
        return this.mOverScrollHeader;
    }

    private final void $$robo$$android_widget_ListView$setOverscrollFooter(Drawable footer) {
        this.mOverScrollFooter = footer;
        this.invalidate();
    }

    private final Drawable $$robo$$android_widget_ListView$getOverscrollFooter() {
        return this.mOverScrollFooter;
    }

    private final void $$robo$$android_widget_ListView$onFocusChanged(boolean gainFocus, int direction, Rect previouslyFocusedRect) {
        super.onFocusChanged(gainFocus, direction, previouslyFocusedRect);
        ListAdapter adapter = this.mAdapter;
        int closetChildIndex = -1;
        int closestChildTop = 0;
        if (adapter != null && gainFocus && previouslyFocusedRect != null) {
            previouslyFocusedRect.offset(this.mScrollX, this.mScrollY);
            if (adapter.getCount() < this.getChildCount() + this.mFirstPosition) {
                this.mLayoutMode = 0;
                this.layoutChildren();
            }
            Rect otherRect = this.mTempRect;
            int minDistance = Integer.MAX_VALUE;
            int childCount = this.getChildCount();
            int firstPosition = this.mFirstPosition;
            for (int i = 0; i < childCount; ++i) {
                if (!adapter.isEnabled(firstPosition + i)) continue;
                View other = this.getChildAt(i);
                other.getDrawingRect(otherRect);
                this.offsetDescendantRectToMyCoords(other, otherRect);
                int distance = ListView.getDistance(previouslyFocusedRect, otherRect, direction);
                if (distance >= minDistance) continue;
                minDistance = distance;
                closetChildIndex = i;
                closestChildTop = other.getTop();
            }
        }
        if (closetChildIndex >= 0) {
            this.setSelectionFromTop(closetChildIndex + this.mFirstPosition, closestChildTop);
        } else {
            this.requestLayout();
        }
    }

    private final void $$robo$$android_widget_ListView$onFinishInflate() {
        super.onFinishInflate();
        int count = this.getChildCount();
        if (count > 0) {
            for (int i = 0; i < count; ++i) {
                this.addHeaderView(this.getChildAt(i));
            }
            this.removeAllViews();
        }
    }

    private final <T extends View> T $$robo$$android_widget_ListView$findViewTraversal(int id2) {
        Object v = super.findViewTraversal(id2);
        if (v == null) {
            v = this.findViewInHeadersOrFooters(this.mHeaderViewInfos, id2);
            if (v != null) {
                return v;
            }
            v = this.findViewInHeadersOrFooters(this.mFooterViewInfos, id2);
            if (v != null) {
                return v;
            }
        }
        return v;
    }

    private final View $$robo$$android_widget_ListView$findViewInHeadersOrFooters(ArrayList<FixedViewInfo> where, int id2) {
        if (where != null) {
            int len = where.size();
            for (int i = 0; i < len; ++i) {
                View v = where.get((int)i).view;
                if (v.isRootNamespace() || (v = v.findViewById(id2)) == null) continue;
                return v;
            }
        }
        return null;
    }

    private final <T extends View> T $$robo$$android_widget_ListView$findViewWithTagTraversal(Object tag) {
        Object v = super.findViewWithTagTraversal(tag);
        if (v == null) {
            v = this.findViewWithTagInHeadersOrFooters(this.mHeaderViewInfos, tag);
            if (v != null) {
                return v;
            }
            v = this.findViewWithTagInHeadersOrFooters(this.mFooterViewInfos, tag);
            if (v != null) {
                return v;
            }
        }
        return v;
    }

    private final View $$robo$$android_widget_ListView$findViewWithTagInHeadersOrFooters(ArrayList<FixedViewInfo> where, Object tag) {
        if (where != null) {
            int len = where.size();
            for (int i = 0; i < len; ++i) {
                View v = where.get((int)i).view;
                if (v.isRootNamespace() || (v = v.findViewWithTag(tag)) == null) continue;
                return v;
            }
        }
        return null;
    }

    private final <T extends View> T $$robo$$android_widget_ListView$findViewByPredicateTraversal(Predicate<View> predicate, View childToSkip) {
        Object v = super.findViewByPredicateTraversal(predicate, childToSkip);
        if (v == null) {
            v = this.findViewByPredicateInHeadersOrFooters(this.mHeaderViewInfos, predicate, childToSkip);
            if (v != null) {
                return v;
            }
            v = this.findViewByPredicateInHeadersOrFooters(this.mFooterViewInfos, predicate, childToSkip);
            if (v != null) {
                return v;
            }
        }
        return v;
    }

    private final View $$robo$$android_widget_ListView$findViewByPredicateInHeadersOrFooters(ArrayList<FixedViewInfo> where, Predicate<View> predicate, View childToSkip) {
        if (where != null) {
            int len = where.size();
            for (int i = 0; i < len; ++i) {
                View v = where.get((int)i).view;
                if (v == childToSkip || v.isRootNamespace() || (v = v.findViewByPredicate(predicate)) == null) continue;
                return v;
            }
        }
        return null;
    }

    @Deprecated
    private final long[] $$robo$$android_widget_ListView$getCheckItemIds() {
        if (this.mAdapter != null && this.mAdapter.hasStableIds()) {
            return this.getCheckedItemIds();
        }
        if (this.mChoiceMode != 0 && this.mCheckStates != null && this.mAdapter != null) {
            SparseBooleanArray states = this.mCheckStates;
            int count = states.size();
            long[] ids = new long[count];
            ListAdapter adapter = this.mAdapter;
            int checkedCount = 0;
            for (int i = 0; i < count; ++i) {
                if (!states.valueAt(i)) continue;
                ids[checkedCount++] = adapter.getItemId(states.keyAt(i));
            }
            if (checkedCount == count) {
                return ids;
            }
            long[] result = new long[checkedCount];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (long[])ids, (int)0, (long[])result, (int)0, (int)checkedCount);
            return result;
        }
        return new long[0];
    }

    private final int $$robo$$android_widget_ListView$getHeightForPosition(int position) {
        int height = super.getHeightForPosition(position);
        if (this.shouldAdjustHeightForDivider(position)) {
            return height + this.mDividerHeight;
        }
        return height;
    }

    private final boolean $$robo$$android_widget_ListView$shouldAdjustHeightForDivider(int itemIndex) {
        boolean drawDividers;
        int dividerHeight = this.mDividerHeight;
        Drawable overscrollHeader = this.mOverScrollHeader;
        Drawable overscrollFooter = this.mOverScrollFooter;
        boolean drawOverscrollHeader = overscrollHeader != null;
        boolean drawOverscrollFooter = overscrollFooter != null;
        boolean bl = drawDividers = dividerHeight > 0 && this.mDivider != null;
        if (drawDividers) {
            boolean fillForMissingDividers = this.isOpaque() && !super.isOpaque();
            int itemCount = this.mItemCount;
            int headerCount = this.getHeaderViewsCount();
            int footerLimit = itemCount - this.mFooterViewInfos.size();
            boolean isHeader = itemIndex < headerCount;
            boolean isFooter = itemIndex >= footerLimit;
            boolean headerDividers = this.mHeaderDividersEnabled;
            boolean footerDividers = this.mFooterDividersEnabled;
            if (!(!headerDividers && isHeader || !footerDividers && isFooter)) {
                ListAdapter adapter = this.mAdapter;
                if (!this.mStackFromBottom) {
                    boolean isLastItem;
                    boolean bl2 = isLastItem = itemIndex == itemCount - 1;
                    if (!drawOverscrollFooter || !isLastItem) {
                        int nextIndex = itemIndex + 1;
                        if (adapter.isEnabled(itemIndex) && (headerDividers || !isHeader && nextIndex >= headerCount) && (isLastItem || adapter.isEnabled(nextIndex) && (footerDividers || !isFooter && nextIndex < footerLimit))) {
                            return true;
                        }
                        if (fillForMissingDividers) {
                            return true;
                        }
                    }
                } else {
                    boolean isFirstItem;
                    int start = drawOverscrollHeader ? 1 : 0;
                    boolean bl3 = isFirstItem = itemIndex == start;
                    if (!isFirstItem) {
                        int previousIndex = itemIndex - 1;
                        if (adapter.isEnabled(itemIndex) && (headerDividers || !isHeader && previousIndex >= headerCount) && (isFirstItem || adapter.isEnabled(previousIndex) && (footerDividers || !isFooter && previousIndex < footerLimit))) {
                            return true;
                        }
                        if (fillForMissingDividers) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final CharSequence $$robo$$android_widget_ListView$getAccessibilityClassName() {
        return ListView.class.getName();
    }

    private final void $$robo$$android_widget_ListView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        int rowsCount = this.getCount();
        int selectionMode = this.getSelectionModeForAccessibility();
        AccessibilityNodeInfo.CollectionInfo collectionInfo = AccessibilityNodeInfo.CollectionInfo.obtain(rowsCount, 1, false, selectionMode);
        info.setCollectionInfo(collectionInfo);
        if (rowsCount > 0) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_TO_POSITION);
        }
    }

    private final boolean $$robo$$android_widget_ListView$performAccessibilityActionInternal(int action, Bundle arguments) {
        if (super.performAccessibilityActionInternal(action, arguments)) {
            return true;
        }
        switch (action) {
            case 16908343: {
                int row = arguments.getInt("android.view.accessibility.action.ARGUMENT_ROW_INT", -1);
                int position = Math.min(row, this.getCount() - 1);
                if (row < 0) break;
                this.smoothScrollToPosition(position);
                return true;
            }
        }
        return false;
    }

    private final void $$robo$$android_widget_ListView$onInitializeAccessibilityNodeInfoForItem(View view, int position, AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoForItem(view, position, info);
        AbsListView.LayoutParams lp = (AbsListView.LayoutParams)view.getLayoutParams();
        boolean isHeading = lp != null && lp.viewType == -2;
        boolean isSelected = this.isItemChecked(position);
        AccessibilityNodeInfo.CollectionItemInfo itemInfo = AccessibilityNodeInfo.CollectionItemInfo.obtain(position, 1, 0, 1, isHeading, isSelected);
        info.setCollectionItemInfo(itemInfo);
    }

    private final void $$robo$$android_widget_ListView$encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("recycleOnMeasure", this.recycleOnMeasure());
    }

    private final HeaderViewListAdapter $$robo$$android_widget_ListView$wrapHeaderListAdapterInternal(ArrayList<FixedViewInfo> headerViewInfos, ArrayList<FixedViewInfo> footerViewInfos, ListAdapter adapter) {
        return new HeaderViewListAdapter(headerViewInfos, footerViewInfos, adapter);
    }

    private final void $$robo$$android_widget_ListView$wrapHeaderListAdapterInternal() {
        this.mAdapter = this.wrapHeaderListAdapterInternal(this.mHeaderViewInfos, this.mFooterViewInfos, this.mAdapter);
    }

    private final void $$robo$$android_widget_ListView$dispatchDataSetObserverOnChangedInternal() {
        if (this.mDataSetObserver != null) {
            this.mDataSetObserver.onChanged();
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_ListView$__constructor__(context);
    }

    public ListView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_ListView$__constructor__(context, attributeSet);
    }

    public ListView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842868);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_ListView$__constructor__(context, attributeSet, n);
    }

    public ListView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_ListView$__constructor__(context, attributeSet, n, n2);
    }

    public ListView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    public int getMaxScrollAmount() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxScrollAmount", $$robo$$android_widget_ListView$getMaxScrollAmount(), this);
    }

    private void adjustViewsUpOrDown() {
        InvokeDynamicSupport.bootstrap("adjustViewsUpOrDown", $$robo$$android_widget_ListView$adjustViewsUpOrDown(), this);
    }

    public void addHeaderView(View view, Object object, boolean bl) {
        InvokeDynamicSupport.bootstrap("addHeaderView", $$robo$$android_widget_ListView$addHeaderView(android.view.View java.lang.Object boolean ), this, view, object, bl);
    }

    public void addHeaderView(View view) {
        InvokeDynamicSupport.bootstrap("addHeaderView", $$robo$$android_widget_ListView$addHeaderView(android.view.View ), this, view);
    }

    @Override
    public int getHeaderViewsCount() {
        return (int)InvokeDynamicSupport.bootstrap("getHeaderViewsCount", $$robo$$android_widget_ListView$getHeaderViewsCount(), this);
    }

    public boolean removeHeaderView(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeHeaderView", $$robo$$android_widget_ListView$removeHeaderView(android.view.View ), this, view);
    }

    private void removeFixedViewInfo(View view, ArrayList<FixedViewInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("removeFixedViewInfo", $$robo$$android_widget_ListView$removeFixedViewInfo(android.view.View java.util.ArrayList<android.widget.ListView$FixedViewInfo> ), this, view, arrayList);
    }

    public void addFooterView(View view, Object object, boolean bl) {
        InvokeDynamicSupport.bootstrap("addFooterView", $$robo$$android_widget_ListView$addFooterView(android.view.View java.lang.Object boolean ), this, view, object, bl);
    }

    public void addFooterView(View view) {
        InvokeDynamicSupport.bootstrap("addFooterView", $$robo$$android_widget_ListView$addFooterView(android.view.View ), this, view);
    }

    @Override
    public int getFooterViewsCount() {
        return (int)InvokeDynamicSupport.bootstrap("getFooterViewsCount", $$robo$$android_widget_ListView$getFooterViewsCount(), this);
    }

    public boolean removeFooterView(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeFooterView", $$robo$$android_widget_ListView$removeFooterView(android.view.View ), this, view);
    }

    @Override
    public ListAdapter getAdapter() {
        return InvokeDynamicSupport.bootstrap("getAdapter", $$robo$$android_widget_ListView$getAdapter(), this);
    }

    @Override
    @RemotableViewMethod(asyncImpl="setRemoteViewsAdapterAsync")
    public void setRemoteViewsAdapter(Intent intent) {
        InvokeDynamicSupport.bootstrap("setRemoteViewsAdapter", $$robo$$android_widget_ListView$setRemoteViewsAdapter(android.content.Intent ), this, intent);
    }

    @Override
    public void setAdapter(ListAdapter listAdapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_ListView$setAdapter(android.widget.ListAdapter ), this, listAdapter);
    }

    @Override
    void resetList() {
        InvokeDynamicSupport.bootstrap("resetList", $$robo$$android_widget_ListView$resetList(), this);
    }

    private void clearRecycledState(ArrayList<FixedViewInfo> arrayList) {
        InvokeDynamicSupport.bootstrap("clearRecycledState", $$robo$$android_widget_ListView$clearRecycledState(java.util.ArrayList<android.widget.ListView$FixedViewInfo> ), this, arrayList);
    }

    private boolean showingTopFadingEdge() {
        return (boolean)InvokeDynamicSupport.bootstrap("showingTopFadingEdge", $$robo$$android_widget_ListView$showingTopFadingEdge(), this);
    }

    private boolean showingBottomFadingEdge() {
        return (boolean)InvokeDynamicSupport.bootstrap("showingBottomFadingEdge", $$robo$$android_widget_ListView$showingBottomFadingEdge(), this);
    }

    @Override
    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("requestChildRectangleOnScreen", $$robo$$android_widget_ListView$requestChildRectangleOnScreen(android.view.View android.graphics.Rect boolean ), this, view, rect, bl);
    }

    @Override
    void fillGap(boolean bl) {
        InvokeDynamicSupport.bootstrap("fillGap", $$robo$$android_widget_ListView$fillGap(boolean ), this, bl);
    }

    private View fillDown(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("fillDown", $$robo$$android_widget_ListView$fillDown(int int ), this, n, n2);
    }

    private View fillUp(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("fillUp", $$robo$$android_widget_ListView$fillUp(int int ), this, n, n2);
    }

    private View fillFromTop(int n) {
        return InvokeDynamicSupport.bootstrap("fillFromTop", $$robo$$android_widget_ListView$fillFromTop(int ), this, n);
    }

    private View fillFromMiddle(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("fillFromMiddle", $$robo$$android_widget_ListView$fillFromMiddle(int int ), this, n, n2);
    }

    private void fillAboveAndBelow(View view, int n) {
        InvokeDynamicSupport.bootstrap("fillAboveAndBelow", $$robo$$android_widget_ListView$fillAboveAndBelow(android.view.View int ), this, view, n);
    }

    private View fillFromSelection(int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("fillFromSelection", $$robo$$android_widget_ListView$fillFromSelection(int int int ), this, n, n2, n3);
    }

    private int getBottomSelectionPixel(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("getBottomSelectionPixel", $$robo$$android_widget_ListView$getBottomSelectionPixel(int int int ), this, n, n2, n3);
    }

    private int getTopSelectionPixel(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("getTopSelectionPixel", $$robo$$android_widget_ListView$getTopSelectionPixel(int int int ), this, n, n2, n3);
    }

    @Override
    @RemotableViewMethod
    public void smoothScrollToPosition(int n) {
        InvokeDynamicSupport.bootstrap("smoothScrollToPosition", $$robo$$android_widget_ListView$smoothScrollToPosition(int ), this, n);
    }

    @Override
    @RemotableViewMethod
    public void smoothScrollByOffset(int n) {
        InvokeDynamicSupport.bootstrap("smoothScrollByOffset", $$robo$$android_widget_ListView$smoothScrollByOffset(int ), this, n);
    }

    private View moveSelection(View view, View view2, int n, int n2, int n3) {
        return InvokeDynamicSupport.bootstrap("moveSelection", $$robo$$android_widget_ListView$moveSelection(android.view.View android.view.View int int int ), this, view, view2, n, n2, n3);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_ListView$onDetachedFromWindow(), this);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_widget_ListView$onSizeChanged(int int int int ), this, n, n2, n3, n4);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_ListView$onMeasure(int int ), this, n, n2);
    }

    private void measureScrapChild(View view, int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("measureScrapChild", $$robo$$android_widget_ListView$measureScrapChild(android.view.View int int int ), this, view, n, n2, n3);
    }

    @ViewDebug.ExportedProperty(category="list")
    protected boolean recycleOnMeasure() {
        return (boolean)InvokeDynamicSupport.bootstrap("recycleOnMeasure", $$robo$$android_widget_ListView$recycleOnMeasure(), this);
    }

    int measureHeightOfChildren(int n, int n2, int n3, int n4, int n5) {
        return (int)InvokeDynamicSupport.bootstrap("measureHeightOfChildren", $$robo$$android_widget_ListView$measureHeightOfChildren(int int int int int ), this, n, n2, n3, n4, n5);
    }

    @Override
    int findMotionRow(int n) {
        return (int)InvokeDynamicSupport.bootstrap("findMotionRow", $$robo$$android_widget_ListView$findMotionRow(int ), this, n);
    }

    private View fillSpecific(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("fillSpecific", $$robo$$android_widget_ListView$fillSpecific(int int ), this, n, n2);
    }

    private void correctTooHigh(int n) {
        InvokeDynamicSupport.bootstrap("correctTooHigh", $$robo$$android_widget_ListView$correctTooHigh(int ), this, n);
    }

    private void correctTooLow(int n) {
        InvokeDynamicSupport.bootstrap("correctTooLow", $$robo$$android_widget_ListView$correctTooLow(int ), this, n);
    }

    @Override
    protected void layoutChildren() {
        InvokeDynamicSupport.bootstrap("layoutChildren", $$robo$$android_widget_ListView$layoutChildren(), this);
    }

    @Override
    boolean trackMotionScroll(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("trackMotionScroll", $$robo$$android_widget_ListView$trackMotionScroll(int int ), this, n, n2);
    }

    private void removeUnusedFixedViews(List<FixedViewInfo> list) {
        InvokeDynamicSupport.bootstrap("removeUnusedFixedViews", $$robo$$android_widget_ListView$removeUnusedFixedViews(java.util.List<android.widget.ListView$FixedViewInfo> ), this, list);
    }

    private boolean isDirectChildHeaderOrFooter(View view) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDirectChildHeaderOrFooter", $$robo$$android_widget_ListView$isDirectChildHeaderOrFooter(android.view.View ), this, view);
    }

    private View makeAndAddView(int n, int n2, boolean bl, int n3, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("makeAndAddView", $$robo$$android_widget_ListView$makeAndAddView(int int boolean int boolean ), this, n, n2, bl, n3, bl2);
    }

    private void setupChild(View view, int n, int n2, boolean bl, int n3, boolean bl2, boolean bl3) {
        InvokeDynamicSupport.bootstrap("setupChild", $$robo$$android_widget_ListView$setupChild(android.view.View int int boolean int boolean boolean ), this, view, n, n2, bl, n3, bl2, bl3);
    }

    @Override
    protected boolean canAnimate() {
        return (boolean)InvokeDynamicSupport.bootstrap("canAnimate", $$robo$$android_widget_ListView$canAnimate(), this);
    }

    @Override
    public void setSelection(int n) {
        InvokeDynamicSupport.bootstrap("setSelection", $$robo$$android_widget_ListView$setSelection(int ), this, n);
    }

    @Override
    void setSelectionInt(int n) {
        InvokeDynamicSupport.bootstrap("setSelectionInt", $$robo$$android_widget_ListView$setSelectionInt(int ), this, n);
    }

    @Override
    int lookForSelectablePosition(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("lookForSelectablePosition", $$robo$$android_widget_ListView$lookForSelectablePosition(int boolean ), this, n, bl);
    }

    int lookForSelectablePositionAfter(int n, int n2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("lookForSelectablePositionAfter", $$robo$$android_widget_ListView$lookForSelectablePositionAfter(int int boolean ), this, n, n2, bl);
    }

    public void setSelectionAfterHeaderView() {
        InvokeDynamicSupport.bootstrap("setSelectionAfterHeaderView", $$robo$$android_widget_ListView$setSelectionAfterHeaderView(), this);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchKeyEvent", $$robo$$android_widget_ListView$dispatchKeyEvent(android.view.KeyEvent ), this, keyEvent);
    }

    @Override
    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyDown", $$robo$$android_widget_ListView$onKeyDown(int android.view.KeyEvent ), this, n, keyEvent);
    }

    @Override
    public boolean onKeyMultiple(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyMultiple", $$robo$$android_widget_ListView$onKeyMultiple(int int android.view.KeyEvent ), this, n, n2, keyEvent);
    }

    @Override
    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onKeyUp", $$robo$$android_widget_ListView$onKeyUp(int android.view.KeyEvent ), this, n, keyEvent);
    }

    private boolean commonKey(int n, int n2, KeyEvent keyEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("commonKey", $$robo$$android_widget_ListView$commonKey(int int android.view.KeyEvent ), this, n, n2, keyEvent);
    }

    boolean pageScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("pageScroll", $$robo$$android_widget_ListView$pageScroll(int ), this, n);
    }

    boolean fullScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("fullScroll", $$robo$$android_widget_ListView$fullScroll(int ), this, n);
    }

    private boolean handleHorizontalFocusWithinListItem(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleHorizontalFocusWithinListItem", $$robo$$android_widget_ListView$handleHorizontalFocusWithinListItem(int ), this, n);
    }

    boolean arrowScroll(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("arrowScroll", $$robo$$android_widget_ListView$arrowScroll(int ), this, n);
    }

    private int nextSelectedPositionForDirection(View view, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("nextSelectedPositionForDirection", $$robo$$android_widget_ListView$nextSelectedPositionForDirection(android.view.View int int ), this, view, n, n2);
    }

    private boolean arrowScrollImpl(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("arrowScrollImpl", $$robo$$android_widget_ListView$arrowScrollImpl(int ), this, n);
    }

    private void handleNewSelectionChange(View view, int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("handleNewSelectionChange", $$robo$$android_widget_ListView$handleNewSelectionChange(android.view.View int int boolean ), this, view, n, n2, bl);
    }

    private void measureAndAdjustDown(View view, int n, int n2) {
        InvokeDynamicSupport.bootstrap("measureAndAdjustDown", $$robo$$android_widget_ListView$measureAndAdjustDown(android.view.View int int ), this, view, n, n2);
    }

    private void measureItem(View view) {
        InvokeDynamicSupport.bootstrap("measureItem", $$robo$$android_widget_ListView$measureItem(android.view.View ), this, view);
    }

    private void relayoutMeasuredItem(View view) {
        InvokeDynamicSupport.bootstrap("relayoutMeasuredItem", $$robo$$android_widget_ListView$relayoutMeasuredItem(android.view.View ), this, view);
    }

    private int getArrowScrollPreviewLength() {
        return (int)InvokeDynamicSupport.bootstrap("getArrowScrollPreviewLength", $$robo$$android_widget_ListView$getArrowScrollPreviewLength(), this);
    }

    private int amountToScroll(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("amountToScroll", $$robo$$android_widget_ListView$amountToScroll(int int ), this, n, n2);
    }

    private int lookForSelectablePositionOnScreen(int n) {
        return (int)InvokeDynamicSupport.bootstrap("lookForSelectablePositionOnScreen", $$robo$$android_widget_ListView$lookForSelectablePositionOnScreen(int ), this, n);
    }

    private ArrowScrollFocusResult arrowScrollFocused(int n) {
        return InvokeDynamicSupport.bootstrap("arrowScrollFocused", $$robo$$android_widget_ListView$arrowScrollFocused(int ), this, n);
    }

    private int positionOfNewFocus(View view) {
        return (int)InvokeDynamicSupport.bootstrap("positionOfNewFocus", $$robo$$android_widget_ListView$positionOfNewFocus(android.view.View ), this, view);
    }

    private boolean isViewAncestorOf(View view, View view2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isViewAncestorOf", $$robo$$android_widget_ListView$isViewAncestorOf(android.view.View android.view.View ), this, view, view2);
    }

    private int amountToScrollToNewFocus(int n, View view, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("amountToScrollToNewFocus", $$robo$$android_widget_ListView$amountToScrollToNewFocus(int android.view.View int ), this, n, view, n2);
    }

    private int distanceToView(View view) {
        return (int)InvokeDynamicSupport.bootstrap("distanceToView", $$robo$$android_widget_ListView$distanceToView(android.view.View ), this, view);
    }

    private void scrollListItemsBy(int n) {
        InvokeDynamicSupport.bootstrap("scrollListItemsBy", $$robo$$android_widget_ListView$scrollListItemsBy(int ), this, n);
    }

    private View addViewAbove(View view, int n) {
        return InvokeDynamicSupport.bootstrap("addViewAbove", $$robo$$android_widget_ListView$addViewAbove(android.view.View int ), this, view, n);
    }

    private View addViewBelow(View view, int n) {
        return InvokeDynamicSupport.bootstrap("addViewBelow", $$robo$$android_widget_ListView$addViewBelow(android.view.View int ), this, view, n);
    }

    public void setItemsCanFocus(boolean bl) {
        InvokeDynamicSupport.bootstrap("setItemsCanFocus", $$robo$$android_widget_ListView$setItemsCanFocus(boolean ), this, bl);
    }

    public boolean getItemsCanFocus() {
        return (boolean)InvokeDynamicSupport.bootstrap("getItemsCanFocus", $$robo$$android_widget_ListView$getItemsCanFocus(), this);
    }

    @Override
    public boolean isOpaque() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaque", $$robo$$android_widget_ListView$isOpaque(), this);
    }

    @Override
    public void setCacheColorHint(int n) {
        InvokeDynamicSupport.bootstrap("setCacheColorHint", $$robo$$android_widget_ListView$setCacheColorHint(int ), this, n);
    }

    void drawOverscrollHeader(Canvas canvas, Drawable drawable2, Rect rect) {
        InvokeDynamicSupport.bootstrap("drawOverscrollHeader", $$robo$$android_widget_ListView$drawOverscrollHeader(android.graphics.Canvas android.graphics.drawable.Drawable android.graphics.Rect ), this, canvas, drawable2, rect);
    }

    void drawOverscrollFooter(Canvas canvas, Drawable drawable2, Rect rect) {
        InvokeDynamicSupport.bootstrap("drawOverscrollFooter", $$robo$$android_widget_ListView$drawOverscrollFooter(android.graphics.Canvas android.graphics.drawable.Drawable android.graphics.Rect ), this, canvas, drawable2, rect);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_widget_ListView$dispatchDraw(android.graphics.Canvas ), this, canvas);
    }

    @Override
    protected boolean drawChild(Canvas canvas, View view, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("drawChild", $$robo$$android_widget_ListView$drawChild(android.graphics.Canvas android.view.View long ), this, canvas, view, l);
    }

    void drawDivider(Canvas canvas, Rect rect, int n) {
        InvokeDynamicSupport.bootstrap("drawDivider", $$robo$$android_widget_ListView$drawDivider(android.graphics.Canvas android.graphics.Rect int ), this, canvas, rect, n);
    }

    public Drawable getDivider() {
        return InvokeDynamicSupport.bootstrap("getDivider", $$robo$$android_widget_ListView$getDivider(), this);
    }

    public void setDivider(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setDivider", $$robo$$android_widget_ListView$setDivider(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public int getDividerHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getDividerHeight", $$robo$$android_widget_ListView$getDividerHeight(), this);
    }

    public void setDividerHeight(int n) {
        InvokeDynamicSupport.bootstrap("setDividerHeight", $$robo$$android_widget_ListView$setDividerHeight(int ), this, n);
    }

    public void setHeaderDividersEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setHeaderDividersEnabled", $$robo$$android_widget_ListView$setHeaderDividersEnabled(boolean ), this, bl);
    }

    public boolean areHeaderDividersEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("areHeaderDividersEnabled", $$robo$$android_widget_ListView$areHeaderDividersEnabled(), this);
    }

    public void setFooterDividersEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFooterDividersEnabled", $$robo$$android_widget_ListView$setFooterDividersEnabled(boolean ), this, bl);
    }

    public boolean areFooterDividersEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("areFooterDividersEnabled", $$robo$$android_widget_ListView$areFooterDividersEnabled(), this);
    }

    public void setOverscrollHeader(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setOverscrollHeader", $$robo$$android_widget_ListView$setOverscrollHeader(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public Drawable getOverscrollHeader() {
        return InvokeDynamicSupport.bootstrap("getOverscrollHeader", $$robo$$android_widget_ListView$getOverscrollHeader(), this);
    }

    public void setOverscrollFooter(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setOverscrollFooter", $$robo$$android_widget_ListView$setOverscrollFooter(android.graphics.drawable.Drawable ), this, drawable2);
    }

    public Drawable getOverscrollFooter() {
        return InvokeDynamicSupport.bootstrap("getOverscrollFooter", $$robo$$android_widget_ListView$getOverscrollFooter(), this);
    }

    @Override
    protected void onFocusChanged(boolean bl, int n, Rect rect) {
        InvokeDynamicSupport.bootstrap("onFocusChanged", $$robo$$android_widget_ListView$onFocusChanged(boolean int android.graphics.Rect ), this, bl, n, rect);
    }

    @Override
    protected void onFinishInflate() {
        InvokeDynamicSupport.bootstrap("onFinishInflate", $$robo$$android_widget_ListView$onFinishInflate(), this);
    }

    @Override
    protected <T extends View> T findViewTraversal(int n) {
        return (T)InvokeDynamicSupport.bootstrap("findViewTraversal", $$robo$$android_widget_ListView$findViewTraversal(int ), this, n);
    }

    View findViewInHeadersOrFooters(ArrayList<FixedViewInfo> arrayList, int n) {
        return InvokeDynamicSupport.bootstrap("findViewInHeadersOrFooters", $$robo$$android_widget_ListView$findViewInHeadersOrFooters(java.util.ArrayList<android.widget.ListView$FixedViewInfo> int ), this, arrayList, n);
    }

    @Override
    protected <T extends View> T findViewWithTagTraversal(Object object) {
        return (T)InvokeDynamicSupport.bootstrap("findViewWithTagTraversal", $$robo$$android_widget_ListView$findViewWithTagTraversal(java.lang.Object ), this, object);
    }

    View findViewWithTagInHeadersOrFooters(ArrayList<FixedViewInfo> arrayList, Object object) {
        return InvokeDynamicSupport.bootstrap("findViewWithTagInHeadersOrFooters", $$robo$$android_widget_ListView$findViewWithTagInHeadersOrFooters(java.util.ArrayList<android.widget.ListView$FixedViewInfo> java.lang.Object ), this, arrayList, object);
    }

    @Override
    protected <T extends View> T findViewByPredicateTraversal(Predicate<View> predicate, View view) {
        return (T)InvokeDynamicSupport.bootstrap("findViewByPredicateTraversal", $$robo$$android_widget_ListView$findViewByPredicateTraversal(java.util.function.Predicate<android.view.View> android.view.View ), this, predicate, view);
    }

    View findViewByPredicateInHeadersOrFooters(ArrayList<FixedViewInfo> arrayList, Predicate<View> predicate, View view) {
        return InvokeDynamicSupport.bootstrap("findViewByPredicateInHeadersOrFooters", $$robo$$android_widget_ListView$findViewByPredicateInHeadersOrFooters(java.util.ArrayList<android.widget.ListView$FixedViewInfo> java.util.function.Predicate<android.view.View> android.view.View ), this, arrayList, predicate, view);
    }

    @Deprecated
    public long[] getCheckItemIds() {
        return InvokeDynamicSupport.bootstrap("getCheckItemIds", $$robo$$android_widget_ListView$getCheckItemIds(), this);
    }

    @Override
    int getHeightForPosition(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getHeightForPosition", $$robo$$android_widget_ListView$getHeightForPosition(int ), this, n);
    }

    private boolean shouldAdjustHeightForDivider(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldAdjustHeightForDivider", $$robo$$android_widget_ListView$shouldAdjustHeightForDivider(int ), this, n);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_ListView$getAccessibilityClassName(), this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_ListView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), this, accessibilityNodeInfo);
    }

    @Override
    public boolean performAccessibilityActionInternal(int n, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityActionInternal", $$robo$$android_widget_ListView$performAccessibilityActionInternal(int android.os.Bundle ), this, n, bundle);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoForItem(View view, int n, AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoForItem", $$robo$$android_widget_ListView$onInitializeAccessibilityNodeInfoForItem(android.view.View int android.view.accessibility.AccessibilityNodeInfo ), this, view, n, accessibilityNodeInfo);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_ListView$encodeProperties(android.view.ViewHierarchyEncoder ), this, viewHierarchyEncoder);
    }

    protected HeaderViewListAdapter wrapHeaderListAdapterInternal(ArrayList<FixedViewInfo> arrayList, ArrayList<FixedViewInfo> arrayList2, ListAdapter listAdapter) {
        return InvokeDynamicSupport.bootstrap("wrapHeaderListAdapterInternal", $$robo$$android_widget_ListView$wrapHeaderListAdapterInternal(java.util.ArrayList<android.widget.ListView$FixedViewInfo> java.util.ArrayList<android.widget.ListView$FixedViewInfo> android.widget.ListAdapter ), this, arrayList, arrayList2, listAdapter);
    }

    protected void wrapHeaderListAdapterInternal() {
        InvokeDynamicSupport.bootstrap("wrapHeaderListAdapterInternal", $$robo$$android_widget_ListView$wrapHeaderListAdapterInternal(), this);
    }

    protected void dispatchDataSetObserverOnChangedInternal() {
        InvokeDynamicSupport.bootstrap("dispatchDataSetObserverOnChangedInternal", $$robo$$android_widget_ListView$dispatchDataSetObserverOnChangedInternal(), this);
    }

    public /* synthetic */ ListView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ListView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ArrowScrollFocusResult
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private int mSelectedPosition;
        private int mAmountToScroll;

        private void $$robo$$android_widget_ListView_ArrowScrollFocusResult$__constructor__() {
        }

        private final void $$robo$$android_widget_ListView_ArrowScrollFocusResult$populate(int selectedPosition, int amountToScroll) {
            this.mSelectedPosition = selectedPosition;
            this.mAmountToScroll = amountToScroll;
        }

        private final int $$robo$$android_widget_ListView_ArrowScrollFocusResult$getSelectedPosition() {
            return this.mSelectedPosition;
        }

        private final int $$robo$$android_widget_ListView_ArrowScrollFocusResult$getAmountToScroll() {
            return this.mAmountToScroll;
        }

        private /* synthetic */ void $$robo$$android_widget_ListView_ArrowScrollFocusResult$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_ListView_ArrowScrollFocusResult$__constructor__();
        }

        public ArrowScrollFocusResult() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListView_ArrowScrollFocusResult$__constructor__(), this);
        }

        void populate(int n, int n2) {
            InvokeDynamicSupport.bootstrap("populate", $$robo$$android_widget_ListView_ArrowScrollFocusResult$populate(int int ), this, n, n2);
        }

        public int getSelectedPosition() {
            return (int)InvokeDynamicSupport.bootstrap("getSelectedPosition", $$robo$$android_widget_ListView_ArrowScrollFocusResult$getSelectedPosition(), this);
        }

        public int getAmountToScroll() {
            return (int)InvokeDynamicSupport.bootstrap("getAmountToScroll", $$robo$$android_widget_ListView_ArrowScrollFocusResult$getAmountToScroll(), this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_widget_ListView_ArrowScrollFocusResult$__constructor__(var1_1);
        }

        public /* synthetic */ ArrowScrollFocusResult(1 var1_1) {
            this();
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListView_ArrowScrollFocusResult$__constructor__(android.widget.ListView$1 ), this, var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ArrowScrollFocusResult)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class FocusSelector
    implements Runnable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int STATE_SET_SELECTION = 1;
        private static int STATE_WAIT_FOR_LAYOUT = 2;
        private static int STATE_REQUEST_FOCUS = 3;
        private int mAction;
        private int mPosition;
        private int mPositionTop;
        /* synthetic */ ListView this$0;

        private void $$robo$$android_widget_ListView_FocusSelector$__constructor__(ListView listView) {
        }

        private final FocusSelector $$robo$$android_widget_ListView_FocusSelector$setupForSetSelection(int position, int top) {
            this.mPosition = position;
            this.mPositionTop = top;
            this.mAction = 1;
            return this;
        }

        private final void $$robo$$android_widget_ListView_FocusSelector$run() {
            if (this.mAction == 1) {
                this.this$0.setSelectionFromTop(this.mPosition, this.mPositionTop);
                this.mAction = 2;
            } else if (this.mAction == 3) {
                int childIndex = this.mPosition - this.this$0.mFirstPosition;
                View child = this.this$0.getChildAt(childIndex);
                if (child != null) {
                    child.requestFocus();
                }
                this.mAction = -1;
            }
        }

        private final Runnable $$robo$$android_widget_ListView_FocusSelector$setupFocusIfValid(int position) {
            if (this.mAction != 2 || position != this.mPosition) {
                return null;
            }
            this.mAction = 3;
            return this;
        }

        private final void $$robo$$android_widget_ListView_FocusSelector$onLayoutComplete() {
            if (this.mAction == 2) {
                this.mAction = -1;
            }
        }

        private /* synthetic */ void $$robo$$android_widget_ListView_FocusSelector$__constructor__(ListView x0, 1 x1) {
        }

        private void __constructor__(ListView listView) {
            this.$$robo$$android_widget_ListView_FocusSelector$__constructor__(listView);
        }

        public FocusSelector(ListView listView) {
            this.this$0 = listView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListView_FocusSelector$__constructor__(android.widget.ListView ), this, listView);
        }

        FocusSelector setupForSetSelection(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("setupForSetSelection", $$robo$$android_widget_ListView_FocusSelector$setupForSetSelection(int int ), this, n, n2);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_ListView_FocusSelector$run(), this);
        }

        Runnable setupFocusIfValid(int n) {
            return InvokeDynamicSupport.bootstrap("setupFocusIfValid", $$robo$$android_widget_ListView_FocusSelector$setupFocusIfValid(int ), this, n);
        }

        void onLayoutComplete() {
            InvokeDynamicSupport.bootstrap("onLayoutComplete", $$robo$$android_widget_ListView_FocusSelector$onLayoutComplete(), this);
        }

        private /* synthetic */ void __constructor__(ListView listView, 1 var2_2) {
            this.$$robo$$android_widget_ListView_FocusSelector$__constructor__(listView, var2_2);
        }

        public /* synthetic */ FocusSelector(ListView listView, 1 var2_2) {
            this(listView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListView_FocusSelector$__constructor__(android.widget.ListView android.widget.ListView$1 ), this, listView, var2_2);
        }

        public /* synthetic */ FocusSelector() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FocusSelector)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class FixedViewInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public View view;
        public Object data;
        public boolean isSelectable;
        /* synthetic */ ListView this$0;

        private void $$robo$$android_widget_ListView_FixedViewInfo$__constructor__(ListView this$0) {
        }

        private void __constructor__(ListView listView) {
            this.$$robo$$android_widget_ListView_FixedViewInfo$__constructor__(listView);
        }

        public FixedViewInfo(ListView listView) {
            this.this$0 = listView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_ListView_FixedViewInfo$__constructor__(android.widget.ListView ), this, listView);
        }

        public /* synthetic */ FixedViewInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FixedViewInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

