/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.animation.ObjectAnimator;
import android.annotation.IntDef;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.os.Bundle;
import android.util.AttributeSet;
import android.util.FloatProperty;
import android.util.IntArray;
import android.util.Log;
import android.util.MathUtils;
import android.util.StateSet;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.PointerIcon;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import com.android.internal.R;
import com.android.internal.widget.ExploreByTouchHelper;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Calendar;
import java.util.Locale;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RadialTimePickerView
extends View
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "RadialTimePickerView";
    public static int HOURS = 0;
    public static int MINUTES = 1;
    private static int HOURS_INNER = 2;
    private static int SELECTOR_CIRCLE = 0;
    private static int SELECTOR_DOT = 1;
    private static int SELECTOR_LINE = 2;
    private static int AM = 0;
    private static int PM = 1;
    private static int HOURS_IN_CIRCLE = 12;
    private static int MINUTES_IN_CIRCLE = 60;
    private static int DEGREES_FOR_ONE_HOUR = 30;
    private static int DEGREES_FOR_ONE_MINUTE = 6;
    private static int[] HOURS_NUMBERS;
    private static int[] HOURS_NUMBERS_24;
    private static int[] MINUTES_NUMBERS;
    private static int ANIM_DURATION_NORMAL = 500;
    private static int ANIM_DURATION_TOUCH = 60;
    private static int[] SNAP_PREFER_30S_MAP;
    private static int NUM_POSITIONS = 12;
    private static float[] COS_30;
    private static float[] SIN_30;
    private static int MISSING_COLOR = -65281;
    private FloatProperty<RadialTimePickerView> HOURS_TO_MINUTES;
    private String[] mHours12Texts;
    private String[] mOuterHours24Texts;
    private String[] mInnerHours24Texts;
    private String[] mMinutesTexts;
    private Paint[] mPaint;
    private Paint mPaintCenter;
    private Paint[] mPaintSelector;
    private Paint mPaintBackground;
    private Typeface mTypeface;
    private ColorStateList[] mTextColor;
    private int[] mTextSize;
    private int[] mTextInset;
    private float[][] mOuterTextX;
    private float[][] mOuterTextY;
    private float[] mInnerTextX;
    private float[] mInnerTextY;
    private int[] mSelectionDegrees;
    private RadialPickerTouchHelper mTouchHelper;
    private Path mSelectorPath;
    private boolean mIs24HourMode;
    private boolean mShowHours;
    private ObjectAnimator mHoursToMinutesAnimator;
    private float mHoursToMinutes;
    private boolean mIsOnInnerCircle;
    private int mSelectorRadius;
    private int mSelectorStroke;
    private int mSelectorDotRadius;
    private int mCenterDotRadius;
    private int mSelectorColor;
    private int mSelectorDotColor;
    private int mXCenter;
    private int mYCenter;
    private int mCircleRadius;
    private int mMinDistForInnerNumber;
    private int mMaxDistForOuterNumber;
    private int mHalfwayDist;
    private String[] mOuterTextHours;
    private String[] mInnerTextHours;
    private String[] mMinutesText;
    private int mAmOrPm;
    private float mDisabledAlpha;
    private OnValueSelectedListener mListener;
    private boolean mInputEnabled;
    boolean mChangedDuringTouch;

    private static final void $$robo$$android_widget_RadialTimePickerView$preparePrefer30sMap() {
        int snappedOutputDegrees = 0;
        int count = 1;
        int expectedCount = 8;
        for (int degrees = 0; degrees < 361; ++degrees) {
            RadialTimePickerView.SNAP_PREFER_30S_MAP[degrees] = snappedOutputDegrees;
            if (count == expectedCount) {
                expectedCount = (snappedOutputDegrees += 6) == 360 ? 7 : (snappedOutputDegrees % 30 == 0 ? 14 : 4);
                count = 1;
                continue;
            }
            ++count;
        }
    }

    private static final int $$robo$$android_widget_RadialTimePickerView$snapPrefer30s(int degrees) {
        if (SNAP_PREFER_30S_MAP == null) {
            return -1;
        }
        return SNAP_PREFER_30S_MAP[degrees];
    }

    private static final int $$robo$$android_widget_RadialTimePickerView$snapOnly30s(int degrees, int forceHigherOrLower) {
        int stepSize = 30;
        int floor = degrees / 30 * 30;
        int ceiling = floor + 30;
        if (forceHigherOrLower == 1) {
            degrees = ceiling;
        } else if (forceHigherOrLower == -1) {
            if (degrees == floor) {
                floor -= 30;
            }
            degrees = floor;
        } else {
            degrees = degrees - floor < ceiling - degrees ? floor : ceiling;
        }
        return degrees;
    }

    private void $$robo$$android_widget_RadialTimePickerView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_RadialTimePickerView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_RadialTimePickerView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_RadialTimePickerView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.HOURS_TO_MINUTES = new FloatProperty<RadialTimePickerView>(this, "hoursToMinutes"){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ RadialTimePickerView this$0;

            private void $$robo$$android_widget_RadialTimePickerView_1$__constructor__(RadialTimePickerView this$0, String name) {
            }

            private final Float $$robo$$android_widget_RadialTimePickerView_1$get(RadialTimePickerView radialTimePickerView) {
                return Float.valueOf(radialTimePickerView.mHoursToMinutes);
            }

            private final void $$robo$$android_widget_RadialTimePickerView_1$setValue(RadialTimePickerView object, float value) {
                object.mHoursToMinutes = value;
                object.invalidate();
            }

            private void __constructor__(RadialTimePickerView radialTimePickerView, String string2) {
                this.$$robo$$android_widget_RadialTimePickerView_1$__constructor__(radialTimePickerView, string2);
            }
            {
                this.this$0 = radialTimePickerView;
                super(string2);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RadialTimePickerView_1$__constructor__(android.widget.RadialTimePickerView java.lang.String ), this, radialTimePickerView, string2);
            }

            @Override
            public Float get(RadialTimePickerView radialTimePickerView) {
                return InvokeDynamicSupport.bootstrap("get", $$robo$$android_widget_RadialTimePickerView_1$get(android.widget.RadialTimePickerView ), this, radialTimePickerView);
            }

            @Override
            public void setValue(RadialTimePickerView radialTimePickerView, float f) {
                InvokeDynamicSupport.bootstrap("setValue", $$robo$$android_widget_RadialTimePickerView_1$setValue(android.widget.RadialTimePickerView float ), this, radialTimePickerView, f);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mHours12Texts = new String[12];
        this.mOuterHours24Texts = new String[12];
        this.mInnerHours24Texts = new String[12];
        this.mMinutesTexts = new String[12];
        this.mPaint = new Paint[2];
        this.mPaintCenter = new Paint();
        this.mPaintSelector = new Paint[3];
        this.mPaintBackground = new Paint();
        this.mTextColor = new ColorStateList[3];
        this.mTextSize = new int[3];
        this.mTextInset = new int[3];
        this.mOuterTextX = new float[2][12];
        this.mOuterTextY = new float[2][12];
        this.mInnerTextX = new float[12];
        this.mInnerTextY = new float[12];
        this.mSelectionDegrees = new int[2];
        this.mSelectorPath = new Path();
        this.mInputEnabled = true;
        this.mChangedDuringTouch = false;
        this.applyAttributes(attrs, defStyleAttr, defStyleRes);
        TypedValue outValue = new TypedValue();
        context.getTheme().resolveAttribute(0x1010033, outValue, true);
        this.mDisabledAlpha = outValue.getFloat();
        this.mTypeface = Typeface.create("sans-serif", 0);
        this.mPaint[0] = new Paint();
        this.mPaint[0].setAntiAlias(true);
        this.mPaint[0].setTextAlign(Paint.Align.CENTER);
        this.mPaint[1] = new Paint();
        this.mPaint[1].setAntiAlias(true);
        this.mPaint[1].setTextAlign(Paint.Align.CENTER);
        this.mPaintCenter.setAntiAlias(true);
        this.mPaintSelector[0] = new Paint();
        this.mPaintSelector[0].setAntiAlias(true);
        this.mPaintSelector[1] = new Paint();
        this.mPaintSelector[1].setAntiAlias(true);
        this.mPaintSelector[2] = new Paint();
        this.mPaintSelector[2].setAntiAlias(true);
        this.mPaintSelector[2].setStrokeWidth(2.0f);
        this.mPaintBackground.setAntiAlias(true);
        Resources res = this.getResources();
        this.mSelectorRadius = res.getDimensionPixelSize(17105269);
        this.mSelectorStroke = res.getDimensionPixelSize(17105270);
        this.mSelectorDotRadius = res.getDimensionPixelSize(17105268);
        this.mCenterDotRadius = res.getDimensionPixelSize(17105260);
        this.mTextSize[0] = res.getDimensionPixelSize(17105275);
        this.mTextSize[1] = res.getDimensionPixelSize(17105275);
        this.mTextSize[2] = res.getDimensionPixelSize(17105274);
        this.mTextInset[0] = res.getDimensionPixelSize(17105273);
        this.mTextInset[1] = res.getDimensionPixelSize(17105273);
        this.mTextInset[2] = res.getDimensionPixelSize(17105272);
        this.mShowHours = true;
        this.mHoursToMinutes = 0.0f;
        this.mIs24HourMode = false;
        this.mAmOrPm = 0;
        this.mTouchHelper = new RadialPickerTouchHelper(this);
        this.setAccessibilityDelegate(this.mTouchHelper);
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        this.initHoursAndMinutesText();
        this.initData();
        Calendar calendar = Calendar.getInstance(Locale.getDefault());
        int currentHour = calendar.get(11);
        int currentMinute = calendar.get(12);
        this.setCurrentHourInternal(currentHour, false, false);
        this.setCurrentMinuteInternal(currentMinute, false);
        this.setHapticFeedbackEnabled(true);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$applyAttributes(AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        int selectorActivatedColor;
        Context context = this.getContext();
        TypedArray a = this.getContext().obtainStyledAttributes(attrs, R.styleable.TimePicker, defStyleAttr, defStyleRes);
        ColorStateList numbersTextColor = a.getColorStateList(3);
        ColorStateList numbersInnerTextColor = a.getColorStateList(9);
        this.mTextColor[0] = numbersTextColor == null ? ColorStateList.valueOf(-65281) : numbersTextColor;
        this.mTextColor[2] = numbersInnerTextColor == null ? ColorStateList.valueOf(-65281) : numbersInnerTextColor;
        this.mTextColor[1] = this.mTextColor[0];
        ColorStateList selectorColors = a.getColorStateList(5);
        if (selectorColors != null) {
            int[] stateSetEnabledActivated = StateSet.get(40);
            selectorActivatedColor = selectorColors.getColorForState(stateSetEnabledActivated, 0);
        } else {
            selectorActivatedColor = -65281;
        }
        this.mPaintCenter.setColor(selectorActivatedColor);
        int[] stateSetActivated = StateSet.get(40);
        this.mSelectorColor = selectorActivatedColor;
        this.mSelectorDotColor = this.mTextColor[0].getColorForState(stateSetActivated, 0);
        this.mPaintBackground.setColor(a.getColor(4, context.getColor(17170775)));
        a.recycle();
    }

    private final void $$robo$$android_widget_RadialTimePickerView$initialize(int hour, int minute, boolean is24HourMode) {
        if (this.mIs24HourMode != is24HourMode) {
            this.mIs24HourMode = is24HourMode;
            this.initData();
        }
        this.setCurrentHourInternal(hour, false, false);
        this.setCurrentMinuteInternal(minute, false);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setCurrentItemShowing(int item, boolean animate) {
        switch (item) {
            case 0: {
                this.showHours(animate);
                break;
            }
            case 1: {
                this.showMinutes(animate);
                break;
            }
            default: {
                Log.e("RadialTimePickerView", "ClockView does not support showing item " + item);
            }
        }
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getCurrentItemShowing() {
        return this.mShowHours ? 0 : 1;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setOnValueSelectedListener(OnValueSelectedListener listener) {
        this.mListener = listener;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setCurrentHour(int hour) {
        this.setCurrentHourInternal(hour, true, false);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setCurrentHourInternal(int hour, boolean callback, boolean autoAdvance) {
        int degrees;
        this.mSelectionDegrees[0] = degrees = hour % 12 * 30;
        int amOrPm = hour == 0 || hour % 24 < 12 ? 0 : 1;
        boolean isOnInnerCircle = this.getInnerCircleForHour(hour);
        if (this.mAmOrPm != amOrPm || this.mIsOnInnerCircle != isOnInnerCircle) {
            this.mAmOrPm = amOrPm;
            this.mIsOnInnerCircle = isOnInnerCircle;
            this.initData();
            this.mTouchHelper.invalidateRoot();
        }
        this.invalidate();
        if (callback && this.mListener != null) {
            this.mListener.onValueSelected(0, hour, autoAdvance);
        }
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getCurrentHour() {
        return this.getHourForDegrees(this.mSelectionDegrees[0], this.mIsOnInnerCircle);
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getHourForDegrees(int degrees, boolean innerCircle) {
        int hour = degrees / 30 % 12;
        if (this.mIs24HourMode) {
            if (!innerCircle && hour == 0) {
                hour = 12;
            } else if (innerCircle && hour != 0) {
                hour += 12;
            }
        } else if (this.mAmOrPm == 1) {
            hour += 12;
        }
        return hour;
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getDegreesForHour(int hour) {
        if (this.mIs24HourMode) {
            if (hour >= 12) {
                hour -= 12;
            }
        } else if (hour == 12) {
            hour = 0;
        }
        return hour * 30;
    }

    private final boolean $$robo$$android_widget_RadialTimePickerView$getInnerCircleForHour(int hour) {
        return this.mIs24HourMode && (hour == 0 || hour > 12);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setCurrentMinute(int minute) {
        this.setCurrentMinuteInternal(minute, true);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setCurrentMinuteInternal(int minute, boolean callback) {
        this.mSelectionDegrees[1] = minute % 60 * 6;
        this.invalidate();
        if (callback && this.mListener != null) {
            this.mListener.onValueSelected(1, minute, false);
        }
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getCurrentMinute() {
        return this.getMinuteForDegrees(this.mSelectionDegrees[1]);
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getMinuteForDegrees(int degrees) {
        return degrees / 6;
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getDegreesForMinute(int minute) {
        return minute * 6;
    }

    private final boolean $$robo$$android_widget_RadialTimePickerView$setAmOrPm(int amOrPm) {
        if (this.mAmOrPm == amOrPm || this.mIs24HourMode) {
            return false;
        }
        this.mAmOrPm = amOrPm;
        this.invalidate();
        this.mTouchHelper.invalidateRoot();
        return true;
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getAmOrPm() {
        return this.mAmOrPm;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$showHours(boolean animate) {
        this.showPicker(true, animate);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$showMinutes(boolean animate) {
        this.showPicker(false, animate);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$initHoursAndMinutesText() {
        for (int i = 0; i < 12; ++i) {
            this.mHours12Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mInnerHours24Texts[i] = String.format("%02d", HOURS_NUMBERS_24[i]);
            this.mOuterHours24Texts[i] = String.format("%d", HOURS_NUMBERS[i]);
            this.mMinutesTexts[i] = String.format("%02d", MINUTES_NUMBERS[i]);
        }
    }

    private final void $$robo$$android_widget_RadialTimePickerView$initData() {
        if (this.mIs24HourMode) {
            this.mOuterTextHours = this.mOuterHours24Texts;
            this.mInnerTextHours = this.mInnerHours24Texts;
        } else {
            this.mOuterTextHours = this.mHours12Texts;
            this.mInnerTextHours = this.mHours12Texts;
        }
        this.mMinutesText = this.mMinutesTexts;
    }

    private final void $$robo$$android_widget_RadialTimePickerView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (!changed) {
            return;
        }
        this.mXCenter = this.getWidth() / 2;
        this.mYCenter = this.getHeight() / 2;
        this.mCircleRadius = Math.min(this.mXCenter, this.mYCenter);
        this.mMinDistForInnerNumber = this.mCircleRadius - this.mTextInset[2] - this.mSelectorRadius;
        this.mMaxDistForOuterNumber = this.mCircleRadius - this.mTextInset[0] + this.mSelectorRadius;
        this.mHalfwayDist = this.mCircleRadius - (this.mTextInset[0] + this.mTextInset[2]) / 2;
        this.calculatePositionsHours();
        this.calculatePositionsMinutes();
        this.mTouchHelper.invalidateRoot();
    }

    private final void $$robo$$android_widget_RadialTimePickerView$onDraw(Canvas canvas) {
        float alphaMod = this.mInputEnabled ? 1.0f : this.mDisabledAlpha;
        this.drawCircleBackground(canvas);
        Path selectorPath = this.mSelectorPath;
        this.drawSelector(canvas, selectorPath);
        this.drawHours(canvas, selectorPath, alphaMod);
        this.drawMinutes(canvas, selectorPath, alphaMod);
        this.drawCenter(canvas, alphaMod);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$showPicker(boolean hours, boolean animate) {
        if (this.mShowHours == hours) {
            return;
        }
        this.mShowHours = hours;
        if (animate) {
            this.animatePicker(hours, 500L);
        } else {
            if (this.mHoursToMinutesAnimator != null && this.mHoursToMinutesAnimator.isStarted()) {
                this.mHoursToMinutesAnimator.cancel();
                this.mHoursToMinutesAnimator = null;
            }
            this.mHoursToMinutes = hours ? 0.0f : 1.0f;
        }
        this.initData();
        this.invalidate();
        this.mTouchHelper.invalidateRoot();
    }

    private final void $$robo$$android_widget_RadialTimePickerView$animatePicker(boolean hoursToMinutes, long duration) {
        float target;
        float f = target = hoursToMinutes ? 0.0f : 1.0f;
        if (this.mHoursToMinutes == target) {
            if (this.mHoursToMinutesAnimator != null && this.mHoursToMinutesAnimator.isStarted()) {
                this.mHoursToMinutesAnimator.cancel();
                this.mHoursToMinutesAnimator = null;
            }
            return;
        }
        this.mHoursToMinutesAnimator = ObjectAnimator.ofFloat(this, this.HOURS_TO_MINUTES, target);
        this.mHoursToMinutesAnimator.setAutoCancel(true);
        this.mHoursToMinutesAnimator.setDuration(duration);
        this.mHoursToMinutesAnimator.start();
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawCircleBackground(Canvas canvas) {
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCircleRadius, this.mPaintBackground);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawHours(Canvas canvas, Path selectorPath, float alphaMod) {
        int hoursAlpha = (int)(255.0f * (1.0f - this.mHoursToMinutes) * alphaMod + 0.5f);
        if (hoursAlpha > 0) {
            canvas.save(2);
            canvas.clipPath(selectorPath, Region.Op.DIFFERENCE);
            this.drawHoursClipped(canvas, hoursAlpha, false);
            canvas.restore();
            canvas.save(2);
            canvas.clipPath(selectorPath, Region.Op.INTERSECT);
            this.drawHoursClipped(canvas, hoursAlpha, true);
            canvas.restore();
        }
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawHoursClipped(Canvas canvas, int hoursAlpha, boolean showActivated) {
        this.drawTextElements(canvas, this.mTextSize[0], this.mTypeface, this.mTextColor[0], this.mOuterTextHours, this.mOuterTextX[0], this.mOuterTextY[0], this.mPaint[0], hoursAlpha, showActivated && !this.mIsOnInnerCircle, this.mSelectionDegrees[0], showActivated);
        if (this.mIs24HourMode && this.mInnerTextHours != null) {
            this.drawTextElements(canvas, this.mTextSize[2], this.mTypeface, this.mTextColor[2], this.mInnerTextHours, this.mInnerTextX, this.mInnerTextY, this.mPaint[0], hoursAlpha, showActivated && this.mIsOnInnerCircle, this.mSelectionDegrees[0], showActivated);
        }
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawMinutes(Canvas canvas, Path selectorPath, float alphaMod) {
        int minutesAlpha = (int)(255.0f * this.mHoursToMinutes * alphaMod + 0.5f);
        if (minutesAlpha > 0) {
            canvas.save(2);
            canvas.clipPath(selectorPath, Region.Op.DIFFERENCE);
            this.drawMinutesClipped(canvas, minutesAlpha, false);
            canvas.restore();
            canvas.save(2);
            canvas.clipPath(selectorPath, Region.Op.INTERSECT);
            this.drawMinutesClipped(canvas, minutesAlpha, true);
            canvas.restore();
        }
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawMinutesClipped(Canvas canvas, int minutesAlpha, boolean showActivated) {
        this.drawTextElements(canvas, this.mTextSize[1], this.mTypeface, this.mTextColor[1], this.mMinutesText, this.mOuterTextX[1], this.mOuterTextY[1], this.mPaint[1], minutesAlpha, showActivated, this.mSelectionDegrees[1], showActivated);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawCenter(Canvas canvas, float alphaMod) {
        this.mPaintCenter.setAlpha((int)(255.0f * alphaMod + 0.5f));
        canvas.drawCircle(this.mXCenter, this.mYCenter, this.mCenterDotRadius, this.mPaintCenter);
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getMultipliedAlpha(int argb, int alpha) {
        return (int)((double)Color.alpha(argb) * ((double)alpha / 255.0) + 0.5);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawSelector(Canvas canvas, Path selectorPath) {
        float dotScale;
        int hoursIndex = this.mIsOnInnerCircle ? 2 : 0;
        int hoursInset = this.mTextInset[hoursIndex];
        int hoursAngleDeg = this.mSelectionDegrees[hoursIndex % 2];
        float hoursDotScale = this.mSelectionDegrees[hoursIndex % 2] % 30 != 0 ? 1.0f : 0.0f;
        boolean minutesIndex = true;
        int minutesInset = this.mTextInset[1];
        int minutesAngleDeg = this.mSelectionDegrees[1];
        float minutesDotScale = this.mSelectionDegrees[1] % 30 != 0 ? 1.0f : 0.0f;
        int selRadius = this.mSelectorRadius;
        float selLength = (float)this.mCircleRadius - MathUtils.lerp(hoursInset, minutesInset, this.mHoursToMinutes);
        double selAngleRad = Math.toRadians(MathUtils.lerpDeg(hoursAngleDeg, minutesAngleDeg, this.mHoursToMinutes));
        float selCenterX = (float)this.mXCenter + selLength * (float)Math.sin(selAngleRad);
        float selCenterY = (float)this.mYCenter - selLength * (float)Math.cos(selAngleRad);
        Paint paint = this.mPaintSelector[0];
        paint.setColor(this.mSelectorColor);
        canvas.drawCircle(selCenterX, selCenterY, selRadius, paint);
        if (selectorPath != null) {
            selectorPath.reset();
            selectorPath.addCircle(selCenterX, selCenterY, selRadius, Path.Direction.CCW);
        }
        if ((dotScale = MathUtils.lerp(hoursDotScale, minutesDotScale, this.mHoursToMinutes)) > 0.0f) {
            Paint dotPaint = this.mPaintSelector[1];
            dotPaint.setColor(this.mSelectorDotColor);
            canvas.drawCircle(selCenterX, selCenterY, (float)this.mSelectorDotRadius * dotScale, dotPaint);
        }
        double sin = Math.sin(selAngleRad);
        double cos = Math.cos(selAngleRad);
        float lineLength = selLength - (float)selRadius;
        int centerX = this.mXCenter + (int)((double)this.mCenterDotRadius * sin);
        int centerY = this.mYCenter - (int)((double)this.mCenterDotRadius * cos);
        float linePointX = centerX + (int)((double)lineLength * sin);
        float linePointY = centerY - (int)((double)lineLength * cos);
        Paint linePaint = this.mPaintSelector[2];
        linePaint.setColor(this.mSelectorColor);
        linePaint.setStrokeWidth(this.mSelectorStroke);
        canvas.drawLine(this.mXCenter, this.mYCenter, linePointX, linePointY, linePaint);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$calculatePositionsHours() {
        float numbersRadius = this.mCircleRadius - this.mTextInset[0];
        RadialTimePickerView.calculatePositions(this.mPaint[0], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[0], this.mOuterTextX[0], this.mOuterTextY[0]);
        if (this.mIs24HourMode) {
            int innerNumbersRadius = this.mCircleRadius - this.mTextInset[2];
            RadialTimePickerView.calculatePositions(this.mPaint[0], innerNumbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[2], this.mInnerTextX, this.mInnerTextY);
        }
    }

    private final void $$robo$$android_widget_RadialTimePickerView$calculatePositionsMinutes() {
        float numbersRadius = this.mCircleRadius - this.mTextInset[1];
        RadialTimePickerView.calculatePositions(this.mPaint[1], numbersRadius, this.mXCenter, this.mYCenter, this.mTextSize[1], this.mOuterTextX[1], this.mOuterTextY[1]);
    }

    private static final void $$robo$$android_widget_RadialTimePickerView$calculatePositions(Paint paint, float radius, float xCenter, float yCenter, float textSize, float[] x, float[] y) {
        paint.setTextSize(textSize);
        yCenter -= (paint.descent() + paint.ascent()) / 2.0f;
        for (int i = 0; i < 12; ++i) {
            x[i] = xCenter - radius * COS_30[i];
            y[i] = yCenter - radius * SIN_30[i];
        }
    }

    private final void $$robo$$android_widget_RadialTimePickerView$drawTextElements(Canvas canvas, float textSize, Typeface typeface, ColorStateList textColor, String[] texts, float[] textX, float[] textY, Paint paint, int alpha, boolean showActivated, int activatedDegrees, boolean activatedOnly) {
        paint.setTextSize(textSize);
        paint.setTypeface(typeface);
        float activatedIndex = (float)activatedDegrees / 30.0f;
        int activatedFloor = (int)activatedIndex;
        int activatedCeil = (int)Math.ceil(activatedIndex) % 12;
        for (int i = 0; i < 12; ++i) {
            boolean activated;
            boolean bl = activated = activatedFloor == i || activatedCeil == i;
            if (activatedOnly && !activated) continue;
            int stateMask = 8 | (showActivated && activated ? 32 : 0);
            int color2 = textColor.getColorForState(StateSet.get(stateMask), 0);
            paint.setColor(color2);
            paint.setAlpha(this.getMultipliedAlpha(color2, alpha));
            canvas.drawText(texts[i], textX[i], textY[i], paint);
        }
    }

    private final int $$robo$$android_widget_RadialTimePickerView$getDegreesFromXY(float x, float y, boolean constrainOutside) {
        int outerBound;
        int innerBound;
        if (this.mIs24HourMode && this.mShowHours) {
            innerBound = this.mMinDistForInnerNumber;
            outerBound = this.mMaxDistForOuterNumber;
        } else {
            int index = this.mShowHours ? 0 : 1;
            int center = this.mCircleRadius - this.mTextInset[index];
            innerBound = center - this.mSelectorRadius;
            outerBound = center + this.mSelectorRadius;
        }
        double dX = x - (float)this.mXCenter;
        double dY = y - (float)this.mYCenter;
        double distFromCenter = Math.sqrt(dX * dX + dY * dY);
        if (distFromCenter < (double)innerBound || constrainOutside && distFromCenter > (double)outerBound) {
            return -1;
        }
        int degrees = (int)(Math.toDegrees(Math.atan2(dY, dX) + 1.5707963267948966) + 0.5);
        if (degrees < 0) {
            return degrees + 360;
        }
        return degrees;
    }

    private final boolean $$robo$$android_widget_RadialTimePickerView$getInnerCircleFromXY(float x, float y) {
        if (this.mIs24HourMode && this.mShowHours) {
            double dX = x - (float)this.mXCenter;
            double dY = y - (float)this.mYCenter;
            double distFromCenter = Math.sqrt(dX * dX + dY * dY);
            return distFromCenter <= (double)this.mHalfwayDist;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_RadialTimePickerView$onTouchEvent(MotionEvent event) {
        if (!this.mInputEnabled) {
            return true;
        }
        int action = event.getActionMasked();
        if (action == 2 || action == 1 || action == 0) {
            boolean forceSelection = false;
            boolean autoAdvance = false;
            if (action == 0) {
                this.mChangedDuringTouch = false;
            } else if (action == 1) {
                autoAdvance = true;
                if (!this.mChangedDuringTouch) {
                    forceSelection = true;
                }
            }
            this.mChangedDuringTouch |= this.handleTouchInput(event.getX(), event.getY(), forceSelection, autoAdvance);
        }
        return true;
    }

    private final boolean $$robo$$android_widget_RadialTimePickerView$handleTouchInput(float x, float y, boolean forceSelection, boolean autoAdvance) {
        int newValue;
        int type;
        boolean valueChanged;
        boolean isOnInnerCircle = this.getInnerCircleFromXY(x, y);
        int degrees = this.getDegreesFromXY(x, y, false);
        if (degrees == -1) {
            return false;
        }
        this.animatePicker(this.mShowHours, 60L);
        if (this.mShowHours) {
            int snapDegrees = RadialTimePickerView.snapOnly30s(degrees, 0) % 360;
            valueChanged = this.mIsOnInnerCircle != isOnInnerCircle || this.mSelectionDegrees[0] != snapDegrees;
            this.mIsOnInnerCircle = isOnInnerCircle;
            this.mSelectionDegrees[0] = snapDegrees;
            type = 0;
            newValue = this.getCurrentHour();
        } else {
            int snapDegrees = RadialTimePickerView.snapPrefer30s(degrees) % 360;
            valueChanged = this.mSelectionDegrees[1] != snapDegrees;
            this.mSelectionDegrees[1] = snapDegrees;
            type = 1;
            newValue = this.getCurrentMinute();
        }
        if (valueChanged || forceSelection || autoAdvance) {
            if (this.mListener != null) {
                this.mListener.onValueSelected(type, newValue, autoAdvance);
            }
            if (valueChanged || forceSelection) {
                this.performHapticFeedback(4);
                this.invalidate();
            }
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_widget_RadialTimePickerView$dispatchHoverEvent(MotionEvent event) {
        if (this.mTouchHelper.dispatchHoverEvent(event)) {
            return true;
        }
        return super.dispatchHoverEvent(event);
    }

    private final void $$robo$$android_widget_RadialTimePickerView$setInputEnabled(boolean inputEnabled) {
        this.mInputEnabled = inputEnabled;
        this.invalidate();
    }

    private final PointerIcon $$robo$$android_widget_RadialTimePickerView$onResolvePointerIcon(MotionEvent event, int pointerIndex) {
        if (!this.isEnabled()) {
            return null;
        }
        int degrees = this.getDegreesFromXY(event.getX(), event.getY(), false);
        if (degrees != -1) {
            return PointerIcon.getSystemIcon(this.getContext(), 1002);
        }
        return super.onResolvePointerIcon(event, pointerIndex);
    }

    static void __staticInitializer__() {
        HOURS_NUMBERS = new int[]{12, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        HOURS_NUMBERS_24 = new int[]{0, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23};
        MINUTES_NUMBERS = new int[]{0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55};
        SNAP_PREFER_30S_MAP = new int[361];
        COS_30 = new float[12];
        SIN_30 = new float[12];
        RadialTimePickerView.preparePrefer30sMap();
        double increment = 0.5235987755982988;
        double angle = 1.5707963267948966;
        for (int i = 0; i < 12; ++i) {
            RadialTimePickerView.COS_30[i] = (float)Math.cos(angle);
            RadialTimePickerView.SIN_30[i] = (float)Math.sin(angle);
            angle += 0.5235987755982988;
        }
    }

    private static void preparePrefer30sMap() {
        InvokeDynamicSupport.bootstrapStatic("preparePrefer30sMap", $$robo$$android_widget_RadialTimePickerView$preparePrefer30sMap());
    }

    private static int snapPrefer30s(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("snapPrefer30s", $$robo$$android_widget_RadialTimePickerView$snapPrefer30s(int ), (int)n);
    }

    private static int snapOnly30s(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("snapOnly30s", $$robo$$android_widget_RadialTimePickerView$snapOnly30s(int int ), (int)n, (int)n2);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_RadialTimePickerView$__constructor__(context);
    }

    public RadialTimePickerView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RadialTimePickerView$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_RadialTimePickerView$__constructor__(context, attributeSet);
    }

    public RadialTimePickerView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843933);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RadialTimePickerView$__constructor__(android.content.Context android.util.AttributeSet ), this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_RadialTimePickerView$__constructor__(context, attributeSet, n);
    }

    public RadialTimePickerView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RadialTimePickerView$__constructor__(android.content.Context android.util.AttributeSet int ), this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_RadialTimePickerView$__constructor__(context, attributeSet, n, n2);
    }

    public RadialTimePickerView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RadialTimePickerView$__constructor__(android.content.Context android.util.AttributeSet int int ), this, context, attributeSet, n, n2);
    }

    void applyAttributes(AttributeSet attributeSet, int n, int n2) {
        InvokeDynamicSupport.bootstrap("applyAttributes", $$robo$$android_widget_RadialTimePickerView$applyAttributes(android.util.AttributeSet int int ), this, attributeSet, n, n2);
    }

    public void initialize(int n, int n2, boolean bl) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_widget_RadialTimePickerView$initialize(int int boolean ), this, n, n2, bl);
    }

    public void setCurrentItemShowing(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCurrentItemShowing", $$robo$$android_widget_RadialTimePickerView$setCurrentItemShowing(int boolean ), this, n, bl);
    }

    public int getCurrentItemShowing() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentItemShowing", $$robo$$android_widget_RadialTimePickerView$getCurrentItemShowing(), this);
    }

    public void setOnValueSelectedListener(OnValueSelectedListener onValueSelectedListener) {
        InvokeDynamicSupport.bootstrap("setOnValueSelectedListener", $$robo$$android_widget_RadialTimePickerView$setOnValueSelectedListener(android.widget.RadialTimePickerView$OnValueSelectedListener ), this, onValueSelectedListener);
    }

    public void setCurrentHour(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentHour", $$robo$$android_widget_RadialTimePickerView$setCurrentHour(int ), this, n);
    }

    private void setCurrentHourInternal(int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("setCurrentHourInternal", $$robo$$android_widget_RadialTimePickerView$setCurrentHourInternal(int boolean boolean ), this, n, bl, bl2);
    }

    public int getCurrentHour() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentHour", $$robo$$android_widget_RadialTimePickerView$getCurrentHour(), this);
    }

    private int getHourForDegrees(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getHourForDegrees", $$robo$$android_widget_RadialTimePickerView$getHourForDegrees(int boolean ), this, n, bl);
    }

    private int getDegreesForHour(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDegreesForHour", $$robo$$android_widget_RadialTimePickerView$getDegreesForHour(int ), this, n);
    }

    private boolean getInnerCircleForHour(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getInnerCircleForHour", $$robo$$android_widget_RadialTimePickerView$getInnerCircleForHour(int ), this, n);
    }

    public void setCurrentMinute(int n) {
        InvokeDynamicSupport.bootstrap("setCurrentMinute", $$robo$$android_widget_RadialTimePickerView$setCurrentMinute(int ), this, n);
    }

    private void setCurrentMinuteInternal(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setCurrentMinuteInternal", $$robo$$android_widget_RadialTimePickerView$setCurrentMinuteInternal(int boolean ), this, n, bl);
    }

    public int getCurrentMinute() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentMinute", $$robo$$android_widget_RadialTimePickerView$getCurrentMinute(), this);
    }

    private int getMinuteForDegrees(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getMinuteForDegrees", $$robo$$android_widget_RadialTimePickerView$getMinuteForDegrees(int ), this, n);
    }

    private int getDegreesForMinute(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDegreesForMinute", $$robo$$android_widget_RadialTimePickerView$getDegreesForMinute(int ), this, n);
    }

    public boolean setAmOrPm(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setAmOrPm", $$robo$$android_widget_RadialTimePickerView$setAmOrPm(int ), this, n);
    }

    public int getAmOrPm() {
        return (int)InvokeDynamicSupport.bootstrap("getAmOrPm", $$robo$$android_widget_RadialTimePickerView$getAmOrPm(), this);
    }

    public void showHours(boolean bl) {
        InvokeDynamicSupport.bootstrap("showHours", $$robo$$android_widget_RadialTimePickerView$showHours(boolean ), this, bl);
    }

    public void showMinutes(boolean bl) {
        InvokeDynamicSupport.bootstrap("showMinutes", $$robo$$android_widget_RadialTimePickerView$showMinutes(boolean ), this, bl);
    }

    private void initHoursAndMinutesText() {
        InvokeDynamicSupport.bootstrap("initHoursAndMinutesText", $$robo$$android_widget_RadialTimePickerView$initHoursAndMinutesText(), this);
    }

    private void initData() {
        InvokeDynamicSupport.bootstrap("initData", $$robo$$android_widget_RadialTimePickerView$initData(), this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_RadialTimePickerView$onLayout(boolean int int int int ), this, bl, n, n2, n3, n4);
    }

    @Override
    public void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_widget_RadialTimePickerView$onDraw(android.graphics.Canvas ), this, canvas);
    }

    private void showPicker(boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("showPicker", $$robo$$android_widget_RadialTimePickerView$showPicker(boolean boolean ), this, bl, bl2);
    }

    private void animatePicker(boolean bl, long l) {
        InvokeDynamicSupport.bootstrap("animatePicker", $$robo$$android_widget_RadialTimePickerView$animatePicker(boolean long ), this, bl, l);
    }

    private void drawCircleBackground(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("drawCircleBackground", $$robo$$android_widget_RadialTimePickerView$drawCircleBackground(android.graphics.Canvas ), this, canvas);
    }

    private void drawHours(Canvas canvas, Path path, float f) {
        InvokeDynamicSupport.bootstrap("drawHours", $$robo$$android_widget_RadialTimePickerView$drawHours(android.graphics.Canvas android.graphics.Path float ), this, canvas, path, f);
    }

    private void drawHoursClipped(Canvas canvas, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("drawHoursClipped", $$robo$$android_widget_RadialTimePickerView$drawHoursClipped(android.graphics.Canvas int boolean ), this, canvas, n, bl);
    }

    private void drawMinutes(Canvas canvas, Path path, float f) {
        InvokeDynamicSupport.bootstrap("drawMinutes", $$robo$$android_widget_RadialTimePickerView$drawMinutes(android.graphics.Canvas android.graphics.Path float ), this, canvas, path, f);
    }

    private void drawMinutesClipped(Canvas canvas, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("drawMinutesClipped", $$robo$$android_widget_RadialTimePickerView$drawMinutesClipped(android.graphics.Canvas int boolean ), this, canvas, n, bl);
    }

    private void drawCenter(Canvas canvas, float f) {
        InvokeDynamicSupport.bootstrap("drawCenter", $$robo$$android_widget_RadialTimePickerView$drawCenter(android.graphics.Canvas float ), this, canvas, f);
    }

    private int getMultipliedAlpha(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getMultipliedAlpha", $$robo$$android_widget_RadialTimePickerView$getMultipliedAlpha(int int ), this, n, n2);
    }

    private void drawSelector(Canvas canvas, Path path) {
        InvokeDynamicSupport.bootstrap("drawSelector", $$robo$$android_widget_RadialTimePickerView$drawSelector(android.graphics.Canvas android.graphics.Path ), this, canvas, path);
    }

    private void calculatePositionsHours() {
        InvokeDynamicSupport.bootstrap("calculatePositionsHours", $$robo$$android_widget_RadialTimePickerView$calculatePositionsHours(), this);
    }

    private void calculatePositionsMinutes() {
        InvokeDynamicSupport.bootstrap("calculatePositionsMinutes", $$robo$$android_widget_RadialTimePickerView$calculatePositionsMinutes(), this);
    }

    private static void calculatePositions(Paint paint, float f, float f2, float f3, float f4, float[] fArray, float[] fArray2) {
        InvokeDynamicSupport.bootstrapStatic("calculatePositions", $$robo$$android_widget_RadialTimePickerView$calculatePositions(android.graphics.Paint float float float float float[] float[] ), (Paint)paint, (float)f, (float)f2, (float)f3, (float)f4, (float[])fArray, (float[])fArray2);
    }

    private void drawTextElements(Canvas canvas, float f, Typeface typeface, ColorStateList colorStateList, String[] stringArray, float[] fArray, float[] fArray2, Paint paint, int n, boolean bl, int n2, boolean bl2) {
        InvokeDynamicSupport.bootstrap("drawTextElements", $$robo$$android_widget_RadialTimePickerView$drawTextElements(android.graphics.Canvas float android.graphics.Typeface android.content.res.ColorStateList java.lang.String[] float[] float[] android.graphics.Paint int boolean int boolean ), this, canvas, f, typeface, colorStateList, stringArray, fArray, fArray2, paint, n, bl, n2, bl2);
    }

    private int getDegreesFromXY(float f, float f2, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getDegreesFromXY", $$robo$$android_widget_RadialTimePickerView$getDegreesFromXY(float float boolean ), this, f, f2, bl);
    }

    private boolean getInnerCircleFromXY(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrap("getInnerCircleFromXY", $$robo$$android_widget_RadialTimePickerView$getInnerCircleFromXY(float float ), this, f, f2);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTouchEvent", $$robo$$android_widget_RadialTimePickerView$onTouchEvent(android.view.MotionEvent ), this, motionEvent);
    }

    private boolean handleTouchInput(float f, float f2, boolean bl, boolean bl2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleTouchInput", $$robo$$android_widget_RadialTimePickerView$handleTouchInput(float float boolean boolean ), this, f, f2, bl, bl2);
    }

    @Override
    public boolean dispatchHoverEvent(MotionEvent motionEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchHoverEvent", $$robo$$android_widget_RadialTimePickerView$dispatchHoverEvent(android.view.MotionEvent ), this, motionEvent);
    }

    public void setInputEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setInputEnabled", $$robo$$android_widget_RadialTimePickerView$setInputEnabled(boolean ), this, bl);
    }

    @Override
    public PointerIcon onResolvePointerIcon(MotionEvent motionEvent, int n) {
        return InvokeDynamicSupport.bootstrap("onResolvePointerIcon", $$robo$$android_widget_RadialTimePickerView$onResolvePointerIcon(android.view.MotionEvent int ), this, motionEvent, n);
    }

    static {
        RobolectricInternals.classInitializing(RadialTimePickerView.class);
    }

    public /* synthetic */ RadialTimePickerView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RadialTimePickerView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class RadialPickerTouchHelper
    extends ExploreByTouchHelper
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private Rect mTempRect;
        private int TYPE_HOUR = 1;
        private int TYPE_MINUTE = 2;
        private int SHIFT_TYPE = 0;
        private int MASK_TYPE = 15;
        private int SHIFT_VALUE = 8;
        private int MASK_VALUE = 255;
        private int MINUTE_INCREMENT = 5;
        /* synthetic */ RadialTimePickerView this$0;

        private void $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$__constructor__(RadialTimePickerView radialTimePickerView) {
            this.mTempRect = new Rect();
            this.TYPE_HOUR = 1;
            this.TYPE_MINUTE = 2;
            this.SHIFT_TYPE = 0;
            this.MASK_TYPE = 15;
            this.SHIFT_VALUE = 8;
            this.MASK_VALUE = 255;
            this.MINUTE_INCREMENT = 5;
        }

        private final void $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$onInitializeAccessibilityNodeInfo(View host, AccessibilityNodeInfo info) {
            super.onInitializeAccessibilityNodeInfo(host, info);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
        }

        private final boolean $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$performAccessibilityAction(View host, int action, Bundle arguments) {
            if (super.performAccessibilityAction(host, action, arguments)) {
                return true;
            }
            switch (action) {
                case 4096: {
                    this.adjustPicker(1);
                    return true;
                }
                case 8192: {
                    this.adjustPicker(-1);
                    return true;
                }
            }
            return false;
        }

        private final void $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$adjustPicker(int step) {
            int maxValue;
            int minValue;
            int initialStep;
            int stepSize;
            if (this.this$0.mShowHours) {
                stepSize = 1;
                int currentHour24 = this.this$0.getCurrentHour();
                if (this.this$0.mIs24HourMode) {
                    initialStep = currentHour24;
                    minValue = 0;
                    maxValue = 23;
                } else {
                    initialStep = this.hour24To12(currentHour24);
                    minValue = 1;
                    maxValue = 12;
                }
            } else {
                stepSize = 5;
                initialStep = this.this$0.getCurrentMinute() / stepSize;
                minValue = 0;
                maxValue = 55;
            }
            int nextValue = (initialStep + step) * stepSize;
            int clampedValue = MathUtils.constrain(nextValue, minValue, maxValue);
            if (this.this$0.mShowHours) {
                this.this$0.setCurrentHour(clampedValue);
            } else {
                this.this$0.setCurrentMinute(clampedValue);
            }
        }

        private final int $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getVirtualViewAt(float x, float y) {
            int id2;
            int degrees = this.this$0.getDegreesFromXY(x, y, true);
            if (degrees != -1) {
                int snapDegrees = RadialTimePickerView.snapOnly30s(degrees, 0) % 360;
                if (this.this$0.mShowHours) {
                    boolean isOnInnerCircle = this.this$0.getInnerCircleFromXY(x, y);
                    int hour24 = this.this$0.getHourForDegrees(snapDegrees, isOnInnerCircle);
                    int hour = this.this$0.mIs24HourMode ? hour24 : this.hour24To12(hour24);
                    id2 = this.makeId(1, hour);
                } else {
                    int snappedOffset;
                    int current = this.this$0.getCurrentMinute();
                    int touched = this.this$0.getMinuteForDegrees(degrees);
                    int snapped = this.this$0.getMinuteForDegrees(snapDegrees);
                    int currentOffset = this.getCircularDiff(current, touched, 60);
                    int minute = currentOffset < (snappedOffset = this.getCircularDiff(snapped, touched, 60)) ? current : snapped;
                    id2 = this.makeId(2, minute);
                }
            } else {
                id2 = Integer.MIN_VALUE;
            }
            return id2;
        }

        private final int $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getCircularDiff(int first, int second, int max) {
            int midpoint;
            int diff = Math.abs(first - second);
            return diff > (midpoint = max / 2) ? max - diff : diff;
        }

        private final void $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getVisibleVirtualViews(IntArray virtualViewIds) {
            if (this.this$0.mShowHours) {
                int min = this.this$0.mIs24HourMode ? 0 : 1;
                int max = this.this$0.mIs24HourMode ? 23 : 12;
                for (int i = min; i <= max; ++i) {
                    virtualViewIds.add(this.makeId(1, i));
                }
            } else {
                int current = this.this$0.getCurrentMinute();
                for (int i = 0; i < 60; i += 5) {
                    virtualViewIds.add(this.makeId(2, i));
                    if (current <= i || current >= i + 5) continue;
                    virtualViewIds.add(this.makeId(2, current));
                }
            }
        }

        private final void $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$onPopulateEventForVirtualView(int virtualViewId, AccessibilityEvent event) {
            event.setClassName(this.getClass().getName());
            int type = this.getTypeFromId(virtualViewId);
            int value = this.getValueFromId(virtualViewId);
            CharSequence description = this.getVirtualViewDescription(type, value);
            event.setContentDescription(description);
        }

        private final void $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$onPopulateNodeForVirtualView(int virtualViewId, AccessibilityNodeInfo node) {
            node.setClassName(this.getClass().getName());
            node.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_CLICK);
            int type = this.getTypeFromId(virtualViewId);
            int value = this.getValueFromId(virtualViewId);
            CharSequence description = this.getVirtualViewDescription(type, value);
            node.setContentDescription(description);
            this.getBoundsForVirtualView(virtualViewId, this.mTempRect);
            node.setBoundsInParent(this.mTempRect);
            boolean selected = this.isVirtualViewSelected(type, value);
            node.setSelected(selected);
            int nextId = this.getVirtualViewIdAfter(type, value);
            if (nextId != Integer.MIN_VALUE) {
                node.setTraversalBefore(this.this$0, nextId);
            }
        }

        private final int $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getVirtualViewIdAfter(int type, int value) {
            if (type == 1) {
                int max;
                int nextValue = value + 1;
                int n = max = this.this$0.mIs24HourMode ? 23 : 12;
                if (nextValue <= max) {
                    return this.makeId(type, nextValue);
                }
            } else if (type == 2) {
                int current = this.this$0.getCurrentMinute();
                int snapValue = value - value % 5;
                int nextValue = snapValue + 5;
                if (value < current && nextValue > current) {
                    return this.makeId(type, current);
                }
                if (nextValue < 60) {
                    return this.makeId(type, nextValue);
                }
            }
            return Integer.MIN_VALUE;
        }

        private final boolean $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$onPerformActionForVirtualView(int virtualViewId, int action, Bundle arguments) {
            if (action == 16) {
                int type = this.getTypeFromId(virtualViewId);
                int value = this.getValueFromId(virtualViewId);
                if (type == 1) {
                    int hour = this.this$0.mIs24HourMode ? value : this.hour12To24(value, this.this$0.mAmOrPm);
                    this.this$0.setCurrentHour(hour);
                    return true;
                }
                if (type == 2) {
                    this.this$0.setCurrentMinute(value);
                    return true;
                }
            }
            return false;
        }

        private final int $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$hour12To24(int hour12, int amOrPm) {
            int hour24 = hour12;
            if (hour12 == 12) {
                if (amOrPm == 0) {
                    hour24 = 0;
                }
            } else if (amOrPm == 1) {
                hour24 += 12;
            }
            return hour24;
        }

        private final int $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$hour24To12(int hour24) {
            if (hour24 == 0) {
                return 12;
            }
            if (hour24 > 12) {
                return hour24 - 12;
            }
            return hour24;
        }

        private final void $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getBoundsForVirtualView(int virtualViewId, Rect bounds) {
            float degrees;
            float radius;
            float centerRadius;
            int type = this.getTypeFromId(virtualViewId);
            int value = this.getValueFromId(virtualViewId);
            if (type == 1) {
                boolean innerCircle = this.this$0.getInnerCircleForHour(value);
                if (innerCircle) {
                    centerRadius = this.this$0.mCircleRadius - this.this$0.mTextInset[2];
                    radius = this.this$0.mSelectorRadius;
                } else {
                    centerRadius = this.this$0.mCircleRadius - this.this$0.mTextInset[0];
                    radius = this.this$0.mSelectorRadius;
                }
                degrees = this.this$0.getDegreesForHour(value);
            } else if (type == 2) {
                centerRadius = this.this$0.mCircleRadius - this.this$0.mTextInset[1];
                degrees = this.this$0.getDegreesForMinute(value);
                radius = this.this$0.mSelectorRadius;
            } else {
                centerRadius = 0.0f;
                degrees = 0.0f;
                radius = 0.0f;
            }
            double radians = Math.toRadians(degrees);
            float xCenter = (float)this.this$0.mXCenter + centerRadius * (float)Math.sin(radians);
            float yCenter = (float)this.this$0.mYCenter - centerRadius * (float)Math.cos(radians);
            bounds.set((int)(xCenter - radius), (int)(yCenter - radius), (int)(xCenter + radius), (int)(yCenter + radius));
        }

        private final CharSequence $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getVirtualViewDescription(int type, int value) {
            String description = type == 1 || type == 2 ? Integer.toString(value) : null;
            return description;
        }

        private final boolean $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$isVirtualViewSelected(int type, int value) {
            boolean selected = type == 1 ? this.this$0.getCurrentHour() == value : (type == 2 ? this.this$0.getCurrentMinute() == value : false);
            return selected;
        }

        private final int $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$makeId(int type, int value) {
            return type << 0 | value << 8;
        }

        private final int $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getTypeFromId(int id2) {
            return id2 >>> 0 & 0xF;
        }

        private final int $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getValueFromId(int id2) {
            return id2 >>> 8 & 0xFF;
        }

        private void __constructor__(RadialTimePickerView radialTimePickerView) {
            this.$$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$__constructor__(radialTimePickerView);
        }

        public RadialPickerTouchHelper(RadialTimePickerView radialTimePickerView) {
            this.this$0 = radialTimePickerView;
            super(radialTimePickerView);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$__constructor__(android.widget.RadialTimePickerView ), this, radialTimePickerView);
        }

        @Override
        public void onInitializeAccessibilityNodeInfo(View view, AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfo", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$onInitializeAccessibilityNodeInfo(android.view.View android.view.accessibility.AccessibilityNodeInfo ), this, view, accessibilityNodeInfo);
        }

        @Override
        public boolean performAccessibilityAction(View view, int n, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityAction", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$performAccessibilityAction(android.view.View int android.os.Bundle ), this, view, n, bundle);
        }

        private void adjustPicker(int n) {
            InvokeDynamicSupport.bootstrap("adjustPicker", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$adjustPicker(int ), this, n);
        }

        @Override
        protected int getVirtualViewAt(float f, float f2) {
            return (int)InvokeDynamicSupport.bootstrap("getVirtualViewAt", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getVirtualViewAt(float float ), this, f, f2);
        }

        private int getCircularDiff(int n, int n2, int n3) {
            return (int)InvokeDynamicSupport.bootstrap("getCircularDiff", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getCircularDiff(int int int ), this, n, n2, n3);
        }

        @Override
        protected void getVisibleVirtualViews(IntArray intArray) {
            InvokeDynamicSupport.bootstrap("getVisibleVirtualViews", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getVisibleVirtualViews(android.util.IntArray ), this, intArray);
        }

        @Override
        protected void onPopulateEventForVirtualView(int n, AccessibilityEvent accessibilityEvent) {
            InvokeDynamicSupport.bootstrap("onPopulateEventForVirtualView", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$onPopulateEventForVirtualView(int android.view.accessibility.AccessibilityEvent ), this, n, accessibilityEvent);
        }

        @Override
        protected void onPopulateNodeForVirtualView(int n, AccessibilityNodeInfo accessibilityNodeInfo) {
            InvokeDynamicSupport.bootstrap("onPopulateNodeForVirtualView", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$onPopulateNodeForVirtualView(int android.view.accessibility.AccessibilityNodeInfo ), this, n, accessibilityNodeInfo);
        }

        private int getVirtualViewIdAfter(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("getVirtualViewIdAfter", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getVirtualViewIdAfter(int int ), this, n, n2);
        }

        @Override
        protected boolean onPerformActionForVirtualView(int n, int n2, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("onPerformActionForVirtualView", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$onPerformActionForVirtualView(int int android.os.Bundle ), this, n, n2, bundle);
        }

        private int hour12To24(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("hour12To24", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$hour12To24(int int ), this, n, n2);
        }

        private int hour24To12(int n) {
            return (int)InvokeDynamicSupport.bootstrap("hour24To12", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$hour24To12(int ), this, n);
        }

        private void getBoundsForVirtualView(int n, Rect rect) {
            InvokeDynamicSupport.bootstrap("getBoundsForVirtualView", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getBoundsForVirtualView(int android.graphics.Rect ), this, n, rect);
        }

        private CharSequence getVirtualViewDescription(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("getVirtualViewDescription", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getVirtualViewDescription(int int ), this, n, n2);
        }

        private boolean isVirtualViewSelected(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("isVirtualViewSelected", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$isVirtualViewSelected(int int ), this, n, n2);
        }

        private int makeId(int n, int n2) {
            return (int)InvokeDynamicSupport.bootstrap("makeId", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$makeId(int int ), this, n, n2);
        }

        private int getTypeFromId(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getTypeFromId", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getTypeFromId(int ), this, n);
        }

        private int getValueFromId(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getValueFromId", $$robo$$android_widget_RadialTimePickerView_RadialPickerTouchHelper$getValueFromId(int ), this, n);
        }

        public /* synthetic */ RadialPickerTouchHelper() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RadialPickerTouchHelper)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface OnValueSelectedListener
    extends InstrumentedInterface {
        public void onValueSelected(int var1, int var2, boolean var3);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    static @interface PickerType {
    }
}

