/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.alsa;

import android.util.Slog;
import com.android.internal.alsa.LineTokenizer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AlsaDevicesParser
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "AlsaDevicesParser";
    protected static boolean DEBUG = false;
    private static String kDevicesFilePath = "/proc/asound/devices";
    private static int kIndex_CardDeviceField = 5;
    private static int kStartIndex_CardNum = 6;
    private static int kEndIndex_CardNum = 8;
    private static int kStartIndex_DeviceNum = 9;
    private static int kEndIndex_DeviceNum = 11;
    private static int kStartIndex_Type = 14;
    private static LineTokenizer mTokenizer;
    private boolean mHasCaptureDevices;
    private boolean mHasPlaybackDevices;
    private boolean mHasMIDIDevices;
    private ArrayList<AlsaDeviceRecord> mDeviceRecords;

    private void $$robo$$com_android_internal_alsa_AlsaDevicesParser$__constructor__() {
        this.mHasCaptureDevices = false;
        this.mHasPlaybackDevices = false;
        this.mHasMIDIDevices = false;
        this.mDeviceRecords = new ArrayList();
    }

    private final int $$robo$$com_android_internal_alsa_AlsaDevicesParser$getDefaultDeviceNum(int card) {
        return 0;
    }

    private final boolean $$robo$$com_android_internal_alsa_AlsaDevicesParser$hasPlaybackDevices(int card) {
        for (AlsaDeviceRecord deviceRecord : this.mDeviceRecords) {
            if (deviceRecord.mCardNum != card || deviceRecord.mDeviceType != 0 || deviceRecord.mDeviceDir != 1) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_alsa_AlsaDevicesParser$hasCaptureDevices(int card) {
        for (AlsaDeviceRecord deviceRecord : this.mDeviceRecords) {
            if (deviceRecord.mCardNum != card || deviceRecord.mDeviceType != 0 || deviceRecord.mDeviceDir != 0) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_alsa_AlsaDevicesParser$hasMIDIDevices(int card) {
        for (AlsaDeviceRecord deviceRecord : this.mDeviceRecords) {
            if (deviceRecord.mCardNum != card || deviceRecord.mDeviceType != 2) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_alsa_AlsaDevicesParser$isLineDeviceRecord(String line) {
        return line.charAt(5) == '[';
    }

    private final void $$robo$$com_android_internal_alsa_AlsaDevicesParser$scan() {
        this.mDeviceRecords.clear();
        File devicesFile = new File("/proc/asound/devices");
        try {
            FileReader reader = new FileReader(devicesFile);
            BufferedReader bufferedReader = new BufferedReader(reader);
            String line = "";
            while ((line = bufferedReader.readLine()) != null) {
                if (!this.isLineDeviceRecord(line)) continue;
                AlsaDeviceRecord deviceRecord = new AlsaDeviceRecord(this);
                deviceRecord.parse(line);
                this.mDeviceRecords.add(deviceRecord);
            }
            reader.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private final void $$robo$$com_android_internal_alsa_AlsaDevicesParser$Log(String heading) {
    }

    static void __staticInitializer__() {
        mTokenizer = new LineTokenizer(" :[]-");
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_alsa_AlsaDevicesParser$__constructor__();
    }

    public AlsaDevicesParser() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_alsa_AlsaDevicesParser$__constructor__(), this);
    }

    public int getDefaultDeviceNum(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDefaultDeviceNum", $$robo$$com_android_internal_alsa_AlsaDevicesParser$getDefaultDeviceNum(int ), this, n);
    }

    public boolean hasPlaybackDevices(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasPlaybackDevices", $$robo$$com_android_internal_alsa_AlsaDevicesParser$hasPlaybackDevices(int ), this, n);
    }

    public boolean hasCaptureDevices(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCaptureDevices", $$robo$$com_android_internal_alsa_AlsaDevicesParser$hasCaptureDevices(int ), this, n);
    }

    public boolean hasMIDIDevices(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMIDIDevices", $$robo$$com_android_internal_alsa_AlsaDevicesParser$hasMIDIDevices(int ), this, n);
    }

    private boolean isLineDeviceRecord(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isLineDeviceRecord", $$robo$$com_android_internal_alsa_AlsaDevicesParser$isLineDeviceRecord(java.lang.String ), this, string2);
    }

    public void scan() {
        InvokeDynamicSupport.bootstrap("scan", $$robo$$com_android_internal_alsa_AlsaDevicesParser$scan(), this);
    }

    public void Log(String string2) {
        InvokeDynamicSupport.bootstrap("Log", $$robo$$com_android_internal_alsa_AlsaDevicesParser$Log(java.lang.String ), this, string2);
    }

    static {
        RobolectricInternals.classInitializing(AlsaDevicesParser.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlsaDevicesParser)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class AlsaDeviceRecord
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int kDeviceType_Unknown = -1;
        public static int kDeviceType_Audio = 0;
        public static int kDeviceType_Control = 1;
        public static int kDeviceType_MIDI = 2;
        public static int kDeviceDir_Unknown = -1;
        public static int kDeviceDir_Capture = 0;
        public static int kDeviceDir_Playback = 1;
        int mCardNum;
        int mDeviceNum;
        int mDeviceType;
        int mDeviceDir;
        /* synthetic */ AlsaDevicesParser this$0;

        private void $$robo$$com_android_internal_alsa_AlsaDevicesParser_AlsaDeviceRecord$__constructor__(AlsaDevicesParser this$0) {
            this.mCardNum = -1;
            this.mDeviceNum = -1;
            this.mDeviceType = -1;
            this.mDeviceDir = -1;
        }

        private final boolean $$robo$$com_android_internal_alsa_AlsaDevicesParser_AlsaDeviceRecord$parse(String line) {
            boolean kToken_LineNum = false;
            boolean kToken_CardNum = true;
            int kToken_DeviceNum = 2;
            int kToken_Type0 = 3;
            int kToken_Type1 = 4;
            int kToken_Type2 = 5;
            int tokenOffset = 0;
            int delimOffset = 0;
            int tokenIndex = 0;
            while ((tokenOffset = mTokenizer.nextToken(line, delimOffset)) != -1) {
                delimOffset = mTokenizer.nextDelimiter(line, tokenOffset);
                if (delimOffset == -1) {
                    delimOffset = line.length();
                }
                String token = line.substring(tokenOffset, delimOffset);
                try {
                    switch (tokenIndex) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.mCardNum = Integer.parseInt(token);
                            if (line.charAt(delimOffset) == '-') break;
                            ++tokenIndex;
                            break;
                        }
                        case 2: {
                            this.mDeviceNum = Integer.parseInt(token);
                            break;
                        }
                        case 3: {
                            if (token.equals("digital")) break;
                            if (token.equals("control")) {
                                this.mDeviceType = 1;
                                break;
                            }
                            if (!token.equals("raw")) break;
                            break;
                        }
                        case 4: {
                            if (token.equals("audio")) {
                                this.mDeviceType = 0;
                                break;
                            }
                            if (!token.equals("midi")) break;
                            this.mDeviceType = 2;
                            this.this$0.mHasMIDIDevices = true;
                            break;
                        }
                        case 5: {
                            if (token.equals("capture")) {
                                this.mDeviceDir = 0;
                                this.this$0.mHasCaptureDevices = true;
                                break;
                            }
                            if (!token.equals("playback")) break;
                            this.mDeviceDir = 1;
                            this.this$0.mHasPlaybackDevices = true;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    Slog.e("AlsaDevicesParser", "Failed to parse token " + tokenIndex + " of " + "/proc/asound/devices" + " token: " + token);
                    return false;
                }
                ++tokenIndex;
            }
            return true;
        }

        private final String $$robo$$com_android_internal_alsa_AlsaDevicesParser_AlsaDeviceRecord$textFormat() {
            StringBuilder sb = new StringBuilder();
            sb.append("[" + this.mCardNum + ":" + this.mDeviceNum + "]");
            switch (this.mDeviceType) {
                case -1: {
                    sb.append(" N/A");
                    break;
                }
                case 0: {
                    sb.append(" Audio");
                    break;
                }
                case 1: {
                    sb.append(" Control");
                    break;
                }
                case 2: {
                    sb.append(" MIDI");
                }
            }
            switch (this.mDeviceDir) {
                case -1: {
                    sb.append(" N/A");
                    break;
                }
                case 0: {
                    sb.append(" Capture");
                    break;
                }
                case 1: {
                    sb.append(" Playback");
                }
            }
            return sb.toString();
        }

        private void __constructor__(AlsaDevicesParser alsaDevicesParser) {
            this.$$robo$$com_android_internal_alsa_AlsaDevicesParser_AlsaDeviceRecord$__constructor__(alsaDevicesParser);
        }

        public AlsaDeviceRecord(AlsaDevicesParser alsaDevicesParser) {
            this.this$0 = alsaDevicesParser;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_alsa_AlsaDevicesParser_AlsaDeviceRecord$__constructor__(com.android.internal.alsa.AlsaDevicesParser ), this, alsaDevicesParser);
        }

        public boolean parse(String string2) {
            return (boolean)InvokeDynamicSupport.bootstrap("parse", $$robo$$com_android_internal_alsa_AlsaDevicesParser_AlsaDeviceRecord$parse(java.lang.String ), this, string2);
        }

        public String textFormat() {
            return InvokeDynamicSupport.bootstrap("textFormat", $$robo$$com_android_internal_alsa_AlsaDevicesParser_AlsaDeviceRecord$textFormat(), this);
        }

        public /* synthetic */ AlsaDeviceRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AlsaDeviceRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

