/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.SearchManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Log;
import com.android.internal.app.IVoiceInteractionManagerService;
import com.android.internal.app.IVoiceInteractionSessionListener;
import com.android.internal.app.IVoiceInteractionSessionShowCallback;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AssistUtils
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "AssistUtils";
    private Context mContext;
    private IVoiceInteractionManagerService mVoiceInteractionManagerService;

    private void $$robo$$com_android_internal_app_AssistUtils$__constructor__(Context context) {
        this.mContext = context;
        this.mVoiceInteractionManagerService = IVoiceInteractionManagerService.Stub.asInterface(ServiceManager.getService("voiceinteraction"));
    }

    private final boolean $$robo$$com_android_internal_app_AssistUtils$showSessionForActiveService(Bundle args, int sourceFlags, IVoiceInteractionSessionShowCallback showCallback, IBinder activityToken) {
        try {
            if (this.mVoiceInteractionManagerService != null) {
                return this.mVoiceInteractionManagerService.showSessionForActiveService(args, sourceFlags, showCallback, activityToken);
            }
        }
        catch (RemoteException e) {
            Log.w("AssistUtils", "Failed to call showSessionForActiveService", e);
        }
        return false;
    }

    private final void $$robo$$com_android_internal_app_AssistUtils$launchVoiceAssistFromKeyguard() {
        try {
            if (this.mVoiceInteractionManagerService != null) {
                this.mVoiceInteractionManagerService.launchVoiceAssistFromKeyguard();
            }
        }
        catch (RemoteException e) {
            Log.w("AssistUtils", "Failed to call launchVoiceAssistFromKeyguard", e);
        }
    }

    private final boolean $$robo$$com_android_internal_app_AssistUtils$activeServiceSupportsAssistGesture() {
        try {
            return this.mVoiceInteractionManagerService != null && this.mVoiceInteractionManagerService.activeServiceSupportsAssist();
        }
        catch (RemoteException e) {
            Log.w("AssistUtils", "Failed to call activeServiceSupportsAssistGesture", e);
            return false;
        }
    }

    private final boolean $$robo$$com_android_internal_app_AssistUtils$activeServiceSupportsLaunchFromKeyguard() {
        try {
            return this.mVoiceInteractionManagerService != null && this.mVoiceInteractionManagerService.activeServiceSupportsLaunchFromKeyguard();
        }
        catch (RemoteException e) {
            Log.w("AssistUtils", "Failed to call activeServiceSupportsLaunchFromKeyguard", e);
            return false;
        }
    }

    private final ComponentName $$robo$$com_android_internal_app_AssistUtils$getActiveServiceComponentName() {
        try {
            if (this.mVoiceInteractionManagerService != null) {
                return this.mVoiceInteractionManagerService.getActiveServiceComponentName();
            }
            return null;
        }
        catch (RemoteException e) {
            Log.w("AssistUtils", "Failed to call getActiveServiceComponentName", e);
            return null;
        }
    }

    private final boolean $$robo$$com_android_internal_app_AssistUtils$isSessionRunning() {
        try {
            return this.mVoiceInteractionManagerService != null && this.mVoiceInteractionManagerService.isSessionRunning();
        }
        catch (RemoteException e) {
            Log.w("AssistUtils", "Failed to call isSessionRunning", e);
            return false;
        }
    }

    private final void $$robo$$com_android_internal_app_AssistUtils$hideCurrentSession() {
        try {
            if (this.mVoiceInteractionManagerService != null) {
                this.mVoiceInteractionManagerService.hideCurrentSession();
            }
        }
        catch (RemoteException e) {
            Log.w("AssistUtils", "Failed to call hideCurrentSession", e);
        }
    }

    private final void $$robo$$com_android_internal_app_AssistUtils$onLockscreenShown() {
        try {
            if (this.mVoiceInteractionManagerService != null) {
                this.mVoiceInteractionManagerService.onLockscreenShown();
            }
        }
        catch (RemoteException e) {
            Log.w("AssistUtils", "Failed to call onLockscreenShown", e);
        }
    }

    private final void $$robo$$com_android_internal_app_AssistUtils$registerVoiceInteractionSessionListener(IVoiceInteractionSessionListener listener) {
        try {
            if (this.mVoiceInteractionManagerService != null) {
                this.mVoiceInteractionManagerService.registerVoiceInteractionSessionListener(listener);
            }
        }
        catch (RemoteException e) {
            Log.w("AssistUtils", "Failed to register voice interaction listener", e);
        }
    }

    private final ComponentName $$robo$$com_android_internal_app_AssistUtils$getAssistComponentForUser(int userId) {
        String setting = Settings.Secure.getStringForUser(this.mContext.getContentResolver(), "assistant", userId);
        if (setting != null) {
            return ComponentName.unflattenFromString(setting);
        }
        if (this.activeServiceSupportsAssistGesture()) {
            return this.getActiveServiceComponentName();
        }
        Intent intent = ((SearchManager)this.mContext.getSystemService("search")).getAssistIntent(false);
        PackageManager pm = this.mContext.getPackageManager();
        ResolveInfo info = pm.resolveActivityAsUser(intent, 65536, userId);
        if (info != null) {
            return new ComponentName(info.activityInfo.applicationInfo.packageName, info.activityInfo.name);
        }
        return null;
    }

    private static final boolean $$robo$$com_android_internal_app_AssistUtils$isPreinstalledAssistant(Context context, ComponentName assistant) {
        ApplicationInfo applicationInfo;
        if (assistant == null) {
            return false;
        }
        try {
            applicationInfo = context.getPackageManager().getApplicationInfo(assistant.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
        return applicationInfo.isSystemApp() || applicationInfo.isUpdatedSystemApp();
    }

    private static final boolean $$robo$$com_android_internal_app_AssistUtils$isDisclosureEnabled(Context context) {
        return Settings.Secure.getInt(context.getContentResolver(), "assist_disclosure_enabled", 0) != 0;
    }

    private static final boolean $$robo$$com_android_internal_app_AssistUtils$shouldDisclose(Context context, ComponentName assistant) {
        if (!AssistUtils.allowDisablingAssistDisclosure(context)) {
            return true;
        }
        return AssistUtils.isDisclosureEnabled(context) || !AssistUtils.isPreinstalledAssistant(context, assistant);
    }

    private static final boolean $$robo$$com_android_internal_app_AssistUtils$allowDisablingAssistDisclosure(Context context) {
        return context.getResources().getBoolean(17956873);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_app_AssistUtils$__constructor__(context);
    }

    public AssistUtils(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_AssistUtils$__constructor__(android.content.Context ), this, context);
    }

    public boolean showSessionForActiveService(Bundle bundle, int n, IVoiceInteractionSessionShowCallback iVoiceInteractionSessionShowCallback, IBinder iBinder) {
        return (boolean)InvokeDynamicSupport.bootstrap("showSessionForActiveService", $$robo$$com_android_internal_app_AssistUtils$showSessionForActiveService(android.os.Bundle int com.android.internal.app.IVoiceInteractionSessionShowCallback android.os.IBinder ), this, bundle, n, iVoiceInteractionSessionShowCallback, iBinder);
    }

    public void launchVoiceAssistFromKeyguard() {
        InvokeDynamicSupport.bootstrap("launchVoiceAssistFromKeyguard", $$robo$$com_android_internal_app_AssistUtils$launchVoiceAssistFromKeyguard(), this);
    }

    public boolean activeServiceSupportsAssistGesture() {
        return (boolean)InvokeDynamicSupport.bootstrap("activeServiceSupportsAssistGesture", $$robo$$com_android_internal_app_AssistUtils$activeServiceSupportsAssistGesture(), this);
    }

    public boolean activeServiceSupportsLaunchFromKeyguard() {
        return (boolean)InvokeDynamicSupport.bootstrap("activeServiceSupportsLaunchFromKeyguard", $$robo$$com_android_internal_app_AssistUtils$activeServiceSupportsLaunchFromKeyguard(), this);
    }

    public ComponentName getActiveServiceComponentName() {
        return InvokeDynamicSupport.bootstrap("getActiveServiceComponentName", $$robo$$com_android_internal_app_AssistUtils$getActiveServiceComponentName(), this);
    }

    public boolean isSessionRunning() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSessionRunning", $$robo$$com_android_internal_app_AssistUtils$isSessionRunning(), this);
    }

    public void hideCurrentSession() {
        InvokeDynamicSupport.bootstrap("hideCurrentSession", $$robo$$com_android_internal_app_AssistUtils$hideCurrentSession(), this);
    }

    public void onLockscreenShown() {
        InvokeDynamicSupport.bootstrap("onLockscreenShown", $$robo$$com_android_internal_app_AssistUtils$onLockscreenShown(), this);
    }

    public void registerVoiceInteractionSessionListener(IVoiceInteractionSessionListener iVoiceInteractionSessionListener) {
        InvokeDynamicSupport.bootstrap("registerVoiceInteractionSessionListener", $$robo$$com_android_internal_app_AssistUtils$registerVoiceInteractionSessionListener(com.android.internal.app.IVoiceInteractionSessionListener ), this, iVoiceInteractionSessionListener);
    }

    public ComponentName getAssistComponentForUser(int n) {
        return InvokeDynamicSupport.bootstrap("getAssistComponentForUser", $$robo$$com_android_internal_app_AssistUtils$getAssistComponentForUser(int ), this, n);
    }

    public static boolean isPreinstalledAssistant(Context context, ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isPreinstalledAssistant", $$robo$$com_android_internal_app_AssistUtils$isPreinstalledAssistant(android.content.Context android.content.ComponentName ), (Context)context, (ComponentName)componentName);
    }

    private static boolean isDisclosureEnabled(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDisclosureEnabled", $$robo$$com_android_internal_app_AssistUtils$isDisclosureEnabled(android.content.Context ), (Context)context);
    }

    public static boolean shouldDisclose(Context context, ComponentName componentName) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("shouldDisclose", $$robo$$com_android_internal_app_AssistUtils$shouldDisclose(android.content.Context android.content.ComponentName ), (Context)context, (ComponentName)componentName);
    }

    public static boolean allowDisablingAssistDisclosure(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("allowDisablingAssistDisclosure", $$robo$$com_android_internal_app_AssistUtils$allowDisablingAssistDisclosure(android.content.Context ), (Context)context);
    }

    public /* synthetic */ AssistUtils() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AssistUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

