/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.ServiceConnection;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.LabeledIntent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.database.DataSetObserver;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.Process;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.storage.StorageManager;
import android.service.chooser.ChooserTarget;
import android.service.chooser.IChooserTargetResult;
import android.service.chooser.IChooserTargetService;
import android.text.TextUtils;
import android.util.FloatProperty;
import android.util.Log;
import android.util.Slog;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ListView;
import com.android.internal.app.IntentForwarderActivity;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverListController;
import com.android.internal.app.ResolverTargetActionsDialogFragment;
import com.android.internal.logging.MetricsLogger;
import com.google.android.collect.Lists;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ChooserActivity
extends ResolverActivity
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "ChooserActivity";
    public static String EXTRA_PRIVATE_RETAIN_IN_ON_STOP = "com.android.internal.app.ChooserActivity.EXTRA_PRIVATE_RETAIN_IN_ON_STOP";
    private static boolean DEBUG = false;
    private static int QUERY_TARGET_SERVICE_LIMIT = 5;
    private static int WATCHDOG_TIMEOUT_MILLIS = 5000;
    private Bundle mReplacementExtras;
    private IntentSender mChosenComponentSender;
    private IntentSender mRefinementIntentSender;
    private RefinementResultReceiver mRefinementResultReceiver;
    private ChooserTarget[] mCallerChooserTargets;
    private ComponentName[] mFilteredComponentNames;
    private Intent mReferrerFillInIntent;
    private long mChooserShownTime;
    protected boolean mIsSuccessfullySelected;
    private ChooserListAdapter mChooserListAdapter;
    private ChooserRowAdapter mChooserRowAdapter;
    private SharedPreferences mPinnedSharedPrefs;
    private static float PINNED_TARGET_SCORE_BOOST = 1000.0f;
    private static float CALLER_TARGET_SCORE_BOOST = 900.0f;
    private static String PINNED_SHARED_PREFS_NAME = "chooser_pin_settings";
    private static String TARGET_DETAILS_FRAGMENT_TAG = "targetDetailsFragment";
    private List<ChooserTargetServiceConnection> mServiceConnections;
    private static int CHOOSER_TARGET_SERVICE_RESULT = 1;
    private static int CHOOSER_TARGET_SERVICE_WATCHDOG_TIMEOUT = 2;
    private Handler mChooserHandler;

    private void $$robo$$com_android_internal_app_ChooserActivity$__constructor__() {
        this.mServiceConnections = new ArrayList<ChooserTargetServiceConnection>();
        this.mChooserHandler = new ShadowedObject(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ ChooserActivity this$0;

            private void $$robo$$com_android_internal_app_ChooserActivity_1$__constructor__(ChooserActivity this$0) {
            }

            private final void $$robo$$com_android_internal_app_ChooserActivity_1$handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        if (this.this$0.isDestroyed()) break;
                        ServiceResultInfo sri = (ServiceResultInfo)msg.obj;
                        if (!this.this$0.mServiceConnections.contains(sri.connection)) {
                            Log.w("ChooserActivity", "ChooserTargetServiceConnection " + sri.connection + " returned after being removed from active connections. Have you considered returning results faster?");
                            break;
                        }
                        if (sri.resultTargets != null) {
                            this.this$0.mChooserListAdapter.addServiceResults(sri.originalTarget, sri.resultTargets);
                        }
                        this.this$0.unbindService(sri.connection);
                        sri.connection.destroy();
                        this.this$0.mServiceConnections.remove(sri.connection);
                        if (!this.this$0.mServiceConnections.isEmpty()) break;
                        this.this$0.mChooserHandler.removeMessages(2);
                        this.this$0.sendVoiceChoicesIfNeeded();
                        this.this$0.mChooserListAdapter.setShowServiceTargets(true);
                        break;
                    }
                    case 2: {
                        this.this$0.unbindRemainingServices();
                        this.this$0.sendVoiceChoicesIfNeeded();
                        this.this$0.mChooserListAdapter.setShowServiceTargets(true);
                        break;
                    }
                    default: {
                        super.handleMessage(msg);
                    }
                }
            }

            private void __constructor__(ChooserActivity chooserActivity) {
                this.$$robo$$com_android_internal_app_ChooserActivity_1$__constructor__(chooserActivity);
            }
            {
                this.this$0 = chooserActivity;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_1$__constructor__(com.android.internal.app.ChooserActivity ), this, chooserActivity);
            }

            @Override
            public void handleMessage(Message message) {
                InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$com_android_internal_app_ChooserActivity_1$handleMessage(android.os.Message ), this, message);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$onCreate(Bundle savedInstanceState) {
        Parcelable[] targetsParcelable;
        CallSite intentReceivedTime = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        this.mIsSuccessfullySelected = false;
        Intent intent = this.getIntent();
        Object targetParcelable = intent.getParcelableExtra("android.intent.extra.INTENT");
        if (!(targetParcelable instanceof Intent)) {
            Log.w("ChooserActivity", "Target is not an intent: " + targetParcelable);
            this.finish();
            super.onCreate(null);
            return;
        }
        Intent target = (Intent)targetParcelable;
        if (target != null) {
            this.modifyTargetIntent(target);
        }
        if ((targetsParcelable = intent.getParcelableArrayExtra("android.intent.extra.ALTERNATE_INTENTS")) != null) {
            boolean offset = target == null;
            Intent[] additionalTargets = new Intent[offset ? targetsParcelable.length - 1 : targetsParcelable.length];
            for (int i = 0; i < targetsParcelable.length; ++i) {
                if (!(targetsParcelable[i] instanceof Intent)) {
                    Log.w("ChooserActivity", "EXTRA_ALTERNATE_INTENTS array entry #" + i + " is not an Intent: " + targetsParcelable[i]);
                    this.finish();
                    super.onCreate(null);
                    return;
                }
                Intent additionalTarget = (Intent)targetsParcelable[i];
                if (i == 0 && target == null) {
                    target = additionalTarget;
                    this.modifyTargetIntent(target);
                    continue;
                }
                additionalTargets[offset ? i - 1 : i] = additionalTarget;
                this.modifyTargetIntent(additionalTarget);
            }
            this.setAdditionalTargets(additionalTargets);
        }
        this.mReplacementExtras = intent.getBundleExtra("android.intent.extra.REPLACEMENT_EXTRAS");
        CharSequence title = intent.getCharSequenceExtra("android.intent.extra.TITLE");
        int defaultTitleRes = 0;
        if (title == null) {
            defaultTitleRes = 17039607;
        }
        Parcelable[] pa = intent.getParcelableArrayExtra("android.intent.extra.INITIAL_INTENTS");
        Intent[] initialIntents = null;
        if (pa != null) {
            initialIntents = new Intent[pa.length];
            for (int i = 0; i < pa.length; ++i) {
                if (!(pa[i] instanceof Intent)) {
                    Log.w("ChooserActivity", "Initial intent #" + i + " not an Intent: " + pa[i]);
                    this.finish();
                    super.onCreate(null);
                    return;
                }
                Intent in = (Intent)pa[i];
                this.modifyTargetIntent(in);
                initialIntents[i] = in;
            }
        }
        this.mReferrerFillInIntent = new Intent().putExtra("android.intent.extra.REFERRER", this.getReferrer());
        this.mChosenComponentSender = (IntentSender)intent.getParcelableExtra("android.intent.extra.CHOSEN_COMPONENT_INTENT_SENDER");
        this.mRefinementIntentSender = (IntentSender)intent.getParcelableExtra("android.intent.extra.CHOOSER_REFINEMENT_INTENT_SENDER");
        this.setSafeForwardingMode(true);
        pa = intent.getParcelableArrayExtra("android.intent.extra.EXCLUDE_COMPONENTS");
        if (pa != null) {
            ComponentName[] names = new ComponentName[pa.length];
            for (int i = 0; i < pa.length; ++i) {
                if (!(pa[i] instanceof ComponentName)) {
                    Log.w("ChooserActivity", "Filtered component #" + i + " not a ComponentName: " + pa[i]);
                    names = null;
                    break;
                }
                names[i] = (ComponentName)pa[i];
            }
            this.mFilteredComponentNames = names;
        }
        if ((pa = intent.getParcelableArrayExtra("android.intent.extra.CHOOSER_TARGETS")) != null) {
            ChooserTarget[] targets = new ChooserTarget[pa.length];
            for (int i = 0; i < pa.length; ++i) {
                if (!(pa[i] instanceof ChooserTarget)) {
                    Log.w("ChooserActivity", "Chooser target #" + i + " not a ChooserTarget: " + pa[i]);
                    targets = null;
                    break;
                }
                targets[i] = (ChooserTarget)pa[i];
            }
            this.mCallerChooserTargets = targets;
        }
        this.mPinnedSharedPrefs = ChooserActivity.getPinnedSharedPrefs(this);
        this.setRetainInOnStop(intent.getBooleanExtra("com.android.internal.app.ChooserActivity.EXTRA_PRIVATE_RETAIN_IN_ON_STOP", false));
        super.onCreate(savedInstanceState, target, title, defaultTitleRes, initialIntents, null, false);
        MetricsLogger.action(this, 214);
        this.mChooserShownTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
        long systemCost = this.mChooserShownTime - intentReceivedTime;
        MetricsLogger.histogram(null, "system_cost_for_smart_sharing", (int)systemCost);
    }

    private static final SharedPreferences $$robo$$com_android_internal_app_ChooserActivity$getPinnedSharedPrefs(Context context) {
        File prefsFile = new File(new File(Environment.getDataUserCePackageDirectory(StorageManager.UUID_PRIVATE_INTERNAL, context.getUserId(), context.getPackageName()), "shared_prefs"), "chooser_pin_settings.xml");
        return context.getSharedPreferences(prefsFile, 0);
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$onDestroy() {
        super.onDestroy();
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        this.unbindRemainingServices();
        this.mChooserHandler.removeMessages(1);
    }

    private final Intent $$robo$$com_android_internal_app_ChooserActivity$getReplacementIntent(ActivityInfo aInfo, Intent defIntent) {
        Bundle replExtras;
        Intent result = defIntent;
        if (this.mReplacementExtras != null && (replExtras = this.mReplacementExtras.getBundle(aInfo.packageName)) != null) {
            result = new Intent(defIntent);
            result.putExtras(replExtras);
        }
        if (aInfo.name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_PARENT) || aInfo.name.equals(IntentForwarderActivity.FORWARD_INTENT_TO_MANAGED_PROFILE)) {
            result = Intent.createChooser(result, this.getIntent().getCharSequenceExtra("android.intent.extra.TITLE"));
            result.putExtra("android.intent.extra.AUTO_LAUNCH_SINGLE_CHOICE", false);
        }
        return result;
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$onActivityStarted(ResolverActivity.TargetInfo cti) {
        ComponentName target;
        if (this.mChosenComponentSender != null && (target = cti.getResolvedComponentName()) != null) {
            Intent fillIn = new Intent().putExtra("android.intent.extra.CHOSEN_COMPONENT", target);
            try {
                this.mChosenComponentSender.sendIntent(this, -1, fillIn, null, null);
            }
            catch (IntentSender.SendIntentException e) {
                Slog.e("ChooserActivity", "Unable to launch supplied IntentSender to report the chosen component: " + e);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$onPrepareAdapterView(AbsListView adapterView, ResolverActivity.ResolveListAdapter adapter) {
        ListView listView = adapterView instanceof ListView ? (ListView)adapterView : null;
        this.mChooserListAdapter = (ChooserListAdapter)adapter;
        if (this.mCallerChooserTargets != null && this.mCallerChooserTargets.length > 0) {
            this.mChooserListAdapter.addServiceResults(null, Lists.newArrayList(this.mCallerChooserTargets));
        }
        this.mChooserRowAdapter = new ChooserRowAdapter(this, this.mChooserListAdapter);
        this.mChooserRowAdapter.registerDataSetObserver(new OffsetDataSetObserver(this, adapterView));
        adapterView.setAdapter(this.mChooserRowAdapter);
        if (listView != null) {
            listView.setItemsCanFocus(true);
        }
    }

    private final int $$robo$$com_android_internal_app_ChooserActivity$getLayoutResource() {
        return 17367111;
    }

    private final boolean $$robo$$com_android_internal_app_ChooserActivity$shouldGetActivityMetadata() {
        return true;
    }

    private final boolean $$robo$$com_android_internal_app_ChooserActivity$shouldAutoLaunchSingleChoice(ResolverActivity.TargetInfo target) {
        return this.getIntent().getBooleanExtra("android.intent.extra.AUTO_LAUNCH_SINGLE_CHOICE", super.shouldAutoLaunchSingleChoice(target));
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$showTargetDetails(ResolveInfo ri) {
        ComponentName name = ri.activityInfo.getComponentName();
        boolean pinned = this.mPinnedSharedPrefs.getBoolean(name.flattenToString(), false);
        ResolverTargetActionsDialogFragment f = new ResolverTargetActionsDialogFragment(ri.loadLabel(this.getPackageManager()), name, pinned);
        f.show(this.getFragmentManager(), "targetDetailsFragment");
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$modifyTargetIntent(Intent in) {
        String action = in.getAction();
        if ("android.intent.action.SEND".equals(action) || "android.intent.action.SEND_MULTIPLE".equals(action)) {
            in.addFlags(0x8080000);
        }
    }

    private final boolean $$robo$$com_android_internal_app_ChooserActivity$onTargetSelected(ResolverActivity.TargetInfo target, boolean alwaysCheck) {
        if (this.mRefinementIntentSender != null) {
            Intent fillIn = new Intent();
            List<Intent> sourceIntents = target.getAllSourceIntents();
            if (!sourceIntents.isEmpty()) {
                fillIn.putExtra("android.intent.extra.INTENT", sourceIntents.get(0));
                if (sourceIntents.size() > 1) {
                    Parcelable[] alts = new Intent[sourceIntents.size() - 1];
                    int N = sourceIntents.size();
                    for (int i = 1; i < N; ++i) {
                        alts[i - 1] = sourceIntents.get(i);
                    }
                    fillIn.putExtra("android.intent.extra.ALTERNATE_INTENTS", alts);
                }
                if (this.mRefinementResultReceiver != null) {
                    this.mRefinementResultReceiver.destroy();
                }
                this.mRefinementResultReceiver = new RefinementResultReceiver(this, target, null);
                fillIn.putExtra("android.intent.extra.RESULT_RECEIVER", this.mRefinementResultReceiver);
                try {
                    this.mRefinementIntentSender.sendIntent(this, 0, fillIn, null, null);
                    return false;
                }
                catch (IntentSender.SendIntentException e) {
                    Log.e("ChooserActivity", "Refinement IntentSender failed to send", e);
                }
            }
        }
        this.updateModelAndChooserCounts(target);
        return super.onTargetSelected(target, alwaysCheck);
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$startSelected(int which, boolean always, boolean filtered) {
        reference var4_4 = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System") - this.mChooserShownTime;
        super.startSelected(which, always, filtered);
        if (this.mChooserListAdapter != null) {
            int cat = 0;
            int value = which;
            switch (this.mChooserListAdapter.getPositionTargetType(which)) {
                case 0: {
                    cat = 215;
                    break;
                }
                case 1: {
                    cat = 216;
                    value -= this.mChooserListAdapter.getCallerTargetCount();
                    break;
                }
                case 2: {
                    cat = 217;
                    value -= this.mChooserListAdapter.getCallerTargetCount() + this.mChooserListAdapter.getServiceTargetCount();
                }
            }
            if (cat != 0) {
                MetricsLogger.action((Context)this, cat, value);
            }
            if (this.mIsSuccessfullySelected) {
                MetricsLogger.histogram(null, "user_selection_cost_for_smart_sharing", (int)var4_4);
                MetricsLogger.histogram(null, "app_position_for_smart_sharing", value);
            }
        }
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$queryTargetServices(ChooserListAdapter adapter) {
        PackageManager pm = this.getPackageManager();
        int targetsToQuery = 0;
        int N = adapter.getDisplayResolveInfoCount();
        for (int i = 0; i < N; ++i) {
            String serviceName;
            ResolverActivity.DisplayResolveInfo dri = adapter.getDisplayResolveInfo(i);
            if (adapter.getScore(dri) == 0.0f) continue;
            ActivityInfo ai = dri.getResolveInfo().activityInfo;
            Bundle md = ai.metaData;
            String string2 = serviceName = md != null ? this.convertServiceName(ai.packageName, md.getString("android.service.chooser.chooser_target_service")) : null;
            if (serviceName != null) {
                Intent serviceIntent;
                block8: {
                    ComponentName serviceComponent = new ComponentName(ai.packageName, serviceName);
                    serviceIntent = new Intent("android.service.chooser.ChooserTargetService").setComponent(serviceComponent);
                    try {
                        String perm = pm.getServiceInfo((ComponentName)serviceComponent, (int)0).permission;
                        if (!"android.permission.BIND_CHOOSER_TARGET_SERVICE".equals(perm)) {
                            Log.w("ChooserActivity", "ChooserTargetService " + serviceComponent + " does not require permission " + "android.permission.BIND_CHOOSER_TARGET_SERVICE" + " - this service will not be queried for ChooserTargets. add android:permission=\"" + "android.permission.BIND_CHOOSER_TARGET_SERVICE" + "\" to the <service> tag for " + serviceComponent + " in the manifest.");
                        }
                        break block8;
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        Log.e("ChooserActivity", "Could not look up service " + serviceComponent + "; component name not found");
                    }
                    continue;
                }
                ChooserTargetServiceConnection conn = new ChooserTargetServiceConnection(this, dri);
                if (this.bindServiceAsUser(serviceIntent, conn, 5, Process.myUserHandle())) {
                    this.mServiceConnections.add(conn);
                    ++targetsToQuery;
                }
            }
            if (targetsToQuery >= 5) break;
        }
        if (!this.mServiceConnections.isEmpty()) {
            this.mChooserHandler.sendEmptyMessageDelayed(2, 5000L);
        } else {
            this.sendVoiceChoicesIfNeeded();
        }
    }

    private final String $$robo$$com_android_internal_app_ChooserActivity$convertServiceName(String packageName, String serviceName) {
        if (TextUtils.isEmpty(serviceName)) {
            return null;
        }
        String fullName = serviceName.startsWith(".") ? packageName + serviceName : (serviceName.indexOf(46) >= 0 ? serviceName : null);
        return fullName;
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$unbindRemainingServices() {
        int N = this.mServiceConnections.size();
        for (int i = 0; i < N; ++i) {
            ChooserTargetServiceConnection conn = this.mServiceConnections.get(i);
            this.unbindService(conn);
            conn.destroy();
        }
        this.mServiceConnections.clear();
        this.mChooserHandler.removeMessages(2);
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$onSetupVoiceInteraction() {
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$updateModelAndChooserCounts(ResolverActivity.TargetInfo info) {
        if (info != null) {
            ResolveInfo ri = info.getResolveInfo();
            Intent targetIntent = this.getTargetIntent();
            if (ri != null && ri.activityInfo != null && targetIntent != null && this.mAdapter != null) {
                this.mAdapter.updateModel(info.getResolvedComponentName());
                this.mAdapter.updateChooserCounts(ri.activityInfo.packageName, this.getUserId(), targetIntent.getAction());
            }
        }
        this.mIsSuccessfullySelected = true;
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$onRefinementResult(ResolverActivity.TargetInfo selectedTarget, Intent matchingIntent) {
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        if (selectedTarget == null) {
            Log.e("ChooserActivity", "Refinement result intent did not match any known targets; canceling");
        } else if (!this.checkTargetSourceIntent(selectedTarget, matchingIntent)) {
            Log.e("ChooserActivity", "onRefinementResult: Selected target " + selectedTarget + " cannot match refined source intent " + matchingIntent);
        } else {
            ResolverActivity.TargetInfo clonedTarget = selectedTarget.cloneFilledIn(matchingIntent, 0);
            if (super.onTargetSelected(clonedTarget, false)) {
                this.updateModelAndChooserCounts(clonedTarget);
                this.finish();
                return;
            }
        }
        this.onRefinementCanceled();
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$onRefinementCanceled() {
        if (this.mRefinementResultReceiver != null) {
            this.mRefinementResultReceiver.destroy();
            this.mRefinementResultReceiver = null;
        }
        this.finish();
    }

    private final boolean $$robo$$com_android_internal_app_ChooserActivity$checkTargetSourceIntent(ResolverActivity.TargetInfo target, Intent matchingIntent) {
        List<Intent> targetIntents = target.getAllSourceIntents();
        int N = targetIntents.size();
        for (int i = 0; i < N; ++i) {
            Intent targetIntent = targetIntents.get(i);
            if (!targetIntent.filterEquals(matchingIntent)) continue;
            return true;
        }
        return false;
    }

    private final void $$robo$$com_android_internal_app_ChooserActivity$filterServiceTargets(String packageName, List<ChooserTarget> targets) {
        if (targets == null) {
            return;
        }
        PackageManager pm = this.getPackageManager();
        for (int i = targets.size() - 1; i >= 0; --i) {
            boolean remove;
            ChooserTarget target = targets.get(i);
            ComponentName targetName = target.getComponentName();
            if (packageName != null && packageName.equals(targetName.getPackageName())) continue;
            try {
                ActivityInfo ai = pm.getActivityInfo(targetName, 0);
                remove = !ai.exported || ai.permission != null;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e("ChooserActivity", "Target " + target + " returned by " + packageName + " component not found");
                remove = true;
            }
            if (!remove) continue;
            targets.remove(i);
        }
    }

    private final ResolverActivity.ResolveListAdapter $$robo$$com_android_internal_app_ChooserActivity$createAdapter(Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed) {
        ChooserListAdapter adapter = new ChooserListAdapter(this, context, payloadIntents, initialIntents, rList, launchedFromUid, filterLastUsed, this.createListController());
        return adapter;
    }

    private final ResolverListController $$robo$$com_android_internal_app_ChooserActivity$createListController() {
        return new ChooserListController(this, this, this.mPm, this.getTargetIntent(), this.getReferrerPackageName(), this.mLaunchedFromUid);
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_ChooserActivity$__constructor__();
    }

    public ChooserActivity() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity$__constructor__(), this);
    }

    @Override
    protected void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_ChooserActivity$onCreate(android.os.Bundle ), this, bundle);
    }

    static SharedPreferences getPinnedSharedPrefs(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getPinnedSharedPrefs", $$robo$$com_android_internal_app_ChooserActivity$getPinnedSharedPrefs(android.content.Context ), (Context)context);
    }

    @Override
    protected void onDestroy() {
        InvokeDynamicSupport.bootstrap("onDestroy", $$robo$$com_android_internal_app_ChooserActivity$onDestroy(), this);
    }

    @Override
    public Intent getReplacementIntent(ActivityInfo activityInfo, Intent intent) {
        return InvokeDynamicSupport.bootstrap("getReplacementIntent", $$robo$$com_android_internal_app_ChooserActivity$getReplacementIntent(android.content.pm.ActivityInfo android.content.Intent ), this, activityInfo, intent);
    }

    @Override
    public void onActivityStarted(ResolverActivity.TargetInfo targetInfo) {
        InvokeDynamicSupport.bootstrap("onActivityStarted", $$robo$$com_android_internal_app_ChooserActivity$onActivityStarted(com.android.internal.app.ResolverActivity$TargetInfo ), this, targetInfo);
    }

    @Override
    public void onPrepareAdapterView(AbsListView absListView, ResolverActivity.ResolveListAdapter resolveListAdapter) {
        InvokeDynamicSupport.bootstrap("onPrepareAdapterView", $$robo$$com_android_internal_app_ChooserActivity$onPrepareAdapterView(android.widget.AbsListView com.android.internal.app.ResolverActivity$ResolveListAdapter ), this, absListView, resolveListAdapter);
    }

    @Override
    public int getLayoutResource() {
        return (int)InvokeDynamicSupport.bootstrap("getLayoutResource", $$robo$$com_android_internal_app_ChooserActivity$getLayoutResource(), this);
    }

    @Override
    public boolean shouldGetActivityMetadata() {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldGetActivityMetadata", $$robo$$com_android_internal_app_ChooserActivity$shouldGetActivityMetadata(), this);
    }

    @Override
    public boolean shouldAutoLaunchSingleChoice(ResolverActivity.TargetInfo targetInfo) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldAutoLaunchSingleChoice", $$robo$$com_android_internal_app_ChooserActivity$shouldAutoLaunchSingleChoice(com.android.internal.app.ResolverActivity$TargetInfo ), this, targetInfo);
    }

    @Override
    public void showTargetDetails(ResolveInfo resolveInfo) {
        InvokeDynamicSupport.bootstrap("showTargetDetails", $$robo$$com_android_internal_app_ChooserActivity$showTargetDetails(android.content.pm.ResolveInfo ), this, resolveInfo);
    }

    private void modifyTargetIntent(Intent intent) {
        InvokeDynamicSupport.bootstrap("modifyTargetIntent", $$robo$$com_android_internal_app_ChooserActivity$modifyTargetIntent(android.content.Intent ), this, intent);
    }

    @Override
    protected boolean onTargetSelected(ResolverActivity.TargetInfo targetInfo, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("onTargetSelected", $$robo$$com_android_internal_app_ChooserActivity$onTargetSelected(com.android.internal.app.ResolverActivity$TargetInfo boolean ), this, targetInfo, bl);
    }

    @Override
    public void startSelected(int n, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("startSelected", $$robo$$com_android_internal_app_ChooserActivity$startSelected(int boolean boolean ), this, n, bl, bl2);
    }

    void queryTargetServices(ChooserListAdapter chooserListAdapter) {
        InvokeDynamicSupport.bootstrap("queryTargetServices", $$robo$$com_android_internal_app_ChooserActivity$queryTargetServices(com.android.internal.app.ChooserActivity$ChooserListAdapter ), this, chooserListAdapter);
    }

    private String convertServiceName(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("convertServiceName", $$robo$$com_android_internal_app_ChooserActivity$convertServiceName(java.lang.String java.lang.String ), this, string2, string3);
    }

    void unbindRemainingServices() {
        InvokeDynamicSupport.bootstrap("unbindRemainingServices", $$robo$$com_android_internal_app_ChooserActivity$unbindRemainingServices(), this);
    }

    @Override
    public void onSetupVoiceInteraction() {
        InvokeDynamicSupport.bootstrap("onSetupVoiceInteraction", $$robo$$com_android_internal_app_ChooserActivity$onSetupVoiceInteraction(), this);
    }

    void updateModelAndChooserCounts(ResolverActivity.TargetInfo targetInfo) {
        InvokeDynamicSupport.bootstrap("updateModelAndChooserCounts", $$robo$$com_android_internal_app_ChooserActivity$updateModelAndChooserCounts(com.android.internal.app.ResolverActivity$TargetInfo ), this, targetInfo);
    }

    void onRefinementResult(ResolverActivity.TargetInfo targetInfo, Intent intent) {
        InvokeDynamicSupport.bootstrap("onRefinementResult", $$robo$$com_android_internal_app_ChooserActivity$onRefinementResult(com.android.internal.app.ResolverActivity$TargetInfo android.content.Intent ), this, targetInfo, intent);
    }

    void onRefinementCanceled() {
        InvokeDynamicSupport.bootstrap("onRefinementCanceled", $$robo$$com_android_internal_app_ChooserActivity$onRefinementCanceled(), this);
    }

    boolean checkTargetSourceIntent(ResolverActivity.TargetInfo targetInfo, Intent intent) {
        return (boolean)InvokeDynamicSupport.bootstrap("checkTargetSourceIntent", $$robo$$com_android_internal_app_ChooserActivity$checkTargetSourceIntent(com.android.internal.app.ResolverActivity$TargetInfo android.content.Intent ), this, targetInfo, intent);
    }

    void filterServiceTargets(String string2, List<ChooserTarget> list) {
        InvokeDynamicSupport.bootstrap("filterServiceTargets", $$robo$$com_android_internal_app_ChooserActivity$filterServiceTargets(java.lang.String java.util.List<android.service.chooser.ChooserTarget> ), this, string2, list);
    }

    @Override
    public ResolverActivity.ResolveListAdapter createAdapter(Context context, List<Intent> list, Intent[] intentArray, List<ResolveInfo> list2, int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("createAdapter", $$robo$$com_android_internal_app_ChooserActivity$createAdapter(android.content.Context java.util.List<android.content.Intent> android.content.Intent[] java.util.List<android.content.pm.ResolveInfo> int boolean ), this, context, list, intentArray, list2, n, bl);
    }

    @Override
    protected ResolverListController createListController() {
        return InvokeDynamicSupport.bootstrap("createListController", $$robo$$com_android_internal_app_ChooserActivity$createListController(), this);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChooserActivity)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class OffsetDataSetObserver
    extends DataSetObserver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private AbsListView mListView;
        private int mCachedViewType;
        private View mCachedView;
        /* synthetic */ ChooserActivity this$0;

        private void $$robo$$com_android_internal_app_ChooserActivity_OffsetDataSetObserver$__constructor__(ChooserActivity this$0, AbsListView listView) {
            this.mCachedViewType = -1;
            this.mListView = listView;
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_OffsetDataSetObserver$onChanged() {
            if (this.this$0.mResolverDrawerLayout == null) {
                return;
            }
            int chooserTargetRows = this.this$0.mChooserRowAdapter.getServiceTargetRowCount();
            int offset = 0;
            for (int i = 0; i < chooserTargetRows; ++i) {
                int pos = this.this$0.mChooserRowAdapter.getCallerTargetRowCount() + i;
                int vt = this.this$0.mChooserRowAdapter.getItemViewType(pos);
                if (vt != this.mCachedViewType) {
                    this.mCachedView = null;
                }
                View v = this.this$0.mChooserRowAdapter.getView(pos, this.mCachedView, this.mListView);
                int height = ((RowViewHolder)v.getTag()).measuredRowHeight;
                offset += (int)((float)height * this.this$0.mChooserRowAdapter.getRowScale(pos));
                if (vt >= 0) {
                    this.mCachedViewType = vt;
                    this.mCachedView = v;
                    continue;
                }
                this.mCachedViewType = -1;
            }
            this.this$0.mResolverDrawerLayout.setCollapsibleHeightReserved(offset);
        }

        private void __constructor__(ChooserActivity chooserActivity, AbsListView absListView) {
            this.$$robo$$com_android_internal_app_ChooserActivity_OffsetDataSetObserver$__constructor__(chooserActivity, absListView);
        }

        public OffsetDataSetObserver(ChooserActivity chooserActivity, AbsListView absListView) {
            this.this$0 = chooserActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_OffsetDataSetObserver$__constructor__(com.android.internal.app.ChooserActivity android.widget.AbsListView ), this, chooserActivity, absListView);
        }

        @Override
        public void onChanged() {
            InvokeDynamicSupport.bootstrap("onChanged", $$robo$$com_android_internal_app_ChooserActivity_OffsetDataSetObserver$onChanged(), this);
        }

        public /* synthetic */ OffsetDataSetObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OffsetDataSetObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RefinementResultReceiver
    extends ResultReceiver
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ChooserActivity mChooserActivity;
        private ResolverActivity.TargetInfo mSelectedTarget;

        private void $$robo$$com_android_internal_app_ChooserActivity_RefinementResultReceiver$__constructor__(ChooserActivity host, ResolverActivity.TargetInfo target, Handler handler) {
            this.mChooserActivity = host;
            this.mSelectedTarget = target;
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_RefinementResultReceiver$onReceiveResult(int resultCode, Bundle resultData) {
            if (this.mChooserActivity == null) {
                Log.e("ChooserActivity", "Destroyed RefinementResultReceiver received a result");
                return;
            }
            if (resultData == null) {
                Log.e("ChooserActivity", "RefinementResultReceiver received null resultData");
                return;
            }
            switch (resultCode) {
                case 0: {
                    this.mChooserActivity.onRefinementCanceled();
                    break;
                }
                case -1: {
                    Object intentParcelable = resultData.getParcelable("android.intent.extra.INTENT");
                    if (intentParcelable instanceof Intent) {
                        this.mChooserActivity.onRefinementResult(this.mSelectedTarget, (Intent)intentParcelable);
                        break;
                    }
                    Log.e("ChooserActivity", "RefinementResultReceiver received RESULT_OK but no Intent in resultData with key Intent.EXTRA_INTENT");
                    break;
                }
                default: {
                    Log.w("ChooserActivity", "Unknown result code " + resultCode + " sent to RefinementResultReceiver");
                }
            }
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_RefinementResultReceiver$destroy() {
            this.mChooserActivity = null;
            this.mSelectedTarget = null;
        }

        private void __constructor__(ChooserActivity chooserActivity, ResolverActivity.TargetInfo targetInfo, Handler handler) {
            this.$$robo$$com_android_internal_app_ChooserActivity_RefinementResultReceiver$__constructor__(chooserActivity, targetInfo, handler);
        }

        public RefinementResultReceiver(ChooserActivity chooserActivity, ResolverActivity.TargetInfo targetInfo, Handler handler) {
            super(handler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_RefinementResultReceiver$__constructor__(com.android.internal.app.ChooserActivity com.android.internal.app.ResolverActivity$TargetInfo android.os.Handler ), this, chooserActivity, targetInfo, handler);
        }

        @Override
        protected void onReceiveResult(int n, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onReceiveResult", $$robo$$com_android_internal_app_ChooserActivity_RefinementResultReceiver$onReceiveResult(int android.os.Bundle ), this, n, bundle);
        }

        public void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$com_android_internal_app_ChooserActivity_RefinementResultReceiver$destroy(), this);
        }

        public /* synthetic */ RefinementResultReceiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RefinementResultReceiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ServiceResultInfo
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public ResolverActivity.DisplayResolveInfo originalTarget;
        public List<ChooserTarget> resultTargets;
        public ChooserTargetServiceConnection connection;

        private void $$robo$$com_android_internal_app_ChooserActivity_ServiceResultInfo$__constructor__(ResolverActivity.DisplayResolveInfo ot, List<ChooserTarget> rt, ChooserTargetServiceConnection c) {
            this.originalTarget = ot;
            this.resultTargets = rt;
            this.connection = c;
        }

        private void __constructor__(ResolverActivity.DisplayResolveInfo displayResolveInfo, List<ChooserTarget> list, ChooserTargetServiceConnection chooserTargetServiceConnection) {
            this.$$robo$$com_android_internal_app_ChooserActivity_ServiceResultInfo$__constructor__(displayResolveInfo, list, chooserTargetServiceConnection);
        }

        public ServiceResultInfo(ResolverActivity.DisplayResolveInfo displayResolveInfo, List<ChooserTarget> list, ChooserTargetServiceConnection chooserTargetServiceConnection) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ServiceResultInfo$__constructor__(com.android.internal.app.ResolverActivity$DisplayResolveInfo java.util.List<android.service.chooser.ChooserTarget> com.android.internal.app.ChooserActivity$ChooserTargetServiceConnection ), this, displayResolveInfo, list, chooserTargetServiceConnection);
        }

        public /* synthetic */ ServiceResultInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ServiceResultInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class ChooserTargetServiceConnection
    implements ServiceConnection,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ResolverActivity.DisplayResolveInfo mOriginalTarget;
        private ComponentName mConnectedComponent;
        private ChooserActivity mChooserActivity;
        private Object mLock;
        private IChooserTargetResult mChooserTargetResult;

        private void $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$__constructor__(ChooserActivity chooserActivity, ResolverActivity.DisplayResolveInfo dri) {
            this.mLock = new Object();
            this.mChooserTargetResult = new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ ChooserTargetServiceConnection this$0;

                private void $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection_1$__constructor__(ChooserTargetServiceConnection this$0) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection_1$sendResult(List<ChooserTarget> targets) throws RemoteException {
                    Object object = this.this$0.mLock;
                    synchronized (object) {
                        if (this.this$0.mChooserActivity == null) {
                            Log.e("ChooserActivity", "destroyed ChooserTargetServiceConnection received result from " + this.this$0.mConnectedComponent + "; ignoring...");
                            return;
                        }
                        this.this$0.mChooserActivity.filterServiceTargets(((ChooserTargetServiceConnection)this.this$0).mOriginalTarget.getResolveInfo().activityInfo.packageName, targets);
                        Message msg = Message.obtain();
                        msg.what = 1;
                        msg.obj = new ServiceResultInfo(this.this$0.mOriginalTarget, targets, this.this$0);
                        this.this$0.mChooserActivity.mChooserHandler.sendMessage(msg);
                    }
                }

                private void __constructor__(ChooserTargetServiceConnection chooserTargetServiceConnection) {
                    this.$$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection_1$__constructor__(chooserTargetServiceConnection);
                }
                {
                    this.this$0 = chooserTargetServiceConnection;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection_1$__constructor__(com.android.internal.app.ChooserActivity$ChooserTargetServiceConnection ), this, chooserTargetServiceConnection);
                }

                @Override
                public void sendResult(List<ChooserTarget> list) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("sendResult", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection_1$sendResult(java.util.List<android.service.chooser.ChooserTarget> ), this, list);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            this.mChooserActivity = chooserActivity;
            this.mOriginalTarget = dri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$onServiceConnected(ComponentName name, IBinder service) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mChooserActivity == null) {
                    Log.e("ChooserActivity", "destroyed ChooserTargetServiceConnection got onServiceConnected");
                    return;
                }
                IChooserTargetService icts = IChooserTargetService.Stub.asInterface(service);
                try {
                    icts.getChooserTargets(this.mOriginalTarget.getResolvedComponentName(), this.mOriginalTarget.getResolveInfo().filter, this.mChooserTargetResult);
                }
                catch (RemoteException e) {
                    Log.e("ChooserActivity", "Querying ChooserTargetService " + name + " failed.", e);
                    this.mChooserActivity.unbindService(this);
                    this.destroy();
                    this.mChooserActivity.mServiceConnections.remove(this);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$onServiceDisconnected(ComponentName name) {
            Object object = this.mLock;
            synchronized (object) {
                if (this.mChooserActivity == null) {
                    Log.e("ChooserActivity", "destroyed ChooserTargetServiceConnection got onServiceDisconnected");
                    return;
                }
                this.mChooserActivity.unbindService(this);
                this.destroy();
                this.mChooserActivity.mServiceConnections.remove(this);
                if (this.mChooserActivity.mServiceConnections.isEmpty()) {
                    this.mChooserActivity.mChooserHandler.removeMessages(2);
                    this.mChooserActivity.sendVoiceChoicesIfNeeded();
                }
                this.mConnectedComponent = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$destroy() {
            Object object = this.mLock;
            synchronized (object) {
                this.mChooserActivity = null;
                this.mOriginalTarget = null;
            }
        }

        private final String $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$toString() {
            return "ChooserTargetServiceConnection{service=" + this.mConnectedComponent + ", activity=" + (this.mOriginalTarget != null ? this.mOriginalTarget.getResolveInfo().activityInfo.toString() : "<connection destroyed>") + "}";
        }

        private void __constructor__(ChooserActivity chooserActivity, ResolverActivity.DisplayResolveInfo displayResolveInfo) {
            this.$$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$__constructor__(chooserActivity, displayResolveInfo);
        }

        public ChooserTargetServiceConnection(ChooserActivity chooserActivity, ResolverActivity.DisplayResolveInfo displayResolveInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$__constructor__(com.android.internal.app.ChooserActivity com.android.internal.app.ResolverActivity$DisplayResolveInfo ), this, chooserActivity, displayResolveInfo);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$onServiceConnected(android.content.ComponentName android.os.IBinder ), this, componentName, iBinder);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$onServiceDisconnected(android.content.ComponentName ), this, componentName);
        }

        public void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$destroy(), this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetServiceConnection$toString(), this);
        }

        public /* synthetic */ ChooserTargetServiceConnection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChooserTargetServiceConnection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RowViewHolder
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        View[] cells;
        ViewGroup row;
        int measuredRowHeight;
        int[] itemIndices;

        private void $$robo$$com_android_internal_app_ChooserActivity_RowViewHolder$__constructor__(ViewGroup row, int cellCount) {
            this.row = row;
            this.cells = new View[cellCount];
            this.itemIndices = new int[cellCount];
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_RowViewHolder$measure() {
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            this.row.measure(spec, spec);
            this.measuredRowHeight = this.row.getMeasuredHeight();
        }

        private void __constructor__(ViewGroup viewGroup, int n) {
            this.$$robo$$com_android_internal_app_ChooserActivity_RowViewHolder$__constructor__(viewGroup, n);
        }

        public RowViewHolder(ViewGroup viewGroup, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_RowViewHolder$__constructor__(android.view.ViewGroup int ), this, viewGroup, n);
        }

        public void measure() {
            InvokeDynamicSupport.bootstrap("measure", $$robo$$com_android_internal_app_ChooserActivity_RowViewHolder$measure(), this);
        }

        public /* synthetic */ RowViewHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RowViewHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ChooserRowAdapter
    extends BaseAdapter
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ChooserListAdapter mChooserListAdapter;
        private LayoutInflater mLayoutInflater;
        private int mColumnCount = 4;
        private RowScale[] mServiceTargetScale;
        private Interpolator mInterpolator;
        private int mAnimationCount;
        /* synthetic */ ChooserActivity this$0;

        private void $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$__constructor__(ChooserActivity this$0, ChooserListAdapter wrappedAdapter) {
            this.mColumnCount = 4;
            this.mAnimationCount = 0;
            this.mChooserListAdapter = wrappedAdapter;
            this.mLayoutInflater = LayoutInflater.from(this$0);
            this.mInterpolator = AnimationUtils.loadInterpolator(this$0, 17563653);
            wrappedAdapter.registerDataSetObserver((DataSetObserver)new ShadowedObject(this, this$0){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ ChooserActivity val$this$0;
                /* synthetic */ ChooserRowAdapter this$1;

                private void $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_1$__constructor__(ChooserRowAdapter this$1, ChooserActivity chooserActivity) {
                    this.this$1 = this$1;
                    this.val$this$0 = chooserActivity;
                }

                private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_1$onChanged() {
                    super.onChanged();
                    int rcount = this.this$1.getServiceTargetRowCount();
                    if (this.this$1.mServiceTargetScale == null || this.this$1.mServiceTargetScale.length != rcount) {
                        int i;
                        RowScale[] old = this.this$1.mServiceTargetScale;
                        int oldRCount = old != null ? old.length : 0;
                        ChooserRowAdapter.access$602(this.this$1, new RowScale[rcount]);
                        if (old != null && rcount > 0) {
                            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)old, (int)0, (Object)this.this$1.mServiceTargetScale, (int)0, (int)Math.min(old.length, rcount));
                        }
                        for (i = rcount; i < oldRCount; ++i) {
                            old[i].cancelAnimation();
                        }
                        for (i = oldRCount; i < rcount; ++i) {
                            RowScale rs;
                            ((ChooserRowAdapter)this.this$1).mServiceTargetScale[i] = rs = new RowScale(this.this$1, 0.0f, 1.0f).setInterpolator(this.this$1.mInterpolator);
                        }
                        for (i = oldRCount; i < rcount; ++i) {
                            this.this$1.mServiceTargetScale[i].startAnimation();
                        }
                    }
                    this.this$1.notifyDataSetChanged();
                }

                private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_1$onInvalidated() {
                    super.onInvalidated();
                    this.this$1.notifyDataSetInvalidated();
                    if (this.this$1.mServiceTargetScale != null) {
                        for (RowScale rs : this.this$1.mServiceTargetScale) {
                            rs.cancelAnimation();
                        }
                    }
                }

                private void __constructor__(ChooserRowAdapter chooserRowAdapter, ChooserActivity chooserActivity) {
                    this.$$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_1$__constructor__(chooserRowAdapter, chooserActivity);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_1$__constructor__(com.android.internal.app.ChooserActivity$ChooserRowAdapter com.android.internal.app.ChooserActivity ), this, chooserRowAdapter, chooserActivity);
                }

                @Override
                public void onChanged() {
                    InvokeDynamicSupport.bootstrap("onChanged", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_1$onChanged(), this);
                }

                @Override
                public void onInvalidated() {
                    InvokeDynamicSupport.bootstrap("onInvalidated", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_1$onInvalidated(), this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final float $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getRowScale(int rowPosition) {
            int start = this.getCallerTargetRowCount();
            int end = start + this.getServiceTargetRowCount();
            if (rowPosition >= start && rowPosition < end) {
                return this.mServiceTargetScale[rowPosition - start].get();
            }
            return 1.0f;
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$onAnimationStart() {
            boolean lock = this.mAnimationCount == 0;
            ++this.mAnimationCount;
            if (lock) {
                this.this$0.mResolverDrawerLayout.setDismissLocked(true);
            }
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$onAnimationEnd() {
            --this.mAnimationCount;
            if (this.mAnimationCount == 0) {
                this.this$0.mResolverDrawerLayout.setDismissLocked(false);
            }
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getCount() {
            return (int)((double)(this.getCallerTargetRowCount() + this.getServiceTargetRowCount()) + Math.ceil((float)this.mChooserListAdapter.getStandardTargetCount() / 4.0f));
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getCallerTargetRowCount() {
            return (int)Math.ceil((float)this.mChooserListAdapter.getCallerTargetCount() / 4.0f);
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getServiceTargetRowCount() {
            return (int)Math.ceil((float)this.mChooserListAdapter.getServiceTargetCount() / 4.0f);
        }

        private final Object $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getItem(int position) {
            return position;
        }

        private final long $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getItemId(int position) {
            return position;
        }

        private final View $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getView(int position, View convertView, ViewGroup parent) {
            RowViewHolder holder = convertView == null ? this.createViewHolder(parent) : (RowViewHolder)convertView.getTag();
            this.bindViewHolder(position, holder);
            return holder.row;
        }

        private final RowViewHolder $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$createViewHolder(ViewGroup parent) {
            ViewGroup row = (ViewGroup)this.mLayoutInflater.inflate(17367112, parent, false);
            RowViewHolder holder = new RowViewHolder(row, 4);
            int spec = View.MeasureSpec.makeMeasureSpec(0, 0);
            for (int i = 0; i < 4; ++i) {
                View v = this.mChooserListAdapter.createView(row);
                int column = i;
                v.setOnClickListener(new View.OnClickListener(this, holder, column){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ RowViewHolder val$holder;
                    /* synthetic */ int val$column;
                    /* synthetic */ ChooserRowAdapter this$1;

                    private void $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_2$__constructor__(ChooserRowAdapter this$1, RowViewHolder rowViewHolder, int n) {
                        this.this$1 = this$1;
                        this.val$holder = rowViewHolder;
                        this.val$column = n;
                    }

                    private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_2$onClick(View v) {
                        this.this$1.this$0.startSelected(this.val$holder.itemIndices[this.val$column], false, true);
                    }

                    private void __constructor__(ChooserRowAdapter chooserRowAdapter, RowViewHolder rowViewHolder, int n) {
                        this.$$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_2$__constructor__(chooserRowAdapter, rowViewHolder, n);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_2$__constructor__(com.android.internal.app.ChooserActivity$ChooserRowAdapter com.android.internal.app.ChooserActivity$RowViewHolder int ), this, chooserRowAdapter, rowViewHolder, n);
                    }

                    @Override
                    public void onClick(View view) {
                        InvokeDynamicSupport.bootstrap("onClick", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_2$onClick(android.view.View ), this, view);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                v.setOnLongClickListener(new View.OnLongClickListener(this, holder, column){
                    public /* synthetic */ Object __robo_data__;
                    /* synthetic */ RowViewHolder val$holder;
                    /* synthetic */ int val$column;
                    /* synthetic */ ChooserRowAdapter this$1;

                    private void $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_3$__constructor__(ChooserRowAdapter this$1, RowViewHolder rowViewHolder, int n) {
                        this.this$1 = this$1;
                        this.val$holder = rowViewHolder;
                        this.val$column = n;
                    }

                    private final boolean $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_3$onLongClick(View v) {
                        this.this$1.this$0.showTargetDetails(this.this$1.mChooserListAdapter.resolveInfoForPosition(this.val$holder.itemIndices[this.val$column], true));
                        return true;
                    }

                    private void __constructor__(ChooserRowAdapter chooserRowAdapter, RowViewHolder rowViewHolder, int n) {
                        this.$$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_3$__constructor__(chooserRowAdapter, rowViewHolder, n);
                    }
                    {
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_3$__constructor__(com.android.internal.app.ChooserActivity$ChooserRowAdapter com.android.internal.app.ChooserActivity$RowViewHolder int ), this, chooserRowAdapter, rowViewHolder, n);
                    }

                    @Override
                    public boolean onLongClick(View view) {
                        return (boolean)InvokeDynamicSupport.bootstrap("onLongClick", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter_3$onLongClick(android.view.View ), this, view);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
                row.addView(v);
                holder.cells[i] = v;
                ViewGroup.LayoutParams lp = v.getLayoutParams();
                v.measure(spec, spec);
                if (lp == null) {
                    lp = new ViewGroup.LayoutParams(-1, v.getMeasuredHeight());
                    row.setLayoutParams(lp);
                    continue;
                }
                lp.height = v.getMeasuredHeight();
            }
            holder.measure();
            ViewGroup.LayoutParams lp = row.getLayoutParams();
            if (lp == null) {
                lp = new ViewGroup.LayoutParams(-1, holder.measuredRowHeight);
                row.setLayoutParams(lp);
            } else {
                lp.height = holder.measuredRowHeight;
            }
            row.setTag(holder);
            return holder;
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$bindViewHolder(int rowPosition, RowViewHolder holder) {
            int end;
            int start = this.getFirstRowPosition(rowPosition);
            int startType = this.mChooserListAdapter.getPositionTargetType(start);
            for (end = start + 4 - 1; this.mChooserListAdapter.getPositionTargetType(end) != startType && end >= start; --end) {
            }
            if (startType == 1) {
                holder.row.setBackgroundColor(this.this$0.getColor(17170520));
            } else {
                holder.row.setBackgroundColor(0);
            }
            int oldHeight = holder.row.getLayoutParams().height;
            holder.row.getLayoutParams().height = Math.max(1, (int)((float)holder.measuredRowHeight * this.getRowScale(rowPosition)));
            if (holder.row.getLayoutParams().height != oldHeight) {
                holder.row.requestLayout();
            }
            for (int i = 0; i < 4; ++i) {
                View v = holder.cells[i];
                if (start + i <= end) {
                    v.setVisibility(0);
                    holder.itemIndices[i] = start + i;
                    this.mChooserListAdapter.bindView(holder.itemIndices[i], v);
                    continue;
                }
                v.setVisibility(8);
            }
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getFirstRowPosition(int row) {
            int callerCount = this.mChooserListAdapter.getCallerTargetCount();
            int callerRows = (int)Math.ceil((float)callerCount / 4.0f);
            if (row < callerRows) {
                return row * 4;
            }
            int serviceCount = this.mChooserListAdapter.getServiceTargetCount();
            int serviceRows = (int)Math.ceil((float)serviceCount / 4.0f);
            if (row < callerRows + serviceRows) {
                return callerCount + (row - callerRows) * 4;
            }
            return callerCount + serviceCount + (row - callerRows - serviceRows) * 4;
        }

        static /* synthetic */ RowScale[] access$602(ChooserRowAdapter x0, RowScale[] x1) {
            x0.mServiceTargetScale = x1;
            return x1;
        }

        private void __constructor__(ChooserActivity chooserActivity, ChooserListAdapter chooserListAdapter) {
            this.$$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$__constructor__(chooserActivity, chooserListAdapter);
        }

        public ChooserRowAdapter(ChooserActivity chooserActivity, ChooserListAdapter chooserListAdapter) {
            this.this$0 = chooserActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$__constructor__(com.android.internal.app.ChooserActivity com.android.internal.app.ChooserActivity$ChooserListAdapter ), this, chooserActivity, chooserListAdapter);
        }

        private float getRowScale(int n) {
            return (float)InvokeDynamicSupport.bootstrap("getRowScale", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getRowScale(int ), this, n);
        }

        public void onAnimationStart() {
            InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$onAnimationStart(), this);
        }

        public void onAnimationEnd() {
            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$onAnimationEnd(), this);
        }

        @Override
        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getCount(), this);
        }

        public int getCallerTargetRowCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCallerTargetRowCount", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getCallerTargetRowCount(), this);
        }

        public int getServiceTargetRowCount() {
            return (int)InvokeDynamicSupport.bootstrap("getServiceTargetRowCount", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getServiceTargetRowCount(), this);
        }

        @Override
        public Object getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getItem(int ), this, n);
        }

        @Override
        public long getItemId(int n) {
            return (long)InvokeDynamicSupport.bootstrap("getItemId", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getItemId(int ), this, n);
        }

        @Override
        public View getView(int n, View view, ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("getView", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getView(int android.view.View android.view.ViewGroup ), this, n, view, viewGroup);
        }

        RowViewHolder createViewHolder(ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("createViewHolder", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$createViewHolder(android.view.ViewGroup ), this, viewGroup);
        }

        void bindViewHolder(int n, RowViewHolder rowViewHolder) {
            InvokeDynamicSupport.bootstrap("bindViewHolder", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$bindViewHolder(int com.android.internal.app.ChooserActivity$RowViewHolder ), this, n, rowViewHolder);
        }

        int getFirstRowPosition(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getFirstRowPosition", $$robo$$com_android_internal_app_ChooserActivity_ChooserRowAdapter$getFirstRowPosition(int ), this, n);
        }

        public /* synthetic */ ChooserRowAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChooserRowAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RowScale
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private static int DURATION = 400;
        float mScale;
        ChooserRowAdapter mAdapter;
        private ObjectAnimator mAnimator;
        public static FloatProperty<RowScale> PROPERTY;

        private void $$robo$$com_android_internal_app_ChooserActivity_RowScale$__constructor__(ChooserRowAdapter adapter, float from, float to) {
            this.mAdapter = adapter;
            this.mScale = from;
            if (from == to) {
                this.mAnimator = null;
                return;
            }
            this.mAnimator = ObjectAnimator.ofFloat(this, PROPERTY, from, to).setDuration(400L);
            this.mAnimator.addListener((Animator.AnimatorListener)new ShadowedObject(this){
                public /* synthetic */ Object __robo_data__;
                /* synthetic */ RowScale this$0;

                private void $$robo$$com_android_internal_app_ChooserActivity_RowScale_2$__constructor__(RowScale this$0) {
                }

                private final void $$robo$$com_android_internal_app_ChooserActivity_RowScale_2$onAnimationStart(Animator animation) {
                    this.this$0.mAdapter.onAnimationStart();
                }

                private final void $$robo$$com_android_internal_app_ChooserActivity_RowScale_2$onAnimationEnd(Animator animation) {
                    this.this$0.mAdapter.onAnimationEnd();
                }

                private void __constructor__(RowScale rowScale) {
                    this.$$robo$$com_android_internal_app_ChooserActivity_RowScale_2$__constructor__(rowScale);
                }
                {
                    this.this$0 = rowScale;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_RowScale_2$__constructor__(com.android.internal.app.ChooserActivity$RowScale ), this, rowScale);
                }

                @Override
                public void onAnimationStart(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$com_android_internal_app_ChooserActivity_RowScale_2$onAnimationStart(android.animation.Animator ), this, animator2);
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$com_android_internal_app_ChooserActivity_RowScale_2$onAnimationEnd(android.animation.Animator ), this, animator2);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        private final RowScale $$robo$$com_android_internal_app_ChooserActivity_RowScale$setInterpolator(Interpolator interpolator2) {
            if (this.mAnimator != null) {
                this.mAnimator.setInterpolator(interpolator2);
            }
            return this;
        }

        private final float $$robo$$com_android_internal_app_ChooserActivity_RowScale$get() {
            return this.mScale;
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_RowScale$startAnimation() {
            if (this.mAnimator != null) {
                this.mAnimator.start();
            }
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_RowScale$cancelAnimation() {
            if (this.mAnimator != null) {
                this.mAnimator.cancel();
            }
        }

        static void __staticInitializer__() {
            PROPERTY = new FloatProperty<RowScale>("scale"){
                public /* synthetic */ Object __robo_data__;

                private void $$robo$$com_android_internal_app_ChooserActivity_RowScale_1$__constructor__(String name) {
                }

                private final void $$robo$$com_android_internal_app_ChooserActivity_RowScale_1$setValue(RowScale object, float value) {
                    object.mScale = value;
                    object.mAdapter.notifyDataSetChanged();
                }

                private final Float $$robo$$com_android_internal_app_ChooserActivity_RowScale_1$get(RowScale object) {
                    return Float.valueOf(object.mScale);
                }

                private void __constructor__(String string2) {
                    this.$$robo$$com_android_internal_app_ChooserActivity_RowScale_1$__constructor__(string2);
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_RowScale_1$__constructor__(java.lang.String ), this, string2);
                }

                @Override
                public void setValue(RowScale rowScale, float f) {
                    InvokeDynamicSupport.bootstrap("setValue", $$robo$$com_android_internal_app_ChooserActivity_RowScale_1$setValue(com.android.internal.app.ChooserActivity$RowScale float ), this, rowScale, f);
                }

                @Override
                public Float get(RowScale rowScale) {
                    return InvokeDynamicSupport.bootstrap("get", $$robo$$com_android_internal_app_ChooserActivity_RowScale_1$get(com.android.internal.app.ChooserActivity$RowScale ), this, rowScale);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(ChooserRowAdapter chooserRowAdapter, float f, float f2) {
            this.$$robo$$com_android_internal_app_ChooserActivity_RowScale$__constructor__(chooserRowAdapter, f, f2);
        }

        public RowScale(ChooserRowAdapter chooserRowAdapter, float f, float f2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_RowScale$__constructor__(com.android.internal.app.ChooserActivity$ChooserRowAdapter float float ), this, chooserRowAdapter, f, f2);
        }

        public RowScale setInterpolator(Interpolator interpolator2) {
            return InvokeDynamicSupport.bootstrap("setInterpolator", $$robo$$com_android_internal_app_ChooserActivity_RowScale$setInterpolator(android.view.animation.Interpolator ), this, interpolator2);
        }

        public float get() {
            return (float)InvokeDynamicSupport.bootstrap("get", $$robo$$com_android_internal_app_ChooserActivity_RowScale$get(), this);
        }

        public void startAnimation() {
            InvokeDynamicSupport.bootstrap("startAnimation", $$robo$$com_android_internal_app_ChooserActivity_RowScale$startAnimation(), this);
        }

        public void cancelAnimation() {
            InvokeDynamicSupport.bootstrap("cancelAnimation", $$robo$$com_android_internal_app_ChooserActivity_RowScale$cancelAnimation(), this);
        }

        static {
            RobolectricInternals.classInitializing(RowScale.class);
        }

        public /* synthetic */ RowScale() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RowScale)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class BaseChooserTargetComparator
    implements Comparator<ChooserTarget> {
        public /* synthetic */ Object __robo_data__;

        private void $$robo$$com_android_internal_app_ChooserActivity_BaseChooserTargetComparator$__constructor__() {
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_BaseChooserTargetComparator$compare(ChooserTarget lhs, ChooserTarget rhs) {
            return (int)Math.signum(rhs.getScore() - lhs.getScore());
        }

        private void __constructor__() {
            this.$$robo$$com_android_internal_app_ChooserActivity_BaseChooserTargetComparator$__constructor__();
        }

        public BaseChooserTargetComparator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_BaseChooserTargetComparator$__constructor__(), this);
        }

        @Override
        public int compare(ChooserTarget chooserTarget, ChooserTarget chooserTarget2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_app_ChooserActivity_BaseChooserTargetComparator$compare(android.service.chooser.ChooserTarget android.service.chooser.ChooserTarget ), this, chooserTarget, chooserTarget2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseChooserTargetComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ChooserListAdapter
    extends ResolverActivity.ResolveListAdapter
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        public static int TARGET_BAD = -1;
        public static int TARGET_CALLER = 0;
        public static int TARGET_SERVICE = 1;
        public static int TARGET_STANDARD = 2;
        private static int MAX_SERVICE_TARGETS = 8;
        private static int MAX_TARGETS_PER_SERVICE = 4;
        private List<ChooserTargetInfo> mServiceTargets;
        private List<ResolverActivity.TargetInfo> mCallerTargets;
        private boolean mShowServiceTargets;
        private float mLateFee;
        private BaseChooserTargetComparator mBaseTargetComparator;
        /* synthetic */ ChooserActivity this$0;

        private void $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$__constructor__(ChooserActivity this$0, Context context, List<Intent> payloadIntents, Intent[] initialIntents, List<ResolveInfo> rList, int launchedFromUid, boolean filterLastUsed, ResolverListController resolverListController) {
            this.mServiceTargets = new ArrayList<ChooserTargetInfo>();
            this.mCallerTargets = new ArrayList<ResolverActivity.TargetInfo>();
            this.mLateFee = 1.0f;
            this.mBaseTargetComparator = new BaseChooserTargetComparator();
            if (initialIntents != null) {
                PackageManager pm = this$0.getPackageManager();
                for (int i = 0; i < initialIntents.length; ++i) {
                    Intent ii = initialIntents[i];
                    if (ii == null) continue;
                    ResolveInfo ri = null;
                    ActivityInfo ai = null;
                    ComponentName cn = ii.getComponent();
                    if (cn != null) {
                        try {
                            ai = pm.getActivityInfo(ii.getComponent(), 0);
                            ri = new ResolveInfo();
                            ri.activityInfo = ai;
                        }
                        catch (PackageManager.NameNotFoundException nameNotFoundException) {
                            // empty catch block
                        }
                    }
                    if (ai == null) {
                        ri = pm.resolveActivity(ii, 65536);
                        ActivityInfo activityInfo = ai = ri != null ? ri.activityInfo : null;
                    }
                    if (ai == null) {
                        Log.w("ChooserActivity", "No activity found for " + ii);
                        continue;
                    }
                    UserManager userManager = (UserManager)this$0.getSystemService("user");
                    if (ii instanceof LabeledIntent) {
                        LabeledIntent li = (LabeledIntent)ii;
                        ri.resolvePackageName = li.getSourcePackage();
                        ri.labelRes = li.getLabelResource();
                        ri.nonLocalizedLabel = li.getNonLocalizedLabel();
                        ri.iconResourceId = ri.icon = li.getIconResource();
                    }
                    if (userManager.isManagedProfile()) {
                        ri.noResourceId = true;
                        ri.icon = 0;
                    }
                    this.mCallerTargets.add(new ResolverActivity.DisplayResolveInfo(this$0, ii, ri, ri.loadLabel(pm), null, ii));
                }
            }
        }

        private final boolean $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$showsExtendedInfo(ResolverActivity.TargetInfo info) {
            return false;
        }

        private final boolean $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$isComponentPinned(ComponentName name) {
            return this.this$0.mPinnedSharedPrefs.getBoolean(name.flattenToString(), false);
        }

        private final View $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$onCreateView(ViewGroup parent) {
            return this.mInflater.inflate(17367238, parent, false);
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$onListRebuilt() {
            if (this.mServiceTargets != null) {
                this.pruneServiceTargets();
            }
            this.this$0.queryTargetServices(this);
        }

        private final boolean $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$shouldGetResolvedFilter() {
            return true;
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getCount() {
            return super.getCount() + this.getServiceTargetCount() + this.getCallerTargetCount();
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getUnfilteredCount() {
            return super.getUnfilteredCount() + this.getServiceTargetCount() + this.getCallerTargetCount();
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getCallerTargetCount() {
            return this.mCallerTargets.size();
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getServiceTargetCount() {
            if (!this.mShowServiceTargets) {
                return 0;
            }
            return Math.min(this.mServiceTargets.size(), 8);
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getStandardTargetCount() {
            return super.getCount();
        }

        private final int $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getPositionTargetType(int position) {
            int offset = 0;
            int callerTargetCount = this.getCallerTargetCount();
            if (position < callerTargetCount) {
                return 0;
            }
            int serviceTargetCount = this.getServiceTargetCount();
            if (position - (offset += callerTargetCount) < serviceTargetCount) {
                return 1;
            }
            int standardTargetCount = super.getCount();
            if (position - (offset += serviceTargetCount) < standardTargetCount) {
                return 2;
            }
            return -1;
        }

        private final ResolverActivity.TargetInfo $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getItem(int position) {
            return this.targetInfoForPosition(position, true);
        }

        private final ResolverActivity.TargetInfo $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$targetInfoForPosition(int position, boolean filtered) {
            int offset = 0;
            int callerTargetCount = this.getCallerTargetCount();
            if (position < callerTargetCount) {
                return this.mCallerTargets.get(position);
            }
            int serviceTargetCount = this.getServiceTargetCount();
            if (position - (offset += callerTargetCount) < serviceTargetCount) {
                return this.mServiceTargets.get(position - offset);
            }
            return filtered ? super.getItem(position - offset) : this.getDisplayInfoAt(position - (offset += serviceTargetCount));
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$addServiceResults(ResolverActivity.DisplayResolveInfo origTarget, List<ChooserTarget> targets) {
            float parentScore = this.getScore(origTarget);
            Collections.sort(targets, this.mBaseTargetComparator);
            float lastScore = 0.0f;
            int N = Math.min(targets.size(), 4);
            for (int i = 0; i < N; ++i) {
                ChooserTarget target = targets.get(i);
                float targetScore = target.getScore();
                targetScore *= parentScore;
                targetScore *= this.mLateFee;
                if (i > 0 && targetScore >= lastScore) {
                    targetScore = lastScore * 0.95f;
                }
                this.insertServiceTarget(new ChooserTargetInfo(this.this$0, origTarget, target, targetScore));
                lastScore = targetScore;
            }
            this.mLateFee *= 0.95f;
            this.notifyDataSetChanged();
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$setShowServiceTargets(boolean show) {
            if (show != this.mShowServiceTargets) {
                this.mShowServiceTargets = show;
                this.notifyDataSetChanged();
            }
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$insertServiceTarget(ChooserTargetInfo chooserTargetInfo) {
            float newScore = chooserTargetInfo.getModifiedScore();
            int N = this.mServiceTargets.size();
            for (int i = 0; i < N; ++i) {
                ChooserTargetInfo serviceTarget = this.mServiceTargets.get(i);
                if (!(newScore > serviceTarget.getModifiedScore())) continue;
                this.mServiceTargets.add(i, chooserTargetInfo);
                return;
            }
            this.mServiceTargets.add(chooserTargetInfo);
        }

        private final void $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$pruneServiceTargets() {
            for (int i = this.mServiceTargets.size() - 1; i >= 0; --i) {
                ChooserTargetInfo cti = this.mServiceTargets.get(i);
                if (this.hasResolvedTarget(cti.getResolveInfo())) continue;
                this.mServiceTargets.remove(i);
            }
        }

        private void __constructor__(ChooserActivity chooserActivity, Context context, List<Intent> list, Intent[] intentArray, List<ResolveInfo> list2, int n, boolean bl, ResolverListController resolverListController) {
            this.$$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$__constructor__(chooserActivity, context, list, intentArray, list2, n, bl, resolverListController);
        }

        public ChooserListAdapter(ChooserActivity chooserActivity, Context context, List<Intent> list, Intent[] intentArray, List<ResolveInfo> list2, int n, boolean bl, ResolverListController resolverListController) {
            this.this$0 = chooserActivity;
            super(chooserActivity, context, list, null, list2, n, bl, resolverListController);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$__constructor__(com.android.internal.app.ChooserActivity android.content.Context java.util.List<android.content.Intent> android.content.Intent[] java.util.List<android.content.pm.ResolveInfo> int boolean com.android.internal.app.ResolverListController ), this, chooserActivity, context, list, intentArray, list2, n, bl, resolverListController);
        }

        @Override
        public boolean showsExtendedInfo(ResolverActivity.TargetInfo targetInfo) {
            return (boolean)InvokeDynamicSupport.bootstrap("showsExtendedInfo", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$showsExtendedInfo(com.android.internal.app.ResolverActivity$TargetInfo ), this, targetInfo);
        }

        @Override
        public boolean isComponentPinned(ComponentName componentName) {
            return (boolean)InvokeDynamicSupport.bootstrap("isComponentPinned", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$isComponentPinned(android.content.ComponentName ), this, componentName);
        }

        @Override
        public View onCreateView(ViewGroup viewGroup) {
            return InvokeDynamicSupport.bootstrap("onCreateView", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$onCreateView(android.view.ViewGroup ), this, viewGroup);
        }

        @Override
        public void onListRebuilt() {
            InvokeDynamicSupport.bootstrap("onListRebuilt", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$onListRebuilt(), this);
        }

        @Override
        public boolean shouldGetResolvedFilter() {
            return (boolean)InvokeDynamicSupport.bootstrap("shouldGetResolvedFilter", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$shouldGetResolvedFilter(), this);
        }

        @Override
        public int getCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getCount(), this);
        }

        @Override
        public int getUnfilteredCount() {
            return (int)InvokeDynamicSupport.bootstrap("getUnfilteredCount", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getUnfilteredCount(), this);
        }

        public int getCallerTargetCount() {
            return (int)InvokeDynamicSupport.bootstrap("getCallerTargetCount", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getCallerTargetCount(), this);
        }

        public int getServiceTargetCount() {
            return (int)InvokeDynamicSupport.bootstrap("getServiceTargetCount", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getServiceTargetCount(), this);
        }

        public int getStandardTargetCount() {
            return (int)InvokeDynamicSupport.bootstrap("getStandardTargetCount", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getStandardTargetCount(), this);
        }

        public int getPositionTargetType(int n) {
            return (int)InvokeDynamicSupport.bootstrap("getPositionTargetType", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getPositionTargetType(int ), this, n);
        }

        @Override
        public ResolverActivity.TargetInfo getItem(int n) {
            return InvokeDynamicSupport.bootstrap("getItem", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$getItem(int ), this, n);
        }

        @Override
        public ResolverActivity.TargetInfo targetInfoForPosition(int n, boolean bl) {
            return InvokeDynamicSupport.bootstrap("targetInfoForPosition", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$targetInfoForPosition(int boolean ), this, n, bl);
        }

        public void addServiceResults(ResolverActivity.DisplayResolveInfo displayResolveInfo, List<ChooserTarget> list) {
            InvokeDynamicSupport.bootstrap("addServiceResults", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$addServiceResults(com.android.internal.app.ResolverActivity$DisplayResolveInfo java.util.List<android.service.chooser.ChooserTarget> ), this, displayResolveInfo, list);
        }

        public void setShowServiceTargets(boolean bl) {
            InvokeDynamicSupport.bootstrap("setShowServiceTargets", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$setShowServiceTargets(boolean ), this, bl);
        }

        private void insertServiceTarget(ChooserTargetInfo chooserTargetInfo) {
            InvokeDynamicSupport.bootstrap("insertServiceTarget", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$insertServiceTarget(com.android.internal.app.ChooserActivity$ChooserTargetInfo ), this, chooserTargetInfo);
        }

        private void pruneServiceTargets() {
            InvokeDynamicSupport.bootstrap("pruneServiceTargets", $$robo$$com_android_internal_app_ChooserActivity_ChooserListAdapter$pruneServiceTargets(), this);
        }

        public /* synthetic */ ChooserListAdapter() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChooserListAdapter)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public final class ChooserTargetInfo
    implements ResolverActivity.TargetInfo,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private ResolverActivity.DisplayResolveInfo mSourceInfo;
        private ResolveInfo mBackupResolveInfo;
        private ChooserTarget mChooserTarget;
        private Drawable mBadgeIcon;
        private CharSequence mBadgeContentDescription;
        private Drawable mDisplayIcon;
        private Intent mFillInIntent;
        private int mFillInFlags;
        private float mModifiedScore;
        /* synthetic */ ChooserActivity this$0;

        private void $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$__constructor__(ChooserActivity this$0, ResolverActivity.DisplayResolveInfo sourceInfo, ChooserTarget chooserTarget, float modifiedScore) {
            Icon icon;
            ActivityInfo ai;
            ResolveInfo ri;
            this.mBadgeIcon = null;
            this.mSourceInfo = sourceInfo;
            this.mChooserTarget = chooserTarget;
            this.mModifiedScore = modifiedScore;
            if (sourceInfo != null && (ri = sourceInfo.getResolveInfo()) != null && (ai = ri.activityInfo) != null && ai.applicationInfo != null) {
                PackageManager pm = this$0.getPackageManager();
                this.mBadgeIcon = pm.getApplicationIcon(ai.applicationInfo);
                this.mBadgeContentDescription = pm.getApplicationLabel(ai.applicationInfo);
            }
            this.mDisplayIcon = (icon = chooserTarget.getIcon()) != null ? icon.loadDrawable(this$0) : null;
            this.mBackupResolveInfo = sourceInfo != null ? null : this$0.getPackageManager().resolveActivity(this.getResolvedIntent(), 0);
            this.mFillInIntent = null;
            this.mFillInFlags = 0;
        }

        private void $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$__constructor__(ChooserActivity this$0, ChooserTargetInfo other, Intent fillInIntent, int flags) {
            this.mBadgeIcon = null;
            this.mSourceInfo = other.mSourceInfo;
            this.mBackupResolveInfo = other.mBackupResolveInfo;
            this.mChooserTarget = other.mChooserTarget;
            this.mBadgeIcon = other.mBadgeIcon;
            this.mBadgeContentDescription = other.mBadgeContentDescription;
            this.mDisplayIcon = other.mDisplayIcon;
            this.mFillInIntent = fillInIntent;
            this.mFillInFlags = flags;
            this.mModifiedScore = other.mModifiedScore;
        }

        private final float $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getModifiedScore() {
            return this.mModifiedScore;
        }

        private final Intent $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getResolvedIntent() {
            if (this.mSourceInfo != null) {
                return this.mSourceInfo.getResolvedIntent();
            }
            Intent targetIntent = new Intent(this.this$0.getTargetIntent());
            targetIntent.setComponent(this.mChooserTarget.getComponentName());
            targetIntent.putExtras(this.mChooserTarget.getIntentExtras());
            return targetIntent;
        }

        private final ComponentName $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getResolvedComponentName() {
            if (this.mSourceInfo != null) {
                return this.mSourceInfo.getResolvedComponentName();
            }
            if (this.mBackupResolveInfo != null) {
                return new ComponentName(this.mBackupResolveInfo.activityInfo.packageName, this.mBackupResolveInfo.activityInfo.name);
            }
            return null;
        }

        private final Intent $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getBaseIntentToSend() {
            Intent result = this.getResolvedIntent();
            if (result == null) {
                Log.e("ChooserActivity", "ChooserTargetInfo: no base intent available to send");
            } else {
                result = new Intent(result);
                if (this.mFillInIntent != null) {
                    result.fillIn(this.mFillInIntent, this.mFillInFlags);
                }
                result.fillIn(this.this$0.mReferrerFillInIntent, 0);
            }
            return result;
        }

        private final boolean $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$start(Activity activity, Bundle options) {
            throw new RuntimeException("ChooserTargets should be started as caller.");
        }

        private final boolean $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$startAsCaller(Activity activity, Bundle options, int userId) {
            Intent intent = this.getBaseIntentToSend();
            if (intent == null) {
                return false;
            }
            intent.setComponent(this.mChooserTarget.getComponentName());
            intent.putExtras(this.mChooserTarget.getIntentExtras());
            boolean ignoreTargetSecurity = this.mSourceInfo != null && this.mSourceInfo.getResolvedComponentName().getPackageName().equals(this.mChooserTarget.getComponentName().getPackageName());
            activity.startActivityAsCaller(intent, options, ignoreTargetSecurity, userId);
            return true;
        }

        private final boolean $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$startAsUser(Activity activity, Bundle options, UserHandle user) {
            throw new RuntimeException("ChooserTargets should be started as caller.");
        }

        private final ResolveInfo $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getResolveInfo() {
            return this.mSourceInfo != null ? this.mSourceInfo.getResolveInfo() : this.mBackupResolveInfo;
        }

        private final CharSequence $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getDisplayLabel() {
            return this.mChooserTarget.getTitle();
        }

        private final CharSequence $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getExtendedInfo() {
            return null;
        }

        private final Drawable $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getDisplayIcon() {
            return this.mDisplayIcon;
        }

        private final Drawable $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getBadgeIcon() {
            return this.mBadgeIcon;
        }

        private final CharSequence $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getBadgeContentDescription() {
            return this.mBadgeContentDescription;
        }

        private final ResolverActivity.TargetInfo $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$cloneFilledIn(Intent fillInIntent, int flags) {
            return new ChooserTargetInfo(this.this$0, this, fillInIntent, flags);
        }

        private final List<Intent> $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getAllSourceIntents() {
            ArrayList<Intent> results = new ArrayList<Intent>();
            if (this.mSourceInfo != null) {
                results.add(this.mSourceInfo.getAllSourceIntents().get(0));
            }
            return results;
        }

        private final boolean $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$isPinned() {
            return this.mSourceInfo != null ? this.mSourceInfo.isPinned() : false;
        }

        private void __constructor__(ChooserActivity chooserActivity, ResolverActivity.DisplayResolveInfo displayResolveInfo, ChooserTarget chooserTarget, float f) {
            this.$$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$__constructor__(chooserActivity, displayResolveInfo, chooserTarget, f);
        }

        public ChooserTargetInfo(ChooserActivity chooserActivity, ResolverActivity.DisplayResolveInfo displayResolveInfo, ChooserTarget chooserTarget, float f) {
            this.this$0 = chooserActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$__constructor__(com.android.internal.app.ChooserActivity com.android.internal.app.ResolverActivity$DisplayResolveInfo android.service.chooser.ChooserTarget float ), this, chooserActivity, displayResolveInfo, chooserTarget, f);
        }

        private void __constructor__(ChooserActivity chooserActivity, ChooserTargetInfo chooserTargetInfo, Intent intent, int n) {
            this.$$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$__constructor__(chooserActivity, chooserTargetInfo, intent, n);
        }

        public ChooserTargetInfo(ChooserActivity chooserActivity, ChooserTargetInfo chooserTargetInfo, Intent intent, int n) {
            this.this$0 = chooserActivity;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$__constructor__(com.android.internal.app.ChooserActivity com.android.internal.app.ChooserActivity$ChooserTargetInfo android.content.Intent int ), this, chooserActivity, chooserTargetInfo, intent, n);
        }

        public float getModifiedScore() {
            return (float)InvokeDynamicSupport.bootstrap("getModifiedScore", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getModifiedScore(), this);
        }

        @Override
        public Intent getResolvedIntent() {
            return InvokeDynamicSupport.bootstrap("getResolvedIntent", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getResolvedIntent(), this);
        }

        @Override
        public ComponentName getResolvedComponentName() {
            return InvokeDynamicSupport.bootstrap("getResolvedComponentName", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getResolvedComponentName(), this);
        }

        private Intent getBaseIntentToSend() {
            return InvokeDynamicSupport.bootstrap("getBaseIntentToSend", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getBaseIntentToSend(), this);
        }

        @Override
        public boolean start(Activity activity, Bundle bundle) {
            return (boolean)InvokeDynamicSupport.bootstrap("start", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$start(android.app.Activity android.os.Bundle ), this, activity, bundle);
        }

        @Override
        public boolean startAsCaller(Activity activity, Bundle bundle, int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("startAsCaller", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$startAsCaller(android.app.Activity android.os.Bundle int ), this, activity, bundle, n);
        }

        @Override
        public boolean startAsUser(Activity activity, Bundle bundle, UserHandle userHandle) {
            return (boolean)InvokeDynamicSupport.bootstrap("startAsUser", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$startAsUser(android.app.Activity android.os.Bundle android.os.UserHandle ), this, activity, bundle, userHandle);
        }

        @Override
        public ResolveInfo getResolveInfo() {
            return InvokeDynamicSupport.bootstrap("getResolveInfo", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getResolveInfo(), this);
        }

        @Override
        public CharSequence getDisplayLabel() {
            return InvokeDynamicSupport.bootstrap("getDisplayLabel", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getDisplayLabel(), this);
        }

        @Override
        public CharSequence getExtendedInfo() {
            return InvokeDynamicSupport.bootstrap("getExtendedInfo", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getExtendedInfo(), this);
        }

        @Override
        public Drawable getDisplayIcon() {
            return InvokeDynamicSupport.bootstrap("getDisplayIcon", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getDisplayIcon(), this);
        }

        @Override
        public Drawable getBadgeIcon() {
            return InvokeDynamicSupport.bootstrap("getBadgeIcon", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getBadgeIcon(), this);
        }

        @Override
        public CharSequence getBadgeContentDescription() {
            return InvokeDynamicSupport.bootstrap("getBadgeContentDescription", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getBadgeContentDescription(), this);
        }

        @Override
        public ResolverActivity.TargetInfo cloneFilledIn(Intent intent, int n) {
            return InvokeDynamicSupport.bootstrap("cloneFilledIn", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$cloneFilledIn(android.content.Intent int ), this, intent, n);
        }

        @Override
        public List<Intent> getAllSourceIntents() {
            return InvokeDynamicSupport.bootstrap("getAllSourceIntents", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$getAllSourceIntents(), this);
        }

        @Override
        public boolean isPinned() {
            return (boolean)InvokeDynamicSupport.bootstrap("isPinned", $$robo$$com_android_internal_app_ChooserActivity_ChooserTargetInfo$isPinned(), this);
        }

        public /* synthetic */ ChooserTargetInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChooserTargetInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class ChooserListController
    extends ResolverListController
    implements ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        /* synthetic */ ChooserActivity this$0;

        private void $$robo$$com_android_internal_app_ChooserActivity_ChooserListController$__constructor__(ChooserActivity this$0, Context context, PackageManager pm, Intent targetIntent, String referrerPackageName, int launchedFromUid) {
        }

        private final boolean $$robo$$com_android_internal_app_ChooserActivity_ChooserListController$isComponentPinned(ComponentName name) {
            return this.this$0.mPinnedSharedPrefs.getBoolean(name.flattenToString(), false);
        }

        private final boolean $$robo$$com_android_internal_app_ChooserActivity_ChooserListController$isComponentFiltered(ComponentName name) {
            if (this.this$0.mFilteredComponentNames == null) {
                return false;
            }
            for (ComponentName filteredComponentName : this.this$0.mFilteredComponentNames) {
                if (!name.equals(filteredComponentName)) continue;
                return true;
            }
            return false;
        }

        private final float $$robo$$com_android_internal_app_ChooserActivity_ChooserListController$getScore(ResolverActivity.DisplayResolveInfo target) {
            if (target == null) {
                return 900.0f;
            }
            float score = super.getScore(target);
            if (target.isPinned()) {
                score += 1000.0f;
            }
            return score;
        }

        private void __constructor__(ChooserActivity chooserActivity, Context context, PackageManager packageManager, Intent intent, String string2, int n) {
            this.$$robo$$com_android_internal_app_ChooserActivity_ChooserListController$__constructor__(chooserActivity, context, packageManager, intent, string2, n);
        }

        public ChooserListController(ChooserActivity chooserActivity, Context context, PackageManager packageManager, Intent intent, String string2, int n) {
            this.this$0 = chooserActivity;
            super(context, packageManager, intent, string2, n);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_ChooserActivity_ChooserListController$__constructor__(com.android.internal.app.ChooserActivity android.content.Context android.content.pm.PackageManager android.content.Intent java.lang.String int ), this, chooserActivity, context, packageManager, intent, string2, n);
        }

        @Override
        boolean isComponentPinned(ComponentName componentName) {
            return (boolean)InvokeDynamicSupport.bootstrap("isComponentPinned", $$robo$$com_android_internal_app_ChooserActivity_ChooserListController$isComponentPinned(android.content.ComponentName ), this, componentName);
        }

        @Override
        boolean isComponentFiltered(ComponentName componentName) {
            return (boolean)InvokeDynamicSupport.bootstrap("isComponentFiltered", $$robo$$com_android_internal_app_ChooserActivity_ChooserListController$isComponentFiltered(android.content.ComponentName ), this, componentName);
        }

        @Override
        public float getScore(ResolverActivity.DisplayResolveInfo displayResolveInfo) {
            return (float)InvokeDynamicSupport.bootstrap("getScore", $$robo$$com_android_internal_app_ChooserActivity_ChooserListController$getScore(com.android.internal.app.ResolverActivity$DisplayResolveInfo ), this, displayResolveInfo);
        }

        public /* synthetic */ ChooserListController() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ChooserListController)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

