/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ListFragment;
import android.content.Context;
import android.os.Bundle;
import android.os.LocaleList;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.SearchView;
import com.android.internal.app.LocaleHelper;
import com.android.internal.app.LocalePicker;
import com.android.internal.app.LocaleStore;
import com.android.internal.app.SuggestedLocaleAdapter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class LocalePickerWithRegion
extends ListFragment
implements SearchView.OnQueryTextListener,
ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String PARENT_FRAGMENT_NAME = "localeListEditor";
    private SuggestedLocaleAdapter mAdapter;
    private LocaleSelectedListener mListener;
    private Set<LocaleStore.LocaleInfo> mLocaleList;
    private LocaleStore.LocaleInfo mParentLocale;
    private boolean mTranslatedOnly;
    private SearchView mSearchView;
    private CharSequence mPreviousSearch;
    private boolean mPreviousSearchHadFocus;
    private int mFirstVisiblePosition;
    private int mTopDistance;

    private void $$robo$$com_android_internal_app_LocalePickerWithRegion$__constructor__() {
        this.mTranslatedOnly = false;
        this.mSearchView = null;
        this.mPreviousSearch = null;
        this.mPreviousSearchHadFocus = false;
        this.mFirstVisiblePosition = 0;
        this.mTopDistance = 0;
    }

    private static final LocalePickerWithRegion $$robo$$com_android_internal_app_LocalePickerWithRegion$createCountryPicker(Context context, LocaleSelectedListener listener, LocaleStore.LocaleInfo parent, boolean translatedOnly) {
        LocalePickerWithRegion localePicker = new LocalePickerWithRegion();
        boolean shouldShowTheList = localePicker.setListener(context, listener, parent, translatedOnly);
        return shouldShowTheList ? localePicker : null;
    }

    private static final LocalePickerWithRegion $$robo$$com_android_internal_app_LocalePickerWithRegion$createLanguagePicker(Context context, LocaleSelectedListener listener, boolean translatedOnly) {
        LocalePickerWithRegion localePicker = new LocalePickerWithRegion();
        localePicker.setListener(context, listener, null, translatedOnly);
        return localePicker;
    }

    private final boolean $$robo$$com_android_internal_app_LocalePickerWithRegion$setListener(Context context, LocaleSelectedListener listener, LocaleStore.LocaleInfo parent, boolean translatedOnly) {
        this.mParentLocale = parent;
        this.mListener = listener;
        this.mTranslatedOnly = translatedOnly;
        this.setRetainInstance(true);
        HashSet<String> langTagsToIgnore = new HashSet<String>();
        if (!translatedOnly) {
            LocaleList userLocales = LocalePicker.getLocales();
            String[] langTags = userLocales.toLanguageTags().split(",");
            Collections.addAll(langTagsToIgnore, langTags);
        }
        if (parent != null) {
            this.mLocaleList = LocaleStore.getLevelLocales(context, langTagsToIgnore, parent, translatedOnly);
            if (this.mLocaleList.size() <= 1) {
                if (listener != null && this.mLocaleList.size() == 1) {
                    listener.onLocaleSelected(this.mLocaleList.iterator().next());
                }
                return false;
            }
        } else {
            this.mLocaleList = LocaleStore.getLevelLocales(context, langTagsToIgnore, null, translatedOnly);
        }
        return true;
    }

    private final void $$robo$$com_android_internal_app_LocalePickerWithRegion$returnToParentFrame() {
        this.getFragmentManager().popBackStack("localeListEditor", 1);
    }

    private final void $$robo$$com_android_internal_app_LocalePickerWithRegion$onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setHasOptionsMenu(true);
        if (this.mLocaleList == null) {
            this.returnToParentFrame();
            return;
        }
        boolean countryMode = this.mParentLocale != null;
        Locale sortingLocale = countryMode ? this.mParentLocale.getLocale() : Locale.getDefault();
        this.mAdapter = new SuggestedLocaleAdapter(this.mLocaleList, countryMode);
        LocaleHelper.LocaleInfoComparator comp = new LocaleHelper.LocaleInfoComparator(sortingLocale, countryMode);
        this.mAdapter.sort(comp);
        this.setListAdapter(this.mAdapter);
    }

    private final boolean $$robo$$com_android_internal_app_LocalePickerWithRegion$onOptionsItemSelected(MenuItem menuItem) {
        int id2 = menuItem.getItemId();
        switch (id2) {
            case 16908332: {
                this.getFragmentManager().popBackStack();
                return true;
            }
        }
        return super.onOptionsItemSelected(menuItem);
    }

    private final void $$robo$$com_android_internal_app_LocalePickerWithRegion$onResume() {
        super.onResume();
        if (this.mParentLocale != null) {
            this.getActivity().setTitle(this.mParentLocale.getFullNameNative());
        } else {
            this.getActivity().setTitle(17040075);
        }
        this.getListView().requestFocus();
    }

    private final void $$robo$$com_android_internal_app_LocalePickerWithRegion$onPause() {
        super.onPause();
        if (this.mSearchView != null) {
            this.mPreviousSearchHadFocus = this.mSearchView.hasFocus();
            this.mPreviousSearch = this.mSearchView.getQuery();
        } else {
            this.mPreviousSearchHadFocus = false;
            this.mPreviousSearch = null;
        }
        ListView list = this.getListView();
        View firstChild = list.getChildAt(0);
        this.mFirstVisiblePosition = list.getFirstVisiblePosition();
        this.mTopDistance = firstChild == null ? 0 : firstChild.getTop() - list.getPaddingTop();
    }

    private final void $$robo$$com_android_internal_app_LocalePickerWithRegion$onListItemClick(ListView l, View v, int position, long id2) {
        LocaleStore.LocaleInfo locale = (LocaleStore.LocaleInfo)this.getListAdapter().getItem(position);
        if (locale.getParent() != null) {
            if (this.mListener != null) {
                this.mListener.onLocaleSelected(locale);
            }
            this.returnToParentFrame();
        } else {
            LocalePickerWithRegion selector = LocalePickerWithRegion.createCountryPicker(this.getContext(), this.mListener, locale, this.mTranslatedOnly);
            if (selector != null) {
                this.getFragmentManager().beginTransaction().setTransition(4097).replace(this.getId(), selector).addToBackStack(null).commit();
            } else {
                this.returnToParentFrame();
            }
        }
    }

    private final void $$robo$$com_android_internal_app_LocalePickerWithRegion$onCreateOptionsMenu(Menu menu2, MenuInflater inflater) {
        if (this.mParentLocale == null) {
            inflater.inflate(0x1140000, menu2);
            MenuItem searchMenuItem = menu2.findItem(16909018);
            this.mSearchView = (SearchView)searchMenuItem.getActionView();
            this.mSearchView.setQueryHint(this.getText(17040736));
            this.mSearchView.setOnQueryTextListener(this);
            if (!TextUtils.isEmpty(this.mPreviousSearch)) {
                searchMenuItem.expandActionView();
                this.mSearchView.setIconified(false);
                this.mSearchView.setActivated(true);
                if (this.mPreviousSearchHadFocus) {
                    this.mSearchView.requestFocus();
                }
                this.mSearchView.setQuery(this.mPreviousSearch, true);
            } else {
                this.mSearchView.setQuery(null, false);
            }
            this.getListView().setSelectionFromTop(this.mFirstVisiblePosition, this.mTopDistance);
        }
    }

    private final boolean $$robo$$com_android_internal_app_LocalePickerWithRegion$onQueryTextSubmit(String query) {
        return false;
    }

    private final boolean $$robo$$com_android_internal_app_LocalePickerWithRegion$onQueryTextChange(String newText) {
        if (this.mAdapter != null) {
            this.mAdapter.getFilter().filter(newText);
        }
        return false;
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_app_LocalePickerWithRegion$__constructor__();
    }

    public LocalePickerWithRegion() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_app_LocalePickerWithRegion$__constructor__(), this);
    }

    private static LocalePickerWithRegion createCountryPicker(Context context, LocaleSelectedListener localeSelectedListener, LocaleStore.LocaleInfo localeInfo, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createCountryPicker", $$robo$$com_android_internal_app_LocalePickerWithRegion$createCountryPicker(android.content.Context com.android.internal.app.LocalePickerWithRegion$LocaleSelectedListener com.android.internal.app.LocaleStore$LocaleInfo boolean ), (Context)context, (LocaleSelectedListener)localeSelectedListener, (LocaleStore.LocaleInfo)localeInfo, (boolean)bl);
    }

    public static LocalePickerWithRegion createLanguagePicker(Context context, LocaleSelectedListener localeSelectedListener, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("createLanguagePicker", $$robo$$com_android_internal_app_LocalePickerWithRegion$createLanguagePicker(android.content.Context com.android.internal.app.LocalePickerWithRegion$LocaleSelectedListener boolean ), (Context)context, (LocaleSelectedListener)localeSelectedListener, (boolean)bl);
    }

    private boolean setListener(Context context, LocaleSelectedListener localeSelectedListener, LocaleStore.LocaleInfo localeInfo, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setListener", $$robo$$com_android_internal_app_LocalePickerWithRegion$setListener(android.content.Context com.android.internal.app.LocalePickerWithRegion$LocaleSelectedListener com.android.internal.app.LocaleStore$LocaleInfo boolean ), this, context, localeSelectedListener, localeInfo, bl);
    }

    private void returnToParentFrame() {
        InvokeDynamicSupport.bootstrap("returnToParentFrame", $$robo$$com_android_internal_app_LocalePickerWithRegion$returnToParentFrame(), this);
    }

    @Override
    public void onCreate(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("onCreate", $$robo$$com_android_internal_app_LocalePickerWithRegion$onCreate(android.os.Bundle ), this, bundle);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return (boolean)InvokeDynamicSupport.bootstrap("onOptionsItemSelected", $$robo$$com_android_internal_app_LocalePickerWithRegion$onOptionsItemSelected(android.view.MenuItem ), this, menuItem);
    }

    @Override
    public void onResume() {
        InvokeDynamicSupport.bootstrap("onResume", $$robo$$com_android_internal_app_LocalePickerWithRegion$onResume(), this);
    }

    @Override
    public void onPause() {
        InvokeDynamicSupport.bootstrap("onPause", $$robo$$com_android_internal_app_LocalePickerWithRegion$onPause(), this);
    }

    @Override
    public void onListItemClick(ListView listView, View view, int n, long l) {
        InvokeDynamicSupport.bootstrap("onListItemClick", $$robo$$com_android_internal_app_LocalePickerWithRegion$onListItemClick(android.widget.ListView android.view.View int long ), this, listView, view, n, l);
    }

    @Override
    public void onCreateOptionsMenu(Menu menu2, MenuInflater menuInflater) {
        InvokeDynamicSupport.bootstrap("onCreateOptionsMenu", $$robo$$com_android_internal_app_LocalePickerWithRegion$onCreateOptionsMenu(android.view.Menu android.view.MenuInflater ), this, menu2, menuInflater);
    }

    @Override
    public boolean onQueryTextSubmit(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onQueryTextSubmit", $$robo$$com_android_internal_app_LocalePickerWithRegion$onQueryTextSubmit(java.lang.String ), this, string2);
    }

    @Override
    public boolean onQueryTextChange(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("onQueryTextChange", $$robo$$com_android_internal_app_LocalePickerWithRegion$onQueryTextChange(java.lang.String ), this, string2);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LocalePickerWithRegion)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface LocaleSelectedListener
    extends InstrumentedInterface {
        public void onLocaleSelected(LocaleStore.LocaleInfo var1);
    }
}

