/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.content;

import android.content.pm.PackageParser;
import android.os.Build;
import android.os.SELinux;
import android.os.SystemProperties;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Slog;
import dalvik.system.CloseGuard;
import dalvik.system.VMRuntime;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NativeLibraryHelper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "NativeHelper";
    private static boolean DEBUG_NATIVE = false;
    public static String LIB_DIR_NAME = "lib";
    public static String LIB64_DIR_NAME = "lib64";
    public static String CLEAR_ABI_OVERRIDE = "-";
    private static int BITCODE_PRESENT = 1;
    private static boolean HAS_NATIVE_BRIDGE;

    private void $$robo$$com_android_internal_content_NativeLibraryHelper$__constructor__() {
    }

    private static final long $$robo$$com_android_internal_content_NativeLibraryHelper$nativeOpenApk(String string2) {
        return 0L;
    }

    private static final void $$robo$$com_android_internal_content_NativeLibraryHelper$nativeClose(long l) {
    }

    private static final long $$robo$$com_android_internal_content_NativeLibraryHelper$nativeSumNativeBinaries(long l, String string2, boolean bl) {
        return 0L;
    }

    private static final int $$robo$$com_android_internal_content_NativeLibraryHelper$nativeCopyNativeBinaries(long l, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        return 0;
    }

    private static final long $$robo$$com_android_internal_content_NativeLibraryHelper$sumNativeBinaries(Handle handle, String abi) {
        long sum = 0L;
        for (long apkHandle : handle.apkHandles) {
            sum += NativeLibraryHelper.nativeSumNativeBinaries(apkHandle, abi, handle.debuggable);
        }
        return sum;
    }

    private static final int $$robo$$com_android_internal_content_NativeLibraryHelper$copyNativeBinaries(Handle handle, File sharedLibraryDir, String abi) {
        for (long apkHandle : handle.apkHandles) {
            int res = NativeLibraryHelper.nativeCopyNativeBinaries(apkHandle, sharedLibraryDir.getPath(), abi, handle.extractNativeLibs, HAS_NATIVE_BRIDGE, handle.debuggable);
            if (res == 1) continue;
            return res;
        }
        return 1;
    }

    private static final int $$robo$$com_android_internal_content_NativeLibraryHelper$findSupportedAbi(Handle handle, String[] supportedAbis) {
        int finalRes = -114;
        for (long apkHandle : handle.apkHandles) {
            int res = NativeLibraryHelper.nativeFindSupportedAbi(apkHandle, supportedAbis, handle.debuggable);
            if (res == -114) continue;
            if (res == -113) {
                if (finalRes >= 0) continue;
                finalRes = -113;
                continue;
            }
            if (res >= 0) {
                if (finalRes >= 0 && res >= finalRes) continue;
                finalRes = res;
                continue;
            }
            return res;
        }
        return finalRes;
    }

    private static final int $$robo$$com_android_internal_content_NativeLibraryHelper$nativeFindSupportedAbi(long l, String[] stringArray, boolean bl) {
        return 0;
    }

    private static final void $$robo$$com_android_internal_content_NativeLibraryHelper$removeNativeBinariesLI(String nativeLibraryPath) {
        if (nativeLibraryPath == null) {
            return;
        }
        NativeLibraryHelper.removeNativeBinariesFromDirLI(new File(nativeLibraryPath), false);
    }

    private static final void $$robo$$com_android_internal_content_NativeLibraryHelper$removeNativeBinariesFromDirLI(File nativeLibraryRoot, boolean deleteRootDir) {
        if (nativeLibraryRoot.exists()) {
            File[] files = nativeLibraryRoot.listFiles();
            if (files != null) {
                for (int nn = 0; nn < files.length; ++nn) {
                    if (files[nn].isDirectory()) {
                        NativeLibraryHelper.removeNativeBinariesFromDirLI(files[nn], true);
                        continue;
                    }
                    if (files[nn].delete()) continue;
                    Slog.w("NativeHelper", "Could not delete native binary: " + files[nn].getPath());
                }
            }
            if (deleteRootDir && !nativeLibraryRoot.delete()) {
                Slog.w("NativeHelper", "Could not delete native binary directory: " + nativeLibraryRoot.getPath());
            }
        }
    }

    private static final void $$robo$$com_android_internal_content_NativeLibraryHelper$createNativeLibrarySubdir(File path) throws IOException {
        if (!path.isDirectory()) {
            path.delete();
            if (!path.mkdir()) {
                throw new IOException("Cannot create " + path.getPath());
            }
            try {
                Os.chmod(path.getPath(), OsConstants.S_IRWXU | OsConstants.S_IRGRP | OsConstants.S_IXGRP | OsConstants.S_IROTH | OsConstants.S_IXOTH);
            }
            catch (ErrnoException e) {
                throw new IOException("Cannot chmod native library directory " + path.getPath(), e);
            }
        } else if (!SELinux.restorecon(path)) {
            throw new IOException("Cannot set SELinux context for " + path.getPath());
        }
    }

    private static final long $$robo$$com_android_internal_content_NativeLibraryHelper$sumNativeBinariesForSupportedAbi(Handle handle, String[] abiList) {
        int abi = NativeLibraryHelper.findSupportedAbi(handle, abiList);
        if (abi >= 0) {
            return NativeLibraryHelper.sumNativeBinaries(handle, abiList[abi]);
        }
        return 0L;
    }

    private static final int $$robo$$com_android_internal_content_NativeLibraryHelper$copyNativeBinariesForSupportedAbi(Handle handle, File libraryRoot, String[] abiList, boolean useIsaSubdir) throws IOException {
        NativeLibraryHelper.createNativeLibrarySubdir(libraryRoot);
        int abi = NativeLibraryHelper.findSupportedAbi(handle, abiList);
        if (abi >= 0) {
            File subDir;
            String instructionSet = VMRuntime.getInstructionSet(abiList[abi]);
            if (useIsaSubdir) {
                File isaSubdir = new File(libraryRoot, instructionSet);
                NativeLibraryHelper.createNativeLibrarySubdir(isaSubdir);
                subDir = isaSubdir;
            } else {
                subDir = libraryRoot;
            }
            int copyRet = NativeLibraryHelper.copyNativeBinaries(handle, subDir, abiList[abi]);
            if (copyRet != 1) {
                return copyRet;
            }
        }
        return abi;
    }

    private static final int $$robo$$com_android_internal_content_NativeLibraryHelper$copyNativeBinariesWithOverride(Handle handle, File libraryRoot, String abiOverride) {
        try {
            if (handle.multiArch) {
                if (abiOverride != null && !"-".equals(abiOverride)) {
                    Slog.w("NativeHelper", "Ignoring abiOverride for multi arch application.");
                }
                int copyRet = -114;
                if (Build.SUPPORTED_32_BIT_ABIS.length > 0 && (copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, libraryRoot, Build.SUPPORTED_32_BIT_ABIS, true)) < 0 && copyRet != -114 && copyRet != -113) {
                    Slog.w("NativeHelper", "Failure copying 32 bit native libraries; copyRet=" + copyRet);
                    return copyRet;
                }
                if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && (copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, libraryRoot, Build.SUPPORTED_64_BIT_ABIS, true)) < 0 && copyRet != -114 && copyRet != -113) {
                    Slog.w("NativeHelper", "Failure copying 64 bit native libraries; copyRet=" + copyRet);
                    return copyRet;
                }
            } else {
                int copyRet;
                String[] abiList;
                String[] stringArray;
                String cpuAbiOverride = null;
                if ("-".equals(abiOverride)) {
                    cpuAbiOverride = null;
                } else if (abiOverride != null) {
                    cpuAbiOverride = abiOverride;
                }
                if (cpuAbiOverride != null) {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = cpuAbiOverride;
                } else {
                    stringArray = abiList = Build.SUPPORTED_ABIS;
                }
                if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && cpuAbiOverride == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                    abiList = Build.SUPPORTED_32_BIT_ABIS;
                }
                if ((copyRet = NativeLibraryHelper.copyNativeBinariesForSupportedAbi(handle, libraryRoot, abiList, true)) < 0 && copyRet != -114) {
                    Slog.w("NativeHelper", "Failure copying native libraries [errorCode=" + copyRet + "]");
                    return copyRet;
                }
            }
            return 1;
        }
        catch (IOException e) {
            Slog.e("NativeHelper", "Copying native libraries failed", e);
            return -110;
        }
    }

    private static final long $$robo$$com_android_internal_content_NativeLibraryHelper$sumNativeBinariesWithOverride(Handle handle, String abiOverride) throws IOException {
        long sum = 0L;
        if (handle.multiArch) {
            if (abiOverride != null && !"-".equals(abiOverride)) {
                Slog.w("NativeHelper", "Ignoring abiOverride for multi arch application.");
            }
            if (Build.SUPPORTED_32_BIT_ABIS.length > 0) {
                sum += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, Build.SUPPORTED_32_BIT_ABIS);
            }
            if (Build.SUPPORTED_64_BIT_ABIS.length > 0) {
                sum += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, Build.SUPPORTED_64_BIT_ABIS);
            }
        } else {
            String[] abiList;
            String[] stringArray;
            String cpuAbiOverride = null;
            if ("-".equals(abiOverride)) {
                cpuAbiOverride = null;
            } else if (abiOverride != null) {
                cpuAbiOverride = abiOverride;
            }
            if (cpuAbiOverride != null) {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = cpuAbiOverride;
            } else {
                stringArray = abiList = Build.SUPPORTED_ABIS;
            }
            if (Build.SUPPORTED_64_BIT_ABIS.length > 0 && cpuAbiOverride == null && NativeLibraryHelper.hasRenderscriptBitcode(handle)) {
                abiList = Build.SUPPORTED_32_BIT_ABIS;
            }
            sum += NativeLibraryHelper.sumNativeBinariesForSupportedAbi(handle, abiList);
        }
        return sum;
    }

    private static final int $$robo$$com_android_internal_content_NativeLibraryHelper$hasRenderscriptBitcode(long l) {
        return 0;
    }

    private static final boolean $$robo$$com_android_internal_content_NativeLibraryHelper$hasRenderscriptBitcode(Handle handle) throws IOException {
        for (long apkHandle : handle.apkHandles) {
            int res = NativeLibraryHelper.hasRenderscriptBitcode(apkHandle);
            if (res < 0) {
                throw new IOException("Error scanning APK, code: " + res);
            }
            if (res != 1) continue;
            return true;
        }
        return false;
    }

    static void __staticInitializer__() {
        HAS_NATIVE_BRIDGE = !"0".equals(SystemProperties.get("ro.dalvik.vm.native.bridge", "0"));
    }

    private void __constructor__() {
        this.$$robo$$com_android_internal_content_NativeLibraryHelper$__constructor__();
    }

    public NativeLibraryHelper() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_content_NativeLibraryHelper$__constructor__(), this);
    }

    private static long nativeOpenApk(String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeOpenApk", $$robo$$com_android_internal_content_NativeLibraryHelper$nativeOpenApk(java.lang.String ), (String)string2);
    }

    private static void nativeClose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeClose", $$robo$$com_android_internal_content_NativeLibraryHelper$nativeClose(long ), (long)l);
    }

    private static long nativeSumNativeBinaries(long l, String string2, boolean bl) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeSumNativeBinaries", $$robo$$com_android_internal_content_NativeLibraryHelper$nativeSumNativeBinaries(long java.lang.String boolean ), (long)l, (String)string2, (boolean)bl);
    }

    private static int nativeCopyNativeBinaries(long l, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeCopyNativeBinaries", $$robo$$com_android_internal_content_NativeLibraryHelper$nativeCopyNativeBinaries(long java.lang.String java.lang.String boolean boolean boolean ), (long)l, (String)string2, (String)string3, (boolean)bl, (boolean)bl2, (boolean)bl3);
    }

    private static long sumNativeBinaries(Handle handle, String string2) {
        return (long)InvokeDynamicSupport.bootstrapStatic("sumNativeBinaries", $$robo$$com_android_internal_content_NativeLibraryHelper$sumNativeBinaries(com.android.internal.content.NativeLibraryHelper$Handle java.lang.String ), (Handle)handle, (String)string2);
    }

    public static int copyNativeBinaries(Handle handle, File file, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("copyNativeBinaries", $$robo$$com_android_internal_content_NativeLibraryHelper$copyNativeBinaries(com.android.internal.content.NativeLibraryHelper$Handle java.io.File java.lang.String ), (Handle)handle, (File)file, (String)string2);
    }

    public static int findSupportedAbi(Handle handle, String[] stringArray) {
        return (int)InvokeDynamicSupport.bootstrapStatic("findSupportedAbi", $$robo$$com_android_internal_content_NativeLibraryHelper$findSupportedAbi(com.android.internal.content.NativeLibraryHelper$Handle java.lang.String[] ), (Handle)handle, (String[])stringArray);
    }

    private static int nativeFindSupportedAbi(long l, String[] stringArray, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeFindSupportedAbi", $$robo$$com_android_internal_content_NativeLibraryHelper$nativeFindSupportedAbi(long java.lang.String[] boolean ), (long)l, (String[])stringArray, (boolean)bl);
    }

    public static void removeNativeBinariesLI(String string2) {
        InvokeDynamicSupport.bootstrapStatic("removeNativeBinariesLI", $$robo$$com_android_internal_content_NativeLibraryHelper$removeNativeBinariesLI(java.lang.String ), (String)string2);
    }

    public static void removeNativeBinariesFromDirLI(File file, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("removeNativeBinariesFromDirLI", $$robo$$com_android_internal_content_NativeLibraryHelper$removeNativeBinariesFromDirLI(java.io.File boolean ), (File)file, (boolean)bl);
    }

    private static void createNativeLibrarySubdir(File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("createNativeLibrarySubdir", $$robo$$com_android_internal_content_NativeLibraryHelper$createNativeLibrarySubdir(java.io.File ), (File)file);
    }

    private static long sumNativeBinariesForSupportedAbi(Handle handle, String[] stringArray) {
        return (long)InvokeDynamicSupport.bootstrapStatic("sumNativeBinariesForSupportedAbi", $$robo$$com_android_internal_content_NativeLibraryHelper$sumNativeBinariesForSupportedAbi(com.android.internal.content.NativeLibraryHelper$Handle java.lang.String[] ), (Handle)handle, (String[])stringArray);
    }

    public static int copyNativeBinariesForSupportedAbi(Handle handle, File file, String[] stringArray, boolean bl) throws IOException {
        return (int)InvokeDynamicSupport.bootstrapStatic("copyNativeBinariesForSupportedAbi", $$robo$$com_android_internal_content_NativeLibraryHelper$copyNativeBinariesForSupportedAbi(com.android.internal.content.NativeLibraryHelper$Handle java.io.File java.lang.String[] boolean ), (Handle)handle, (File)file, (String[])stringArray, (boolean)bl);
    }

    public static int copyNativeBinariesWithOverride(Handle handle, File file, String string2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("copyNativeBinariesWithOverride", $$robo$$com_android_internal_content_NativeLibraryHelper$copyNativeBinariesWithOverride(com.android.internal.content.NativeLibraryHelper$Handle java.io.File java.lang.String ), (Handle)handle, (File)file, (String)string2);
    }

    public static long sumNativeBinariesWithOverride(Handle handle, String string2) throws IOException {
        return (long)InvokeDynamicSupport.bootstrapStatic("sumNativeBinariesWithOverride", $$robo$$com_android_internal_content_NativeLibraryHelper$sumNativeBinariesWithOverride(com.android.internal.content.NativeLibraryHelper$Handle java.lang.String ), (Handle)handle, (String)string2);
    }

    private static int hasRenderscriptBitcode(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("hasRenderscriptBitcode", $$robo$$com_android_internal_content_NativeLibraryHelper$hasRenderscriptBitcode(long ), (long)l);
    }

    public static boolean hasRenderscriptBitcode(Handle handle) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("hasRenderscriptBitcode", $$robo$$com_android_internal_content_NativeLibraryHelper$hasRenderscriptBitcode(com.android.internal.content.NativeLibraryHelper$Handle ), (Handle)handle);
    }

    static {
        RobolectricInternals.classInitializing(NativeLibraryHelper.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NativeLibraryHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class Handle
    implements Closeable,
    ShadowedObject {
        public /* synthetic */ Object __robo_data__;
        private CloseGuard mGuard;
        private volatile boolean mClosed;
        long[] apkHandles;
        boolean multiArch;
        boolean extractNativeLibs;
        boolean debuggable;

        private static final Handle $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$create(File packageFile) throws IOException {
            try {
                PackageParser.PackageLite lite = PackageParser.parsePackageLite(packageFile, 0);
                return Handle.create(lite);
            }
            catch (PackageParser.PackageParserException e) {
                throw new IOException("Failed to parse package: " + packageFile, e);
            }
        }

        private static final Handle $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$create(PackageParser.Package pkg) throws IOException {
            return Handle.create(pkg.getAllCodePaths(), (pkg.applicationInfo.flags & Integer.MIN_VALUE) != 0, (pkg.applicationInfo.flags & 0x10000000) != 0, (pkg.applicationInfo.flags & 2) != 0);
        }

        private static final Handle $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$create(PackageParser.PackageLite lite) throws IOException {
            return Handle.create(lite.getAllCodePaths(), lite.multiArch, lite.extractNativeLibs, lite.debuggable);
        }

        private static final Handle $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$create(List<String> codePaths, boolean multiArch, boolean extractNativeLibs, boolean debuggable) throws IOException {
            int size = codePaths.size();
            long[] apkHandles = new long[size];
            for (int i = 0; i < size; ++i) {
                String path = codePaths.get(i);
                apkHandles[i] = NativeLibraryHelper.nativeOpenApk(path);
                if (apkHandles[i] != 0L) continue;
                for (int j = 0; j < i; ++j) {
                    NativeLibraryHelper.nativeClose(apkHandles[j]);
                }
                throw new IOException("Unable to open APK: " + path);
            }
            return new Handle(apkHandles, multiArch, extractNativeLibs, debuggable);
        }

        private void $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$__constructor__(long[] apkHandles, boolean multiArch, boolean extractNativeLibs, boolean debuggable) {
            this.mGuard = CloseGuard.get();
            this.apkHandles = apkHandles;
            this.multiArch = multiArch;
            this.extractNativeLibs = extractNativeLibs;
            this.debuggable = debuggable;
            this.mGuard.open("close");
        }

        private final void $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$close() {
            for (long apkHandle : this.apkHandles) {
                NativeLibraryHelper.nativeClose(apkHandle);
            }
            this.mGuard.close();
            this.mClosed = true;
        }

        private final void $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$finalize() throws Throwable {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
            }
            try {
                if (!this.mClosed) {
                    this.close();
                }
            }
            finally {
                super.finalize();
            }
        }

        public static Handle create(File file) throws IOException {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$create(java.io.File ), (File)file);
        }

        public static Handle create(PackageParser.Package package_) throws IOException {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$create(android.content.pm.PackageParser$Package ), (PackageParser.Package)package_);
        }

        public static Handle create(PackageParser.PackageLite packageLite) throws IOException {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$create(android.content.pm.PackageParser$PackageLite ), (PackageParser.PackageLite)packageLite);
        }

        private static Handle create(List<String> list, boolean bl, boolean bl2, boolean bl3) throws IOException {
            return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$create(java.util.List<java.lang.String> boolean boolean boolean ), list, (boolean)bl, (boolean)bl2, (boolean)bl3);
        }

        private void __constructor__(long[] lArray, boolean bl, boolean bl2, boolean bl3) {
            this.$$robo$$com_android_internal_content_NativeLibraryHelper_Handle$__constructor__(lArray, bl, bl2, bl3);
        }

        public Handle(long[] lArray, boolean bl, boolean bl2, boolean bl3) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$__constructor__(long[] boolean boolean boolean ), this, lArray, bl, bl2, bl3);
        }

        @Override
        public void close() {
            InvokeDynamicSupport.bootstrap("close", $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$close(), this);
        }

        protected void finalize() throws Throwable {
            InvokeDynamicSupport.bootstrap("finalize", $$robo$$com_android_internal_content_NativeLibraryHelper_Handle$finalize(), this);
        }

        public /* synthetic */ Handle() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Handle)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

