/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.midi;

import android.media.midi.MidiReceiver;
import com.android.internal.midi.MidiConstants;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MidiFramer
extends MidiReceiver
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    public String TAG;
    private MidiReceiver mReceiver;
    private byte[] mBuffer;
    private int mCount;
    private byte mRunningStatus;
    private int mNeeded;
    private boolean mInSysEx;

    private void $$robo$$com_android_internal_midi_MidiFramer$__constructor__(MidiReceiver receiver) {
        this.TAG = "MidiFramer";
        this.mBuffer = new byte[3];
        this.mReceiver = receiver;
    }

    private static final String $$robo$$com_android_internal_midi_MidiFramer$formatMidiData(byte[] data, int offset, int count) {
        String text = "MIDI+" + offset + " : ";
        for (int i = 0; i < count; ++i) {
            text = text + String.format("0x%02X, ", data[offset + i]);
        }
        return text;
    }

    private final void $$robo$$com_android_internal_midi_MidiFramer$onSend(byte[] data, int offset, int count, long timestamp) throws IOException {
        int sysExStartOffset = this.mInSysEx ? offset : -1;
        for (int i = 0; i < count; ++i) {
            byte currentByte = data[offset];
            int currentInt = currentByte & 0xFF;
            if (currentInt >= 128) {
                if (currentInt < 240) {
                    this.mRunningStatus = currentByte;
                    this.mCount = 1;
                    this.mNeeded = MidiConstants.getBytesPerMessage(currentByte) - 1;
                } else if (currentInt < 248) {
                    if (currentInt == 240) {
                        this.mInSysEx = true;
                        sysExStartOffset = offset;
                    } else if (currentInt == 247) {
                        if (this.mInSysEx) {
                            this.mReceiver.send(data, sysExStartOffset, offset - sysExStartOffset + 1, timestamp);
                            this.mInSysEx = false;
                            sysExStartOffset = -1;
                        }
                    } else {
                        this.mBuffer[0] = currentByte;
                        this.mRunningStatus = 0;
                        this.mCount = 1;
                        this.mNeeded = MidiConstants.getBytesPerMessage(currentByte) - 1;
                    }
                } else {
                    if (this.mInSysEx) {
                        this.mReceiver.send(data, sysExStartOffset, offset - sysExStartOffset, timestamp);
                        sysExStartOffset = offset + 1;
                    }
                    this.mReceiver.send(data, offset, 1, timestamp);
                }
            } else if (!this.mInSysEx) {
                this.mBuffer[this.mCount++] = currentByte;
                if (--this.mNeeded == 0) {
                    if (this.mRunningStatus != 0) {
                        this.mBuffer[0] = this.mRunningStatus;
                    }
                    this.mReceiver.send(this.mBuffer, 0, this.mCount, timestamp);
                    this.mNeeded = MidiConstants.getBytesPerMessage(this.mBuffer[0]) - 1;
                    this.mCount = 1;
                }
            }
            ++offset;
        }
        if (sysExStartOffset >= 0 && sysExStartOffset < offset) {
            this.mReceiver.send(data, sysExStartOffset, offset - sysExStartOffset, timestamp);
        }
    }

    private void __constructor__(MidiReceiver midiReceiver) {
        this.$$robo$$com_android_internal_midi_MidiFramer$__constructor__(midiReceiver);
    }

    public MidiFramer(MidiReceiver midiReceiver) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_midi_MidiFramer$__constructor__(android.media.midi.MidiReceiver ), this, midiReceiver);
    }

    public static String formatMidiData(byte[] byArray, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("formatMidiData", $$robo$$com_android_internal_midi_MidiFramer$formatMidiData(byte[] int int ), (byte[])byArray, (int)n, (int)n2);
    }

    @Override
    public void onSend(byte[] byArray, int n, int n2, long l) throws IOException {
        InvokeDynamicSupport.bootstrap("onSend", $$robo$$com_android_internal_midi_MidiFramer$onSend(byte[] int int long ), this, byArray, n, n2, l);
    }

    public /* synthetic */ MidiFramer() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MidiFramer)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

