/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.hardware.SensorManager;
import android.net.ConnectivityManager;
import android.os.BatteryStats;
import android.os.Bundle;
import android.os.MemoryFile;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseLongArray;
import com.android.internal.app.IBatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.BatteryStatsImpl;
import com.android.internal.os.BluetoothPowerCalculator;
import com.android.internal.os.CameraPowerCalculator;
import com.android.internal.os.CpuPowerCalculator;
import com.android.internal.os.FlashlightPowerCalculator;
import com.android.internal.os.MemoryPowerCalculator;
import com.android.internal.os.MobileRadioPowerCalculator;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.SensorPowerCalculator;
import com.android.internal.os.WakelockPowerCalculator;
import com.android.internal.os.WifiPowerCalculator;
import com.android.internal.os.WifiPowerEstimator;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class BatteryStatsHelper
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    static boolean DEBUG = false;
    private static String TAG;
    private static BatteryStats sStatsXfer;
    private static Intent sBatteryBroadcastXfer;
    private static ArrayMap<File, BatteryStats> sFileXfer;
    private Context mContext;
    private boolean mCollectBatteryBroadcast;
    private boolean mWifiOnly;
    private IBatteryStats mBatteryInfo;
    private BatteryStats mStats;
    private Intent mBatteryBroadcast;
    private PowerProfile mPowerProfile;
    private String[] mSystemPackageArray;
    private String[] mServicepackageArray;
    private PackageManager mPackageManager;
    private List<BatterySipper> mUsageList;
    private List<BatterySipper> mWifiSippers;
    private List<BatterySipper> mBluetoothSippers;
    private SparseArray<List<BatterySipper>> mUserSippers;
    private List<BatterySipper> mMobilemsppList;
    private int mStatsType;
    long mRawRealtimeUs;
    long mRawUptimeUs;
    long mBatteryRealtimeUs;
    long mBatteryUptimeUs;
    long mTypeBatteryRealtimeUs;
    long mTypeBatteryUptimeUs;
    long mBatteryTimeRemainingUs;
    long mChargeTimeRemainingUs;
    private long mStatsPeriod;
    private double mMaxPower;
    private double mMaxRealPower;
    private double mComputedPower;
    private double mTotalPower;
    private double mMinDrainedPower;
    private double mMaxDrainedPower;
    PowerCalculator mCpuPowerCalculator;
    PowerCalculator mWakelockPowerCalculator;
    MobileRadioPowerCalculator mMobileRadioPowerCalculator;
    PowerCalculator mWifiPowerCalculator;
    PowerCalculator mBluetoothPowerCalculator;
    PowerCalculator mSensorPowerCalculator;
    PowerCalculator mCameraPowerCalculator;
    PowerCalculator mFlashlightPowerCalculator;
    PowerCalculator mMemoryPowerCalculator;
    boolean mHasWifiPowerReporting;
    boolean mHasBluetoothPowerReporting;

    private static final boolean $$robo$$com_android_internal_os_BatteryStatsHelper$checkWifiOnly(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        return !cm.isNetworkSupported(0);
    }

    private static final boolean $$robo$$com_android_internal_os_BatteryStatsHelper$checkHasWifiPowerReporting(BatteryStats stats, PowerProfile profile) {
        return stats.hasWifiActivityReporting() && profile.getAveragePower("wifi.controller.idle") != 0.0 && profile.getAveragePower("wifi.controller.rx") != 0.0 && profile.getAveragePower("wifi.controller.tx") != 0.0;
    }

    private static final boolean $$robo$$com_android_internal_os_BatteryStatsHelper$checkHasBluetoothPowerReporting(BatteryStats stats, PowerProfile profile) {
        return stats.hasBluetoothActivityReporting() && profile.getAveragePower("bluetooth.controller.idle") != 0.0 && profile.getAveragePower("bluetooth.controller.rx") != 0.0 && profile.getAveragePower("bluetooth.controller.tx") != 0.0;
    }

    private void $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(Context context) {
    }

    private void $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(Context context, boolean collectBatteryBroadcast) {
    }

    private void $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(Context context, boolean collectBatteryBroadcast, boolean wifiOnly) {
        this.mUsageList = new ArrayList<BatterySipper>();
        this.mWifiSippers = new ArrayList<BatterySipper>();
        this.mBluetoothSippers = new ArrayList<BatterySipper>();
        this.mUserSippers = new SparseArray();
        this.mMobilemsppList = new ArrayList<BatterySipper>();
        this.mStatsType = 0;
        this.mStatsPeriod = 0L;
        this.mMaxPower = 1.0;
        this.mMaxRealPower = 1.0;
        this.mHasWifiPowerReporting = false;
        this.mHasBluetoothPowerReporting = false;
        this.mContext = context;
        this.mCollectBatteryBroadcast = collectBatteryBroadcast;
        this.mWifiOnly = wifiOnly;
        this.mPackageManager = context.getPackageManager();
        Resources resources = context.getResources();
        this.mSystemPackageArray = resources.getStringArray(0x1070011);
        this.mServicepackageArray = resources.getStringArray(0x1070010);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$storeStatsHistoryInFile(String fname) {
        ArrayMap<File, BatteryStats> arrayMap = sFileXfer;
        synchronized (arrayMap) {
            File path = BatteryStatsHelper.makeFilePath(this.mContext, fname);
            sFileXfer.put(path, this.getStats());
            FileOutputStream fout = null;
            try {
                fout = new FileOutputStream(path);
                Parcel hist = Parcel.obtain();
                this.getStats().writeToParcelWithoutUids(hist, 0);
                byte[] histData = hist.marshall();
                fout.write(histData);
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to write history to file", e);
            }
            finally {
                if (fout != null) {
                    try {
                        fout.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final BatteryStats $$robo$$com_android_internal_os_BatteryStatsHelper$statsFromFile(Context context, String fname) {
        ArrayMap<File, BatteryStats> arrayMap = sFileXfer;
        synchronized (arrayMap) {
            block15: {
                BatteryStats batteryStats;
                File path = BatteryStatsHelper.makeFilePath(context, fname);
                BatteryStats stats = sFileXfer.get(path);
                if (stats != null) {
                    return stats;
                }
                FileInputStream fin = null;
                try {
                    fin = new FileInputStream(path);
                    byte[] data = BatteryStatsHelper.readFully(fin);
                    Parcel parcel = Parcel.obtain();
                    parcel.unmarshall(data, 0, data.length);
                    parcel.setDataPosition(0);
                    batteryStats = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
                }
                catch (IOException e) {
                    Log.w(TAG, "Unable to read history to file", e);
                    break block15;
                }
                return batteryStats;
                finally {
                    if (fin != null) {
                        try {
                            fin.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            return BatteryStatsHelper.getStats(IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats")));
        }
    }

    private static final void $$robo$$com_android_internal_os_BatteryStatsHelper$dropFile(Context context, String fname) {
        BatteryStatsHelper.makeFilePath(context, fname).delete();
    }

    private static final File $$robo$$com_android_internal_os_BatteryStatsHelper$makeFilePath(Context context, String fname) {
        return new File(context.getFilesDir(), fname);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$clearStats() {
        this.mStats = null;
    }

    private final BatteryStats $$robo$$com_android_internal_os_BatteryStatsHelper$getStats() {
        if (this.mStats == null) {
            this.load();
        }
        return this.mStats;
    }

    private final Intent $$robo$$com_android_internal_os_BatteryStatsHelper$getBatteryBroadcast() {
        if (this.mBatteryBroadcast == null && this.mCollectBatteryBroadcast) {
            this.load();
        }
        return this.mBatteryBroadcast;
    }

    private final PowerProfile $$robo$$com_android_internal_os_BatteryStatsHelper$getPowerProfile() {
        return this.mPowerProfile;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$create(BatteryStats stats) {
        this.mPowerProfile = new PowerProfile(this.mContext);
        this.mStats = stats;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$create(Bundle icicle) {
        if (icicle != null) {
            this.mStats = sStatsXfer;
            this.mBatteryBroadcast = sBatteryBroadcastXfer;
        }
        this.mBatteryInfo = IBatteryStats.Stub.asInterface(ServiceManager.getService("batterystats"));
        this.mPowerProfile = new PowerProfile(this.mContext);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$storeState() {
        sStatsXfer = this.mStats;
        sBatteryBroadcastXfer = this.mBatteryBroadcast;
    }

    private static final String $$robo$$com_android_internal_os_BatteryStatsHelper$makemAh(double power) {
        if (power == 0.0) {
            return "0";
        }
        String format = power < 1.0E-5 ? "%.8f" : (power < 1.0E-4 ? "%.7f" : (power < 0.001 ? "%.6f" : (power < 0.01 ? "%.5f" : (power < 0.1 ? "%.4f" : (power < 1.0 ? "%.3f" : (power < 10.0 ? "%.2f" : (power < 100.0 ? "%.1f" : "%.0f")))))));
        return String.format(Locale.ENGLISH, format, power);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int statsType, int asUser) {
        SparseArray<UserHandle> users = new SparseArray<UserHandle>(1);
        users.put(asUser, new UserHandle(asUser));
        this.refreshStats(statsType, users);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int statsType, List<UserHandle> asUsers) {
        int n = asUsers.size();
        SparseArray<UserHandle> users = new SparseArray<UserHandle>(n);
        for (int i = 0; i < n; ++i) {
            UserHandle userHandle = asUsers.get(i);
            users.put(userHandle.getIdentifier(), userHandle);
        }
        this.refreshStats(statsType, users);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int statsType, SparseArray<UserHandle> asUsers) {
        this.refreshStats(statsType, asUsers, SystemClock.elapsedRealtime() * 1000L, SystemClock.uptimeMillis() * 1000L);
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int statsType, SparseArray<UserHandle> asUsers, long rawRealtimeUs, long rawUptimeUs) {
        int i;
        this.getStats();
        this.mMaxPower = 0.0;
        this.mMaxRealPower = 0.0;
        this.mComputedPower = 0.0;
        this.mTotalPower = 0.0;
        this.mUsageList.clear();
        this.mWifiSippers.clear();
        this.mBluetoothSippers.clear();
        this.mUserSippers.clear();
        this.mMobilemsppList.clear();
        if (this.mStats == null) {
            return;
        }
        if (this.mCpuPowerCalculator == null) {
            this.mCpuPowerCalculator = new CpuPowerCalculator(this.mPowerProfile);
        }
        this.mCpuPowerCalculator.reset();
        if (this.mMemoryPowerCalculator == null) {
            this.mMemoryPowerCalculator = new MemoryPowerCalculator(this.mPowerProfile);
        }
        this.mMemoryPowerCalculator.reset();
        if (this.mWakelockPowerCalculator == null) {
            this.mWakelockPowerCalculator = new WakelockPowerCalculator(this.mPowerProfile);
        }
        this.mWakelockPowerCalculator.reset();
        if (this.mMobileRadioPowerCalculator == null) {
            this.mMobileRadioPowerCalculator = new MobileRadioPowerCalculator(this.mPowerProfile, this.mStats);
        }
        this.mMobileRadioPowerCalculator.reset(this.mStats);
        boolean hasWifiPowerReporting = BatteryStatsHelper.checkHasWifiPowerReporting(this.mStats, this.mPowerProfile);
        if (this.mWifiPowerCalculator == null || hasWifiPowerReporting != this.mHasWifiPowerReporting) {
            this.mWifiPowerCalculator = hasWifiPowerReporting ? new WifiPowerCalculator(this.mPowerProfile) : new WifiPowerEstimator(this.mPowerProfile);
            this.mHasWifiPowerReporting = hasWifiPowerReporting;
        }
        this.mWifiPowerCalculator.reset();
        boolean hasBluetoothPowerReporting = BatteryStatsHelper.checkHasBluetoothPowerReporting(this.mStats, this.mPowerProfile);
        if (this.mBluetoothPowerCalculator == null || hasBluetoothPowerReporting != this.mHasBluetoothPowerReporting) {
            this.mBluetoothPowerCalculator = new BluetoothPowerCalculator(this.mPowerProfile);
            this.mHasBluetoothPowerReporting = hasBluetoothPowerReporting;
        }
        this.mBluetoothPowerCalculator.reset();
        if (this.mSensorPowerCalculator == null) {
            this.mSensorPowerCalculator = new SensorPowerCalculator(this.mPowerProfile, (SensorManager)this.mContext.getSystemService("sensor"));
        }
        this.mSensorPowerCalculator.reset();
        if (this.mCameraPowerCalculator == null) {
            this.mCameraPowerCalculator = new CameraPowerCalculator(this.mPowerProfile);
        }
        this.mCameraPowerCalculator.reset();
        if (this.mFlashlightPowerCalculator == null) {
            this.mFlashlightPowerCalculator = new FlashlightPowerCalculator(this.mPowerProfile);
        }
        this.mFlashlightPowerCalculator.reset();
        this.mStatsType = statsType;
        this.mRawUptimeUs = rawUptimeUs;
        this.mRawRealtimeUs = rawRealtimeUs;
        this.mBatteryUptimeUs = this.mStats.getBatteryUptime(rawUptimeUs);
        this.mBatteryRealtimeUs = this.mStats.getBatteryRealtime(rawRealtimeUs);
        this.mTypeBatteryUptimeUs = this.mStats.computeBatteryUptime(rawUptimeUs, this.mStatsType);
        this.mTypeBatteryRealtimeUs = this.mStats.computeBatteryRealtime(rawRealtimeUs, this.mStatsType);
        this.mBatteryTimeRemainingUs = this.mStats.computeBatteryTimeRemaining(rawRealtimeUs);
        this.mChargeTimeRemainingUs = this.mStats.computeChargeTimeRemaining(rawRealtimeUs);
        this.mMinDrainedPower = (double)this.mStats.getLowDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.mMaxDrainedPower = (double)this.mStats.getHighDischargeAmountSinceCharge() * this.mPowerProfile.getBatteryCapacity() / 100.0;
        this.processAppUsage(asUsers);
        for (i = 0; i < this.mUsageList.size(); ++i) {
            BatterySipper bs = this.mUsageList.get(i);
            bs.computeMobilemspp();
            if (bs.mobilemspp == 0.0) continue;
            this.mMobilemsppList.add(bs);
        }
        for (i = 0; i < this.mUserSippers.size(); ++i) {
            List<BatterySipper> user = this.mUserSippers.valueAt(i);
            for (int j = 0; j < user.size(); ++j) {
                BatterySipper bs = user.get(j);
                bs.computeMobilemspp();
                if (bs.mobilemspp == 0.0) continue;
                this.mMobilemsppList.add(bs);
            }
        }
        Collections.sort(this.mMobilemsppList, new Comparator<BatterySipper>(this){
            public /* synthetic */ Object __robo_data__;
            /* synthetic */ BatteryStatsHelper this$0;

            private void $$robo$$com_android_internal_os_BatteryStatsHelper_1$__constructor__(BatteryStatsHelper this$0) {
            }

            private final int $$robo$$com_android_internal_os_BatteryStatsHelper_1$compare(BatterySipper lhs, BatterySipper rhs) {
                return Double.compare(rhs.mobilemspp, lhs.mobilemspp);
            }

            private void __constructor__(BatteryStatsHelper batteryStatsHelper) {
                this.$$robo$$com_android_internal_os_BatteryStatsHelper_1$__constructor__(batteryStatsHelper);
            }
            {
                this.this$0 = batteryStatsHelper;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsHelper_1$__constructor__(com.android.internal.os.BatteryStatsHelper ), this, batteryStatsHelper);
            }

            @Override
            public int compare(BatterySipper batterySipper, BatterySipper batterySipper2) {
                return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$com_android_internal_os_BatteryStatsHelper_1$compare(com.android.internal.os.BatterySipper com.android.internal.os.BatterySipper ), this, batterySipper, batterySipper2);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        });
        this.processMiscUsage();
        Collections.sort(this.mUsageList);
        if (!this.mUsageList.isEmpty()) {
            this.mMaxRealPower = this.mMaxPower = this.mUsageList.get((int)0).totalPowerMah;
            int usageListCount = this.mUsageList.size();
            for (int i2 = 0; i2 < usageListCount; ++i2) {
                this.mComputedPower += this.mUsageList.get((int)i2).totalPowerMah;
            }
        }
        this.mTotalPower = this.mComputedPower;
        if (this.mStats.getLowDischargeAmountSinceCharge() > 1) {
            double amount;
            if (this.mMinDrainedPower > this.mComputedPower) {
                amount = this.mMinDrainedPower - this.mComputedPower;
                this.mTotalPower = this.mMinDrainedPower;
                BatterySipper bs = new BatterySipper(BatterySipper.DrainType.UNACCOUNTED, null, amount);
                int index = Collections.binarySearch(this.mUsageList, bs);
                if (index < 0) {
                    index = -(index + 1);
                }
                this.mUsageList.add(index, bs);
                this.mMaxPower = Math.max(this.mMaxPower, amount);
            } else if (this.mMaxDrainedPower < this.mComputedPower) {
                amount = this.mComputedPower - this.mMaxDrainedPower;
                BatterySipper bs = new BatterySipper(BatterySipper.DrainType.OVERCOUNTED, null, amount);
                int index = Collections.binarySearch(this.mUsageList, bs);
                if (index < 0) {
                    index = -(index + 1);
                }
                this.mUsageList.add(index, bs);
                this.mMaxPower = Math.max(this.mMaxPower, amount);
            }
        }
        double hiddenPowerMah = this.removeHiddenBatterySippers(this.mUsageList);
        double totalRemainingPower = this.getTotalPower() - hiddenPowerMah;
        if (Math.abs(totalRemainingPower) > 0.001) {
            int size = this.mUsageList.size();
            for (int i3 = 0; i3 < size; ++i3) {
                BatterySipper sipper = this.mUsageList.get(i3);
                if (sipper.shouldHide) continue;
                sipper.proportionalSmearMah = hiddenPowerMah * ((sipper.totalPowerMah + sipper.screenPowerMah) / totalRemainingPower);
                sipper.sumPower();
            }
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$processAppUsage(SparseArray<UserHandle> asUsers) {
        boolean forAllUsers = asUsers.get(-1) != null;
        this.mStatsPeriod = this.mTypeBatteryRealtimeUs;
        BatterySipper osSipper = null;
        SparseArray<? extends BatteryStats.Uid> uidStats = this.mStats.getUidStats();
        int NU = uidStats.size();
        for (int iu = 0; iu < NU; ++iu) {
            BatteryStats.Uid u = uidStats.valueAt(iu);
            BatterySipper app = new BatterySipper(BatterySipper.DrainType.APP, u, 0.0);
            this.mCpuPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mWakelockPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mMobileRadioPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mWifiPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mBluetoothPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mSensorPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mCameraPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            this.mFlashlightPowerCalculator.calculateApp(app, u, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            double totalPower = app.sumPower();
            if (totalPower == 0.0 && u.getUid() != 0) continue;
            int uid = app.getUid();
            int userId = UserHandle.getUserId(uid);
            if (uid == 1010) {
                this.mWifiSippers.add(app);
            } else if (uid == 1002) {
                this.mBluetoothSippers.add(app);
            } else if (!forAllUsers && asUsers.get(userId) == null && UserHandle.getAppId(uid) >= 10000) {
                List<BatterySipper> list = this.mUserSippers.get(userId);
                if (list == null) {
                    list = new ArrayList<BatterySipper>();
                    this.mUserSippers.put(userId, list);
                }
                list.add(app);
            } else {
                this.mUsageList.add(app);
            }
            if (uid != 0) continue;
            osSipper = app;
        }
        if (osSipper != null) {
            this.mWakelockPowerCalculator.calculateRemaining(osSipper, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
            osSipper.sumPower();
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addPhoneUsage() {
        long phoneOnTimeMs = this.mStats.getPhoneOnTime(this.mRawRealtimeUs, this.mStatsType) / 1000L;
        double phoneOnPower = this.mPowerProfile.getAveragePower("radio.active") * (double)phoneOnTimeMs / 3600000.0;
        if (phoneOnPower != 0.0) {
            this.addEntry(BatterySipper.DrainType.PHONE, phoneOnTimeMs, phoneOnPower);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addScreenUsage() {
        double power = 0.0;
        long screenOnTimeMs = this.mStats.getScreenOnTime(this.mRawRealtimeUs, this.mStatsType) / 1000L;
        power += (double)screenOnTimeMs * this.mPowerProfile.getAveragePower("screen.on");
        double screenFullPower = this.mPowerProfile.getAveragePower("screen.full");
        for (int i = 0; i < 5; ++i) {
            double screenBinPower = screenFullPower * (double)((float)i + 0.5f) / 5.0;
            long brightnessTime = this.mStats.getScreenBrightnessTime(i, this.mRawRealtimeUs, this.mStatsType) / 1000L;
            double p = screenBinPower * (double)brightnessTime;
            power += p;
        }
        if ((power /= 3600000.0) != 0.0) {
            this.addEntry(BatterySipper.DrainType.SCREEN, screenOnTimeMs, power);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addRadioUsage() {
        BatterySipper radio = new BatterySipper(BatterySipper.DrainType.CELL, null, 0.0);
        this.mMobileRadioPowerCalculator.calculateRemaining(radio, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
        radio.sumPower();
        if (radio.totalPowerMah > 0.0) {
            this.mUsageList.add(radio);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$aggregateSippers(BatterySipper bs, List<BatterySipper> from, String tag) {
        for (int i = 0; i < from.size(); ++i) {
            BatterySipper wbs = from.get(i);
            bs.add(wbs);
        }
        bs.computeMobilemspp();
        bs.sumPower();
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addIdleUsage() {
        double idlePowerMaMs;
        double suspendPowerMaMs = (double)(this.mTypeBatteryRealtimeUs / 1000L) * this.mPowerProfile.getAveragePower("cpu.idle");
        double totalPowerMah = (suspendPowerMaMs + (idlePowerMaMs = (double)(this.mTypeBatteryUptimeUs / 1000L) * this.mPowerProfile.getAveragePower("cpu.awake"))) / 3600000.0;
        if (totalPowerMah != 0.0) {
            this.addEntry(BatterySipper.DrainType.IDLE, this.mTypeBatteryRealtimeUs / 1000L, totalPowerMah);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addWiFiUsage() {
        BatterySipper bs = new BatterySipper(BatterySipper.DrainType.WIFI, null, 0.0);
        this.mWifiPowerCalculator.calculateRemaining(bs, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
        this.aggregateSippers(bs, this.mWifiSippers, "WIFI");
        if (bs.totalPowerMah > 0.0) {
            this.mUsageList.add(bs);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addBluetoothUsage() {
        BatterySipper bs = new BatterySipper(BatterySipper.DrainType.BLUETOOTH, null, 0.0);
        this.mBluetoothPowerCalculator.calculateRemaining(bs, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
        this.aggregateSippers(bs, this.mBluetoothSippers, "Bluetooth");
        if (bs.totalPowerMah > 0.0) {
            this.mUsageList.add(bs);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addUserUsage() {
        for (int i = 0; i < this.mUserSippers.size(); ++i) {
            int userId = this.mUserSippers.keyAt(i);
            BatterySipper bs = new BatterySipper(BatterySipper.DrainType.USER, null, 0.0);
            bs.userId = userId;
            this.aggregateSippers(bs, this.mUserSippers.valueAt(i), "User");
            this.mUsageList.add(bs);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$addMemoryUsage() {
        BatterySipper memory = new BatterySipper(BatterySipper.DrainType.MEMORY, null, 0.0);
        this.mMemoryPowerCalculator.calculateRemaining(memory, this.mStats, this.mRawRealtimeUs, this.mRawUptimeUs, this.mStatsType);
        memory.sumPower();
        if (memory.totalPowerMah > 0.0) {
            this.mUsageList.add(memory);
        }
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$processMiscUsage() {
        this.addUserUsage();
        this.addPhoneUsage();
        this.addScreenUsage();
        this.addWiFiUsage();
        this.addBluetoothUsage();
        this.addMemoryUsage();
        this.addIdleUsage();
        if (!this.mWifiOnly) {
            this.addRadioUsage();
        }
    }

    private final BatterySipper $$robo$$com_android_internal_os_BatteryStatsHelper$addEntry(BatterySipper.DrainType drainType, long time, double power) {
        BatterySipper bs = new BatterySipper(drainType, null, 0.0);
        bs.usagePowerMah = power;
        bs.usageTimeMs = time;
        bs.sumPower();
        this.mUsageList.add(bs);
        return bs;
    }

    private final List<BatterySipper> $$robo$$com_android_internal_os_BatteryStatsHelper$getUsageList() {
        return this.mUsageList;
    }

    private final List<BatterySipper> $$robo$$com_android_internal_os_BatteryStatsHelper$getMobilemsppList() {
        return this.mMobilemsppList;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsHelper$getStatsPeriod() {
        return this.mStatsPeriod;
    }

    private final int $$robo$$com_android_internal_os_BatteryStatsHelper$getStatsType() {
        return this.mStatsType;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxPower() {
        return this.mMaxPower;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxRealPower() {
        return this.mMaxRealPower;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getTotalPower() {
        return this.mTotalPower;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getComputedPower() {
        return this.mComputedPower;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getMinDrainedPower() {
        return this.mMinDrainedPower;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxDrainedPower() {
        return this.mMaxDrainedPower;
    }

    private static final byte[] $$robo$$com_android_internal_os_BatteryStatsHelper$readFully(FileInputStream stream) throws IOException {
        return BatteryStatsHelper.readFully(stream, stream.available());
    }

    private static final byte[] $$robo$$com_android_internal_os_BatteryStatsHelper$readFully(FileInputStream stream, int avail) throws IOException {
        int pos = 0;
        byte[] data = new byte[avail];
        int amt;
        while ((amt = stream.read(data, pos, data.length - pos)) > 0) {
            avail = stream.available();
            if (avail <= data.length - (pos += amt)) continue;
            byte[] newData = new byte[pos + avail];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])data, (int)0, (byte[])newData, (int)0, (int)pos);
            data = newData;
        }
        return data;
    }

    private final double $$robo$$com_android_internal_os_BatteryStatsHelper$removeHiddenBatterySippers(List<BatterySipper> sippers) {
        double proportionalSmearPowerMah = 0.0;
        BatterySipper screenSipper = null;
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper sipper = sippers.get(i);
            sipper.shouldHide = this.shouldHideSipper(sipper);
            if (sipper.shouldHide && sipper.drainType != BatterySipper.DrainType.OVERCOUNTED && sipper.drainType != BatterySipper.DrainType.SCREEN && sipper.drainType != BatterySipper.DrainType.UNACCOUNTED) {
                proportionalSmearPowerMah += sipper.totalPowerMah;
            }
            if (sipper.drainType != BatterySipper.DrainType.SCREEN) continue;
            screenSipper = sipper;
        }
        this.smearScreenBatterySipper(sippers, screenSipper);
        return proportionalSmearPowerMah;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$smearScreenBatterySipper(List<BatterySipper> sippers, BatterySipper screenSipper) {
        long rawRealtimeMs = SystemClock.elapsedRealtime();
        long totalActivityTimeMs = 0L;
        SparseLongArray activityTimeArray = new SparseLongArray();
        int size = sippers.size();
        for (int i = 0; i < size; ++i) {
            BatteryStats.Uid uid = sippers.get((int)i).uidObj;
            if (uid == null) continue;
            long timeMs = this.getForegroundActivityTotalTimeMs(uid, rawRealtimeMs);
            activityTimeArray.put(uid.getUid(), timeMs);
            totalActivityTimeMs += timeMs;
        }
        if (totalActivityTimeMs >= 600000L) {
            double screenPowerMah = screenSipper.totalPowerMah;
            int size2 = sippers.size();
            for (int i = 0; i < size2; ++i) {
                BatterySipper sipper = sippers.get(i);
                sipper.screenPowerMah = screenPowerMah * (double)activityTimeArray.get(sipper.getUid(), 0L) / (double)totalActivityTimeMs;
            }
        }
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsHelper$shouldHideSipper(BatterySipper sipper) {
        BatterySipper.DrainType drainType = sipper.drainType;
        return drainType == BatterySipper.DrainType.IDLE || drainType == BatterySipper.DrainType.CELL || drainType == BatterySipper.DrainType.SCREEN || drainType == BatterySipper.DrainType.UNACCOUNTED || drainType == BatterySipper.DrainType.OVERCOUNTED || this.isTypeService(sipper) || this.isTypeSystem(sipper);
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsHelper$isTypeService(BatterySipper sipper) {
        String[] packages = this.mPackageManager.getPackagesForUid(sipper.getUid());
        if (packages == null) {
            return false;
        }
        for (String packageName : packages) {
            if (!ArrayUtils.contains(this.mServicepackageArray, packageName)) continue;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$com_android_internal_os_BatteryStatsHelper$isTypeSystem(BatterySipper sipper) {
        int uid = sipper.uidObj == null ? -1 : sipper.getUid();
        sipper.mPackages = this.mPackageManager.getPackagesForUid(uid);
        if (uid >= 0 && uid < 10000) {
            return true;
        }
        if (sipper.mPackages != null) {
            for (String packageName : sipper.mPackages) {
                if (!ArrayUtils.contains(this.mSystemPackageArray, packageName)) continue;
                return true;
            }
        }
        return false;
    }

    private final long $$robo$$com_android_internal_os_BatteryStatsHelper$getForegroundActivityTotalTimeMs(BatteryStats.Uid uid, long rawRealtimeMs) {
        BatteryStats.Timer timer = uid.getForegroundActivityTimer();
        if (timer != null) {
            return timer.getTotalTimeLocked(rawRealtimeMs, 0);
        }
        return 0L;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$setPackageManager(PackageManager packageManager) {
        this.mPackageManager = packageManager;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$setSystemPackageArray(String[] array2) {
        this.mSystemPackageArray = array2;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$setServicePackageArray(String[] array2) {
        this.mServicepackageArray = array2;
    }

    private final void $$robo$$com_android_internal_os_BatteryStatsHelper$load() {
        if (this.mBatteryInfo == null) {
            return;
        }
        this.mStats = BatteryStatsHelper.getStats(this.mBatteryInfo);
        if (this.mCollectBatteryBroadcast) {
            this.mBatteryBroadcast = this.mContext.registerReceiver(null, new IntentFilter("android.intent.action.BATTERY_CHANGED"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final BatteryStatsImpl $$robo$$com_android_internal_os_BatteryStatsHelper$getStats(IBatteryStats service) {
        try {
            ParcelFileDescriptor pfd = service.getStatisticsStream();
            if (pfd == null) return new BatteryStatsImpl();
            try (ParcelFileDescriptor.AutoCloseInputStream fis = new ParcelFileDescriptor.AutoCloseInputStream(pfd);){
                BatteryStatsImpl stats;
                byte[] data = BatteryStatsHelper.readFully(fis, MemoryFile.getSize(pfd.getFileDescriptor()));
                Parcel parcel = Parcel.obtain();
                parcel.unmarshall(data, 0, data.length);
                parcel.setDataPosition(0);
                BatteryStatsImpl batteryStatsImpl = stats = BatteryStatsImpl.CREATOR.createFromParcel(parcel);
                return batteryStatsImpl;
            }
            catch (IOException e) {
                Log.w(TAG, "Unable to read statistics stream", e);
                return new BatteryStatsImpl();
            }
        }
        catch (RemoteException e) {
            Log.w(TAG, "RemoteException:", e);
        }
        return new BatteryStatsImpl();
    }

    static void __staticInitializer__() {
        TAG = BatteryStatsHelper.class.getSimpleName();
        sFileXfer = new ArrayMap();
    }

    public static boolean checkWifiOnly(Context context) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkWifiOnly", $$robo$$com_android_internal_os_BatteryStatsHelper$checkWifiOnly(android.content.Context ), (Context)context);
    }

    public static boolean checkHasWifiPowerReporting(BatteryStats batteryStats, PowerProfile powerProfile) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkHasWifiPowerReporting", $$robo$$com_android_internal_os_BatteryStatsHelper$checkHasWifiPowerReporting(android.os.BatteryStats com.android.internal.os.PowerProfile ), (BatteryStats)batteryStats, (PowerProfile)powerProfile);
    }

    public static boolean checkHasBluetoothPowerReporting(BatteryStats batteryStats, PowerProfile powerProfile) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("checkHasBluetoothPowerReporting", $$robo$$com_android_internal_os_BatteryStatsHelper$checkHasBluetoothPowerReporting(android.os.BatteryStats com.android.internal.os.PowerProfile ), (BatteryStats)batteryStats, (PowerProfile)powerProfile);
    }

    private void __constructor__(Context context) {
        this.$$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(context);
    }

    public BatteryStatsHelper(Context context) {
        this(context, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(android.content.Context ), this, context);
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(context, bl);
    }

    public BatteryStatsHelper(Context context, boolean bl) {
        this(context, bl, BatteryStatsHelper.checkWifiOnly(context));
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(android.content.Context boolean ), this, context, bl);
    }

    private void __constructor__(Context context, boolean bl, boolean bl2) {
        this.$$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(context, bl, bl2);
    }

    public BatteryStatsHelper(Context context, boolean bl, boolean bl2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_BatteryStatsHelper$__constructor__(android.content.Context boolean boolean ), this, context, bl, bl2);
    }

    public void storeStatsHistoryInFile(String string2) {
        InvokeDynamicSupport.bootstrap("storeStatsHistoryInFile", $$robo$$com_android_internal_os_BatteryStatsHelper$storeStatsHistoryInFile(java.lang.String ), this, string2);
    }

    public static BatteryStats statsFromFile(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("statsFromFile", $$robo$$com_android_internal_os_BatteryStatsHelper$statsFromFile(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    public static void dropFile(Context context, String string2) {
        InvokeDynamicSupport.bootstrapStatic("dropFile", $$robo$$com_android_internal_os_BatteryStatsHelper$dropFile(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    private static File makeFilePath(Context context, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("makeFilePath", $$robo$$com_android_internal_os_BatteryStatsHelper$makeFilePath(android.content.Context java.lang.String ), (Context)context, (String)string2);
    }

    public void clearStats() {
        InvokeDynamicSupport.bootstrap("clearStats", $$robo$$com_android_internal_os_BatteryStatsHelper$clearStats(), this);
    }

    public BatteryStats getStats() {
        return InvokeDynamicSupport.bootstrap("getStats", $$robo$$com_android_internal_os_BatteryStatsHelper$getStats(), this);
    }

    public Intent getBatteryBroadcast() {
        return InvokeDynamicSupport.bootstrap("getBatteryBroadcast", $$robo$$com_android_internal_os_BatteryStatsHelper$getBatteryBroadcast(), this);
    }

    public PowerProfile getPowerProfile() {
        return InvokeDynamicSupport.bootstrap("getPowerProfile", $$robo$$com_android_internal_os_BatteryStatsHelper$getPowerProfile(), this);
    }

    public void create(BatteryStats batteryStats) {
        InvokeDynamicSupport.bootstrap("create", $$robo$$com_android_internal_os_BatteryStatsHelper$create(android.os.BatteryStats ), this, batteryStats);
    }

    public void create(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("create", $$robo$$com_android_internal_os_BatteryStatsHelper$create(android.os.Bundle ), this, bundle);
    }

    public void storeState() {
        InvokeDynamicSupport.bootstrap("storeState", $$robo$$com_android_internal_os_BatteryStatsHelper$storeState(), this);
    }

    public static String makemAh(double d) {
        return InvokeDynamicSupport.bootstrapStatic("makemAh", $$robo$$com_android_internal_os_BatteryStatsHelper$makemAh(double ), (double)d);
    }

    public void refreshStats(int n, int n2) {
        InvokeDynamicSupport.bootstrap("refreshStats", $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int int ), this, n, n2);
    }

    public void refreshStats(int n, List<UserHandle> list) {
        InvokeDynamicSupport.bootstrap("refreshStats", $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int java.util.List<android.os.UserHandle> ), this, n, list);
    }

    public void refreshStats(int n, SparseArray<UserHandle> sparseArray) {
        InvokeDynamicSupport.bootstrap("refreshStats", $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int android.util.SparseArray<android.os.UserHandle> ), this, n, sparseArray);
    }

    public void refreshStats(int n, SparseArray<UserHandle> sparseArray, long l, long l2) {
        InvokeDynamicSupport.bootstrap("refreshStats", $$robo$$com_android_internal_os_BatteryStatsHelper$refreshStats(int android.util.SparseArray<android.os.UserHandle> long long ), this, n, sparseArray, l, l2);
    }

    private void processAppUsage(SparseArray<UserHandle> sparseArray) {
        InvokeDynamicSupport.bootstrap("processAppUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$processAppUsage(android.util.SparseArray<android.os.UserHandle> ), this, sparseArray);
    }

    private void addPhoneUsage() {
        InvokeDynamicSupport.bootstrap("addPhoneUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addPhoneUsage(), this);
    }

    private void addScreenUsage() {
        InvokeDynamicSupport.bootstrap("addScreenUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addScreenUsage(), this);
    }

    private void addRadioUsage() {
        InvokeDynamicSupport.bootstrap("addRadioUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addRadioUsage(), this);
    }

    private void aggregateSippers(BatterySipper batterySipper, List<BatterySipper> list, String string2) {
        InvokeDynamicSupport.bootstrap("aggregateSippers", $$robo$$com_android_internal_os_BatteryStatsHelper$aggregateSippers(com.android.internal.os.BatterySipper java.util.List<com.android.internal.os.BatterySipper> java.lang.String ), this, batterySipper, list, string2);
    }

    private void addIdleUsage() {
        InvokeDynamicSupport.bootstrap("addIdleUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addIdleUsage(), this);
    }

    private void addWiFiUsage() {
        InvokeDynamicSupport.bootstrap("addWiFiUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addWiFiUsage(), this);
    }

    private void addBluetoothUsage() {
        InvokeDynamicSupport.bootstrap("addBluetoothUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addBluetoothUsage(), this);
    }

    private void addUserUsage() {
        InvokeDynamicSupport.bootstrap("addUserUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addUserUsage(), this);
    }

    private void addMemoryUsage() {
        InvokeDynamicSupport.bootstrap("addMemoryUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$addMemoryUsage(), this);
    }

    private void processMiscUsage() {
        InvokeDynamicSupport.bootstrap("processMiscUsage", $$robo$$com_android_internal_os_BatteryStatsHelper$processMiscUsage(), this);
    }

    private BatterySipper addEntry(BatterySipper.DrainType drainType, long l, double d) {
        return InvokeDynamicSupport.bootstrap("addEntry", $$robo$$com_android_internal_os_BatteryStatsHelper$addEntry(com.android.internal.os.BatterySipper$DrainType long double ), this, drainType, l, d);
    }

    public List<BatterySipper> getUsageList() {
        return InvokeDynamicSupport.bootstrap("getUsageList", $$robo$$com_android_internal_os_BatteryStatsHelper$getUsageList(), this);
    }

    public List<BatterySipper> getMobilemsppList() {
        return InvokeDynamicSupport.bootstrap("getMobilemsppList", $$robo$$com_android_internal_os_BatteryStatsHelper$getMobilemsppList(), this);
    }

    public long getStatsPeriod() {
        return (long)InvokeDynamicSupport.bootstrap("getStatsPeriod", $$robo$$com_android_internal_os_BatteryStatsHelper$getStatsPeriod(), this);
    }

    public int getStatsType() {
        return (int)InvokeDynamicSupport.bootstrap("getStatsType", $$robo$$com_android_internal_os_BatteryStatsHelper$getStatsType(), this);
    }

    public double getMaxPower() {
        return (double)InvokeDynamicSupport.bootstrap("getMaxPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxPower(), this);
    }

    public double getMaxRealPower() {
        return (double)InvokeDynamicSupport.bootstrap("getMaxRealPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxRealPower(), this);
    }

    public double getTotalPower() {
        return (double)InvokeDynamicSupport.bootstrap("getTotalPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getTotalPower(), this);
    }

    public double getComputedPower() {
        return (double)InvokeDynamicSupport.bootstrap("getComputedPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getComputedPower(), this);
    }

    public double getMinDrainedPower() {
        return (double)InvokeDynamicSupport.bootstrap("getMinDrainedPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getMinDrainedPower(), this);
    }

    public double getMaxDrainedPower() {
        return (double)InvokeDynamicSupport.bootstrap("getMaxDrainedPower", $$robo$$com_android_internal_os_BatteryStatsHelper$getMaxDrainedPower(), this);
    }

    public static byte[] readFully(FileInputStream fileInputStream) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$com_android_internal_os_BatteryStatsHelper$readFully(java.io.FileInputStream ), (FileInputStream)fileInputStream);
    }

    public static byte[] readFully(FileInputStream fileInputStream, int n) throws IOException {
        return InvokeDynamicSupport.bootstrapStatic("readFully", $$robo$$com_android_internal_os_BatteryStatsHelper$readFully(java.io.FileInputStream int ), (FileInputStream)fileInputStream, (int)n);
    }

    public double removeHiddenBatterySippers(List<BatterySipper> list) {
        return (double)InvokeDynamicSupport.bootstrap("removeHiddenBatterySippers", $$robo$$com_android_internal_os_BatteryStatsHelper$removeHiddenBatterySippers(java.util.List<com.android.internal.os.BatterySipper> ), this, list);
    }

    public void smearScreenBatterySipper(List<BatterySipper> list, BatterySipper batterySipper) {
        InvokeDynamicSupport.bootstrap("smearScreenBatterySipper", $$robo$$com_android_internal_os_BatteryStatsHelper$smearScreenBatterySipper(java.util.List<com.android.internal.os.BatterySipper> com.android.internal.os.BatterySipper ), this, list, batterySipper);
    }

    public boolean shouldHideSipper(BatterySipper batterySipper) {
        return (boolean)InvokeDynamicSupport.bootstrap("shouldHideSipper", $$robo$$com_android_internal_os_BatteryStatsHelper$shouldHideSipper(com.android.internal.os.BatterySipper ), this, batterySipper);
    }

    public boolean isTypeService(BatterySipper batterySipper) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTypeService", $$robo$$com_android_internal_os_BatteryStatsHelper$isTypeService(com.android.internal.os.BatterySipper ), this, batterySipper);
    }

    public boolean isTypeSystem(BatterySipper batterySipper) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTypeSystem", $$robo$$com_android_internal_os_BatteryStatsHelper$isTypeSystem(com.android.internal.os.BatterySipper ), this, batterySipper);
    }

    public long getForegroundActivityTotalTimeMs(BatteryStats.Uid uid, long l) {
        return (long)InvokeDynamicSupport.bootstrap("getForegroundActivityTotalTimeMs", $$robo$$com_android_internal_os_BatteryStatsHelper$getForegroundActivityTotalTimeMs(android.os.BatteryStats$Uid long ), this, uid, l);
    }

    public void setPackageManager(PackageManager packageManager) {
        InvokeDynamicSupport.bootstrap("setPackageManager", $$robo$$com_android_internal_os_BatteryStatsHelper$setPackageManager(android.content.pm.PackageManager ), this, packageManager);
    }

    public void setSystemPackageArray(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setSystemPackageArray", $$robo$$com_android_internal_os_BatteryStatsHelper$setSystemPackageArray(java.lang.String[] ), this, stringArray);
    }

    public void setServicePackageArray(String[] stringArray) {
        InvokeDynamicSupport.bootstrap("setServicePackageArray", $$robo$$com_android_internal_os_BatteryStatsHelper$setServicePackageArray(java.lang.String[] ), this, stringArray);
    }

    private void load() {
        InvokeDynamicSupport.bootstrap("load", $$robo$$com_android_internal_os_BatteryStatsHelper$load(), this);
    }

    private static BatteryStatsImpl getStats(IBatteryStats iBatteryStats) {
        return InvokeDynamicSupport.bootstrapStatic("getStats", $$robo$$com_android_internal_os_BatteryStatsHelper$getStats(com.android.internal.app.IBatteryStats ), (IBatteryStats)iBatteryStats);
    }

    static {
        RobolectricInternals.classInitializing(BatteryStatsHelper.class);
    }

    public /* synthetic */ BatteryStatsHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BatteryStatsHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

