/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MobileRadioPowerCalculator
extends PowerCalculator
implements ShadowedObject {
    public /* synthetic */ Object __robo_data__;
    private static String TAG = "MobileRadioPowerController";
    private static boolean DEBUG = false;
    private double mPowerRadioOn;
    private double[] mPowerBins;
    private double mPowerScan;
    private BatteryStats mStats;
    private long mTotalAppMobileActiveMs;

    private final double $$robo$$com_android_internal_os_MobileRadioPowerCalculator$getMobilePowerPerPacket(long rawRealtimeUs, int statsType) {
        long MOBILE_BPS = 200000L;
        double MOBILE_POWER = this.mPowerRadioOn / 3600.0;
        long mobileRx = this.mStats.getNetworkActivityPackets(0, statsType);
        long mobileTx = this.mStats.getNetworkActivityPackets(1, statsType);
        long mobileData = mobileRx + mobileTx;
        long radioDataUptimeMs = this.mStats.getMobileRadioActiveTime(rawRealtimeUs, statsType) / 1000L;
        double mobilePps = mobileData != 0L && radioDataUptimeMs != 0L ? (double)mobileData / (double)radioDataUptimeMs : 12.20703125;
        return MOBILE_POWER / mobilePps / 3600.0;
    }

    private void $$robo$$com_android_internal_os_MobileRadioPowerCalculator$__constructor__(PowerProfile profile, BatteryStats stats) {
        this.mPowerBins = new double[5];
        this.mTotalAppMobileActiveMs = 0L;
        this.mPowerRadioOn = profile.getAveragePower("radio.active");
        for (int i = 0; i < this.mPowerBins.length; ++i) {
            this.mPowerBins[i] = profile.getAveragePower("radio.on", i);
        }
        this.mPowerScan = profile.getAveragePower("radio.scanning");
        this.mStats = stats;
    }

    private final void $$robo$$com_android_internal_os_MobileRadioPowerCalculator$calculateApp(BatterySipper app, BatteryStats.Uid u, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        app.mobileRxPackets = u.getNetworkActivityPackets(0, statsType);
        app.mobileTxPackets = u.getNetworkActivityPackets(1, statsType);
        app.mobileActive = u.getMobileRadioActiveTime(statsType) / 1000L;
        app.mobileActiveCount = u.getMobileRadioActiveCount(statsType);
        app.mobileRxBytes = u.getNetworkActivityBytes(0, statsType);
        app.mobileTxBytes = u.getNetworkActivityBytes(1, statsType);
        if (app.mobileActive > 0L) {
            this.mTotalAppMobileActiveMs += app.mobileActive;
            app.mobileRadioPowerMah = (double)app.mobileActive * this.mPowerRadioOn / 3600000.0;
        } else {
            app.mobileRadioPowerMah = (double)(app.mobileRxPackets + app.mobileTxPackets) * this.getMobilePowerPerPacket(rawRealtimeUs, statsType);
        }
    }

    private final void $$robo$$com_android_internal_os_MobileRadioPowerCalculator$calculateRemaining(BatterySipper app, BatteryStats stats, long rawRealtimeUs, long rawUptimeUs, int statsType) {
        double power = 0.0;
        long signalTimeMs = 0L;
        long noCoverageTimeMs = 0L;
        for (int i = 0; i < this.mPowerBins.length; ++i) {
            long strengthTimeMs = stats.getPhoneSignalStrengthTime(i, rawRealtimeUs, statsType) / 1000L;
            double p = (double)strengthTimeMs * this.mPowerBins[i] / 3600000.0;
            power += p;
            signalTimeMs += strengthTimeMs;
            if (i != 0) continue;
            noCoverageTimeMs = strengthTimeMs;
        }
        long scanningTimeMs = stats.getPhoneSignalScanningTime(rawRealtimeUs, statsType) / 1000L;
        double p = (double)scanningTimeMs * this.mPowerScan / 3600000.0;
        power += p;
        long radioActiveTimeMs = this.mStats.getMobileRadioActiveTime(rawRealtimeUs, statsType) / 1000L;
        long remainingActiveTimeMs = radioActiveTimeMs - this.mTotalAppMobileActiveMs;
        if (remainingActiveTimeMs > 0L) {
            power += this.mPowerRadioOn * (double)remainingActiveTimeMs / 3600000.0;
        }
        if (power != 0.0) {
            if (signalTimeMs != 0L) {
                app.noCoveragePercent = (double)noCoverageTimeMs * 100.0 / (double)signalTimeMs;
            }
            app.mobileActive = remainingActiveTimeMs;
            app.mobileActiveCount = stats.getMobileRadioActiveUnknownCount(statsType);
            app.mobileRadioPowerMah = power;
        }
    }

    private final void $$robo$$com_android_internal_os_MobileRadioPowerCalculator$reset() {
        this.mTotalAppMobileActiveMs = 0L;
    }

    private final void $$robo$$com_android_internal_os_MobileRadioPowerCalculator$reset(BatteryStats stats) {
        this.reset();
        this.mStats = stats;
    }

    private double getMobilePowerPerPacket(long l, int n) {
        return (double)InvokeDynamicSupport.bootstrap("getMobilePowerPerPacket", $$robo$$com_android_internal_os_MobileRadioPowerCalculator$getMobilePowerPerPacket(long int ), this, l, n);
    }

    private void __constructor__(PowerProfile powerProfile, BatteryStats batteryStats) {
        this.$$robo$$com_android_internal_os_MobileRadioPowerCalculator$__constructor__(powerProfile, batteryStats);
    }

    public MobileRadioPowerCalculator(PowerProfile powerProfile, BatteryStats batteryStats) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$com_android_internal_os_MobileRadioPowerCalculator$__constructor__(com.android.internal.os.PowerProfile android.os.BatteryStats ), this, powerProfile, batteryStats);
    }

    @Override
    public void calculateApp(BatterySipper batterySipper, BatteryStats.Uid uid, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateApp", $$robo$$com_android_internal_os_MobileRadioPowerCalculator$calculateApp(com.android.internal.os.BatterySipper android.os.BatteryStats$Uid long long int ), this, batterySipper, uid, l, l2, n);
    }

    @Override
    public void calculateRemaining(BatterySipper batterySipper, BatteryStats batteryStats, long l, long l2, int n) {
        InvokeDynamicSupport.bootstrap("calculateRemaining", $$robo$$com_android_internal_os_MobileRadioPowerCalculator$calculateRemaining(com.android.internal.os.BatterySipper android.os.BatteryStats long long int ), this, batterySipper, batteryStats, l, l2, n);
    }

    @Override
    public void reset() {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_MobileRadioPowerCalculator$reset(), this);
    }

    public void reset(BatteryStats batteryStats) {
        InvokeDynamicSupport.bootstrap("reset", $$robo$$com_android_internal_os_MobileRadioPowerCalculator$reset(android.os.BatteryStats ), this, batteryStats);
    }

    public /* synthetic */ MobileRadioPowerCalculator() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MobileRadioPowerCalculator)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

